///////////////////////////////////////////////////////////
//  clCMATHDImageFileUpdateStatus.h
//  Implementation of the Class clCMATHDImageFileUpdateStatus
//  Created on:      07-Jul-2015 5:29:11 PM
///////////////////////////////////////////////////////////

#if !defined(EA_BFE790E7_47A6_4343_BA6B_231069196B41__INCLUDED_)
#define EA_BFE790E7_47A6_4343_BA6B_231069196B41__INCLUDED_

#include "clADRMsgPayload.h"
#include "types/clCMEnumTypes.h"

class clCMATHDImageFileUpdateStatus : public clADRMsgPayload
{

public:
	/**
	 * Unsigned long word 0..0xffffffff
	 */
	unsigned int HDStationId;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char RFU_StatusByte0;
	unsigned char RFU_StatusByte1;
	/**
	 * Enumeration 0..1
	 * 0 Station Logo (MPS) or Service Logo (SPS 1..7)
	 * 1 Primary Image
	 */
	clCMEnum_HDImageType HDImageType;
	/**
	 * Enumeration 0..1
	 * 0 Image is coded in jpg format
	 * 1 Image is coded in png format
	 */
	clCMEnum_HDImageCoding HDImageCoding;
	/**
	 * Unsigned byte 0..0xff
	 */

	unsigned char ReservedByte_0;
	unsigned char ReservedByte_1;
	unsigned char ReservedByte_2;
	unsigned char ReservedByte_3;
	/**
	 * Enumeration 0..7
	 * 0 Audio program 1 (MPS)
	 * 1..7 Audio program 2 .. 8 (SPS)
	 */
	clCMEnum_HDAudioService HDAudioService;
	/**
	 * Unsigned long word 0..0xffffffff
	 */
	unsigned int HDApplicationMimeType;
	/**
	 * Unsigned word
	 */
	unsigned short LOTID;

	unsigned char Minute;
	unsigned char Hour;
	unsigned char Day;
	unsigned char Month;
	unsigned short Year;

	/**
	 * Unsigned long word
	 */
	unsigned int NumberOfImageFileBytes;
	/**
	 * Stream byte 0, byte 1, .. byte n
	 */
	tunerVector<unsigned char> ImageFileBytes;

	clCMATHDImageFileUpdateStatus();
	virtual ~clCMATHDImageFileUpdateStatus();
	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * Read ATHDImageFileUpdateStatus parameters
	 */
	unsigned int getHDStationId();
	clCMEnum_HDImageType::enHDImageType getHDImageType();
	clCMEnum_HDImageCoding::enHDImageCoding getHDImageCoding();
	clCMEnum_HDAudioService::enHDAudioService getHDAudioService();
	unsigned int getHDApplicationMimeType();
	unsigned short getLOTID();
	unsigned int getNumberOfImageFileBytes();
	tunerVector<unsigned char> getImageFileBytes();
	unsigned char u8GetMinute();
	unsigned char u8GetHour();
	unsigned char u8GetDay();
	unsigned char u8GetMonth();
	unsigned short u8GetYear();
	void SetLOTDiscardTime(unsigned int DiscardTime);
	
	/*  Copy constructor  */ 
		
	clCMATHDImageFileUpdateStatus(const clCMATHDImageFileUpdateStatus &ImageFileUpdate): clADRMsgPayload (ImageFileUpdate)
	{
				this->HDStationId = ImageFileUpdate.HDStationId;
				this->RFU_StatusByte0 = ImageFileUpdate.RFU_StatusByte0;
				this->RFU_StatusByte1 = ImageFileUpdate.RFU_StatusByte1;
				this->HDImageType = ImageFileUpdate.HDImageType;
				this->HDImageCoding = ImageFileUpdate.HDImageCoding;
				this->ReservedByte_0 = ImageFileUpdate.ReservedByte_0;
				this->ReservedByte_1 = ImageFileUpdate.ReservedByte_1;
				this->ReservedByte_2 = ImageFileUpdate.ReservedByte_2;
				this->ReservedByte_3 = ImageFileUpdate.ReservedByte_3;
				this->HDAudioService = ImageFileUpdate.HDAudioService;
				this->HDApplicationMimeType = ImageFileUpdate.HDApplicationMimeType;
				this->LOTID = ImageFileUpdate.LOTID;
				this->Minute = ImageFileUpdate.Minute;
				this->Hour = ImageFileUpdate.Hour;
				this->Day = ImageFileUpdate.Day;
				this->Month = ImageFileUpdate.Month;
				this->Year = ImageFileUpdate.Year;
				this->NumberOfImageFileBytes = ImageFileUpdate.NumberOfImageFileBytes;
				this->ImageFileBytes = ImageFileUpdate.ImageFileBytes;
	}
	
	/*  Copy assignment operator  */ 
		
   clCMATHDImageFileUpdateStatus &operator=(const clCMATHDImageFileUpdateStatus &ImageFileUpdate)
	{
		if(this==&ImageFileUpdate){
		return *this;
		}
		else
			{
				this->HDStationId = ImageFileUpdate.HDStationId;
				this->RFU_StatusByte0 = ImageFileUpdate.RFU_StatusByte0;
				this->RFU_StatusByte1 = ImageFileUpdate.RFU_StatusByte1;
				this->HDImageType = ImageFileUpdate.HDImageType;
				this->HDImageCoding = ImageFileUpdate.HDImageCoding;
				this->ReservedByte_0 = ImageFileUpdate.ReservedByte_0;
				this->ReservedByte_1 = ImageFileUpdate.ReservedByte_1;
				this->ReservedByte_2 = ImageFileUpdate.ReservedByte_2;
				this->ReservedByte_3 = ImageFileUpdate.ReservedByte_3;
				this->HDAudioService = ImageFileUpdate.HDAudioService;
				this->HDApplicationMimeType = ImageFileUpdate.HDApplicationMimeType;
				this->LOTID = ImageFileUpdate.LOTID;
				this->Minute = ImageFileUpdate.Minute;
				this->Hour = ImageFileUpdate.Hour;
				this->Day = ImageFileUpdate.Day;
				this->Month = ImageFileUpdate.Month;
				this->Year = ImageFileUpdate.Year;
				this->NumberOfImageFileBytes = ImageFileUpdate.NumberOfImageFileBytes;
				this->ImageFileBytes = ImageFileUpdate.ImageFileBytes;
			}
	return *this;
	}
	
	/*  Move assignment operator */
		
	clCMATHDImageFileUpdateStatus &operator=(clCMATHDImageFileUpdateStatus &&ImageFileUpdate)
	{
		if(this==&ImageFileUpdate){
		return *this;
		}
		else
			{
				this->HDStationId = 0;
				this->RFU_StatusByte0 = ' ';
				this->RFU_StatusByte1 = ' ';
				this->HDImageType = {};
				this->HDImageCoding = {};
				this->ReservedByte_0 = ' ';
				this->ReservedByte_1 = ' ';
				this->ReservedByte_2 = ' ';
				this->ReservedByte_3 = ' ';
				this->HDAudioService = {};
				this->HDApplicationMimeType = 0;
				this->LOTID = 0;
				this->Minute = ' ';
				this->Hour = ' ';
				this->Day = ' ';
				this->Month = ' ';
				this->Year = 0;
				this->NumberOfImageFileBytes = 0;
				this->ImageFileBytes = {};
				
				this->HDStationId = ImageFileUpdate.HDStationId;
				this->RFU_StatusByte0 = ImageFileUpdate.RFU_StatusByte0;
				this->RFU_StatusByte1 = ImageFileUpdate.RFU_StatusByte1;
				this->HDImageType = ImageFileUpdate.HDImageType;
				this->HDImageCoding = ImageFileUpdate.HDImageCoding;
				this->ReservedByte_0 = ImageFileUpdate.ReservedByte_0;
				this->ReservedByte_1 = ImageFileUpdate.ReservedByte_1;
				this->ReservedByte_2 = ImageFileUpdate.ReservedByte_2;
				this->ReservedByte_3 = ImageFileUpdate.ReservedByte_3;
				this->HDAudioService = ImageFileUpdate.HDAudioService;
				this->HDApplicationMimeType = ImageFileUpdate.HDApplicationMimeType;
				this->LOTID = ImageFileUpdate.LOTID;
				this->Minute = ImageFileUpdate.Minute;
				this->Hour = ImageFileUpdate.Hour;
				this->Day = ImageFileUpdate.Day;
				this->Month = ImageFileUpdate.Month;
				this->Year = ImageFileUpdate.Year;
				this->NumberOfImageFileBytes = ImageFileUpdate.NumberOfImageFileBytes;
				this->ImageFileBytes = ImageFileUpdate.ImageFileBytes;
	
				ImageFileUpdate.HDStationId = 0;
				ImageFileUpdate.RFU_StatusByte0 = ' ';
				ImageFileUpdate.RFU_StatusByte1 = ' ';
				ImageFileUpdate.HDImageType = {};
				ImageFileUpdate.HDImageCoding = {};
				ImageFileUpdate.ReservedByte_0 = ' ';
				ImageFileUpdate.ReservedByte_1 = ' ';
				ImageFileUpdate.ReservedByte_2 = ' ';
				ImageFileUpdate.ReservedByte_3 = ' ';
				ImageFileUpdate.HDAudioService = {};
				ImageFileUpdate.HDApplicationMimeType = 0;
				ImageFileUpdate.LOTID = 0;
				ImageFileUpdate.Minute = ' ';
				ImageFileUpdate.Hour = ' ';
				ImageFileUpdate.Day = ' ';
				ImageFileUpdate.Month = ' ';
				ImageFileUpdate.Year = 0;
				ImageFileUpdate.NumberOfImageFileBytes = 0;
				ImageFileUpdate.ImageFileBytes = {};
			}
    return *this;
	}  
	
	
	
};
#endif // !defined(EA_BFE790E7_47A6_4343_BA6B_231069196B41__INCLUDED_)
