///////////////////////////////////////////////////////////
//  clCMATHDImageFileUpdateStatus.cpp
//  Implementation of the Class clCMATHDImageFileUpdateStatus
//  Created on:      07-Jul-2015 5:29:12 PM
///////////////////////////////////////////////////////////

#include "clCMATHDImageFileUpdateStatus.h"

clCMATHDImageFileUpdateStatus::clCMATHDImageFileUpdateStatus() : HDStationId(0),
RFU_StatusByte0(0),
RFU_StatusByte1(0),
ReservedByte_0(0),
ReservedByte_1(0),
ReservedByte_2(0),
ReservedByte_3(0),
HDApplicationMimeType(0),
LOTID(0),
Minute(0),
Hour(0),
Day(0),
Month(0),
Year(0),
NumberOfImageFileBytes(0){

}

clCMATHDImageFileUpdateStatus::~clCMATHDImageFileUpdateStatus(){

}

tunerVector<unsigned char> clCMATHDImageFileUpdateStatus::oSerialize(){

	tunerVector<unsigned char> payload;
	return payload;
}

short clCMATHDImageFileUpdateStatus::u16GetSize(){

	return 0;
}

void clCMATHDImageFileUpdateStatus::vConstruct(tunerVector<unsigned char> bitStream){

	unsigned short position=0;

	HDStationId = getInt(bitStream, position);
	position = (unsigned short)(position + sizeof(HDStationId));

	RFU_StatusByte0 = bitStream[position++];
	RFU_StatusByte1 = bitStream[position++];

	HDImageType.enType = static_cast<clCMEnum_HDImageType::enHDImageType>(bitStream[position++]);
	HDImageCoding.enType = static_cast<clCMEnum_HDImageCoding::enHDImageCoding>(bitStream[position++]);

	unsigned int DiscardTime = getInt(bitStream,position);

	SetLOTDiscardTime(DiscardTime);

	position = (unsigned short)(position + sizeof(DiscardTime));

	ReservedByte_0 = bitStream[position++];
	ReservedByte_1 = bitStream[position++];
	ReservedByte_2 = bitStream[position++];
	ReservedByte_3 = bitStream[position++];

	HDAudioService.enType = static_cast<clCMEnum_HDAudioService::enHDAudioService>(bitStream[position++]);

	HDApplicationMimeType = getInt(bitStream, position);
	position = (unsigned short)(position + sizeof(HDApplicationMimeType));
	
	unsigned char MSB = bitStream[position++];
	unsigned char LSB = bitStream[position++];
	LOTID = getWord(LSB, MSB);

	NumberOfImageFileBytes = getInt(bitStream, position);
	position = (unsigned short)(position + sizeof(NumberOfImageFileBytes));

	for(int CurrentPosition = position;
			(int)NumberOfImageFileBytes > (int)(CurrentPosition - position);
			CurrentPosition++)
	{
		ImageFileBytes.push_back(bitStream[CurrentPosition]);
	}
}

unsigned int clCMATHDImageFileUpdateStatus::getHDStationId()
{
	return HDStationId;
}

clCMEnum_HDImageType::enHDImageType clCMATHDImageFileUpdateStatus::getHDImageType()
{
	return HDImageType.enType;
}

clCMEnum_HDImageCoding::enHDImageCoding clCMATHDImageFileUpdateStatus::getHDImageCoding()
{
	return HDImageCoding.enType;
}

clCMEnum_HDAudioService::enHDAudioService clCMATHDImageFileUpdateStatus::getHDAudioService()
{
	return HDAudioService.enType;
}

unsigned int clCMATHDImageFileUpdateStatus::getHDApplicationMimeType()
{
	return HDApplicationMimeType;
}

unsigned short clCMATHDImageFileUpdateStatus::getLOTID()
{
	return LOTID;
}

unsigned int clCMATHDImageFileUpdateStatus::getNumberOfImageFileBytes()
{
	return NumberOfImageFileBytes;
}

tunerVector<unsigned char> clCMATHDImageFileUpdateStatus::getImageFileBytes()
{
	return ImageFileBytes;
}

unsigned char clCMATHDImageFileUpdateStatus::u8GetMinute()
{
	return Minute;
}

unsigned char clCMATHDImageFileUpdateStatus::u8GetHour()
{
	return Hour;
}

unsigned char clCMATHDImageFileUpdateStatus::u8GetDay()
{
	return Day;
}

unsigned char clCMATHDImageFileUpdateStatus::u8GetMonth()
{
	return Month;
}

unsigned short clCMATHDImageFileUpdateStatus::u8GetYear()
{
	return Year;
}

void clCMATHDImageFileUpdateStatus::SetLOTDiscardTime(unsigned int DiscardTime)
{
	Minute = DiscardTime & 0x0000003F;
	Hour = (DiscardTime >> 6) & 0x0000001F;
	Day = (DiscardTime >> 11) & 0x0000001F;
	Month = (DiscardTime >> 16) & 0x0000000F;
	Year = (unsigned short)((DiscardTime >> 20) & 0x00000FFF);
}
