///////////////////////////////////////////////////////////
//  clCMATHDImageFileUpdateSet.cpp
//  Implementation of the Class clCMATHDImageFileUpdateSet
//  Created on:      07-Jul-2015 5:26:48 PM
///////////////////////////////////////////////////////////

#include "clCMATHDImageFileUpdateSet.h"

clCMATHDImageFileUpdateSet::clCMATHDImageFileUpdateSet(): HDAudioProgramBitMask(0),
RFU_GetByte0(0),
RFU_GetByte1(0),
RFU_GetByte2(0),
RFU_GetByte3(0){

}

clCMATHDImageFileUpdateSet::~clCMATHDImageFileUpdateSet(){

}

tunerVector<unsigned char> clCMATHDImageFileUpdateSet::oSerialize(){

	tunerVector<unsigned char> payload;

	payload.push_back(HDAudioProgramBitMask);
	payload.push_back(static_cast<unsigned char>(HDImageType.enType));
	payload.push_back(RFU_GetByte0);
	payload.push_back(RFU_GetByte1);
	payload.push_back(RFU_GetByte2);
	payload.push_back(RFU_GetByte3);

	return payload;
}

short clCMATHDImageFileUpdateSet::u16GetSize(){

	short size = (short)(sizeof(HDAudioProgramBitMask) + HDImageType.getSize() + sizeof(RFU_GetByte0) * 4);
	return size;
}

void clCMATHDImageFileUpdateSet::vConstruct(tunerVector<unsigned char> /*bitStream*/){

}

void clCMATHDImageFileUpdateSet::setHDAudioProgramBitMask(unsigned char newHDAudioProgramBitMask)
{
	HDAudioProgramBitMask = newHDAudioProgramBitMask;
}

void clCMATHDImageFileUpdateSet::setHDImageType(clCMEnum_HDImageType::enHDImageType newHDImageType)
{
	HDImageType.enType = newHDImageType;
}

void clCMATHDImageFileUpdateSet::setRFU_GetByte0(unsigned char newRFU_GetByte0)
{
	RFU_GetByte0 = newRFU_GetByte0;
}

void clCMATHDImageFileUpdateSet::setRFU_GetByte1(unsigned char newRFU_GetByte1)
{
	RFU_GetByte1 = newRFU_GetByte1;
}

void clCMATHDImageFileUpdateSet::setRFU_GetByte2(unsigned char newRFU_GetByte2)
{
	RFU_GetByte2 = newRFU_GetByte2;
}

void clCMATHDImageFileUpdateSet::setRFU_GetByte3(unsigned char newRFU_GetByte3)
{
	RFU_GetByte3 = newRFU_GetByte3;
}
