///////////////////////////////////////////////////////////
//  clCMATHDGetImageFileGet.h
//  Implementation of the Class clCMATHDGetImageFileGet
//  Created on:      06-Jul-2015 8:40:32 PM
///////////////////////////////////////////////////////////

#if !defined(EA_B61792B5_A7A2_455e_B66D_99982A70BC65__INCLUDED_)
#define EA_B61792B5_A7A2_455e_B66D_99982A70BC65__INCLUDED_

#include "clADRMsgPayload.h"
#include "types/clCMEnumTypes.h"

class clCMATHDGetImageFileGet : public clADRMsgPayload
{

public:
	/**
	 * Unsigned long word 0..0xffffffff
	 */
	unsigned int HDStationId;
	/**
	 * Enumeration 0..7
	 * 0 Audio program 1 (MPS)
	 * 1..7 Audio program 2 .. 8 (SPS)
	 */
	clCMEnum_ATHDAudioProgram HDAudioProgram;
	/**
	 * Enumeration 0..1
	 * 0 Station Logo (MPS) or Service Logo (SPS 1..7)
	 * 1 Primary Image
	 */
	clCMEnum_HDImageType HDImageType;
	/**
	 * Unsigned byte 0..0xff
	 */
	unsigned char RFU_GetByte0;
	unsigned char RFU_GetByte1;
	unsigned char RFU_GetByte2;
	unsigned char RFU_GetByte3;

	clCMATHDGetImageFileGet();
	virtual ~clCMATHDGetImageFileGet();
	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * Set ATHDGetImageFileGet parameters
	 */
	void setHDStationId(unsigned int newHDStationId);
	void setHDAudioProgram(clCMEnum_ATHDAudioProgram::enATHDAudioProgram newHDAudioProgram);
	void setHDImageType(clCMEnum_HDImageType::enHDImageType newHDImageType);
	void setRFU_GetByte0(unsigned char newRFU_GetByte0);
	void setRFU_GetByte1(unsigned char newRFU_GetByte1);
	void setRFU_GetByte2(unsigned char newRFU_GetByte2);
	void setRFU_GetByte3(unsigned char newRFU_GetByte3);

};
#endif // !defined(EA_B61792B5_A7A2_455e_B66D_99982A70BC65__INCLUDED_)
