///////////////////////////////////////////////////////////
//  clCMATHDAudioProgramDirectSet.h
//  Implementation of the Class clCMATHDAudioProgramDirectSet
//  Created on:      17-Feb-2015 1:58:22 PM
///////////////////////////////////////////////////////////

#if !defined(EA_8FDF2A0F_8621_4dad_B3A8_48078B42F102__INCLUDED_)
#define EA_8FDF2A0F_8621_4dad_B3A8_48078B42F102__INCLUDED_

#include "clADRMsgPayload.h"
#include "types/clCMEnumTypes.h"

class clCMATHDAudioProgramDirectSet : public clADRMsgPayload
{

public:
	/**
	 * Constructor
	 */
	clCMATHDAudioProgramDirectSet();
	/**
	 * Destructor
	 */
	virtual ~clCMATHDAudioProgramDirectSet();
	/**
	 * Unsigned long
	 * 87700..107900 Hz
	 */
	unsigned int Frequency;
	/**
	 * Enumeration 0..7
	 * 0 Audio program 1 (MPS)
	 * 1..7 Audio program 2 .. 8 (SPS)
	 */
	clCMEnum_ATHDAudioProgram HDAudioProgram;
	/**
	 * serialize payload
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * Set Frequency
	 */
	void setFrequency(unsigned int newFrequency);
	/**
	 * Set HD audio program
	 */
	void setHDAudioProgram(clCMEnum_ATHDAudioProgram::enATHDAudioProgram newHDAudioProgram);

};
#endif // !defined(EA_8FDF2A0F_8621_4dad_B3A8_48078B42F102__INCLUDED_)
