///////////////////////////////////////////////////////////
//  clCMATBandStatus.h
//  Implementation of the Class clCMATBandStatus
//  Created on:      10-Feb-2015 8:37:10 PM
///////////////////////////////////////////////////////////

#if !defined(EA_7FE5289C_585C_4826_BAC6_173A5AB1057D__INCLUDED_)
#define EA_7FE5289C_585C_4826_BAC6_173A5AB1057D__INCLUDED_

#include "clADRMsgPayload.h"
#include "types/clCMEnumTypes.h"
#include "datatypes/tString.h"

#define DRMSERVICELABEL_LEN	64
#define HDCALLSIGN_LEN		16
#define STATIONNAME_LEN		8

class clCMATBandStatus : public clADRMsgPayload
{

public:
	/**
	 * Constructor
	 */
	clCMATBandStatus();
	/**
	 * Destrcutor
	 */
	virtual ~clCMATBandStatus();
	/**
	 * Unsigned long 150..108000 KHZ
	 */
	unsigned int Frequency;
	/**
	 * Unsigned word 0..0xffff
	 */
	unsigned short PI;
	/**
	 * String of length 8 bytes
	 */
	tunerString Stationname;
	/**
	 * String of length 16 bytes
	 */
	tunerString HDCallSign;
	/**
	 * Unsigned long word 0..0xffffffff
	 */
	unsigned int HDStationId;
	/**
	 * Unsigned word 0x0f20..0x0f3f
	 */
	unsigned short ActivePresetList;
	/**
	 * Unsigned byte 0x00..0xff
	 */
	unsigned char PresetAutocompare;
	/**
	 * Byte array of size 64
	 */
	tunerString DRMServiceLabel;
	/**
	 * Unsigned long word 0..0xffffffff
	 */
	unsigned int DRMServiceId;
	/**
	 * Unsigned byte 0x00..0xff
	 */
	unsigned char rfu_byte_0;
	unsigned char rfu_byte_1;
	unsigned char rfu_byte_2;
	unsigned char rfu_byte_3;
	unsigned char rfu_byte_4;
	unsigned char rfu_byte_5;
	unsigned char rfu_byte_6;
	unsigned char rfu_byte_7;
	unsigned char rfu_byte_8;
	unsigned char rfu_byte_9;
	unsigned char rfu_byte_10;
	unsigned char rfu_byte_11;
	unsigned char rfu_byte_12;
	unsigned char rfu_byte_13;
	unsigned char rfu_byte_14;
	unsigned char rfu_byte_15;
	unsigned char rfu_byte_16;
	unsigned char rfu_byte_17;
	unsigned char rfu_byte_18;
	/**
	 * Enumeration 0..7
	 */
	clCMEnum_HDAudioService HDAudioService;
	/**
	 * Enumeration 0..22 And 0xff
	 */
	clCMEnum_Band Band;
	/**
	 * serialize payload
	 */
	/**
	 * Enumeration 0..3 DRM audio program 1..4
	 */
	clCMEnum_DRMServiceShortId DRMServiceShortId;
	tunerVector<unsigned char> oSerialize();
	/**
	 * returns the size of the payload
	 */
	short u16GetSize();
	/**
	 * constructs payload
	 */
	void vConstruct(tunerVector<unsigned char> bitStream);
	/**
	 * construct RFU bytes
	 */
	void ConstructRFUBytes(tunerVector<unsigned char> &bitStream, unsigned short position);
	/**
	 * Set Band
	 */
	void setBand(clCMEnum_Band::enBand newBand);
	/**
	 * Set Frequency
	 */
	void setFrequency(unsigned int newFrequency);
	/**
	 * Set PI
	 */
	void setPI(unsigned short newPI);
	/**
	 * Set Station name
	 */
	void setStationname(tunerString newStationname);
	/**
	 * Set HD call sign
	 */
	void setHDCallSign(tunerString newHDCallSign);
	/**
	 * Set HD Station ID
	 */
	void setHDStationId(unsigned int newHDStationId);
	/**
	 * Set HD Audio Service
	 */
	void setHDAudioService(clCMEnum_HDAudioService::enHDAudioService newHDAudioService);
	/**
	 * Set Active preset list
	 */
	void setActivePresetList(unsigned short newActivePresetList);
	/**
	 * Set Preset auto-compare
	 */
	void setPresetAutocompare(unsigned char newPresetAutocompare);
	/**
	 * Set DRM service label
	 */
	void setDRMServiceLabel(tunerString newDRMServiceLabel);
	/**
	 * Set DRM service Id
	 */
	void setDRMServiceId(unsigned int newDRMServiceId);
	/**
	 * Set DRM service short Id
	 */
	void setDRMServiceShortId(clCMEnum_DRMServiceShortId::enDRMServiceShortId newDRMServiceShortId);
	/**
	 * Set RFU bytes
	 */
	void setrfu_bytes(tunerVector<unsigned char> newrfu_bytes);
	/**
	 * Read Band
	 */
	 clCMEnum_Band::enBand getBand() const;
	/**
	 * Read Frequency
	 */
	unsigned long getFrequency() const;
	/**
	 * Read PI
	 */
	unsigned short getPI() const;
	/**
	 * Read Station name
	 */
	const char * getStationname() const;
	/**
	 * Read HD call sign
	 */
	const char * getHDCallSign() const;
	/**
	 * Read HD station ID
	 */
	unsigned long getHDStationId() const;
	/**
	 * Read HD audio service
	 */
	clCMEnum_HDAudioService::enHDAudioService getHDAudioService() const;
	/**
	 * Read active preset list
	 */
	unsigned short getActivePresetList() const;
	/**
	 * Read Preset auto-compare
	 */
	unsigned char getPresetAutocompare() const;
	/**
	 * Read DRM service label
	 */
	const char * getDRMServiceLabel() const;
	/**
	 * Read DRM service Id
	 */
	unsigned long getDRMServiceId() const;
	/**
	 * Read DRM service short ID
	 */
	clCMEnum_DRMServiceShortId::enDRMServiceShortId getDRMServiceShortId() const;
	/**
	 * Read RFU bytes
	 */
	tunerVector<unsigned char> getrfu_bytes();

};
#endif // !defined(EA_7FE5289C_585C_4826_BAC6_173A5AB1057D__INCLUDED_)
