///////////////////////////////////////////////////////////
//  clATPISetGet.h
//  Implementation of the Class clATPISetGet
//  Created on:      26-Mar-2015 5:52:58 PM
///////////////////////////////////////////////////////////

#if !defined(EA_0F8BF601_1641_40af_8DA6_6F0143846134__INCLUDED_)
#define EA_0F8BF601_1641_40af_8DA6_6F0143846134__INCLUDED_

#include "clADRMsgPayload.h"

class clATPISetGet : public clADRMsgPayload
{

public:
    /**
    * unsigned word 0..0xffff
    */
    unsigned short u16PI;
    /**
     * unsigned int
     * 76000..108000
     */
    unsigned int u32Frequency;

    clATPISetGet();
    virtual ~clATPISetGet();
    /**
    * serialize the data stream
    */
    tunerVector<unsigned char> oSerialize();
    /**
    * set value of PI
    */
    void setPI(unsigned short newPI);
    /**
    * set value of Frequency
    */
    void setFrequency(unsigned int newFrequency);
    /**
    * returns the size of the data stream
    */
    short u16GetSize();
    /**
    * construct payload
    */
    void vConstruct(tunerVector<unsigned char> bitStream);

};
#endif // !defined(EA_0F8BF601_1641_40af_8DA6_6F0143846134__INCLUDED_)
