///////////////////////////////////////////////////////////
//  clADROutMsg.h
//  Implementation of the Class clADROutMsg
//  Created on:      09-Jan-2015 14:47:24
//  Original author: pad1cob
///////////////////////////////////////////////////////////

#if !defined(EA_064CA27F_49A3_48f4_8579_447DBB3A26AE__INCLUDED_)
#define EA_064CA27F_49A3_48f4_8579_447DBB3A26AE__INCLUDED_

#include "clByteConverter.h"
#include "clADRMsgHeader.h"
#include "clADRMsgPayload.h"
#include "datatypes/tVector.h"

/**
 * The message class used to creating messages which can be sent to the ADR.
 * @author pad1cob
 * @version 1.0
 * @updated 09-Jan-2015 15:06:01
 */
class clADROutMsg : public clByteConverter
{

public:
	clADROutMsg();
	virtual ~clADROutMsg();

	/**
	 * accepts the messageHeader and Payload data.
	 * 
	 * @param msgHeader
	 * @param payload
	 */
	clADROutMsg(clADRMsgHeader msgHeader, clADRMsgPayload* payload);
	/**
	 * The function to modify the message into bitstream. 
	 */
	tunerVector<unsigned char> oSerialize();
	/**
	 * Converts the header into bitstream and stores into vector 
	 */
	void vAddHeaderToBitStream(clADRMsgHeader msgHeader, clADRMsgPayload* payload);
	/**
	 * Converts the payload into bitstream and stores into vector 
	 */
	void vAddPayloadToBitStream(clADRMsgPayload* payload);


private:
	/**
	 * contains the bitstream related to input data
	 */
	tunerVector<unsigned char> bitStream;

};
#endif // !defined(EA_064CA27F_49A3_48f4_8579_447DBB3A26AE__INCLUDED_)
