///////////////////////////////////////////////////////////
//  clADROutMsg.cpp
//  Implementation of the Class clADROutMsg
//  Created on:      09-Jan-2015 14:47:24
//  Original author: pad1cob
///////////////////////////////////////////////////////////

#include "clADROutMsg.h"


clADROutMsg::clADROutMsg(){

}



clADROutMsg::~clADROutMsg(){

}





clADROutMsg::clADROutMsg(clADRMsgHeader msgHeader, clADRMsgPayload* payload){

   vAddHeaderToBitStream(msgHeader, payload);
   vAddPayloadToBitStream(payload);
}


tunerVector<unsigned char> clADROutMsg::oSerialize(){

	return  bitStream;
}


void clADROutMsg::vAddHeaderToBitStream(clADRMsgHeader msgHeader, clADRMsgPayload* payload) {

   bitStream.push_back(getMSB(msgHeader.getu16ClientId()));
   bitStream.push_back(getLSB(msgHeader.getu16ClientId()));
   bitStream.push_back(getMSB(msgHeader.getu16FBlockId()));
   bitStream.push_back(getLSB(msgHeader.getu16FBlockId()));
   bitStream.push_back(msgHeader.getu8InstanceId());
   bitStream.push_back(getMSB(msgHeader.getu16FunctionId()));
   bitStream.push_back(getLSB(msgHeader.getu16FunctionId()));
   bitStream.push_back(msgHeader.getu8OpCode());
   short sizeOfPayload = payload->u16GetSize();
   if (payload->bIsStaticSize())
   {
	   bitStream.push_back(getMSB(sizeOfPayload));
	   bitStream.push_back(getLSB(sizeOfPayload));
   }
}



void clADROutMsg::vAddPayloadToBitStream(clADRMsgPayload* payload) {

   tunerVector<unsigned char> payloadData = payload->oSerialize();
   bitStream.insert(bitStream.end(), payloadData.begin(), payloadData.end());
}
