///////////////////////////////////////////////////////////
//  clADRMsgPayload.h
//  Implementation of the Class clADRMsgPayload
//  Created on:      09-Jan-2015 14:47:30
//  Original author: pad1cob
///////////////////////////////////////////////////////////

#if !defined(EA_F676920B_2F35_4adb_A56C_7B2C235C6E00__INCLUDED_)
#define EA_F676920B_2F35_4adb_A56C_7B2C235C6E00__INCLUDED_

#include "clByteConverter.h"
#include "datatypes/tVector.h"
/**
 * Base class for all ADR functions.
 * @author pad1cob
 * @version 1.0
 * @updated 09-Jan-2015 15:11:40
 */
class clADRMsgPayload : public clByteConverter
{

public:
	clADRMsgPayload();
	virtual ~clADRMsgPayload();

	/**
	 * returns the size of the data stream
	 */
	virtual tunerVector<unsigned char> oSerialize() =0;
	/**
	 * returns the size of the payload
	 */
	virtual short u16GetSize() =0;
	/**
	 * determines if the function size is variable
	 */
	virtual bool bIsStaticSize() {return true;}
	/**
	 * contructs the payload object using the bitstream
	 * 
	 * @param bitStream
	 */
	virtual void vConstruct(tunerVector<unsigned char> bitStream) =0;
	
	/*  Copy constructor  */
		
	clADRMsgPayload(const clADRMsgPayload &Payload): clByteConverter (Payload)
	{}
	
	/*  Copy assignment operator */
		
	clADRMsgPayload &operator=(clADRMsgPayload &Payload)
	{
		if(this==&Payload){
		return *this;
		}
		return Payload;
	}
	
	/*  Move assignment operator  */
		
	clADRMsgPayload &operator=(clADRMsgPayload &&Payload)
	{
		if(this==&Payload){
		return *this;
		}
		return Payload;
	}

};
#endif // !defined(EA_F676920B_2F35_4adb_A56C_7B2C235C6E00__INCLUDED_)
