///////////////////////////////////////////////////////////
//  clADRInMsg.h
//  Implementation of the Class clADRInMsg
//  Created on:      09-Jan-2015 14:47:12
//  Original author: pad1cob
///////////////////////////////////////////////////////////

#if !defined(EA_D51547DD_B315_46bc_AB20_A47DD57C1D4F__INCLUDED_)
#define EA_D51547DD_B315_46bc_AB20_A47DD57C1D4F__INCLUDED_

#include "clADRMsgHeader.h"
#include "clByteConverter.h"
#include "clADRMsgPayload.h"
#include "datatypes/tVector.h"

/**
 * class used to read incoming messages from ADR.
 * This can be used to retrieve the header and also pass an object to be filled.
 * @author pad1cob
 * @version 1.0
 * @updated 09-Jan-2015 15:58:23
 */
class clADRInMsg : public clByteConverter
{
private:
	tunerVector<unsigned char> bitStream;
	clADRMsgHeader header;


public:
	clADRInMsg();
	virtual ~clADRInMsg();

	/**
	 * 
	 * @param bitStream
	 */
	clADRInMsg(tunerVector<unsigned char> & bitStream, bool bDecodeOnlyHeader = false);
	/**
	 * returns the header object of the message
	 */
	clADRMsgHeader getHeader();
	/**
	 * used to read the data into the payload
	 * 
	 * @param oPayload
	 */
	void vGetDataFromPayload(clADRMsgPayload & oPayload);

	void vPackHeader(tunerVector<unsigned char> & stream);

};
#endif // !defined(EA_D51547DD_B315_46bc_AB20_A47DD57C1D4F__INCLUDED_)
