///////////////////////////////////////////////////////////
//  clADRInMsg.cpp
//  Implementation of the Class clADRInMsg
//  Created on:      09-Jan-2015 14:47:12
//  Original author: pad1cob
///////////////////////////////////////////////////////////

#include "clADRInMsg.h"
#include "datatypes/tAlgorithm.h"
#include "tuner_trace.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUN_TRACE_CLASS_TUNAPP
#include "trcGenProj/Header/clADRInMsg.cpp.trc.h"
#endif


clADRInMsg::clADRInMsg(){

}



clADRInMsg::~clADRInMsg(){

}





clADRInMsg::clADRInMsg(tunerVector<unsigned char> & stream, bool bDecodeOnlyHeader){
	if(bDecodeOnlyHeader)
	{
	   vPackHeader(stream);
	}
	else
	{
	   bitStream = stream;
	   unsigned short index = 0;
	   unsigned char MSB = bitStream[index++];
	   unsigned char LSB = bitStream[index++];
	   header.setu16ClientId(getWord(LSB,MSB));
	   MSB = bitStream[index++];
	   LSB = bitStream[index++];
	   header.setu16FBlockId(getWord(LSB,MSB));
	   header.setu8InstanceId(bitStream[index++]);
	   MSB = bitStream[index++];
	   LSB = bitStream[index++];
	   header.setu16FunctionId(getWord(LSB,MSB));
	   header.setu8OpCode(bitStream[index++]);
	   index = (unsigned short) (index + sizeof( unsigned short)); //Skip size information
	   bitStream.erase(bitStream.begin(), bitStream.begin() + index);
	}
}

void clADRInMsg::vPackHeader(tunerVector<unsigned char> & stream)
{
	unsigned short index = 0;
   unsigned char MSB = stream[index++];
   unsigned char LSB = stream[index++];
   header.setu16ClientId(getWord(LSB,MSB));
   MSB = stream[index++];
   LSB = stream[index++];
   header.setu16FBlockId(getWord(LSB,MSB));
   header.setu8InstanceId(stream[index++]);
   MSB = stream[index++];
   LSB = stream[index++];
   header.setu16FunctionId(getWord(LSB,MSB));
   header.setu8OpCode(stream[index++]);
}


clADRMsgHeader clADRInMsg::getHeader(){

   return  header;
}


void clADRInMsg::vGetDataFromPayload(clADRMsgPayload & oPayload){
	if (bitStream.empty())
	{
		 ETG_TRACE_USR4(("vGetDataFromPayload on empty payload "));
	}
   else
	{
	oPayload.vConstruct(bitStream);
	}
}
