/**************************************************************************//**
* \file     clTunerControl.h
*
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef announcements_clTunerControl_h
#define announcements_clTunerControl_h


#include "datatypes/tunerDatatypes.h"
#include "announcements/config/tunerAnnouncements.h"
#include "datatypes/tMap.h"
#include "datatypes/tString.h"


namespace tuner
{
   namespace announcements
   {
      class clTunerInterface;

      class clTunerControl
      {
      public:
         virtual ~clTunerControl();
         static clTunerControl* instance();
         static clTunerControl* m_poTunerControl;

         void vOnAnnouncementState(tuner::common::enSourceId tunerSourceId, tuner::common::enAnnouncement announcementId,
        		 tuner::common::enSrcActivity tunerSrcActivity, tuner::common::enTunerState tunerState);
         void vCancelAnnouncement(tuner::common::enSourceId tunerSourceId, tuner::common::enAnnouncement announcementId);
         void vSetTunerImpl(tuner::announcements::clTunerInterface* poImpl, tuner::common::enSourceId tunerSourceId);
         void vOnAnnouncementCompleted(tuner::common::enSourceId tunerSourceId,
        			tuner::common::enAnnouncement announcementId, tuner::common::enSrcActivity tunerSrcActivity);

      private:
         clTunerControl();
         tunerMap<tuner::common::enSourceId, tuner::announcements::clTunerInterface*> TunerImplMap;
      };
   }
}

#endif // announcements_clTunerControl_h
