/**************************************************************************//**
* \file     clTunerControl.cpp
*
*           clTunerControl method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/

#include "announcements/clTunerControl.h"
#include "announcements/interface/clTunerInterface.h"


using namespace tuner::announcements;
using namespace tuner::common;


clTunerControl* clTunerControl::m_poTunerControl = NULL;
/**************************************************************************//**
* Constructor
******************************************************************************/
clTunerControl::clTunerControl()
{

}


/**************************************************************************//**
* Destructor
******************************************************************************/
clTunerControl::~clTunerControl()
{
}


/**************************************************************************//**
* Destructor
******************************************************************************/
clTunerControl* clTunerControl::instance()
{
	if (m_poTunerControl == 0)
	{
		m_poTunerControl = new clTunerControl();
	}
	return m_poTunerControl;
}


/**************************************************************************//**
* 
******************************************************************************/
void clTunerControl::vSetTunerImpl(tuner::announcements::clTunerInterface* poImpl,tuner::common::enSourceId tunerSourceId)
{
	TunerImplMap[tunerSourceId] = poImpl;
}


/**************************************************************************//**
* 
******************************************************************************/
void clTunerControl::vOnAnnouncementState(tuner::common::enSourceId tunerSourceId, tuner::common::enAnnouncement announcementId,
		tuner::common::enSrcActivity tunerSrcActivity, tuner::common::enTunerState tunerState)
{
	if (TunerImplMap.find(tunerSourceId) != TunerImplMap.end())
	{
		TunerImplMap[tunerSourceId]->vOnAnnouncementState(announcementId, tunerSrcActivity, tunerState);
	}
}


/**************************************************************************//**
*
******************************************************************************/
void clTunerControl::vCancelAnnouncement(tuner::common::enSourceId tunerSourceId, tuner::common::enAnnouncement announcementId)
{
	if (TunerImplMap.find(tunerSourceId) != TunerImplMap.end())
	{
		TunerImplMap[tunerSourceId]->vCancelAnnouncement(announcementId);
	}
}

/**************************************************************************//**
*
******************************************************************************/
void clTunerControl::vOnAnnouncementCompleted(tuner::common::enSourceId tunerSourceId,
		tuner::common::enAnnouncement announcementId, tuner::common::enSrcActivity tunerSrcActivity)
{
	if (TunerImplMap.find(tunerSourceId) != TunerImplMap.end())
	{
		TunerImplMap[tunerSourceId]->vOnAnnouncementCompleted(announcementId, tunerSrcActivity);
	}
}
