/**************************************************************************//**
* \file     clAudioControl.cpp
*
*           clAudioControl method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/

#include "announcements/clAudioControl.h"
#include "announcements/interface/clAudioInterface.h"


static tuner::announcements::clAudioInterface* m_poAudio;


using namespace tuner::announcements;
using namespace tuner::common;


/**************************************************************************//**
* Constructor
******************************************************************************/
clAudioControl::clAudioControl()
{

}


/**************************************************************************//**
* Destructor
******************************************************************************/
clAudioControl::~clAudioControl()
{
}


/**************************************************************************//**
* 
******************************************************************************/
void clAudioControl::vSetAudioImpl(tuner::announcements::clAudioInterface* poImpl)
{
   m_poAudio = poImpl;
}


/**************************************************************************//**
* 
******************************************************************************/
void clAudioControl::vRequestSourceChange(tuner::common::enSourceId tunerSourceId, tuner::common::enSrcActivity tunerSrcActivity)
{
   if (0 != m_poAudio)
   {
      m_poAudio->vRequestSourceChange(tunerSourceId, tunerSrcActivity);
   }
}


/**************************************************************************//**
*
******************************************************************************/
enSourceId clAudioControl::getActiveSource()
{
   if (0 != m_poAudio)
   {
      return m_poAudio->getActiveSource();
   }
   return tuner::common::SOURCEID_LIMIT;
}


/**************************************************************************//**
*
******************************************************************************/
enSrcActivity clAudioControl::getActiveSourceActivity()
{
   if (0 != m_poAudio)
   {
     return m_poAudio->getActiveSourceActivity();
   }
   return tuner::common::SRCACTIVITY_UNKNOWN;
}

tuner::common::enSourceId clAudioControl::getRequestedSource()
{
	if (0 != m_poAudio)
	{
		return m_poAudio->getRequestedSource();
	}
	return tuner::common::SOURCEID_LIMIT;
}

tuner::common::enSrcActivity clAudioControl::getRequestedSourceActivity()
{	
	if (0 != m_poAudio)
	{
		return m_poAudio->getRequestedSourceActivity();
	}
	return tuner::common::SRCACTIVITY_UNKNOWN;
}
