/**************************************************************************//**
* \file     clAnnouncementState.h
*
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/
#ifndef clAnnouncementState_h
#define clAnnouncementState_h

#include "datatypes/tunerDatatypes.h"
#include "announcements/config/tunerAnnouncements.h"
#include "datatypes/tString.h"
#include "datatypes/tMap.h"

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

namespace tuner
{
   namespace announcements
   {
      class clAnnouncementState
      {
      public:
         virtual ~clAnnouncementState();
         clAnnouncementState();
         enum enState
         {
            ANNOUNCEMENT_REQUESTED,
            ANNOUNCEMENT_REQUEST_IN_PROGRESS,
            ANNOUNCEMENT_FAILED,
            ANNOUNCEMENT_NOT_ALLOWED,
            ANNOUNCEMENT_COMPLETED,
         };
         
         bool bIsAnnouncementRequested();
         bool bIsAnnouncementFailed();
         bool bIsAnnouncementNotAllowed();
         bool bIsAnnouncementRequestCompleted();
         bool bIsAnnouncementRequestInProgress();
         void vReset();
         bool bIsActivateRequest();
         bool bIsDeactivateRequest();
         bool bIgnoreAnnouncement();
         bool bAlwaysPlayAnnouncement();

         enState state;
         tuner::common::enSourceId tunerSource;
         tuner::common::enAnnouncement announcementId;
         tuner::common::enSrcActivity tunerSrcActivity;
         tuner::common::enTunerState tunerState;
         unsigned char priority;

      private:

      };
   }
}

#endif // clAnnouncementState_h
