/**************************************************************************//**
* \file     clAnnouncementSettings.cpp
*
*           clAnnouncementSettings method class implementation
*
* \remark   Copyright: 2010 Robert Bosch GmbH, Hildesheim
******************************************************************************/

#include "announcements/clAnnouncementSettings.h"
#include "datatypes/tunerDatatypes.h"
#include "announcements/config/tunerAnnouncements.h"
#include "common/tuner_trace.h"


using namespace tuner::common;
using namespace tuner::announcements;

clAnnouncementSettings* clAnnouncementSettings::m_poAnnouncementSettings = 0;


#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNER_TRACE_CLASS_ANNOUNCEMENTS
#include "trcGenProj/Header/clAnnouncementSettings.cpp.trc.h"
#endif


#define IGNORE_ANNOUNCEMENTS 0x1f

/**************************************************************************//**
* Constructor
******************************************************************************/
clAnnouncementSettings::clAnnouncementSettings()
{
	vInitializeDefaultValues();
}


/**************************************************************************//**
* Destructor
******************************************************************************/
clAnnouncementSettings::~clAnnouncementSettings()
{

}


/**************************************************************************//**
*
******************************************************************************/
tuner::announcements::clAnnouncementSettings* clAnnouncementSettings::instance()
{
   if (0 == clAnnouncementSettings::m_poAnnouncementSettings)
   {
	   clAnnouncementSettings::m_poAnnouncementSettings = new tuner::announcements::clAnnouncementSettings();
   }
   return clAnnouncementSettings::m_poAnnouncementSettings;
}


/**************************************************************************//**
*
******************************************************************************/
void clAnnouncementSettings::deleteInstance()
{
   if (0 != clAnnouncementSettings::m_poAnnouncementSettings)
   {
      delete clAnnouncementSettings::m_poAnnouncementSettings;
      clAnnouncementSettings::m_poAnnouncementSettings = 0;
   }
}


/**************************************************************************//**
*
******************************************************************************/
void clAnnouncementSettings::vInitializeDefaultValues()
{

	for(unsigned int u32Index = 0; u32Index < ANNOUNCEMENT_LIMIT; u32Index++)
	{
		AnnouncementPriorityMap[(tuner::common::enAnnouncement)u32Index] = getDefaultPriority((tuner::common::enAnnouncement)u32Index);
	}
}


/**************************************************************************//**
*
******************************************************************************/
void clAnnouncementSettings::vSetAnnouncementPriority(tuner::common::enAnnouncement announcement, unsigned short priority)
{
	AnnouncementPriorityMap[announcement] = priority;
}


/**************************************************************************//**
*
******************************************************************************/
unsigned short clAnnouncementSettings::u16GetAnnouncementPriority(tuner::common::enAnnouncement announcement)
{
	return AnnouncementPriorityMap[announcement];
}


/**************************************************************************//**
*
******************************************************************************/
tuner::common::enAnnouncement clAnnouncementSettings::oGetHighestPriorityAnnouncement(tuner::common::enSourceId tunerSourceId)
{
	tunerVector<tuner::common::enAnnouncement> listOfAnnouncements = oGetSourceAnnouncements(tunerSourceId);
	tuner::common::enAnnouncement announcement =ANNOUNCEMENT_LIMIT;
	unsigned priority = IGNORE_ANNOUNCEMENTS;

	for(unsigned int u32Index = 0; u32Index < listOfAnnouncements.size(); u32Index++)
	{
		if (priority > AnnouncementPriorityMap[listOfAnnouncements[u32Index]])
		{
			priority = AnnouncementPriorityMap[listOfAnnouncements[u32Index]];
			announcement = listOfAnnouncements[u32Index];
		}
	}
	return announcement;
}


/**************************************************************************//**
*
******************************************************************************/
tuner::announcements::stTunerAnnouncementInformation clAnnouncementSettings::oGetHighestPriorityAnnouncement(tunerVector<tuner::announcements::stTunerAnnouncementInformation>  announcementList)
{
	stTunerAnnouncementInformation announcementInfo;
   announcementInfo.tunerAnnouncement = tuner::common::ANNOUNCEMENT_LIMIT;
   announcementInfo.tunerSourceId = tuner::common::SOURCEID_LIMIT;
   announcementInfo.tunerSrcActivity = tuner::common::SRCACTIVITY_UNKNOWN;
	unsigned priority = IGNORE_ANNOUNCEMENTS;

	for(unsigned int u32Index = 0; u32Index < announcementList.size(); u32Index++)
	{
		if (priority > AnnouncementPriorityMap[announcementList[u32Index].tunerAnnouncement])
		{
			priority = AnnouncementPriorityMap[announcementList[u32Index].tunerAnnouncement];
			announcementInfo = announcementList[u32Index];
		}
	}
	return announcementInfo;
}


/**************************************************************************//**
*
******************************************************************************/
bool clAnnouncementSettings::bPlayOtherAnnouncements(tuner::common::enSourceId tunerSourceId, tuner::common::enSourceId AnnouncementType)
{
	tunerMap<tuner::common::enSourceId, tunerPair<tuner::common::enSourceId, bool> >::iterator itr;
	itr = TrafficAnnouncementInOtherSourceMap.find(tunerSourceId);
	if((itr !=  TrafficAnnouncementInOtherSourceMap.end()) && (itr->second.first ==AnnouncementType ))
	{
		ETG_TRACE_USR4(("AnnouncementSetting --> PlayOtherAnnouncements Source =%d AnnouncementType=%d returns =%d",
		ETG_ENUM(TUNER_SOURCE,tunerSourceId),ETG_ENUM(TUNER_SOURCE,AnnouncementType),itr->second.second));
		return itr->second.second;
	}
	ETG_TRACE_USR4(("AnnouncementSetting --> PlayOtherAnnouncements Source =%d AnnouncementType=%d returns false",
	ETG_ENUM(TUNER_SOURCE,tunerSourceId),ETG_ENUM(TUNER_SOURCE,AnnouncementType)));
	/*Weather alert from weather band should be supported in all source. No KDS parameter available */
	if(AnnouncementType == tuner::common::WEATHERANNOUNCEMENTS)
	{
	   return true;
	}
	return false;
}
/**************************************************************************//**
*
******************************************************************************/
void clAnnouncementSettings::vSetPlayOtherAnnouncements(tuner::common::enSourceId tunerSourceId,
													tuner::common::enSourceId AnnouncementSource,	bool bSupport)
{
	ETG_TRACE_USR4(("vSetPlayOtherAnnouncements()::bSupport=%d AnnouncementType=%d enSourceId=%d", bSupport, AnnouncementSource,ETG_ENUM(TUNER_SOURCE, (tU8)tunerSourceId)));
	TrafficAnnouncementInOtherSourceMap.insert(tunermakePair(tunerSourceId,(tunermakePair(AnnouncementSource, bSupport)) ));
}


/**************************************************************************//**
*
******************************************************************************/
void clAnnouncementSettings::vOnNewTpState(tuner::common::enBand band, tuner::common::enTpState tpState )
{
	ETG_TRACE_USR4(("vOnNewTpState()::tpState=%d band=%d", ETG_ENUM(TUNER_TPSTATE,tpState), ETG_ENUM(TUNER_BAND,band)));
	TpStateMap[band] = tpState;
}


/**************************************************************************//**
*
******************************************************************************/
void clAnnouncementSettings::vOnSourceFollowingState(tuner::common::enBand tunerBand, bool bServiceFollowing )
{
	ETG_TRACE_USR4(("vOnSourceFollowingState()::bServiceFollowing=%d band=%d", bServiceFollowing, ETG_ENUM(TUNER_BAND, tunerBand)));
	ServiceFollowingMap[tunerBand] = bServiceFollowing;
}


/**************************************************************************//**
*
******************************************************************************/
bool clAnnouncementSettings::bIsTpSupportedInBand(tuner::common::enSourceId tunerSourceId)
{
	if (TpStateMap.find(oGetAnnouncementSourceBand(oGetAnnouncementSourceId(tunerSourceId))) != TpStateMap.end())
	{
		if(TpStateMap[oGetAnnouncementSourceBand(oGetAnnouncementSourceId(tunerSourceId))] == tuner::common::TP_AVAILABLE)
		{
			ETG_TRACE_USR4(("bIsTpSupportedInBand()::Source=%d TP state=%d",1,ETG_ENUM(TUNER_SOURCE, (tU8)tunerSourceId)));
			return true;
		}
	}
	return false;
}



/**************************************************************************//**
*
******************************************************************************/
bool clAnnouncementSettings::bIsServiceFollowingActive(tuner::common::enSourceId tunerSourceId)
{
	if (ServiceFollowingMap.find(oGetAnnouncementSourceBand(oGetAnnouncementSourceId(tunerSourceId))) != ServiceFollowingMap.end())
	{
		return ServiceFollowingMap[oGetAnnouncementSourceBand(oGetAnnouncementSourceId(tunerSourceId))];
	}
	return false;
}

/***
 *
 */
bool clAnnouncementSettings::bIsAnnouncementSurvivellenceModeSupport(tuner::common::enSourceId tunerSourceId)
{
	if (AnnoSurvivellenceMode.find(tunerSourceId) != AnnoSurvivellenceMode.end())
	{
		return AnnoSurvivellenceMode[tunerSourceId];
	}
	return false;
}

/****
 *
 */
void clAnnouncementSettings::vSetAnnouncementSurvivellenceModeSupport(tuner::common::enSourceId tunerSourceId, bool bSupport)
{
	ETG_TRACE_USR4(("ANNOUNCEMENTS: src = %d SurvivellenceMode            = %d\n", ETG_ENUM(TUNER_SOURCE, (tU8)tunerSourceId),bSupport));
	AnnoSurvivellenceMode[tunerSourceId] = bSupport;
}
