/************************************************************************
* FILE:           clSessionControl.h
* PROJECT:        G3g
* SW-COMPONENT:   TunerMaster
*----------------------------------------------------------------------
*
* DESCRIPTION:   Implementation of the Class clSessionControl
*
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:

* Date           | Author                       		| Modification
* 27-Mar-2015  	 | pad1cob						        | Initial version.
																			
*************************************************************************/

#ifndef clSessionControl_h
#define clSessionControl_h


#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_SERVICEINFO
#include "midw_fi_if.h"

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_SERVICEINFO
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_ERRORCODES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_FI_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_ext_fi_if.h"


#include "datatypes/tunerDatatypes.h"

namespace tuner
{
   namespace sessionManagement
   {
      namespace audio
      {
         class clTunerInterface;
         /**
          * @author pad1cob
          * @version 1.0
          * @created 27-Mar-2015 15:43:29
          */
         class clSessionControl
         {

            public:
        	   static clSessionControl* getInstance();
               virtual ~clSessionControl();
               virtual void vOnNewTunerState(midw_fi_tcl_e8_Tun_TunerHeader::tenType midwTunerHeader, unsigned char audioSink);
               virtual void vOnNewTunerBand(midw_fi_tcl_e8_Tun_TunerBand::tenType midwTunerBand);
               virtual void vOnNewTunerState(midw_ext_fi_tcl_e8_DAB_SourceState::tenType dabTunerState);
               virtual void vOnNewDabTunerState(tuner::common::enTunerState dabTunerState);
               virtual void vRequestMute(bool bMute, bool bInterrupt);
               virtual void vOnDirectFrequencyResult();
               void vOnServiceState(tuner::common::enTunerClient tunerClient, tuner::common::enTunerClientAvailability tunerClientAvailable);
               virtual void vOnNewTunerState(midw_fi_tcl_e8_Tun_TunerHeader::tenType midwTunerHeader, midw_fi_tcl_e8_Tun_MTCAudioSource::tenType midwTunerSource);
               bool bIsServiceUnAvailable(tuner::common::enSourceId tunerSourceId);
			   tuner::common::enSourceId oGetRequestedSource();
			   tuner::common::enSrcActivity oGetRequestedSourceActivity();
			   tuner::common::enSessionState oGetRequestedSourceState();
	           tuner::common::enSourceId getStoredPreviousSessionStateBeforeAnnoucementSrc();
	           tuner::common::enSrcActivity getStoredPreviousSessionStateBeforeAnnoucementSrcActivity();
			   bool bOnDirectFrequency(midw_fi_tcl_e8_Band::tenType midwTunerMasterBand, unsigned int directFrequency);
			   void vLearnForever(bool bBGorFGLearnForever);
			   void vTunerSetFGBGLearnForever(tuner::common::enSourceId tunerSourceId, bool bSupport);
               static clSessionControl* m_poSessionControl;
               tuner::common::enTunerState getActiveTunerState(tuner::common::enTunerClient tunerClient);
               tuner::common::enBand getActiveTunerBand();
			   void vSetSBRVariant(bool bSBRVariant);

            private:
               clSessionControl();
               tuner::common::enTunerState tunerState;
               tuner::common::enBand tunerBand;

         };

      }
   }
}
#endif // !defined(clSessionControl_h)
