/************************************************************************
* FILE:           clDABTunerImpl.h
* PROJECT:        G3g
* SW-COMPONENT:   TunerMaster
*----------------------------------------------------------------------
*
* DESCRIPTION:    Implementation of the Class clDABTunerImpl
*
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:

* Date           | Author                       		| Modification
* 27-Mar-2015  	 | pad1cob						        | Initial version.
																			
*************************************************************************/

#ifndef clDABTunerImpl_h
#define clDABTunerImpl_h


#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_SERVICEINFO
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_ERRORCODES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_FI_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE 
#include "midw_ext_fi_if.h"

#include "sessionManagement/clMidwTunerImpl.h"


class tunmstr_DABClient_Handler;
class tunmstr_MsgToHMI;
class tunmstr_TunerClientHandler;
class clConfigInterface;
namespace tuner
{
   namespace sessionManagement
   {
      namespace audio
      {
         class clTunerInterface;
         /**
          * @author pad1cob
          * @version 1.0
          * @created 27-Mar-2015 15:43:29
          */
         class clDABTunerImpl   : public tuner::sessionManagement::audio::clMidwTunerImpl
         {

            public:
               clDABTunerImpl(tunmstr_DABClient_Handler* poDABClientHandler , tunmstr_MsgToHMI* poTunerMsgToHMI, tunmstr_TunerClientHandler* poTunerClientHandler,
            		   clConfigInterface* poclConfigInterface);
               virtual ~clDABTunerImpl();
               virtual void vOnAllocate(tuner::common::enSourceId tunerSourceId, tunerString inputDevice);
               virtual void vSetTunerState(tuner::common::enSourceId tunerSourceId, tuner::common::enTunerState tunerState, bool bInformSourceChange);
               virtual void vChangeBand(tuner::common::enBand tunerBand);
               virtual void vOnMuteState(tuner::common::enSourceId tunerSourceId, tuner::common::enMuteState tunerMuteState);
               virtual void vSetFrequency(tuner::common::enBand tunerBand, unsigned int frequency);
               virtual void vOnSrcChangeCompleted( tuner::common::enSourceId tunerSourceId, bool bSetBandNone );
               virtual void vClearAnnouncementStates();
               virtual void vCancelAnnouncement();
               tunmstr_DABClient_Handler* m_poDABClientHandler;
               tunmstr_MsgToHMI* m_poTunerMsgToHMI;
               tunmstr_TunerClientHandler* m_poTunerClientHandler;
			   clConfigInterface* m_poclConfigInterface;
         };

      }
   }
}
#endif // !defined(clDABTunerImpl_h)
