/************************************************************************
* FILE:           clArlSourceImpl.h
* PROJECT:        G3g
* SW-COMPONENT:   TunerMaster
*----------------------------------------------------------------------
*
* DESCRIPTION:    Header contents of the Class clArlSourceImpl
*
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:

* Date           | Author                       		| Modification
* 27-Mar-2015  	 | pad1cob						        | Initial version.
																			
*************************************************************************/

#ifndef clArlSourceImpl_h
#define clArlSourceImpl_h

#define ARL_S_IMPORT_INTERFACE_GENERIC_AIL
#include "audio_routing_lib.h"

#include "sessionManagement/audio/clAudioSession.h"
#include "sessionManagement/audio/config/tunerSessionManagement.h"
#include "convTables/tunerArlMap.h"
#include "sessionManagement/audio/interface/clAudioInterface.h"
#include "announcements/interface/clAudioInterface.h"
class clConfigInterface;
namespace tuner
{
   namespace sessionManagement
   {
      namespace audio
      {
         /**
          * @author pad1cob
          * @version 1.0
          * @created 27-Mar-2015 15:43:29
          */
         class clArlSourceImpl : public arl_tclISource_AIL , public tuner::sessionManagement::audio::clAudioInterface
         {

            public:
               clArlSourceImpl(ail_tclAppInterface* poMainApp,clConfigInterface* poclConfigInterface);
               virtual ~clArlSourceImpl();

               /**
                *
                * @param enSrcNum
                * @param rfcoAllocRoute
                */
               virtual tBool bOnAllocate(arl_tenSource enSrcNum, const arl_tAllocRouteResult& rfcoAllocRoute);
               /**
                *
                * @param enSrcNum
                */
               virtual tBool bOnDeAllocate(arl_tenSource enSrcNum);
               /**
                *
                * @param enSrcNum
                * @param enMuteState
                */
               virtual tBool bOnMuteState(arl_tenSource enSrcNum, arl_tenMuteState enMuteState);
               /**
                *
                * @param enSrcNum
                * @param rfcoSrcActivity
                */
               virtual tBool bOnSrcActivity(arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity);

               virtual void vSetSrcAvailable(tuner::common::enSourceId,
            			tuner::common::enAudioSrcAvailability ,tuner::common::enAudioSourceAvailabiltyReason);
               virtual void vSendSrcChangeResult(tuner::common::enSourceId tunerSourceId, tuner::common::enSrcActivity tunerSourceActivity);
               virtual void vRequestMute(tuner::common::enSourceId tunerSourceId, tuner::common::enMuteState tunerMuteState);
               
               void vRequestSourceChange(tuner::common::enSourceId tunerSourceId, tuner::common::enSrcActivity tunerSourceActivity);
               tuner::common::enSourceId getActiveSource();
               tuner::common::enSrcActivity getActiveSourceActivity();
               tuner::common::enBand getActiveTunerBand();
               tuner::common::enSessionState getActiveSessionState();

               void vInit();
			   void vUpdateStreamRouterServiceState(tuner::common::enTunerClientAvailability tunerClientAvailable);
			   void vUpdateAudioSourceAvailabelStatus(arl_tenSource oSource,arl_tenSrcAvailability oSrcAvail,
					   arl_tenAvailabilityReason oAvailabilityReason);
			   void vResetAudioSessionStates();


            private:
               tuner::common::enSourceId activeTunerSourceId;
               tuner::common::enSrcActivity activeTunerSourceActivity;
               tuner::common::enBand activeTunerBand;
			   tuner::common::enTunerClientAvailability streamRouterServiceAvailable;
			   tuner::common::enSessionState activeSessionState;
			   clConfigInterface* m_poclConfigInterface;


         };

      }
   }
}
#endif // !defined(clArlSourceImpl_h)
