/************************************************************************
* FILE:           clArlSourceImpl.cpp
* PROJECT:        G3g
* SW-COMPONENT:   TunerMaster
*----------------------------------------------------------------------
*
* DESCRIPTION:    Implementation of the Class clArlSourceImpl
*
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:

* Date           | Author                       		| Modification
* 27-Mar-2015  	 | pad1cob						        | Initial version.
																			
*************************************************************************/

#include "sessionManagement/clArlSourceImpl.h"

#include "common/tuner_trace.h"
#include "kdsconfig/clConfigInterface.h"

using namespace tuner::sessionManagement::audio;
using namespace tuner::common;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNER_TRACE_CLASS_SESSIONMANAGEMENT
#include "trcGenProj/Header/clArlSourceImpl.cpp.trc.h"
#endif


clArlSourceImpl::clArlSourceImpl(ail_tclAppInterface* poMainApp,clConfigInterface* poclConfigInterface)
   : arl_tclISource_AIL(poMainApp)
, activeTunerSourceId(tuner::common::SOURCEID_LIMIT)
, activeTunerSourceActivity(tuner::common::SRCACTIVITY_UNKNOWN)
, activeTunerBand(tuner::common::BAND_LIMIT)
, streamRouterServiceAvailable(tuner::common::TUNERCLIENTAVAILABITY_LIMIT)
,activeSessionState(tuner::common::SESSIONSTATE_LIMIT)
,m_poclConfigInterface(poclConfigInterface)
{


}



clArlSourceImpl::~clArlSourceImpl(){

}


tBool clArlSourceImpl::bOnAllocate(arl_tenSource enSrcNum, const arl_tAllocRouteResult& rfcoAllocRoute){

   tunerString inputDevice("");
   if (rfcoAllocRoute.listOutputDev.strALSADev.size())
   {
      inputDevice = rfcoAllocRoute.listOutputDev.strALSADev[0].szValue;
   }
   return clAudioSession::instance()->bOnAllocate(getTunerSourceId(enSrcNum), inputDevice);
}


tBool clArlSourceImpl::bOnDeAllocate(arl_tenSource enSrcNum){

   return clAudioSession::instance()->bOnDeAllocate(getTunerSourceId(enSrcNum));
}


tBool clArlSourceImpl::bOnMuteState(arl_tenSource enSrcNum, arl_tenMuteState muteState){

	return clAudioSession::instance()->bOnMuteState(getTunerSourceId(enSrcNum), getTunerMuteState(muteState));
}


tBool clArlSourceImpl::bOnSrcActivity(arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity){
	ETG_TRACE_USR4(("bOnSrcActivity: streamRouterServiceAvailable      = %d rfcoSrcActivity =%d,",streamRouterServiceAvailable,getTunerSrcActivity(rfcoSrcActivity)));
	if((streamRouterServiceAvailable ==tuner::common::UNAVAILABLE) && (getTunerSrcActivity(rfcoSrcActivity)==tuner::common::SRCOFF))
	{
		vSourceActivityResult(enSrcNum,rfcoSrcActivity);
		return true;
	}
	else
	{
		activeSessionState = tuner::common::SRC_CHANGE_IN_PROGRESS;
		return clAudioSession::instance()->bOnSrcActivity(getTunerSourceId(enSrcNum), getTunerSrcActivity(rfcoSrcActivity));
	}
}


void clArlSourceImpl::vSetSrcAvailable(tuner::common::enSourceId tunerSourceId,
		tuner::common::enAudioSrcAvailability AudioSrcAvailability ,tuner::common::enAudioSourceAvailabiltyReason AudioSourceAvailabiltyReason){

	ETG_TRACE_USR4(("Audio Source Availability: SourceId      = %d\n", ETG_ENUM(TUNER_SOURCE, (tU8)tunerSourceId)));
	ETG_TRACE_USR4(("Audio Source Availability: Availability   = %d\n", ETG_ENUM(AUDIO_SOURCE_AVAILABILITY, (tU8)AudioSrcAvailability)));
	ETG_TRACE_USR4(("Audio Source Availability: Reason   = %d\n", ETG_ENUM(AUDIO_SOURCE_AVAILABILITY_REASON, (tU8)AudioSourceAvailabiltyReason)));

	bSetSourceAvailability(getArlSourceAvailibility(AudioSrcAvailability),getArlSourceAvailibilityReason(AudioSourceAvailabiltyReason),getArlSourceNumber(tunerSourceId));
}

void clArlSourceImpl::vSendSrcChangeResult(tuner::common::enSourceId tunerSource, tuner::common::enSrcActivity tunerSourceActivity){

	vSourceActivityResult(getArlSourceNumber(tunerSource), getArlActivity(tunerSourceActivity) );
	if(bIsTemporarySource(tunerSource))	//NCG3D-63092 - Update AudioRouteREquest property only for temporary sources
	{
		vRequestSourceChange(tunerSource, tunerSourceActivity);
	}
	activeTunerSourceId = tunerSource;
	activeTunerSourceActivity = tunerSourceActivity;
	activeSessionState = tuner::common::SRC_CHANGE_COMPLETED;
	ETG_TRACE_USR4(("Source Change Result Sent to ARL: SourceId      = %d\n", ETG_ENUM(TUNER_SOURCE, (tU8)tunerSource)));
	ETG_TRACE_USR4(("Source Change Result Sent to ARL: SrcActivity   = %d\n", ETG_ENUM(TUNER_SRCACTIVITY, (tU8)tunerSourceActivity)));
}


void clArlSourceImpl::vRequestMute(tuner::common::enSourceId tunerSource, tuner::common::enMuteState tunerMuteState){

	if(m_poclConfigInterface != nullptr)
	{
		if(m_poclConfigInterface->u32GetConfigData("SBR"))
		{
			(void)clAudioSession::instance()->bOnMuteState(tunerSource,tunerMuteState);
			return;
		}
	}
	bSetMuteState(getArlSourceNumber(tunerSource), getArlMuteAction(tunerMuteState), getArlMuteReason(tunerSource) );
	ETG_TRACE_USR4(("Mute Request Sent to ARL: SourceId      = %d\n", ETG_ENUM(TUNER_SOURCE, (tU8)tunerSource)));
	ETG_TRACE_USR4(("Mute Request Sent to ARL: SrcActivity   = %d\n", ETG_ENUM(TUNER_MUTESTATES, (tU8)tunerMuteState)));
}


void clArlSourceImpl::vRequestSourceChange(tuner::common::enSourceId tunerSource, tuner::common::enSrcActivity tunerSourceActivity){

	bSetAudioRouteRequest(getArlSourceNumber(tunerSource), getArlActivity(tunerSourceActivity) );
}


tuner::common::enSourceId clArlSourceImpl::getActiveSource(){
ETG_TRACE_USR4(("getActiveSource: SourceId      = %d\n", ETG_ENUM(TUNER_SOURCE, (tU8)activeTunerSourceId)));
	return activeTunerSourceId;
}
tuner::common::enBand clArlSourceImpl::getActiveTunerBand(){

	return oGetBand(activeTunerSourceId);
}

tuner::common::enSrcActivity clArlSourceImpl::getActiveSourceActivity(){

	return activeTunerSourceActivity;
}

tuner::common::enSessionState clArlSourceImpl::getActiveSessionState()
{
	return activeSessionState;
}
void clArlSourceImpl::vInit(){

   clAudioSession::instance()->vInit();
}

void clArlSourceImpl::vUpdateAudioSourceAvailabelStatus(arl_tenSource oSource,arl_tenSrcAvailability oSrcAvail,
		   arl_tenAvailabilityReason oAvailabilityReason)
{
	clAudioSession::instance()->vInformSourceAvailability(getTunerSourceId(oSource),getAudioSourceAvailabilty(oSrcAvail),getAudioSourceAvailabiltyReason(oAvailabilityReason));
}

void clArlSourceImpl::vUpdateStreamRouterServiceState(tuner::common::enTunerClientAvailability enstreamRouterServiceAvailable)
 {
	 ETG_TRACE_USR4(("vUpdateStreamRouterServiceState: streamRouterServiceAvailable      = %d",enstreamRouterServiceAvailable));
	streamRouterServiceAvailable =enstreamRouterServiceAvailable;
	if(streamRouterServiceAvailable ==tuner::common::UNAVAILABLE)
	{
		clAudioSession::instance()->vDeInit();
	}
	else
	{
		clAudioSession::instance()->vInit();
	}
	
 }
void clArlSourceImpl::vResetAudioSessionStates()
{
	clAudioSession::instance()->vDeInit();
}