/************************************************************************
* FILE:           midwTunerMap.h
* PROJECT:        G3g
* SW-COMPONENT:   FC_TunerMaster.
*----------------------------------------------------------------------
*
* DESCRIPTION:    
*
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date            | Author                       		 | Modification

*************************************************************************/


#ifndef midwTunerMap_h
#define midwTunerMap_h


#include "datatypes/tVector.h"
#include "sessionManagement/audio/config/tunerSessionManagement.h"
#include "announcements/config/tunerAnnouncements.h"
#include "datatypes/tunerDatatypes.h"

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_SERVICEINFO
#include "midw_fi_if.h"

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_SERVICEINFO
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_ERRORCODES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_FI_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

#define READ_DRM_MODULATION_BIT 0x80000000
#define LW_BIT_SET 0x00000002
#define MW_BIT_SET 0x00000004
#define LW_MW_BITS_SET 0x00000006

#include "midw_ext_fi_if.h"


namespace tuner
{
   namespace sessionManagement
   {
      namespace audio
      {

         struct stMidwTunerStateMap
         {
            tuner::common::enTunerState tunerState;
            midw_fi_tcl_e8_Tun_SubCommand::tenType midwSubCommand;
            bool bMidwTunerState;
            midw_fi_tcl_e8_Tun_TunerHeader::tenType midwTunerHeader;
         };

         struct stMidwTunerSourceMap
         {
            tuner::common::enSourceId tunerSourceId;
            midw_fi_tcl_e8_Tun_TunerHeader::tenType midwTunerHeader;
            midw_fi_tcl_e8_Tun_AudioSink::tenType midwAudioSink;
            midw_fi_tcl_e8_Tun_PhysicalTuner::tenType midwPhysicalTuner;
            bool bUpdateAudioDevice;
            unsigned char modulationSwitch;
            midw_fi_tcl_e8_Band::tenType midwTunermasterBand;
         };

         struct stMidwTunerBandMap
         {
            tuner::common::enBand tunerBand;
            midw_fi_tcl_e8_Tun_TunerBand::tenType midwTunerBand;
         };

         struct stMidwDabTunerStateMap
         {
            tuner::common::enTunerState tunerState;
            midw_ext_fi_tcl_e8_DAB_SourceState::tenType midwDabTunerState;
         };

         struct stMidwDabTunerSourceMap
         {
        	tuner::common::enSourceId tunerSourceId;
        	midw_ext_fi_tcl_e8_DAB_Source::tenType midwDabSource;
         };

         struct stMidwDabTunerMuteStateMap
         {
        	tuner::common::enMuteState tunerMuteState;
        	midw_ext_fi_tcl_e8_DAB_MuteStatus::tenType midwDabMuteState;
         };

         struct stMidwDABAnnoSurvivellenceStateMap
         {
        	 tuner::common::enSourceId tunerSourceId;
        	 bool bDABAnnoSurvivellencesSupported;
         };
      }
   }
   namespace announcements
   {

      struct stMidwTunerAnnouncementsMap
      {
         tuner::common::enAnnouncement tunerAnnouncement;
         midw_fi_tcl_e8_Anno_Message::tenType midwTunerAnnoMessage;
         tuner::common::enSrcActivity tunerSrcActivity;
         tuner::common::enSourceId tunerSourceId;
      };

      struct stMidwTunerAnnouncementResponseMap
      {
         tuner::common::enAnnouncement tunerAnnouncement;
         midw_fi_tcl_e8_Tun_TunerHeader::tenType midwTunerHeader;
         midw_fi_tcl_e8_Tun_AudioSink::tenType midwAudioSink;
         midw_fi_tcl_e8_Tun_PhysicalTuner::tenType midwPhysicalTuner;
         bool bUpdateAudioDevice;
         midw_fi_tcl_e8_Tun_AnnoTypes::tenType midwAnnoType;
		 unsigned char tunerMasterAnnoType;
      };

      struct stMidwTunerSrcActivityMap
      {
         tuner::common::enSrcActivity tunerSrcActivity;
         tuner::common::enTunerState tunerState;
         midw_fi_tcl_e8_Tun_SubCommand::tenType midwSubCommand;
         bool bMidwTunerState;
         midw_fi_tcl_e8_Tun_TunerHeader::tenType midwTunerHeader;
         midw_fi_tcl_e8_Tun_DRMSourceActivity::tenType midwSrcActivity;

      };

      struct stMidwTunerTpStateMap
      {
          tuner::common::enTpState tunerTpState;
    	  midw_fi_tcl_e8_AtStationTPinfo::tenType midwTpState;
      };


      struct stMidwDabAnnouncementsMap
      {
         tuner::common::enAnnouncement tunerAnnouncement;
         unsigned short midwAnnoType;
         tuner::common::enSourceId tunerSourceId;
         unsigned short tunerMasterAnnoType;
      };

      struct stMidwDabAnnouncementStateMap
      {
         midw_ext_fi_tcl_e8_DAB_AnnouncementStatus::tenType midwDabAnnouncementState;
         tuner::common::enSrcActivity tunerSrcActivity;
         bool bSelect;
      };

   }
   namespace MTCAudioSource
   {
   	   struct stMTCAudioSource
	   {
   		   tuner::common::enAnnouncement tunerAnnouncement;
   		   tuner::common::enSourceId tunerSourceId;
   		   tuner::common::enBand tunerBand;
   		   midw_fi_tcl_e8_Tun_MTCAudioSource::tenType MTCAudioSourceId;
	   };
   }
}

midw_fi_tcl_e8_Tun_SubCommand::tenType getMidwTunerSubCommand(tuner::common::enTunerState tunerState);
bool getMidwTunerState(tuner::common::enTunerState tunerState);

midw_fi_tcl_e8_Tun_TunerHeader::tenType getMidwTunerHeader(tuner::common::enSourceId tunerSourceId);
midw_fi_tcl_e8_Tun_AudioSink::tenType getMidwAudioSink(tuner::common::enSourceId tunerSourceId);
midw_fi_tcl_e8_Tun_PhysicalTuner::tenType getMidwPhysicalTuner(tuner::common::enSourceId tunerSourceId);
midw_fi_tcl_e8_Tun_TunerBand::tenType getMidwBand(tuner::common::enBand tunerBand);
bool bSendAudioDeviceInformation(tuner::common::enSourceId tunerSourceId);
unsigned char getModulationSwitch(tuner::common::enSourceId tunerSourceId);

tuner::common::enTunerState getTunerState(midw_fi_tcl_e8_Tun_TunerHeader::tenType midwTunerHeader);
tuner::common::enTunerState getTunerState(midw_ext_fi_tcl_e8_DAB_SourceState::tenType midwDabTunerState);
tuner::common::enBand getTunerBand(midw_fi_tcl_e8_Tun_TunerBand::tenType midwTunerBand);

tuner::common::enAnnouncement getAnnouncement( midw_fi_tcl_e8_Anno_Message::tenType midwTunerAnnoMessage);
tuner::common::enSrcActivity getSrcActivity( midw_fi_tcl_e8_Anno_Message::tenType midwTunerAnnoMessage);
tuner::common::enSourceId getTunerSourceId( midw_fi_tcl_e8_Anno_Message::tenType midwTunerAnnoMessage);
bool bIsDABForeGroundAnnouncementSurvivellenceModeSupport(tuner::common::enSourceId tunerSourceId);


midw_ext_fi_tcl_e8_DAB_SourceState::tenType getMidwDabTunerState(tuner::common::enTunerState tunerState);
midw_ext_fi_tcl_e8_DAB_Source::tenType getMidwDabSource(tuner::common::enSourceId tunerSourceId);
midw_ext_fi_tcl_e8_DAB_MuteStatus::tenType getMidwDabMuteState(tuner::common::enMuteState tunerMuteState);

tunerVector<tuner::announcements::stTunerAnnouncementInformation> oGetAnnouncementList(std::vector<midw_ext_fi_tcl_DAB_AnnoElement> midwDabAnnouncementList);

tuner::common::enAnnouncement getAnnouncement( unsigned short midwAnnoType);
tuner::common::enSrcActivity getSrcActivity( midw_ext_fi_tcl_e8_DAB_AnnouncementStatus::tenType midwDabAnnouncementState);
tuner::common::enSourceId getTunerSourceId( unsigned short midwAnnoType);
tuner::common::enSourceId getTunerSourceId(midw_fi_tcl_e8_Band::tenType midwTunermasterBand);

midw_fi_tcl_e8_Tun_TunerHeader::tenType getMidwTunerHeader(tuner::common::enAnnouncement tunerAnnouncement);
midw_fi_tcl_e8_Tun_AudioSink::tenType getMidwAudioSink(tuner::common::enAnnouncement tunerAnnouncement);
midw_fi_tcl_e8_Tun_PhysicalTuner::tenType getMidwPhysicalTuner(tuner::common::enAnnouncement tunerAnnouncement);
midw_fi_tcl_e8_Tun_AnnoTypes::tenType getMidwAnnoType(tuner::common::enAnnouncement tunerAnnouncement);


midw_fi_tcl_e8_Tun_SubCommand::tenType getMidwTunerSubCommand(tuner::common::enSrcActivity tunerSrcActivity);
midw_fi_tcl_e8_Tun_DRMSourceActivity::tenType getMidwSrcActivity(tuner::common::enSrcActivity tunerSrcActivity);
bool getMidwTunerState(tuner::common::enSrcActivity tunerSrcActivity);
tuner::common::enSrcActivity getSrcActivity(tuner::common::enTunerState tunerState);

unsigned short getDabAnnouncementType(tuner::common::enAnnouncement);
unsigned short getDABTunerMasterAnnouncement(tuner::common::enAnnouncement tunerAnnouncement);
unsigned char getAMFMTunerMasterAnnouncement(tuner::common::enAnnouncement tunerAnnouncement);
bool getSelectValue(tuner::common::enSrcActivity tunerSrcActivity);
void vSetMidwTunerSource(tU32 u32CombiBand, tU32 u32AvailableBand);
void vSetCB1forDRMandBandForAM(tU32 u32CombiBand, tU32 u32AvailableBand);
void vSetNoneforDRMandBandForAM(tU32 u32CombiBand, tU32 u32AvailableBand);

tuner::common::enTpState getTunerTpState( midw_fi_tcl_e8_AtStationTPinfo::tenType midwTpState);

midw_fi_tcl_e8_Tun_TunerHeader::tenType getMidwTunerHeader(tuner::common::enTunerState tunerState);
midw_fi_tcl_e8_Tun_MTCAudioSource::tenType getMTCAudioSource(tuner::common::enBand tunerBand, tuner::common::enSourceId tunerSourceId);
midw_fi_tcl_e8_Tun_MTCAudioSource::tenType getMTCAudioSource(tuner::common::enAnnouncement tunerAnnouncement);
tuner::common::enSourceId getTunerSourceId(midw_fi_tcl_e8_Tun_MTCAudioSource::tenType midwMTCSourceId);

#endif // midwTunerMap_h
