#include "antDiagMap.h"
static const stantDiagMax20084ILimReg astantDiagMax20084ILimReg[] =
{
	#define ANTDIAG_MAX20084_ILIM_REG_VALUE(ILIMRgBitVal, ILimVal)                  { ILIMRgBitVal, ILimVal},
	#include "antDiagMap.dat"
	#undef ANTDIAG_MAX20084_ILIM_REG_VALUE

};

static const stantDiagMax20084OverIReg astantDiagMax20084OverIReg[] =
{
	#define ANTDIAG_MAX20084_OVERI_REG_VALUE(OverIRgBitVal, OverIVal)                  { OverIRgBitVal, OverIVal},
	#include "antDiagMap.dat"
	#undef ANTDIAG_MAX20084_OVERI_REG_VALUE

};

static const stantDiagMax20084OpenIReg astantDiagMax20084OpenIReg[] =
{
	#define ANTDIAG_MAX20084_OPENI_REG_VALUE(OpenIRgBitVal, OpenIVal)                  { OpenIRgBitVal, OpenIVal},
	#include "antDiagMap.dat"
	#undef ANTDIAG_MAX20084_OPENI_REG_VALUE

};

static const stantDiagMax20084WarIReg astantDiagMax20084WarIReg[] =
{
	#define ANTDIAG_MAX20084_WARI_REG_VALUE(WarIRgBitVal, WarIVal)                  { WarIRgBitVal, WarIVal},
	#include "antDiagMap.dat"
	#undef ANTDIAG_MAX20084_WARI_REG_VALUE

};

static const stantDiagMax20084OutVReg astantDiagMax20084OutVReg[] =
{
	#define ANTDIAG_MAX20084_OUTPUTV_REG_VALUE(OutVRgBitVal, OutVVal)                  { OutVRgBitVal, (tFloat)OutVVal},
	#include "antDiagMap.dat"
	#undef ANTDIAG_MAX20084_OUTPUTV_REG_VALUE

};

tU8 u8GetMax20084ILimRegBitVal(tU16 u16ILim)
{
   const int u32Size = sizeof astantDiagMax20084ILimReg / sizeof(stantDiagMax20084ILimReg);
   for (int u32Index = 0; u32Index < u32Size; u32Index++)
   {
      if (astantDiagMax20084ILimReg[u32Index].u16ILim == u16ILim)
      {
         return astantDiagMax20084ILimReg[u32Index].u8RegBitVal;
      }
	  if( u32Index != 0)
	  {
		if ((astantDiagMax20084ILimReg[u32Index].u16ILim > u16ILim) && (astantDiagMax20084ILimReg[u32Index-1].u16ILim < u16ILim))
		{
			return astantDiagMax20084ILimReg[u32Index].u8RegBitVal;
		}
		else if((u32Index == u32Size-1) && (u16ILim > astantDiagMax20084ILimReg[u32Index].u16ILim ))
		{
			return astantDiagMax20084ILimReg[u32Index].u8RegBitVal;
		}
	  }
   }
   return astantDiagMax20084ILimReg[0].u8RegBitVal;
}
tU8 u8GetMax20084OverIRegBitVal(tU16 u16OverI)
{
   const int u32Size = sizeof astantDiagMax20084OverIReg / sizeof(stantDiagMax20084OverIReg);
   for (int u32Index = 0; u32Index < u32Size; u32Index++)
   {
      if (astantDiagMax20084OverIReg[u32Index].u16OverI == u16OverI)
      {
         return astantDiagMax20084OverIReg[u32Index].u8RegBitVal;
      }
	  if( u32Index != 0)
	  {
		if ((astantDiagMax20084OverIReg[u32Index].u16OverI > u16OverI) && (astantDiagMax20084OverIReg[u32Index-1].u16OverI < u16OverI))
		{
			return astantDiagMax20084OverIReg[u32Index].u8RegBitVal;
		}
		else if((u32Index == u32Size-1) && (u16OverI > astantDiagMax20084OverIReg[u32Index].u16OverI ))
		{
			return astantDiagMax20084OverIReg[u32Index].u8RegBitVal;
		}
	  }
   }
   return astantDiagMax20084OverIReg[0].u8RegBitVal;
}
tU8 u8GetMax20084OpenIRegBitVal(tU16 u16OpenI)
{
   const int u32Size = sizeof astantDiagMax20084OpenIReg / sizeof(stantDiagMax20084OpenIReg);
   for (int u32Index = 0; u32Index < u32Size; u32Index++)
   {
      if (astantDiagMax20084OpenIReg[u32Index].u16OpenI == u16OpenI)
      {
         return astantDiagMax20084OpenIReg[u32Index].u8RegBitVal;
      }
	  if( u32Index != 0)
	  {
		if ((astantDiagMax20084OpenIReg[u32Index].u16OpenI > u16OpenI) && (astantDiagMax20084OpenIReg[u32Index-1].u16OpenI < u16OpenI))
		{
			return astantDiagMax20084OpenIReg[u32Index].u8RegBitVal;
		}
		else if((u32Index == u32Size-1) && (u16OpenI > astantDiagMax20084OpenIReg[u32Index].u16OpenI ))
		{
			return astantDiagMax20084OpenIReg[u32Index].u8RegBitVal;
		}
	  }
   }
   return astantDiagMax20084OpenIReg[0].u8RegBitVal;
}
tU8 u8GetMax20084WarIRegBitVal(tU16 u16WarI)
{
   const int u32Size = sizeof astantDiagMax20084WarIReg / sizeof(stantDiagMax20084WarIReg);
   for (int u32Index = 0; u32Index < u32Size; u32Index++)
   {
      if (astantDiagMax20084WarIReg[u32Index].u16WarI == u16WarI)
      {
         return astantDiagMax20084WarIReg[u32Index].u8RegBitVal;
      }
	  if( u32Index != 0)
	  {
		if ((astantDiagMax20084WarIReg[u32Index].u16WarI > u16WarI) && (astantDiagMax20084WarIReg[u32Index-1].u16WarI < u16WarI))
		{
			return astantDiagMax20084WarIReg[u32Index].u8RegBitVal;
		}
		else if((u32Index == u32Size-1) && (u16WarI > astantDiagMax20084WarIReg[u32Index].u16WarI ))
		{
			return astantDiagMax20084WarIReg[u32Index].u8RegBitVal;
		}
	  }
   }
   return astantDiagMax20084WarIReg[0].u8RegBitVal;
}
tU8 u8GetMax20084OutVRegBitVal(tFloat fOutV)
{   
   const int u32Size = sizeof astantDiagMax20084OutVReg / sizeof(stantDiagMax20084OutVReg);
   for (int u32Index = 0; u32Index < u32Size; u32Index++)
   {
      if (astantDiagMax20084OutVReg[u32Index].fOutV == fOutV)
      {
         return astantDiagMax20084OutVReg[u32Index].u8RegBitVal;
      }
	  if( u32Index != 0)
	  {
		if ((astantDiagMax20084OutVReg[u32Index].fOutV > fOutV) && (astantDiagMax20084OutVReg[u32Index-1].fOutV < fOutV))
		{
			return astantDiagMax20084OutVReg[u32Index].u8RegBitVal;
		}
		else if((u32Index == u32Size-1) && (fOutV > astantDiagMax20084OutVReg[u32Index].fOutV ))
		{
			return astantDiagMax20084OutVReg[u32Index].u8RegBitVal;
		}
	  }
   }
   return astantDiagMax20084OutVReg[0].u8RegBitVal;
	
}
