
/************************************************************************
* FILE:           clAudioImpl.cpp
* PROJECT:        G3g
* SW-COMPONENT:   fc_tunermaster
*----------------------------------------------------------------------
*
* DESCRIPTION:    Implementation of the Class clAudioImpl
*
*----------------------------------------------------------------------
* COPYRIGHT: (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date        | Author		 | Modification
* 27-Mar-2015 | pad1cob      | 
*************************************************************************/

#include "announcements/clAudioImpl.h"
#include "sessionManagement/clArlSourceImpl.h"

#include "common/tuner_trace.h"

using namespace tuner::common;
using namespace tuner::announcements;

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNER_TRACE_CLASS_ANNOUNCEMENTS
#include "trcGenProj/Header/clAudioImpl.cpp.trc.h"
#endif

clAudioImpl::clAudioImpl(tuner::sessionManagement::audio::clArlSourceImpl* poArlSourceImpl)
   : m_poArlSourceImpl(poArlSourceImpl)
{
	requestedSourceId = tuner::common::SOURCEID_LIMIT;
	requestedSourceActivity = tuner::common::SRCACTIVITY_UNKNOWN;
}



clAudioImpl::~clAudioImpl(){
	m_poArlSourceImpl = 0;
}


void clAudioImpl::vRequestSourceChange(tuner::common::enSourceId tunerSourceId, tuner::common::enSrcActivity tunerSourceActivity){

	ETG_TRACE_USR4(("AudioRouteRequest: SourceId      = %d\n", ETG_ENUM(TUNER_SOURCE, (tU8)tunerSourceId)));
	ETG_TRACE_USR4(("AudioRouteRequest: SrcActivity      = %d\n", ETG_ENUM(TUNER_SRCACTIVITY, (tU8)tunerSourceActivity)));
	m_poArlSourceImpl->vRequestSourceChange(tunerSourceId, tunerSourceActivity);
	requestedSourceId = tunerSourceId;
	requestedSourceActivity = tunerSourceActivity;
}

tuner::common::enSourceId clAudioImpl::getActiveSource(){

   return m_poArlSourceImpl->getActiveSource();
}

tuner::common::enSrcActivity clAudioImpl::getActiveSourceActivity(){

   return m_poArlSourceImpl->getActiveSourceActivity();
}

tuner::common::enSourceId clAudioImpl::getRequestedSource() {

	return requestedSourceId;
}

tuner::common::enSrcActivity clAudioImpl::getRequestedSourceActivity() {

	return requestedSourceActivity;
}
