
/************************************************************************
* FILE:           clAnnouncementControl.cpp
* PROJECT:        G3g
* SW-COMPONENT:   fc_tunermaster
*----------------------------------------------------------------------
*
* DESCRIPTION:    Implementation of the Class clAnnouncementControl
*
*----------------------------------------------------------------------
* COPYRIGHT: (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date        | Author		 | Modification
* 27-Mar-2015 | pad1cob      | 
*************************************************************************/


#include "announcements/clAnnouncementControl.h"
#include "announcements/clAnnouncements.h"
#include "announcements/clAnnouncementSettings.h"
#include "convTables/midwTunerMap.h"
#include "common/tuner_trace.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNER_TRACE_CLASS_ANNOUNCEMENTS
#include "trcGenProj/Header/clAnnouncementControl.cpp.trc.h"
#endif

using namespace tuner::announcements;
using namespace tuner::common;


clAnnouncementControl::clAnnouncementControl() :bTPState(false), streamRouterServiceAvailable(tuner::common::UNAVAILABLE){
   
   clAnnouncementSettings::instance();

}



clAnnouncementControl::~clAnnouncementControl(){

}


void clAnnouncementControl::vOnNewAnnouncementMessage(midw_fi_tcl_e8_Anno_Message::tenType midwTunerAnnoMessage,tuner::common::enSourceId tunerSourceId,tuner::common::enSrcActivity tunerSrcActivity){

	if(getSrcActivity(midwTunerAnnoMessage) != tuner::common::SRCACTIVITY_UNKNOWN)
	{
		if(bIsRepeatedAnnouncementRequest(midwTunerAnnoMessage) == false)
		{
			ETG_TRACE_USR4(("clAnnouncementControl::vOnNewAnnouncementMessage getAnnouncement =%d getSrcActivity =%d",
			         getAnnouncement(midwTunerAnnoMessage),getSrcActivity(midwTunerAnnoMessage)));
			clAnnouncements::instance()->vOnNewAnnouncementRequest(getAnnouncement(midwTunerAnnoMessage), getSrcActivity(midwTunerAnnoMessage), getTunerSourceId(midwTunerAnnoMessage),tunerSourceId,tunerSrcActivity);
		}
	}
}

bool clAnnouncementControl::bIsRepeatedAnnouncementRequest(midw_fi_tcl_e8_Anno_Message::tenType midwTunerAnnoMessage)
{
	if(getAnnouncement(midwTunerAnnoMessage) == clAnnouncements::instance()->oGetActiveAnnouncementId()
			&& getSrcActivity(midwTunerAnnoMessage) == clAnnouncements::instance()->oGetActiveAnnouncementActivity()
			&& clAnnouncements::instance()->oGetActiveAnnouncementState() != tuner::announcements::clAnnouncementState::ANNOUNCEMENT_COMPLETED)
	{
		return true;
	}
	else
	{
		return false;
	}
}


void clAnnouncementControl::vOnNewAnnouncementList(std::vector<midw_ext_fi_tcl_DAB_AnnoElement> midwDabAnnouncementList,tuner::common::enSourceId tunerSourceId,tuner::common::enSrcActivity tunerSrcActivity){

      clAnnouncements::instance()->vOnNewAnnouncementList(oGetAnnouncementList(midwDabAnnouncementList),tunerSourceId,tunerSrcActivity);
}


void clAnnouncementControl::vSetAnnouncementPriority(tuner::common::enAnnouncement announcement, unsigned short priority){

	clAnnouncementSettings::instance()->vSetAnnouncementPriority(announcement, priority);
}


void clAnnouncementControl::vOnNewTpState(midw_fi_tcl_e8_Tun_TunerBand::tenType midwTunerBand, midw_fi_tcl_e8_AtStationTPinfo::tenType midwTpState) {

	clAnnouncementSettings::instance()->vOnNewTpState(getTunerBand(midwTunerBand), getTunerTpState(midwTpState));
}


void clAnnouncementControl::vOnNewTpState(tuner::common::enBand tunerBand, tuner::common::enTpState  tpState) {

	clAnnouncementSettings::instance()->vOnNewTpState(tunerBand, tpState);
}


void clAnnouncementControl::vOnSourceFollowingState(tuner::common::enBand tunerBand, bool bSourceFollowing) {

	clAnnouncementSettings::instance()->vOnSourceFollowingState(tunerBand, bSourceFollowing);
}


void clAnnouncementControl::vSetTunerState(tuner::common::enSourceId tunerSourceId, tuner::common::enTunerState tunerState, bool bInformSourceChange){

	if(bInformSourceChange == true)
	{
		clAnnouncements::instance()->vOnSourceChangeResponse(tunerSourceId, tuner::common::SRCOFF, tunerState);
	}
	else
	{
		clAnnouncements::instance()->vOnSourceChangeResponse(tunerSourceId, getSrcActivity(tunerState), tunerState);
	}
}


void clAnnouncementControl::vCancelAnnouncement(midw_fi_tcl_StopAnnouncements::tenType /*midwCancelAnnouncement*/){

	clAnnouncements::instance()->vCancelAnnouncement();
}

void  clAnnouncementControl::vOnAllocate(tuner::common::enSourceId /*tunerSourceId */, tunerString /*inputDevice*/){

}


void clAnnouncementControl::vChangeBand(tuner::common::enBand /*tunerBand*/){

}

void clAnnouncementControl::vOnSrcChangeCompleted( tuner::common::enSourceId /*tunerSourceId */, bool /*bSetBandNone*/ ){

}

void clAnnouncementControl::vOnMuteState(tuner::common::enSourceId /*tunerSourceId*/, tuner::common::enMuteState /*tunerMuteState*/)
{

}

unsigned short clAnnouncementControl::oGetActiveMidwAnnouncementId()
{
	return getDabAnnouncementType(clAnnouncements::instance()->oGetActiveAnnouncementId());
}

void clAnnouncementControl::vSetFrequency(tuner::common::enBand /*tunerBand*/, unsigned int /*frequency*/)
{

}


void clAnnouncementControl::vSetModulationAndSrcActivity(tuner::common::enSourceId /*tunerSourceId*/, tuner::common::enSrcActivity /*tunerSrcActivity*/)
{

}

void clAnnouncementControl::vClearAnnouncementStates()
{
	clAnnouncements::instance()->vClearAnnouncementStates();
}

void clAnnouncementControl::vSetPICode(unsigned short piCode)
{
	clAnnouncements::instance()->vSetPICode(piCode);
}

unsigned short clAnnouncementControl::oGetPICode()
{
	return clAnnouncements::instance()->oGetPICode();
}

void clAnnouncementControl::vSetAnnouncementSwitch(bool TPState)
{
	bTPState = TPState;
}

bool clAnnouncementControl::bIsAnnouncementSwitchOn()
{
	return bTPState;
}


void clAnnouncementControl::vOnNewTunerState(midw_fi_tcl_e8_Tun_TunerHeader::tenType midwTunerHeader, unsigned char audioSink)
{
	if((midwTunerHeader == midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_TUN_FOREGROUND) &&
			!(audioSink == midw_fi_tcl_b8_Tun_AudioSink::FI_C_U8_BIT_USR1_SWITCHED_TUN_TOFG))
	{
		clAnnouncements::instance()->vOnNewTunerState(tuner::common::TAFG);
	}
	else
	{
		clAnnouncements::instance()->vOnNewTunerState(getTunerState(midwTunerHeader));
	}
}

void clAnnouncementControl::vOnNewTunerState(tuner::common::enTunerState dabTunerState)
{
	clAnnouncements::instance()->vOnNewTunerState(dabTunerState);
}

void clAnnouncementControl::vOnNewTunerState(midw_fi_tcl_e8_Tun_TunerHeader::tenType midwTunerHeader, midw_fi_tcl_e8_Tun_MTCAudioSource::tenType midwTunerSource)
{
	if((midwTunerHeader == midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_TUN_FOREGROUND) &&
			bIsTemporarySource(getTunerSourceId(midwTunerSource)))
	{
		clAnnouncements::instance()->vOnNewTunerState(tuner::common::TAFG);
	}
	else
	{
		clAnnouncements::instance()->vOnNewTunerState(getTunerState(midwTunerHeader));
	}
}

void clAnnouncementControl::vCancelAnnouncement()
{
	clAnnouncements::instance()->vCancelAnnouncement();
}
void clAnnouncementControl::vUpdateStreamRouterServiceState(tuner::common::enTunerClientAvailability enstreamRouterServiceAvailable)
 {
	 ETG_TRACE_USR4(("vUpdateStreamRouterServiceState: streamRouterServiceAvailable      = %d",enstreamRouterServiceAvailable));
	streamRouterServiceAvailable =enstreamRouterServiceAvailable;
	if(streamRouterServiceAvailable ==tuner::common::UNAVAILABLE)
	{
		clAnnouncements::instance()->vDeInit();
	}
	else
	{
		clAnnouncements::instance()->vInit();
	}
 }
void clAnnouncementControl::vResetAnnouncementsStates()
{
	clAnnouncements::instance()->vDeInit();
}