/************************************************************************
 * FILE:           tunmstr_TunerClientHandler.cpp
 * PROJECT:        G3g
 * SW-COMPONENT:   fc_tunermaster.
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:    To Handle CCA Messages sent from fc_amfmtuner
 *
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      	| Author                       | Modification
 * 30/11/2010	| (RBEI\ECV4) Pallavi          | initial version
 * 25.04.13  	| NGP1KOR    				   | First version of the G3g after porting from NISSAN LCN2Kai
				
 *************************************************************************/

//-----------------
// System includes
//-----------------
#ifdef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#include "ahl_mock/ahl_if.h"
#include "amt_mock/amt_if.h"
#else
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"


#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_SERVICEINFO
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" 

#include "fc_tunermaster_featureControl.h"
#include "tunmstr_TunerClientHandler.h"

#include "tunermaster_utility.h"
#include "tunermaster_PrjConfig.h"
#include "tunermaster_Config.h"
#include "tunermaster_main.h"
#include "tunermaster_defines.h"           // Contains all tmc related defines.
#include "tunmstr_SrcChg_Trace.h"
//#include "tunermaster_trace.h"   // Trace defines. 
#ifndef TUNMASTERMASTER_PRJCONFIG_H
#include "tunermaster_PrjConfig.h"
#endif

#include "tunmstr_SrcChg_Defines.h"
#include "tunmstr_DABClient_Handler.h"
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
#include "tunermaster_PMClient.h"
#endif
#include "tunmstr_SrcChgManager.h"
#ifndef tunmstr_Preset_Handler_H
#include "tunmstr_Preset_Handler.h"
#endif
#include "tunmstr_MsgToHMI.h"
#include "tunmstr_SrcChg_AnnoHandler.h"
#ifdef AUDIO_ACTIVE
#include "tunmstr_AudioClientHandler.h"
#endif
#include "tunmstr_AutoStorehandler.h"
#include "tunmstr_MuteHandler.h"
#include "kdsconfig/clConfigInterface.h"
#ifndef VARIANT_S_FTR_ENABLE_TUNERMASTER_MOCK
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#include "dp_tuner_if.h"
#endif
#include "tunmstr_SDSHandler.h"
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
#include "tunermaster_SXMClient.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNMSTR_TRACE_CLASS_TUNCLIENT_HANDLER
#include "trcGenProj/Header/tunmstr_TunerClientHandler.cpp.trc.h"
#endif

#include "convTables/midwTunerMap.h"
/* +++
MESSAGE MAP:
enter the function IDs (FID) and the corresponding functions here.
the function will be called when a message with the corresponding FID arrives
+++ */
BEGIN_MSG_MAP(tunmstr_TunerClientHandler, ahl_tclBaseWork)

//Properties

ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_ATSTATIONINFO,         					vHandle_g_AtStation_Info)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_ANNOUNCEMENT_MESSAGE,			vHandle_g_Announcement_Message )
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_ANNOUNCEMENT_SWITCH,			vHandle_g_Announcement_Switch )
//ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_COMPONENT_STATUS_TUNER ,		vHandle_g_Component_Status )
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_DIAG_REMOTE_CONTROL ,				vHandle_g_Remote_Control )
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_G_ANNOUNCEMENT_INFO,					vHandle_g_AnnouncementInfo )
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_G_GET_STATIC_LIST, 							vHandle_TunPresetList)
ON_MESSAGE(MIDW_TUNERFI_C_U16_FID_TUN_G_MUTE_REQUEST, vHandle_MuteRequest)


//Methods Results
//ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SET_RDBID,                 vHandle_s_SetRdbid)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_ACTIVE_TUNER,       vHandle_s_ActiveTuner)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_DIRECT_FREQUENCY,       vHandle_s_DirectFrequency)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_CHANGE_LSM,       vHandle_s_ChangeLsm)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SET_PI,       vHandle_s_SetPI)

// To handle Source change behaviour,Method results
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_AUDIO_FG_BG_NEW,           vHandle_s_AudioFgBg)
//ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_CHANGE_BAND,		            vHandle_s_BandChange)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_AUTOSTORE, vHandle_S_Autostore)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_PRESET_HANDLING, vHandle_s_HandlePresetMethodResult)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_AUDIO_DEVICE, vHandle_s_AudioDevice)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SET_DEMODULATION_SWITCH, vHandle_s_DemodSwitch)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_SET_DRM_SRCACTIVITY, vHandle_s_DRMSrcAct)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_DISABLE_BAND, vHandle_s_DisableBand)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_PRESET_STORAGE_PS_FREEZE,  	vHandle_s_PSFreezeResult )
/*Added to resolve double deletion */
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_GET_STATIC_LIST, vHandle_s_UnUsedMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_ANNOUNCEMENT_SWITCH, vHandle_s_UnUsedMessages)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_ANNOUNCEMENT_ESCAPE, vHandle_s_UnUsedMessages)
#ifdef INCLUDE_PROFILE_MANAGER
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_USER_PROFILE_UPDATE, vHandle_s_UserProfileUpdateResult)
ON_MESSAGE( MIDW_TUNERFI_C_U16_FID_TUN_S_PRESETLIST_CONTENT_UPDATE, vHandle_S_ProfilePresetListContentUpdateResult)
#endif
END_MSG_MAP()
/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::tunmstr_TunerClientHandler( )
 *
 * DESCRIPTION:  Constructor
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
tunmstr_TunerClientHandler::tunmstr_TunerClientHandler( tunmaster_tclApp* poMainApp, tuner::sessionManagement::audio::clArlSourceImpl* poArlImpl)
#else
tunmstr_TunerClientHandler::tunmstr_TunerClientHandler( tunmaster_tclApp* poMainApp)
#endif
{
	poGWMain = poMainApp;
	m_potunmaster_Config = NULL;
	m_poclConfigInterface = NULL;
	m_potunmstr_Utility = NULL;
	#ifdef AUDIO_ACTIVE
	m_potunmstr_AudioClientHandler = NULL;
	#endif
	m_potunmstr_SrcChgManager = NULL;
	m_potunmstr_MsgToHMI = NULL;
	m_potunmstr_DABClient_Handler = NULL;
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
	m_ptunmaster_PMClient = NULL;
#endif
	m_ptunmstr_Preset_Handler = NULL;
	m_ptunmstr_AutoStoreHandler = NULL;
	m_potunmstr_SrcChg_AnnoHandler = NULL;
	m_potunmstr_MsgFromHMI = NULL;
	m_potunmstr_MuteHandler = NULL;
	m_potunmstr_SDSHandler = NULL;
	m_u8ServiceAvailable_Tuner = TUNMASTER_INVALID;
	m_u16TunerRegID = AMT_C_U16_REGID_INVALID;
	m_blSendGetStaticListReq = FALSE;
	m_u8AnnoType = 0xff;
	m_bPTYState = FALSE;
	m_u8StationinfoBand = (tU8)midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_INVALID;
	m_u8StationinfoFreq = 0;
	m_bFromPMClient = false;
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	m_poSessionControl = clSessionControl::getInstance();
	m_poArlImpl = poArlImpl;
	m_u8TunerHeader=midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_TUN_BACKGROUND;
	m_u8AudioSink=0XFF;
#endif

	m_u8PresetAutocompare = 0xFF;
	m_bUserPresetAction = FALSE;
}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::~tunmstr_TunerClientHandler( )
 *
 * DESCRIPTION:  Destructor.
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tunmstr_TunerClientHandler::~tunmstr_TunerClientHandler( )                                  
{
	poGWMain = NULL;
	m_potunmstr_Utility = NULL;
	m_potunmaster_Config = NULL;
	m_poclConfigInterface = NULL;
#ifdef AUDIO_ACTIVE
	m_potunmstr_AudioClientHandler = NULL;
#endif
	m_potunmstr_SrcChgManager = NULL;
	m_potunmstr_MsgToHMI = NULL;
	m_potunmstr_DABClient_Handler = NULL;
	m_ptunmstr_Preset_Handler=NULL;
	m_potunmstr_MsgFromHMI=NULL;
	m_u8ServiceAvailable_Tuner = TUNMASTER_INVALID;
	m_ptunmstr_AutoStoreHandler = NULL;
	m_potunmstr_SrcChg_AnnoHandler = NULL;
	m_blSendGetStaticListReq=FALSE;
	m_potunmstr_MuteHandler = NULL;
	m_potunmstr_SDSHandler = NULL;
	m_bPTYState = FALSE;
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	m_poSessionControl = NULL;
	m_poArlImpl = NULL;
	m_u8TunerHeader=midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_TUN_BACKGROUND;
	m_u8AudioSink=0XFF;
#endif
	m_u8StationinfoBand = (tU8)midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_INVALID;
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
	m_ptunmaster_PMClient = NULL;
#endif

	m_u8PresetAutocompare = 0xFF;
	m_bUserPresetAction = FALSE;
}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vSet_tunmaster_Config_Ptr( )
 *
 * DESCRIPTION:   With this config data can be accessed
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vSet_tunmaster_Config_Ptr( tunmaster_Config* potunmaster_Config )
{
	if( potunmaster_Config != NULL )
	{
		m_potunmaster_Config = potunmaster_Config;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmaster_Config != NULL );
	}

}
#ifdef AUDIO_ACTIVE
/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vSet_tunmstr_AudioClientHandler_Ptr( )
 *
 * DESCRIPTION:  Get class tunmstr_AudioClientHandler pointer.
 *
 * PARAMETER:    tunmstr_AudioClientHandler* pointer
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunmstr_TunerClientHandler::vSet_tunmstr_AudioClientHandler_Ptr( tunmstr_AudioClientHandler* potunmstr_AudioClientHandler)
{
	if( potunmstr_AudioClientHandler != NULL )
	{
		m_potunmstr_AudioClientHandler = potunmstr_AudioClientHandler;
	}
	else
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT ( potunmstr_AudioClientHandler != NULL );
#endif

	}


}
#endif
/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vSet_tunmstr_Utility_Ptr( )
 *
 * DESCRIPTION:  Set pointer to class m_potunmstr_Utility.
 *
 * PARAMETER:    tVoid
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vSet_tunmstr_Utility_Ptr( tunmaster_Utility* potunmstr_Utility  )
{
	if( potunmstr_Utility != NULL )
	{
		m_potunmstr_Utility = potunmstr_Utility;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_Utility != NULL );
	}
}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vSet_tunmstr_SrcChgManager_Ptr( )
 *
 * DESCRIPTION:
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunmstr_TunerClientHandler::vSet_tunmstr_SrcChgManager_Ptr( tunmstr_SrcChgManager* potunmstr_SrcChgManager )
{
	if( potunmstr_SrcChgManager != NULL )
	{
		m_potunmstr_SrcChgManager = potunmstr_SrcChgManager;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_SrcChgManager != NULL );
	}
}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vSet_tunmstr_MsgToHMI_Ptr( )
 *
 * DESCRIPTION:
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunmstr_TunerClientHandler::vSet_tunmstr_MsgToHMI_Ptr( tunmstr_MsgToHMI* potunmstr_MsgToHMI )
{
	if( potunmstr_MsgToHMI != NULL )
	{
		m_potunmstr_MsgToHMI = potunmstr_MsgToHMI;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_MsgToHMI != NULL );
	}
}

/*************************************************************************
* FUNCTION:    vSet_tunmstr_ConfigInterface_Ptr
*
* DESCRIPTION:
*
* PARAMETER:   clConfigInterface* poclConfigInterface
*
* RETURNVALUE:  void
*************************************************************************/
tVoid tunmstr_TunerClientHandler::vSet_tunmstr_ConfigInterface_Ptr
(clConfigInterface* poclConfigInterface)
{
	if( poclConfigInterface != NULL )
	{
		m_poclConfigInterface = poclConfigInterface;
	}

}

/*************************************************************************
 *
 * FUNCTION:    vSet_tunmstr_DABClient_Handler_Ptr( tunmstr_DABClient_Handler* potunmstr_DABClient_Handler )
 *
 * DESCRIPTION: Set pointer to pointer tunmstr_DABClient_Handler
 *
 * PARAMETER:   tunmstr_DABClient_Handler* potunmstr_DABClient_Handler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunmstr_TunerClientHandler::vSet_tunmstr_DABClient_Handler_Ptr(tunmstr_DABClient_Handler* potunmstr_DABClient_Handler)
{
	if( potunmstr_DABClient_Handler != NULL )
	{
		m_potunmstr_DABClient_Handler = ( tunmstr_DABClient_Handler* )potunmstr_DABClient_Handler;
	}

}
/*************************************************************************
 *
 * FUNCTION:    vSet_PMClient_Handler_Ptr(tunermaster_PMClient* po_PMClient_Handler)
 *
 * DESCRIPTION: Set pointer to pointer tunermaster_PMClient
 *
 * PARAMETER:   tunermaster_PMClient* po_PMClient_Handler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
tVoid tunmstr_TunerClientHandler::vSet_PMClient_Handler_Ptr(tunermaster_PMClient* po_PMClient_Handler)
{
	if( NULL != po_PMClient_Handler  )
	{
		 m_ptunmaster_PMClient = ( tunermaster_PMClient* )po_PMClient_Handler;
	}
}
#endif
/*************************************************************************
 *
 * FUNCTION:    vSet_tunmstr_Preset_Handler_Ptr
 *
 * DESCRIPTION: Set pointer to pointer tunmstr_Preset_Handler
 *
 * PARAMETER:   tunmstr_Preset_Handler* potunmstr_Preset_Handler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunmstr_TunerClientHandler::vSet_tunmstr_Preset_Handler_Ptr(tunmstr_Preset_Handler* potunmstr_Preset_Handler)
{
	if( potunmstr_Preset_Handler != NULL )
	{
		m_ptunmstr_Preset_Handler = ( tunmstr_Preset_Handler* )potunmstr_Preset_Handler;
	}
}

/*************************************************************************
 *
 * FUNCTION:    vSet_tunmstr_AutoStoreHandler_Ptr
 *
 * DESCRIPTION: Set pointer to pointer tunmstr_Presethandler
 *
 * PARAMETER:   tunmstr_Presethandler* potunmstr_Presethandler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunmstr_TunerClientHandler::vSet_tunmstr_AutoStoreHandler_Ptr(tunmstr_AutoStoreHandler* potunmstr_AutoStoreHandler)
{
	if( potunmstr_AutoStoreHandler != NULL )
	{
		m_ptunmstr_AutoStoreHandler = ( tunmstr_AutoStoreHandler* )potunmstr_AutoStoreHandler;
	}
}
/*************************************************************************
 *
 * FUNCTION:    vSet_tunmstr_SrcChg_AnnoHandler_Ptr
 *
 * DESCRIPTION: Set pointer to pointer tunmstr_Presethandler
 *
 * PARAMETER:   tunmstr_Presethandler* potunmstr_Presethandler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vSet_tunmstr_SrcChg_AnnoHandler_Ptr(tunmstr_SrcChg_AnnoHandler* potunmstr_SrcChg_AnnoHandler)

{
	if( potunmstr_SrcChg_AnnoHandler != NULL )
	{
		m_potunmstr_SrcChg_AnnoHandler = ( tunmstr_SrcChg_AnnoHandler* )potunmstr_SrcChg_AnnoHandler;
	}
	else
	{
		NORMAL_M_ASSERT ( m_potunmstr_SrcChg_AnnoHandler != NULL );
	}
}
/*************************************************************************
 *
 * FUNCTION:    vSet_tunmstr_MuteHandler_Ptr
 *
 * DESCRIPTION: Set pointer to pointer tunmstr_Presethandler
 *
 * PARAMETER:   tunmstr_Presethandler* potunmstr_Presethandler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vSet_tunmstr_MuteHandler_Ptr(tunmstr_MuteHandler* potunmstr_MuteHandler)

{
	if( potunmstr_MuteHandler != NULL )
	{
		m_potunmstr_MuteHandler = ( tunmstr_MuteHandler* )potunmstr_MuteHandler;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_MuteHandler != NULL );
	}
}
/*************************************************************************
 *
 * FUNCTION:    vSet_tunmstr_MsgFromHMI_Ptr( tunmstr_MsgFromHMI* potunmstr_MsgFromHMI )
 *
 * DESCRIPTION:   Set pointer to pointer tunmstr_MsgFromHMI
 *
 * PARAMETER:    tunmstr_MsgFromHMI* potunmstr_MsgFromHMI
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vSet_tunmstr_MsgFromHMI_Ptr( tunmstr_MsgFromHMI* potunmstr_MsgFromHMI )
{
	if( potunmstr_MsgFromHMI != NULL )
	{
		m_potunmstr_MsgFromHMI = ( tunmstr_MsgFromHMI* )potunmstr_MsgFromHMI;
	}

}


/*************************************************************************
 *
 * FUNCTION:     tunmstr_MsgFromHMI::vSet_tunmstr_SDSHandler_Ptr( )
 *
 * DESCRIPTION:  Set pointer to class m_potunmstr_SDSHandler.
 *
 * PARAMETER:    tVoid
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vSet_tunmstr_SDSHandler_Ptr( tunmstr_SDSHandler* potunmstr_SDSHandler  )
{
	if( potunmstr_SDSHandler != NULL )
	{
		m_potunmstr_SDSHandler = potunmstr_SDSHandler;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_SDSHandler != NULL );
	}
}


#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vSet_tunmstr_SXMClient_Handler_Ptr( )
 *
 * DESCRIPTION:  Set pointer to pointer SXM client
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 ************************************************************************/
tVoid tunmstr_TunerClientHandler::vSet_tunmstr_SXMClient_Handler_Ptr(tunermaster_SXMClient* potunermaster_SXMClient)
{
	if( potunermaster_SXMClient != NULL )
	{
		m_potunermaster_SXMClient = potunermaster_SXMClient;
	}
	else
	{
		NORMAL_M_ASSERT ( m_potunermaster_SXMClient != NULL );
	}
}
#endif


/*************************************************************************************
 *
 *FUNCTION:     tunmstr_TunerClientHandler::vOnServiceState
 *
 *DESCRIPTION:  Handles the state changes of the service we use
 *
 *PARAMETER:    tU16,tU16,tU16,tU8,tU16,
 *
 *RETURNVALUE: None
 ************************************************************************************/
tVoid tunmstr_TunerClientHandler :: vOnServiceState(   tU16  u16ServiceId ,
		tU16  u16ServerId ,
		tU16  u16RegisterId,
		tU8   u8ServiceState,
		tU16  u16SubId      )
{
	if((u16ServiceId  !=  CCA_C_U16_SRV_TUNERCONTROL) ||(poGWMain == NULL) ||\
		(m_poclConfigInterface == NULL) || (m_potunmstr_DABClient_Handler == NULL) || (m_potunmstr_SrcChgManager == NULL)||
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		(NULL==m_potunmstr_AudioClientHandler) ||
#endif
      (m_ptunmstr_Preset_Handler==NULL) || (m_potunmstr_MsgFromHMI == NULL) || (m_potunmstr_MsgToHMI == NULL)
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	  || (m_potunermaster_SXMClient == NULL)
#endif
	  )
	{
		NORMAL_M_ASSERT (NULL != poGWMain);
		NORMAL_M_ASSERT (NULL != m_poclConfigInterface);
		NORMAL_M_ASSERT (NULL != m_potunmstr_DABClient_Handler);
		NORMAL_M_ASSERT(NULL != m_potunmstr_SrcChgManager);
		NORMAL_M_ASSERT(NULL != m_ptunmstr_Preset_Handler);
		NORMAL_M_ASSERT(NULL != m_potunmstr_MsgToHMI);
		NORMAL_M_ASSERT(NULL != m_potunmstr_MsgFromHMI);
		return;
	}

	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNCLIENT_HANDLER,
			ET_EN_T16 _ TUNMSTR_TRACE_TUNCLT_SERVICE_STATE _
			ET_EN_T16  _ u16ServiceId _
			ET_EN_T16  _ u16ServerId _
			ET_EN_T16  _ u16RegisterId _
			ET_EN_T8   _ u8ServiceState _
			ET_EN_T16  _ u16SubId _
			ET_EN_DONE );
	/*if ( NULL == poGWMain )
   {
   poGWMain->vUnregisterService( (tU16) CCA_C_U16_SRV_DIAGLOG );  
   ET_TRACE_ERROR_BIN( TUNMSTR_TRACE_CLASS_TUNCLIENT_HANDLER, 
   ET_EN_T16 _ TUNMSTR_TRACE_TUNCLT_UNREG_FAIL _
   ET_EN_DONE );
   NORMAL_M_ASSERT (NULL != poGWMain);

   }*/


	// Analyze the state of the server
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		clSessionControl::getInstance()->vOnServiceState(tuner::common::AMFMTUNER, static_cast<tuner::common::enTunerClientAvailability>(u8ServiceState));
#endif
	switch(u8ServiceState)
	{
	case AMT_C_U8_SVCSTATE_AVAILABLE:
	{

		m_u8ServiceAvailable_Tuner = TRUE;
		tU16 u16FID;
		m_u16TunerRegID=u16RegisterId;
		//Trace the status Accepted or rejected
		ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNCLIENT_HANDLER, ET_EN_STRING _ "TUN -> Reg ID :" _
				ET_EN_T16 _ m_u16TunerRegID _ ET_EN_DONE );

		u16FID = MIDW_TUNERFI_C_U16_FID_TUN_G_ATSTATIONINFO;
		fregisterForFID(u16FID); // register for MIDW_TUNERFI_C_U16_FID_TUN_G_STATION_DATA_VAG

		u16FID = MIDW_TUNERFI_C_U16_FID_TUN_G_ANNOUNCEMENT_MESSAGE;
		fregisterForFID(u16FID); // register for MIDW_TUNERFI_C_U16_FID_TUN_G_ANNOUNCEMENT_MESSAGE

		u16FID = MIDW_TUNERFI_C_U16_FID_TUN_G_ANNOUNCEMENT_SWITCH;
		fregisterForFID(u16FID);// Register for MIDW_TUNERFI_C_U16_FID_TUN_G_ANNOUNCEMENT_SWITCH

	//	u16FID = MIDW_TUNERFI_C_U16_FID_TUN_G_COMPONENT_STATUS_TUNER;
	//	fregisterForFID(u16FID);// Register for MIDW_TUNERFI_C_U16_FID_TUN_G_COMPONENT_STATUS_TUNER

		u16FID = MIDW_TUNERFI_C_U16_FID_TUN_G_DIAG_REMOTE_CONTROL;
		fregisterForFID(u16FID);// Register for MIDW_TUNERFI_C_U16_FID_TUN_G_DIAG_REMOTE_CONTROL

		u16FID = MIDW_TUNERFI_C_U16_FID_TUN_G_ANNOUNCEMENT_INFO;
		fregisterForFID(u16FID);// Register for MIDW_TUNERFI_C_U16_FID_TUN_G_ANNOUNCEMENT_INFO

		u16FID = MIDW_TUNERFI_C_U16_FID_TUN_G_GET_STATIC_LIST;
		fregisterForFID(u16FID);// Register for MIDW_TUNERFI_C_U16_FID_TUN_G_TAINFO
		u16FID = MIDW_TUNERFI_C_U16_FID_TUN_G_MUTE_REQUEST;
		fregisterForFID(u16FID);// Register for MIDW_TUNERFI_C_U16_FID_TUN_G_MUTE_REQUEST
		if( ! poGWMain->blGetStratUpTriggerSent_Info())
		{
			poGWMain->vTunerMasterStartUpProcess();
		}
		tU32 u32Available_band =m_poclConfigInterface->u32GetConfigData("AvailableBands");
		for(tU8 u8Source=(tU8)ARL_SRC_FM;u8Source<=(tU8)ARL_SRC_AM;u8Source++)
		{
			arl_tenSrcAvailability enSrcAvail=ARL_EN_SRC_NOT_AVAILABLE;
			arl_tenAvailabilityReason enAvailabilityReason=ARL_EN_REASON_NOMEDIA;
			switch(u8Source)
			{
			case ARL_SRC_FM:
			case ARL_SRC_FMTA:
			{
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
				m_poArlImpl->vRequestMute(tuner::common::FM1,tuner::common::DEMUTE); /*Added to send demute when tuner comes up*/
#endif
				if((u32Available_band & TUNMSTR_CONFIG_DEFAULT_AVAILABLEBAND_FM_MASKVAL))
				{
					enSrcAvail=ARL_EN_SRC_PLAYABLE;
					enAvailabilityReason=ARL_EN_REASON_NEWMEDIA;
				}
				break;
			}
			case ARL_SRC_AM:
			{
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
				m_poArlImpl->vRequestMute(tuner::common::AM,tuner::common::DEMUTE); /*Added to send demute when tuner comes up*/
#endif
				#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
				dp_tclTmcTunerUsrDPAMAvailability oTmcTunerDPAMAvailability ;
				tBool bTmcTunerDPAMAvailStatus = true;
				oTmcTunerDPAMAvailability.s32GetData(bTmcTunerDPAMAvailStatus);
				ETG_TRACE_USR4(( "AMAvailability=%d",bTmcTunerDPAMAvailStatus));

				if((m_poclConfigInterface->u32GetConfigData("AvailableBands") & 0x06) && (m_poclConfigInterface->u32GetConfigData("CFGAM")))
				{
					if( bTmcTunerDPAMAvailStatus)
					{
						enSrcAvail=ARL_EN_SRC_PLAYABLE;
						enAvailabilityReason=ARL_EN_REASON_NEWMEDIA;
					}
				}
				#else
				if((u32Available_band & TUNMSTR_CONFIG_DEFAULT_AVAILABLEBAND_AM_MASKVAL))
				{
					enSrcAvail=ARL_EN_SRC_PLAYABLE;
					enAvailabilityReason=ARL_EN_REASON_NEWMEDIA;
				}
				#endif
				break;
			}
			default:
			{
				break;
			}
			}
				
            #ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			m_potunmstr_AudioClientHandler->vSendSourceavailability((arl_tenSource)u8Source,enSrcAvail,enAvailabilityReason);
			#else
			ETG_TRACE_USR4(( "vUpdateAudioSourceAvailabelStatus() source =%d availability =%d reason=%d",u8Source,enSrcAvail,enAvailabilityReason));
			m_poArlImpl->vUpdateAudioSourceAvailabelStatus((arl_tenSource)u8Source,enSrcAvail,enAvailabilityReason);
            #endif
		}
	    //Send source availability for DRM
		arl_tenSrcAvailability arlSrcAvailability = ARL_EN_SRC_NOT_AVAILABLE;
		arl_tenAvailabilityReason arlAvailabilityReason = ARL_EN_REASON_NOMEDIA;
		if (m_poclConfigInterface->u32GetConfigData("DRMSupported"))
		{
			arlSrcAvailability = ARL_EN_SRC_PLAYABLE;
			arlAvailabilityReason = ARL_EN_REASON_NEWMEDIA;
		}
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendSourceavailability(ARL_SRC_DRM,arlSrcAvailability,arlAvailabilityReason);
#else
		m_poArlImpl->vUpdateAudioSourceAvailabelStatus(ARL_SRC_DRM,arlSrcAvailability,arlAvailabilityReason);
		m_poArlImpl->vRequestMute(tuner::common::DRM,tuner::common::DEMUTE); /*Added to send demute when tuner comes up*/
#endif
		arlSrcAvailability = ARL_EN_SRC_NOT_AVAILABLE;
		arlAvailabilityReason = ARL_EN_REASON_NOMEDIA;
		if((u32Available_band & TUNMSTR_CONFIG_DEFAULT_AVAILABLEBAND_TRF_MASKVAL))
		{
			arlSrcAvailability=ARL_EN_SRC_PLAYABLE;
			arlAvailabilityReason=ARL_EN_REASON_NEWMEDIA;
		}
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendSourceavailability(ARL_SRC_AMTI,arlSrcAvailability,arlAvailabilityReason);
#else
		m_poArlImpl->vUpdateAudioSourceAvailabelStatus(ARL_SRC_AMTI,arlSrcAvailability,arlAvailabilityReason);
		m_poArlImpl->vRequestMute(tuner::common::AMTI,tuner::common::DEMUTE); /*Added to send demute when tuner comes up*/
#endif
      arlSrcAvailability=ARL_EN_SRC_PLAYABLE;
      arlAvailabilityReason=ARL_EN_REASON_NEWMEDIA;
		if((u32Available_band & TUNMSTR_CONFIG_DEFAULT_AVAILABLEBAND_WB_MASKVAL))
		{
			arlSrcAvailability=ARL_EN_SRC_PLAYABLE;
			arlAvailabilityReason=ARL_EN_REASON_NEWMEDIA;
		}
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendSourceavailability(ARL_SRC_WX,arlSrcAvailability,arlAvailabilityReason);
#else
		m_poArlImpl->vUpdateAudioSourceAvailabelStatus(ARL_SRC_WX,arlSrcAvailability,arlAvailabilityReason);
		m_poArlImpl->vUpdateAudioSourceAvailabelStatus(ARL_SRC_WX_ALERT,arlSrcAvailability,arlAvailabilityReason);
		m_poArlImpl->vRequestMute(tuner::common::WB,tuner::common::DEMUTE); /*Added to send demute when tuner comes up*/
#endif
		if(m_blSendGetStaticListReq==TRUE)
		{
			
//#ifdef VARIANT_S_FTR_ENABLE_FEATURE_SUZUKI
	//		vRequestPresetList_Suzuki();


//#endif/** END SUZUKI */

if(m_poclConfigInterface->u32GetConfigData("PresetListType"))
{
	if(m_poclConfigInterface->u32GetConfigData("SXMSupported"))
	{
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
			if(m_potunermaster_SXMClient->bGetServiceStatus())
			{
				m_ptunmstr_Preset_Handler->Update_tunmstr_bStartUpFlag(TRUE);
				//m_ptunmstr_Preset_Handler->Inc_m_u8StartUp_HMI_Update();

				vRequestMixedPresetList();
				m_ptunmstr_Preset_Handler->Inc_m_u8SXMStartUp_HMI_Update();
				m_potunermaster_SXMClient->vGetPresetList();
			}
#endif
#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
			if(m_potunmstr_MsgFromHMI->bGetSXM360LServiceStatus())
			{
				m_ptunmstr_Preset_Handler->Update_tunmstr_bStartUpFlag(TRUE);
				//m_ptunmstr_Preset_Handler->Inc_m_u8StartUp_HMI_Update();

				vRequestMixedPresetList();
				m_ptunmstr_Preset_Handler->Inc_m_u8SXMStartUp_HMI_Update();
				midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus oStatus;
				oStatus.Preset_Action.enType = midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_GETPRESETLIST;
				oStatus.PresetIndex = 0x00;
				m_potunmstr_MsgToHMI->vHandleSXM360LPresetRequest(oStatus);
			}
#endif
	}
	else
	{
		m_ptunmstr_Preset_Handler->Update_tunmstr_bStartUpFlag(TRUE);
		//m_ptunmstr_Preset_Handler->Inc_m_u8StartUp_HMI_Update();

		vRequestMixedPresetList();
	}

}/** END PSA */
			//vRequestPresetList();

		}
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		vHandlePendingSrcChgReq_Tuner();
#else
		if(m_poclConfigInterface->u32GetConfigData("DABSupported") &&
				(m_poclConfigInterface->u32GetConfigData("SBR")) &&
				(m_potunmstr_DABClient_Handler->u8GetDABServiceState()))
		{
			for(tU8 u8Source=(tU8)ARL_SRC_DAB;u8Source<=(tU8)ARL_SRC_DABTA;u8Source++)
			{
				m_poArlImpl->vUpdateAudioSourceAvailabelStatus((arl_tenSource)u8Source,ARL_EN_SRC_PLAYABLE,ARL_EN_REASON_NEWMEDIA);
				m_poArlImpl->vRequestMute(tuner::common::DAB,tuner::common::DEMUTE); /*Added to send demute when tuner comes up*/
			}
		}
#endif
	}
	break;

	case AMT_C_U8_SVCSTATE_NOT_AVAILABLE:
	{
		// Service is not available anymore
		// Don't do anything..wait for availability
		ETG_TRACE_USR1(( " vOnServiceState()->entered into Tuner control service not availabel"));

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		tuner::common::enSourceId currentSourceId = m_poArlImpl->getActiveSource();
		if(bIsTemporarySource(currentSourceId) && oGetTunerClient(currentSourceId) == tuner::common::AMFMTUNER)
		{
			oAnnouncementControl.vOnNewAnnouncementMessage(midw_fi_tcl_e8_Anno_Message::FI_EN_TA_PTY_OFF,m_poSessionControl->getStoredPreviousSessionStateBeforeAnnoucementSrc(),m_poSessionControl->getStoredPreviousSessionStateBeforeAnnoucementSrcActivity());
		}
#endif
		tBool blDabAvail = (tBool)m_poclConfigInterface->u32GetConfigData("DABSupported");
		tU8 u8DABService = m_potunmstr_DABClient_Handler->u8GetDABServiceState();
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_SrcChgManager->vClearRadioStates();
#endif
		m_u8ServiceAvailable_Tuner = FALSE;
		for(tU8 u8Source=(tU8)ARL_SRC_FM;u8Source<=(tU8)ARL_SRC_AM;u8Source++)
		{
         #ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			m_potunmstr_AudioClientHandler->vSendSourceavailability((arl_tenSource)u8Source,ARL_EN_SRC_PLAYABLE_UNKNOWN,ARL_EN_REASON_SAMEMEDIA);
		#else
			/*Source availability will be sent only when the amfm/dab service becomes available*/
			//m_poArlImpl->vUpdateAudioSourceAvailabelStatus((arl_tenSource)u8Source,ARL_EN_SRC_PLAYABLE_UNKNOWN,ARL_EN_REASON_NEWMEDIA);
         #endif
		}

	    //Send source availability for DRM
		if (m_poclConfigInterface->u32GetConfigData("DRMSupported"))
		{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		arl_tenSrcAvailability arlSrcAvailability = ARL_EN_SRC_PLAYABLE_UNKNOWN;
		arl_tenAvailabilityReason arlAvailabilityReason = ARL_EN_REASON_SAMEMEDIA;
		m_potunmstr_AudioClientHandler->vSendSourceavailability(ARL_SRC_DRM,arlSrcAvailability,arlAvailabilityReason);
#else
		/*Source availability will be sent only when the amfm/dab service becomes available*/
		//m_poArlImpl->vUpdateAudioSourceAvailabelStatus(ARL_SRC_DRM,arlSrcAvailability,arlAvailabilityReason);
#endif
		}


		if((blDabAvail == TRUE) )
		{
			if(u8DABService == FALSE)
			{
				ETG_TRACE_USR1(( " vOnServiceState()->DAB && tuner service is not available"));
				poGWMain->vTunerMasterShutDownProcess();
			}
		}// end of if
		else
		{
			poGWMain->vTunerMasterShutDownProcess();
		}
		if(m_poclConfigInterface->u32GetConfigData("PresetListType"))
		{
			vRequestMixedPresetList();
			m_ptunmstr_Preset_Handler->vClearPresetList();
			m_ptunmstr_Preset_Handler->vUpdateMixedPresetListBandAsNone();
			if(m_poclConfigInterface->u32GetConfigData("SXMSupported"))
			{
				m_ptunmstr_Preset_Handler->Dec_m_u8TunerStartUp_HMI_Update(true);
				m_ptunmstr_Preset_Handler->Dec_m_u8SXMStartUp_HMI_Update(true);
			}
		}


	}
	break;

	case AMT_C_U8_SVCSTATE_REG_INVALID:
	{
		// Server has lost our registration.
		m_u16TunerRegID = AMT_C_U16_REGID_INVALID;
		// Try to register again

		vRegisterForService();



	}
	break;

	default:
	{
		m_u16TunerRegID = AMT_C_U16_REGID_INVALID;
		vRegisterForService();
	}
	break;

	} // switch(u8ServiceState)

	//Trace the status Accepted or rejected
	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_TUNCLIENT_HANDLER, ET_EN_STRING _ "TUN -> Reg ID :" _
			ET_EN_T16 _ m_u16TunerRegID _ ET_EN_DONE );
}

/*************************************************************************************
 *
 *FUNCTION:     tunmstr_TunerClientHandler::vNewAppState
 *
 *DESCRIPTION:  Main calls this function whenever there is a change in
 *               power state to handle CCA service
 *
 *PARAMETER:    tU16,tU16,tU16,tU8,tU16,
 *
 *RETURNVALUE: None
 ************************************************************************************/
tVoid tunmstr_TunerClientHandler :: vOnNewAppState(  tU32 /*u32OldAppState*/,  tU32 u32AppState  )
{
	// Decide to reg/unreg based on the state of APP
	switch(u32AppState)
	{
		case AMT_C_U32_STATE_DIAGNOSIS:
		case AMT_C_U32_STATE_PAUSE:
		{
			vRegisterForService();
			break;

		}
		case AMT_C_U32_STATE_OFF:
		{
			ETG_TRACE_USR1(( " vOnNewAppState()->Don't unregister for Tuner control service"));
			//fUnregisterForService();
		}
		break;
		default:
		{
			ET_TRACE_ERROR_BIN( TUNMSTR_TRACE_CLASS_TUNCLIENT_HANDLER, ET_EN_T16 _ TUNMSTR_TRACE_TUNCLT_INVALID_APPID _
					ET_EN_DONE );
			break;

		}
	} // end of Switch

}// end of NewAppState

/*************************************************************************************
 *
 *FUNCTION:     tunmstr_TunerClientHandler::fUnregisterForService
 *
 *DESCRIPTION:  Sends a unregister message to Diaglog
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  tBool
 ************************************************************************************/
tBool tunmstr_TunerClientHandler::fUnregisterForService()
{
	// Return value
	tBool fIsServiceUnregistered = TRUE;

	// Unregister if registration is valid?
	if ( AMT_C_U16_REGID_INVALID != m_u16TunerRegID )
	{

		// Send an unregister for service message
		if ( NULL == poGWMain )
		{
			/*poGWMain->vUnregisterService( (tU16) CCA_C_U16_SRV_DIAGLOG );
         ET_TRACE_ERROR_BIN( TUNMSTR_TRACE_CLASS_TUNCLIENT_HANDLER, 
         ET_EN_T16 _ TUNMSTR_TRACE_TUNCLT_UNREG_FAIL _
         ET_EN_DONE );*/
			NORMAL_M_ASSERT (NULL != poGWMain);

		}


		else
		{
			poGWMain->vUnregisterService( (tU16) CCA_C_U16_SRV_TUNERCONTROL );
			ET_TRACE_ERROR_BIN( TUNMSTR_TRACE_CLASS_TUNCLIENT_HANDLER,
					ET_EN_T16 _ TUNMSTR_TRACE_TUNCLT_UNREG_SUCCESS _
					ET_EN_DONE );

		}

		// Make register-ID invalid:
		m_u16TunerRegID = AMT_C_U16_REGID_INVALID;

		m_u8ServiceAvailable_Tuner = FALSE;
	}

	// return whether the service is unregistered
	return fIsServiceUnregistered;
}

/*************************************************************************************
 *
 *FUNCTION:     tunmstr_TunerClientHandler::fregisterForFID
 *
 *DESCRIPTION:  Handles the state changes of the service we use
 *
 *PARAMETER:    tU16,tU16,tU16,tU8,tU16,
 *
 *RETURNVALUE: None
 ************************************************************************************/
tBool tunmstr_TunerClientHandler :: fregisterForFID(tU16 u16FID) 
{

	tBool bRetVal = FALSE;

	if ( NULL == poGWMain )
	{
		NORMAL_M_ASSERT (NULL != poGWMain);
		return FALSE;
	}

	gm_tclEmptyMessage oUpRegMessage( CCA_C_U16_APP_TUNERMASTER,  // AppID of this application
			CCA_C_U16_APP_TUNER,      // AppID of the Server
			m_u16TunerRegID,                // RegId for the service (see bRegisterForService )
			0,                        // always 0
			CCA_C_U16_SRV_TUNERCONTROL,  // SID of the service
			u16FID,                   // FID to register for
			AMT_C_U8_CCAMSG_OPCODE_UPREG);





	if (poGWMain->enPostMessage(&oUpRegMessage, TRUE) == AIL_EN_N_NO_ERROR)
	{
		// message send success - set the return value to TRUE
		bRetVal = TRUE;

		ET_TRACE_INFO_BIN(TUNMSTR_TRACE_CLASS_TUNCLIENT_HANDLER,
				ET_EN_T16 _ TUNMSTR_TRACE_TUNCLT_FID_REG_OK  _
				ET_EN_DONE);


	}
	else
	{
		ET_TRACE_INFO_BIN(TUNMSTR_TRACE_CLASS_TUNCLIENT_HANDLER,
				ET_EN_T16 _ TUNMSTR_TRACE_TUNCLT_FID_REG_NOK  _
				ET_EN_DONE);
	}

	return bRetVal;

}
/*************************************************************************************
 *
 *FUNCTION:     tunmstr_TunerClientHandler::vRegisterForService
 *
 *DESCRIPTION:  Sends a register message to fc_amfmtuner
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  tVoid
 ************************************************************************************/
tU8 tunmstr_TunerClientHandler::u8GetTunerService()const
{
	return m_u8ServiceAvailable_Tuner;
}
/*************************************************************************************
 *
 *FUNCTION:     tunmstr_TunerClientHandler::vRegisterForService
 *
 *DESCRIPTION:  Sends a register message to fc_amfmtuner
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  tVoid
 ************************************************************************************/
tVoid tunmstr_TunerClientHandler::vSetAnnoType(tU8 u8AnnoType)
{
	m_u8AnnoType = u8AnnoType;
}
/*************************************************************************************
 *
 *FUNCTION:     tunmstr_TunerClientHandler::vRegisterForService
 *
 *DESCRIPTION:  Sends a register message to fc_amfmtuner
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  tVoid
 ************************************************************************************/
tVoid tunmstr_TunerClientHandler::vRegisterForService()
{
	// Return value
	//  tBool fIsServiceRegistered = FALSE;
	tBool bRetVal = FALSE;
	if ( NULL == poGWMain )
	{
		NORMAL_M_ASSERT (NULL != poGWMain);
		return;
	}


	// check valid reqisteration
	if ( AMT_C_U16_REGID_INVALID == m_u16TunerRegID )
	{


		bRetVal = poGWMain->bRegisterAsync(CCA_C_U16_SRV_TUNERCONTROL,
				MIDW_TUNERFI_C_U16_SERVICE_MAJORVERSION                      /* Major version */,
				MIDW_TUNERFI_C_U16_SERVICE_MINORVERSION                      /* Minor version */,
				0x0,
				CCA_C_U16_APP_TUNER);



		if(bRetVal == TRUE)
		{

			ET_TRACE_INFO_BIN(TUNMSTR_TRACE_CLASS_TUNCLIENT_HANDLER,
					ET_EN_T16 _ TUNMSTR_TRACE_TUNCLT_SERVICE_REG_OK  _
					ET_EN_DONE);

		}

		else

		{
			ET_TRACE_INFO_BIN(TUNMSTR_TRACE_CLASS_TUNCLIENT_HANDLER,
					ET_EN_T16 _ TUNMSTR_TRACE_TUNCLT_SERVICE_REG_NOK  _
					ET_EN_DONE);
			m_u8ServiceAvailable_Tuner = FALSE;

		}



	}

	//    // Determine whether the service is registered / registeration was successful
	//    fIsServiceRegistered = ( AMT_C_U16_REGID_INVALID != m_u16TunerRegID);
	//    // return whether the service is registered
	//    return fIsServiceRegistered;

}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vSend_s_SetAnnouncementSwitch( )
 *
 * DESCRIPTION:  This function is used to set announcment switches
 *
 * PARAMETER:    tU8 u8AnnoSwitch
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vSend_s_SetAnnouncementSwitch(tU8 u8AnnoSwitch)
{

	midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_SWITCHMethodStart oMsgData;


	oMsgData.b8AnnoType.u8Value = u8AnnoSwitch;

	vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
			oMsgData,           // parameter&
			MIDW_TUNERFI_C_U16_FID_TUN_S_ANNOUNCEMENT_SWITCH, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0 //CmdCntr
	);

	ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vSend_s_SetAnnouncementSwitch ,u8AnnoSwitch : %d",
					u8AnnoSwitch));
}

/*******************************************************************************
 *FUNCTION:    tun_MsgFromHMI::vGetDatafromAMT
 *
 *DESCRIPTION: This function converts Amt message to visitor class and
 *             get the data from visitor to the Fi class. Refer FI Manual.
 *             Doc.
 *
 *PARAMETER:
 *           poFiMsg   - Amt Message
 *           oFIData   - Base class of Fi class
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_TunerClientHandler::vGetDatafromAMT( amt_tclServiceData* poFIMsg,
		fi_tclTypeBase&     oFIData )const
{
	// Create Visitor message object for incoming message
	fi_tclVisitorMessage oInVisitorMsg(poFIMsg);

	/* Get the data in FI class from Vistor class*/
	if(OSAL_ERROR == oInVisitorMsg.s32GetData(oFIData,1))
	{
		// assert here
		NORMAL_M_ASSERT_ALWAYS ();
	}

}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vHandle_g_TA_Message( )
 *
 * DESCRIPTION:  Handle message from RU -(0x41) RU_TUNMSTR_R_SET_FRQ.
 *
 * PARAMETER:    tU8* u8Message, tU32 u32Len
 *
 * RETURNVALUE:  tVoid
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vHandle_g_Announcement_Message(amt_tclServiceData* poMessage )
{
	if((poMessage == NULL ) || (m_potunmstr_SrcChg_AnnoHandler == NULL) || (m_potunmstr_SrcChgManager == NULL)||(NULL==m_potunmaster_Config))
	{
		ET_TRACE_ERROR_BIN( TUNMSTR_TRACE_CLASS_TUNCLIENT_HANDLER,\
				ET_EN_T16 _ TUNMSTR_TRACE_TUNCLT_HANDLER_NULL_POINTER _\
				ET_EN_DONE );
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChg_AnnoHandler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
		return;

	}

	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_STATUS:
	{
		midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus oStatusMsg;
		vGetDatafromAMT(poMessage,oStatusMsg);
		ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandle_g_Announcement_Message,Tuner State : %d",m_potunmstr_SrcChgManager->u8GetTunerState()));
#ifndef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
		tU8 u8Anno_Type = (tU8)oStatusMsg.e8AnnoMessage.enType;

		tU8 u8FMAnnoType = 0xFF;

		tU8 u8Anno_State = blConvertTUNAnnoType_TunMstrAnnoType(u8Anno_Type , u8FMAnnoType);

		ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandle_g_Announcement_Message u8FMAnnoType : %d",u8FMAnnoType));

		if((tU16)m_potunmaster_Config->u16GetAnnoPrio(u8FMAnnoType) != TUNMSTR_ANNOPRIORITY_IGNORE)
		{
			if((m_potunmstr_SrcChgManager->u8GetTunerState() != (tU8)TUNMSTR_SRCCHG_INPROGESS) || (u8Anno_State == TUNMSTR_ANNOREQUEST_OFF))
			{
				vHandle_AnnouncementMessage(u8Anno_State,u8FMAnnoType);
			}
		}
		else
		{
			ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandle_g_Announcement_Message, anno request blocked due to ignore priority "));
		}
#else
		/*In FM source, when FM PTY31 ends and Weather alert is still active. 1st request for FM PTY31 off.*/
		if((tuner::common::FMANNOUNCEMENTS == m_poArlImpl->getActiveSource()) &&
		         (tuner::common::SRCON ==m_poArlImpl->getActiveSourceActivity() ||
		                  tuner::common::SRCPAUSE ==m_poArlImpl->getActiveSourceActivity()) &&
		                  (oStatusMsg.e8AnnoMessage.enType == midw_fi_tcl_e8_Anno_Message::FI_EN_TA_OFF_PTY31_OFF_WEATHERALERT_ON))
		{
		   oAnnouncementControl.vOnNewAnnouncementMessage(midw_fi_tcl_e8_Anno_Message::FI_EN_TA_PTY_OFF,m_poSessionControl->getStoredPreviousSessionStateBeforeAnnoucementSrc(),m_poSessionControl->getStoredPreviousSessionStateBeforeAnnoucementSrcActivity());
		}
		else
      {
		   oAnnouncementControl.vOnNewAnnouncementMessage(oStatusMsg.e8AnnoMessage.enType,m_poSessionControl->getStoredPreviousSessionStateBeforeAnnoucementSrc(),m_poSessionControl->getStoredPreviousSessionStateBeforeAnnoucementSrcActivity());
      }
#endif
		break;
	}//end of case AMT_C_U8_CCAMSG_OPCODE_STATUS
	case AMT_C_U8_CCAMSG_OPCODE_UPREG:
	case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
	default:
		break;
	};//end of switch (poMessage->u8GetOpCode())
}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vHandle_AnnouncementMessage( )
 *
 * DESCRIPTION:
 *
 * PARAMETER:    tU8 u8Anno_State , tU8 u8FMAnnoType
 *
 * RETURNVALUE:  tVoid
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vHandle_AnnouncementMessage(tU8 u8Anno_State , tU8 u8FMAnnoType)
{
	if((m_potunmstr_SrcChg_AnnoHandler == NULL) || (NULL==m_potunmaster_Config))
	{
		ET_TRACE_ERROR_BIN( TUNMSTR_TRACE_CLASS_TUNCLIENT_HANDLER,\
				ET_EN_T16 _ TUNMSTR_TRACE_TUNCLT_HANDLER_NULL_POINTER _\
				ET_EN_DONE );
		NORMAL_M_ASSERT( m_potunmstr_SrcChg_AnnoHandler != NULL );
		NORMAL_M_ASSERT( m_potunmaster_Config != NULL );
		return;

	}


	tU16 u16CurrentAnnoPrio = m_potunmaster_Config->u16GetAnnoPrio(m_potunmstr_SrcChg_AnnoHandler->m_ActiveAnnoSrc);

	if(u8Anno_State == TUNMSTR_ANNOREQUEST_ON)
	{
		if(u16CurrentAnnoPrio > (tU16)m_potunmaster_Config->u16GetAnnoPrio(u8FMAnnoType))
		{
			m_u8AnnoType = u8FMAnnoType;
			m_potunmstr_SrcChg_AnnoHandler->vHandle_AnnoMSG(m_u8AnnoType,TUNMSTR_SRCCHG_SOURCE_TUN1FM,TRUE);
			ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandle_AnnouncementMessage ,Anno Req passed to anno handler AnnoType =%d, AnnoState=%d",
					u8FMAnnoType,u8Anno_State));
		}
		else
		{
			ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandle_AnnouncementMessage ignore anno request,u8CurrentAnnoPrio : %d, request anno prio : %d ",
					u16CurrentAnnoPrio , m_potunmaster_Config->u16GetAnnoPrio(u8FMAnnoType)));
		}
	}
	else if(u8Anno_State == TUNMSTR_ANNOREQUEST_OFF)
	{
		ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandle_AnnouncementMessage off m_potunmstr_SrcChg_AnnoHandler->m_ActiveAnnoSrc :%d"
				" m_u8AnnoType : %d ",m_potunmstr_SrcChg_AnnoHandler->m_ActiveAnnoSrc,u8FMAnnoType));
		if(m_potunmstr_SrcChg_AnnoHandler->m_ActiveAnnoSrc == u8FMAnnoType)
		{
			m_potunmstr_SrcChg_AnnoHandler->vHandle_AnnoMSG(m_u8AnnoType,TUNMSTR_SRCCHG_SOURCE_TUN1FM,FALSE);
			ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandle_AnnouncementMessage ,Anno Req passed to anno handler AnnoType =%d, AnnoState=%d",
					u8FMAnnoType,u8Anno_State	));
		}
	}
	else
	{
		ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandle_AnnouncementMessage,message already sent to anno handler \
				                         or invalid request received "));
	}
}


/*************************************************************************************
 *FUNCTION:    tunmstr_TunerClientHandler::vHandle_g_Station_Data
 *
 *DESCRIPTION: This function converts Amt message to visitor class and
 *             get the data from visitor to the Fi class. Refer FI Manual.Doc.
 *
 *PARAMETER:    tU16,fi_tclTypeBase& ,tU16,tU8,tU16,tU16
 *
 *RETURNVALUE: None
 ************************************************************************************/
tVoid tunmstr_TunerClientHandler::vHandle_g_AtStation_Info(amt_tclServiceData* poMessage )
{
	if((poMessage == NULL ) ||(m_potunmstr_MsgToHMI == NULL)|| \
			(m_potunmstr_SrcChg_AnnoHandler == NULL) || (m_poclConfigInterface == NULL))
	{

		return;

	}
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_STATUS:
	{
		// Analyse the change in frequency in FG.

		midw_tunerfi_tclMsgFID_TUN_G_ATSTATIONINFOStatus oStatusMsg;

		vGetDatafromAMT(poMessage,oStatusMsg);

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
		tU8 RequestedBand = u8GetBandFromFrequency(oStatusMsg.Atstationinfo.u32Frequency);
        ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandle_g_AtStation_Info RequestedBand = %d m_u8StationinfoBand = %d atstationband=%d Frequency=%d",
		 RequestedBand, m_u8StationinfoBand,oStatusMsg.Atstationinfo.e8Band.enType,oStatusMsg.Atstationinfo.u32Frequency));
        if(m_u8StationinfoBand != RequestedBand && (RequestedBand == TUNMSTR_SRCCHG_BAND_LW || RequestedBand == TUNMSTR_SRCCHG_BAND_AM))
		{
			m_u8StationinfoBand = u8GetBandFromFrequency(oStatusMsg.Atstationinfo.u32Frequency);
			if(m_u8StationinfoBand == TUNMSTR_SRCCHG_BAND_LW  || TUNMSTR_SRCCHG_BAND_AM == m_u8StationinfoBand)
			{
				m_potunmstr_MsgToHMI->vSend_g_Band_Info(TUNMSTR_SRCCHG_SOURCE_TUN1AM, false);
			}
		}
		else if((RequestedBand == TUNMSTR_SRCCHG_BAND_FM) && (m_u8StationinfoBand != RequestedBand))
		{
			/* update current band, t oavoid screen transition from LW to MW (LW->FM->MW) */
			m_u8StationinfoBand = u8GetBandFromFrequency(oStatusMsg.Atstationinfo.u32Frequency);
		}
#endif
        m_u8StationinfoFreq = oStatusMsg.Atstationinfo.u32Frequency;
		tU8 u8TPStatus  =  (tU8)oStatusMsg.Atstationinfo.e8AtStationTPinfo.enType;
		tU8 u8MonitorFMTA_AM =  (m_poclConfigInterface->u32GetConfigData("MonitorFMTA")) & TUNMSTR_MONITORFMTA_AM;
		tU8 u8MonitorFMTA_FM = (tU8)(((m_poclConfigInterface->u32GetConfigData("MonitorFMTA")) & TUNMSTR_MONITORFMTA_FM)>>0x01);
		if((u8MonitorFMTA_AM) && (oStatusMsg.Atstationinfo.e8Band.enType == midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_MW))
		{
			ETG_TRACE_USR4(("TPStatus: Atstationinfo:: in AM source, TP status will be  monitored by BG tuner "));
		}
		else if((u8MonitorFMTA_FM) && (oStatusMsg.Atstationinfo.e8Band.enType == midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_FM)
					&& (u8TPStatus == midw_fi_tcl_e8_AtStationTPinfo::FI_EN_UNKNOWN))
		{
			ETG_TRACE_USR4(("TPStatus: Atstationinfo:: in FM source, TP status will be  monitored by BG tuner "));
		}
		else
		{


#ifdef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
			ETG_TRACE_USR4(("TPStatus: Atstationinfo:: in FM source, TP status sent = %d", oStatusMsg.Atstationinfo.e8AtStationTPinfo.enType));
			oAnnouncementControl.vOnNewTpState(oStatusMsg.Atstationinfo.e8Band.enType, oStatusMsg.Atstationinfo.e8AtStationTPinfo.enType);
			tBool blTPState = false;
			if((oStatusMsg.Atstationinfo.e8AtStationTPinfo.enType==midw_fi_tcl_e8_AtStationTPinfo::FI_EN_SELF_TP) || (oStatusMsg.Atstationinfo.e8AtStationTPinfo.enType ==midw_fi_tcl_e8_AtStationTPinfo::FI_EN_EON_TP))
			{
				blTPState=true;
			}
			m_potunmstr_MsgToHMI->vSend_g_TP_Status(blTPState,midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_FM1);

#else
			m_potunmstr_SrcChg_AnnoHandler->vCheckForTPStatus(u8TPStatus, (tU8)TUNMSTR_SRCCHG_SOURCE_TUN1FM);
#endif

		}
	
		m_u8PresetAutocompare = (tU8)oStatusMsg.Atstationinfo.u16StaticListElementID;
		m_bUserPresetAction = oStatusMsg.Atstationinfo.bUserPresetAction;
		ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandle_g_AtStation_Info m_u8PresetAutocompare = %d, m_bUserPresetAction = %d", m_u8PresetAutocompare, m_bUserPresetAction));
		m_potunmstr_MsgToHMI->vSend_g_PresetAutoCompare(m_u8PresetAutocompare, m_bUserPresetAction);

	break;
	}// end of case AMT_C_U8_CCAMSG_OPCODE_STATUS
	default:
	{
		break;
	}
	}

}//end of tVoid tunmstr_TunerClientHandler::vHandle_g_Station_Data(amt_tclServiceData* poMessage )

/***********************************************************
 * Send Band info, on the basis of Frequency range
 ***********************************************************/
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
tU8 tunmstr_TunerClientHandler::u8GetBandFromFrequency(unsigned int u32Frequency)
{
	tU8 u8Band = TUNMSTR_SRCCHG_BAND_UPDATE_NOTREQ;
	if(m_poclConfigInterface == NULL)
	{
		NORMAL_M_ASSERT (m_poclConfigInterface != NULL);
		return u8Band;
	}

	if(((unsigned int)m_poclConfigInterface->u32GetConfigData("HighFM") >= u32Frequency) && ((unsigned int)m_poclConfigInterface->u32GetConfigData("LowFM") <= u32Frequency))
	{
		u8Band = TUNMSTR_SRCCHG_BAND_FM;
	}
	else if(((unsigned int)m_poclConfigInterface->u32GetConfigData("HighLW") >= u32Frequency) && ((unsigned int)m_poclConfigInterface->u32GetConfigData("LowLW") <= u32Frequency))
	{
		u8Band = TUNMSTR_SRCCHG_BAND_LW;
	}
	else if(((unsigned int)m_poclConfigInterface->u32GetConfigData("HighMW") >= u32Frequency) && ((unsigned int)m_poclConfigInterface->u32GetConfigData("LowMW") <= u32Frequency))
	{
		u8Band = TUNMSTR_SRCCHG_BAND_AM;
	}

	return u8Band;
}
#endif
/*************************************************************************************
 *FUNCTION:    tunmstr_TunerClientHandler::vSendMessage
 *
 *DESCRIPTION: This function converts Amt message to visitor class and
 *             get the data from visitor to the FI class. Refer FI Manual.Doc.
 *
 *PARAMETER:    tU16,fi_tclTypeBase& ,tU16,tU8,tU16,tU16
 *
 *RETURNVALUE: None
 ************************************************************************************/
tVoid tunmstr_TunerClientHandler :: vSendMessage( tU16             u16DestAppID,
		const fi_tclTypeBase&  oOutData,
		tU16             u16Fid,
		tU8              u8OpCode,
		tU16             u16CmdCtr)
{
	if((m_potunmaster_Config == NULL) || ( NULL == poGWMain ) || (m_u16TunerRegID == AMT_C_U16_REGID_INVALID))
	{
		NORMAL_M_ASSERT (NULL != m_potunmaster_Config);
		NORMAL_M_ASSERT (NULL != poGWMain);
		return ;
	}


	fi_tclVisitorMessage oOutVisitorMsg(oOutData,1);


	// Set the CCA message information
	oOutVisitorMsg.vInitServiceData(  CCA_C_U16_APP_TUNERMASTER,                  /* Source app-ID    */
			u16DestAppID,                         /* Dest. app-ID     */
			AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,    /* stream type      */
			0,                                    /* stream counter   */
			m_u16TunerRegID,                             /* Registry ID      */
			u16CmdCtr,                            /* Command counter  */
			CCA_C_U16_SRV_TUNERCONTROL,                /* Service-ID       */
			u16Fid,                               /* Function-ID      */
			u8OpCode,                             /* OpCode           */
			0,                                    /* ACT              */
			0,                                    /* Source sub-ID    */
			0 );                                  /* Dest. sub-ID     */
	// Send it to the client
	if(poGWMain->enPostMessage(&oOutVisitorMsg, TRUE) != AIL_EN_N_NO_ERROR)
	{
		//Trace for Error message if required.
	}

}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vHandle_s_ActiveTuner( )
 *
 * DESCRIPTION:  gives Active info
 *
 * PARAMETER:     amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  Void.
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vHandle_s_ActiveTuner(amt_tclServiceData* poMessage )
{
	if((poMessage == NULL )||(m_potunmstr_MsgToHMI == NULL))
	{
		ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandle_s_ActiveTuner, Null pointer"));
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		return;

	}
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
	{
		midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodResult oMsgData;
		vGetDatafromAMT(poMessage,oMsgData);
		tU8 u8CurrentActivetTuner = (tU8)oMsgData.u8_PhysicalTuner.enType;
		m_potunmstr_MsgToHMI->vSend_s_TunerInfo(u8CurrentActivetTuner);
		ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandle_s_ActiveTuner, result sent"
				"TunerHeader=%d",
				u8CurrentActivetTuner ));
	}
	break;
	default:
	{
		break;
	}

	};// switch
}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vHandle_s_ChangeLsm( )
 *
 * DESCRIPTION:  handle change lsm result
 *
 * PARAMETER:     amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  Void.
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vHandle_s_ChangeLsm(amt_tclServiceData* poMessage )
{
	if(poMessage == NULL )
	{
		ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandle_s_ChangeLsm, Null pointer"));
		NORMAL_M_ASSERT( poMessage != NULL );
		return;

	}
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
	{
		midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodResult oMsgData;
		vGetDatafromAMT(poMessage,oMsgData);
		tU8 u8Status = (tU8)oMsgData.TunerServer_StatusResponse.u8TunerStatus.enType;
		ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandle_s_ChangeLsm, Status = %d", u8Status));
		break;
	}
	default:
	{
		break;
	}

	};// switch
}


/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vHandle_s_SetPI( )
 *
 * DESCRIPTION:  handle change set PI result
 *
 * PARAMETER:     amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  Void.
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vHandle_s_SetPI(amt_tclServiceData* poMessage )
{
	if(poMessage == NULL )
	{
		ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandle_s_SetPI, Null pointer"));
		NORMAL_M_ASSERT( poMessage != NULL );
		return;

	}
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
	{
		midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodResult oMsgData;
		vGetDatafromAMT(poMessage,oMsgData);
		tU8 u8Status = (tU8)oMsgData.TunerServer_StatusResponse.u8TunerStatus.enType;
		ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandle_s_SetPI, Status = %d", u8Status));
		break;
	}
	default:
	{
		break;
	}

	};// switch
}


/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vHandle_s_PSFreezeResult( )
 *
 * DESCRIPTION:  handle PS freeze result
 *
 * PARAMETER:     amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  Void.
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vHandle_s_PSFreezeResult(amt_tclServiceData* poMessage )
{
	if(poMessage == NULL )
	{
		ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandle_s_PSFreezeResult, Null pointer"));
		NORMAL_M_ASSERT( poMessage != NULL );
		return;

	}
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
	{
		midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodResult oMsgData;
		vGetDatafromAMT(poMessage,oMsgData);
		tU8 u8Status = (tU8)oMsgData.TunerServer_StatusResponse.u8TunerStatus.enType;
		ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandle_s_PSFreezeResult, Status = %d", u8Status));
		break;
	}
	default:
	{
		break;
	}

	};// switch
}


/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vHandle_s_DirectFrequency( )
 *
 * DESCRIPTION:  On Reciving Method result follwoinga ctions to be performed.
 * 	1) Check if Audio has requested for Band change.
 * 	2)Compare for Band values, if different forward that request to fc_amfmtuner
 * 	3)Clear SDS Band change and Frequency request flag
 * 	4)Set Tuner status to InProgress so that we send response back to ARL
 * 	5)Set SDS band calue to Inavlid
 *
 * PARAMETER:     amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  Void.
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vHandle_s_DirectFrequency(amt_tclServiceData* poMessage )
{
	if((poMessage == NULL )||(m_potunmstr_MsgToHMI == NULL) || (m_potunmstr_SrcChgManager == NULL)
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			|| (m_potunmstr_AudioClientHandler == NULL)
#endif
			)
	{
		ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandle_s_DirectFrequency, Null pointer"));
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
#endif
		return;
	}
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
	{
		midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodResult oMsgData;
		vGetDatafromAMT(poMessage,oMsgData);

		tU8 u8Status = (tU8)oMsgData.TunerServer_StatusResponse.u8TunerStatus.enType;

		if( (tU8)TUNMSTR_SRCCHG_RES_REQ_SUCCEED == u8Status )
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		{
			//1) Check if Audio has requested for Band change, if so forward that to fc_amfmtuner
			if(TRUE == m_potunmstr_SrcChgManager->blGetBandChgSDS_status())
			{
				vHandleSDSDirectFreqReq();
			}//if(TRUE == m_potunmstr_SrcChgManager->blGetBandChgSDS_status())
			else
			{
				ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandle_s_DirectFrequency, Band Change not requested from ARL"));
			}
			m_potunmstr_SrcChgManager->vSetDirectFrqRequest_Status(FALSE);
			ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandle_s_DirectFrequency, result sent"
					"FrqRequest = %d",
					m_potunmstr_SrcChgManager->blGetDirectFrqRequest_Status()));
			//Set SDS band calue to Inavlid
			m_potunmstr_SrcChgManager->vSetSDSBand(TUNMSTR_SRCCHG_INVALID);
		}//if(TUNMSTR_SRCCHG_RES_REQ_SUCCEED == u8Status )
#else
		{
			ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandle_s_DirectFrequency status received"));
			m_poSessionControl->vOnDirectFrequencyResult();
		}

#endif
	}//case end
	break;
	default:
	{
		break;
	}
	};// switch
}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vHandle_s_AudioFgBg( )
 *
 * DESCRIPTION:  Get PS Name of Tuner valaidity check.
 *
 * PARAMETER:     tU8 u8WhichTuner
 *
 * RETURNVALUE:  tBOOL - Valid or Invalid.
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vHandle_s_AudioFgBg(amt_tclServiceData* poMessage )
{
	if((poMessage == NULL )|| (m_potunmstr_SrcChgManager == NULL) || (m_poclConfigInterface == NULL)
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			|| (m_poSessionControl == NULL)
#endif
			)
	{
		ET_TRACE_ERROR_BIN( TUNMSTR_TRACE_CLASS_TUNCLIENT_HANDLER,\
				ET_EN_T16 _ TUNMSTR_TRACE_TUNCLT_HANDLER_NULL_POINTER _\
				ET_EN_DONE );

		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL);
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT(m_poSessionControl != NULL);
#endif
		return;

	}
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
	{
		tU8 u8Status;

		midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodResult oMsg;
		vGetDatafromAMT(poMessage,oMsg);
		
		if(oMsg.TunAudioFgBgStatus.u8_TunerHeader.enType == midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_INVALID_TYPE)
		{
			/*Fix for Bug 425420 */
			ETG_TRACE_USR2(( " vHandle_s_AudioFgBg()->oMsg.TunAudioFgBgStatus.u8_TunerHeader.enType=%d ",oMsg.TunAudioFgBgStatus.u8_TunerHeader.enType));
			return;
		}
		u8Status = (tU8)oMsg.TunerServer_StatusResponse.u8TunerStatus.enType;
		
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		if(m_poclConfigInterface->u32GetConfigData("SBR"))
		{
			ETG_TRACE_USR1(( " vHandle_s_AudioFgBg()->m_u8TunerHeader=%d MTCAudioSource=%d",m_u8TunerHeader,(tU8)oMsg.TunAudioFgBgStatus.e8MTCAudioSource.enType));
			/*For DAB anno source, this call is not required */
			if(bIsTemporarySource(m_poSessionControl->oGetRequestedSource()))
			{
				if(oGetTunerClient(getTunerSourceId(oMsg.TunAudioFgBgStatus.e8MTCAudioSource.enType)) == tuner::common::AMFMTUNER) {
					oAnnouncementControl.vOnNewTunerState(oMsg.TunAudioFgBgStatus.u8_TunerHeader.enType, oMsg.TunAudioFgBgStatus.e8MTCAudioSource.enType);
				}
				/*For DAB Anno Off tunermaster is not receiving result for select_s_anno method. It should remove, if fc_dab start sending method result for select_s_anno */
				else if (m_poSessionControl->oGetRequestedSourceActivity() == tuner::common::SRCOFF) {
					oAnnouncementControl.vOnNewTunerState(oMsg.TunAudioFgBgStatus.u8_TunerHeader.enType, oMsg.TunAudioFgBgStatus.e8MTCAudioSource.enType);
				}
			}
			m_poSessionControl->vOnNewTunerBand(midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_INVALID);
			m_poSessionControl->vOnNewTunerState(oMsg.TunAudioFgBgStatus.u8_TunerHeader.enType, oMsg.TunAudioFgBgStatus.e8MTCAudioSource.enType);
		}
		else 
		{
			ETG_TRACE_USR1(( " vHandle_s_AudioFgBg()->m_u8TunerHeader=%d m_u8AudioSink=%d",m_u8TunerHeader,m_u8AudioSink));
			if(bIsTemporarySource(m_poSessionControl->oGetRequestedSource()))
			{
				oAnnouncementControl.vOnNewTunerState(oMsg.TunAudioFgBgStatus.u8_TunerHeader.enType, oMsg.TunAudioFgBgStatus.u8AudioSink.u8Value);
			}
			m_poSessionControl->vOnNewTunerBand(midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_INVALID);
			m_poSessionControl->vOnNewTunerState(oMsg.TunAudioFgBgStatus.u8_TunerHeader.enType, oMsg.TunAudioFgBgStatus.u8AudioSink.u8Value);
		}
		if(bIsRequestedSourceFM())
		{
			if( tuner::common::DAB != m_poArlImpl->getActiveSource() && tuner::common::TUNERTOFG != m_poSessionControl->getActiveTunerState(tuner::common::DABTUNER)) /*Added as fix for NCG3D-39180*/
				vHandleDABSurvivellenceState();
		}
#else
		m_potunmstr_SrcChgManager->vMethodResult_SrcChg_FrmTuner( u8Status);
#endif

		ET_TRACE_INFO_BIN(TUNMSTR_TRACE_CLASS_TUNCLIENT_HANDLER,
				ET_EN_T16 _ TUNMSTR_TRACE_TUNCLT_HANDLE_S_AUDIOFGBG _
				ET_EN_T8 _ u8Status _
				ET_EN_DONE);

	}
	break;
#if 0
	case AMT_C_U8_CCAMSG_OPCODE_STATUS:
	{
		midw_tunerfi_tclMsgFID_TUN_G_AUDIO_FG_BG_NEWStatus oStatus;

		vGetDatafromAMT(poMessage,oStatus);
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
      if(bIsTemporarySource(m_poSessionControl->oGetRequestedSource()))
      {
    	  oAnnouncementControl.vOnNewTunerState(oStatus.TunAudioFgBgStatus.u8_TunerHeader.enType, oStatus.TunAudioFgBgStatus.u8AudioSink.u8Value);
      }
      m_poSessionControl->vOnNewTunerState(oStatus.TunAudioFgBgStatus.u8_TunerHeader.enType, oStatus.TunAudioFgBgStatus.u8AudioSink.u8Value);
	  m_poSessionControl->vOnNewTunerBand(midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_INVALID);
#else
		if(midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_TUN_FOREGROUND == oStatus.TunAudioFgBgStatus.u8_TunerHeader.enType)
		{
			m_potunmstr_SrcChgManager->vSetTunerState((tU8)TUNMSTR_SRCCHG_FOREGROUND);
		}
		else
		{
			m_potunmstr_SrcChgManager->vSetTunerState((tU8)TUNMSTR_SRCCHG_BACKGROUND);
		}
#endif
	}break;
#endif
	default:
		break;
	};// switch
}
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
/*************************************************************************************/
tBool tunmstr_TunerClientHandler::bIsRequestedSourceFM()
{
	if(m_poArlImpl->getActiveSourceActivity()!=tuner::common::SRCOFF &&
			tuner::common::FM1== m_poArlImpl->getActiveSource() && tuner::common::SRC_CHANGE_COMPLETED==m_poArlImpl->getActiveSessionState())
	{
		return true;
	}
	return false;
}
#endif
/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vHandle_s_BandChange( )
 *
 * DESCRIPTION:  Get PS Name of Tuner valaidity check.
 *
 * PARAMETER:     tU8 u8WhichTuner
 *
 * RETURNVALUE:  tBOOL - Valid or Invalid.
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vHandle_s_BandChange(amt_tclServiceData* /*poMessage */)
{
#if 0
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	if((poMessage == NULL )|| (m_potunmstr_SrcChgManager == NULL))
	{
		ET_TRACE_ERROR_BIN( TUNMSTR_TRACE_CLASS_TUNCLIENT_HANDLER,\
				ET_EN_T16 _ TUNMSTR_TRACE_TUNCLT_HANDLER_NULL_POINTER _\
				ET_EN_DONE );

		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager );
		return;
	}
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
	{
		tU8 u8Status;

		midw_tunerfi_tclMsgFID_TUN_CHANGE_BANDMethodResult oMsg;
		vGetDatafromAMT(poMessage,oMsg);
		u8Status = (tU8) oMsg.TunerServer_StatusResponse.u8TunerStatus.enType;

		m_potunmstr_SrcChgManager->vMethodResult_BandChg_FrmTuner( u8Status);

		ET_TRACE_INFO_BIN(TUNMSTR_TRACE_CLASS_TUNCLIENT_HANDLER,
				ET_EN_T16 _ TUNMSTR_TRACE_TUNCLT_HANDLE_S_BANDCANGE _
				ET_EN_DONE);

	}
	break;
	default:
	{
		break;
	}

	};// switch
#else
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
	{
	   midw_tunerfi_tclMsgFID_TUN_CHANGE_BANDMethodResult oMsg;
	   vGetDatafromAMT(poMessage,oMsg);
	   if((tU8) oMsg.TunerServer_StatusResponse.u8TunerStatus.enType == TUNMSTR_SRCCHG_RES_REQ_SUCCEED)
	   {
	      m_poSessionControl->vOnNewTunerBand(midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_INVALID);
			if(bIsRequestedSourceFM())
			{
				if( tuner::common::DAB != m_poArlImpl->getActiveSource() && tuner::common::TUNERTOFG != m_poSessionControl->getActiveTunerState(tuner::common::DABTUNER)) /*Added as fix for NCG3D-39180*/
					vHandleDABSurvivellenceState();
			}
	   }
	}
	break;
	default:
	{
		break;
	}

	};// switch
#endif
#endif
}
/*************************************************************************/
 
/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vSend_s_Audio_FG_BG_New( tU8 u8TunHeader, tU8 u8SubCommand, tU8 u8AUdioSink)
 *
 * DESCRIPTION:  This function is used to send Source change infomation to fc_amfmtuner
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vSend_s_Audio_FG_BG_New(tU8 u8TunHeader, tU8 u8SubCommand, tU8 u8AudioSink,tU8 u8TunerState ,tU8 u8_PhysicalTuner, tU8 u8TunBand)
{

	if((m_ptunmstr_Preset_Handler==NULL) || (m_ptunmstr_AutoStoreHandler == NULL))
	{
		return;
	}
	midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart oMsgData;

	ETG_TRACE_USR4(( " vSend_s_Audio_FG_BG_New()->u8TunerState=%d\n",u8TunerState));

	oMsgData.TunAudFGBGNew.u8_TunerHeader.enType = (midw_fi_tcl_e8_Tun_TunerHeader::tenType)u8TunHeader;
	oMsgData.TunAudFGBGNew.u8SubCommand.enType =(midw_fi_tcl_e8_Tun_SubCommand::tenType)u8SubCommand;
	oMsgData.TunAudFGBGNew.u8AudioSink.enType = (midw_fi_tcl_e8_Tun_AudioSink::tenType)u8AudioSink;

	oMsgData.TunAudFGBGNew.bTunerState = (tBool)u8TunerState;
	oMsgData.TunAudFGBGNew.u8_PhysicalTuner.enType =(midw_fi_tcl_e8_Tun_PhysicalTuner::tenType)u8_PhysicalTuner;
	
	oMsgData.TunAudFGBGNew.e8Band.enType = (midw_fi_tcl_e8_Tun_TunerBand::tenType)u8TunBand;
	
	ETG_TRACE_USR4(( " vSend_s_Audio_FG_BG_New()->band= %d",u8TunBand));

	vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
			oMsgData,           // parameter&
			MIDW_TUNERFI_C_U16_FID_TUN_S_AUDIO_FG_BG_NEW, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0);
//	stPresetHandlingReguest oPresetHandleReq=m_ptunmstr_Preset_Handler->stGetPresetHandleRequest();
//	if((u8SubCommand == (tU8)midw_fi_tcl_e8_Tun_SubCommand::FI_EN_TUN_CHANGE_TO_FG) && (oPresetHandleReq.blReguestPending==TRUE))
//	{
//
//		if(oPresetHandleReq.ePresetAction.enType==midw_fi_tcl_e8_Tun_PresetAction::FI_EN_RECALL_ELEMENT)
//		{
//			m_ptunmstr_Preset_Handler->vUpdatePresetRequestVar(NormalPresetRecall);
//			m_potunmstr_AudioClientHandler->vStoreMuteParameter(m_potunmstr_AudioClientHandler->enConvertFiSourcetoArlSrc((tU8)oPresetHandleReq.eBand.enType),
//					ARL_EN_MUTEACTION_MUTE,ARL_EN_MUTE_REASON_OTHER);
//			m_potunmstr_AudioClientHandler->vSendMuteState(m_potunmstr_AudioClientHandler->enConvertFiSourcetoArlSrc((tU8)oPresetHandleReq.eBand.enType),
//					ARL_EN_MUTEACTION_MUTE,ARL_EN_MUTE_REASON_OTHER);
//		}
//		midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodStart oMethodStart;
//		oMethodStart.e8Action.enType=oPresetHandleReq.ePresetAction.enType;
//		oMethodStart.u8ListElementID=oPresetHandleReq.u8Element_ID;
//		tU8 u8List = (tU8)oPresetHandleReq.eList.enType;
//		oMethodStart.e8ListID.enType= (midw_fi_tcl_e8_Tun_ListID::tenType)u8List;
//		vSendMessage( CCA_C_U16_APP_TUNER,
//				oMethodStart,
//				MIDW_TUNERFI_C_U16_FID_TUN_S_PRESET_HANDLING,
//				AMT_C_U8_CCAMSG_OPCODE_METHODSTART,
//				0
//		);
//
//			m_ptunmstr_Preset_Handler->vClearPreserHandleRequest();
//	}
//	else
//	{
//
//	}
	tBool blNormalAST_Status = m_ptunmstr_AutoStoreHandler->blGetNormalAST_Request();
	//tBool blInitialAST_Status = m_ptunmstr_AutoStoreHandler->m_blGetInitalAST_Request();
	if(blNormalAST_Status == TRUE)
	{
		vSend_s_AutoStore(m_ptunmstr_AutoStoreHandler->u8GetAST_ListID() ,m_ptunmstr_AutoStoreHandler->blGetAST_Status());
		m_ptunmstr_AutoStoreHandler->vSetNormalAST_Status(FALSE);
		m_ptunmstr_AutoStoreHandler->vSetAST_ListID(TUNMSTR_SRCCHG_INVALID);
		ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vSend_s_Audio_FG_BG_New, pending AST requests ent to Tuner"));
	}
	else
	{
	}
	ET_TRACE_INFO_BIN(TUNMSTR_TRACE_CLASS_TUNCLIENT_HANDLER,\
			ET_EN_T16 _ TUNMSTR_TRACE_TUNCLT_SEND_S_AUDIOFGBG _\
			ET_EN_DONE);

}

tVoid tunmstr_TunerClientHandler::vSend_MTCAudiosource(midw_fi_tcl_e8_Tun_TunerHeader::tenType e8TunerState, midw_fi_tcl_e8_Tun_MTCAudioSource::tenType e8MTCAudioSource, midw_fi_tcl_e8_Tun_TunerBand::tenType e8Band, bool bIsAnnoSrcOffRequest)
{
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB

	ETG_TRACE_USR4(( " vSend_MTCAudiosource()->u8TunerState=%d\n",e8TunerState));
	ETG_TRACE_USR4(( " vSend_MTCAudiosource()->MTC audio source= %d",e8MTCAudioSource));
	ETG_TRACE_USR4(( " vSend_MTCAudiosource()->bIsAnnoSrcOffRequest= %d",bIsAnnoSrcOffRequest));
	ETG_TRACE_USR4(( " vSend_MTCAudiosource()->band= %d",e8Band));

	midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart oMsgData;
	if(bIsAnnoSrcOffRequest == true && e8MTCAudioSource == midw_fi_tcl_e8_Tun_MTCAudioSource::FI_EN_TUN_LASTAUDIOSOURCE)
	{
		if(m_poSessionControl->getStoredPreviousSessionStateBeforeAnnoucementSrcActivity() == tuner::common::SRCON || m_poSessionControl->getStoredPreviousSessionStateBeforeAnnoucementSrcActivity() == tuner::common::SRCPAUSE)
		{
			oMsgData.TunAudFGBGNew.u8_TunerHeader.enType = midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_TUN_FOREGROUND;
			tuner::common::enSourceId tunerSourceId = m_poSessionControl->getStoredPreviousSessionStateBeforeAnnoucementSrc();
			oMsgData.TunAudFGBGNew.e8MTCAudioSource.enType = getMTCAudioSource(oGetBand(tunerSourceId), tunerSourceId);
		}
		else
		{
			oMsgData.TunAudFGBGNew.u8_TunerHeader.enType = midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_TUN_BACKGROUND;
			oMsgData.TunAudFGBGNew.e8MTCAudioSource.enType = midw_fi_tcl_e8_Tun_MTCAudioSource::FI_EN_TUN_NOHEARDSOURCE;
		}
	}
	else if(e8TunerState != midw_fi_tcl_e8_Tun_TunerHeader::FI_EN_INVALID_TYPE)
	{
		oMsgData.TunAudFGBGNew.u8_TunerHeader.enType = e8TunerState;
		oMsgData.TunAudFGBGNew.e8MTCAudioSource.enType = e8MTCAudioSource;
	}
	else {
		ETG_TRACE_USR4(( " vSend_MTCAudiosource() No action"));
		return;
	}

	/*below parameters are not required, hence setting it to invalid */
	oMsgData.TunAudFGBGNew.u8SubCommand.enType =midw_fi_tcl_e8_Tun_SubCommand::FI_EN_INVALID_TYPE;
	oMsgData.TunAudFGBGNew.u8AudioSink.enType = midw_fi_tcl_e8_Tun_AudioSink::FI_EN_INVALID_TYPE;
	oMsgData.TunAudFGBGNew.bTunerState = false;
	oMsgData.TunAudFGBGNew.u8_PhysicalTuner.enType =midw_fi_tcl_e8_Tun_PhysicalTuner::FI_EN_INVALID_TYPE;
	oMsgData.TunAudFGBGNew.e8Band.enType = e8Band;

	vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
			oMsgData,           // parameter&
			MIDW_TUNERFI_C_U16_FID_TUN_S_AUDIO_FG_BG_NEW, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0);
#endif
}

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
tVoid tunmstr_TunerClientHandler::vHandleDABSurvivellenceState()
{
	ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandleDABSurvivellenceState AnnouncementSwitch = %d", oAnnouncementControl.bIsAnnouncementSwitchOn()));
	ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandleDABSurvivellenceState dabTunerState = %d", m_poSessionControl->getActiveTunerState(tuner::common::DABTUNER)));
	if((m_poclConfigInterface!=NULL) && (NULL!=m_potunmstr_DABClient_Handler))
	{
		if((m_poclConfigInterface->u32GetConfigData("DABSupported")) && (m_poArlImpl->getActiveSessionState()!=tuner::common::SRC_CHANGE_IN_PROGRESS))
		{
			tuner::common::enTunerState dabTunerState = m_poSessionControl->getActiveTunerState(tuner::common::DABTUNER);
			//TP switch is Off
			if(!oAnnouncementControl.bIsAnnouncementSwitchOn())
			{ 
				ETG_TRACE_USR4((" tunmstr_TunerClientHandler::TP switch is Off"));
				if(tuner::common::FGANNOSURVIVELLENCE==m_poSessionControl->getActiveTunerState(tuner::common::DABTUNER)
				|| tuner::common::BGANNOSURVIVELLENCE==m_poSessionControl->getActiveTunerState(tuner::common::DABTUNER))
				{
					dabTunerState = tuner::common::TUNERTOBG;
				}
			}
			// TP switch is oN
			else
			{
				//In Radio Source
				ETG_TRACE_USR4((" tunmstr_TunerClientHandler::TP switch is On"));
				bool blDabStateUpdateRequired =bIsDabStateUpdateRequired(dabTunerState, oAnnouncementControl.oGetPICode());
				if( m_poArlImpl->getActiveSourceActivity() != tuner::common::SRCOFF && m_poArlImpl->getActiveSourceActivity() != tuner::common::SRCACTIVITY_UNKNOWN)
				{
					//the current radio source supports AnnouncementSurvivellenceMode
					if(tuner::announcements::clAnnouncementSettings::instance()->bIsAnnouncementSurvivellenceModeSupport(m_poArlImpl->getActiveSource()))
					{
						//Send dab tuner to the state update by bIsDabStateUpdateRequired function
					}
					else if(m_poArlImpl->getActiveSource()!=tuner::common::DAB && m_poArlImpl->getActiveSource()!=tuner::common::FMANNOUNCEMENTS && m_poArlImpl->getActiveSource()!=tuner::common::DABANNOUNCEMENTS)
					{
						dabTunerState = tuner::common::TUNERTOBG;
					}
				}
				/*In Non radio source*/
				else if(tuner::announcements::clAnnouncementSettings::instance()->bIsAnnouncementSurvivellenceModeSupport(tuner::common::SOURCEID_LIMIT))
				{
					if(!blDabStateUpdateRequired)
					{
						dabTunerState = tuner::common::TUNERTOBG;
					}
				}
			}
			tuner::common::enTunerState currentdabTunerState = m_poSessionControl->getActiveTunerState(tuner::common::DABTUNER);
			ETG_TRACE_USR4((" tunmstr_TunerClientHandler::currentdabTunerState =%d dabTunerState=%d",currentdabTunerState,dabTunerState));
			if(currentdabTunerState!=dabTunerState)
			{
				m_poSessionControl->vOnNewDabTunerState(dabTunerState);
				m_potunmstr_DABClient_Handler->vSendSourceState(dabTunerState);
			}
		}
	}
}
#endif

/*************************************************************************
  *************************************************************************/
tVoid tunmstr_TunerClientHandler::vSend_s_DemodulationSwitch(tU8 u8ModSwitch, tBool bDRMValue)
{	
    midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodStart oMethodStart;
	oMethodStart.b8DemodulationSwitchMask.u8Value = u8ModSwitch;
	oMethodStart.b8DemodulationSwitchValue.u8Value = u8ModSwitch;
    if(u8ModSwitch == midw_fi_tcl_b8_Tun_DemodSwitch::FI_C_U8_BIT_DRM30)
    {

        oMethodStart.b8DemodulationSwitchValue.vSetDRM30(bDRMValue);
    }
	
	vSendMessage(	CCA_C_U16_APP_TUNER,
					oMethodStart, 
					MIDW_TUNERFI_C_U16_FID_TUN_S_SET_DEMODULATION_SWITCH, 
					AMT_C_U8_CCAMSG_OPCODE_METHODSTART,0);

	ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vSend_s_DemodulationSwitch, Msg Sent"));
}


/*************************************************************************
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vSend_s_AudioDevice(tunerString sSinkName)
{	
	
	midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodStart oMethodStart;
    oMethodStart.sDRMAudioSinkName.bSet(sSinkName.c_str(), midw_fi_tclString::FI_EN_UTF8);
  
	vSendMessage( CCA_C_U16_APP_TUNER,
			oMethodStart, 
			MIDW_TUNERFI_C_U16_FID_TUN_S_AUDIO_DEVICE, 
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,0);

	ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vSend_s_AudioDevice, Msg Sent"));
}	
/*************************************************************************
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vSend_s_DRMSourceActivity(enTunmstr_DRMSourceActivity   e8SrcAct)
{
    midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodStart oMethodStart;
    oMethodStart.e8DRMSourceActivity.enType = (midw_fi_tcl_e8_Tun_DRMSourceActivity::tenType)e8SrcAct;

	vSendMessage(	CCA_C_U16_APP_TUNER,
					oMethodStart, 
					MIDW_TUNERFI_C_U16_FID_TUN_S_SET_DRM_SRCACTIVITY, 
					AMT_C_U8_CCAMSG_OPCODE_METHODSTART,0);

	ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vSend_s_DRMSourceActivity, Msg Sent"));
}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vSend_s_ChangeBand( tU8 u8TunBand)
 *
 * DESCRIPTION:  This function is used to send Band change infomation to fc_amfmtuner
 *
 * PARAMETER:    u8TunBand
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vSend_s_ChangeBand(tU8 /*u8TunBand*/)
{
#if 0
	midw_tunerfi_tclMsgFID_TUN_CHANGE_BANDMethodStart oMsgData;

	oMsgData.u8Band.enType = (midw_fi_tcl_e8_Tun_TunerBand::tenType)u8TunBand;

	vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
			oMsgData,           // parameter&
			MIDW_TUNERFI_C_U16_FID_TUN_CHANGE_BAND, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0);
	ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vSend_s_ChangeBand, Msg Sent"));
#endif
}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::tunmstr_TunerClientHandler( )
 *
 * DESCRIPTION:  This function is used to send Method start for Stop running Announcement
 * PARAMETER:    u8ListElementID
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vSend_s_Stop_Anno(tU8 u8Anno)
{

	midw_tunerfi_tclMsgFID_TUN_S_ANNOUNCEMENT_ESCAPEMethodStart oMsgData;

	oMsgData.e8AnnoType.enType =(midw_fi_tcl_e8_Tun_AnnoTypes::tenType)u8Anno;

	vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
			oMsgData,           // parameter&
			MIDW_TUNERFI_C_U16_FID_TUN_S_ANNOUNCEMENT_ESCAPE, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0);


	ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vSend_s_Stop_Anno, Msg Sent"));
}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vSend_s_ActiveTuner( )
 *
 * DESCRIPTION:  Method start for FID_TUN_S_ACTIVE_TUNER
 * PARAMETER:    Void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vSend_s_ActiveTuner()
{
	midw_tunerfi_tclMsgFID_TUN_S_ACTIVE_TUNERMethodStart oMsgData;


	vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
			oMsgData,           // parameter&
			MIDW_TUNERFI_C_U16_FID_TUN_S_ACTIVE_TUNER, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0);


	ET_TRACE_INFO_BIN(TUNMSTR_TRACE_CLASS_TUNCLIENT_HANDLER,
			ET_EN_T16 _ TUNMSTR_TRACE_TUNCLT_SEND_S_STOP_ANNO _
			ET_EN_DONE);
}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vSend_s_ActiveTuner( )
 *
 * DESCRIPTION:  Method start for FID_TUN_S_DIRECT_FREQUENCY
 * PARAMETER:    Void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vSend_s_DirectFrq_input(tU32 u32Frequency , tU8 u8Band)
{
	midw_tunerfi_tclMsgFID_TUN_S_DIRECT_FREQUENCYMethodStart oMsgData;
	oMsgData.u32Frequency = u32Frequency;
	oMsgData.u8Band.enType = (midw_fi_tcl_e8_Tun_TunerBand::tenType)u8Band;


	vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
			oMsgData,           // parameter&
			MIDW_TUNERFI_C_U16_FID_TUN_S_DIRECT_FREQUENCY, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0);


	ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vSend_s_DirectFrq_input, Msg Sent, u32Frequency = %d, u8Band = %d", (tU32)oMsgData.u32Frequency, (tU8)oMsgData.u8Band.enType));
}


/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vSend_s_SetPIFreq_Input( )
 *
 * DESCRIPTION:  Method start for FID_TUN_S_SET_PI
 * PARAMETER:    Void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vSend_s_SetPIFreq_Input(tU32 u32Frequency , tU16 u16PI)
{
	midw_tunerfi_tclMsgFID_TUN_S_SET_PIMethodStart oMsgData;
	oMsgData.TunSetPIPara.u8AbsOrRel.enType = midw_fi_tcl_e8_Tun_Abs_Or_Rel::FI_EN_TUN_PI_ABS;
	oMsgData.TunSetPIPara.u8RelSteps.enType = midw_fi_tcl_e8_Tun_Rel_Steps::FI_EN_INVALID_TYPE;
	oMsgData.TunSetPIPara.u8Direction.enType = midw_fi_tcl_e8_Tun_Direction::FI_EN_INVALID_TYPE;
	oMsgData.TunSetPIPara.u8Nsteps = 0;
	oMsgData.TunSetPIPara.u32Frequency = u32Frequency;
	oMsgData.TunSetPIPara.u16PI = u16PI;


	vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
			oMsgData,           // parameter&
			MIDW_TUNERFI_C_U16_FID_TUN_S_SET_PI, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0);


	ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vSend_s_SetPIFreq_Input, Msg Sent, u32Frequency = %d, PI = %d", (tU32)oMsgData.TunSetPIPara.u32Frequency, (tU8)oMsgData.TunSetPIPara.u16PI));
}


/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::tunmstr_TunerClientHandler( )
 *
 * DESCRIPTION:  This function is used to send Method start for Stop running Announcement
 * PARAMETER:    u8ListElementID
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vHandle_g_Announcement_Switch(amt_tclServiceData* poMessage)
{
	if((poMessage == NULL ) || (m_potunmstr_MsgToHMI == NULL) || (m_potunmstr_SrcChg_AnnoHandler == NULL))
	{
		ET_TRACE_ERROR_BIN( TUNMSTR_TRACE_CLASS_TUNCLIENT_HANDLER,\
				ET_EN_T16 _ TUNMSTR_TRACE_TUNCLT_HANDLER_NULL_POINTER _\
				ET_EN_DONE );

		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI );
		NORMAL_M_ASSERT( m_potunmstr_SrcChg_AnnoHandler );
		return;

	}
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_STATUS:
	{
		midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_SWITCHStatus oStatusMsg;
		//create an object of  FID_TUN_G_ANNOUNCEMENT_SWITCH
		vGetDatafromAMT(poMessage,oStatusMsg);
		tBool blTPState= oStatusMsg.bTPState;
		tBool blPTYState = oStatusMsg.bPTYState;
		m_bPTYState = oStatusMsg.bPTYState;
		m_potunmstr_SrcChg_AnnoHandler->vHandleAnnoSwitchState(blTPState,blPTYState,oStatusMsg.bWeatherAlertState);
#ifdef	VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
		oAnnouncementControl.vSetAnnouncementSwitch(blTPState);
		if( tuner::common::DAB != m_poArlImpl->getActiveSource() && tuner::common::TUNERTOFG != m_poSessionControl->getActiveTunerState(tuner::common::DABTUNER)) /*Added as fix for NCG3D-39180*/
			vHandleDABSurvivellenceState();
#endif
	}
	break;
	case AMT_C_U8_CCAMSG_OPCODE_UPREG:
	case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
	default:
	{
		break;
	}

	};// end of switch

}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vHandle_g_Component_Status( )
 *
 * DESCRIPTION:  This function is used to send Method start for Stop running Announcement
 * PARAMETER:    u8ListElementID
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vHandle_g_Component_Status(amt_tclServiceData* /*poMessage*/)
{
#if 0
	if((poMessage == NULL ) || (m_potunmstr_MsgToHMI == NULL) || (m_potunmstr_SrcChgManager == NULL))
	{
		ET_TRACE_ERROR_BIN( TUNMSTR_TRACE_CLASS_TUNCLIENT_HANDLER,\
				ET_EN_T16 _ TUNMSTR_TRACE_TUNCLT_HANDLER_NULL_POINTER _\
				ET_EN_DONE );

		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI );
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager );
		return;

	}
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_STATUS:
	{
		midw_tunerfi_tclMsgFID_TUN_G_COMPONENT_STATUS_TUNERStatus oStatusMsg;
		//create an object of  FID_TUN_G_SET_FEATURE
		vGetDatafromAMT(poMessage,oStatusMsg);
		tU8 u8AudioSink, u8BGMode;
		u8AudioSink = oStatusMsg.Component_status.u8AudioSinkTUN1;
		u8BGMode    = oStatusMsg.Component_status.u8BGModeTuner;
		ET_TRACE_ERROR_BIN( TUNMSTR_TRACE_CLASS_TUNCLIENT_HANDLER,\
				ET_EN_T16 _ TUNMSTR_TRACE_TUNCLT_HANDLER_COMP_STATUS _\
				ET_EN_T8 _ u8AudioSink _\
				ET_EN_T32 _ u8BGMode _\
				ET_EN_DONE );
		// extract data
		if( ( TUNMSTR_COMP_STATUS_BGMODE_TEMP_FM == u8BGMode )&&( TUNMSTR_COMP_STATUS_AUDSINK_USR_BG == u8AudioSink ))
		{
			//m_potunmstr_SrcChgManager->vSetBGTunerMode(TRUE);
			m_potunmstr_MsgToHMI->vSend_g_Band_Info((tU8)TUNMSTR_SRCCHG_SOURCE_TUN1AM, false);
		}
		else if (( TUNMSTR_COMP_STATUS_BGMODE_USER_FM == u8BGMode )&&( TUNMSTR_COMP_STATUS_AUDSINK_USR_BG == u8AudioSink ))
		{
			//m_potunmstr_SrcChgManager->vSetBGTunerMode(TRUE);
			m_potunmstr_MsgToHMI->vSend_g_Band_Info((tU8)TUNMSTR_SRCCHG_SOURCE_TUN1FM, false);
		}
		else
		{
			//m_potunmstr_SrcChgManager->vSetBGTunerMode(FALSE);
		}
	}
	break;
	case AMT_C_U8_CCAMSG_OPCODE_UPREG:
	case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
	default:
	{
		break;
	}

	};// end of switch
#endif
}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vHandle_g_Remote_Control( )
 *
 * DESCRIPTION:  Handler function for FID_TUN_G_DIAG_REMOTE_CONTROL
 * PARAMETER:    amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vHandle_g_Remote_Control(amt_tclServiceData* poMessage)
{
	if((poMessage == NULL ) || (m_potunmstr_SrcChgManager == NULL))
	{
		ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandle_g_Remote_Control, Null pointer"));
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager );
		return;
	}
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_STATUS:
	{
		midw_tunerfi_tclMsgFID_TUN_G_DIAG_REMOTE_CONTROLStatus oStatusMsg;
		//create an object of  FID_TUN_G_DIAG_REMOTE_CONTROL
		vGetDatafromAMT(poMessage,oStatusMsg);
		tBool blRemoteSession = oStatusMsg.bRemoteCtrl;
		m_potunmstr_SrcChgManager->vSetRemoteControl_Status(blRemoteSession);
		ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandle_g_Remote_Control"
				"RemoteSession = %d",
				blRemoteSession ));
	}
	break;
	case AMT_C_U8_CCAMSG_OPCODE_UPREG:
	case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
	default:
	{
		break;
	}

	};// end of switch

}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vHandle_g_AnnouncementInfo( )
 *
 * DESCRIPTION:  Handler function for FID_TUN_G_TAINFO
 * PARAMETER:    amt_tclServiceData* poMessage
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vHandle_g_AnnouncementInfo(amt_tclServiceData* poMessage)
{
	if(poMessage == NULL )
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		return;
	}
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_STATUS:
	{
		midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_INFOStatus oStatusMsg;
		//create an object of  FID_TUN_G_ANNOUNCEMENT_INFO
		vGetDatafromAMT(poMessage,oStatusMsg);
#ifdef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
		oAnnouncementControl.vSetPICode(oStatusMsg.AnnoInfoStatus.u16PI);
		if( tuner::common::DAB != m_poArlImpl->getActiveSource() && tuner::common::TUNERTOFG != m_poSessionControl->getActiveTunerState(tuner::common::DABTUNER)) /*Added as fix for NCG3D-39180*/
			vHandleDABSurvivellenceState(); 
#endif
			vHandle_MonitorFMTA(oStatusMsg.AnnoInfoStatus.u16PI);
	break;
		}
	default:
	{
		break;
	}

	}
}
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
tBool tunmstr_TunerClientHandler::bIsDabStateUpdateRequired(tuner::common::enTunerState &dabTunerState, tU16 u16PICode)
{
	ETG_TRACE_USR4((" bIsDabStateUpdateRequired dabTunerState=%d u16PICode=%d",dabTunerState,u16PICode));
	if(dabTunerState != tuner::common::TUNERTOFG)
	{
		if((u16PICode != 0) && (dabTunerState == tuner::common::FGANNOSURVIVELLENCE || dabTunerState == tuner::common::TUNERSTATE_UNKNOWN || dabTunerState == tuner::common::BGANNOSURVIVELLENCE))
		{
			dabTunerState = tuner::common::TUNERTOBG;
			return true;
		}
		else if(u16PICode == 0 &&
				(dabTunerState == tuner::common::TUNERTOBG || dabTunerState == tuner::common::TUNERSTATE_UNKNOWN ||tuner::common::FGANNOSURVIVELLENCE == dabTunerState || tuner::common::BGANNOSURVIVELLENCE == dabTunerState))
		{
#ifdef  VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
			dabTunerState = tuner::common::BGANNOSURVIVELLENCE;
#else
		/*DAB state is to be changed based on KDS  parameter AnnoSurveillance Hardcoding is removed */
					if ( 0x01 == m_poclConfigInterface->u32GetConfigData("AnnoSurveillance"))
					{
						dabTunerState = tuner::common::FGANNOSURVIVELLENCE;
					}
					else if( 0x02 == m_poclConfigInterface->u32GetConfigData("AnnoSurveillance"))
					{
						dabTunerState = tuner::common::BGANNOSURVIVELLENCE;
					}
					else
					{
						ETG_TRACE_USR4((" bIsDabStateUpdateRequired NO  AnnoSurveillance state"));
					}
#endif
			return true;
		}
	}
	ETG_TRACE_USR4((" bIsDabStateUpdateRequired return false"));
	return false;
}
#endif
/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vHandle_MonitorFMTA( )
 *
 * DESCRIPTION:
 * PARAMETER:    tU16 u16PICode
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vHandle_MonitorFMTA(tU16 u16PICode)
{
	if((m_potunmstr_SrcChgManager == NULL) || (m_potunmstr_SrcChg_AnnoHandler == NULL)
		|| (m_poclConfigInterface == NULL) || (NULL == m_potunmstr_MsgToHMI))
	{
		return;
	}
#ifndef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
	m_potunmstr_SrcChgManager->vHandleDABTempAnnouncement();
#endif

	ETG_TRACE_USR4(("TPStatus: AnnoucementInfo:: PICode=%d ",u16PICode));
	midw_fi_tcl_e8_AtStationTPinfo::tenType enTPState =midw_fi_tcl_e8_AtStationTPinfo::FI_EN_NO_TP;
#ifdef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
	tBool blSendUpdate = true;
	if(tuner::common::TUNERTOFG!=m_poSessionControl->getActiveTunerState(tuner::common::AMFMTUNER))
#else
	if(TUNMSTR_SRCCHG_FOREGROUND!=m_potunmstr_SrcChgManager ->u8GetTunerState())
#endif
	{
		ETG_TRACE_USR4(("TPStatus: AMFM tuner is not in FG and PI=%d",u16PICode));
		if(u16PICode != 0)
		{
			enTPState= midw_fi_tcl_e8_AtStationTPinfo::FI_EN_SELF_TP;
		}
	}
		else
		{
		tU8 u8MonitorFMTA_AM =  (m_poclConfigInterface->u32GetConfigData("MonitorFMTA")) & TUNMSTR_MONITORFMTA_AM;
		tU8 u8MonitorFMTA_FM = (tU8)(((m_poclConfigInterface->u32GetConfigData("MonitorFMTA")) & TUNMSTR_MONITORFMTA_FM)>>0x01);
		ETG_TRACE_USR4(("TPStatus: AMFM tuner is in FG and MonitorFMTAInAM =%d MonitorFMTAInFM=%d",u8MonitorFMTA_AM,u8MonitorFMTA_FM));
		#ifdef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
		if(((u8MonitorFMTA_FM) && (tuner::common::FM1== m_poArlImpl->getActiveSource()) && (u16PICode != 0)) ||
			((u8MonitorFMTA_AM) && (tuner::common::AM== m_poArlImpl->getActiveSource())&& (u16PICode != 0)))
		{
			if(m_poArlImpl->getActiveSourceActivity()!=tuner::common::SRCOFF)
			{
				enTPState= midw_fi_tcl_e8_AtStationTPinfo::FI_EN_SELF_TP;
		}
	}
		/*Temp fix: not to disable tp status, When FMTA is active source
		RootCasue: after placing FM_TA to FG in Non radio source, the AMFM tuner state is getting updated as FG*/
		else if((tuner::common::FMANNOUNCEMENTS== m_poArlImpl->getActiveSource()) && (u16PICode != 0))
		{
			enTPState= midw_fi_tcl_e8_AtStationTPinfo::FI_EN_SELF_TP;
		}
		else if(((u8MonitorFMTA_FM) && (tuner::common::FM1== m_poArlImpl->getActiveSource()) && (u16PICode == 0)) ||
			((u8MonitorFMTA_AM) && (tuner::common::AM== m_poArlImpl->getActiveSource())&& (u16PICode == 0)))
		{
			enTPState =midw_fi_tcl_e8_AtStationTPinfo::FI_EN_NO_TP;
		}
		else
		{
			blSendUpdate=false;
		}
		#else
		tU8 u8CurrentBand = m_potunmstr_SrcChgManager ->u8GetCurrentSource();
		if(((u8MonitorFMTA_FM) && (u8CurrentBand == (tU8)TUNMSTR_SRCCHG_SOURCE_TUN1FM) && (u16PICode != 0)) ||
				((u8MonitorFMTA_AM) && (u8CurrentBand == (tU8)TUNMSTR_SRCCHG_SOURCE_TUN1AM)&& (u16PICode != 0)))
		{
			enTPState= midw_fi_tcl_e8_AtStationTPinfo::FI_EN_SELF_TP;
		}
		#endif
	}
#ifdef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
	if(blSendUpdate)
	{
		oAnnouncementControl.vOnNewTpState(midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_FM, enTPState);
		tBool blTPState= false;
		if(enTPState==midw_fi_tcl_e8_AtStationTPinfo::FI_EN_SELF_TP)
		{
			blTPState = true;
		}
		ETG_TRACE_USR4(("TPStatus: AnnouncementInfo TPState=%d",blTPState));
		m_potunmstr_MsgToHMI->vSend_g_TP_Status(blTPState,midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_FM1);
	}
#else
	m_potunmstr_SrcChg_AnnoHandler->vCheckForTPStatus(enTPState, (tU8)midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_FM);
#endif
}


/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vHandleTTFiS_CMD( )
 *
 * DESCRIPTION:  Handler to handle TTFIs Commands
 *
 * PARAMETER:    tU8DataLength, const tU8*u8DataSpecial
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vHandleTTFiS_CMD(const tU8* u8DataSpecial)
{
	tU8 u8FunctionID = u8DataSpecial[0];
	//CCA message Function ID
	if ( NULL == poGWMain ||(m_potunmstr_Utility==NULL) )
	{
		ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandleTTFiS_CMD, Null pointer"));
		NORMAL_M_ASSERT (NULL != poGWMain);
		NORMAL_M_ASSERT (NULL != m_potunmstr_Utility);
		return;

	}
	tU16 u16RegID = poGWMain->u16GetRegID();

	ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandleTTFiS_CMD"
			"u8FunctionID=%d u16RegID=%d ",
			u8FunctionID,
			u16RegID));

	switch(u8FunctionID)
	{
	case MIDW_TUNERFI_C_U16_FID_TUN_G_SET_FEATURE:
	{
		midw_tunerfi_tclMsgFID_TUN_G_SET_FEATUREStatus oStatusMsg;
		oStatusMsg.b32_Features.u32Value=u8DataSpecial[1];
		vSendMessage( CCA_C_U16_APP_TUNERMASTER,// Destination APP ID
				oStatusMsg,           // parameter&
				MIDW_TUNERFI_C_U16_FID_TUN_G_SET_FEATURE, //FID
				AMT_C_U8_CCAMSG_OPCODE_STATUS,  // OpCode                           /* amt_tclServiceData* */
				0);
		ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandleTTFiS_CMD, MIDW_TUNERFI_C_U16_FID_TUN_G_SET_FEATURE sent"));


	}break;
	case MIDW_TUNERFI_C_U16_FID_TUN_G_ANNOUNCEMENT_MESSAGE:
	{
		midw_tunerfi_tclMsgFID_TUN_G_ANNOUNCEMENT_MESSAGEStatus oStatusMsg;
		tU8 u8check = u8DataSpecial[1];
		oStatusMsg.e8AnnoMessage.enType = (midw_fi_tcl_e8_Anno_Message::tenType)u8check;
		vSendMessage( CCA_C_U16_APP_TUNERMASTER,// Destination APP ID
				oStatusMsg,           // parameter&
				MIDW_TUNERFI_C_U16_FID_TUN_G_ANNOUNCEMENT_MESSAGE, //FID
				AMT_C_U8_CCAMSG_OPCODE_STATUS,  // OpCode                           /* amt_tclServiceData* */
				0);
		ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandleTTFiS_CMD, MIDW_TUNERFI_C_U16_FID_TUN_G_ANNOUNCEMENT_MESSAGE sent"));

	}
	break;
	default:
	{
		midw_tunerfi_tclMsgFID_TUN_S_AUDIO_FG_BG_NEWMethodStart oMsgData;
		oMsgData.TunAudFGBGNew.u8_TunerHeader.enType = (midw_fi_tcl_e8_Tun_TunerHeader::tenType)0;
		oMsgData.TunAudFGBGNew.u8SubCommand.enType =(midw_fi_tcl_e8_Tun_SubCommand::tenType)0;
		oMsgData.TunAudFGBGNew.u8AudioSink.enType = (midw_fi_tcl_e8_Tun_AudioSink::tenType)0;

		oMsgData.TunAudFGBGNew.bTunerState = (tBool)0;
		oMsgData.TunAudFGBGNew.u8_PhysicalTuner.enType =(midw_fi_tcl_e8_Tun_PhysicalTuner::tenType)0xff;

		oMsgData.TunAudFGBGNew.e8Band.enType = (midw_fi_tcl_e8_Tun_TunerBand::tenType)18;

		//ETG_TRACE_USR4(( " vSend_s_Audio_FG_BG_New()->band= %d",u8TunBand));

		vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
			oMsgData,           // parameter&
			MIDW_TUNERFI_C_U16_FID_TUN_S_AUDIO_FG_BG_NEW, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0);
		break;
	}
	}
}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vHandlePendingSrcChgReq_Tuner( )
 *
 * DESCRIPTION:  Handler to handle Source change request during Service unavail info
 *
 * PARAMETER:
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vHandlePendingSrcChgReq_Tuner()
{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	if ((m_potunmstr_AudioClientHandler == NULL) ||	(m_potunmstr_SrcChgManager == NULL))
	{
		ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandlePendingSrcChgReq_Tuner, Null pointer"));
		NORMAL_M_ASSERT (NULL != m_potunmstr_AudioClientHandler);
		NORMAL_M_ASSERT (NULL != m_potunmstr_SrcChgManager);
		return;
	}
	tU8 u8Source = m_potunmstr_AudioClientHandler->u8GetSrcReq_ServiceUnavail();
	tU8 u8Action = m_potunmstr_AudioClientHandler->u8GetSrcActivity_ServiceUnavail();
	if(u8Source == (tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA)
	{
		vHandlePendingTunTAPendingReq();
	}//	if(u8Source = TUNMSTR_SRCCHG_SOURCE_FM_TA)
	else if((tU8)TUNMSTR_TUNER_SOURCE_1)
	{
		switch(u8Action)
		{
		case TUNMSTR_SRCCHG_ACTION_ON:
		{
			m_potunmstr_SrcChgManager->vHandleTunerSrcChg_ON(u8Source);
			ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandlePendingSrcChgReq_Tuner, FM -ON"));

		}break;
		case TUNMSTR_SRCCHG_ACTION_PAUSE:
		{
			m_potunmstr_SrcChgManager->vHandleTunerSrcChg_PAUSE(u8Source);
			ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandlePendingSrcChgReq_Tuner, FM -PAUSE"));
		}break;
		case TUNMSTR_SRCCHG_ACTION_OFF:
		{
			m_potunmstr_SrcChgManager->vHandleTunerSrcChg_OFF(u8Source);
			ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandlePendingSrcChgReq_Tuner, FM -PAUSE"));
		}break;
		default:
		{
			ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandlePendingSrcChgReq_Tuner, Default case Tuner"));
		}
		break;
		}// end of Switch
		m_potunmstr_AudioClientHandler->vSetSrcReq_ServiceUnavail(TUNMSTR_SRCCHG_INVALID);
		m_potunmstr_AudioClientHandler->vSetSrcActivity_ServiceUnavail(TUNMSTR_SRCCHG_INVALID);
	}//else if(TUNMSTR_TUNER_SOURCE_1)
	else if((tU8)TUNMSTR_DAB_SOURCE)
	{
		ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandlePendingSrcChgReq, DAB source; would be handelled in DAB clinet handler"));
	}
	else
	{
		ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandlePendingSrcChgReq, Default caser"));
		m_potunmstr_AudioClientHandler->vSetSrcReq_ServiceUnavail(TUNMSTR_SRCCHG_INVALID);
		m_potunmstr_AudioClientHandler->vSetSrcActivity_ServiceUnavail(TUNMSTR_SRCCHG_INVALID);
	}
#endif
	return;
}// end of function

/*************************************************************************
*************************************************************************/
tVoid tunmstr_TunerClientHandler::vHandle_s_AudioDevice(amt_tclServiceData* poMessage )const
{
    if(poMessage == NULL )
    {
        NORMAL_M_ASSERT( poMessage != NULL );
        return;
    }
    ETG_TRACE_USR4(("tunmstr_TunerClientHandler::vHandle_s_AudioDevice opcode %u", poMessage->u8GetOpCode()));

    if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
    {
        midw_tunerfi_tclMsgFID_TUN_S_AUDIO_DEVICEMethodResult oMsg;
        vGetDatafromAMT(poMessage,oMsg);

        tU8 u8Status =    (tU8)oMsg.TunerServer_StatusResponse.u8TunerStatus.enType;
        ETG_TRACE_USR4(("tunmstr_TunerClientHandler::vHandle_s_AudioDevice: %s", u8Status==0 ? \
        "result is TUN_MSTR_RES_REQ_SUCCEED" : "result is TUN_MSTR_RES_REQ_FAIL"));
    }
}
/*************************************************************************
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vHandle_s_DRMSrcAct(amt_tclServiceData* poMessage )const
{
    if(poMessage == NULL )
    {
        NORMAL_M_ASSERT( poMessage != NULL );
        return;
    }
    ETG_TRACE_USR4(("tunmstr_TunerClientHandler::vHandle_s_DRMSrcAct opcode %u", poMessage->u8GetOpCode()));
    if(poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
    {
        midw_tunerfi_tclMsgFID_TUN_S_SET_DRM_SRCACTIVITYMethodResult oMsg;
        vGetDatafromAMT(poMessage,oMsg);

        tU8 u8Status = (tU8)oMsg.TunerServer_StatusResponse.u8TunerStatus.enType;
        ETG_TRACE_USR4(("tunmstr_TunerClientHandler::vHandle_s_DRMSrcAct: %s", u8Status==0 ? \
        "result is TUN_MSTR_RES_REQ_SUCCEED" : "result is TUN_MSTR_RES_REQ_FAIL"));
    }
}
/*************************************************************************
 *************************************************************************/

tVoid tunmstr_TunerClientHandler::vHandle_s_DemodSwitch(amt_tclServiceData* poMessage )const
{
    if(poMessage == NULL )
    {
        NORMAL_M_ASSERT( poMessage != NULL );
        return;
    }
    ETG_TRACE_USR4(("tunmstr_TunerClientHandler::vHandle_s_DemodSwitch opcode %u", poMessage->u8GetOpCode()));
    if(poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
    {
        midw_tunerfi_tclMsgFID_TUN_S_SET_DEMODULATION_SWITCHMethodResult oMsg;
        vGetDatafromAMT(poMessage,oMsg);

        tU8 u8Status = (tU8)oMsg.TunerServer_StatusResponse.u8TunerStatus.enType;
        ETG_TRACE_USR4(("tunmstr_TunerClientHandler::vHandle_s_DemodSwitch: %s", u8Status==0 ? \
        "result is TUN_MSTR_RES_REQ_SUCCEED" : "result is TUN_MSTR_RES_REQ_FAIL"));
    }
}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vHandle_S_Autostore( )
 *
 * DESCRIPTION:  Handler for method result of auto store
 *
 * PARAMETER:     amt_tclServiceData* poMessag
 *
 * RETURNVALUE:  tVoid
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vHandle_S_Autostore(amt_tclServiceData* poMessage )const
{
	if((poMessage == NULL )|| (m_ptunmstr_AutoStoreHandler == NULL)||(m_potunmstr_MsgFromHMI==NULL))
	{
		ET_TRACE_ERROR_BIN( TUNMSTR_TRACE_CLASS_TUNCLIENT_HANDLER,\
				ET_EN_T16 _ TUNMSTR_TRACE_TUNCLT_HANDLER_NULL_POINTER _\
				ET_EN_DONE );

		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_ptunmstr_AutoStoreHandler!= NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgFromHMI!= NULL );
		return;
	}
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
	{
		midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodResult oMsg;
		vGetDatafromAMT(poMessage,oMsg);

		tU8 u8Status = (tU8)oMsg.TunerServer_StatusResponse.u8TunerStatus.enType;

		if((tU8)TUNMSTR_SRCCHG_RES_REQ_SUCCEED == u8Status)
		{
			ETG_TRACE_USR4(("tunmstr_TunerClientHandler::vHandle_s_AutoStore, MethodResult success"));
			if(m_ptunmstr_AutoStoreHandler->m_blGetInitalAST_Request() == TRUE)
			{
				m_ptunmstr_AutoStoreHandler->vHandleResult_ForInitialAST();
				// If initail AST is active, check if furher AST request needs to be sent or not
			}
			else
			{
				m_ptunmstr_AutoStoreHandler->vHandleResult_ForNormalAST();
				// If Normal AST is active,
			}
		}//if(TUNMSTR_SRCCHG_RES_REQ_SUCCEED == u8Status)
		else
		{
			ETG_TRACE_USR4(("tunmstr_TunerClientHandler::vHandle_s_AutoStore, MethodResult FAIL!!!"));
			m_potunmstr_MsgFromHMI->vSendAST_MethodResult(TUNMSTR_SRCCHG_INVALID, TUNMSTR_SRCCHG_INVALID,AMT_C_U8_CCAMSG_OPCODE_ERROR);
				
		}
	}break;
	case AMT_C_U8_CCAMSG_OPCODE_ERROR:
	{
		if(m_ptunmstr_AutoStoreHandler->m_blGetInitalAST_Request() == TRUE)
		{
			m_potunmstr_MsgFromHMI->vSendAST_MethodResult(TUNMSTR_SRCCHG_INVALID, TUNMSTR_SRCCHG_INVALID,AMT_C_U8_CCAMSG_OPCODE_ERROR);
		}
		break;
	}
	default:
		break;

	};// switch
}
/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vHandle_TunPresetList(
 *
 *DESCRIPTION: Funtion to handle property FID_TUN_G_GET_STATIC_LIST
 *
 *PARAMETER:	
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_TunerClientHandler::vHandle_TunPresetList(amt_tclServiceData* poMessage )const
{
	if((poMessage==NULL)||(m_ptunmstr_Preset_Handler==NULL))
	{
		return;
	}
	ETG_TRACE_USR4((" vHandle_TunPresetList()"));
	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_STATUS:
		{
			m_ptunmstr_Preset_Handler->vUpdateTunerPresetList(poMessage);
			break;
		}
		default:
		{
			break;
		}
	}
}
/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vHandle_MuteRequest(
 *
 *DESCRIPTION: Funtion to handle property FID_TUN_G_MUTE_REQUEST
 *
 *PARAMETER:
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_TunerClientHandler::vHandle_MuteRequest(amt_tclServiceData* poMessage )
{
	if((poMessage==NULL) ||(m_potunmstr_MuteHandler == NULL)
			|| (m_potunmstr_SrcChgManager == NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MuteHandler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
		return;
	}
	ETG_TRACE_USR4((" vHandle_MuteRequest()"));

	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_STATUS:
		{
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		   midw_tunerfi_tclMsgFID_TUN_G_MUTE_REQUESTStatus oStatusMsg;
		   if(m_potunmstr_MsgFromHMI == NULL)
		   {
			   NORMAL_M_ASSERT( m_potunmstr_MsgFromHMI != NULL );
			   return;
		   }
		    m_potunmstr_MsgFromHMI->vGetDatafromAMT(poMessage,oStatusMsg);

		   clSessionControl::getInstance()->vRequestMute(oStatusMsg.bMute, oStatusMsg.bMute_Interrupt);
#else
			if(m_potunmstr_SrcChgManager->u8GetTunerState() != (tU8)TUNMSTR_SRCCHG_BACKGROUND
					&& m_potunmstr_SrcChgManager->u8GetTunerState() != (tU8)TUNMSTR_SRCCHG_INVALID)
			{
				m_potunmstr_MuteHandler->vHandle_TunerMuteRequest(poMessage);
			}
			
#endif
			break;
		}
		default:
		{
			ETG_TRACE_USR4((" vHandle_MuteRequest(), invalid"));
			break;
		}
	}
}


/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vSend_s_MuteState(
 *
 *DESCRIPTION: Funtion to send method  FID_TUN_S_AUDIO_MUTEREQUEST to tuner MIDW
 *
 *PARAMETER:
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_TunerClientHandler::vSend_s_MuteState()
{
	ETG_TRACE_USR4((" vSend_s_MuteState()"));
	midw_tunerfi_tclMsgFID_TUN_S_AUDIO_MUTEREQUESTMethodStart oMsgData;
	vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
			oMsgData,           // parameter&
			MIDW_TUNERFI_C_U16_FID_TUN_S_AUDIO_MUTEREQUEST, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode        /* amt_tclServiceData* */
			0);
}


/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vHandle_s_HandlePresetMethodResult
 *
 *DESCRIPTION: Funtion to handle method result of  TUN_S_PRESET_HANDLING
 *
 *PARAMETER:	amt_tclServiceData* poMessage
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_TunerClientHandler::vHandle_s_HandlePresetMethodResult(amt_tclServiceData* poMessage )
{

	if((poMessage == NULL ) || (NULL == m_ptunmstr_Preset_Handler) )
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_ptunmstr_Preset_Handler != NULL );
		return;
	}
	ETG_TRACE_USR4((" vHandle_s_HandlePresetMethodResult()"));
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		if(NULL != m_potunmstr_AudioClientHandler)
			m_potunmstr_AudioClientHandler->vSendDemuteRequest();
		break;
#endif
		midw_tunerfi_tclMsgFID_TUN_S_PRESET_HANDLINGMethodResult oMsg;
		vGetDatafromAMT(poMessage,oMsg);

		if( midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED != oMsg.TunerServer_StatusResponse.u8TunerStatus.enType )
		{
			if(oMsg.e8Action.enType == midw_fi_tcl_e8_Tun_PresetAction::FI_EN_DELETE_ONE_ELEMENT)
			{
#ifdef INCLUDE_PROFILE_MANAGER
				m_ptunmstr_Preset_Handler->vClearPresetDeleteElementID();
#endif
			}
		}
		break;
	}
	case AMT_C_U8_CCAMSG_OPCODE_ERROR:
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		if(NULL != m_potunmstr_AudioClientHandler)
			m_potunmstr_AudioClientHandler->vSendDemuteRequest();
#endif
		break;
	}
	default:
	{
		break;
	}
	}

}/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vSend_s_AutoStore( )
 *
 * DESCRIPTION:  This function is used to send Method start for Auto Store
 * PARAMETER:    u8ListID,  blStatus
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vSend_s_AutoStore(tU8 u8ListID, tBool blStatus)
{
	midw_tunerfi_tclMsgFID_TUN_S_AUTOSTOREMethodStart oMsgData;

	oMsgData.e8ListID.enType = (midw_fi_tcl_e8_Tun_ListID::tenType)u8ListID;
	oMsgData.bStatus = blStatus;

	vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
			oMsgData,           // parameter&
			MIDW_TUNERFI_C_U16_FID_TUN_S_AUTOSTORE, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0);
	ETG_TRACE_USR4((" vSend_s_AutoStore(), method start sent"));
}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vRequestPresetList( )
 *
 * DESCRIPTION:  This function is used to send Method start for FID_TUN_S_GET_STATIC_LIST
 * PARAMETER:    Void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vRequestPresetList()
{
	//Send method start only if tuner service is availabel, else send the request once the service becomes availabel.
	if(m_u8ServiceAvailable_Tuner==TRUE)
	{
		midw_tunerfi_tclMsgFID_TUN_G_GET_STATIC_LISTGet oMsgData;

		vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
						oMsgData,           // parameter&
						MIDW_TUNERFI_C_U16_FID_TUN_G_GET_STATIC_LIST, //FID
						AMT_C_U8_CCAMSG_OPCODE_GET,  // OpCode                           /* amt_tclServiceData* */
						0);
		//m_ptunmstr_Preset_Handler->Inc_m_u8StartUp_HMI_Update(); //For Testing PSA Mixed PresetList
	/*	oMsgData.e8ListID.enType=midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_AM_MW1;
		vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
				oMsgData,           // parameter&
				MIDW_TUNERFI_C_U16_FID_TUN_S_GET_STATIC_LIST, //FID
				AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                            amt_tclServiceData
		//		0);
		m_blSendGetStaticListReq=FALSE;
		//m_ptunmstr_Preset_Handler->Send_HMIUpdate_Flag(); //For Testing PSA Mixed PresetList

		DRM Preset request*/
		#ifdef VARIANT_S_FTR_ENABLE_DRM
		oMsgData.e8ListID.enType=midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_DRM1;
		vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
				oMsgData,           // parameter&
				MIDW_TUNERFI_C_U16_FID_TUN_S_GET_STATIC_LIST, //FID
				AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
				0);
		#endif
		ETG_TRACE_USR4((" vRequestPresetList(), method start sent"));
	}
	else
	{
		m_blSendGetStaticListReq=TRUE;
	}
}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vRequestPresetList_Suzuki( )
 *
 * DESCRIPTION:  This function is used to send Method start for FID_TUN_S_GET_STATIC_LIST
 * PARAMETER:    Void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vRequestPresetList_Suzuki()
{
   if(m_poclConfigInterface == NULL )
      {

         NORMAL_M_ASSERT( m_poclConfigInterface != NULL );
         return;
      }
	//Send method start only if tuner service is availabel, else send the request once the service becomes availabel.
	if(m_u8ServiceAvailable_Tuner==TRUE)
	{
		midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart oMsgData;
		//Once the tunermaster  KDS parameters are defined, method start for all the supporting List will be send
		//Till the KDS is defined the request is sent only for FM1 and MW bank
		oMsgData.e8ListID.enType=midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_FM1;
		vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
				oMsgData,           // parameter&
				MIDW_TUNERFI_C_U16_FID_TUN_S_GET_STATIC_LIST, //FID
				AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
				0);
		// List request for FM1
		
		if(m_poclConfigInterface->u32GetConfigData("UserAutostoreNoOfStations") == 0)
		{
		oMsgData.e8ListID.enType=midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_FM2;
		vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
				oMsgData,           // parameter&
				MIDW_TUNERFI_C_U16_FID_TUN_S_GET_STATIC_LIST, //FID
				AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
				0);
		// List request for FM2
		}

		oMsgData.e8ListID.enType=midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_FM_AST;
		vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
				oMsgData,           // parameter&
				MIDW_TUNERFI_C_U16_FID_TUN_S_GET_STATIC_LIST, //FID
				AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
				0);
		// List request for FM_AST
		oMsgData.e8ListID.enType=midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_AM_MW1;
		vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
				oMsgData,           // parameter&
				MIDW_TUNERFI_C_U16_FID_TUN_S_GET_STATIC_LIST, //FID
				AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
				0);

		oMsgData.e8ListID.enType=midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_AM_AST;
		vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
				oMsgData,           // parameter&
				MIDW_TUNERFI_C_U16_FID_TUN_S_GET_STATIC_LIST, //FID
				AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
				0);
		// List request for AM_AST

		/*Request for DRM1 Preset List*/
	if(m_poclConfigInterface->u32GetConfigData("DRMSupported"))
	{
		oMsgData.e8ListID.enType=midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_DRM1;
		vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
				oMsgData,           // parameter&
				MIDW_TUNERFI_C_U16_FID_TUN_S_GET_STATIC_LIST, //FID
				AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
				0);

		/*Request for DRM_AST Preset List*/
		oMsgData.e8ListID.enType=midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_DRM_AST;
		vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
				oMsgData,           // parameter&
				MIDW_TUNERFI_C_U16_FID_TUN_S_GET_STATIC_LIST, //FID
				AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
				0);
	}
		m_blSendGetStaticListReq=FALSE;
		ETG_TRACE_USR4((" vRequestPresetList_Suzuki(), method start sent"));
	}
	else
	{
		m_blSendGetStaticListReq=TRUE;
	}
}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vRequestMixedPresetList( )
 *
 * DESCRIPTION:  This function is used to send Method start for FID_TUN_S_GET_STATIC_LIST
 * PARAMETER:    Void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vRequestMixedPresetList()
{
	//Send method start only if tuner service is available, else send the request once the service becomes available.
	if(m_u8ServiceAvailable_Tuner==TRUE)
	{
		midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart oMsgData;
		//Once the tunermaster  KDS parameters are defined, method start for all the supporting List will be send
		//Till the KDS is defined the request is sent only for FM1 and MW bank
		if ((m_ptunmstr_Preset_Handler == NULL) || (m_poclConfigInterface == NULL))
		{
			return;
		}
		
		if(m_poclConfigInterface->u32GetConfigData("SXMSupported"))
			m_ptunmstr_Preset_Handler->Inc_m_u8TunerStartUp_HMI_Update();
		else
			m_ptunmstr_Preset_Handler->Inc_m_u8StartUp_HMI_Update();
		
		oMsgData.e8ListID.enType=midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_MIX1;
		vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
				oMsgData,           // parameter&
				MIDW_TUNERFI_C_U16_FID_TUN_S_GET_STATIC_LIST, //FID
				AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                          
				0);
    /*
		m_ptunmstr_Preset_Handler->Inc_m_u8StartUp_HMI_Update();
		oMsgData.e8ListID.enType=midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_AM_MW1;
		vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
				oMsgData,           // parameter&
				MIDW_TUNERFI_C_U16_FID_TUN_S_GET_STATIC_LIST, //FID
				AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           
				//0);*/
		/* m_ptunmstr_Preset_Handler->Inc_m_u8StartUp_HMI_Update();
		oMsgData.e8ListID.enType=midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_AM_LW1;
		vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
				oMsgData,           // parameter&
				MIDW_TUNERFI_C_U16_FID_TUN_S_GET_STATIC_LIST, //FID
				AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           
				//0);*/
		/* m_blSendGetStaticListReq=FALSE;*/
		//m_ptunmstr_Preset_Handler->Send_HMIUpdate_Flag();
		ETG_TRACE_USR4((" vRequestMixedPresetList(), method start sent"));

	}
	else
	{
		m_blSendGetStaticListReq=TRUE;
	}
}
/*************************************************************************
 * FUNCTION:     vSetTunerRegID()
 *
 * DESCRIPTION: Update the member variable m_u16RegID with regID on successful registration TUNER service
 *
 * PARAMETER:    tU16 u16RegId
 *
 * RETURNVALUE:  void
 **************************************************************************/
tVoid tunmstr_TunerClientHandler::vSetTunerRegID(tU16 u16RegID)
{
	m_u16TunerRegID=u16RegID;
}
/*************************************************************************
 * FUNCTION:     vHandleSDSDirectFreqReq()
 *
 * DESCRIPTION:		Function to handle SDS direct frequecy request
 *
 * PARAMETER:    None
 *
 * RETURNVALUE:  void
 **************************************************************************/
tVoid tunmstr_TunerClientHandler::vHandleSDSDirectFreqReq()
{
	if((NULL==m_potunmstr_SrcChgManager)
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			||(NULL==m_potunmstr_AudioClientHandler)
#endif
			)
	{
		return;
	}
	tU8 u8Band = m_potunmstr_SrcChgManager->u8GetSDSBand();
    tU8 u8CurrentBand =  m_potunmstr_SrcChgManager->u8GetCurrentSource();
	if(u8CurrentBand != u8Band)
	{
		//if different forward that request to fc_amfmtuner
		vSend_s_ChangeBand(u8Band);
		//Clear SDS Band change and Frequency request flag
		m_potunmstr_SrcChgManager->vSetBandChg_Flag(TRUE);
		m_potunmstr_SrcChgManager->vSetSourceInfo(u8Band);
		//Set Tuner status to InProgress so that we send response back to ARL
		m_potunmstr_SrcChgManager->vSetTunerState((tU8)TUNMSTR_SRCCHG_INPROGESS);
		ETG_TRACE_USR4(("vHandleSDSDirectFreqReq, Band Change request sent ->"
				"ActiveBand=%d RequestedBand =%d",
				u8CurrentBand, u8Band ));
	}
	else
	{
		tU8 u8AudioState = m_potunmstr_SrcChgManager->u8GetTunAudibleStatus();
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(m_potunmstr_AudioClientHandler->u8MapTunmstrSources(u8CurrentBand) , u8AudioState);
#endif
		ETG_TRACE_USR4(("vHandleSDSDirectFreqReq, requested band and active band are same -> hence send result to ARL"
				"ActiveBand=%d RequestedBand =%d AudioState =%d",
				u8CurrentBand, u8Band , u8AudioState));
	}
	m_potunmstr_SrcChgManager->vSetBandChgSDS_status(FALSE);
}
/*************************************************************************
 * FUNCTION:     vHandlePendingTunTAPendingReq()
 *
 * DESCRIPTION:	Function to handle Pending FM TA request
 *
 * PARAMETER:    None
 *
 * RETURNVALUE:  void
 **************************************************************************/
tVoid tunmstr_TunerClientHandler::vHandlePendingTunTAPendingReq()
{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	if((NULL==m_potunmstr_AudioClientHandler)||(NULL==m_potunmstr_SrcChgManager))
	{
		return;
	}
	tU8 u8Action = m_potunmstr_AudioClientHandler->u8GetSrcActivity_ServiceUnavail();
	switch(u8Action)
	{
	case TUNMSTR_SRCCHG_ACTION_ON:
	{
		m_potunmstr_SrcChgManager->vHandleAnnoSrc_ON((tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA);
		ETG_TRACE_USR4(("vHandlePendingTunTAPendingReq, TA -ON"));
	}break;
	case TUNMSTR_SRCCHG_ACTION_PAUSE:
	{
		m_potunmstr_SrcChgManager->vHandleAnnoSrc_PAUSE((tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA);
		ETG_TRACE_USR4((" vHandlePendingTunTAPendingReq, TA -PAUSE"));
	}break;
	case TUNMSTR_SRCCHG_ACTION_OFF:
	{
		m_potunmstr_SrcChgManager->vHandleAnnoSrc_OFF((tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA);
		ETG_TRACE_USR4(("vHandlePendingTunTAPendingReq, TA -OFF"));
	}break;
	default:
	{
		ETG_TRACE_USR4(("vHandlePendingTunTAPendingReq, Default case TA"));
	}
	break;
	}// end of Switch
	m_potunmstr_AudioClientHandler->vSetSrcReq_ServiceUnavail(TUNMSTR_SRCCHG_INVALID);
	m_potunmstr_AudioClientHandler->vSetSrcActivity_ServiceUnavail(TUNMSTR_SRCCHG_INVALID);
#endif
}


/*************************************************************************
 * FUNCTION:     blConvertTUNAnnoType_TunMstrAnnoType()
 *
 * DESCRIPTION:	This is conevrt function to conevrt FM Anno types defines to Tunermaster anno defines
 *
 * PARAMETER:    u8Anno_Type , u8FMAnnoType
 *
 * RETURNVALUE:  tU8
 **************************************************************************/
tU8 tunmstr_TunerClientHandler:: blConvertTUNAnnoType_TunMstrAnnoType(tU8 u8Anno_Type , tU8 &u8FMAnnoType)
{
	if((m_poclConfigInterface == NULL )||(m_potunmstr_SrcChg_AnnoHandler==NULL) ||(m_potunmstr_SrcChgManager == NULL))
	{

		NORMAL_M_ASSERT( m_poclConfigInterface != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChg_AnnoHandler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
		return 0xFF;
	}

	tU8 u8Anno_State = TUNMSTR_ANNOREQUEST_IGNORE;
	tU8 u8FMAnnoPrioType = (m_poclConfigInterface->u32GetConfigData("AnnouncementPrioFMTA") > m_poclConfigInterface->u32GetConfigData("AnnouncementPrioFMPTY31"))
								? TunMstr_AnnoActive_FMPTY : TunMstr_AnnoActive_FMTA;


	ETG_TRACE_USR4((" tunmstr_TunerClientHandler::blConvertTUNAnnoType_TunMstrAnnoType :%d", u8FMAnnoPrioType));
	ETG_TRACE_USR4((" tunmstr_TunerClientHandler::blConvertTUNAnnoType_TunMstrAnnoType FM prio:%d , PTY prio :%d", m_poclConfigInterface->u32GetConfigData("AnnouncementPrioFMTA"),
			m_poclConfigInterface->u32GetConfigData("AnnouncementPrioFMPTY31")));
	switch(u8Anno_Type)
	{
	case TUNMSTR_ANNOMSG_TAPTY_OFF:
	{
		u8FMAnnoType = m_u8AnnoType;
		u8Anno_State = TUNMSTR_ANNOREQUEST_OFF;
	}break;
	case TUNMSTR_ANNOMSG_TAON_PTYOFF:
	{
		u8FMAnnoType  = (tU8)TunMstr_AnnoActive_FMTA;
		u8Anno_State = TUNMSTR_ANNOREQUEST_ON;

		if(m_potunmstr_SrcChg_AnnoHandler->m_ActiveAnnoSrc == TunMstr_AnnoActive_FMPTY)
		{
			if(m_potunmstr_SrcChgManager->u8GetTunerState() != (tU8)TUNMSTR_SRCCHG_INPROGESS)
			{
				m_u8AnnoType = u8FMAnnoType;
				m_potunmstr_SrcChg_AnnoHandler->vHandle_AnnoMSG(m_u8AnnoType,TUNMSTR_SRCCHG_SOURCE_TUN1FM,u8Anno_State);
				u8Anno_State = TUNMSTR_ANNOREQUEST_IGNORE;
				ETG_TRACE_USR4((" tunmstr_TunerClientHandler::blConvertTUNAnnoType_TunMstrAnnoType ,Anno Req passed to anno handler AnnoType =%d, AnnoState=%d",
						u8FMAnnoType,u8Anno_State));
				return u8Anno_State;
			}
		}

	}break;
	case TUNMSTR_ANNOMSG_TAOFF_PTYON:
	{
		u8FMAnnoType = (tU8)TunMstr_AnnoActive_FMPTY;
		u8Anno_State = TUNMSTR_ANNOREQUEST_ON;

		if(m_potunmstr_SrcChg_AnnoHandler->m_ActiveAnnoSrc == TunMstr_AnnoActive_FMTA)
		{
			if(m_potunmstr_SrcChgManager->u8GetTunerState() != (tU8)TUNMSTR_SRCCHG_INPROGESS)
			{
				m_u8AnnoType = u8FMAnnoType;
				m_potunmstr_SrcChg_AnnoHandler->vHandle_AnnoMSG(m_u8AnnoType,TUNMSTR_SRCCHG_SOURCE_TUN1FM,u8Anno_State);
				u8Anno_State = TUNMSTR_ANNOREQUEST_IGNORE;
				ETG_TRACE_USR4((" tunmstr_TunerClientHandler::blConvertTUNAnnoType_TunMstrAnnoType ,Anno Req passed to anno handler AnnoType =%d, AnnoState=%d",
						u8FMAnnoType,u8Anno_State));
				return u8Anno_State;
			}
		}

	}break;
	case TUNMSTR_ANNOMSG_TAON_PTYON:
	{
		u8FMAnnoType = u8FMAnnoPrioType;
		u8Anno_State = TUNMSTR_ANNOREQUEST_ON;
	}break;
	default:
		break;
	}
	return u8Anno_State;
}// end of function


/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::vSend_s_ChangeLSM( )
 *
 * DESCRIPTION:  Method start for FID_TUN_S_DIRECT_FREQUENCY
 * PARAMETER:    Void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_TunerClientHandler::vSend_s_ChangeLSM()
{

	if(m_potunmstr_SDSHandler == NULL )
	{
		NORMAL_M_ASSERT( m_potunmstr_SDSHandler != NULL );
		return;
	}

	midw_tunerfi_tclMsgFID_TUN_S_CHANGE_LSMMethodStart oMsgData;

	oMsgData.Option.enType = (midw_fi_tcl_e8_StationSelectionOption::tenType)m_potunmstr_SDSHandler->m_rSDSTunerRequest.u8Option;
	oMsgData.Band.enType = (midw_fi_tcl_e8_Tun_TunerBand::tenType)m_potunmstr_SDSHandler->m_rSDSTunerRequest.u8Band;
	oMsgData.Frequency = m_potunmstr_SDSHandler->m_rSDSTunerRequest.u32Frequency;
	oMsgData.u8Element_ID = m_potunmstr_SDSHandler->m_rSDSTunerRequest.u8ElemID;
	oMsgData.e8ListID.enType = (midw_fi_tcl_e8_Tun_ListID::tenType)m_potunmstr_SDSHandler->m_rSDSTunerRequest.u8ListID;
	oMsgData.PI = m_potunmstr_SDSHandler->m_rSDSTunerRequest.u32PI;
	oMsgData.HDProgramNumber = m_potunmstr_SDSHandler->m_rSDSTunerRequest.u8HDProgramNumber;


	vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
			oMsgData,           // parameter&
			MIDW_TUNERFI_C_U16_FID_TUN_S_CHANGE_LSM, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0);


}


/*************************************************************************
 * FUNCTION:     bGetPTYState()
 *
 * DESCRIPTION:	Returns PTY state
 *
 * PARAMETER:
 *
 * RETURNVALUE:  tBool
 **************************************************************************/

tBool tunmstr_TunerClientHandler::bGetPTYState() const
{
	ETG_TRACE_USR4((" tunmstr_TunerClientHandler::bGetPTYState,m_bPTYState :%d",m_bPTYState));
	return m_bPTYState;
}


/*************************************************************************
 * FUNCTION:     u8GetActiveStationinfoBand()
 *
 * DESCRIPTION:	 Returns band
 *
 * PARAMETER:
 *
 * RETURNVALUE:  tU8
 **************************************************************************/

tU8 tunmstr_TunerClientHandler::u8GetActiveStationinfoBand() const
{
	ETG_TRACE_USR4((" tunmstr_TunerClientHandler::u8GetActiveAMBand,ActiveAMBand :%d",m_u8StationinfoBand));
	return m_u8StationinfoBand;
}

/**********************************

***********************************/
tVoid tunmstr_TunerClientHandler::vHandle_s_UnUsedMessages()
{
	// Do nothing
}
tVoid tunmstr_TunerClientHandler::vDisableTunerSource(tU8 u8Source , tBool bFromPMClient)
{
	if(NULL==m_potunmstr_MsgFromHMI)
	{
		return;
	}
	m_bFromPMClient = bFromPMClient;
	midw_tunerfi_tclMsgFID_TUN_S_DISABLE_BANDMethodStart oMsgData;
	if(enGetTunerDisableBand(u8Source).enType==midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_INVALID)
	{
		m_potunmstr_MsgFromHMI->vSend_s_Source_Setup_Option_MethodResult(midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_FAIL);
		return;
	}
	else
	{
		oMsgData.u8Band.enType= enGetTunerDisableBand(u8Source).enType;
		vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
			oMsgData,           // parameter&
			MIDW_TUNERFI_C_U16_FID_TUN_S_DISABLE_BAND, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0);
	}
}


midw_fi_tcl_e8_Tun_TunerBand tunmstr_TunerClientHandler::enGetTunerDisableBand(tU8 u8Source)
{
	ETG_TRACE_USR4((" enGetTunerDisableBand"));
	midw_fi_tcl_e8_Tun_TunerBand enBand;
	enBand.enType = midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_INVALID;
	if(m_poclConfigInterface==NULL)
	{
		ETG_TRACE_USR4((" enGetTunerDisableBand null pointer"));
		return enBand;
	}
	if(u8Source==midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_AM)
	{
		ETG_TRACE_USR4(("CombiBands=%u AvailableBands=%d ",m_poclConfigInterface->u32GetConfigData("CombiBands"),m_poclConfigInterface->u32GetConfigData("AvailableBands")));
		if((m_poclConfigInterface->u32GetConfigData("CombiBands") & 0x0006) == 0x0006)
		{
			enBand.enType=midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_CB1;
		}
		else if (m_poclConfigInterface->u32GetConfigData("AvailableBands") & 0x0004)
		{
			enBand.enType=midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_MW;
		}
		else if (m_poclConfigInterface->u32GetConfigData("AvailableBands") & 0x0002)
		{
			enBand.enType=midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_LW;
		}

	}
	ETG_TRACE_USR4((" enGetTunerDisableBand enBand=%d",enBand.enType));
	return enBand;
}


tVoid tunmstr_TunerClientHandler::vHandle_s_DisableBand(amt_tclServiceData* poMessage)
{
	if((NULL==poMessage) || (NULL==m_potunmstr_MsgFromHMI)|| (NULL==m_ptunmstr_Preset_Handler))
	{
		return;
	}
	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
		{
			m_ptunmstr_Preset_Handler->vSendEmptyPresetlistUpdate(); /* Bug fix for 293407 : clear the list irrespective of  AM OFF request coming from PM or HMI*/
			if(!m_bFromPMClient)
			{
				m_potunmstr_MsgFromHMI->vSend_s_Source_Setup_Option_MethodResult(midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED);			
			}
#ifdef INCLUDE_PROFILE_MANAGER
			else
			{
				midw_fi_tcl_TunMstr_RadioSetting_StatusResponse TunerMasterResponse;
				TunerMasterResponse.RadioProfileSetting_Response.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_SUCCEED;
				TunerMasterResponse.RadioProfileSetting_ErrorCode.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_NONE;
				m_ptunmaster_PMClient->vSendResponseToRadioSetting(TunerMasterResponse);
				m_potunmstr_MsgToHMI->vSend_g_Tuner_Source_Availability_status();
			}
#endif			
			#ifndef VARIANT_S_FTR_ENABLE_TUNERMASTER_MOCK
			dp_tclTmcTunerUsrDPAMAvailability oTmcTunerDPAMAvailability ;
			tBool bTmcTunerDPAMAvailStatus = true;
			oTmcTunerDPAMAvailability.s32GetData(bTmcTunerDPAMAvailStatus);
			ETG_TRACE_USR4(( "AMAvailability=%d",bTmcTunerDPAMAvailStatus));
			#endif
			break;
		}
		default:
			break;
	}
}
/*************************************************************************
 * FUNCTION:     vHandleProfileUpdate()
 *
 * DESCRIPTION:
 *
 * PARAMETER:
 * Param 1 UserID that need to be sent to ADR
 * Param 2 Action (Load profile, copy  and delete)
 * Param 3 for destination needs to be added
 *
 * RETURNVALUE:  Void
 **************************************************************************/
#ifdef INCLUDE_PROFILE_MANAGER
tVoid tunmstr_TunerClientHandler::vHandleProfileUpdate(tU8 u8UserID , tU8 u8Action ){
#else
tVoid tunmstr_TunerClientHandler::vHandleProfileUpdate(tU8 /*u8UserID*/ , tU8 /*u8Action*/ ){
#endif
		midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart oMsgData;
#ifdef INCLUDE_PROFILE_MANAGER
		oMsgData.UserID = u8UserID;
		ETG_TRACE_USR4(("tunmstr_TunerClientHandler::vHandleProfileUpdate CHANGE()m_u8UserID =%d  m_u8Action =%d en_ActionChangeProfile = %d ",u8UserID,u8Action ,en_ActionChangeProfile));
		switch(u8Action)
		{
			case (tU8)en_ActionChangeProfile:
			{
				oMsgData.Action.enType = midw_fi_tcl_Tun_UserProfileAction::FI_EN_TUN_PROFILE_CHANGE;
				ETG_TRACE_USR4(("tunmstr_TunerClientHandler::vHandleProfileUpdate, CHANGE Message"));

				break;
			}
			case (tU8)en_ActionCopy:
			{
				oMsgData.Action.enType = midw_fi_tcl_Tun_UserProfileAction::FI_EN_TUN_PROFILE_COPY;
				oMsgData.UserID = 0xFF;
				oMsgData.DestinationUserID =u8UserID ;
				ETG_TRACE_USR4(("tunmstr_TunerClientHandler::vHandleProfileUpdate, COPY  Message"));
				break;
			}
			case (tU8)en_ActionDelete:
			{
				oMsgData.Action.enType = midw_fi_tcl_Tun_UserProfileAction::FI_EN_TUN_PROFILE_DELETE;
				ETG_TRACE_USR4(("tunmstr_TunerClientHandler::vHandleProfileUpdate, DELETE Message"));
				break;
			}
			default:
			{
				break;
			}
		 }
#endif
		vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
			oMsgData,           // parameter&
			MIDW_TUNERFI_C_U16_FID_TUN_S_USER_PROFILE_UPDATE, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0);
}

#ifdef INCLUDE_PROFILE_MANAGER
tVoid tunmstr_TunerClientHandler::vSendAMFMListonlinePersonalization(midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart& AMFMList )
{


	ETG_TRACE_USR4(("vSendAMFMListonlinePersonalization "));
		vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
			AMFMList,           // parameter&
			MIDW_TUNERFI_C_U16_FID_TUN_S_PRESETLIST_CONTENT_UPDATE, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0);

}
/*************************************************************************
 * FUNCTION:     vHandle_g_ProfileUpdateResult()
 *
 * DESCRIPTION:	 To handle result received from DAB
 *
 * PARAMETER:
 * Param 1 Message
 *
 * RETURNVALUE:  Void
 **************************************************************************/

tVoid tunmstr_TunerClientHandler::vHandle_s_UserProfileUpdateResult(amt_tclServiceData* poMessage)
{
	if((NULL==poMessage) || (NULL == m_ptunmaster_PMClient ))
	{
		return;
		ETG_TRACE_USR4(("vHandle_s_UserProfileUpdateResult, NULL Message"));
	}
	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
		{
			midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodResult oMsg;
			vGetDatafromAMT(poMessage,oMsg);
			tU8 u8Status = TUNMSTR_PROFILE_USER_ACTION_FAIL;
			if(midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED == oMsg.TunerServer_StatusResponse.u8TunerStatus.enType)
				u8Status = TUNMSTR_PROFILE_USER_ACTION_SUCESS;

			switch(oMsg.Action.enType)
			{

				case  midw_fi_tcl_Tun_UserProfileAction::FI_EN_TUN_PROFILE_CHANGE:
				{
					m_ptunmaster_PMClient->vHandleOnDataChanged((tU8)u8Status );
					break;
					ETG_TRACE_USR4(("tunermaster_PMClient::vHandle_s_UserProfileUpdateResult CHANGE()u8Status =%d   ",u8Status));
					//(tU8)en_ActionChangeProfile
				}
				case  midw_fi_tcl_Tun_UserProfileAction::FI_EN_TUN_PROFILE_COPY:
				{
					m_ptunmaster_PMClient->vHandleOnProfileCopied((tU8)u8Status);
					ETG_TRACE_USR4(("tunermaster_PMClient::vHandle_s_UserProfileUpdateResult COPY () u8Status =%d   ",u8Status));
					break;
			}

				case  midw_fi_tcl_Tun_UserProfileAction::FI_EN_TUN_PROFILE_DELETE:
			{
					m_ptunmaster_PMClient->vHandleOnProfileDeleted((tU8)u8Status);
					ETG_TRACE_USR4(("tunermaster_PMClient::vHandle_s_UserProfileUpdateResult Delete ()u8Status =%d   ",u8Status));
					break;
				}
				default:
				{
					break;
				}
			}
			break;
		}
		default:
			break;
	}

}

tVoid tunmstr_TunerClientHandler::vHandle_S_ProfilePresetListContentUpdateResult(amt_tclServiceData* poMessage)
{


	if((NULL==poMessage) || (NULL == m_ptunmaster_PMClient ) || (NULL == m_ptunmstr_Preset_Handler))
		{
			ETG_TRACE_USR4(("vHandle_S_ProfilePresetListContentUpdateResult, NULL Message"));
			return;
		}
		switch (poMessage->u8GetOpCode())
		{
			case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
			{

				midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodResult oMsg;
				vGetDatafromAMT(poMessage,oMsg);

				midw_fi_tcl_TunMstr_RadioSetting_StatusResponse TunerMasterResponse;
				TunerMasterResponse.RadioProfileSetting_Response.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_SUCCEED;
				TunerMasterResponse.RadioProfileSetting_ErrorCode.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_NONE;

				if(midw_fi_tcl_e8_Tun_ResponseStatus::FI_EN_TUN_RES_REQ_SUCCEED != oMsg.TunerServer_StatusResponse.u8TunerStatus.enType)
				{
					TunerMasterResponse.RadioProfileSetting_Response.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_FAILED_FOR_AMFM;
					TunerMasterResponse.RadioProfileSetting_ErrorCode.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_UNKNOWN;

					 if((m_poclConfigInterface->u32GetConfigData("PresetListType")) && (m_ptunmaster_PMClient->bGetKeepOtherPreset()))
					 {
						midw_tunerfi_tclMsgFID_TUN_S_GET_STATIC_LISTMethodStart oMsgData;
						 oMsgData.e8ListID.enType=midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_MIX1;
						 vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
									oMsgData,           // parameter&
									MIDW_TUNERFI_C_U16_FID_TUN_S_GET_STATIC_LIST, //FID
									AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode
									0);
					 }
				}

				ETG_TRACE_USR4(("vHandle_S_ProfilePresetListContentUpdateResult Response.RadioProfileSetting_Response = %d",TunerMasterResponse.RadioProfileSetting_Response.enType));
				m_ptunmaster_PMClient->vSendResponseToRadioSetting(TunerMasterResponse);

				break;
			}
			default:
				break;
		}

}
#endif
tU32 tunmstr_TunerClientHandler::u32GetCurrentAtStationFreq()
{
	ETG_TRACE_USR4(("u32GetCurrentAtStationFreq Current Freq = %d   ",m_u8StationinfoFreq));
	return m_u8StationinfoFreq;
}


/*************************************************************************
 * FUNCTION:     vSendPSFreezeReq()
 *
 * DESCRIPTION:	 Send PS Freeze request to AM/FM
 *
 * PARAMETER:	 tU8 u8Mode
 *
 * RETURNVALUE:  tVoid
 **************************************************************************/
tVoid tunmstr_TunerClientHandler::vSendPSFreezeReq(tU8 u8Mode)
{
	ETG_TRACE_USR4(("vSendPSFreezeReq mode : %d", u8Mode));
	midw_tunerfi_tclMsgFID_TUN_S_PRESET_STORAGE_PS_FREEZEMethodStart oMsgData;

	oMsgData.e8Mode.enType = (midw_fi_tcl_e8_PS_Freeze_Mode::tenType)u8Mode;

	vSendMessage( CCA_C_U16_APP_TUNER,// Destination APP ID
		oMsgData,           // parameter&
		MIDW_TUNERFI_C_U16_FID_TUN_S_PRESET_STORAGE_PS_FREEZE, //FID
		AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode
		0);
}


/*************************************************************************
 *
 * FUNCTION:     tunmstr_TunerClientHandler::u8GetPresetAutoCompare()
 *
 * DESCRIPTION:  Return preset autocompare
 * PARAMETER:
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tBool tunmstr_TunerClientHandler::u8GetPresetAutoCompare()
{

	ETG_TRACE_USR4(("u8GetPresetAutoCompare : %d",m_u8PresetAutocompare));

	return m_u8PresetAutocompare;

}



