/************************************************************************
 * FILE:           tunmstr_SrcChgManager.cpp
 * PROJECT:        G3g
 * SW-COMPONENT:   fc_tunermaster.
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:    This class will handle source change logic functionalty
 *
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      | Author                       | Modification
 * 12/04/2011| Pallavi HN (CM-AI/PJ-VW36)    | initial version
 *
 *************************************************************************/
//-----------------
// System includes
//-----------------
#include "fc_tunermaster_featureControl.h"

#include "tunermaster_main.h"
#include "tunermaster_defines.h"           // Contains all tmc related defines.
#include "tunmstr_TunerClientHandler.h"
#include "tunmstr_AudioClientHandler.h"
#include "tunmstr_SrcChg_Defines.h"
#include "tunmstr_SrcChg_Trace.h"
#include "tunmstr_SrcChgManager.h"
#include "tunmstr_DABClient_Handler.h"
#include "tunmstr_MsgToHMI.h"
#include "tunmstr_Preset_Handler.h"
#include "tunmstr_MuteHandler.h"
#ifndef tunmstr_SrcChg_AnnoHandler_H
#include "tunmstr_SrcChg_AnnoHandler.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNMSTR_TRACE_CLASS_SRCCHG
#include "trcGenProj/Header/tunmstr_SrcChgManager.cpp.trc.h"
#endif


OSAL_tTimerHandle tunmstr_SrcChgManager::_hSysErrorHandelr_Timer  = OSAL_C_INVALID_HANDLE;
// Macro to Check for the Tuner Source
/*************************************************************************
 *
 * FUNCTION:    tunmstr_SrcChgManager( )
 *
 * DESCRIPTION:  ructor
 *
 * PARAMETER:    tunmaster_tclApp* poMainApp
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tunmstr_SrcChgManager::tunmstr_SrcChgManager( tunmaster_tclApp* poMainApp)
{
	poGWMain = poMainApp;
	m_potunmaster_Config = NULL;
	m_potunmstr_TunerClientHandler = NULL;
	m_potunmstr_MsgFromHMI = NULL;
	m_potunmstr_MsgToHMI = NULL;
	m_potunmstr_DABClient_Handler = NULL;
	m_potunmstr_SrcChg_AnnoHandler = NULL;
#ifdef AUDIO_ACTIVE
	m_potunmstr_AudioClientHandler = NULL;
#endif
	m_ptunmaster_tclSPMClient=NULL;
	m_potunmstr_Preset_Handler = NULL;
	m_potunmstr_MuteHandler = NULL;
	m_blBandChangeFlag=FALSE;
	m_blBandChangeFlag = FALSE;
	m_blPresetChangeFlag_Tuner = FALSE;
	m_blPresetChangeFlag_DAB = FALSE;
	m_blTun_Header = (tU8)TUNMSTR_SRCCHG_FOREGROUND;
	m_u8ActiveSource = (tU8)TUNMSTR_SRCCHG_INVALID;
	m_u8Element_ID = (tU8)TUNMSTR_SRCCHG_INVALID;
	m_u8CurrentTunerState = (tU8)TUNMSTR_SRCCHG_INVALID;
	m_u8TunAudibaleStatus = (tU8)TUNMSTR_SRCCHG_ACTION_OFF;
	m_blDABVisibleStatus = FALSE;
	m_blDABAudibleStatus = (tU8)TUNMSTR_SRCCHG_ACTION_OFF;
	m_u8DABState = (tU8)TUNMSTR_SRCCHG_INVALID;
	m_u8DABAudibaleStatus = FALSE;
	m_u8Current_TASource = (tU8)TUNMSTR_SRCCHG_SOURCE_NO_TA;
	m_u8Current_TAAction = (tU8)TUNMSTR_SRCCHG_ACTION_OFF;
	m_blTestMode = FALSE;
	m_blRemoteSession_Active = FALSE;
	m_blExtarctBandValue = FALSE;
	m_u8PreviousBand = TUNMASTER_INVALID;
	m_u8SDS_Band = TUNMASTER_INVALID;
	m_blFrq_Requested = FALSE;
	m_blBandChg_Requested = FALSE;
	m_blErrHandlr_TmrCreated = FALSE;
	m_u8InProgSource = (tU8)TUNMSTR_SRCCHG_SOURCE_NON_RADIO;
	m_u8InProgSrcActivity = (tU8)TUNMASTER_INVALID;
	m_u8InProgDABSource = (tU8)TUNMSTR_SRCCHG_SOURCE_NON_RADIO;
	m_u8InProgDABSrcActivity = (tU8)TUNMASTER_INVALID;
	m_u16PI = 0;
	m_AnnoHandlingRequest.u8AnnoState = FALSE;
	m_AnnoHandlingRequest.u8AnnoType = TUNMASTER_INVALID;
	m_AnnoHandlingRequest.u8Source = TUNMASTER_INVALID;
	enSrcActivty = NONE;
	vCreateTimer();
}
/*************************************************************************
 *
 * FUNCTION:     ~tunmstr_SrcChgManager( )
 *
 * DESCRIPTION:  Disturctor
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tunmstr_SrcChgManager::~tunmstr_SrcChgManager( )                                  
{
	poGWMain = NULL;
	m_potunmaster_Config = NULL;
	m_potunmstr_TunerClientHandler = NULL;
	m_potunmstr_MsgFromHMI = NULL;
	m_potunmstr_MsgToHMI = NULL;
	m_potunmstr_DABClient_Handler = NULL;
	m_potunmstr_AudioClientHandler = NULL;
	m_ptunmaster_tclSPMClient=NULL;
	m_potunmstr_SrcChg_AnnoHandler = NULL;
	m_potunmstr_Preset_Handler = NULL;
	m_potunmstr_MuteHandler = NULL;
	m_blBandChangeFlag=FALSE;
	m_blPresetChangeFlag_Tuner=FALSE;
	m_blPresetChangeFlag_DAB=FALSE;
	m_blTun_Header= (tU8)TUNMSTR_SRCCHG_FOREGROUND;
	m_u8ActiveSource= (tU8)TUNMSTR_SRCCHG_SOURCE_NON_RADIO;
	m_u8Element_ID=TUNMSTR_SRCCHG_INVALID;
	m_u8CurrentTunerState=TUNMSTR_SRCCHG_INVALID;
	m_u8TunAudibaleStatus= (tU8)TUNMSTR_SRCCHG_ACTION_OFF;
	m_blDABVisibleStatus=FALSE;
	m_blDABAudibleStatus = (tU8)TUNMSTR_SRCCHG_ACTION_OFF;
	m_u8DABState=TUNMSTR_SRCCHG_INVALID;
	m_u8DABAudibaleStatus=FALSE;
	m_u8Current_TASource = (tU8)TUNMSTR_SRCCHG_SOURCE_NO_TA;
	m_u8Current_TAAction = (tU8)TUNMSTR_SRCCHG_ACTION_OFF;
	m_blTestMode=FALSE;
	m_blRemoteSession_Active=FALSE;
	m_blExtarctBandValue=FALSE;
	m_u8PreviousBand=TUNMASTER_INVALID;
	m_u8SDS_Band = TUNMASTER_INVALID;
	m_blFrq_Requested = FALSE;
	m_blBandChg_Requested =FALSE;
	m_u8InProgSource= (tU8)TUNMSTR_SRCCHG_SOURCE_NON_RADIO;
	m_u8InProgSrcActivity=TUNMASTER_INVALID;
	m_u8InProgDABSource = (tU8)TUNMSTR_SRCCHG_SOURCE_NON_RADIO;
	m_u8InProgDABSrcActivity = TUNMASTER_INVALID;
	enSrcActivty=NONE;
	m_AnnoHandlingRequest.u8AnnoState = FALSE;
	m_AnnoHandlingRequest.u8AnnoType = TUNMASTER_INVALID;
	m_AnnoHandlingRequest.u8Source = TUNMASTER_INVALID;
	m_u16PI = 0;

	vDeleteTimer();
}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_MsgFromHMI::vSet_tunmstr_SrcChg_AnnoHandler_Ptr( )
 *
 * DESCRIPTION:  Set pointer to pointer tunmstr_SrcChg_AnnoHandler*
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vSet_tunmstr_SrcChg_AnnoHandler_Ptr
(tunmstr_SrcChg_AnnoHandler* potunmstr_SrcChg_AnnoHandler)

{
	if( potunmstr_SrcChg_AnnoHandler != NULL )
	{
		m_potunmstr_SrcChg_AnnoHandler =(tunmstr_SrcChg_AnnoHandler*)potunmstr_SrcChg_AnnoHandler;
	}
	else
	{
		NORMAL_M_ASSERT ( m_potunmstr_SrcChg_AnnoHandler != NULL );
	}
}
/*************************************************************************
 *
 * FUNCTION: vSet_tunmaster_Config_Ptr( tunmaster_Config* potunmaster_Config )
 *
 * DESCRIPTION:  Set pointer to pointer tunmaster_Config
 *
 * PARAMETER:    tunmaster_Config* potunmaster_Config
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vSet_tunmaster_Config_Ptr(tunmaster_Config* potunmaster_Config)
{
	if( potunmaster_Config != NULL )
	{
		m_potunmaster_Config = ( tunmaster_Config* )potunmaster_Config;
	}

}
/*************************************************************************
 *
 * FUNCTION:    vSet_tunmstr_MsgFromHMI_Ptr( tunmstr_MsgFromHMI* potunmstr_MsgFromHMI )
 *
 * DESCRIPTION:   Set pointer to pointer tunmstr_MsgFromHMI
 *
 * PARAMETER:    tunmstr_MsgFromHMI* potunmstr_MsgFromHMI
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vSet_tunmstr_MsgFromHMI_Ptr(tunmstr_MsgFromHMI* potunmstr_MsgFromHMI )
{
	if( potunmstr_MsgFromHMI != NULL )
	{
		m_potunmstr_MsgFromHMI = ( tunmstr_MsgFromHMI* )potunmstr_MsgFromHMI;
	}

}


/*************************************************************************
 *
 * FUNCTION:    vSet_tunmstr_TunerClientHandler_Ptr( tunmstr_TunerClientHandler* potunmstr_TunerClientHandler )
 *
 * DESCRIPTION:  Set pointer to pointer tunmstr_TunerClientHandler
 *
 * PARAMETER:    tunmstr_TunerClientHandler* potunmstr_TunerClientHandler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vSet_tunmstr_TunerClientHandler_Ptr
(tunmstr_TunerClientHandler* potunmstr_TunerClientHandler )
{
	if( potunmstr_TunerClientHandler != NULL )
	{
		m_potunmstr_TunerClientHandler = (tunmstr_TunerClientHandler*)potunmstr_TunerClientHandler;
	}

}
/*************************************************************************
 *
 * FUNCTION:    vSet_tunmstr_MsgToHMI_Ptr( tunmstr_MsgToHMI* potunmstr_MsgToHMI )
 *
 * DESCRIPTION: Set pointer to pointer tunmstr_MsgToHMI
 *
 * PARAMETER:    tunmstr_MsgToHMI* potunmstr_MsgToHMI
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vSet_tunmstr_MsgToHMI_Ptr(tunmstr_MsgToHMI* potunmstr_MsgToHMI )
{
	if( potunmstr_MsgToHMI != NULL )
	{
		m_potunmstr_MsgToHMI = ( tunmstr_MsgToHMI* )potunmstr_MsgToHMI;
	}

}
/*************************************************************************
 *
 * FUNCTION:    vSet_tunmstr_DABClient_Handler_Ptr( tunmstr_DABClient_Handler* potunmstr_DABClient_Handler )
 *
 * DESCRIPTION: Set pointer to pointer tunmstr_DABClient_Handler
 *
 * PARAMETER:   tunmstr_DABClient_Handler* potunmstr_DABClient_Handler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunmstr_SrcChgManager::vSet_tunmstr_DABClient_Handler_Ptr
(tunmstr_DABClient_Handler* potunmstr_DABClient_Handler)
{
	if( potunmstr_DABClient_Handler != NULL )
	{
		m_potunmstr_DABClient_Handler = ( tunmstr_DABClient_Handler* )potunmstr_DABClient_Handler;
	}

}
/*************************************************************************
 *
 * FUNCTION:    vSet_tunmstr_AudioClientHandler_Ptr(tunmstr_AudioClientHandler* potunmstr_AudioClientHandler)
 *
 * DESCRIPTION: Set pointer to pointer tunmstr_AudioClientHandler
 *
 * PARAMETER:   tunmstr_AudioClientHandler* potunmstr_AudioClientHandler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vSet_tunmstr_AudioClientHandler_Ptr
(tunmstr_AudioClientHandler* potunmstr_AudioClientHandler)
{
	if( potunmstr_AudioClientHandler != NULL )
	{
		m_potunmstr_AudioClientHandler = (tunmstr_AudioClientHandler*)potunmstr_AudioClientHandler;
	}

}
/*************************************************************************
*
* FUNCTION:    vSet_tunmaster_tclSPMClient_Ptr(tunmaster_tclSPMClient* potunmaster_tclSPMClient)
*
* DESCRIPTION: Set pointer to pointer tunmaster_tclSPMClient
*
* PARAMETER:   tunmaster_tclSPMClient* potunmaster_tclSPMClient
*
* RETURNVALUE:  void
*
*************************************************************************/

tVoid tunmstr_SrcChgManager::vSet_tunmaster_tclSPMClient(tunmaster_tclSPMClient* potunmaster_tclSPMClient)
{
	if( potunmaster_tclSPMClient != NULL )
	{
		m_ptunmaster_tclSPMClient = ( tunmaster_tclSPMClient* )potunmaster_tclSPMClient;
	}
}

/*************************************************************************
 * FUNCTION:     tunmstr_SrcChgManager::vSet_tunmstr_tunmstr_Preset_Handler_Ptr( )
 *
 * DESCRIPTION:  tunmstr_Preset_Handler* potunmstr_Preset_Handler
 *
 * PARAMETER:    tunmstr_Preset_Handler* potunmstr_Preset_Handler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vSet_tunmstr_tunmstr_Preset_Handler_Ptr( tunmstr_Preset_Handler* potunmstr_Preset_Handler)
{
	if( potunmstr_Preset_Handler != NULL )
	{
		m_potunmstr_Preset_Handler = ( tunmstr_Preset_Handler* )potunmstr_Preset_Handler;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_Preset_Handler != NULL );
	}
}

/*************************************************************************
 *
 * FUNCTION:    vSet_tunmstr_MuteHandler_Ptr
 *
 * DESCRIPTION: Set pointer to pointer tunmstr_Presethandler
 *
 * PARAMETER:   tunmstr_Presethandler* potunmstr_Presethandler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vSet_tunmstr_MuteHandler_Ptr(tunmstr_MuteHandler* potunmstr_MuteHandler)

{
	if( potunmstr_MuteHandler != NULL )
	{
		m_potunmstr_MuteHandler = ( tunmstr_MuteHandler* )potunmstr_MuteHandler;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_MuteHandler != NULL );
	}
}

/*************************************************************************
 *
 * FUNCTION:    blCompareBand( tU8 u8New_Band )
 *
 * DESCRIPTION: compares current band with Band infomation sent from HMI and check if both are same.
 *
 * PARAMETER:   u8New_Band
 *
 * RETURNVALUE: tBool
 *
 *************************************************************************/
tBool tunmstr_SrcChgManager::blCompareBand(const tU8 u8New_Band)const
{
	tBool blBandChange = FALSE;
	if(u8New_Band == m_u8ActiveSource)
	{
		blBandChange = FALSE; 
		// same band, no need to send change band message to fc_amfmtuner
	}
	else
	{
		blBandChange = TRUE;
	}
	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, 
			ET_EN_T16 _ TUNMSTR_TRACE_SRCCHG_MANGR_COMPARE_BAND _
			ET_EN_T8  _ blBandChange _
			ET_EN_DONE );

	return (blBandChange);

}

/*************************************************************************
 *
 * FUNCTION:    blGetBandFlagStatus(  )
 *
 * DESCRIPTION: Returns Status of Band Change Flasg
 *
 * PARAMETER:   Void
 *
 * RETURNVALUE: tBool
 *
 *************************************************************************/
tBool tunmstr_SrcChgManager::blGetBandFlagStatus()const
{
	return(m_blBandChangeFlag);
}

/*************************************************************************
 *
 * FUNCTION:    blExtractBandInfo(  )
 *
 * DESCRIPTION: Returns Status if band value has to be extarct from AtStation info are not
 *
 * PARAMETER:   Void
 *
 * RETURNVALUE: tBool
 *
 *************************************************************************/
tBool tunmstr_SrcChgManager::blExtractBandInfo()const
{
	return(m_blExtarctBandValue);
}
/*************************************************************************
 *
 * FUNCTION:    vSetExtractBand_Status(  )
 *
 * DESCRIPTION: Updates the member variable m_blExtarctBandValue
 *
 * PARAMETER:   const tBool blStatus
 *
 * RETURNVALUE: tVoid
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vSetExtractBand_Status(const tBool blStatus)
{
	m_blExtarctBandValue = blStatus;
}
/*************************************************************************
 *
 * FUNCTION:    u8GetLastBand(  )
 *
 * DESCRIPTION: Returns Band value, which was active before remote control session
 *
 * PARAMETER:   Void
 *
 * RETURNVALUE: tU8
 *
 *************************************************************************/

tU8 tunmstr_SrcChgManager::u8GetLastBand()const
{
	return m_u8PreviousBand;
}
/*************************************************************************
 *
 * FUNCTION:    SetLastBand(  )
 *
 * DESCRIPTION: Returns Band value, which was active before remote control session
 *
 * PARAMETER:   Void
 *
 * RETURNVALUE: tU8
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vSetLastBand(const tU8 u8Band)
{
	m_u8PreviousBand = u8Band;
}
/*************************************************************************
 *
 * FUNCTION:    blGetPresetRecallStatus(  )
 *
 * DESCRIPTION: Returns Status of Band Change Flasg
 *
 * PARAMETER:   Void
 *
 * RETURNVALUE: tBool
 *
 *************************************************************************/
tBool tunmstr_SrcChgManager::blGetPresetRecallStatus()const
{
	return(m_blPresetChangeFlag_Tuner);
}
/*************************************************************************
 *
 * FUNCTION:    vSetPresetRecallStatus_Tuner(tBool blStatus )
 *
 * DESCRIPTION: Sets status of preset recall Flag
 *
 * PARAMETER:   tBool blStatus
 *
 * RETURNVALUE: tVoid
 *
 *************************************************************************/

tVoid tunmstr_SrcChgManager::vSetPresetRecallStatus_Tuner(const tBool blStatus)
{
	m_blPresetChangeFlag_Tuner = blStatus;
}
/*************************************************************************
 *
 * FUNCTION:    vSetBandChg_Flag
 *
 * DESCRIPTION: Sets status of preset recall Flag
 *
 * PARAMETER:   tBool blStatus
 *
 * RETURNVALUE: tVoid
 *
 *************************************************************************/

tVoid tunmstr_SrcChgManager::vSetBandChg_Flag(const tBool blStatus)
{

	m_blBandChangeFlag = blStatus;
}
/*************************************************************************
 *
 * FUNCTION:    vSetRemoteControl_Status(tBool blStatus )
 *
 * DESCRIPTION: Set the status of RemoteControl
 *
 * PARAMETER:   tBool blStatus
 *
 * RETURNVALUE: tVoid
 *
 *************************************************************************/

tVoid tunmstr_SrcChgManager::vSetRemoteControl_Status(const tBool blStatus)
{
	ETG_TRACE_USR1(("vSetRemoteControl_Status"
		"RemoteSession=%d, ExtractBand=%d, Status=%d",
		m_blRemoteSession_Active,m_blExtarctBandValue,blStatus));
	if((blStatus == FALSE) && (m_blRemoteSession_Active == TRUE))
	{
		vSetExtractBand_Status(TRUE);
	}
	else
	{
		vSetExtractBand_Status(FALSE);

	}
	m_blRemoteSession_Active = blStatus;
}
/*************************************************************************
 *
 * FUNCTION:    vSetPresetRecallStatus_DAB(tBool blStatus )
 *
 * DESCRIPTION: Sets status of preset recall Flag
 *
 * PARAMETER:   tBool blStatus
 *
 * RETURNVALUE: tVoid
 *
 *************************************************************************/

tVoid tunmstr_SrcChgManager::vSetPresetRecallStatus_DAB(const tBool blStatus)
{
	m_blPresetChangeFlag_DAB = blStatus; 
}

/*************************************************************************
 *
 * FUNCTION:    vSetSourceInfo(tU8 u8New_Band)
 *
 * DESCRIPTION: Sets value of active band
 *
 * PARAMETER:   u8New_Band
 *
 * RETURNVALUE: tVoid
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vSetSourceInfo(const tU8 u8New_Band)
{
	m_u8ActiveSource = u8New_Band;
	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG,
			ET_EN_T16 _ TUNMSTR_TRACE_SRCCHG_MANGR_BANDINFO _
			ET_EN_T8  _ m_u8ActiveSource _
			ET_EN_DONE );
}
/*************************************************************************
 *
 * FUNCTION:    vSetSourceInfo(tU8 u8New_Band)
 *
 * DESCRIPTION: Sets value of active band
 *
 * PARAMETER:   u8New_Band
 *
 * RETURNVALUE: tVoid
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vSendCurrentSource_Info(tU8 u8Source)
{
	if(m_potunmstr_MsgToHMI == NULL)
	{
		NORMAL_M_ASSERT(m_potunmstr_MsgToHMI!=NULL);
		return;
	}
	ETG_TRACE_USR1(("vSendCurrentSource_Info, Source Value sent to HMI Source=%02x",
			ETG_CENUM(enTunmstrSource,u8Source)));
	m_potunmstr_MsgToHMI->vSend_g_Band_Info(u8Source, false);
}
/*************************************************************************
 *
 * FUNCTION:    tU8 u8GetCurrentSource()
 *
 * DESCRIPTION: returns Active band infomation
 *
 * PARAMETER:   tVoid
 *
 * RETURNVALUE: tU8
 *
 *************************************************************************/
tU8 tunmstr_SrcChgManager::u8GetCurrentSource()const
{
	return m_u8ActiveSource;
}
/*************************************************************************
 *
 * FUNCTION:    tBool u8GetTunerState()
 *
 * DESCRIPTION: returns current state of Tuner, FG/BG
 *
 * PARAMETER:   tVoid
 *
 * RETURNVALUE: ttBool
 *
 *************************************************************************/
tU8 tunmstr_SrcChgManager:: u8GetTunerState()const
{
	return m_u8CurrentTunerState;
}
/*************************************************************************
 *
 * FUNCTION:    tBool u8GetDABState()
 *
 * DESCRIPTION: returns current state of DAB, FG/BG
 *
 * PARAMETER:   tVoid
 *
 * RETURNVALUE: ttBool
 *
 *************************************************************************/
tU8 tunmstr_SrcChgManager:: u8GetDABState()const
{
	ETG_TRACE_USR4(("tunmstr_SrcChgManager::u8GetDABState() DAB_State=%02x",
		ETG_CENUM(enTunmstrTunerState,m_u8DABState)));
	return m_u8DABState;
}
/*************************************************************************
 *
 * FUNCTION:    tBool vSetDABState()
 *
 * DESCRIPTION: returns current state of DAB, FG/BG
 *
 * PARAMETER:   tVoid
 *
 * RETURNVALUE: ttBool
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager:: vSetDABState(const tU8 u8Status)
{
	m_u8DABState = u8Status;
	ETG_TRACE_USR1(("tunmstr_SrcChgManager::vSetDABState() DAB_State=%02x",
	ETG_CENUM(enTunmstrTunerState,m_u8DABState)));
}
/*************************************************************************
 *
 * FUNCTION:   vSetTunerState(tBool blTunerState)
 *
 * DESCRIPTION: Sets current state of Tuner
 *
 * PARAMETER:   tVoid
 *
 * RETURNVALUE: tBool
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager:: vSetTunerState(const tU8 u8TunerState)
{
	m_u8CurrentTunerState = u8TunerState;
	ETG_TRACE_USR1(("tunmstr_SrcChgManager::vSetTunerState() Tun_State=%02x",
	ETG_CENUM(enTunmstrTunerState,m_u8CurrentTunerState)));
}
/*************************************************************************
 *
 * FUNCTION:    tBool blGetDABVisibalityStatus()
 *
 * DESCRIPTION: returns current state of DAB, Visible/Invisible
 *
 * PARAMETER:   tVoid
 *
 * RETURNVALUE: ttBool
 *
 *************************************************************************/
tBool tunmstr_SrcChgManager:: blGetDABVisibalityStatus()const
{
	return m_blDABVisibleStatus;
}
/*************************************************************************
 *
 * FUNCTION:    tBool u8GetTunAudibleStatus()
 *
 * DESCRIPTION: returns current state of Tuner Visible/Invisible
 *
 * PARAMETER:   tVoid
 *
 * RETURNVALUE: ttBool
 *
 *************************************************************************/
tU8 tunmstr_SrcChgManager:: u8GetTunAudibleStatus()const
{
	return m_u8TunAudibaleStatus;
}
/*************************************************************************
 *
 * FUNCTION:     vSetTunAudibleStatus()
 *
 * DESCRIPTION: Updates the memeber variable m_u8TunAudibaleStatus
 *
 * PARAMETER:  tU8 u8Status
 *
 * RETURNVALUE: tVoid
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager:: vSetTunAudibleStatus(const tU8 u8Status)
{
	m_u8TunAudibaleStatus = u8Status;
}
/*************************************************************************
 *
 * FUNCTION:    tBool blGetDABAudibleStatus()
 *
 * DESCRIPTION: returns current state of DAB Audible/Not Audible
 *
 * PARAMETER:   tVoid
 *
 * RETURNVALUE: ttBool
 *
 *************************************************************************/
tU8 tunmstr_SrcChgManager:: u8GetDABAudibleStatus()const
{
	return m_u8DABAudibaleStatus;
}
/*************************************************************************
 *
 * FUNCTION:    tBool vSetElement_ID()
 *
 * DESCRIPTION: returns current state of DAB Audible/Not Audible
 *
 * PARAMETER:   tVoid
 *
 * RETURNVALUE: ttBool
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vSetElement_ID(tU8 u8Element_ID)
{
	m_u8Element_ID = u8Element_ID;
}
/*************************************************************************
 *  FUNCTION:    tVoid tunmstr_SrcChgManager::vHandleTunerSrcChg_ON()
 *
 *  DESCRIPTION: This function will takes action based on the FG/BG info of current Tuner state
 *
 *  PARAMETER:   tU8 u8Source,
 *
 *
 *  RETURNVALUE: None
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vHandleTunerSrcChg_ON(tU8 u8Source)
{
	if(m_potunmstr_SrcChg_AnnoHandler == NULL) 
	{
		NORMAL_M_ASSERT( m_potunmstr_SrcChg_AnnoHandler != NULL );
		return;
	}

	tU8 u8Tun_State = u8GetTunerState();
	ETG_TRACE_USR1(("tunmstr_SrcChgManager::vHandleTunerSrcChg_ON() Tun_State=%02x",
	ETG_CENUM(enTunmstrTunerState,u8Tun_State)));
	if(m_potunmstr_SrcChg_AnnoHandler->m_ActiveAnnoSrc != TunMstr_AnnoActive_None)
	{
		tU8 u8TASource = m_potunmstr_SrcChg_AnnoHandler->u8ConvertCurrentAnnoARLSource((tU8)m_potunmstr_SrcChg_AnnoHandler->m_ActiveAnnoSrc);
		m_potunmstr_SrcChg_AnnoHandler->vSend_Src_Chg_Request(u8TASource,(tU8)TUNMSTR_SRCCHG_ACTION_OFF);
		m_potunmstr_SrcChg_AnnoHandler->vSetActiveAnnoSrc(TunMstr_AnnoActive_None);
	}

	if((u8GetDABState() != TUNMSTR_SRCCHG_BACKGROUND) && (u8GetDABState() != TUNMSTR_SRCCHG_INVALID))
	{
		m_potunmstr_DABClient_Handler->vSend_s_Source_State((tU8)TUNMSTR_SRCCHG_DAB_BACKGROUND);
		vSetDABState((tU8)TUNMSTR_SRCCHG_BACKGROUND);
	}

	if((tU8)TUNMSTR_SRCCHG_FOREGROUND == u8Tun_State) 
	{
		vHandleTuner_ON_FG(u8Source);
		vSetSourceInfo(u8Source);
		m_u8TunAudibaleStatus = (tU8)TUNMSTR_SRCCHG_ACTION_ON;
	}
	else if( ((tU8)TUNMSTR_SRCCHG_BACKGROUND == u8Tun_State ) ||((tU8)TUNMSTR_SRCCHG_INVALID == u8Tun_State ))
	{
		vHandleTuner_ON_BG(u8Source);
		//update source and Action value in member variables
		vSetSourceInfo(u8Source);
		m_u8TunAudibaleStatus = (tU8)TUNMSTR_SRCCHG_ACTION_ON;
	}
	else if(u8Tun_State ==(tU8)TUNMSTR_SRCCHG_INPROGESS)
	{
		vHandleTunerStateInProgress(u8Source,(tU8)TUNMSTR_SRCCHG_ACTION_ON);
	}
	else
	{
		// no updates
	}

}//end of function
/*************************************************************************
 *  FUNCTION:    tVoid tunmstr_SrcChgManager::vHandleTunerSrcChg_PAUSE()
 *
 *  DESCRIPTION: Handle to handle Pause stae
 *  Use cases: Zero Volume, Band Change on Zero Volume(HK_PRess, RVC,SWC), Phone Call active, TA Active
 *
 *  PARAMETER:   tU8 u8Source
 *
 *
 *  RETURNVALUE: None
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vHandleTunerSrcChg_PAUSE(tU8 u8Source)
{
	if( (m_potunmstr_TunerClientHandler == NULL) ||
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			(m_potunmstr_AudioClientHandler == NULL)||
#endif
			(m_ptunmaster_tclSPMClient==NULL))
	{
		NORMAL_M_ASSERT( m_potunmstr_TunerClientHandler != NULL );
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
#endif
		NORMAL_M_ASSERT( m_ptunmaster_tclSPMClient != NULL );
		return;
	}
	tU8 u8Tun_State = u8GetTunerState();
	tU32 u32CVMEvent=m_ptunmaster_tclSPMClient->u32GetCVMEvent();
	ETG_TRACE_USR4(("vHandleTunerSrcChg_PAUSE()->u8Tun_State=%d u32CVMEvent=%d u8Source=%d",u8Tun_State,u32CVMEvent,u8Source));

	if(u32CVMEvent==TUNMSTR_CRITICAL_LOW_VOLTAGE_START)
	{
		vHandleCriticalVg(u8Source,(tU8)TUNMSTR_SRCCHG_ACTION_PAUSE);
		return;
	}
	if((tU8)TUNMSTR_SRCCHG_INPROGESS == u8Tun_State )
	{
		vHandleTunerStateInProgress(u8Source,(tU8)TUNMSTR_SRCCHG_ACTION_PAUSE );
		return;
	}
	if(blIsFMTAActive())
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(m_potunmstr_AudioClientHandler->u8MapTunmstrSources(u8Source) , (tU8)TUNMSTR_SRCCHG_ACTION_PAUSE);
#endif
		return;
	}
	switch(u8Source)
	{
	case TUNMSTR_SRCCHG_SOURCE_TUN1FM:
	case TUNMSTR_SRCCHG_SOURCE_TUN1AM:
   case TUNMSTR_SRCCHG_SOURCE_DRM:
	{
		vhandleTunerpAUSE(u8Source);
	break;
	}
	default:
	{
		break;
	}
	};//switch(u8Band)
	vSetSourceInfo(u8Source);
	m_u8TunAudibaleStatus = (tU8)TUNMSTR_SRCCHG_ACTION_PAUSE;
	//update source and Action value in member variables
}//end of function
/*************************************************************************
 *  FUNCTION:    tVoid tunmstr_SrcChgManager::vHandleTunerSrcChg_OFF()
 *
 *  DESCRIPTION: This function will handle "OFF" state by sending tuner to BG if required.
 *  Use Cases:	Normal source change, Band Change, SWC, SDS, RVC
 *
 *  PARAMETER:   tU8 u8Source
 *
 *
 *  RETURNVALUE: None
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vHandleTunerSrcChg_OFF(tU8 u8Source)
{
	if(
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			(m_potunmstr_AudioClientHandler == NULL) ||
#endif
			(m_potunmstr_TunerClientHandler == NULL)||(m_ptunmaster_tclSPMClient==NULL))
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT(m_potunmstr_AudioClientHandler != NULL);
#endif
		NORMAL_M_ASSERT(m_ptunmaster_tclSPMClient != NULL);
		NORMAL_M_ASSERT(m_potunmstr_TunerClientHandler != NULL);
		return;
	}
	tU32 u32CVMEvent=m_ptunmaster_tclSPMClient->u32GetCVMEvent();
	tU8 u8Tun_State = u8GetTunerState();
	ETG_TRACE_USR4(("vHandleTunerSrcChg_OFF() Tun_State=%02x CVMEvent=%d Source=%02x",
	ETG_CENUM(enTunmstrTunerState,u8Tun_State),u32CVMEvent,
	ETG_CENUM(enTunmstrSource,u8Source)));


	if(u32CVMEvent==TUNMSTR_CRITICAL_LOW_VOLTAGE_START)
	{
        vHandleCriticalVg(u8Source, (tU8)TUNMSTR_SRCCHG_ACTION_OFF);
		return;
	}
	if((blGetDirectFrqRequest_Status() == TRUE) || ((tU8)TUNMSTR_SRCCHG_BACKGROUND == u8Tun_State))
	{

		ETG_TRACE_USR4(("vHandleTunerSrcChg_OFF,  send result to lib ->"
				"SDS_Req = %d Tun_State =%d",
				blGetDirectFrqRequest_Status(), u8Tun_State ));
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(\
			m_potunmstr_AudioClientHandler->u8MapTunmstrSources(u8Source), (tU8)TUNMSTR_SRCCHG_ACTION_OFF);
#endif
	}

	else if(((tU8)TUNMSTR_SRCCHG_FOREGROUND == u8Tun_State) || (TUNMSTR_SRCCHG_INVALID == u8Tun_State))
	{
        enSrcActivty=enConvertSrcForOFF(u8Source);
        //send tuner to BG
        vSendTunerToBG( u8Source, enSrcActivty);
	}
	else if(u8Tun_State ==(tU8)TUNMSTR_SRCCHG_INPROGESS)
	{
		vHandleTunerStateInProgress(u8Source,(tU8)TUNMSTR_SRCCHG_ACTION_OFF);
		return;
	}
	else
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(
		m_potunmstr_AudioClientHandler->u8MapTunmstrSources(u8Source), (tU8)TUNMSTR_SRCCHG_ACTION_OFF);
#endif
		ETG_TRACE_USR4(("vHandleTunerSrcChg_OFF, default case, send result to ARL"));
	}

		vHandleDABTempAnnouncement(); // DAB surveillance check SUZUKI-20811 
	/** avoid setting last active source when off req has arrived */
	//vSetSourceInfo(u8Source);
	m_u8TunAudibaleStatus = (tU8)TUNMSTR_SRCCHG_ACTION_OFF;
	//update Action value in member variables
}//end of vHandleTunerSrcChg_OFF
/*************************************************************************
 *  FUNCTION:    tVoid tunmstr_SrcChgManager::vHandleDABSrcChg_ON()
 *
 *  DESCRIPTION: Handles source change for DAB
 *  use Case: Normal Source change to DAB
 *
 *  PARAMETER:   tU8 u8Source
 *
 *
 *  RETURNVALUE: None
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vHandleDABSrcChg_ON(tU8 u8Source)
{
	if(
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			(m_potunmstr_AudioClientHandler == NULL) ||
#endif
			(m_potunmstr_DABClient_Handler == NULL) || (m_potunmstr_SrcChg_AnnoHandler == NULL))
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT(m_potunmstr_AudioClientHandler != NULL);
#endif
		NORMAL_M_ASSERT(m_potunmstr_SrcChg_AnnoHandler != NULL);
		NORMAL_M_ASSERT(m_potunmstr_DABClient_Handler != NULL);
		ETG_TRACE_USR4(("vHandleDABSrcChg_ON, Assert!!!"));
		return;
	}
	tU8 u8DABState = u8GetDABState();
	ETG_TRACE_USR4(("vHandleDABSrcChg_ON()DAB_State=%02x Source=%02x",
	ETG_CENUM(enTunmstrTunerState,u8DABState),
	ETG_CENUM(enTunmstrSource,u8Source)));
	/* When DAB is active, ARL sends DAB pause follwed by DAB TA play
	1. Update DAB status as Pause
	2. Send DAB TA to FG
	3  Once DAB TA Ends and ARL sends DAB TA stop , update the variable m_blDABTAEnded as True,
	so that when ARL send DAB Play,by check the flag m_blDABTAEnded and DAB state for Pause, DAB can be put to FG*/
	if((tU8)TUNMSTR_SRCCHG_DAB_PAUSE_STATE ==u8DABState)
	{
		// Solution given for JIRA issue NIKAI-3964
		if(m_potunmstr_SrcChg_AnnoHandler->blGetTPState_DAB() ==TRUE)
		{
			ETG_TRACE_USR4(("vHandleDABSrcChg_ON, Send TP state "))
			m_potunmstr_MsgToHMI->vSend_g_TP_Status(m_potunmstr_SrcChg_AnnoHandler->blGetTPState_DAB(),\
			(tU8)TUNMSTR_SRCCHG_SOURCE_DAB);
		}
		ETG_TRACE_USR4(("vHandleDABSrcChg_ON, DAB is in Pause state , Sedn dab to FG "))
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(
		m_potunmstr_AudioClientHandler->u8MapTunmstrSources(u8Source), (tU8)TUNMSTR_SRCCHG_ACTION_ON);
#endif
		m_potunmstr_SrcChg_AnnoHandler->vSetDABTA_Ended(FALSE);
	}
	else if( ((tU8)TUNMSTR_SRCCHG_BACKGROUND == u8DABState )||((tU8)TUNMSTR_SRCCHG_INVALID == u8DABState ))
	{
		// Solution given for JIRA issue NIKAI-3964
		if(m_potunmstr_SrcChg_AnnoHandler->blGetTPState_DAB() ==TRUE)
		{
			m_potunmstr_MsgToHMI->vSend_g_TP_Status(m_potunmstr_SrcChg_AnnoHandler->blGetTPState_DAB(),\
				(tU8)TUNMSTR_SRCCHG_SOURCE_DAB);
		}
		enSrcActivty=DAB_ON;
		m_potunmstr_DABClient_Handler->vSend_s_Source_State((tU8)TUNMSTR_SRCCHG_DAB_FOREGROUND);
	}
	else if((tU8)TUNMSTR_SRCCHG_INPROGESS == u8DABState)
	{
		vHandleDABStateInProgress(u8Source,TUNMSTR_SRCCHG_ACTION_ON);
	}
	else if((tU8)TUNMSTR_SRCCHG_DAB_SURVEILLANCE == u8DABState)
	{
		enSrcActivty=DAB_ON;
		m_potunmstr_DABClient_Handler->vSend_s_Source_State((tU8)TUNMSTR_SRCCHG_DAB_FOREGROUND);
	}
	//If tuner state is FG or Pause
	else
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		ETG_TRACE_USR4(("vHandleDABSrcChg_ON, DAB is in FG hence send result to Lib"))
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(
		m_potunmstr_AudioClientHandler->u8MapTunmstrSources(u8Source), (tU8)TUNMSTR_SRCCHG_ACTION_ON);
#endif
	}
	vSetDABState((tU8)TUNMSTR_SRCCHG_FOREGROUND);
	vSetSourceInfo(u8Source);
	m_u8DABAudibaleStatus = (tU8)TUNMSTR_SRCCHG_ACTION_ON;
	//update source and Action value in member variables
}
/*************************************************************************
 *  FUNCTION:    tVoid tunmstr_SrcChgManager::vHandleDABSrcChg_PAUSE()
 *
 *  DESCRIPTION: This function will handle source change
 *  Use Case: Zero Volume, Phone Active, SrcChg on Zero Volume....
 *
 *  PARAMETER:   tU8 u8Source
 *
 *
 *  RETURNVALUE: None
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vHandleDABSrcChg_PAUSE(tU8 u8Source)
{
	if( (m_potunmstr_DABClient_Handler == NULL) ||
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			(m_potunmstr_AudioClientHandler == NULL)||
#endif
			(m_potunmstr_MsgToHMI==NULL)||(m_ptunmaster_tclSPMClient==NULL)||(m_potunmstr_SrcChg_AnnoHandler == NULL))
	{
		NORMAL_M_ASSERT( m_potunmstr_DABClient_Handler != NULL );
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
#endif
		NORMAL_M_ASSERT(m_potunmstr_MsgToHMI != NULL);
		NORMAL_M_ASSERT( m_ptunmaster_tclSPMClient != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChg_AnnoHandler != NULL );
		return;
	}
	tU32 u32CVMEvent=m_ptunmaster_tclSPMClient->u32GetCVMEvent();
	tU8 u8DABState = u8GetDABState();
    tU8 u8Band = u8ConvertSrcToBand(u8GetCurrentSource());
	ETG_TRACE_USR4(("vHandleDABSrcChg_PAUSE()DAB_State=%02x Source=%02x u32CVMEvent=%d Band=%02x",
	ETG_CENUM(enTunmstrTunerState,u8DABState),
	ETG_CENUM(enTunmstrSource,u8Source),u32CVMEvent,
	ETG_CENUM(enTunmstrSource,u8Band)));
	if(u32CVMEvent==TUNMSTR_CRITICAL_LOW_VOLTAGE_START)
	{
		m_potunmstr_DABClient_Handler->vSend_s_Source_State((tU8)TUNMSTR_SRCCHG_DAB_BACKGROUND);
		vSetDABState((tU8)TUNMSTR_SRCCHG_BACKGROUND);
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(
		m_potunmstr_AudioClientHandler->u8MapTunmstrSources(u8Source), (tU8)TUNMSTR_SRCCHG_ACTION_PAUSE);
#endif
		return;
	}
	if(m_potunmstr_SrcChg_AnnoHandler->blGetTA_Anno_Status() == TRUE)
	{
		ETG_TRACE_USR4(("vHandleDABSrcChg_PAUSE, TA active send result to ARL"))
		vSetDABState((tU8)TUNMSTR_SRCCHG_DAB_PAUSE_STATE);
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(
		m_potunmstr_AudioClientHandler->u8MapTunmstrSources(u8Source) , (tU8)TUNMSTR_SRCCHG_ACTION_PAUSE);
#endif
	}

	else if((u8Band !=u8Source)&&((u8DABState == (tU8)TUNMSTR_SRCCHG_BACKGROUND)||((tU8)TUNMSTR_SRCCHG_INVALID == u8DABState )))
	{
		// Solution given for JIRA issue NIKAI-3964
		if(m_potunmstr_SrcChg_AnnoHandler->blGetTPState_DAB() ==TRUE)
		{
			ETG_TRACE_USR4(("vHandleDABSrcChg_PAUSE,Send TP status"))
			m_potunmstr_MsgToHMI->vSend_g_TP_Status(m_potunmstr_SrcChg_AnnoHandler->blGetTPState_DAB(),\
			(tU8)TUNMSTR_SRCCHG_SOURCE_DAB);
		}
		enSrcActivty=DAB_PAUSE;
		//if DAB is not current active source send it to FG
		m_potunmstr_DABClient_Handler->vSend_s_Source_State((tU8)TUNMSTR_SRCCHG_DAB_FOREGROUND);
		vSetDABState((tU8)TUNMSTR_SRCCHG_FOREGROUND);
	}
	else if((tU8)TUNMSTR_SRCCHG_INPROGESS == u8DABState)
	{
		vHandleDABStateInProgress(u8Source,TUNMSTR_SRCCHG_ACTION_PAUSE);
	}
	else if((tU8)TUNMSTR_SRCCHG_DAB_SURVEILLANCE == u8DABState)
	{
		enSrcActivty=DAB_PAUSE;
		m_potunmstr_DABClient_Handler->vSend_s_Source_State((tU8)TUNMSTR_SRCCHG_DAB_FOREGROUND);
	}
	else
	{
		ETG_TRACE_USR4(("vHandleDABSrcChg_PAUSE, No action required send Result to LIB"
			"update Dab status as Pause"));
		//IF DAB is already in FG, send result to AUdio lib.
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(
		m_potunmstr_AudioClientHandler->u8MapTunmstrSources(u8Source), (tU8)TUNMSTR_SRCCHG_ACTION_PAUSE);
#endif
		/* When DAB is active, ARL sends DAB pause follwed by DAB TA play
		1. Update DAB status as Pause
		2.  Once DAB TA Ends and ARL sends DAB TA stop , update the variable m_blDABTAEnded as True,
		so that when ARL send DAB Play,by check the flag m_blDABTAEnded and DAB state for Pause, DAB can be put to FG*/
		vSetDABState((tU8)TUNMSTR_SRCCHG_DAB_PAUSE_STATE);
	}
	vSetSourceInfo(u8Source);
	m_u8DABAudibaleStatus = (tU8)TUNMSTR_SRCCHG_ACTION_PAUSE;
	//update source and Action value in member variables
}//end of function
/*************************************************************************
 *  FUNCTION:    tVoid tunmstr_SrcChgManager::vHandleDABSrcChg_OFF()
 *
 *  DESCRIPTION: Handles source change for DAB
 *  Use Case: Normal Change, RVC, SWC
 *
 *  PARAMETER:   tU8 u8Source
 *
 *
 *  RETURNVALUE: None
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vHandleDABSrcChg_OFF(tU8 u8Source)
{
	if(
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			(m_potunmstr_AudioClientHandler == NULL) ||
#endif
			(m_potunmstr_DABClient_Handler == NULL)|| (m_ptunmaster_tclSPMClient==NULL))
	{
		
		NORMAL_M_ASSERT( m_potunmstr_DABClient_Handler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
		NORMAL_M_ASSERT(m_ptunmaster_tclSPMClient != NULL);
		return;
	}
	tU32 u32CVMEvent=m_ptunmaster_tclSPMClient->u32GetCVMEvent();
	tU8 u8DABState = u8GetDABState();
	ETG_TRACE_USR4(("vHandleDABSrcChg_OFF()DAB_State=%02x Source=%02x u32CVMEvent=%d",
	ETG_CENUM(enTunmstrTunerState,u8DABState),
	ETG_CENUM(enTunmstrSource,u8Source),u32CVMEvent));
	if(u32CVMEvent==TUNMSTR_CRITICAL_LOW_VOLTAGE_START)
	{
		m_potunmstr_DABClient_Handler->vSend_s_Source_State((tU8)TUNMSTR_SRCCHG_DAB_BACKGROUND);
		vSetDABState((tU8)TUNMSTR_SRCCHG_BACKGROUND);
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(
		m_potunmstr_AudioClientHandler->u8MapTunmstrSources(u8Source), (tU8)TUNMSTR_SRCCHG_ACTION_OFF);
#endif
		return;
	}


	//If dab state is in Pause or FG or INVALID and DAB is Invisible
	if(((tU8)TUNMSTR_SRCCHG_FOREGROUND == u8DABState ) ||( (tU8)TUNMSTR_SRCCHG_DAB_PAUSE_STATE == u8DABState))
	{
		enSrcActivty=DAB_OFF;
		m_potunmstr_DABClient_Handler->vSend_s_Source_State((tU8)TUNMSTR_SRCCHG_DAB_BACKGROUND);
		vSetDABState((tU8)TUNMSTR_SRCCHG_BACKGROUND);
		//When DAB is send to BG clear the  TA source and Action
		//JIRA issue NIKAI-4868, NKAI-4866  and
		m_u8Current_TASource = (tU8)TUNMSTR_SRCCHG_SOURCE_NO_TA;
		m_u8Current_TAAction = (tU8)TUNMSTR_SRCCHG_ACTION_OFF;
		m_u8ActiveSource = (tU8)TUNMSTR_SRCCHG_SOURCE_DAB;
	}// Normal Source Change
	else if(((tU8)TUNMSTR_SRCCHG_BACKGROUND == u8DABState)||((tU8)TUNMSTR_SRCCHG_INVALID == u8DABState ))
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(
		m_potunmstr_AudioClientHandler->u8MapTunmstrSources(u8Source), (tU8)TUNMSTR_SRCCHG_ACTION_OFF);
#endif
		//already in BG, send result to LIB
	}// nested source change
	else if((tU8)TUNMSTR_SRCCHG_INPROGESS == u8DABState)
	{
		vHandleDABStateInProgress(u8Source,TUNMSTR_SRCCHG_ACTION_OFF);
	}
	else
	{
		//nothing
	}
	vHandleDABTempAnnouncement();  //DAB surveillance check SUZUKI-20811 
	//vSetSourceInfo(u8Source);
	m_u8DABAudibaleStatus = (tU8)TUNMSTR_SRCCHG_ACTION_OFF;
	//update source and Action value in member variables
}//end of function
/*************************************************************************
 *  FUNCTION:    tVoid tunmstr_SrcChgManager::vHandleOtherSrcChg_Play()
 *
 *  DESCRIPTION: Handler for FM_TA and DAB_TA
 *  Use Cases:	Normal FM_TA, DAB_TA Active
 *
 *  PARAMETER:   tU8 u8Source
 *
 *
 *  RETURNVALUE: None
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vHandleAnnoSrc_ON(tU8 u8Source)
{
	if ((m_potunmstr_DABClient_Handler == NULL)||(m_potunmstr_TunerClientHandler == NULL) ||(NULL==m_potunmstr_SrcChg_AnnoHandler) )
	{
		NORMAL_M_ASSERT( m_potunmstr_DABClient_Handler != NULL );
		NORMAL_M_ASSERT(m_potunmstr_TunerClientHandler != NULL);
		NORMAL_M_ASSERT(m_potunmstr_SrcChg_AnnoHandler!= NULL);
		ETG_TRACE_USR4(("tunmstr_SrcChgManager::vHandleAnnoSrc_ON, ASSERT!!!!!!!"));
		return;
	}
	m_u8Current_TAAction = (tU8)TUNMSTR_SRCCHG_ACTION_ON;
	tU8 u8Tun_State = u8GetTunerState();
	switch(u8Source)
	{
	case TUNMSTR_SRCCHG_SOURCE_FM_TA:
	{
		m_u8Current_TASource = (tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA;
		enSrcActivty=FMTA_ON;
		m_potunmstr_TunerClientHandler->vSend_s_Audio_FG_BG_New(
				(tU8)TUNMSTR_SRCCHG_FOREGROUND, (tU8)TUNMSTR_SRCCHG_CHG_TO_FG, (tU8)TUNMSTR_SRCCHG_TA_CHG_FGBG, u8Tun_State,0xFF );
		break;
	}
	case TUNMSTR_SRCCHG_SOURCE_DAB_TA:
	{
		m_u8Current_TASource = (tU8)TUNMSTR_SRCCHG_SOURCE_DAB_TA;
		m_potunmstr_DABClient_Handler->vSend_s_SlectAnno(TunMstr_AnnoActive_DABTA, TRUE);
		vUpdateAnnoHandlingRequest(TRUE,(tU8)TUNMSTR_SRCCHG_SOURCE_DAB,(tU8)TUNMSTR_SRCCHG_ANNOTYPE_TA);
		m_potunmstr_MsgToHMI->vSend_g_Announcement_Status(TRUE, (tU8)TUNMSTR_SRCCHG_SOURCE_DAB, (tU8)TUNMSTR_SRCCHG_ANNOTYPE_TA);
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(m_potunmstr_AudioClientHandler->u8MapTunmstrSources((tU8)TUNMSTR_SRCCHG_SOURCE_DAB_TA), (tU8)TUNMSTR_SRCCHG_ACTION_ON);
#endif
		break;
	}
	case TUNMSTR_SRCCHG_SOURCE_FMPTY31:
	{
		m_u8Current_TASource = (tU8)TUNMSTR_SRCCHG_SOURCE_FMPTY31;
		enSrcActivty=FMTA_ON;
		m_potunmstr_TunerClientHandler->vSend_s_Audio_FG_BG_New(
				(tU8)TUNMSTR_SRCCHG_FOREGROUND, (tU8)TUNMSTR_SRCCHG_CHG_TO_FG, (tU8)TUNMSTR_SRCCHG_PTY_CHG_FGBG,u8Tun_State,0xFF );
		break;
	}
	case TUNMSTR_SRCCHG_SOURCE_DABPTY31:
	{
		m_u8Current_TASource = (tU8)TUNMSTR_SRCCHG_SOURCE_DABPTY31;
		m_potunmstr_DABClient_Handler->vSend_s_SlectAnno(TunMstr_AnnoActive_DABPTY, TRUE);
		vUpdateAnnoHandlingRequest(TRUE,(tU8)TUNMSTR_SRCCHG_SOURCE_DAB,(tU8)TUNMSTR_SRCCHG_ANNOTYPES_PTY31);
		m_potunmstr_MsgToHMI->vSend_g_Announcement_Status(TRUE, (tU8)TUNMSTR_SRCCHG_SOURCE_DAB, (tU8)TUNMSTR_SRCCHG_ANNOTYPES_PTY31);
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(m_potunmstr_AudioClientHandler->u8MapTunmstrSources((tU8)TUNMSTR_SRCCHG_SOURCE_DABPTY31), (tU8)TUNMSTR_SRCCHG_ACTION_ON);
#endif
		break;
	}
	case TUNMSTR_SRCCHG_SOURCE_DABOTHER:
	{
		tU8 u8AnnoType = m_potunmstr_SrcChg_AnnoHandler->u8GetTunmst_AnnoTypes((tU16)m_potunmstr_SrcChg_AnnoHandler->m_ActiveAnnoSrc);
		m_u8Current_TASource = (tU8)TUNMSTR_SRCCHG_SOURCE_DABOTHER;
		vUpdateAnnoHandlingRequest(TRUE,(tU8)TUNMSTR_SRCCHG_SOURCE_DAB,u8AnnoType);
		m_potunmstr_MsgToHMI->vSend_g_Announcement_Status(TRUE, (tU8)TUNMSTR_SRCCHG_SOURCE_DAB, u8AnnoType);
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(m_potunmstr_AudioClientHandler->u8MapTunmstrSources((tU8)TUNMSTR_SRCCHG_SOURCE_DABOTHER), (tU8)TUNMSTR_SRCCHG_ACTION_ON);
#endif
		break;
	}
	case TUNMSTR_SRCCHG_SOURCE_FMTA_INVALID:
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(m_potunmstr_AudioClientHandler->u8MapTunmstrSources((tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA),
								(tU8)TUNMSTR_SRCCHG_ACTION_ON);
#endif
		m_potunmstr_SrcChg_AnnoHandler->vSend_Src_Chg_Request((tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA,(tU8)TUNMSTR_SRCCHG_ACTION_OFF);

		break;
	}
	case TUNMSTR_SRCCHG_SOURCE_DABTA_INVALID:
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(m_potunmstr_AudioClientHandler->u8MapTunmstrSources((tU8)TUNMSTR_SRCCHG_SOURCE_DAB_TA),
								(tU8)TUNMSTR_SRCCHG_ACTION_ON);
#endif
		m_potunmstr_SrcChg_AnnoHandler->vSend_Src_Chg_Request((tU8)TUNMSTR_SRCCHG_SOURCE_DAB_TA,(tU8)TUNMSTR_SRCCHG_ACTION_OFF);

		break;
	}
	default:
		ETG_TRACE_USR4(("tunmstr_SrcChgManager::vHandleAnnoSrc_ON, inside default case"));
		break;
	}//end of Switch
	//vSetSourceInfo(u8Source);
	//update source value in member variables
	ETG_TRACE_USR4(("tunmstr_SrcChgManager::vHandleOtherSrcChg_ON"
			"TASource=%d TAAction=%d Source=%d",
			m_u8Current_TASource ,m_u8Current_TAAction, u8Source));

}//end of function

/*************************************************************************
 *  FUNCTION:    tVoid tunmstr_SrcChgManager::vHandleTASrc_PAUSE()
 *
 *  DESCRIPTION: Handler for FM_TA and DAB_TA to handle Pause state
 *  Use Cases: Phone call on TA, Zero Volume on TA
 *
 *  PARAMETER:   tU8 u8Source
 *
 *
 *  RETURNVALUE: None
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vHandleAnnoSrc_PAUSE(tU8 u8Source)
{
	if(
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			(m_potunmstr_AudioClientHandler == NULL)||
#endif
			(NULL==m_potunmstr_SrcChg_AnnoHandler))
	{
		NORMAL_M_ASSERT(m_potunmstr_AudioClientHandler != NULL);
		ETG_TRACE_USR4(("tunmstr_SrcChgManager::vHandleTASrc_PAUSE, ASSERT!!!!!!!!!!"));
		return;
	}
	m_u8Current_TAAction = (tU8)TUNMSTR_SRCCHG_ACTION_PAUSE;
	tU8 u8ActiveSource = m_potunmstr_SrcChg_AnnoHandler->u8ConvertCurrentAnnoSource(m_potunmstr_SrcChg_AnnoHandler->m_ActiveAnnoSrc);
	switch(u8ActiveSource)
	{
	case TUNMSTR_SRCCHG_SOURCE_FMPTY31:
	{
		m_u8Current_TASource = (tU8)TUNMSTR_SRCCHG_SOURCE_FMPTY31;
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(m_potunmstr_AudioClientHandler->u8MapTunmstrSources(u8Source), (tU8)TUNMSTR_SRCCHG_ACTION_PAUSE);
#endif

	}break;
	case TUNMSTR_SRCCHG_SOURCE_FM_TA:
	{
		m_u8Current_TASource = (tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA;
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(
		m_potunmstr_AudioClientHandler->u8MapTunmstrSources(u8Source), (tU8)TUNMSTR_SRCCHG_ACTION_PAUSE);
#endif

	}break;
	case TUNMSTR_SRCCHG_SOURCE_DAB_TA:
	{
		m_u8Current_TASource = (tU8)TUNMSTR_SRCCHG_SOURCE_DAB_TA;
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(
		m_potunmstr_AudioClientHandler->u8MapTunmstrSources(u8Source), (tU8)TUNMSTR_SRCCHG_ACTION_PAUSE);
#endif

	}break;
	case TUNMSTR_SRCCHG_SOURCE_DABPTY31:
	{
		m_u8Current_TASource = (tU8)TUNMSTR_SRCCHG_SOURCE_DABPTY31;
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(m_potunmstr_AudioClientHandler->u8MapTunmstrSources(u8Source), (tU8)TUNMSTR_SRCCHG_ACTION_PAUSE);
		ETG_TRACE_USR4(("tunmstr_SrcChgManager::vHandleAnnoSrc_PAUSE, DAB_PTY31 result sent to Audio LIB"));
#endif
		//send result to AUdio Lib

	}break;
	case TUNMSTR_SRCCHG_SOURCE_DABOTHER:
	{
		m_u8Current_TASource = (tU8)TUNMSTR_SRCCHG_SOURCE_DABOTHER;
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(m_potunmstr_AudioClientHandler->u8MapTunmstrSources(u8Source), (tU8)TUNMSTR_SRCCHG_ACTION_PAUSE);
		ETG_TRACE_USR4(("tunmstr_SrcChgManager::vHandleAnnoSrc_PAUSE, DAB_Other result sent to Audio LIB"));
#endif
		//send result to AUdio Lib

	}break;
	default :
		ETG_TRACE_USR4(("tunmstr_SrcChgManager::vHandleOtherSrcChg_OFF, inside default case"));
		break;
}//end of Switch
//vSetSourceInfo(u8Source);
//update source value in member variables
		ETG_TRACE_USR4(("tunmstr_SrcChgManager::vHandleOtherSrcChg_OFF"
				"TASource=%d TAAction=%d Source=%d",
				m_u8Current_TASource ,m_u8Current_TAAction, u8Source));
}//end of function
/*************************************************************************
 *  FUNCTION:    tVoid tunmstr_SrcChgManager::vHandleTASrc_OFF()
 *
 *  DESCRIPTION: THis function handle TA OFF case
 *  Use Case: All TA
 *
 *  PARAMETER:   tU8 u8Source
 *
 *
 *  RETURNVALUE: None
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vHandleAnnoSrc_OFF(tU8 u8Source)
{
	if ((m_potunmstr_TunerClientHandler == NULL) ||
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			(m_potunmstr_AudioClientHandler == NULL) ||
#endif
			(m_potunmstr_DABClient_Handler == NULL)||(m_potunmstr_MsgToHMI==NULL)||(m_potunmstr_SrcChg_AnnoHandler == NULL))
	{
		NORMAL_M_ASSERT(m_potunmstr_TunerClientHandler != NULL);
		NORMAL_M_ASSERT(m_potunmstr_AudioClientHandler != NULL);
		NORMAL_M_ASSERT(m_potunmstr_DABClient_Handler  != NULL);
		NORMAL_M_ASSERT(m_potunmstr_MsgToHMI  != NULL);
		NORMAL_M_ASSERT(m_potunmstr_SrcChg_AnnoHandler  != NULL);
		return;
	}
	m_u8Current_TAAction = (tU8)TUNMSTR_SRCCHG_ACTION_OFF;
	tU8 u8Tun_State = u8GetTunerState();
	switch(u8Source)
	{
	case TUNMSTR_SRCCHG_SOURCE_FM_TA:
	{
		m_u8Current_TASource = (tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA;
		m_potunmstr_SrcChg_AnnoHandler->vSetLastFMTA_ActiveStatus(TRUE) ;
		// Solution for NIKAI-3947
		enSrcActivty=FMTA_OFF;
		m_potunmstr_TunerClientHandler->vSend_s_Audio_FG_BG_New(
				(tU8)TUNMSTR_SRCCHG_FOREGROUND, (tU8)TUNMSTR_SRCCHG_CHG_TO_BG, (tU8)TUNMSTR_SRCCHG_TA_CHG_FGBG, u8Tun_State,0xFF );
		break;
	}
	case TUNMSTR_SRCCHG_SOURCE_FMPTY31:
	{
		m_u8Current_TASource = (tU8)TUNMSTR_SRCCHG_SOURCE_FMPTY31;
		m_potunmstr_SrcChg_AnnoHandler->vSetLastFMTA_ActiveStatus(TRUE) ;
		// Solution for NIKAI-3947
		enSrcActivty=FMTA_OFF;
		m_potunmstr_TunerClientHandler->vSend_s_Audio_FG_BG_New(
				(tU8)TUNMSTR_SRCCHG_FOREGROUND, (tU8)TUNMSTR_SRCCHG_CHG_TO_BG, (tU8)TUNMSTR_SRCCHG_PTY_CHG_FGBG,u8Tun_State,0xFF );
		break;
	}
	case TUNMSTR_SRCCHG_SOURCE_DAB_TA:
	case TUNMSTR_SRCCHG_SOURCE_DABPTY31:
	case 	TUNMSTR_SRCCHG_SOURCE_DABOTHER:
	{
		m_u8Current_TASource = u8Source;
		m_potunmstr_SrcChg_AnnoHandler->vSetLastFMTA_ActiveStatus(TRUE) ;
		/* When DAB is active, ARL sends DAB pause follwed by DAB TA play
		1. Update DAB status as Pause
		2. Send DAB TA to FG
		3  Once DAB TA Ends and ARL sends DAB TA stop , update the variable m_blDABTAEnded as True,
		so that when ARL send DAB Play,by check the flag m_blDABTAEnded and DAB state for Pause, DAB can be put to FG*/
		m_potunmstr_SrcChg_AnnoHandler->vSetDABTA_Ended(TRUE);

		tU8 u8AnnoType = m_potunmstr_SrcChg_AnnoHandler->u8GetTunmst_AnnoTypes((tU16)m_potunmstr_SrcChg_AnnoHandler->m_ActiveAnnoSrc);
		vUpdateAnnoHandlingRequest(FALSE,(tU8)TUNMSTR_SRCCHG_SOURCE_DAB,u8AnnoType);
		m_potunmstr_MsgToHMI->vSend_g_Announcement_Status(FALSE, (tU8)TUNMSTR_SRCCHG_SOURCE_DAB, u8AnnoType);
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(m_potunmstr_AudioClientHandler->u8MapTunmstrSources(u8Source),(tU8)TUNMSTR_SRCCHG_ACTION_OFF);
		m_potunmstr_AudioClientHandler->vHandleANNOSrcChg_Request((tU8)TUNMSTR_SRCCHG_SOURCE_DAB_TA, (tU8)TUNMSTR_SRCCHG_ACTION_OFF);
#endif
		//Soltion for NIKAI-3639

		m_u8Current_TASource = (tU8)TUNMSTR_SRCCHG_SOURCE_NO_TA;
		m_potunmstr_TunerClientHandler->vSetAnnoType((tU8)TUNMSTR_ANNOMSG_INVALID);
		m_potunmstr_SrcChg_AnnoHandler->vSetActiveAnnoSrc(TunMstr_AnnoActive_None);

		break;
	}
	case TUNMSTR_SRCCHG_SOURCE_FMTA_INVALID:
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(m_potunmstr_AudioClientHandler->u8MapTunmstrSources((tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA),
								(tU8)TUNMSTR_SRCCHG_ACTION_OFF);
#endif
		break;
	}
	case TUNMSTR_SRCCHG_SOURCE_DABTA_INVALID:
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(m_potunmstr_AudioClientHandler->u8MapTunmstrSources((tU8)TUNMSTR_SRCCHG_SOURCE_DAB_TA),
								(tU8)TUNMSTR_SRCCHG_ACTION_OFF);
#endif
		break;
	}
	
	default :
	{
		ETG_TRACE_USR4(("tunmstr_SrcChgManager::vHandleAnnoSrc_OFF, inside default case"));
		break;
	}
	}//end of Switch
	//update source value in member variables
	ETG_TRACE_USR4(("tunmstr_SrcChgManager::vHandleOtherSrcChg_OFF"
			"TASource=%d TAAction=%d Source=%02x",
			m_u8Current_TASource ,m_u8Current_TAAction,
			ETG_CENUM(enTunmstrSource,u8Source)));
}//end of function

/*************************************************************************
 *  FUNCTION:    tVoid tunmstr_SrcChgManager::vCheckForBandChange()
 *
 *  DESCRIPTION: Helper function to Handle Band Change
 *
 *  PARAMETER:   amt_tclServiceData* poMessage
 *
 *
 *  RETURNVALUE: None
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vCheckForBandChange(amt_tclServiceData* poMessage)
{
	if(( poMessage == NULL ) || (m_potunmstr_MsgToHMI == NULL) ||(m_potunmstr_TunerClientHandler == NULL) ||(NULL==m_potunmstr_SrcChg_AnnoHandler))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		NORMAL_M_ASSERT( m_potunmstr_TunerClientHandler != NULL );
		return;
	}
	if((m_blRemoteSession_Active == TRUE ) && ((m_u8CurrentTunerState == (tU8)TUNMSTR_SRCCHG_FOREGROUND)))
	{
        tU8 u8band = u8ConvertSrcToBand(u8GetCurrentSource());
		if(u8band == (tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA)
		{
			m_u8PreviousBand = (tU8)TUNMSTR_SRCCHG_SOURCE_TUN1FM;
		}//if TA is active source in FM
		else
		{
			m_u8PreviousBand = u8band;
		}// if either FM or AM is active source.

	}
	midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart oMsgData;
	//create an object of  FID_TUNMSTR_S_SOURCE_CHANGE
	vGetDataFromAmt(poMessage,oMsgData);
	tU8 u8Band = (tU8)oMsgData.Band.enType;
	/*	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG,
				ET_EN_T16 _ TUNMSTR_TRACE_SRCCHG_MANGR_BAND_CHANGE _
				ET_EN_T8 _ u8Band _
				ET_EN_DONE );*/


	switch (u8Band)
	{
	case TUNMSTR_SRCCHG_BAND_FM:
	{
		if(m_blTestMode == TRUE)
		{
			m_potunmstr_TunerClientHandler->vSend_s_ChangeBand(u8Band);
			m_blBandChangeFlag = TRUE;
		}
		ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG,
				ET_EN_T16 _ TUNMSTR_TRACE_BAND_CHANGE_REQUIRED _
				ET_EN_DONE );
		m_potunmstr_MsgToHMI -> vSend_g_SourceChange((tU8)TUNMSTR_SRCCHG_SOURCE_TUN1FM, (tU8)TUNMSTR_SRCCHG_ACTION_ON);
		break;
	}//case TUNMSTR_SRCCHG_BAND_FM
	case TUNMSTR_SRCCHG_BAND_AM:
	{
		if (m_blTestMode == TRUE)
		{
			m_potunmstr_TunerClientHandler->vSend_s_ChangeBand(TUNMSTR_SRCCHG_BAND_AM);
			m_blBandChangeFlag = TRUE;
		}
		ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG,
				ET_EN_T16 _ TUNMSTR_TRACE_BAND_CHANGE_REQUIRED _
				ET_EN_DONE );
		m_potunmstr_MsgToHMI->vSend_g_SourceChange((tU8)TUNMSTR_SRCCHG_SOURCE_TUN1AM, (tU8)TUNMSTR_SRCCHG_ACTION_ON);
		break;
	}//case TUNMSTR_SRCCHG_BAND_FM
	case TUNMSTR_SRCCHG_BAND_CB1:
   {
      if (m_blTestMode == TRUE)
      {
         m_potunmstr_TunerClientHandler->vSend_s_ChangeBand(TUNMSTR_SRCCHG_BAND_CB1);
         m_blBandChangeFlag = TRUE;
      }
      ETG_TRACE_USR4(("tunmstr_SrcChgManager::vCheckForBandChange :: Band change to DRM."));
      m_potunmstr_MsgToHMI->vSend_g_SourceChange((tU8)TUNMSTR_SRCCHG_SOURCE_DRM, (tU8)TUNMSTR_SRCCHG_ACTION_ON);
      break;
   }//case TUNMSTR_SRCCHG_BAND_CB1
	case TUNMSTR_SRCCHG_BAND_DAB:
		{

	ETG_TRACE_USR4(("tunmstr_SrcChgManager::vCheckForBandChange, DAB Band change requested"));
			m_potunmstr_MsgToHMI->vSend_g_SourceChange((tU8)TUNMSTR_SRCCHG_SOURCE_DAB,(tU8)TUNMSTR_SRCCHG_ACTION_ON);
			break;
		}//case TUNMSTR_SRCCHG_BAND_FM
		// Solution for NIKAI2-475. On HK _Radio press DAB source change comes as a Band hcange request.
	default:
		break;

	}// end of Switch

}// End of Function
/*************************************************************************
 *  FUNCTION:    tVoid tunmstr_SrcChgManager::vCheckForPreset_Recall()
 *
 *  DESCRIPTION: Helper function to Handle Band Change
 *
 *  PARAMETER:   amt_tclServiceData* poMessage
 *
 *
 *  RETURNVALUE: None
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vCheckForPreset_Recall(amt_tclServiceData* poMessage)
{
	if(( poMessage == NULL ) || (m_potunmstr_TunerClientHandler == NULL) || (m_potunmstr_DABClient_Handler == NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_TunerClientHandler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_DABClient_Handler != NULL );
		return;
	}
#if 0
	midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MIXED_PRESET_RECALLMethodStart oMsgData;
	//create an object of  FID_TUNMSTR_S_MIXED_PRESET_RECALL
	vGetDataFromAmt(poMessage,oMsgData);

	tU8 u8Element_ID = oMsgData.u8Element_ID;
	vSetElement_ID(u8Element_ID);
	tU8 u8Band =  (tU8)oMsgData.List.enType;
	if(TUNMSTR_SRCCHG_BAND_DAB == u8Band)
	{
		u8Band = (tU8)TUNMSTR_SRCCHG_SOURCE_DAB;
	}

	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, 
			ET_EN_T16 _ TUNMSTR_TRACE_MIXED_PRESET_RECALL _
			ET_EN_T8 _ u8Element_ID _
			ET_EN_T8 _ u8Band _
			ET_EN_DONE );

	if( (u8Band == TUNMSTR_SRCCHG_BAND_FM) || (u8Band == TUNMSTR_SRCCHG_BAND_AM))
	{
	//	m_potunmstr_TunerClientHandler->vSend_s_SelMixedPreset_ListElem(m_u8Element_ID);
		vSetPresetRecallStatus_Tuner(FALSE);
		ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG,
				ET_EN_T16 _ TUNMSTR_TRACE_SRCCHG_TUN_PRESET_RECALL _
				ET_EN_DONE );
	}
	else if ((tU8)TUNMSTR_SRCCHG_SOURCE_DAB == u8Band)
	{
		m_potunmstr_DABClient_Handler->vSend_s_Activate_Preset_List_Elem(m_u8Element_ID);
		vSetPresetRecallStatus_Tuner(FALSE);
		ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG,
				ET_EN_T16 _ TUNMSTR_TRACE_SRCCHG_DAB_PRESET_RECALL _
				ET_EN_DONE );

	}
#endif
	// update Preset Change Flag

}// end of Function
/*************************************************************************
 *  FUNCTION:    tVoid tunmstr_SrcChgManager::vCheckForVisibility()
 *
 *  DESCRIPTION: Helper function to Handle Visibility Info
 *
 *  PARAMETER:   amt_tclServiceData* poMessage
 *
 *
 *  RETURNVALUE: None
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vCheckForVisibility(amt_tclServiceData* /*poMessage*/)
{
#if 0
	if(( poMessage == NULL ) || (m_potunmstr_SrcChg_AnnoHandler == NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChg_AnnoHandler != NULL );
		return;
	}
	midw_tunermasterfi_tclMsgFID_TUNMSTR_S_VISIBILITYMethodStart oMsgData;
	//create an object of  FID_TUNMSTR_S_MIXED_PRESET_RECALL
	vGetDataFromAmt(poMessage,oMsgData);
	tBool blVisible = oMsgData.Visible;
	tU8 u8Source =  oMsgData.Source;
	if(TUNMSTR_SRCCHG_BAND_DAB == u8Source)
	{
		u8Source = (tU8)TUNMSTR_SRCCHG_SOURCE_DAB;
	}

	switch (u8Source)
	{
	case TUNMSTR_SRCCHG_SOURCE_TUN1FM:
	{
		break;
	}
	case TUNMSTR_SRCCHG_SOURCE_DAB:
	{
		m_blDABVisibleStatus = blVisible;
		//If DAB screen is visible and DAB TP is activated, than Enable TA icon 
		//else If FM TP is activated in BG than update FM TP state
		//Jira issue NIKAI2-779
		if((blVisible==TRUE)&& (m_potunmstr_SrcChg_AnnoHandler->blGetTPState_DAB() == TRUE))
		{
			ETG_TRACE_USR4(("tunmstr_SrcChgManager::vCheckForVisibility()->DAB is visible DAB TP is enabled"));
			m_potunmstr_MsgToHMI->vSend_g_TP_Status(m_potunmstr_SrcChg_AnnoHandler->blGetTPState_DAB(), (tU8)TUNMSTR_SRCCHG_SOURCE_DAB);
		}
		// to solve JIRA issue NIKAI-3964
		ETG_TRACE_USR4(("tunmstr_SrcChgManager::vCheckForVisibility, Update DAB Visible info"
				"blVisible=%d ",
				m_blDABVisibleStatus));
		break;
	}
	default:
		break;
	}//end of switch
#endif
}// end of Function
/*************************************************************************
 *  FUNCTION:    tVoid tunmstr_SrcChgManager::vHandleSrcChg_MethodResult_DAB()
 *
 *  DESCRIPTION: Helper function to Handle Band Change
 *
 *  PARAMETER:   amt_tclServiceData* poMessage
 *
 *
 *  RETURNVALUE: None
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vHandleSrcChg_MethodResult_DAB(tU8 u8Result)
{
	if(
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			(m_potunmstr_AudioClientHandler == NULL) ||
#endif
			(m_potunmstr_MsgToHMI == NULL) || (m_potunmstr_SrcChg_AnnoHandler == NULL))
	{
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
#endif
		NORMAL_M_ASSERT( m_potunmstr_SrcChg_AnnoHandler != NULL );
		return;
	}


	tBool blBandUpdateReq=FALSE;
	ETG_TRACE_USR1(("vHandleSrcChg_MethodResult_DAB()->"));
	ETG_TRACE_USR1(("vHandleSrcChg_MethodResult_DAB()->enSrcActivty=%02x",
			ETG_CENUM(enSourcendAction,enSrcActivty)));
	if((tU8)TUNMSTR_SRCCHG_DAB_RES_OK!=u8Result)

	{
		return;
	}
	switch(enSrcActivty)
	{
	case DAB_ON:
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(m_potunmstr_AudioClientHandler->u8MapTunmstrSources((tU8)TUNMSTR_SRCCHG_SOURCE_DAB), (tU8)TUNMSTR_SRCCHG_ACTION_ON);
#endif
		blBandUpdateReq=TRUE;
		break;
	}
	case DAB_OFF:
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(m_potunmstr_AudioClientHandler->u8MapTunmstrSources((tU8)TUNMSTR_SRCCHG_SOURCE_DAB), (tU8)TUNMSTR_SRCCHG_ACTION_OFF);
#endif
		blBandUpdateReq=TRUE;

		break;
	}
	case DAB_PAUSE:
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(m_potunmstr_AudioClientHandler->u8MapTunmstrSources((tU8)TUNMSTR_SRCCHG_SOURCE_DAB), (tU8)TUNMSTR_SRCCHG_ACTION_PAUSE);
#endif
		blBandUpdateReq=TRUE;

			break;
		}
		default:
		{
			break;
		}	
		// No need to udpate Band datapool for TA sources. to Solve JIRA issue NIKAI-1142
	}
	if(blBandUpdateReq)
	{
		ETG_TRACE_USR1(("tunmstr_SrcChgManager::vHandleSrcChg_MethodResult_DAB()->Update Band info "));
		vSendCurrentSource_Info(u8CheckRadioSource());
		enSrcActivty=NONE;
	}
}// end of Function
/*******************************************************************************
 *FUNCTION:    tunmstr_SrcChgManager::vGetDataFromAmt
 *
 *DESCRIPTION: This function converts Amt message to visitor class and
 *             get the data from visitor to the Fi class. Refer FI Manual.
 *             Doc.
 *
 *PARAMETER:
 *           poFiMsg   - Amt Message
 *           oFIData   - Base class of Fi class
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_SrcChgManager::vGetDataFromAmt(amt_tclServiceData* poFIMsg,
		fi_tclTypeBase&     oFIData )const
{
	// Create Visitor message object for incoming message
	fi_tclVisitorMessage oInVisitorMsg(poFIMsg);

	/* Get the data in FI class from Vistor class*/   
	if(OSAL_ERROR == oInVisitorMsg.s32GetData(oFIData,1))
	{
		// assert here 
		NORMAL_M_ASSERT_ALWAYS ();
	}
}
/*******************************************************************************
 *FUNCTION:    tunmstr_SrcChgManager::vMethodResult_SrcChg_FrmTuner
 *
 *DESCRIPTION: This function converts Amt message to visitor class and
 *             get the data from visitor to the Fi class. Refer FI Manual.
 *             Doc.
 *
 *PARAMETER:
 *           poFiMsg   - Amt Message
 *           oFIData   - Base class of Fi class
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_SrcChgManager::vMethodResult_SrcChg_FrmTuner(tU8 u8Status)
{
	tBool blUpdateRequired=FALSE;
    tU8 u8Source = u8GetCurrentSource();
	if((m_potunmstr_AudioClientHandler == NULL) || (m_potunmstr_MsgToHMI ==NULL)||(NULL==m_potunmstr_SrcChg_AnnoHandler))
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
#endif
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChg_AnnoHandler != NULL );
		return;
	}// end of assert

	ETG_TRACE_USR1(("tunmstr_SrcChgManager::vMethodResult_SrcChg_FrmTuner()->"
		"Source=%02x MethodResultStatus=%02x m_blBandChangeFlag=%d m_u8Current_TASource=%d",
	ETG_CENUM(enTunmstrSource,u8Source),
	ETG_CENUM(enTunmstr_Methodresult,u8Status),m_blBandChangeFlag,m_u8Current_TASource));
	ETG_TRACE_USR1(("vMethodResult_SrcChg_FrmTuner()->enSrcActivty=%02x",
	ETG_CENUM(enSourcendAction,enSrcActivty)));
	if (( ((tU8)TUNMSTR_SRCCHG_RES_REQ_SUCCEED !=u8Status )) ||\
		(((m_blBandChangeFlag == TRUE) && ((tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA!= m_u8Current_TASource))))
	{
		ETG_TRACE_USR4(("vMethodResult_SrcChg_FrmTuner -->Retunr from function "));
		return;
	}// end of if ((TUNMSTR_SRCCHG_RES_REQ_SUCCEED !=u8Status ))
	switch(enSrcActivty)
	{
	case FMTA_ON:
	case FMTA_PAUSE:
	case FMTA_OFF:
	{
		vHandleFMTAFGBGMethodResult();

		break;
	}
	case FM_ON:
	case FM_PAUSE:
	case AM_ON:
	case AM_PAUSE:
	case DRM_ON:
	case DRM_PAUSE:
	{
		if(m_u8CurrentTunerState == (tU8)TUNMSTR_SRCCHG_INPROGESS)
		{
			vSetTunerState((tU8)TUNMSTR_SRCCHG_FOREGROUND);
			blUpdateRequired=TRUE;
		}
		break;
	}
	case FM_OFF:
	case AM_OFF:
   case DRM_OFF:
	{
		if(m_u8CurrentTunerState == (tU8)TUNMSTR_SRCCHG_INPROGESS)
		{
			vSetTunerState((tU8)TUNMSTR_SRCCHG_BACKGROUND);
			blUpdateRequired=TRUE;
		}
		break;
	}
	default:
	{
		break;
	}
	}
	if(blUpdateRequired)
	{
		vSendCurrentSource_Info(u8Source);
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(
			m_potunmstr_AudioClientHandler->u8MapTunmstrSources(u8GetSourceFromenSourcendAction()), u8GetActionFromenSourcendAction());
#endif
		vInitializeErrHandlr_Timer(TUNERMASTER_STOP_TIMER);
		// Stop Timer on receiving Method result
	}//end of else if
	enSrcActivty=NONE;
	vHandleTunerStateInProgress(m_u8InProgSource,m_u8InProgSrcActivity);
	m_u8InProgSource = TUNMSTR_SRCCHG_INVALID;
	m_u8InProgSrcActivity = TUNMSTR_SRCCHG_INVALID;
	// update HMI data pools
}//end of function
/*******************************************************************************
 *FUNCTION:    tunmstr_SrcChgManager::vMethodResult_BandChg_FrmTuner
 *
 *DESCRIPTION: This function converts Amt message to visitor class and
 *             get the data from visitor to the Fi class. Refer FI Manual.
 *             Doc.
 *
 *PARAMETER:	tU8 u8Status
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_SrcChgManager::vMethodResult_BandChg_FrmTuner(tU8 u8Status)
{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	if(m_potunmstr_AudioClientHandler ==NULL)
	{
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
		return;
	}
#endif
    tU8 u8Source = u8GetCurrentSource();
	ETG_TRACE_USR1(("tunmstr_SrcChgManager::vMethodResult_BandChg_FrmTuner()->"
		"Source=%02x MethodResultStatus=%02x m_blBandChangeFlag=%d",
	ETG_CENUM(enTunmstrSource,u8Source),
	ETG_CENUM(enTunmstr_Methodresult,u8Status),m_blBandChangeFlag));
	ETG_TRACE_USR1(("tunmstr_SrcChgManager::vMethodResult_BandChg_FrmTuner()->enSrcActivty=%02x",
	ETG_CENUM(enSourcendAction,enSrcActivty)));
	if((((tU8)TUNMSTR_SRCCHG_RES_REQ_SUCCEED !=u8Status )||(m_blBandChangeFlag == FALSE))&&\
		(m_u8CurrentTunerState == (tU8)TUNMSTR_SRCCHG_INPROGESS))
	{
		ETG_TRACE_USR1(("tunmstr_SrcChgManager::vMethodResult_BandChg_FrmTuner, Result Failed or Band Change false "));
		return;
	}
	tBool blSendResulttoARL=FALSE;
	switch(enSrcActivty)
	{
		case FM_ON:
		case FM_PAUSE:
		case AM_ON:
		case AM_PAUSE:
      case DRM_ON:
      case DRM_PAUSE:
		{
			vSetTunerState((tU8)TUNMSTR_SRCCHG_FOREGROUND);
			blSendResulttoARL=TRUE;
			break;
		}	
		case FM_OFF:
		case AM_OFF:
      case DRM_OFF:
		{
			blSendResulttoARL=TRUE;
			break;
		}
		default:
		{
		ETG_TRACE_USR4(("tunmstr_SrcChgManager::vMethodResult_BandChg_FrmTuner, Default "));
		break;
		}
	};//end of switch
	if(blSendResulttoARL)
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(
		m_potunmstr_AudioClientHandler->u8MapTunmstrSources(u8GetSourceFromenSourcendAction()), u8GetActionFromenSourcendAction());
#endif
	}
	enSrcActivty=NONE;
	m_blBandChangeFlag = FALSE;
	vInitializeErrHandlr_Timer(TUNERMASTER_STOP_TIMER);
	//update Band change flaf after sending result
	vSendCurrentSource_Info(u8Source);
	//Update to HMI, so that data pools can be udpated
	vHandleTunerStateInProgress(m_u8InProgSource,m_u8InProgSrcActivity);
	m_u8InProgSource = TUNMSTR_SRCCHG_INVALID;
	m_u8InProgSrcActivity = TUNMSTR_SRCCHG_INVALID;
}//  end of function
/*******************************************************************************
 *FUNCTION:    tunmstr_SrcChgManager::vMethodResult_PresetRecall_FrmTuner
 *
 *DESCRIPTION: This function converts Amt message to visitor class and
 *             get the data from visitor to the Fi class. Refer FI Manual.
 *             Doc.
 *
 *PARAMETER:
 *           poFiMsg   - Amt Message
 *           oFIData   - Base class of Fi class
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_SrcChgManager::vMethodResult_PresetRecall_FrmTuner(tU8 u8Status) const
{
	if((tU8)TUNMSTR_SRCCHG_RES_REQ_SUCCEED == u8Status ) 
	{
		ETG_TRACE_USR4(("tunmstr_SrcChgManager::vMethodResult_PresetRecall_FrmTuner, Success "));
	}
	else 
	{
		ETG_TRACE_USR1(("tunmstr_SrcChgManager::vMethodResult_PresetRecall_FrmTuner, Fail "));
	}
}
/*******************************************************************************
 *FUNCTION:    vUpdateBand
 *
 *DESCRIPTION: with this function, currtent tuned band value is updated.
 *
 *PARAMETER:
 *           u8TA_Anno, u8Source
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_SrcChgManager::vUpdateBand(tU8 u8Band)
{
	if(m_potunmstr_MsgToHMI == NULL)
	{
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		return;
	}
	tU8 u8Temp = u8GetTunerState();
	if((tU8)TUNMSTR_SRCCHG_FOREGROUND == u8Temp)
	{
		if( TUNMSTR_SRCCHG_TUNER_BAND_FM == u8Band )
		{
			vSetSourceInfo(u8Band);
		}
		else if (TUNMSTR_SRCCHG_TUNER_BAND_AM == u8Band)
		{
			u8Band = TUNMSTR_SRCCHG_BAND_AM;
			// Convert value AM band as per Tuner master FI
			vSetSourceInfo(u8Band);
		}
		else
		{
			// Nothing
		}
	}
}
/*******************************************************************************
 *FUNCTION:    vSetSDSBand
 *
 *DESCRIPTION: with this function, currtent tuned band value is updated.
 *
 *PARAMETER:
 *           u8Band
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_SrcChgManager :: vSetSDSBand(const tU8 u8Band)
{
	m_u8SDS_Band = u8Band;
}
/*******************************************************************************
 *FUNCTION:    u8GetSDSBand
 *
 *DESCRIPTION: with this function, currtent tuned band value is updated.
 *
 *PARAMETER:
 *           None
 *
 *RETURNVALUE: m_u8SDS_Band
 ********************************************************************************/
tU8 tunmstr_SrcChgManager :: u8GetSDSBand()const
{
	return m_u8SDS_Band;
}
/*******************************************************************************
 *FUNCTION:    vSetDirectFrqRequest_Status
 *
 *DESCRIPTION: If SDS requests for FRQ Chg, this flag is updated
 *
 *PARAMETER:
 *           blStatus
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_SrcChgManager ::vSetDirectFrqRequest_Status(const tBool blStatus)
{
	m_blFrq_Requested = blStatus;
}
/*******************************************************************************
 *FUNCTION:    blGetDirectFrqRequest_Status
 *
 *DESCRIPTION: m_blFrq_Requested falg value is returned
 *
 *PARAMETER:
 *           None
 *
 *RETURNVALUE: m_blFrq_Requested
 ********************************************************************************/
tBool tunmstr_SrcChgManager ::blGetDirectFrqRequest_Status()const
{
	return m_blFrq_Requested;

}
/*******************************************************************************
 *FUNCTION:    vSetDirectFrqRequest_Status
 *
 *DESCRIPTION: If Audio places any Band hcange request this flag is set
 *
 *PARAMETER:
 *           blStatus
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_SrcChgManager ::vSetBandChgSDS_status(const tBool blStatus)
{
	m_blBandChg_Requested = blStatus;

}
/*******************************************************************************
 *FUNCTION:    blGetDirectFrqRequest_Status
 *
 *DESCRIPTION: m_blBandChg_Requested falg value is returned
 *
 *PARAMETER:
 *           None
 *
 *RETURNVALUE: m_blFrq_Requested
 ********************************************************************************/
tBool tunmstr_SrcChgManager ::blGetBandChgSDS_status()const
{
	return m_blBandChg_Requested;

}
/*******************************************************************************
 *FUNCTION:    u8GetCurrentTA_Source
 *
 *DESCRIPTION: m_blBandChg_Requested falg value is returned
 *
 *PARAMETER:	None
 *
 *RETURNVALUE: m_blFrq_Requested
 ********************************************************************************/
tU8 tunmstr_SrcChgManager::u8GetCurrentTA_Source()const
{
	return m_u8Current_TASource;

}
/*******************************************************************************
 *FUNCTION:    blGetTestMode_Status
 *
 *DESCRIPTION: m_blBandChg_Requested falg value is returned
 *
 *PARAMETER:	None
 *
 *RETURNVALUE: m_blFrq_Requested
 ********************************************************************************/
tU8 tunmstr_SrcChgManager::blGetTestMode_Status()const
{
	return m_blTestMode;
}
/*******************************************************************************
 *FUNCTION:    vTestMode
 *
 *PARAMETER:    poMessage
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_SrcChgManager::vTestMode(amt_tclServiceData* poMessage)
{
	midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart oMsgData;
	vGetDataFromAmt(poMessage,oMsgData);
	m_blTestMode = oMsgData.TestModeActive;
	ETG_TRACE_USR1(("tunmstr_SrcChgManager::vTestMode()TestModeActive=%d",m_blTestMode));
}
/*******************************************************************************
 *FUNCTION:    vTestMode_SrcChg
 *
 *PARAMETER:    poMessage
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_SrcChgManager::vTestMode_SrcChg(amt_tclServiceData* poMessage)
{
	if((m_potunmstr_MsgToHMI ==NULL) || (m_potunmstr_TunerClientHandler == NULL))
	{
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		NORMAL_M_ASSERT( m_potunmstr_TunerClientHandler != NULL );
		return;
	}
	midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart oMsgData;
	vGetDataFromAmt(poMessage,oMsgData);
	switch(oMsgData.WhichTuner.enType)
	{
	case midw_fi_tcl_e8_WhichTuner::FI_EN_TUN_MSTR_TUNER_0:
	{
		m_potunmstr_TunerClientHandler->vSend_s_Audio_FG_BG_New((tU8)TUNMSTR_SRCCHG_FOREGROUND, (tU8)TUNMSTR_SRCCHG_CHG_TO_FG,\
			(tU8)TUNMSTR_SRCCHG_USR1_CHG_FGBG, (tU8)TUNMSTR_SRCCHG_FOREGROUND, (tU8)TUNMSTR_SRCCHG_TUNER0);
	}break;
	case midw_fi_tcl_e8_WhichTuner::FI_EN_TUN_MSTR_TUNER_1:
	{
		m_potunmstr_TunerClientHandler->vSend_s_Audio_FG_BG_New((tU8)TUNMSTR_SRCCHG_FOREGROUND, (tU8)TUNMSTR_SRCCHG_CHG_TO_FG,\
			(tU8)TUNMSTR_SRCCHG_USR1_CHG_FGBG, (tU8)TUNMSTR_SRCCHG_FOREGROUND, (tU8)TUNMSTR_SRCCHG_TUNER1);
	}break;
	case midw_fi_tcl_e8_WhichTuner::FI_EN_TUN_MSTR_TUNER_2:
	{
		m_potunmstr_TunerClientHandler->vSend_s_Audio_FG_BG_New((tU8)TUNMSTR_SRCCHG_FOREGROUND, (tU8)TUNMSTR_SRCCHG_CHG_TO_FG,\
			(tU8)TUNMSTR_SRCCHG_USR1_CHG_FGBG, (tU8)TUNMSTR_SRCCHG_FOREGROUND, (tU8)TUNMSTR_SRCCHG_TUNER2);
	}break;
	case midw_fi_tcl_e8_WhichTuner::FI_EN_TUN_MSTR_TUNER_3:
	{
		m_potunmstr_TunerClientHandler->vSend_s_Audio_FG_BG_New((tU8)TUNMSTR_SRCCHG_FOREGROUND, (tU8)TUNMSTR_SRCCHG_CHG_TO_FG,\
			(tU8)TUNMSTR_SRCCHG_USR1_CHG_FGBG, (tU8)TUNMSTR_SRCCHG_FOREGROUND, (tU8)TUNMSTR_SRCCHG_TUNER3);
	}break;
	case midw_fi_tcl_e8_WhichTuner::FI_EN_TUN_MSTR_AUTO_MODE:
	{
		m_potunmstr_TunerClientHandler->vSend_s_Audio_FG_BG_New((tU8)TUNMSTR_SRCCHG_FOREGROUND, (tU8)TUNMSTR_SRCCHG_CHG_TO_FG,\
			(tU8)TUNMSTR_SRCCHG_USR1_CHG_FGBG, (tU8)TUNMSTR_SRCCHG_FOREGROUND, (tU8)TUNMSTR_SRCCHG_AUTO);
	}break;
	default:
		break;
	};//end of switch case
}
/*******************************************************************************
 *FUNCTION:    vHandleTunerON_FG
 *
 *DESCRIPTION: IF tuner is in FG, will check if band change is required.
 *			   If there is need for band change this trigger will be sent to fc_amfmtuenr, else result will be sent to LIB
 *			   Handles use cases like, Normal Band Change with HK_Press, Band change via SWC, SDS
 *PARAMETER:    tU8 u8Source
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_SrcChgManager::vHandleTuner_ON_FG(tU8 u8RequestedSource)
{
	if(
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			(m_potunmstr_AudioClientHandler == NULL) ||
#endif
			(m_potunmstr_TunerClientHandler == NULL))
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT(m_potunmstr_AudioClientHandler);
#endif
		NORMAL_M_ASSERT(m_potunmstr_TunerClientHandler);
		return;
	}
    tU8 u8CurrentSource = u8GetCurrentSource();
	ETG_TRACE_USR1(("tunmstr_SrcChgManager::vHandleTuner_ON_FG()Band=%02x Source=%02x",
    ETG_CENUM(enTunmstrSource,u8CurrentSource),
    ETG_CENUM(enTunmstrSource,u8RequestedSource)));
    enSrcActivty = enConvertSrcForON(u8RequestedSource);

    if (u8RequestedSource == TUNMSTR_SRCCHG_SOURCE_DRM)
    {
        m_potunmstr_TunerClientHandler->vSend_s_DRMSourceActivity(enConvertDRMSrcActValue(enSrcActivty));
    }

    if(u8RequestedSource == u8CurrentSource)
    {
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
        m_potunmstr_AudioClientHandler->vSendResult_ToLib(
        m_potunmstr_AudioClientHandler->u8MapTunmstrSources(u8RequestedSource) ,(tU8)TUNMSTR_SRCCHG_ACTION_ON);
#endif
        //Tuner is in FG with same band, hence send result to audio
    }
    else
    {        
        m_potunmstr_TunerClientHandler->vSend_s_ChangeBand(u8ConvertSrcToBand(u8RequestedSource));
        vInitializeErrHandlr_Timer(TUNERMASTER_ERRHANDLR_TIMER);
        vSetTunerState((tU8)TUNMSTR_SRCCHG_INPROGESS);
        m_blBandChangeFlag = TRUE;
        //Send command for band change
    }
	ETG_TRACE_USR1(("tunmstr_SrcChgManager::vHandleTuner_ON_FG()->enSrcActivty=%02x",
	ETG_CENUM(enSourcendAction,enSrcActivty)));
}//end of function
/*******************************************************************************
 *FUNCTION:    vHandleTunerON_BG
 *
 *DESCRIPTION: If current tuner state in BG and Source on request from ARL 
			   Along with that we would also check for Band change required 
			   and send trigger for band change if nesessary.
			   Use cases covered:Normal source change, Band change when RVC, SWC Soucre change, SDS Src change
 *PARAMETER:   u8Source
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_SrcChgManager::vHandleTuner_ON_BG(tU8 u8RequestedSource)
{
	if((m_potunmstr_TunerClientHandler == NULL))
	{
		NORMAL_M_ASSERT(m_potunmstr_TunerClientHandler);
		return;
	}
    tU8 u8CurrentSource = u8GetCurrentSource();
    ETG_TRACE_USR1(("tunmstr_SrcChgManager::vHandleTuner_ON_BG()u8CurrentSource=%02x u8RequestedSource=%02x",
    ETG_CENUM(enTunmstrSource,u8CurrentSource),
    ETG_CENUM(enTunmstrSource,u8RequestedSource)));
    enSrcActivty = enConvertSrcForON(u8RequestedSource);
    //send tuner to FG with requested source
    vSendTunerToFG(u8RequestedSource, enSrcActivty);
    if(u8RequestedSource != u8CurrentSource)
    {
        m_potunmstr_TunerClientHandler->vSend_s_ChangeBand(u8ConvertSrcToBand(u8RequestedSource));
        m_blBandChangeFlag = TRUE;
        //Send command for band change
    }
	ETG_TRACE_USR1(("tunmstr_SrcChgManager::vHandleTuner_ON_BG()->enSrcActivty=%02x",
	ETG_CENUM(enSourcendAction,enSrcActivty)));
}//end of function
/*******************************************************************************
 *FUNCTION:    vHandleTunerStateInProgress
 *
 *DESCRIPTION: When tunerstate is in Progess, 
			   the reguested source On will be handled once the Tunerstate becomes BG/FG
 *             
 *PARAMETER:    u8Source
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_SrcChgManager::vHandleTunerStateInProgress(tU8 u8Source,tU8 u8SrcActivity)
{
	ETG_TRACE_USR4(("Entered into vHandleTunerStateInProgress()"));
	if(m_u8CurrentTunerState == (tU8)TUNMSTR_SRCCHG_INPROGESS)
	{
		ETG_TRACE_USR1(("vHandleTunerStateInProgress()->Tuner state is in Inprogess"));
		vSetInprogmemberVariables(u8Source,u8SrcActivity);
	}
	else
	{
		switch(u8SrcActivity)
		{
		case (tU8)TUNMSTR_SRCCHG_ACTION_ON:
			{
			vHandleTunerSrcChg_ON(u8Source);
			break;
			}
		case (tU8)TUNMSTR_SRCCHG_ACTION_PAUSE:
			{
			vHandleTunerSrcChg_PAUSE(u8Source);
			break;
			}
		case (tU8)TUNMSTR_SRCCHG_ACTION_OFF:
			{
			vHandleTunerSrcChg_OFF(u8Source);
			break;
			}
		case (tU8)TUNMSTR_SRCCHG_INVALID:
		default:
		{
			ETG_TRACE_USR1(("tunmstr_SrcChgManager::vHandleTunerStateInProgress()->Default case"));
			break;
		}
		}
	}
}

/*******************************************************************************
 *FUNCTION:    vHandleDABStateInProgress
 *
 *DESCRIPTION: When DABstate is in Progess,
			   the reguested source On will be handled once the Tunerstate becomes BG/FG
 *
 *PARAMETER:    u8Source
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_SrcChgManager::vHandleDABStateInProgress(tU8 u8Source,tU8 u8SrcActivity)
{
	ETG_TRACE_USR4(("Entered into vHandleDABStateInProgress()"));
	if(u8GetDABState() == (tU8)TUNMSTR_SRCCHG_INPROGESS)
	{
		ETG_TRACE_USR1(("vHandleDABStateInProgress()->DAB state is in Inprogess"));
		vSetInprogDABmemberVariables(u8Source,u8SrcActivity);
	}
	else
	{
		switch(u8SrcActivity)
		{
		case (tU8)TUNMSTR_SRCCHG_ACTION_ON:
			{
			vHandleDABSrcChg_ON(u8Source);
			break;
			}
		case (tU8)TUNMSTR_SRCCHG_ACTION_PAUSE:
			{
			vHandleDABSrcChg_PAUSE(u8Source);
			break;
			}
		case (tU8)TUNMSTR_SRCCHG_ACTION_OFF:
			{
			vHandleDABSrcChg_OFF(u8Source);
			break;
			}
		case (tU8)TUNMSTR_SRCCHG_INVALID:
		default:
		{
			ETG_TRACE_USR1(("tunmstr_SrcChgManager::vHandleDABStateInProgress()->Default case"));
			break;
		}
		}
	}
}

/*******************************************************************************
 *FUNCTION:    u8CheckRadioSource
 *
 *DESCRIPTION: returns current state of Radio, FG/BG
 *
 *PARAMETER:   None
 *
 *RETURNVALUE: None
 ********************************************************************************/
tU8 tunmstr_SrcChgManager::u8CheckRadioSource()
{
	ETG_TRACE_USR1(("tunmstr_SrcChgManager::u8CheckRadioSource()TunerState=%02x DABState=%02x",
	ETG_CENUM(enTunmstrTunerState,m_u8CurrentTunerState),
	ETG_CENUM(enTunmstrTunerState,m_u8DABState)));
	
	if(((tU8)TUNMSTR_SRCCHG_FOREGROUND==m_u8CurrentTunerState)||((tU8)TUNMSTR_SRCCHG_FOREGROUND==m_u8DABState)||\
		((tU8)TUNMSTR_SRCCHG_DAB_PAUSE_STATE==m_u8DABState))
	{
		//Source value need not to be set to NON-RADIO
	}
	else if((TUNMSTR_SRCCHG_INVALID==m_u8DABState)||(TUNMSTR_SRCCHG_INVALID==m_u8CurrentTunerState)||\
	((tU8)TUNMSTR_SRCCHG_BACKGROUND==m_u8DABState)||(TUNMSTR_SRCCHG_INVALID==m_u8CurrentTunerState))
	{
		m_u8ActiveSource=(tU8)TUNMSTR_SRCCHG_SOURCE_NON_RADIO;
		ETG_TRACE_USR4(("tunmstr_SrcChgManager::vSetRadioSource()->Source value set to NON-RADIO"));
		//during start up when both variabels are init to default values
	}
	else
	{
		ETG_TRACE_USR4(("tunmstr_SrcChgManager::vSetRadioSource()->Source value need not to be set to NON-RADIO"));
		// default state no change
	}
	return (m_u8ActiveSource);
}
/*************************************************************************
 *  FUNCTION:    tVoid tunmstr_SrcChgManager::vCheckforFrequencyChange()
 *
 *  DESCRIPTION: Helper function to Handle direct frequency input via SDS
 *					1)Tuner will be sent to FG if its in BG
 *					2)Direct frequency value will be forwared
 *					3)IF current active band and request band are different then,
					 send band change request to fc_amfmtuner
 *  PARAMETER:   amt_tclServiceData* poMessage
 *  RETURNVALUE: None
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vCheckforFrequencyChange(amt_tclServiceData* poMessage)
{
	if(( poMessage == NULL ) || (m_potunmstr_MsgToHMI == NULL) ||(m_potunmstr_TunerClientHandler == NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		NORMAL_M_ASSERT( m_potunmstr_TunerClientHandler != NULL );
		return;
	}
	midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart oMsgData;
	//create an object of  FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUT
	vGetDataFromAmt(poMessage,oMsgData);
	tU8  u8Band  = (tU8)oMsgData.Band.enType;
	tU32 u32Frequency = oMsgData.Frequency;
/*	ETG_TRACE_USR4(("vCheckforFrequencyChange Frequency=%d, Band=%02x",
			u32Frequency,ETG_CENUM(midw_fi_tcl_e8_Band,oMsgData.Band.enType))); */
	// send tuenr to FG if its in BG
	if(m_u8CurrentTunerState == (tU8)TUNMSTR_SRCCHG_BACKGROUND)
	{
		m_potunmstr_TunerClientHandler->vSend_s_Audio_FG_BG_New(
				(tU8)TUNMSTR_SRCCHG_FOREGROUND, (tU8)TUNMSTR_SRCCHG_CHG_TO_FG, (tU8)TUNMSTR_SRCCHG_USR1_CHG_FGBG,\
				(tU8)TUNMSTR_SRCCHG_BACKGROUND, (tU8)TUNMSTR_SRCCHG_INVALID);
		vSetTunerState((tU8)TUNMSTR_SRCCHG_FOREGROUND);
		// send tuner to FG
	}
	//Direct frequency value will be forwared
	m_potunmstr_TunerClientHandler->vSend_s_DirectFrq_input(u32Frequency,u8Band);
	// send Frequency change command
	vSetDirectFrqRequest_Status(TRUE);
	// update SDS band value
	ETG_TRACE_USR4(("tunmstr_SrcChgManager::vCheckforFrequencyChange"
			"Frequency=%d, Band=%d",
			u32Frequency,u8Band));
}// End of Function
/*************************************************************************
 *  FUNCTION:    tVoid tunmstr_SrcChgManager::vSetInprogmemberVariables()
 *
 *  DESCRIPTION: This function will update the member variable m_u8InProgSource,m_u8InProgSrcActivity
 *
 *  PARAMETER:   tBool blInProgState,tU8 u8Source,tU8 u8SrcActivity
 *
 *  RETURNVALUE: tVoid
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vSetInprogmemberVariables(tU8 u8Source,tU8 u8SrcActivity)
{
	m_u8InProgSource=u8Source;
	m_u8InProgSrcActivity=u8SrcActivity;
	ETG_TRACE_USR1(("tunmstr_SrcChgManager::vSetInprogmemberVariables()InProgSrcActivity=%02x InProgSrcActivity=%02x",
	ETG_CENUM(enTunmstrAction,m_u8InProgSrcActivity),
	ETG_CENUM(enTunmstrSource,u8Source)));
}

/*************************************************************************
 *  FUNCTION:    tVoid tunmstr_SrcChgManager::vSetInprogDABmemberVariables()
 *
 *  DESCRIPTION: This function will update the member variable m_u8InProgSource,m_u8InProgSrcActivity
 *
 *  PARAMETER:   tBool blInProgState,tU8 u8Source,tU8 u8SrcActivity
 *
 *  RETURNVALUE: tVoid
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vSetInprogDABmemberVariables(tU8 u8Source,tU8 u8SrcActivity)
{
	m_u8InProgDABSource=u8Source;
	m_u8InProgDABSrcActivity=u8SrcActivity;
	ETG_TRACE_USR1(("tunmstr_SrcChgManager::vSetInprogDABmemberVariables()InProgSrcActivity=%02x InProgSrcActivity=%02x",
	ETG_CENUM(enTunmstrAction,m_u8InProgDABSrcActivity),
	ETG_CENUM(enTunmstrSource,u8Source)));
}

/*************************************************************************
 * FUNCTION:     vTimeOut_Responce_TimerCallBack( )
 *
 * DESCRIPTION:  Call back function for timer expire, on timer expire follwoing actions are performed.
 * 					1.Timer active flag is cleared.
 * 					2. New request from ARL is sent to Tuner
 * PARAMETER:    tVoid *pArg
 *
 * RETURNVALUE:   OSAL_tpfCallback
 *************************************************************************/
OSAL_tpfCallback tunmstr_SrcChgManager::vTimeOut_Responce_TimerCallBack( tVoid *pArg)
{
	// Validate the incoming pointer
	if  (NULL == pArg )
	{
		OSAL_vAssert(FALSE);
	}
	tunmstr_SrcChgManager*   potunmaster_SrcChgManager;
	potunmaster_SrcChgManager = (tunmstr_SrcChgManager*) pArg;
	ETG_TRACE_USR1(("vTimeOut_Responce_TimerCallBack"));
	if(NULL!=potunmaster_SrcChgManager)
	{
		potunmaster_SrcChgManager->m_u8CurrentTunerState=TUNMSTR_SRCCHG_INVALID;
		potunmaster_SrcChgManager->vHandleTunerStateInProgress(potunmaster_SrcChgManager->m_u8InProgSource,\
		potunmaster_SrcChgManager->m_u8InProgSrcActivity);
		potunmaster_SrcChgManager->m_u8InProgSource = TUNMSTR_SRCCHG_INVALID;
		potunmaster_SrcChgManager->m_u8InProgSrcActivity = TUNMSTR_SRCCHG_INVALID;
	}
	return FALSE;
}
/*************************************************************************
 * FUNCTION:     tunmstr_SrcChgManager::vInitializeErrHandlr_Timer( )
 *
 * DESCRIPTION:  Set time out value for the timer to send TMC info
 *
 * PARAMETER:    -
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vInitializeErrHandlr_Timer( tU32 u32TimerValue )const
{
	if(_hSysErrorHandelr_Timer != OSAL_C_INVALID_HANDLE)
	{
		(tVoid)OSAL_s32TimerSetTime( _hSysErrorHandelr_Timer, (OSAL_tMSecond)u32TimerValue, (OSAL_tMSecond)0 );
		ETG_TRACE_USR4(("tunmstr_SrcChgManager::vInitializeErrHandlr_Timer ->"
				"TinerValue %d", u32TimerValue));
	}
	else
	{
		ETG_TRACE_ERR(("tunmstr_SrcChgManager::vInitializeErrHandlr_Timer -> timer handler is correpted"));
	}
}// end of function
/*******************************************************************************
 *FUNCTION:    tunmstr_SrcChgManager::vCreateTimer
 *
 *DESCRIPTION:  Creats 25 sec timer required for Tuner error handling
 *
 *PARAMETER:
 *           poFiMsg   - Amt Message
 *           oFIData   - Base class of Fi class
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_SrcChgManager::vCreateTimer()
{

	tS32 s32OsalError = OSAL_s32TimerCreate( ( OSAL_tpfCallback )vTimeOut_Responce_TimerCallBack,
			( tPVoid )this, &_hSysErrorHandelr_Timer );
	if( s32OsalError == OSAL_ERROR )
	{
		NORMAL_M_ASSERT( s32OsalError != OSAL_ERROR );
		_hSysErrorHandelr_Timer  = OSAL_C_INVALID_HANDLE;
	}
	else
	{
		ETG_TRACE_USR4(("tunmstr_SrcChgManager::vCreateTimer  timer created"));
		m_blErrHandlr_TmrCreated =  TRUE;
	}
	//vInitializeErrHandlr_Timer(TUNERMASTER_ERRHANDLR_TIMER, TRUE);
}// end of if(DIA_KDS_TMC_XM != u32TMCServer )

/*******************************************************************************
 *FUNCTION:    tunmstr_SrcChgManager::vDeleteTimer
 *
 *DESCRIPTION:  Delete 25 sec timer required for Tuner error handling
 *
 *PARAMETER:
 *           poFiMsg   - Amt Message
 *           oFIData   - Base class of Fi class
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_SrcChgManager::vDeleteTimer()
{
	if(OSAL_C_INVALID_HANDLE != _hSysErrorHandelr_Timer)
	{
		tS32 retFlag = OSAL_s32TimerDelete(_hSysErrorHandelr_Timer);
		_hSysErrorHandelr_Timer = OSAL_C_INVALID_HANDLE;

		if( retFlag == OSAL_ERROR )
		{
			ETG_TRACE_ERR(("tunmstr_SrcChgManager::Tuner Responce  timer is not deleted"));
		}
		else
		{
			ETG_TRACE_USR4(("Tuner Responce timer is deleted"));
		}
		m_blErrHandlr_TmrCreated = FALSE;
	}
}// end of if(DIA_KDS_TMC_XM != u32TMCServer )

/*************************************************************************
 * FUNCTION:     tunmstr_SrcChgManager::vHandleTunerServiceUnavil( )
 *
 * DESCRIPTION:  Follwing operations are performed when Tuner service is unavil.
 * Delete Error Handler timer and related flags
 * Send Pending Result to ARL
 * Check if Nesting commands exist, if so clear them.
 *
 * PARAMETER:    -None
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vClearRadioStates()
{
	if(
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			(m_potunmstr_AudioClientHandler==NULL)||
#endif
			(m_potunmstr_SrcChg_AnnoHandler == NULL))
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
#endif
		NORMAL_M_ASSERT( m_potunmstr_SrcChg_AnnoHandler != NULL );
		return;
	}
	tBool blAnnoActive = m_potunmstr_SrcChg_AnnoHandler->blGetTA_Anno_Status();
	ETG_TRACE_USR1((" tunmstr_SrcChgManager::vClearRadioStates -> "
		"m_blTA_Anno_Active=%d m_u8Current_TASource=%d m_u8CurrentTunerState=%d",\
			blAnnoActive,m_u8Current_TASource,m_u8CurrentTunerState));
	vInitializeErrHandlr_Timer(TUNERMASTER_STOP_TIMER);
	if(blAnnoActive == TRUE)
	{
		vStoreSource_FMTAActive();
	}
	else if(((m_u8TunAudibaleStatus == (tU8)TUNMSTR_SRCCHG_ACTION_ON) ||(m_u8TunAudibaleStatus == (tU8)TUNMSTR_SRCCHG_ACTION_PAUSE)) \
	&&((m_u8ActiveSource == (tU8)TUNMSTR_SRCCHG_SOURCE_TUN1FM) ||(m_u8ActiveSource == (tU8)TUNMSTR_SRCCHG_SOURCE_TUN1AM)))
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
				m_potunmstr_AudioClientHandler->vSetSrcActivity_ServiceUnavail(m_u8TunAudibaleStatus);
				m_potunmstr_AudioClientHandler->vSetSrcReq_ServiceUnavail(m_u8ActiveSource);
#endif
				m_u8ActiveSource = (tU8)TUNMSTR_SRCCHG_SOURCE_NON_RADIO;
				// Changes done to Solve JIRA issue NIKAI2-1120
	}
	m_u8InProgSource = TUNMSTR_SRCCHG_INVALID;
	m_u8InProgSrcActivity = TUNMSTR_SRCCHG_INVALID;
	m_u8TunAudibaleStatus = TUNMSTR_SRCCHG_INVALID;
	m_u8CurrentTunerState = TUNMSTR_SRCCHG_INVALID;
	m_blBandChangeFlag=FALSE;
	// Initialise Tuner state variables.
}
/*************************************************************************
 * FUNCTION:     tunmstr_SrcChgManager::vClearDABStates( )
 *
 * DESCRIPTION:  Follwing operations are performed when DAB service is unavil.
 *
 * PARAMETER:    -None
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vClearDABStates()
{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	if((m_potunmstr_AudioClientHandler==NULL)|| (m_potunmstr_SrcChg_AnnoHandler == NULL))
	{
		NORMAL_M_ASSERT( m_potunmstr_AudioClientHandler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChg_AnnoHandler != NULL );
		return;
	}

	tBool blAnnoActive = m_potunmstr_SrcChg_AnnoHandler->blGetTA_Anno_Status();
	tBool blDABTP_State = m_potunmstr_SrcChg_AnnoHandler->blGetTPState_DAB();
	ETG_TRACE_USR1(("tunmstr_SrcChgManager::m_blTA_Anno_Active=%d m_u8Current_TASource=%d m_u8CurrentTunerState=%d m_blTPState_DAB=%d "
		"m_u8DABState=%d",\
			blAnnoActive,m_u8Current_TASource,m_u8CurrentTunerState,blDABTP_State,m_u8DABState));
	if(((m_u8DABAudibaleStatus == (tU8)TUNMSTR_SRCCHG_ACTION_ON) ||(m_u8DABAudibaleStatus == (tU8)TUNMSTR_SRCCHG_ACTION_PAUSE))\
			&&((m_u8ActiveSource ==(tU8)TUNMSTR_SRCCHG_SOURCE_DAB )))
	{
				m_potunmstr_AudioClientHandler->vSetSrcActivity_ServiceUnavail(m_u8DABAudibaleStatus);
				m_potunmstr_AudioClientHandler->vSetSrcReq_ServiceUnavail(m_u8ActiveSource);
				m_u8ActiveSource = (tU8)TUNMSTR_SRCCHG_SOURCE_NON_RADIO;
				ETG_TRACE_USR4(("vClearDABStates()->Source and Action value stored"));
				// Changes done to Solve JIRA issue NIKAI2-1120
	}
	if(blAnnoActive == TRUE)
	{
		vStoreSource_DABTAActive();
	}
	m_u8DABAudibaleStatus = TUNMSTR_SRCCHG_INVALID;
	m_u8DABState = TUNMSTR_SRCCHG_INVALID;
#endif
}
/*************************************************************************
 * FUNCTION:     tunmstr_SrcChgManager::enConvertSourcetoEnumSource( )
 *
 * DESCRIPTION:  Converts the u8source to corresponding enSourcendAction
 *
 * PARAMETER:    tU8 u8Source
 *
 * RETURNVALUE:  enSourcendAction
 *************************************************************************/
enSourcendAction tunmstr_SrcChgManager::enConvertSrcForOFF(tU8 u8Source)const
{
	enSourcendAction enSource=NONE;
	switch(u8Source)
	{
	case TUNMSTR_SRCCHG_SOURCE_TUN1FM:
		{
			enSource=FM_OFF;
			break;
		}
	case TUNMSTR_SRCCHG_SOURCE_TUN1AM:
		{
			enSource=AM_OFF;
			break;
		}
   case TUNMSTR_SRCCHG_SOURCE_DRM:
      {
            enSource=DRM_OFF;
            break;
      }
	case TUNMSTR_SRCCHG_SOURCE_DAB:
     {
         enSource=DAB_OFF;
         break;
     }
	default:
		{
			break;
		}

	}
    ETG_TRACE_USR4(("enConvertSrcForOFF()->u8Source=%d,enSource=%d",u8Source,enSource));
	return enSource;
}
/*************************************************************************
 * FUNCTION:     tunmstr_SrcChgManager::vHandleFMTAFGBGMethodResult( )
 *
 * DESCRIPTION:  Function to handle the method result of FGBG, when enSrcActivty  is set to FM TA
 *
 * PARAMETER:    tVoid
 *
 * RETURNVALUE:  tVoid
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vHandleFMTAFGBGMethodResult()
{
	if((m_potunmstr_TunerClientHandler == NULL) || (m_potunmstr_SrcChg_AnnoHandler == NULL))
	{
		ETG_TRACE_USR4(("vHandleFMTAFGBGMethodResult()->NULL"));
		return;
	}

	ETG_TRACE_USR1(("tunmstr_SrcChgManager::vHandleFMTAFGBGMethodResult()->enSrcActivty=%02x",
			ETG_CENUM(enSourcendAction,enSrcActivty)));
	tU8 u8AnnoType = m_potunmstr_SrcChg_AnnoHandler->u8GetTunmst_AnnoTypes((tU16)m_potunmstr_SrcChg_AnnoHandler->m_ActiveAnnoSrc);
	switch(enSrcActivty)
	{
	case FMTA_ON:
	{
		vUpdateAnnoHandlingRequest(TRUE,(tU8)TUNMSTR_SRCCHG_SOURCE_TUN1FM,u8AnnoType);
		m_potunmstr_MsgToHMI->vSend_g_Announcement_Status(TRUE, (tU8)TUNMSTR_SRCCHG_SOURCE_TUN1FM, u8AnnoType);
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(
		m_potunmstr_AudioClientHandler->u8MapTunmstrSources((tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA), (tU8)TUNMSTR_SRCCHG_ACTION_ON );
#endif
		break;
	}
	case FMTA_PAUSE:
	{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(
		m_potunmstr_AudioClientHandler->u8MapTunmstrSources((tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA), (tU8)TUNMSTR_SRCCHG_ACTION_PAUSE);
#endif
		//send Result to LIB
		break;
	}
	case FMTA_OFF:
	{
		vUpdateAnnoHandlingRequest(FALSE,(tU8)TUNMSTR_SRCCHG_SOURCE_TUN1FM,u8AnnoType);
		m_potunmstr_MsgToHMI->vSend_g_Announcement_Status(FALSE, (tU8)TUNMSTR_SRCCHG_SOURCE_TUN1FM, u8AnnoType);
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSendResult_ToLib(m_potunmstr_AudioClientHandler->u8MapTunmstrSources((tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA),(tU8)TUNMSTR_SRCCHG_ACTION_OFF);
#endif
		m_u8Current_TASource = (tU8)TUNMSTR_SRCCHG_SOURCE_NO_TA;
		m_potunmstr_TunerClientHandler->vSetAnnoType((tU8)TUNMSTR_ANNOMSG_INVALID);
		m_potunmstr_SrcChg_AnnoHandler->vSetActiveAnnoSrc(TunMstr_AnnoActive_None);

		break;
	}
	default:
	{
		break;
	}
	}
}
/*************************************************************************
 * FUNCTION:     tunmstr_SrcChgManager::u8GetSourceFromenSourcendAction( )
 *
 * DESCRIPTION:  Function to convert the current enSrcActivty to Tunermaster Source.
 *
 * PARAMETER:    tVoid
 *
 * RETURNVALUE:  u8Source
 *************************************************************************/
tU8 tunmstr_SrcChgManager::u8GetSourceFromenSourcendAction()const
{
	tU8 u8Source=TUNMSTR_SRCCHG_INVALID;
	switch(enSrcActivty)
	{
	case FM_ON:
	case FM_PAUSE:
	case FM_OFF:
	{
		u8Source=(tU8)TUNMSTR_SRCCHG_SOURCE_TUN1FM;
		break;
	}
	case AM_OFF:
	case AM_ON:
	case AM_PAUSE:
	{
		u8Source=(tU8)TUNMSTR_SRCCHG_SOURCE_TUN1AM;
		break;
	}
	case DAB_ON:
	case DAB_PAUSE:
	case DAB_OFF:
		{
			u8Source=(tU8)TUNMSTR_SRCCHG_SOURCE_DAB;
			break;
		}
	case DABTA_ON:
	case DABTA_OFF:
	case DABTA_PAUSE:
		{
			u8Source=(tU8)TUNMSTR_SRCCHG_SOURCE_DAB_TA;
			break;
		}
	case FMTA_ON:
	case FMTA_OFF:
	case FMTA_PAUSE:
		{
			u8Source=(tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA;
			break;
		}
    case DRM_OFF:
    case DRM_ON:
    case DRM_PAUSE:
    {
        u8Source=(tU8)TUNMSTR_SRCCHG_SOURCE_DRM;
        break;
    }
	default:
		{
			break;
		}
	}
	ETG_TRACE_USR4(("tunmstr_SrcChgManager::u8GetSourceFromenSourcendAction()->enSrcActivty=%02x u8Source=%d",
	ETG_CENUM(enSourcendAction,enSrcActivty),u8Source));
	return  u8Source;
}
/*************************************************************************
 * FUNCTION:     tunmstr_SrcChgManager::u8GetSourceFromenSourcendAction( )
 *
 * DESCRIPTION:  Function to convert the current enSrcActivty to Tunermaster Action.
 *
 * PARAMETER:    tVoid
 *
 * RETURNVALUE:  u8Action
 *************************************************************************/
tU8 tunmstr_SrcChgManager::u8GetActionFromenSourcendAction()const
{
	tU8 u8Action=TUNMSTR_SRCCHG_INVALID;
	switch(enSrcActivty)
	{
	case FM_ON:
	case AM_ON:
	case DAB_ON:
	case DABTA_ON:
	case FMTA_ON:
   case DRM_ON:
	{
		u8Action=(tU8)TUNMSTR_SRCCHG_ACTION_ON;
		break;
	}
	case FM_PAUSE:
	case AM_PAUSE:
	case DAB_PAUSE:
	case FMTA_PAUSE:
	case DABTA_PAUSE:
   case DRM_PAUSE:
	{
		u8Action=(tU8)TUNMSTR_SRCCHG_ACTION_PAUSE;
		break;
	}
	case FM_OFF:
	case AM_OFF:
	case DAB_OFF:
	case FMTA_OFF:
	case DABTA_OFF:
   case DRM_OFF:
	{
		u8Action=(tU8)TUNMSTR_SRCCHG_ACTION_OFF;
		break;
	}
	default:
	{
		break;
	}
	}
	ETG_TRACE_USR4(("tunmstr_SrcChgManager::u8GetActionFromenSourcendAction()->enSrcActivty=%02x u8Action=%d",
	ETG_CENUM(enSourcendAction,enSrcActivty),u8Action));
	return u8Action;
}
/*************************************************************************
 * FUNCTION:    vHandleCriticalVg
 *
 * DESCRIPTION:  Function to Handle Critical Low vg When tuner is the current source
 *
 * PARAMETER:    u8Source,tU8 u8Action
 *
 * RETURNVALUE:  tVoid
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vHandleCriticalVg(tU8 u8Source,tU8 u8Action)
{
	ETG_TRACE_USR1(("tunmstr_SrcChgManager::vHandleCriticalVg"));	
    m_potunmstr_TunerClientHandler->vSend_s_Audio_FG_BG_New(
        (tU8)TUNMSTR_SRCCHG_FOREGROUND, (tU8)TUNMSTR_SRCCHG_CHG_TO_BG, (tU8)TUNMSTR_SRCCHG_USR1_CHG_FGBG, (tU8)TUNMSTR_SRCCHG_FOREGROUND,0xFF);
    if(u8Source == TUNMSTR_SRCCHG_SOURCE_DRM)
    {
        if(u8Action == TUNMSTR_SRCCHG_ACTION_OFF)
        {
            m_potunmstr_TunerClientHandler->vSend_s_DRMSourceActivity(enConvertDRMSrcActValue(DRM_OFF));
        }
        else if(u8Action == TUNMSTR_SRCCHG_ACTION_PAUSE)
        {
            m_potunmstr_TunerClientHandler->vSend_s_DRMSourceActivity(enConvertDRMSrcActValue(DRM_PAUSE));
        }
        else
        {
            //to avoid lint warnings
        }
    }
    vSetTunerState((tU8)TUNMSTR_SRCCHG_BACKGROUND);
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
    m_potunmstr_AudioClientHandler->vSendResult_ToLib(m_potunmstr_AudioClientHandler->u8MapTunmstrSources(u8Source), u8Action);
#endif


}
/*************************************************************************
 * FUNCTION:    enConvSrcForPause
 *
 * DESCRIPTION:  Function to convert source when the action is pause to enSourcendAction type.
 *
 * PARAMETER:    u8Source,tU8 u8Action
 *
 * RETURNVALUE:  tVoid
 *************************************************************************/
enSourcendAction tunmstr_SrcChgManager::enConvertSrcForPause(tU8 u8Source)const
{
	enSourcendAction enSource=NONE;
	switch(u8Source)
	{
	case TUNMSTR_SRCCHG_SOURCE_TUN1FM:
		{
			enSource=FM_PAUSE;
			break;
		}
	case TUNMSTR_SRCCHG_SOURCE_TUN1AM:
		{
			enSource=AM_PAUSE;
			break;
		}
   case TUNMSTR_SRCCHG_SOURCE_DRM:
		{
		  enSource=DRM_PAUSE;
		  break;
		}
	case TUNMSTR_SRCCHG_SOURCE_DAB:
		{
			enSource=DAB_PAUSE;
			break;
		}
	default:
		{
			break;
		}
	}
    ETG_TRACE_USR4(("tunmstr_SrcChgManager::enConvertSrcForPause()->u8Source=%d,enSource=%d",u8Source,enSource));
	return enSource;
}
/*************************************************************************
 ************************************************************************/
enSourcendAction tunmstr_SrcChgManager::enConvertSrcForON(tU8 u8Source)const
{
    enSourcendAction enSource=NONE;
    switch(u8Source)
    {
    case TUNMSTR_SRCCHG_SOURCE_TUN1FM:
    {
        enSource=FM_ON;
        break;
    }
    case TUNMSTR_SRCCHG_SOURCE_TUN1AM:
    {
        enSource=AM_ON;
        break;
    }
    case TUNMSTR_SRCCHG_SOURCE_DRM:
    {
        enSource=DRM_ON;
        break;
    }
    case TUNMSTR_SRCCHG_SOURCE_DAB:
    {
        enSource=DAB_ON;
        break;
    }
    default:
    {
        break;
    }
    }
    ETG_TRACE_USR4(("tunmstr_SrcChgManager::enConvertSrcForON()->u8Source=%d,enSource=%d",u8Source,enSource));
    return enSource;
}
/*************************************************************************
 * FUNCTION:    u8ConvertSrcToBand
 *
 * DESCRIPTION:  Function to tunermaster source to tunermaster Band type.
 *
 * PARAMETER:    u8Source
 *
 * RETURNVALUE:  tU8 u8RetBand
 *************************************************************************/
tU8 tunmstr_SrcChgManager::u8ConvertSrcToBand(tU8 u8Source)
{
	tU8 u8RetBand=TUNMSTR_SRCCHG_INVALID;
	switch(u8Source)
	{
		case TUNMSTR_SRCCHG_SOURCE_TUN1FM:
		{
			u8RetBand=TUNMSTR_SRCCHG_BAND_FM;
			break;
		}
		case TUNMSTR_SRCCHG_SOURCE_TUN1AM:
		{
			u8RetBand=TUNMSTR_SRCCHG_BAND_AM;
			break;
		}
		case TUNMSTR_SRCCHG_SOURCE_DRM:
		{
		   u8RetBand=TUNMSTR_SRCCHG_BAND_CB1;
		   break;
		}
		case TUNMSTR_SRCCHG_SOURCE_DAB:
		{
			u8RetBand=TUNMSTR_SRCCHG_BAND_DAB;
			break;
		}
		default:
		{
			break;
		}
	}
    ETG_TRACE_USR4(("tunmstr_SrcChgManager::u8ConvertSrcToBand()->u8Source=%d,u8RetBand=%d",u8Source,u8RetBand));
	return u8RetBand;
}

enTunmstr_DRMSourceActivity tunmstr_SrcChgManager::enConvertDRMSrcActValue(enSourcendAction u8Action)
{
    enTunmstr_DRMSourceActivity e8SrcAct = TUNMSTR_DRM_OFF;
    switch(u8Action)
    {
    case DRM_OFF:
    {
         e8SrcAct = TUNMSTR_DRM_OFF;
    }break;
    case DRM_ON:
    {
        e8SrcAct = TUNMSTR_DRM_ON;
    }break;
    case DRM_PAUSE:
    {
        e8SrcAct=TUNMSTR_DRM_PAUSE;
    }break;
    default:
    {
        ETG_TRACE_USR4(("entered default case"));
    }
    }

    return e8SrcAct;
}

/*************************************************************************
 * FUNCTION:    vSendTunerToFG
 *
 * DESCRIPTION:  Send tuner to foreground.
 *
 * PARAMETER:    u8Source
 *
 * RETURNVALUE:  tVoid
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vSendTunerToFG(tU8 u8RequestedSource, enSourcendAction u8Action)
{
    ETG_TRACE_USR4(("Entered tunmstr_SrcChgManager::vSendTunerToFG"));
    if(u8RequestedSource == TUNMSTR_SRCCHG_SOURCE_DRM)
    {
        m_potunmstr_TunerClientHandler->vSend_s_Audio_FG_BG_New(
                (tU8)TUNMSTR_SRCCHG_FOREGROUND, (tU8)TUNMSTR_SRCCHG_CHG_TO_FG, \
                    (tU8)TUNMSTR_SRCCHG_USR1_CHG_FGBG, (tU8)TUNMSTR_SRCCHG_BACKGROUND,\
                    TUNMSTR_SRCCHG_INVALID);
        /**set DRM source activity*/
        m_potunmstr_TunerClientHandler->vSend_s_DRMSourceActivity(enConvertDRMSrcActValue(u8Action));
    }
    else
    {
        m_potunmstr_TunerClientHandler->vSend_s_Audio_FG_BG_New(
                (tU8)TUNMSTR_SRCCHG_FOREGROUND, (tU8)TUNMSTR_SRCCHG_CHG_TO_FG, \
                    (tU8)TUNMSTR_SRCCHG_USR1_CHG_FGBG, (tU8)TUNMSTR_SRCCHG_BACKGROUND,\
                    TUNMSTR_SRCCHG_INVALID);
    }
    vSetTunerState((tU8)TUNMSTR_SRCCHG_INPROGESS);
    vInitializeErrHandlr_Timer(TUNERMASTER_ERRHANDLR_TIMER);
}
/*************************************************************************
 * FUNCTION:    vSendTunerToBG
 *
 * DESCRIPTION:  Send tuner to boreground.
 *
 * PARAMETER:    u8Source
 *
 * RETURNVALUE:  tVoid
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vSendTunerToBG(tU8 u8Source, enSourcendAction u8Action)
{
    ETG_TRACE_USR4(("Entered tunmstr_SrcChgManager::vSendTunerToBG"));
    m_potunmstr_TunerClientHandler->vSend_s_Audio_FG_BG_New(
            (tU8)TUNMSTR_SRCCHG_FOREGROUND,(tU8)TUNMSTR_SRCCHG_CHG_TO_BG,\
            (tU8)TUNMSTR_SRCCHG_USR1_CHG_FGBG,(tU8)TUNMSTR_SRCCHG_FOREGROUND,0xFF);
    if(u8Source == TUNMSTR_SRCCHG_SOURCE_DRM )
    {
        /**set DRM source activity OFF*/
        m_potunmstr_TunerClientHandler->vSend_s_DRMSourceActivity(enConvertDRMSrcActValue(u8Action));
    }
    vSetTunerState((tU8)TUNMSTR_SRCCHG_INPROGESS);
    vInitializeErrHandlr_Timer(TUNERMASTER_ERRHANDLR_TIMER);
}
/*************************************************************************
 * FUNCTION:    vhandleTunerpAUSE
 *
 * DESCRIPTION:  Function to handle Tuner Pause request from ARL
 *
 * PARAMETER:    u8Source
 *
 * RETURNVALUE:  tVoid
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vhandleTunerpAUSE(tU8 u8Source)
{
    tU8 u8CurrentSource = u8GetCurrentSource();
	tU8 u8Tun_State = u8GetTunerState();
    enSrcActivty=enConvertSrcForPause(u8Source);

    if((u8Tun_State == (tU8)TUNMSTR_SRCCHG_BACKGROUND	) || ((tU8)TUNMSTR_SRCCHG_INVALID == u8Tun_State ))
    {
        ETG_TRACE_USR1(("tunmstr_SrcChgManager::vhandleTunerpAUSE->Send tuner to FG"));
        vSendTunerToFG(u8Source, enSrcActivty);
    }
    if (u8Source == TUNMSTR_SRCCHG_SOURCE_DRM)
    {
        //only if source is DRM send source activity request to AMFM
        m_potunmstr_TunerClientHandler->vSend_s_DRMSourceActivity(enConvertDRMSrcActValue(enSrcActivty));
    }
    if(u8CurrentSource !=u8Source)
    {
        ETG_TRACE_USR1(("tunmstr_SrcChgManager::vhandleTunerpAUSE->Send tuner to Band change"));

        m_potunmstr_TunerClientHandler->vSend_s_ChangeBand(u8ConvertSrcToBand(u8Source));
        m_blBandChangeFlag = TRUE;
    }
    else
    {
        //currentsource and requested source are same
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
        m_potunmstr_AudioClientHandler->vSendResult_ToLib(m_potunmstr_AudioClientHandler->u8MapTunmstrSources(u8Source) , (tU8)TUNMSTR_SRCCHG_ACTION_PAUSE);
#endif
    }
}
/*************************************************************************
 * FUNCTION:    vStoreSource_FMTAActive
 *
 * DESCRIPTION:  Function to store the source when FM TA is current source 
 *
 * PARAMETER:    tVoid
 *
 * RETURNVALUE:  tVoid
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vStoreSource_FMTAActive()
{
	if((NULL==m_potunmstr_SrcChg_AnnoHandler)
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			||(NULL==m_potunmstr_AudioClientHandler)
#endif
			)
	{
		return;
	}
	tBool blClearTAFlags=TRUE;
	tBool blDABTP_State=m_potunmstr_SrcChg_AnnoHandler->blGetTPState_DAB();
	if(m_u8CurrentTunerState==(tU8)TUNMSTR_SRCCHG_FOREGROUND)
	{
		ETG_TRACE_USR1(("tunmstr_SrcChgManager::vStoreSource_FMTAActive()->When FMTA is active in FM source during LWP, Stroe FM pause"));
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSetSrcActivity_ServiceUnavail((tU8)TUNMSTR_SRCCHG_ACTION_PAUSE);
		m_potunmstr_AudioClientHandler->vSetSrcReq_ServiceUnavail((tU8)TUNMSTR_SRCCHG_SOURCE_TUN1FM);
		m_potunmstr_AudioClientHandler->vHandleANNOSrcChg_Request((tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA,(tU8)TUNMSTR_SRCCHG_ACTION_OFF);
#endif
	}
	else if((m_u8DABState==(tU8)TUNMSTR_SRCCHG_DAB_PAUSE_STATE)&&(blDABTP_State==FALSE))
	{
		ETG_TRACE_USR1(("tunmstr_SrcChgManager::vStoreSource_FMTAActive()->When FM TA is active in dab source and tuner service becomes Unavailable Or LW PW"));
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vHandleANNOSrcChg_Request((tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA,(tU8)TUNMSTR_SRCCHG_ACTION_OFF);
#endif
	}
	else
	{
		ETG_TRACE_USR4(("tunmstr_SrcChgManager::vStoreSource_FMTAActive()->Dont clear the TA flags"));	
		blClearTAFlags=FALSE;
	}
	if(blClearTAFlags)
	{
		m_u8Current_TASource = (tU8)TUNMSTR_SRCCHG_SOURCE_NO_TA;
		m_u8Current_TAAction = TUNMSTR_SRCCHG_INVALID;
		m_potunmstr_SrcChg_AnnoHandler->vSetTA_Anno_State(FALSE);
		m_potunmstr_SrcChg_AnnoHandler->vSetLastFMTA_ActiveStatus(FALSE);
	}
}
/*************************************************************************
 * FUNCTION:    vStoreSource_DABTAActive
 *
 * DESCRIPTION:  Function to store the source when DAB TA is current source 
 *
 * PARAMETER:    tVoid
 *
 * RETURNVALUE:  tVoid
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vStoreSource_DABTAActive()
{
	if((NULL==m_potunmstr_SrcChg_AnnoHandler)
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			||(NULL==m_potunmstr_AudioClientHandler)
#endif
			)
	{
		return;
	}
	tBool blDABTP_State=m_potunmstr_SrcChg_AnnoHandler->blGetTPState_DAB();
	if(m_u8DABState==(tU8)TUNMSTR_SRCCHG_DAB_PAUSE_STATE)
	{
		ETG_TRACE_USR4(("tunmstr_SrcChgManager::vStoreSource_DABTAActive()->When DAB TA is active  in dab source during LWP, Stroe DAB pause"));
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_potunmstr_AudioClientHandler->vSetSrcActivity_ServiceUnavail((tU8)TUNMSTR_SRCCHG_ACTION_PAUSE);
		m_potunmstr_AudioClientHandler->vSetSrcReq_ServiceUnavail((tU8)TUNMSTR_SRCCHG_SOURCE_DAB);
#endif
		if(blDABTP_State==TRUE)
		{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			m_potunmstr_AudioClientHandler->vHandleANNOSrcChg_Request((tU8)TUNMSTR_SRCCHG_SOURCE_DAB_TA,(tU8)TUNMSTR_SRCCHG_ACTION_OFF);
#endif
		}
		else
		{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			m_potunmstr_AudioClientHandler->vHandleANNOSrcChg_Request((tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA,(tU8)TUNMSTR_SRCCHG_ACTION_OFF);
#endif
			m_potunmstr_SrcChg_AnnoHandler->vSetLastFMTA_ActiveStatus(FALSE);
		}
		m_u8Current_TASource = (tU8)TUNMSTR_SRCCHG_SOURCE_NO_TA;
		m_u8Current_TAAction = TUNMSTR_SRCCHG_INVALID;
		m_potunmstr_SrcChg_AnnoHandler->vSetDABTA_Ended(TRUE);
	}
}
/*************************************************************************
 * FUNCTION:    blIsFMTAActive
 *
 * DESCRIPTION:  Function to check TA annou active in tunmstr_SrcChgManager class
 *
 * PARAMETER:    tVoid
 *
 * RETURNVALUE:  tVoid
 *************************************************************************/
tBool tunmstr_SrcChgManager::blIsFMTAActive()const
{
	if(NULL==m_potunmstr_SrcChg_AnnoHandler)
	{
		return FALSE;
	}
	if(m_potunmstr_SrcChg_AnnoHandler->blGetTA_Anno_Status() == TRUE)
	{
		return TRUE;
	}
	else
	{
		return FALSE;
	}
}


/*************************************************************************
 *  FUNCTION:    tVoid tunmstr_SrcChgManager::vUpdateAnnoHandlingRequest()
 *
 *  DESCRIPTION: Helper function to update anno request
 *
 *  PARAMETER:   amt_tclServiceData* poMessage
 *
 *
 *  RETURNVALUE: None
 *
 *************************************************************************/
tVoid tunmstr_SrcChgManager::vUpdateAnnoHandlingRequest(tU8 u8AnnoState, tU8 u8Source , tU16 u16AnnoType)
{
	m_AnnoHandlingRequest.u8AnnoState = u8AnnoState;
	m_AnnoHandlingRequest.u8AnnoType = u16AnnoType;
	m_AnnoHandlingRequest.u8Source = u8Source;
	ETG_TRACE_USR4(("tunmstr_SrcChgManager::vUpdateAnnoHandlingRequest()-> u8AnnoState :%d, u8AnnoType : %d \
			u8Source : %d", m_AnnoHandlingRequest.u8AnnoState,m_AnnoHandlingRequest.u8AnnoType,m_AnnoHandlingRequest.u8Source));
}

/*************************************************************************
 * FUNCTION:    vHandleDABTempAnnouncement()
 *
 * DESCRIPTION:	Handle DAB surveillance announcements
 *
 * PARAMETER:
 *
 * RETURNVALUE: None
 **************************************************************************/

tVoid tunmstr_SrcChgManager::vHandleDABTempAnnouncement()
{
	if((m_potunmstr_DABClient_Handler==NULL) || (m_potunmstr_SrcChg_AnnoHandler == NULL))
	{
		NORMAL_M_ASSERT( m_potunmstr_DABClient_Handler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChg_AnnoHandler != NULL );
		return;
	}

	ETG_TRACE_USR4(("tunmstr_SrcChgManager::vHandleDABTempFG()"));

	tU8 u8AnnoType = m_potunmstr_SrcChg_AnnoHandler->u8ConvertCurrentAnnoARLSource((tU16)m_potunmstr_SrcChg_AnnoHandler->m_ActiveAnnoSrc);
	if((u8AnnoType == (tU8)TUNMSTR_SRCCHG_SOURCE_DAB_TA) || (u8AnnoType == (tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA)) // SUZUKI-22859, SUZUKI-22883 no handling if anno is active.
	{
		ETG_TRACE_USR4(("tunmstr_SrcChgManager::vHandleDABTempFG(), no handling if DAB anno active"));
		return;
	}

	tU8 u8TPSwitch = (tU8)(((m_potunmstr_SrcChg_AnnoHandler->u32GetAnnoButtonState_FM()) & (tU8)TUNMSTR_ANNOSTATE_PTYOFF_TAON)>>0x01);
	if((u8TPSwitch) && ((u8GetDABState() == TUNMSTR_SRCCHG_BACKGROUND) || (u8GetDABState() == TUNMSTR_SRCCHG_INVALID)))  // check only in non DAB source
	{
		vUpdateDAB_SrcState();
	}
	else
	{
		// no handling
	}
}


/*************************************************************************
 * FUNCTION:     vUpdateDAB_SrcState()
 *
 * DESCRIPTION:	updates DAB src state to BG or surveillance
 *
 * PARAMETER:
 *
 * RETURNVALUE:  tVoid
 **************************************************************************/

tVoid tunmstr_SrcChgManager::vUpdateDAB_SrcState()
{

	if(m_potunmstr_DABClient_Handler==NULL)
	{
		NORMAL_M_ASSERT( m_potunmstr_DABClient_Handler != NULL );
		return;
	}
#ifdef VARIANT_S_FTR_ENABLE_DAB_SURVEILLANCE
	ETG_TRACE_USR4((" tunmstr_SrcChgManager::vUpdateDAB_SrcState"));

	if(u16GetAnnoInfoPI() != 0)
	{
		if((u8GetDABState() != TUNMSTR_SRCCHG_BACKGROUND) && (u8GetDABState() != TUNMSTR_SRCCHG_INVALID))
		{
			ETG_TRACE_USR4(("tunmstr_SrcChgManager::vHandleDABTempFG(), DAB BG"));
			m_potunmstr_DABClient_Handler->vSend_s_Source_State((tU8)TUNMSTR_SRCCHG_DAB_BACKGROUND);
			vSetDABState((tU8)TUNMSTR_SRCCHG_BACKGROUND);
		}
	}
	else
	{
		if(u8GetDABState() != TUNMSTR_SRCCHG_DAB_SURVEILLANCE)
		{
			ETG_TRACE_USR4(("tunmstr_SrcChgManager::vHandleDABTempFG(), surveillance"));
			m_potunmstr_DABClient_Handler->vSend_s_Source_State((tU8)TUNMSTR_SRCCHG_DAB_FOREGROUND_SURVEILLANCE);
			vSetDABState((tU8)TUNMSTR_SRCCHG_DAB_SURVEILLANCE);
		}
	}
#endif
}


/*************************************************************************
 * FUNCTION:     u16GetAnnoInfoPI()
 *
 * DESCRIPTION:	Returns PI
 *
 * PARAMETER:
 *
 * RETURNVALUE:  tU16
 **************************************************************************/

tU16 tunmstr_SrcChgManager::u16GetAnnoInfoPI() const
{
	ETG_TRACE_USR4((" tunmstr_SrcChgManager::u16GetAnnoInfoPI,m_u16PI :%d",m_u16PI));
	return m_u16PI;
}


/*************************************************************************
 * FUNCTION:     vSetAnnoInfoPI()
 *
 * DESCRIPTION:	Returns PTY state
 *
 * PARAMETER:
 *
 * RETURNVALUE:  tVoid
 **************************************************************************/

tVoid tunmstr_SrcChgManager::vSetAnnoInfoPI(tU16 u16PI)
{
	m_u16PI = u16PI;
}

