/************************************************************************
 * FILE:           tunmstr_MsgToHMI.h
 * PROJECT:        G3g
 * SW-COMPONENT:   FC_TunerMaster.
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:    CCA messages sent to HMI are implemented in this file.
 *
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date     		 | Author                       | Modification
 * 15-04-11  		 | CM-AI/PJ-VW36 Pallavi HN   	| initial version
* 25.04.13  		 | NGP1KOR   					| First version of the G3g after porting from NISSAN LCN2Kai
				
 *************************************************************************/
//-----------------
// System includes
//-----------------


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#include "ahl_mock/ahl_if.h"
#include "amt_mock/amt_if.h"
#else
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif
/*----------------------------------------------------------------------*/
/* FI type inclusion                                                    */
/*----------------------------------------------------------------------*/
#ifdef IMPORT_INTERFACE
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_ERRORCODES


#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" 
#endif
/*----------------------------------------------------------------------*/

#include "fc_tunermaster_featureControl.h"

#include "tunermaster_main.h"
#include "tunermaster_Config.h"
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
#include "tunmstr_TunerClientHandler.h"
#endif
#include "tunmstr_SrcChg_Defines.h"
#include "tunmstr_SrcChg_Trace.h"
#include "tunmstr_SrcChgManager.h"
#include "tunmstr_MsgToHMI.h"
#include "tunmstr_MsgFromHMI.h"
#include "tunmstr_antdiag_Defines.h"
#include "tunmstr_SrcChg_AnnoHandler.h"
#include "kdsconfig/clConfigInterface.h"
#include "tunmstr_DABClient_Handler.h"
#ifndef TUNERMASTER_DEFINES_H
#include "tunermaster_defines.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNMSTR_TRACE_CLASS_SRCCHG
#include "trcGenProj/Header/tunmstr_MsgToHMI.cpp.trc.h"
#endif
OSAL_tSemHandle tunmstr_MsgToHMI::m_hNotTable_SemHandle  = OSAL_C_INVALID_HANDLE;

#ifndef VARIANT_S_FTR_ENABLE_TUNERMASTER_MOCK
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#include "dp_tuner_if.h"
#endif

/*************************************************************************
 *
 * FUNCTION:     tunmstr_MsgToHMI::tunmstr_MsgToHMI( )
 *
 * DESCRIPTION:  Constructor
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
tunmstr_MsgToHMI::tunmstr_MsgToHMI( tunmaster_tclApp* potunerMainApp , tuner::sessionManagement::audio::clArlSourceImpl* poArlImpl ):
#else
tunmstr_MsgToHMI::tunmstr_MsgToHMI( tunmaster_tclApp* potunerMainApp):
#endif
		poGWMain( NULL ),\
		m_potunmaster_Config(NULL),\
		m_potunmstr_TunerClientHandler(NULL),\
		m_potunmstr_SrcChgManager(NULL),\
				m_potunmstr_MsgFromHMI(NULL),\
				m_potunmstr_SrcChg_AnnoHandler(NULL),\
				m_poclConfigInterface(NULL)
		{

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
				m_poArlImpl = poArlImpl;
#endif

		bAnnouncementStatus = false;
		u8AnnouncementMainSource = 0xff;
		u8AnnouncementType = 0xff;


	poGWMain = potunerMainApp;
	m_potunmstr_DABClient_Handler = NULL;


	tS32 s32RetFlag = OSAL_s32SemaphoreCreate(TUNERMASTER_HMI_NOTTABLE_SEM_NAME, &m_hNotTable_SemHandle, 1);
	
	//Added to remove lint warning.
	ETG_TRACE_USR4(("tunmstr_MsgToHMI::tunmstr_MsgToHMI()-> s32RetFlag=%x.", s32RetFlag));

	// Initialize notification table array.
	//::memset(m_aFuncID_HMI_Array, 0, sizeof(m_aFuncID_HMI_Array));
	//::memset(m_aNotArray_HMI, 0, sizeof(m_aFuncID_HMI_Array));

	/* ---
   create HMI NotificationTable.
   Here we store information about all HMI registered clients
   --- */
	m_hNotTable_TunerMaster = new ahl_tclNotificationTable( TUNERMASTER_AUDIO_FUNID_CARRAY_SIZE);
	//m_poHMINotTable = new ahl_tclNotificationTable( m_aFuncID_HMI_Array,
	//                                                 TUNER_HMI_FUNID_CARRAY_SIZE,
	//                                                 m_aNotArray_HMI,
	//                                                 TUNER_HMI_FUNID_NOTARRAY_SIZE
	//                                               );
#ifdef INCLUDE_PROFILE_MANAGER
	m_poPMClient = NULL;
#endif
	m_u8ActivePreset = 0xFF;
	m_u8TunerTPStatus = 0xFF;
	m_u8DABTPStatus = 0xFF;
		}//End of constructor


/*************************************************************************
 *
 * FUNCTION:     tunmstr_MsgToHMI::~tunmstr_MsgToHMI( )
 *
 * DESCRIPTION:  Destructor
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tunmstr_MsgToHMI::~tunmstr_MsgToHMI( )
{
	tS32 s32RetFlag = OSAL_s32SemaphoreClose( m_hNotTable_SemHandle );
	s32RetFlag = OSAL_s32SemaphoreDelete( TUNERMASTER_HMI_NOTTABLE_SEM_NAME );

	ETG_TRACE_USR4(("tunmstr_MsgToHMI::~tunmstr_MsgToHMI()-> s32RetFlag=%x.", s32RetFlag));

	if( m_hNotTable_TunerMaster != NULL )
	{
		vDeleteNoThrow( m_hNotTable_TunerMaster);
	}

	m_potunmaster_Config = NULL;
	m_potunmstr_TunerClientHandler = NULL;
	m_potunmstr_SrcChgManager = NULL;
	m_potunmstr_MsgFromHMI = NULL;
	m_potunmstr_SrcChg_AnnoHandler = NULL;
	bAnnouncementStatus = false;
	u8AnnouncementMainSource = 0xff;
	u8AnnouncementType = 0xff;
	m_poclConfigInterface = NULL;
    m_potunmstr_DABClient_Handler = NULL;
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	m_poArlImpl = NULL;
#endif
#ifdef INCLUDE_PROFILE_MANAGER
	m_poPMClient = NULL;
#endif
	m_u8ActivePreset = 0xFF;
	m_u8TunerTPStatus = 0xFF;
	m_u8DABTPStatus = 0xFF;

}//End of Destructor
/*************************************************************************
 *
 * FUNCTION: vSet_tunmstr_SrcChg_AnnoHandler_Ptr( tunmstr_SrcChg_AnnoHandler* potunmstr_SrcChg_AnnoHandler )
 *
 * DESCRIPTION:  Set pointer to pointer tunmaster_Config
 *
 * PARAMETER:    tunmaster_Config* potunmaster_Config
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_MsgToHMI::vSet_tunmstr_SrcChg_AnnoHandler_Ptr(tunmstr_SrcChg_AnnoHandler* potunmstr_SrcChg_AnnoHandler)

{
	if( potunmstr_SrcChg_AnnoHandler != NULL )
	{
		m_potunmstr_SrcChg_AnnoHandler = ( tunmstr_SrcChg_AnnoHandler* )potunmstr_SrcChg_AnnoHandler;
	}
	else
	{
		NORMAL_M_ASSERT ( m_potunmstr_SrcChg_AnnoHandler != NULL );
	}
}
/*************************************************************************
 *
 * FUNCTION:    vSet_tunmaster_Config_Ptr
 *
 * DESCRIPTION:  Set pointer to pointer tunmaster_Config
 *
 * PARAMETER:    tunmaster_Config* potunmaster_Config
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunmstr_MsgToHMI::vSet_tunmaster_Config_Ptr( tunmaster_Config* potunmaster_Config )
{
	if( potunmaster_Config != NULL )
	{
		m_potunmaster_Config = ( tunmaster_Config* )potunmaster_Config;
	}
}
/*************************************************************************
 *
 * FUNCTION:    tunmstr_MsgToHMI( tunmstr_TunerClientHandler* potunmstr_TunerClientHandler )
 *
 * DESCRIPTION:  Set pointer to pointer tunmstr_TunerClientHandler
 *
 * PARAMETER:    tunmstr_TunerClientHandler* potunmstr_TunerClientHandler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_MsgToHMI::vSet_tunmstr_TunerClientHandler_Ptr( tunmstr_TunerClientHandler* potunmstr_TunerClientHandler )
{
	if( potunmstr_TunerClientHandler != NULL )
	{
		m_potunmstr_TunerClientHandler = ( tunmstr_TunerClientHandler* )potunmstr_TunerClientHandler;
	}

}
/*************************************************************************
 *
 * FUNCTION:    tunmstr_MsgToHMI( tunmstr_TunerClientHandler* potunmstr_TunerClientHandler )
 *
 * DESCRIPTION:  Set pointer to pointer tunmstr_TunerClientHandler
 *
 * PARAMETER:    tunmstr_TunerClientHandler* potunmstr_TunerClientHandler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_MsgToHMI::vSet_tunmstr_SrcChgManager_Ptr( tunmstr_SrcChgManager* potunmstr_SrcChgManager )
{
	if( potunmstr_SrcChgManager != NULL )
	{
		m_potunmstr_SrcChgManager = ( tunmstr_SrcChgManager* )potunmstr_SrcChgManager;
	}

}
/*************************************************************************
 *
 * FUNCTION:    vSet_tunmstr_MsgFromHMI_Ptr( tunmstr_MsgFromHMI* potunmstr_MsgFromHMI )
 *
 * DESCRIPTION:   Set pointer to pointer tunmstr_MsgFromHMI
 *
 * PARAMETER:    tunmstr_MsgFromHMI* potunmstr_MsgFromHMI
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_MsgToHMI::vSet_tunmstr_MsgFromHMI_Ptr( tunmstr_MsgFromHMI* potunmstr_MsgFromHMI )
{
	if( potunmstr_MsgFromHMI != NULL )
	{
		m_potunmstr_MsgFromHMI = ( tunmstr_MsgFromHMI* )potunmstr_MsgFromHMI;
	}

}


/*************************************************************************
* FUNCTION:    vSet_tunmstr_ConfigInterface_Ptr
*
* DESCRIPTION: 
*
* PARAMETER:   clConfigInterface* poclConfigInterface
*
* RETURNVALUE:  void
*************************************************************************/
tVoid tunmstr_MsgToHMI::vSet_tunmstr_ConfigInterface_Ptr
(clConfigInterface* poclConfigInterface)
{
	if( poclConfigInterface != NULL )
	{
		m_poclConfigInterface = poclConfigInterface;
	}

}
tVoid tunmstr_MsgToHMI::vSet_tunmstr_DABClient_Handler_Ptr(tunmstr_DABClient_Handler* potunmstr_DABClient_Handler)
{
	if( potunmstr_DABClient_Handler != NULL )
	{
		m_potunmstr_DABClient_Handler = ( tunmstr_DABClient_Handler* )potunmstr_DABClient_Handler;
	}

}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_MsgToHMI::vAddNotificationTable ( )
 *
 * DESCRIPTION:  Add new (HMI UpReg) Function ID registration in the Notification table
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tBool tunmstr_MsgToHMI::bAddNotificationTable ( const amt_tclServiceData* poMessage )
{
	if(( poMessage == NULL ) ||( m_hNotTable_TunerMaster == NULL) )
	{
		if( poMessage == NULL )
		{
			NORMAL_M_ASSERT( poMessage != NULL );
		}

		if( m_hNotTable_TunerMaster == NULL )
		{
			NORMAL_M_ASSERT( m_hNotTable_TunerMaster != NULL );
		}

		return false;
	}//if(( poMessage == NULL ) ||( m_hNotTable_SemHandle == NULL) )

	tBool bSuccess = TRUE;

	ahl_bEnterCritical( m_hNotTable_SemHandle );

	tU16 u16ServiceID = poMessage->u16GetServiceID();

	switch(u16ServiceID)
	{
	case CCA_C_U16_SRV_TUNERMASTERCONTROL:
	{
		switch (poMessage->u8GetOpCode())
		{
		case AMT_C_U8_CCAMSG_OPCODE_UPREG:
		{
			/*---------------------------------------------------------------*/
			/* Notfication-Message - entry with TRUE in ahl_notificationList */
			/*---------------------------------------------------------------*/
			bSuccess = m_hNotTable_TunerMaster -> bAddNotification( poMessage->u16GetFunctionID(),
					poMessage->u16GetSourceAppID(),
					poMessage->u16GetRegisterID(),
					TRUE,
					poMessage->u16GetCmdCounter() );
			if (bSuccess == FALSE)
			{


				ET_TRACE_ERROR_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _ TUNMSTR_TRACE_MSG_TO_HMI_ADD_TO_NOTIF_FAIL _
						ET_EN_T16 _ poMessage->u16GetFunctionID() _
						ET_EN_T16 _ poMessage->u16GetSourceAppID() _
						ET_EN_T16 _ u16ServiceID _
						ET_EN_T16 _ poMessage->u16GetRegisterID() _ ET_EN_DONE);
			}
			else
			{
				ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _ TUNMSTR_TRACE_MSG_TO_HMI_ADD_TO_NOTIF_OK _
						ET_EN_T16 _ poMessage->u16GetFunctionID() _
						ET_EN_T16 _ poMessage->u16GetSourceAppID() _
						ET_EN_T16 _ u16ServiceID _
						ET_EN_T16 _ poMessage->u16GetRegisterID() _ ET_EN_DONE);
			}
		} /* AMT_C_U8_CCAMSG_OPCODE_UPREG */
		break;

		case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
		case AMT_C_U8_CCAMSG_OPCODE_GET:
		case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
			break;

		default:
			ET_TRACE_WARNING( ( (ail_tclAppInterface*)poGWMain )->u16GetAppId(), (tChar*) "TUNMSTR: tunmstr_MsgToHMI - unknown Opcode\n");
			break;

		} /* switch (poMessage->u8GetOpCode()) */

	}/* case CCA_C_U16_SRV_TUNERMASTERCONTROL: */
	break;

	default:
		ET_TRACE_WARNING( ( (ail_tclAppInterface*)poGWMain )->u16GetAppId(), (tChar*) "TUNMSTR: tunmstr_MsgToHMI - unknown Opcode\n");
		break;
	} /* switch(u16ServiceID) */

	ahl_bReleaseCritical(m_hNotTable_SemHandle);
	return bSuccess;
}//End of Function


/*************************************************************************
 *
 * FUNCTION:     tunmstr_MsgToHMI::vRemoveNotification ( )
 *
 * DESCRIPTION:  Remove (HMI UpReg) Function ID registration in the Notification table
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tBool tunmstr_MsgToHMI::bRemoveNotification( const amt_tclServiceData* poMessage )
{
	if(( poMessage == NULL ) ||( m_hNotTable_TunerMaster == NULL) )
	{
		if( poMessage == NULL )
		{
			NORMAL_M_ASSERT( poMessage != NULL );
		}
		if( m_hNotTable_SemHandle == 0 )
		{
			NORMAL_M_ASSERT( m_hNotTable_TunerMaster != NULL );
		}
		return false;
	}//if(( poMessage == NULL ) ||( m_hNotTable_SemHandle == NULL) )

	tBool bSuccess = TRUE;

	ahl_bEnterCritical( m_hNotTable_SemHandle );

	tU16 u16ServiceID = poMessage->u16GetServiceID();

	switch(u16ServiceID)
	{
	case CCA_C_U16_SRV_TUNERMASTERCONTROL:
	{
		switch (poMessage->u8GetOpCode())
		{

		case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
		{
			/*--------------------------------------------*/
			/* Remove FunctionID from notification table  */
			/*--------------------------------------------*/
			bSuccess = m_hNotTable_TunerMaster -> bRemoveNotification( poMessage->u16GetFunctionID(),
					poMessage->u16GetSourceAppID(),
					poMessage->u16GetRegisterID(),
					TRUE,
					poMessage->u16GetCmdCounter() );

			ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _ TUNMSTR_TRACE_MSG_TO_HMI_REM_NOTIF _
					ET_EN_T16 _ poMessage->u16GetFunctionID() _
					ET_EN_T16 _ poMessage->u16GetSourceAppID() _
					ET_EN_T16 _ u16ServiceID _
					ET_EN_T16 _ poMessage->u16GetRegisterID() _ ET_EN_DONE);

		}/* case AMT_C_U8_CCAMSG_OPCODE_RELUPREG */
		break;

		case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
		case AMT_C_U8_CCAMSG_OPCODE_GET:
		case AMT_C_U8_CCAMSG_OPCODE_UPREG:
			break;

		default:
			ET_TRACE_WARNING( ( (ail_tclAppInterface*)poGWMain )->u16GetAppId(), (tChar*) "TUNMSTR: tunmstr_MsgToHMI - unknown Opcode\n");
			break;

		} /* switch (poMessage->u8GetOpCode()) */

	}/* case CCA_C_U16_SRV_TUNERMSTRCONTROL: */
	break;

	default:
		ET_TRACE_WARNING( ( (ail_tclAppInterface*)poGWMain )->u16GetAppId(), (tChar*) "TUNMSTR: tunmstr_MsgToHMI - unknown Opcode\n");
		break;

	}//Switch(u16ServiceID)

	ahl_bReleaseCritical(m_hNotTable_SemHandle);

	return bSuccess;
}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_MsgToHMI::vRemoveAllEntriesWithRegID ( )
 *
 * DESCRIPTION:  Remove All entries (HMI UpReg) of Function ID registration in the Notification table
 *
 * PARAMETER:    tU16 u16ServiceID, tU16 u16RegisterID
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_MsgToHMI::vRemoveAllEntriesWithRegID( tU16 u16ServiceID, tU16 u16RegisterID )
{   
	if( m_hNotTable_TunerMaster == NULL)
	{
		NORMAL_M_ASSERT( m_hNotTable_TunerMaster != NULL );
		return;
	}


	switch (u16ServiceID)
	{
	case CCA_C_U16_SRV_TUNERMASTERCONTROL:
		m_hNotTable_TunerMaster -> bRemoveAllEntriesWithRegID( u16RegisterID );

		ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _ TUNMSTR_TRACE_MSG_TO_HMI_REMALL_NOTIF _
				ET_EN_T16 _ u16RegisterID _ ET_EN_T16 _ u16ServiceID _ ET_EN_DONE);
		break;

	default:
		break;
	}
}


/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vGetDatafromAMT
 *
 *DESCRIPTION: This function converts Amt message to visitor class and
 *             get the data from visitor to the Fi class. Refer FI Manual.
 *             Doc.
 *
 *PARAMETER:
 *           poFiMsg   - Amt Message
 *           oFIData   - Base class of Fi class
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_MsgToHMI::vGetDatafromAMT( amt_tclServiceData* poFIMsg,
		fi_tclTypeBase&     oFIData )const
{
	// Create Visitor message object for incoming message
	fi_tclVisitorMessage oInVisitorMsg(poFIMsg);

	/* Get the data in FI class from Vistor class*/
	if(OSAL_ERROR == oInVisitorMsg.s32GetData(oFIData,1))
	{
		// assert here
		NORMAL_M_ASSERT_ALWAYS ();
	}

}




/****************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vSendMessage
 *
 *DESCRIPTION: This function converts Amt message to visitor class and
 *             get the data from visitor to the Fi class. Refer FI Manual.Doc.
 *
 *PARAMETER:
 *             u16DestAppID      - Destination ID of Out Msg
 *             oOutData          - Base class of out going Fi object
 *             u16Fid            - Funtion id of the out going message
 *             u8OpCode          - Opcode of the message
 *
 *RETURNVALUE: None
 ******************************************************************************/
tVoid tunmstr_MsgToHMI::vSendMessage( StSendCCAMsg OStSendCCAMsg,const fi_tclTypeBase&  oOutData)
{
	if((poGWMain == NULL)||(OStSendCCAMsg.u16RegID==AMT_C_U16_REGID_INVALID))
	{
		NORMAL_M_ASSERT( poGWMain != NULL );
		NORMAL_M_ASSERT( OStSendCCAMsg.u16RegID != AMT_C_U16_REGID_INVALID );
		return;
	}
	// Create the Visitor Message
	fi_tclVisitorMessage oOutVisitorMsg(oOutData,1);


	// Set the CCA message information
	oOutVisitorMsg.vInitServiceData(
			CCA_C_U16_APP_TUNERMASTER,                      /* Source app-ID    */
			OStSendCCAMsg.u16DestAppID,                             /* Dest. app-ID     */
			AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,        /* stream type      */
			0,                                        /* stream counter   */
			OStSendCCAMsg.u16RegID,                                 /* Registry ID      */
			OStSendCCAMsg.u16CmdCtr,                                /* Command counter  */
			CCA_C_U16_SRV_TUNERMASTERCONTROL,               /* Service-ID       */
			OStSendCCAMsg.u16Fid,                                   /* Function-ID      */
			OStSendCCAMsg.u8OpCode,                                 /* OpCode           */
			0,                                        /* ACT              */
			0,                                        /* Source sub-ID    */
			0 );                                      /* Dest. sub-ID     */

	/* ---
   send it to the client 
   --- */
	if(poGWMain->enPostMessage( &oOutVisitorMsg, TRUE ) != AIL_EN_N_NO_ERROR)
	{
		// Message sent successfully.
		ETG_TRACE_USR4(("vSendMessage()->Message not sent successfully."));
	}
	else
	{
		// Message not sent successfully.
		ETG_TRACE_USR4(("vSendMessage()->Message sent successfully."));
	}
}

/*******************************************************************************
 *FUNCTION:		tunmstr_MsgToHMI::vSend_g_RFAntennaTest
 *
 *DESCRIPTION:	This function will FM Antenna status and current value to tuner HMI.
 *PARAMETER:	tU8 u8WhichAntennaToCheck, tU8 u8antennastatus, tFloat fconnectioncurrent
 *RETURNVALUE:	None
 ********************************************************************************/
tVoid tunmstr_MsgToHMI::vSend_g_RFAntennaTest(tU8 u8WhichAntenna,tU8 u8antennastatus,tFloat fconnectioncurrent)
{
	ETG_TRACE_USR4(("vSend_g_RFAntennaTest()-> WhichAntenna=%02x Antennastatus=%02x current=%f",
		ETG_CENUM(tenAntDiagClients,u8WhichAntenna),
		ETG_CENUM(tenRfAntennaStatus,u8antennastatus),fconnectioncurrent));
	if ((m_hNotTable_TunerMaster == NULL) || (m_poclConfigInterface == NULL))
	{
		NORMAL_M_ASSERT( m_hNotTable_TunerMaster != NULL );
		ETG_TRACE_USR4(("tunmstr_MsgToHMI::vSend_g_RFAntennaTest::assert"));
		return;
	}
	ahl_bEnterCritical( m_hNotTable_SemHandle );
	#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
	if( u8antennastatus == enAntennState_ELMOSOpen_Noresult)
	{
		u8antennastatus = enAntennState_Unknown;
	}
	#endif
	/* Post status message to all the registered clients. */
	for(ahl_tNotification* pNot = m_hNotTable_TunerMaster->poGetNotificationList(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_RF_ANTENNA_TEST) ;
			pNot != OSAL_NULL;
			pNot=pNot->pNext)
	{
		midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RF_ANTENNA_TESTStatus oMsgStatus;
		oMsgStatus.Tunmstr_RF_Antenna.AntennaTest.enType=( midw_fi_tcl_e8_AntennaTest::tenType)u8WhichAntenna;
		if((!m_poclConfigInterface->u32GetConfigData("DABSupported")) && (enDAB1==u8WhichAntenna))
		{
			oMsgStatus.Tunmstr_RF_Antenna.RFAntennaStatus.enType = midw_fi_tcl_e8_RFAntenna::FI_EN_TUN_MSTR_RF_ANTENNA_STATE_UNKNOWN;
		}
		else
		{
		oMsgStatus.Tunmstr_RF_Antenna.RFAntennaStatus.enType = (midw_fi_tcl_e8_RFAntenna::tenType)u8antennastatus;
		}
		if(fconnectioncurrent>255.0)
		{
			fconnectioncurrent=255.0;
		}
		oMsgStatus.Tunmstr_RF_Antenna.ConnectionCurrent = (tU8)fconnectioncurrent;
		StSendCCAMsg oStSendCCAMsg;
		oStSendCCAMsg.u16DestAppID=pNot->u16AppID;
		oStSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_RF_ANTENNA_TEST;
		oStSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_STATUS;
		oStSendCCAMsg.u16CmdCtr=pNot->u16CmdCounter;
		oStSendCCAMsg.u16RegID=pNot->u16RegisterID;
		vSendMessage( oStSendCCAMsg,oMsgStatus);
	}//For Loop
	ahl_bReleaseCritical(m_hNotTable_SemHandle);
}
/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vDeleteNoThrow(
 *
 *DESCRIPTION:
 *
 *PARAMETER:
 *
 *
 *RETURNVALUE:
 ********************************************************************************/
template< class T > void tunmstr_MsgToHMI::vDeleteNoThrow( T*& rfpArg ) throw()
		{
	OSAL_DELETE rfpArg;
	rfpArg = 0;
		}

#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vSend_g_SourceChange
 *
 *DESCRIPTION: This function will send source change property to HMI
 *
 *
 *
 *PARAMETER: tU8 u8Source, tU8 u8Action
 *
 *
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_MsgToHMI::vSend_g_SourceChange( tU8 u8Source, tU8 u8Action )
{
	if(( m_potunmstr_TunerClientHandler== NULL )||( m_hNotTable_TunerMaster == NULL) || ( m_potunmstr_SrcChgManager== NULL ) )
	{

		NORMAL_M_ASSERT( m_potunmstr_TunerClientHandler != NULL );
		NORMAL_M_ASSERT( m_hNotTable_TunerMaster != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
		return;

	}
	tBool blTemp = FALSE;
	ahl_bEnterCritical( m_hNotTable_SemHandle );

	/* Post status message to all the registered clients. */
	for(ahl_tNotification* pNot = m_hNotTable_TunerMaster->poGetNotificationList(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_SOURCE_CHANGE) ;
			pNot != OSAL_NULL;
			pNot=pNot->pNext)
	{


		midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SOURCE_CHANGEStatus oMsgStatus;

		oMsgStatus.Source.enType = (midw_fi_tcl_e8_Source::tenType)u8Source;
		oMsgStatus.Action.enType = (midw_fi_tcl_e8_Action::tenType)u8Action;
		// to be done later
		ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _\
				TUNMSTR_TRACE_MSG_TO_HMI_SEND_SRCCHG_STATUS _\
				ET_EN_T8 _ oMsgStatus.Source.enType _\
				ET_EN_T8 _ oMsgStatus.Action.enType _\
				ET_EN_DONE );

		StSendCCAMsg oStSendCCAMsg;
		oStSendCCAMsg.u16DestAppID=pNot->u16AppID;
		//oStSendCCAMsg.oOutData=oMsgStatus;
		oStSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_SOURCE_CHANGE;
		oStSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_STATUS;
		oStSendCCAMsg.u16CmdCtr=pNot->u16CmdCounter;
		oStSendCCAMsg.u16RegID=pNot->u16RegisterID;
		// Send message to HMI
		vSendMessage( oStSendCCAMsg,oMsgStatus);

		if( ( (enTunmstrAction)u8Action == (tU8)TUNMSTR_SRCCHG_ACTION_ON ) && (((enTunmstrSource)u8Source == (tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA)||((enTunmstrSource)u8Source==(tU8)TUNMSTR_SRCCHG_SOURCE_DAB_TA)))
		{
			blTemp = TRUE;
			//m_potunmstr_SrcChg_AnnoHandler->vSetActiveAnnoSrc((enActiveAnnoSource)u16AnnoType);
			m_potunmstr_SrcChg_AnnoHandler->vSetTA_Anno_State(blTemp);
		}
		else if( ( (enTunmstrAction)u8Action == (tU8)TUNMSTR_SRCCHG_ACTION_OFF) && (((enTunmstrSource)u8Source == (tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA)|| ((enTunmstrSource)u8Source==(tU8)TUNMSTR_SRCCHG_SOURCE_DAB_TA)))
		{
			blTemp = FALSE;
			m_potunmstr_SrcChg_AnnoHandler->vSetTA_Anno_State(blTemp);
		}


	}//For Loop
	ahl_bReleaseCritical(m_hNotTable_SemHandle);

}

tVoid tunmstr_MsgToHMI::vUpdateAnnouncementStatusValues(tBool blAnno_Status, tU8 u8Source, tU8 u8AnnoType)
{
	bAnnouncementStatus = blAnno_Status;
	u8AnnouncementMainSource = u8Source;
	u8AnnouncementType = u8AnnoType;
}

/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vSend_g_TA_Announcement
 *
 *DESCRIPTION: This function will send TA Announcement property to HMI
 *
 *
 *
 *PARAMETER: tU8 u8Source, tU8 u8Action
 *
 *
 *
 *RETURNVALUE: None
 ********************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
tVoid tunmstr_MsgToHMI::vSend_g_Announcement_Status()
{
	vSend_g_Announcement_Status(bAnnouncementStatus, u8AnnouncementMainSource, u8AnnouncementType);
}
#endif

tVoid tunmstr_MsgToHMI::vSend_g_Announcement_Status( tBool blAnno_Status, tU8 u8Source, tU8 u8AnnoType )
{
	if(( m_potunmstr_TunerClientHandler== NULL )||( m_hNotTable_TunerMaster == NULL))
	{

		NORMAL_M_ASSERT( m_potunmstr_TunerClientHandler != NULL );
		NORMAL_M_ASSERT( m_hNotTable_TunerMaster != NULL );
		return;

	}

	ETG_TRACE_USR4(("tunmstr_MsgToHMI::vSend_g_TA_Announcement()u8Source=%d u8AnnoType=%d blAnno_Status=%d",u8Source,u8AnnoType,blAnno_Status));

	ahl_bEnterCritical( m_hNotTable_SemHandle );

	/* Post status message to all the registered clients. */
	for(ahl_tNotification* pNot = m_hNotTable_TunerMaster->poGetNotificationList(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_ANNOUNCEMENT_STATUS) ;
			pNot != OSAL_NULL;
			pNot=pNot->pNext)
	{


		midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNOUNCEMENT_STATUSStatus oMsgStatus;

		oMsgStatus.Source.enType = (midw_fi_tcl_e8_Source::tenType)u8Source;
		oMsgStatus.Anno_Status = blAnno_Status;
		oMsgStatus.Anno_Types.enType = (midw_fi_tcl_e8_AnnoTypes::tenType)u8AnnoType;
		// to be done later
		ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _\
				TUNMSTR_TRACE_MSG_TO_HMI_SEND_TA_ANNO_STATUS _\
				ET_EN_T8 _ oMsgStatus.Source.enType _\
				ET_EN_T8 _ oMsgStatus.Anno_Status _\
				ET_EN_DONE );

		StSendCCAMsg oStSendCCAMsg;
		oStSendCCAMsg.u16DestAppID=pNot->u16AppID;
		oStSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_ANNOUNCEMENT_STATUS;
		oStSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_STATUS;
		oStSendCCAMsg.u16CmdCtr=pNot->u16CmdCounter;
		oStSendCCAMsg.u16RegID=pNot->u16RegisterID;
		vSendMessage( oStSendCCAMsg,oMsgStatus);
		ETG_TRACE_USR4(("tunmstr_MsgToHMI::vSend_g_TA_Announcement()->Message sent successfully."));
	}//For Loop
	ahl_bReleaseCritical(m_hNotTable_SemHandle);
} /* if( m_potunmstr_TunerClientHandler ->bGet_SendMsgToTimaSwitch() ) */
/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vSend_g_TP_Status
 *
 *DESCRIPTION: This function will send TP Status of currently playing station
to HMI during 
 *PARAMETER: tBool blTP_Status
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_MsgToHMI::vSend_g_TP_Status( tBool blTP_Status , tU8 u8Source)
{
	if(( m_potunmstr_TunerClientHandler== NULL )||( m_hNotTable_TunerMaster == NULL))
	{

		NORMAL_M_ASSERT( m_potunmstr_TunerClientHandler != NULL );
		NORMAL_M_ASSERT( m_hNotTable_TunerMaster != NULL );

		ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _\
				TUNMSTR_TRACE_MSG_TO_HMI_ASSTER _\
				ET_EN_DONE );
		return;

	}

	if(u8Source == (tU8)midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_FM1)
		m_u8TunerTPStatus = blTP_Status;
	if(u8Source == (tU8)midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_DAB)
		m_u8DABTPStatus = blTP_Status;

	ahl_bEnterCritical( m_hNotTable_SemHandle );
	/* Post status message to all the registered clients. */
	for(ahl_tNotification* pNot = m_hNotTable_TunerMaster->poGetNotificationList(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_TP_STATUS) ;
			pNot != OSAL_NULL;
			pNot=pNot->pNext)
	{

		midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TP_STATUSStatus oMsgStatus;

		oMsgStatus.TP_STATE = blTP_Status;
		oMsgStatus.TP_Source.enType = (midw_fi_tcl_e8_Source::tenType)u8Source;
		// to be done later
		ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _\
				TUNMSTR_TRACE_MSG_TO_HMI_SEND_TP_STATUS _\
				ET_EN_T8 _ oMsgStatus.TP_STATE _\
				ET_EN_DONE );
		StSendCCAMsg oStSendCCAMsg;
		oStSendCCAMsg.u16DestAppID=pNot->u16AppID;
		oStSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_TP_STATUS;
		oStSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_STATUS;
		oStSendCCAMsg.u16CmdCtr=pNot->u16CmdCounter;
		oStSendCCAMsg.u16RegID=pNot->u16RegisterID;
		vSendMessage( oStSendCCAMsg,oMsgStatus);

	}//For Loop
	ahl_bReleaseCritical(m_hNotTable_SemHandle);
}
/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vSend_g_Band_Info
 *
 *DESCRIPTION: This function will send TP Status of currently playing station
to HMI during 
 *PARAMETER: tBool blTP_Status
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_MsgToHMI::vSend_g_Band_Info( tU8 u8SourceId, tBool bSetBandNone )
{
	ETG_TRACE_USR4(("tunmstr_MsgToHMI::vSend_g_Band_Info, SourceId= %d", u8SourceId));
	if(( m_potunmstr_TunerClientHandler== NULL )||( m_hNotTable_TunerMaster == NULL))
	{

		NORMAL_M_ASSERT( m_potunmstr_TunerClientHandler != NULL );
		NORMAL_M_ASSERT( m_hNotTable_TunerMaster != NULL );

		ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _\
				TUNMSTR_TRACE_MSG_TO_HMI_ASSTER _\
				ET_EN_DONE );
		return;

	}
	midw_fi_tcl_e8_Band::tenType enHMIBand = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_NONE ;
	// This logic is introduced to block update of other source info to HMI, as HMI would require only Active Band Info
	switch (u8SourceId)
	{
	case TUNMSTR_SRCCHG_SOURCE_TUN1FM:
	{
		enHMIBand = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_FM;
	}break;
	case TUNMSTR_SRCCHG_SOURCE_TUN1AM:
	{
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
			if(m_potunmstr_TunerClientHandler->u8GetActiveStationinfoBand() == TUNMSTR_SRCCHG_BAND_AM)
			{
				enHMIBand = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_MW;
			}
			else if(m_potunmstr_TunerClientHandler->u8GetActiveStationinfoBand() == TUNMSTR_SRCCHG_BAND_LW)
			{
				enHMIBand = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_LW;
			}
			else
			{
				// send band info on receiving ATStationInfo
			}
#else
			enHMIBand = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_MW;
#endif
	}break;
   case TUNMSTR_SRCCHG_SOURCE_DRM:
   {
	   enHMIBand = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_CB1;
   }
   break;
	case TUNMSTR_SRCCHG_SOURCE_DAB:
	{
		enHMIBand = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_DAB;
	}break;
	case TUNMSTR_SRCCHG_SOURCE_NON_RADIO:
	{
		enHMIBand = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_NONE;
	}break;
	case TUNMSTR_SRCCHG_SOURCE_TUN2:
	case TUNMSTR_SRCCHG_SOURCE_FM_TA:
	case TUNMSTR_SRCCHG_SOURCE_DAB_TA:
	case TUNMSTR_SRCCHG_SOURCE_DAB_FM_SF:
	case TUNMSTR_SRCCHG_SOURCE_NO_TA:
	//case TUNMSTR_SRCCHG_SOURCE_TUN3:
	//case TUNMSTR_SRCCHG_SOURCE_TUN4:
	default:
		break;
	}// end of switch
	/* Post status message to all the registered clients. */
	if(enHMIBand == midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_NONE)
	{
		ETG_TRACE_USR4(("tunmstr_MsgToHMI::vSend_g_Band_Info-> No need to update Band Info to HMI"));
		return;
	}
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
	/* PSARCCB-9100: required for SRCOFF requests */
	if(bSetBandNone == true)
	{
		enHMIBand = midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_NONE;
	}
#else
	bSetBandNone = false;
#endif
	ahl_bEnterCritical( m_hNotTable_SemHandle );
	ETG_TRACE_USR4(("tunmstr_MsgToHMI::vSend_g_Band_Info u8HMIBand = %d bSetBandNone=%d", enHMIBand,bSetBandNone));
	for(ahl_tNotification* pNot = m_hNotTable_TunerMaster->poGetNotificationList(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_BAND_INFO) ;
			pNot != OSAL_NULL;
			pNot=pNot->pNext)
	{

		midw_tunermasterfi_tclMsgFID_TUNMSTR_G_BAND_INFOStatus oMsgStatus;
		oMsgStatus.Band.enType = enHMIBand;
		// to be done later
		ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _\
				TUNMSTR_TRACE_MSG_TO_HMI_SEND_BAND_INFO _\
				ET_EN_T8 _ oMsgStatus.Band.enType _\
				ET_EN_DONE );
		StSendCCAMsg oStSendCCAMsg;
		oStSendCCAMsg.u16DestAppID=pNot->u16AppID;
		oStSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_BAND_INFO;
		oStSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_STATUS;
		oStSendCCAMsg.u16CmdCtr=pNot->u16CmdCounter;
		oStSendCCAMsg.u16RegID=pNot->u16RegisterID;
		vSendMessage( oStSendCCAMsg,oMsgStatus);

	}//For Loop
	ahl_bReleaseCritical(m_hNotTable_SemHandle);
}

/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vSend_g_Tuner_Source_Availability_status
 *
 *DESCRIPTION: This function will send info about Source availability to the registered clients

 *PARAMETER:
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_MsgToHMI::vSend_g_Tuner_Source_Availability_status(tBool bIsUpreg)
{
#ifdef INCLUDE_PROFILE_MANAGER
	if(( m_potunmstr_TunerClientHandler== NULL )||( m_hNotTable_TunerMaster == NULL)||(m_poPMClient == NULL))
#else
	if(( m_potunmstr_TunerClientHandler== NULL )||( m_hNotTable_TunerMaster == NULL))
#endif
	{
		NORMAL_M_ASSERT( m_potunmstr_TunerClientHandler != NULL );
		NORMAL_M_ASSERT( m_hNotTable_TunerMaster != NULL );
#ifdef INCLUDE_PROFILE_MANAGER
		NORMAL_M_ASSERT( m_poPMClient != NULL );
#endif
		ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _\
				TUNMSTR_TRACE_MSG_TO_HMI_ASSTER _\
				ET_EN_DONE );
		return;
	}
#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
		dp_tclTmcTunerUsrDPAMAvailability oTmcTunerDPAMAvailability ;

		ETG_TRACE_USR4(( "AMAvailability=%d bIsUpreg=%d",oTmcTunerDPAMAvailability.tGetData(),bIsUpreg));

		tBool bTmcTunerDPAMAvailStatus = true;
		oTmcTunerDPAMAvailability.s32GetData(bTmcTunerDPAMAvailStatus);

#endif
	ahl_bEnterCritical( m_hNotTable_SemHandle );
	for(ahl_tNotification* pNot = m_hNotTable_TunerMaster->poGetNotificationList(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITY) ;
			pNot != OSAL_NULL;
			pNot=pNot->pNext)
	{
		midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITYStatus oMsgStatus;
		oMsgStatus.Source.enType = midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_AM;
#ifndef VARIANT_S_FTR_ENABLE_AMT_MOCK
		oMsgStatus.Available = bTmcTunerDPAMAvailStatus;
#endif
		StSendCCAMsg oStSendCCAMsg;
		oStSendCCAMsg.u16DestAppID=pNot->u16AppID;
		oStSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITY;
		oStSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_STATUS;
		oStSendCCAMsg.u16CmdCtr=pNot->u16CmdCounter;
		oStSendCCAMsg.u16RegID=pNot->u16RegisterID;
		vSendMessage( oStSendCCAMsg,oMsgStatus);
	}//For Loop
	ahl_bReleaseCritical(m_hNotTable_SemHandle);
#ifdef INCLUDE_PROFILE_MANAGER
	if(!bIsUpreg)
	{
		midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus oStatusMessage;
		oStatusMessage.RadioProfileSettingAction.u8Value = 02;
		oStatusMessage.AMSwitch = bTmcTunerDPAMAvailStatus;
		/**/

		if(!oStatusMessage.AMSwitch)
			m_poPMClient->vClearAMPresetsWhenDisableAM();
		vSend_g_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATION_Status(oStatusMessage);
	}
#endif
}

/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vSend_s_TunerInfo
 *
 *DESCRIPTION: Send Tuner info to fc_Diagnosis
 *
 *PARAMETER:tU8 u8Tun_Header
 *
 *
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_MsgToHMI::vSend_s_TunerInfo(tU8 u8TunerIndex)
{
	if( (m_hNotTable_SemHandle == 0) || (m_potunmstr_MsgFromHMI == NULL))

	{
		NORMAL_M_ASSERT( m_hNotTable_SemHandle != 0 );
		NORMAL_M_ASSERT( m_potunmstr_MsgFromHMI != NULL );
		ETG_TRACE_USR4(("tunmstr_MsgToHMI::vSend_s_TunerInfo, Null Pointer"));
		return;
	}// if
	ahl_bEnterCritical( m_hNotTable_SemHandle );
	/* Post status message to all the registered clients. */
	midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_ACTIVETUNER_INFOMethodResult oMsgResult;

	oMsgResult.TunerMaster_StatusResponse.u8TunermasterStatus.enType =(midw_fi_tcl_e8_TunMstr_ResponseStatus::tenType) TUNMSTR_SRCCHG_RES_REQ_SUCCEED;
	oMsgResult.WhichTuner.enType = (midw_fi_tcl_e8_WhichTuner::tenType)u8TunerIndex;
	StSendCCAMsg oStSendCCAMsg;
	oStSendCCAMsg.u16DestAppID=m_potunmstr_MsgFromHMI->u16GetActiveTuner_APPID();
	oStSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_GET_ACTIVETUNER_INFO;
	oStSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
	oStSendCCAMsg.u16CmdCtr=m_potunmstr_MsgFromHMI->u16GetCmdCntr();
	oStSendCCAMsg.u16RegID=m_potunmstr_MsgFromHMI->u16GetRegID();
	vSendMessage( oStSendCCAMsg,oMsgResult);
	ETG_TRACE_USR4(("tunmstr_MsgToHMI::vSend_s_TunerInfo, Message sent"));
	ahl_bReleaseCritical(m_hNotTable_SemHandle);
}

/*******************************************************************************
 *
 *DESCRIPTION: Funtion to handle property FID_TUNMSTR_G_PRESET_LIST
 *
 *PARAMETER:	midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus oStatus
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_MsgToHMI::vSend_g_PresetListStatus(midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus oStatus)
{
	if(( m_hNotTable_TunerMaster == NULL))
	{
		NORMAL_M_ASSERT( m_hNotTable_TunerMaster != NULL );
		return;
	}
	ETG_TRACE_USR4(("PresetList::Update to HMI listsize:%d",(int) oStatus.ListOfStations.size()));
	for(tU8 u8index = 0 ; u8index < oStatus.ListOfStations.size() ; u8index++)
	{
		ETG_TRACE_USR4(("PresetList::Update to HMI*************at Element%d ****************",oStatus.ListOfStations.at(u8index).Element_ID));
		ETG_TRACE_USR4(("PresetList::Update to HMI->Frequency: %d Band:%d",oStatus.ListOfStations.at(u8index).Frequency, oStatus.ListOfStations.at(u8index).Band.enType));
		ETG_TRACE_USR4(("PresetList::Update to HMI->PSName:%s ",oStatus.ListOfStations.at(u8index).PSName.szGet(midw_fi_tclString::FI_EN_UTF8)));
		ETG_TRACE_USR4(("PresetList::Update to HMI->EnsembleName:%s",oStatus.ListOfStations.at(u8index).EnsembleName.szGet(midw_fi_tclString::FI_EN_UTF8)));
		ETG_TRACE_USR4(("PresetList::Update to HMI->FrequencyLabel:%s",oStatus.ListOfStations.at(u8index).Frequency_Label.szGet(midw_fi_tclString::FI_EN_UTF8)));
		ETG_TRACE_USR4(("PresetList::Update to HMI->ServiceID:%d",oStatus.ListOfStations.at(u8index).SXMSMSlib_PresetListEntry.ServiceID));
		ETG_TRACE_USR4(("PresetList::Update to HMI->ChannelID:%d",oStatus.ListOfStations.at(u8index).SXMSMSlib_PresetListEntry.ChannelID));
		ETG_TRACE_USR4(("PresetList::Update to HMI->ChannelName_smslib:%s",oStatus.ListOfStations.at(u8index).SXMSMSlib_PresetListEntry.ChannelName.szGet(midw_fi_tclString::FI_EN_UTF8)));
		ETG_TRACE_USR4(("PresetList::Update to HMI->ChannelName_360L:%s",oStatus.ListOfStations.at(u8index).SXM360L_PresetListEntry.Name.szGet(midw_fi_tclString::FI_EN_UTF8)));
		ETG_TRACE_USR4(("PresetList::Update to HMI->PDT:%s",oStatus.ListOfStations.at(u8index).SXM360L_PresetListEntry.PDT.szGet(midw_fi_tclString::FI_EN_UTF8)));

	}

	ahl_bEnterCritical( m_hNotTable_SemHandle );
	/* Post status message to all the registered clients. */
	for(ahl_tNotification* pNot = m_hNotTable_TunerMaster->poGetNotificationList(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_PRESET_LIST) ;
			pNot != OSAL_NULL;
			pNot=pNot->pNext)
	{
		StSendCCAMsg oStSendCCAMsg;
		oStSendCCAMsg.u16DestAppID=pNot->u16AppID;
		oStSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_PRESET_LIST;
		oStSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_STATUS;
		oStSendCCAMsg.u16CmdCtr=pNot->u16CmdCounter;
		oStSendCCAMsg.u16RegID=pNot->u16RegisterID;
		vSendMessage( oStSendCCAMsg,oStatus);
	}
	ahl_bReleaseCritical(m_hNotTable_SemHandle);
}

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
/*******************************************************************************
 *
 *DESCRIPTION: Function to handle property FID_TUNMSTR_G_PRESET_CHANNEL_UPDATE
 *
 *PARAMETER:	midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus oStatus
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_MsgToHMI::vSend_g_PresetChannelUpdate(midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_CHANNEL_UPDATEStatus oStatus)
{
	if(( m_hNotTable_TunerMaster == NULL))
	{
		NORMAL_M_ASSERT( m_hNotTable_TunerMaster != NULL );
		return;
	}

	ETG_TRACE_USR4(("PresetList::Update to HMI*************at Element%d ****************",oStatus.PresetIndex));
	ETG_TRACE_USR4(("PresetList::Update to HMI->PresetBand:%d",oStatus.PresetBand));
	ETG_TRACE_USR4(("PresetList::Update to HMI->LinearPresetIndex:%d",oStatus.LinearPresetIndex));
	ETG_TRACE_USR4(("PresetList::Update to HMI->ServiceID:%d",oStatus.ChannelInfo.ServiceID));
	ETG_TRACE_USR4(("PresetList::Update to HMI->ChannelID:%d",oStatus.ChannelInfo.ChannelID));

	ahl_bEnterCritical( m_hNotTable_SemHandle );
	/* Post status message to all the registered clients. */
	for(ahl_tNotification* pNot = m_hNotTable_TunerMaster->poGetNotificationList(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_PRESET_CHANNEL_UPDATE) ;
			pNot != OSAL_NULL;
			pNot=pNot->pNext)
	{
		StSendCCAMsg oStSendCCAMsg;
		oStSendCCAMsg.u16DestAppID=pNot->u16AppID;
		oStSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_PRESET_CHANNEL_UPDATE;
		oStSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_STATUS;
		oStSendCCAMsg.u16CmdCtr=pNot->u16CmdCounter;
		oStSendCCAMsg.u16RegID=pNot->u16RegisterID;
		vSendMessage( oStSendCCAMsg,oStatus);
	}
	ahl_bReleaseCritical(m_hNotTable_SemHandle);
}


/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vSend_g_SystemMessage
 *
 *DESCRIPTION: Function to handle property FID_TUNMSTR_G_SXM_SYSTEM_MESSAGE
 *
 *PARAMETER:	tU8 u8SystemErrorType , tU16 u16ChannelNumber
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_MsgToHMI::vSend_g_SystemMessage(tU8 u8SystemErrorType , tU16 u16ChannelNumber)
{
	if(( m_hNotTable_TunerMaster == NULL))
	{
		NORMAL_M_ASSERT( m_hNotTable_TunerMaster != NULL );
		return;
	}

	ahl_bEnterCritical( m_hNotTable_SemHandle );
	/* Post status message to all the registered clients. */
	for(ahl_tNotification* pNot = m_hNotTable_TunerMaster->poGetNotificationList(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_SXM_SYSTEM_MESSAGE) ;
			pNot != OSAL_NULL;
			pNot=pNot->pNext)
	{
		midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_SYSTEM_MESSAGEStatus oStatus;
		oStatus.SystemErrorType.enType = (midw_fi_tcl_e8_SXMSystemMessage::tenType)u8SystemErrorType;
		oStatus.CID = u16ChannelNumber;
		StSendCCAMsg oStSendCCAMsg;
		oStSendCCAMsg.u16DestAppID=pNot->u16AppID;
		oStSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_SXM_SYSTEM_MESSAGE;
		oStSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_STATUS;
		oStSendCCAMsg.u16CmdCtr=pNot->u16CmdCounter;
		oStSendCCAMsg.u16RegID=pNot->u16RegisterID;
		vSendMessage( oStSendCCAMsg,oStatus);
	}
	ahl_bReleaseCritical(m_hNotTable_SemHandle);
}
#endif


/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vSend_g_PresetAutoCompare
 *
 *DESCRIPTION: Function to handle property FID_TUNMSTR_G_PRESET_AUTOCOMPARE
 *
 *PARAMETER:	tU8 u8PresetAutoCompare
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_MsgToHMI::vSend_g_PresetAutoCompare(tU8 u8PresetAutoCompare, tBool bUserPresetAction)
{
	if(( m_hNotTable_TunerMaster == NULL))
	{
		NORMAL_M_ASSERT( m_hNotTable_TunerMaster != NULL );
		return;
	}

	ETG_TRACE_USR4(("vSend_g_PresetAutoCompare(), u8PresetAutoCompare : %d, bUserPresetAction : %d", u8PresetAutoCompare, bUserPresetAction));
	m_u8ActivePreset = u8PresetAutoCompare;

	ahl_bEnterCritical( m_hNotTable_SemHandle );
	/* Post status message to all the registered clients. */
	for(ahl_tNotification* pNot = m_hNotTable_TunerMaster->poGetNotificationList(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_PRESET_AUTOCOMPARE);
			pNot != OSAL_NULL;
			pNot=pNot->pNext)
	{
		midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_AUTOCOMPAREStatus oStatus;
		oStatus.PresetAutocompare = u8PresetAutoCompare;
		oStatus.bUserPresetAction = bUserPresetAction;
		StSendCCAMsg oStSendCCAMsg;
		oStSendCCAMsg.u16DestAppID=pNot->u16AppID;
		oStSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_PRESET_AUTOCOMPARE;
		oStSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_STATUS;
		oStSendCCAMsg.u16CmdCtr=pNot->u16CmdCounter;
		oStSendCCAMsg.u16RegID=pNot->u16RegisterID;
		vSendMessage( oStSendCCAMsg,oStatus);
	}
	ahl_bReleaseCritical(m_hNotTable_SemHandle);
}


/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::u8GetActivePreset
 *
 *DESCRIPTION: Function to return active preset number
 *
 *PARAMETER:
 *
 *RETURNVALUE: tU8
 ********************************************************************************/
tU8 tunmstr_MsgToHMI::u8GetActivePreset()
{
	return m_u8ActivePreset;
}


/*********************************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vSend_g_TunerDomainAvailabilityStatus
 *
 *DESCRIPTION: Funtion to handle property FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITY
 *
 *PARAMETER:	midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus oStatus
 *
 *RETURNVALUE: tVoid
 *********************************************************************************************/
tVoid tunmstr_MsgToHMI::vSend_g_TunerDomainAvailabilityStatus()
{
	ETG_TRACE_USR4(("vSend_g_TunerDomainAvailabilityStatus()"));

	if(( m_hNotTable_TunerMaster == NULL) || (NULL == m_potunmstr_DABClient_Handler) || (NULL == m_potunmstr_TunerClientHandler))
	{
		NORMAL_M_ASSERT( m_hNotTable_TunerMaster != NULL );
		ETG_TRACE_USR4(("vSend_g_TunerDomainAvailabilityStatus()->assert"));
		return;
	}
		midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus oStatus;
		if((!m_potunmstr_DABClient_Handler->u8GetDABServiceState()) && (!m_potunmstr_TunerClientHandler->u8GetTunerService()))
		{
			oStatus.TunerAvailability.enType = midw_fi_tcl_e8_TunerAvailability::FI_EN_TUNMSTR_BOTH_TUNER_NOT_AVAILABLE;
		}
		else if((!m_potunmstr_DABClient_Handler->u8GetDABServiceState()) && (m_potunmstr_TunerClientHandler->u8GetTunerService()))
		{
			oStatus.TunerAvailability.enType = midw_fi_tcl_e8_TunerAvailability::FI_EN_TUNMSTR_FM_TUNER_NOW_AVAILABLE;
		}
		else if((m_potunmstr_DABClient_Handler->u8GetDABServiceState()) && (!m_potunmstr_TunerClientHandler->u8GetTunerService()))
		{
			oStatus.TunerAvailability.enType = midw_fi_tcl_e8_TunerAvailability::FI_EN_TUNMSTR_DAB_TUNER_NOW_AVAILABLE;
		}
		else
		{
			oStatus.TunerAvailability.enType = midw_fi_tcl_e8_TunerAvailability::FI_EN_TUNMSTR_BOTH_TUNER_NOW_AVAILABLE;
		}
	ahl_bEnterCritical( m_hNotTable_SemHandle );
	/* Post status message to all the registered clients. */
	for(ahl_tNotification* pNot = m_hNotTable_TunerMaster->poGetNotificationList(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITY) ;
			pNot != OSAL_NULL;
			pNot=pNot->pNext)
	{
		StSendCCAMsg oStSendCCAMsg;
		oStSendCCAMsg.u16DestAppID=pNot->u16AppID;
		oStSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITY;
		oStSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_STATUS;
		oStSendCCAMsg.u16CmdCtr=pNot->u16CmdCounter;
		oStSendCCAMsg.u16RegID=pNot->u16RegisterID;
		vSendMessage( oStSendCCAMsg,oStatus);
	}
	ahl_bReleaseCritical(m_hNotTable_SemHandle);
}

/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vSend_g_Activate_Anno
 *
 *DESCRIPTION: Send Anno Button
 *
 *PARAMETER:tU8 u8Tun_Header
 *
 *
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_MsgToHMI:: vSend_g_AnnoButton_Status(tU8 u8Source, tU32 u32AnnoType)
{
	if( (m_hNotTable_SemHandle == 0) ||  (m_hNotTable_TunerMaster == NULL)
			|| (m_poclConfigInterface == NULL))

	{
		NORMAL_M_ASSERT( m_hNotTable_SemHandle != 0 );
		NORMAL_M_ASSERT( m_hNotTable_TunerMaster != NULL );
		NORMAL_M_ASSERT( m_poclConfigInterface != NULL );
		ETG_TRACE_USR4(("tunmstr_MsgToHMI::vSend_g_Activate_Anno, Null Pointer"));
		return;
	}// if
	tBool bDABavail = (tBool)m_poclConfigInterface->u32GetConfigData("DABSupported");
#ifndef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
	if((u8Source == (tU8)TUNMSTR_SRCCHG_SOURCE_DAB) && (!bDABavail))
#else
	if((m_poArlImpl->getActiveSource() == tuner::common::DAB) && (!bDABavail))
#endif
	{
		ETG_TRACE_USR4(("tunmstr_MsgToHMI::vSend_g_AnnoButton_Status, DAB not available"));
	}
	else
	{
	ahl_bEnterCritical( m_hNotTable_SemHandle );

	/* Post status message to all the registered clients. */
	for(ahl_tNotification* pNot = m_hNotTable_TunerMaster->poGetNotificationList(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_ANNO_BUTTON_STATUS) ;
			pNot != OSAL_NULL;
			pNot=pNot->pNext)
	{
		midw_tunermasterfi_tclMsgFID_TUNMSTR_G_ANNO_BUTTON_STATUSStatus oMsg;

		oMsg.Source.enType = (midw_fi_tcl_e8_Source::tenType)u8Source;
		oMsg.b32AnnouncementType.u32Value = u32AnnoType;

		StSendCCAMsg oStSendCCAMsg;
		oStSendCCAMsg.u16DestAppID=pNot->u16AppID;
		oStSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_ANNO_BUTTON_STATUS;
		oStSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_STATUS;
		oStSendCCAMsg.u16CmdCtr=pNot->u16CmdCounter;
		oStSendCCAMsg.u16RegID=pNot->u16RegisterID;
		vSendMessage( oStSendCCAMsg,oMsg);
	}
	ETG_TRACE_USR4(("tunmstr_MsgToHMI::vSend_s_TunerInfo, Message sent"));
	ahl_bReleaseCritical(m_hNotTable_SemHandle);
	}
}

/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vSend_g_GetAutostoreStatus
 *
 *DESCRIPTION: Send autostore property update to HMI
 *
 *PARAMETER:   oStatus
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_MsgToHMI::vSend_g_GetAutostoreStatus(tBool bAST_State , tU8 u8AST_Type)
{
    ETG_TRACE_USR4(("tunmstr_MsgToHMI::vSend_g_GetAutostoreStatus, send status update"));

    if( (m_hNotTable_SemHandle == 0) || (m_hNotTable_TunerMaster == NULL))
    {
        NORMAL_M_ASSERT( m_hNotTable_SemHandle != 0 );
        NORMAL_M_ASSERT( m_hNotTable_TunerMaster != NULL );
        ETG_TRACE_USR4(("tunmstr_MsgToHMI::vSend_g_GetAutostoreStatus, Null Pointer"));
        return;
    }// if
    ahl_bEnterCritical( m_hNotTable_SemHandle );

    midw_tunermasterfi_tclMsgFID_TUNMSTR_G_GET_AUTOSTORE_STATUSStatus oAutostoreStatus;
    oAutostoreStatus.Autostore_State = bAST_State;
    oAutostoreStatus.AST_Type.enType = (midw_fi_tcl_e8_AST_Types::tenType)u8AST_Type;

    ETG_TRACE_USR4(("tunmstr_AutoStoreHandler::vSend_g_GetAutostoreStatus update sent with values\
                    AutostoreState(0-inactive, 1-active) = %d  AutostoreType(0-normal, 1-initial) = %x", \
                    oAutostoreStatus.Autostore_State , oAutostoreStatus.AST_Type.enType));

    /* Post status message to all the registered clients. */
    for(ahl_tNotification* pNot = m_hNotTable_TunerMaster->poGetNotificationList(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_GET_AUTOSTORE_STATUS) ;
            pNot != OSAL_NULL;
            pNot=pNot->pNext)
    {
        StSendCCAMsg oStSendCCAMsg;
        oStSendCCAMsg.u16DestAppID=pNot->u16AppID;
        oStSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_GET_AUTOSTORE_STATUS;
        oStSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_STATUS;
        oStSendCCAMsg.u16CmdCtr=pNot->u16CmdCounter;
        oStSendCCAMsg.u16RegID=pNot->u16RegisterID;
        vSendMessage( oStSendCCAMsg,oAutostoreStatus);
    }
    ETG_TRACE_USR4(("tunmstr_MsgToHMI::vSend_g_GetAutostoreStatus, Message sent"));
    ahl_bReleaseCritical(m_hNotTable_SemHandle);
}

/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vSendMTC_SetMode_status
 *
 *DESCRIPTION: Send SetMode property update to HMI
 *
 *PARAMETER:   u8Mode
 *
 *RETURNVALUE: None
 *AUTHOR: Vinay Nadagoud ECV2 17.12.2014
 ********************************************************************************/
tVoid tunmstr_MsgToHMI::vSendMTC_SetMode_status(tU8 u8Mode)
{
    ETG_TRACE_USR4(("tunmstr_MsgToHMI::vSendMTC_SetMode_status, send status update"));

    if( (m_hNotTable_SemHandle == 0) || (m_hNotTable_TunerMaster == NULL))
    {
        NORMAL_M_ASSERT( m_hNotTable_SemHandle != 0 );
        NORMAL_M_ASSERT( m_hNotTable_TunerMaster != NULL );
        ETG_TRACE_USR4(("tunmstr_MsgToHMI::vSendMTC_SetMode_status, Null Pointer"));
        return;
    }// if
    ahl_bEnterCritical( m_hNotTable_SemHandle );

    midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus oMTCSetModeStatus;
    oMTCSetModeStatus.Mode.u8Value = u8Mode;

	ETG_TRACE_USR4(("tunmstr_MsgToHMI::vSendMTC_SetMode_status, u8Mode = %d",u8Mode));

    /* Post status message to all the registered clients. */
    for(ahl_tNotification* pNot = m_hNotTable_TunerMaster->poGetNotificationList(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_MTC_SETMODE_STATUS) ;
            pNot != OSAL_NULL;
            pNot=pNot->pNext)
    {
        StSendCCAMsg oStSendCCAMsg;
        oStSendCCAMsg.u16DestAppID=pNot->u16AppID;
        oStSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_MTC_SETMODE_STATUS;
        oStSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_STATUS;
        oStSendCCAMsg.u16CmdCtr=pNot->u16CmdCounter;
        oStSendCCAMsg.u16RegID=pNot->u16RegisterID;
        vSendMessage( oStSendCCAMsg,oMTCSetModeStatus);
    }
   ahl_bReleaseCritical(m_hNotTable_SemHandle);
}


/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vSendMTC_Surveilance_StationStatus
 *
 *DESCRIPTION: Send Surveilance station status property update to HMI
 *
 *PARAMETER:   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSStatus
 *
 *RETURNVALUE: None
 *AUTHOR: Vinay Nadagoud ECV2 17.12.2014
 ********************************************************************************/
tVoid tunmstr_MsgToHMI::vSendMTC_Surveilance_StationStatus(\
	midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUSStatus oMTCSurveilanceStatus)
{
    ETG_TRACE_USR4(("tunmstr_MsgToHMI::vSendMTC_Surveilance_StationStatus, send status update"));

    if( (m_hNotTable_SemHandle == 0) || (m_hNotTable_TunerMaster == NULL))
    {
        NORMAL_M_ASSERT( m_hNotTable_SemHandle != 0 );
        NORMAL_M_ASSERT( m_hNotTable_TunerMaster != NULL );
        ETG_TRACE_USR4(("tunmstr_MsgToHMI::vSendMTC_Surveilance_StationStatus, Null Pointer"));
        return;
    }// if
    ahl_bEnterCritical( m_hNotTable_SemHandle );

     /* Post status message to all the registered clients. */
    for(ahl_tNotification* pNot = m_hNotTable_TunerMaster->poGetNotificationList(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUS) ;
            pNot != OSAL_NULL;
            pNot=pNot->pNext)
    {
        StSendCCAMsg oStSendCCAMsg;
        oStSendCCAMsg.u16DestAppID=pNot->u16AppID;
        oStSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUS;
        oStSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_STATUS;
        oStSendCCAMsg.u16CmdCtr=pNot->u16CmdCounter;
        oStSendCCAMsg.u16RegID=pNot->u16RegisterID;
        vSendMessage( oStSendCCAMsg,oMTCSurveilanceStatus);
    }
   ahl_bReleaseCritical(m_hNotTable_SemHandle);
}

/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::u8GetTunerTPStatus
 *
 *DESCRIPTION: Tuner TP Status
 *
 *PARAMETER:
 *
 *
 *
 *RETURNVALUE: tU8
 ********************************************************************************/
tU8 tunmstr_MsgToHMI:: u8GetTunerTPStatus()
{
	ETG_TRACE_USR4(("tunmstr_MsgToHMI::u8GetTunerTPStatus : %d", m_u8TunerTPStatus));
	return m_u8TunerTPStatus;
}

/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::u8GetTunerTPStatus
 *
 *DESCRIPTION: Tuner TP Status
 *
 *PARAMETER:
 *
 *
 *
 *RETURNVALUE: tU8
 ********************************************************************************/
tU8 tunmstr_MsgToHMI:: u8GetDABTPStatus()
{
	ETG_TRACE_USR4(("tunmstr_MsgToHMI::u8GetDABTPStatus : %d", m_u8DABTPStatus));
	return m_u8DABTPStatus;
}

#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vHandleSXM360LPresetRequest
 *
 *DESCRIPTION: Handle SXM 360L preset requests
 *
 *PARAMETER:   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus oStatus
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_MsgToHMI::vHandleSXM360LPresetRequest(midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus oStatus)
{

	ETG_TRACE_USR4(("tunmstr_MsgToHMI::vHandleSXM360LPresetRequest, send status update"));

    if( (m_hNotTable_SemHandle == 0) || (m_hNotTable_TunerMaster == NULL))
    {
        NORMAL_M_ASSERT( m_hNotTable_SemHandle != 0 );
        NORMAL_M_ASSERT( m_hNotTable_TunerMaster != NULL );
        ETG_TRACE_USR4(("tunmstr_MsgToHMI::vHandleSXM360LPresetRequest, Null Pointer"));
        return;
    }

	ahl_bEnterCritical( m_hNotTable_SemHandle );
	/* Post status message to all the registered clients. */
	for(ahl_tNotification* pNot = m_hNotTable_TunerMaster->poGetNotificationList(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_SXM_PRESET_HANDLING) ;
			pNot != OSAL_NULL;
			pNot=pNot->pNext)
	{
		StSendCCAMsg oStSendCCAMsg;
		oStSendCCAMsg.u16DestAppID=pNot->u16AppID;
		oStSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_SXM_PRESET_HANDLING;
		oStSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_STATUS;
		oStSendCCAMsg.u16CmdCtr=pNot->u16CmdCounter;
		oStSendCCAMsg.u16RegID=pNot->u16RegisterID;
		vSendMessage( oStSendCCAMsg,oStatus);
	}
	ahl_bReleaseCritical(m_hNotTable_SemHandle);

}


/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vSend_SXM360LUserProfileActions
 *
 *DESCRIPTION:
 *
 *PARAMETER: 	midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus oStatus
 *
 *RETURNVALUE: 	None
 ********************************************************************************/
tVoid tunmstr_MsgToHMI::vSend_SXM360LUserProfileActions(midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus oStatus)
{
	if( m_hNotTable_TunerMaster == NULL )
	{

		NORMAL_M_ASSERT( m_hNotTable_TunerMaster != NULL );

		ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _\
				TUNMSTR_TRACE_MSG_TO_HMI_ASSTER _\
				ET_EN_DONE );
		return;

	}

	ahl_bEnterCritical( m_hNotTable_SemHandle );
	/* Post status message to all the registered clients. */
	for(ahl_tNotification* pNot = m_hNotTable_TunerMaster->poGetNotificationList(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_SXM_USERPROFILE) ;
			pNot != OSAL_NULL;
			pNot=pNot->pNext)
	{

		StSendCCAMsg oStSendCCAMsg;
		oStSendCCAMsg.u16DestAppID=pNot->u16AppID;
		oStSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_SXM_USERPROFILE;
		oStSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_STATUS;
		oStSendCCAMsg.u16CmdCtr=pNot->u16CmdCounter;
		oStSendCCAMsg.u16RegID=pNot->u16RegisterID;
		vSendMessage( oStSendCCAMsg,oStatus);

	}//For Loop
	ahl_bReleaseCritical(m_hNotTable_SemHandle);
}

#endif

/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vSend_g_TUNMSTR_G_RADIOPROFILE_SETTINGSStatus
 *
 *
 *
 *PARAMETER:   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTINGSStatus
 *
 *RETURNVALUE: None
 *AUTHOR: mhv6kor
 ********************************************************************************/
#ifdef INCLUDE_PROFILE_MANAGER
#if 0
tVoid tunmstr_MsgToHMI::vSend_g_TUNMSTR_G_RADIOPROFILE_SETTINGSStatus(midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTINGSStatus oRadioProfileSettingsStatus)
{

        vSendMessage( m_StPMAppData,oRadioProfileSettingsStatus);

}
#endif
/*******************************************************************************
 *FUNCTION:    tunmstr_MsgToHMI::vSend_g_TUNMSTR_G_RADIOPROFILE_SETTINGSStatus
 *
 *
 *
 *PARAMETER:   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTINGSStatus
 *
 *RETURNVALUE: None
 *AUTHOR: mhv6kor
 ********************************************************************************/
tVoid tunmstr_MsgToHMI::vSend_g_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATION_Status(midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus oRadioProfileSettingsStatus)
{


    ETG_TRACE_USR4(("tunmstr_MsgToHMI::vSend_g_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATION_Status, send status update"));

    if( (m_hNotTable_SemHandle == 0) || (m_hNotTable_TunerMaster == NULL))
    {
        NORMAL_M_ASSERT( m_hNotTable_SemHandle != 0 );
        NORMAL_M_ASSERT( m_hNotTable_TunerMaster != NULL );
        ETG_TRACE_USR4(("tunmstr_MsgToHMI::vSend_g_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATION_Status, Null Pointer"));
        return;
    }// if
    ahl_bEnterCritical( m_hNotTable_SemHandle );

     /* Post status message to all the registered clients. */
    for(ahl_tNotification* pNot = m_hNotTable_TunerMaster->poGetNotificationList(MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATION) ;
            pNot != OSAL_NULL;
            pNot=pNot->pNext)
    {
        StSendCCAMsg oStSendCCAMsg;
        oStSendCCAMsg.u16DestAppID=pNot->u16AppID;
        oStSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATION;
        oStSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_STATUS;
        oStSendCCAMsg.u16CmdCtr=pNot->u16CmdCounter;
        oStSendCCAMsg.u16RegID=pNot->u16RegisterID;
        vSendMessage( oStSendCCAMsg,oRadioProfileSettingsStatus);
    }
   ahl_bReleaseCritical(m_hNotTable_SemHandle);


}


/*************************************************************************
* FUNCTION:    vSet_tunmstr_PMClient_Ptr
*
* DESCRIPTION:
*
* PARAMETER:   (tunermaster_PMClient* poPMClientPtr)
*
* RETURNVALUE:  void
*************************************************************************/
tVoid tunmstr_MsgToHMI::vSet_tunmstr_PMClient_Ptr(tunermaster_PMClient* poPMClientPtr)
{
	if( poPMClientPtr != NULL )
	{
		m_poPMClient = poPMClientPtr;
	}
	else
	{
		ETG_TRACE_USR4(("tunmstr_Preset_Handler Error NULL"));
	}

}

#endif
#endif 

