/************************************************************************
 * FILE:           tunmstr_MsgFromHMI.h
 * PROJECT:        G3g
 * SW-COMPONENT:   FC_TunerMaster.
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:    CCA messages received from fc_audio are handled in this file.
 *
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      | Author                       | Modification
 * 15-04-11  | CM-AI/PJ-VW36 Pallavi HN     | initial version
 *
 *************************************************************************/



//------------
// includes
//------------
#ifdef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#include "ahl_mock/ahl_if.h"
#include "amt_mock/amt_if.h"
#else
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"


//---------------------------------------

//-------------------
// Internal includes
//-------------------

#include "fc_tunermaster_featureControl.h"

#include "tunermaster_main.h"
#include "tunermaster_utility.h"
#include "tunermaster_Config.h"

#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
#include "tunmstr_TunerClientHandler.h"
#endif

#include "tunmstr_MsgToHMI.h"
#include "tunmstr_MsgFromHMI.h"
#include "tunmstr_SrcChg_Trace.h"
#include "tunmstr_SrcChgManager.h"
#ifndef tunmstr_SrcChg_AnnoHandler_H
#include "tunmstr_SrcChg_AnnoHandler.h"
#endif
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
#ifndef tunmstr_Preset_Handler_H
#include "tunmstr_Preset_Handler.h"
#endif
#endif
#include"tunmstr_AutoStorehandler.h"
#ifndef tunmstr_antdiag_Manager_H
#include "tunmstr_antdiag_Manager.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNMSTR_TRACE_CLASS_SRCCHG
#include "trcGenProj/Header/tunmstr_MsgFromHMI.cpp.trc.h"
#endif
#ifndef VARIANT_S_FTR_ENABLE_TUNERMASTER_MOCK
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#include "dp_tuner_if.h"
#endif
#include "kdsconfig/clConfigInterface.h"

#ifdef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
#include "announcements/clAnnouncementControl.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
#include "tunmstr_SDSHandler.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
#include "tunermaster_SXMClient.h"
#include "tunermaster_SXMchannelartClient.h"
#endif

/* +++
MESSAGE MAP:
enter the function IDs (FID) and the corresponding functions here.
the function will be called when a message with the corresponding FID arrives
+++ */

BEGIN_MSG_MAP(tunmstr_MsgFromHMI, ahl_tclBaseWork)

// for Methods
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_BAND_CHANGE,           vHandle_s_BandChange_TM )
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_STOP_ANNOUNCEMENT,     vHandle_s_StopAnnouncement )
//ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_VISIBILITY,            vHandle_s_Visibility )
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_TEST_MODE,			 vHandle_s_TestMode)
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_SRCCHG_TESTMODE,       vHandle_s_SrcChg_testmode )
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_GET_ACTIVETUNER_INFO,  vHandle_s_GetActiveTuner_Info )
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUT,  vHandle_s_DirectFrequency_Input )
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_AUTOSTORE,  vHandle_s_AutoStore )
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_PRESET_HANDLING,  vHandle_s_PresetHandling )
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENT,  vHandle_s_ActivateAnno )


#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_SOURCE_SETUP_OPTION, vHandle_s_Source_Setup_Option)
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_STATION_SELECTION,  	vHandle_s_StationSelection )
#endif

/*Adding PM related method*/
#ifdef INCLUDE_PROFILE_MANAGER
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RADIOPROFILE_SETTING, vHandle_Tunmstr_s_RadioProfile_Setting)
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUEST,  	vHandle_s_Radio_Profile_Setting_Request )
//ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_RADIOPROFILE_SETTINGS,  	vHandle_g_TUNMSTR_G_RADIOPROFILE_SETTINGSStatus )
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATION,  	vHandle_g_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATION_Status )
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_SXM_USERPROFILE_RESPONSE,  	vHandleUserProfileResponse )
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_SXM_USERPROFILE,  	vHandle_g_SXM_UserProfile )
#endif


// For Properties
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_SOURCE_CHANGE ,         vHandle_g_SourceChange )
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_TP_STATUS,              vHandle_g_TP_Status )
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_BAND_INFO,              vHandle_g_Band_Info )
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_PRESET_LIST,        vHandle_g_PresetList )
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_ANNO_BUTTON_STATUS,        vHandle_g_AnnoButton_Status)
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_ANNOUNCEMENT_STATUS,        vHandle_g_Anno_Status)
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITY,        vHandle_g_Tuner_Domain_Availability)
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_GET_AUTOSTORE_STATUS,  vHandle_g_Get_Autostore_Status )

ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_MTC_SETMODE,  vHandle_s_Set_MTC_SetMode )
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_MTC_SETMODE_STATUS,  vHandle_s_Set_MTC_SetMode )
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUS,  vHandle_g_MTC_SurveilanceStationStatus)
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITY,  			vHandle_g_Tuner_Source_Availability)

ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZE,  	vHandle_s_Set_PSFreeze )

#if defined(VARIANT_S_FTR_ENABLE_SXMCLIENT) || defined(VARIANT_S_FTR_ENABLE_SXM360LCLIENT)
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_SXM_SRCSTATE,  	vHandle_s_SXM_SrcState )
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_GET_SXMCHANNELART_LIST,  	vHandle_s_get_ChannelArtList )
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_PRESET_CHANNEL_UPDATE,  	vHandle_g_Preset_ChannelUpdate )
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_SXM_SYSTEM_MESSAGE,  	vHandle_g_System_Message )
#else
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_SXM_PRESET_RESPONSE,  vHandle_s_HandleSXMPreset )
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_SXM_PRESETAUTOCOMPARE,  	vHandle_s_SXM_PresetAutoCompare )
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_SXM_PRESET_HANDLING,  	vHandle_g_SXM_PresetHandling )
#endif
#endif
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_PRESET_AUTOCOMPARE,  	vHandle_g_Preset_AutoCompare )

#endif
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RF_ANTENNA_TEST,       vHandle_s_Rf_Antenna_Test )
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_RF_ANTENNA_TEST,        vHandle_g_Rf_Antenna_Test )
ON_MESSAGE( MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_SET_DTVANTENNAREGISTER, vHandle_g_Set_DTVAntennaTRegister)
END_MSG_MAP()



/* Initialize Semaphore */
OSAL_tSemHandle tunmstr_MsgFromHMI::m_hNotTable_SemHandle  = OSAL_C_INVALID_HANDLE;

/*************************************************************************
 *
 * FUNCTION: tunmstr_MsgFromHMI::tunmstr_MsgFromHMI(ccademo_tclApp* poGWMainApp)
 *
 * DESCRIPTION: constructor, creates object tunmstr_MsgFromHMI - object
 *
 * PARAMETER: ccademo_tclApp* poGWMainApp: main - object of this application
 *
 * RETURNVALUE: none
 *
 *************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
tunmstr_MsgFromHMI::tunmstr_MsgFromHMI(tunmaster_tclApp* potunerMainApp , tuner::sessionManagement::audio::clArlSourceImpl* poArlImpl)
#else
tunmstr_MsgFromHMI::tunmstr_MsgFromHMI(  tunmaster_tclApp* potunerMainApp )
#endif

				
				{
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	m_poArlImpl = poArlImpl;
	m_poSessionControl = clSessionControl::getInstance();
#endif
	poGWMain = potunerMainApp;
	m_hNotTable_SemHandle = tunmaster_tclApp::_hNotTableSem;
	m_u16RegID = AMT_C_U16_REGID_INVALID;
	m_16CmdCntr = 0x00;
	m_AST_APPID = 0x00;
	m_u16ActiveTuner_AppID = 0x00;
	m_u16RfAntennaTest_AppID= 0x00;
	m_u16RfAntennaTest_Cmdcntr=0X00;
	m_u16RfAntennaTest_RegID=AMT_C_U16_REGID_INVALID;
	m_ptunmaster_Config = NULL;
	m_potunmstr_SrcChgManager = NULL;
	m_potunmstr_MsgToHMI = NULL;
	m_potunmstr_TunerClientHandler = NULL;
	m_potunmstr_Preset_Handler = NULL;
	m_potunmstr_DABClient_Handler = NULL;
	m_potunmstr_SrcChg_AnnoHandler = NULL;
	m_potunmstr_antdiag_Manager = NULL;
	m_ptunmstr_AutoStoreHandler = NULL;
	m_potunmstr_Utility = NULL;
	m_potunmstr_SDSHandler = NULL;
#ifdef INCLUDE_PROFILE_MANAGER
	m_potunmstr_PMClient_Handler = NULL;
#endif
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	m_potunermaster_SXMClient = nullptr;
	m_potunermaster_SXMchannelartClient = nullptr;
#endif
	m_poclConfigInterface = NULL;
#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
	m_bSXM360LClientAvail = FALSE;
	m_u8SXMPresetAutocompare = 0xFF;
	m_bSXMUserPresetAction = FALSE;
#endif

#if defined(VARIANT_S_FTR_ENABLE_SXMCLIENT) || defined(VARIANT_S_FTR_ENABLE_SXM360LCLIENT)
	m_bSXMSrcState = FALSE;
#endif
				}

/*************************************************************************
 *
 * FUNCTION: tunmstr_MsgFromHMI::~tunmstr_MsgFromHMI( )
 *
 * DESCRIPTION: Destructor.
 *
 * PARAMETER:
 *
 * RETURNVALUE: none
 *
 *************************************************************************/
tunmstr_MsgFromHMI::~tunmstr_MsgFromHMI( )
{  
	m_hNotTable_SemHandle  = OSAL_C_INVALID_HANDLE;

	poGWMain = NULL;
	m_u16RegID = AMT_C_U16_REGID_INVALID;
	m_16CmdCntr = 0x00;
	m_AST_APPID = 0x00;
	m_u16ActiveTuner_AppID = 0x00;
	m_u16ActiveTuner_AppID = 0x00;
	m_u16RfAntennaTest_AppID= 0x00;
	m_u16RfAntennaTest_Cmdcntr=0X00;
	m_u16RfAntennaTest_RegID=AMT_C_U16_REGID_INVALID;
	m_ptunmaster_Config = NULL;
	m_potunmstr_SrcChgManager = NULL;
	m_potunmstr_TunerClientHandler = NULL;
	m_potunmstr_MsgToHMI = NULL;
	m_potunmstr_Preset_Handler = NULL;
	m_potunmstr_DABClient_Handler=NULL;
	m_potunmstr_SrcChg_AnnoHandler = NULL;
	m_potunmstr_antdiag_Manager=NULL;
	m_ptunmstr_AutoStoreHandler = NULL;
	m_potunmstr_Utility = NULL;
	m_poclConfigInterface = NULL;
	m_potunmstr_SDSHandler = NULL;
#ifdef INCLUDE_PROFILE_MANAGER
	m_potunmstr_PMClient_Handler = NULL;
#endif
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	m_potunermaster_SXMClient = nullptr;
	m_potunermaster_SXMchannelartClient = nullptr;
#endif
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	m_poArlImpl = 0x00;
	m_poSessionControl = 0;
#endif
#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
	m_bSXM360LClientAvail = FALSE;
	m_u8SXMPresetAutocompare = 0xFF;
	m_bSXMUserPresetAction = FALSE;
#endif

#if defined(VARIANT_S_FTR_ENABLE_SXMCLIENT) || defined(VARIANT_S_FTR_ENABLE_SXM360LCLIENT)
	m_bSXMSrcState = FALSE;
#endif

}

/*************************************************************************
 *
 * FUNCTION:    vSet_tunmstr_DABClient_Handler_Ptr( tunmstr_DABClient_Handler* potunmstr_DABClient_Handler )
 *
 * DESCRIPTION: Set pointer to pointer tunmstr_DABClient_Handler
 *
 * PARAMETER:   tunmstr_DABClient_Handler* potunmstr_DABClient_Handler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunmstr_MsgFromHMI::vSet_tunmstr_DABClient_Handler_Ptr(tunmstr_DABClient_Handler* potunmstr_DABClient_Handler)
{
	if( potunmstr_DABClient_Handler != NULL )
	{
		m_potunmstr_DABClient_Handler = ( tunmstr_DABClient_Handler* )potunmstr_DABClient_Handler;
	}

}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_MsgFromHMI::vSet_tunmstr_SrcChgManager_Ptr( )
 *
 * DESCRIPTION:  Set pointer to pointer m_potunmstr_SrcChgManager*
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_MsgFromHMI::vSet_tunmstr_SrcChgManager_Ptr( tunmstr_SrcChgManager* potunmstr_SrcChgManager )
{
	if( potunmstr_SrcChgManager != NULL )
	{
		m_potunmstr_SrcChgManager= ( tunmstr_SrcChgManager* )potunmstr_SrcChgManager;
	}
	else
	{
		NORMAL_M_ASSERT ( m_potunmstr_SrcChgManager != NULL );
	}
}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_MsgFromHMI::vSet_tunmaster_Config_Ptr( )
 *
 * DESCRIPTION:  Set pointer to pointer m_ptunmaster_Config*
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_MsgFromHMI::vSet_tunmstr_TunerClientHandler_Ptr( tunmstr_TunerClientHandler* potunmstr_TunerClientHandler )
{
	if( potunmstr_TunerClientHandler != NULL )
	{
		m_potunmstr_TunerClientHandler = ( tunmstr_TunerClientHandler* )potunmstr_TunerClientHandler;
	}
	else
	{
		NORMAL_M_ASSERT ( m_potunmstr_TunerClientHandler != NULL );
	}
}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_MsgFromHMI::vSet_tunmstr_tunmstr_Preset_Handler_Ptr( )
 *
 * DESCRIPTION:  tunmstr_Preset_Handler* potunmstr_Preset_Handler
 *
 * PARAMETER:    tunmstr_Preset_Handler* potunmstr_Preset_Handler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_MsgFromHMI::vSet_tunmstr_tunmstr_Preset_Handler_Ptr( tunmstr_Preset_Handler* potunmstr_Preset_Handler)
{
	if( potunmstr_Preset_Handler != NULL )
	{
		m_potunmstr_Preset_Handler = ( tunmstr_Preset_Handler* )potunmstr_Preset_Handler;
	}
	else
	{
		NORMAL_M_ASSERT ( m_potunmstr_Preset_Handler != NULL );
	}
}
/*************************************************************************
 *
 * FUNCTION:    vSet_tunmaster_Config_Ptr
 *
 * DESCRIPTION:  Set pointer to pointer tunmaster_Config
 *
 * PARAMETER:    tunmaster_Config* potunmaster_Config
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunmstr_MsgFromHMI::vSet_tunmaster_Config_Ptr( tunmaster_Config* potunmaster_Config )
{
	if( potunmaster_Config != NULL )
	{
		m_ptunmaster_Config = ( tunmaster_Config* )potunmaster_Config;
	}
}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_MsgFromHMI::vSet_tunmstr_MsgToHMI_Ptr( )
 *
 * DESCRIPTION:  Set pointer to pointer m_ptunmaster_Config*
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_MsgFromHMI::vSet_tunmstr_MsgToHMI_Ptr( tunmstr_MsgToHMI* potunmstr_MsgToHMI )
{
	if( potunmstr_MsgToHMI != NULL )
	{
		m_potunmstr_MsgToHMI = ( tunmstr_MsgToHMI* )potunmstr_MsgToHMI;
	}
	else
	{
		NORMAL_M_ASSERT ( m_potunmstr_MsgToHMI != NULL );
	}
}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_MsgFromHMI::vSet_tunmstr_AutoStoreHandler_Ptr( )
 *
 * DESCRIPTION:  Set pointer to pointer m_ptunmaster_Config*
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_MsgFromHMI::vSet_tunmstr_AutoStoreHandler_Ptr(tunmstr_AutoStoreHandler* potunmstr_AutoStoreHandler)

{
	if( potunmstr_AutoStoreHandler != NULL )
	{
		m_ptunmstr_AutoStoreHandler = ( tunmstr_AutoStoreHandler* )potunmstr_AutoStoreHandler;
	}
	else
	{
		NORMAL_M_ASSERT ( m_ptunmstr_AutoStoreHandler != NULL );
	}
}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_MsgFromHMI::vSet_tunmstr_SrcChg_AnnoHandler_Ptr( )
 *
 * DESCRIPTION:  Set pointer to pointer tunmstr_SrcChg_AnnoHandler*
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_MsgFromHMI::vSet_tunmstr_SrcChg_AnnoHandler_Ptr(tunmstr_SrcChg_AnnoHandler* potunmstr_SrcChg_AnnoHandler)

{
	if( potunmstr_SrcChg_AnnoHandler != NULL )
	{
		m_potunmstr_SrcChg_AnnoHandler = ( tunmstr_SrcChg_AnnoHandler* )potunmstr_SrcChg_AnnoHandler;
	}
	else
	{
		NORMAL_M_ASSERT ( m_potunmstr_SrcChg_AnnoHandler != NULL );
	}
}
/*************************************************************************
 * FUNCTION:    tunmstr_MsgFromHMI::vSet_tunmstr_antdiag_Manager( tunmstr_antdiag_Manager* potunmstr_antdiag_Manager )
 *
 * DESCRIPTION: Set pointer to pointer tunmstr_antdiag_Manager
 *
 * PARAMETER:   tunmstr_antdiag_Manager* potunmstr_antdiag_Manager
 *
 * RETURNVALUE:  void
 *************************************************************************/

tVoid tunmstr_MsgFromHMI::vSet_tunmstr_antdiag_Manager(tunmstr_antdiag_Manager* potunmstr_antdiag_Manager)
{
	if( potunmstr_antdiag_Manager != NULL )
	{
		m_potunmstr_antdiag_Manager = ( tunmstr_antdiag_Manager* )potunmstr_antdiag_Manager;
	}
}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_MsgFromHMI::vSet_tunmstr_Utility_Ptr( )
 *
 * DESCRIPTION:  Set pointer to class m_potunmstr_Utility.
 *
 * PARAMETER:    tVoid
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_MsgFromHMI::vSet_tunmstr_Utility_Ptr( tunmaster_Utility* potunmstr_Utility  )
{
	if( potunmstr_Utility != NULL )
	{
		m_potunmstr_Utility = potunmstr_Utility;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_Utility != NULL );
	}
}


/*************************************************************************
* FUNCTION:    vSet_tunmstr_ConfigInterface_Ptr
*
* DESCRIPTION:
*
* PARAMETER:   clConfigInterface* poclConfigInterface
*
* RETURNVALUE:  void
*************************************************************************/
tVoid tunmstr_MsgFromHMI::vSet_tunmstr_ConfigInterface_Ptr
(clConfigInterface* poclConfigInterface)
{
	if( poclConfigInterface != NULL )
	{
		m_poclConfigInterface = poclConfigInterface;
	}

}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_MsgFromHMI::vSet_tunmstr_SDSHandler_Ptr( )
 *
 * DESCRIPTION:  Set pointer to class m_potunmstr_SDSHandler.
 *
 * PARAMETER:    tVoid
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_MsgFromHMI::vSet_tunmstr_SDSHandler_Ptr( tunmstr_SDSHandler* potunmstr_SDSHandler  )
{
	if( potunmstr_SDSHandler != NULL )
	{
		m_potunmstr_SDSHandler = potunmstr_SDSHandler;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_SDSHandler != NULL );
	}
}



/*************************************************************************
 *  FUNCTION:    tVoid vSetAudioRegID()
 *
 *  DESCRIPTION: To Set Reg ID from Audio
 *
 *  PARAMETER:   amt_tclServiceData* poMessage
 *
 *
 *  RETURNVALUE: None
 *
 *************************************************************************/
tVoid tunmstr_MsgFromHMI::vSetRegID(tU16 u16RegID)
{
	m_u16RegID = u16RegID;
}
/*******************************************************************************
 * FUNCTION:     tunmstr_MsgFromHMI::u16GetDiagRegID( )
 *
 * DESCRIPTION:  To retrieve the Audio Register ID
 *
 * PARAMETER:    None
 *
 * RETURNVALUE:  tU16
 * HISTORY
 * Date      | Author                       | Modification
 *-------------------------------------------------------------------------------
 *******************************************************************************/
tU16 tunmstr_MsgFromHMI :: u16GetRegID()const
{
	return  m_u16RegID;
}
/*************************************************************************
 *  FUNCTION:    tVoid vSetCmdCntr()
 *
 *  DESCRIPTION:
 *
 *  PARAMETER:   amt_tclServiceData* poMessage
 *
 *
 *  RETURNVALUE: None
 *
 *************************************************************************/
tVoid tunmstr_MsgFromHMI::vSetCmdCntr(tU16 u16CmdCntr)
{
	m_16CmdCntr = u16CmdCntr;
}
/*******************************************************************************
 * FUNCTION:     tunmstr_MsgFromHMI::u16GetCmdCntr( )
 *
 * DESCRIPTION:
 *
 * PARAMETER:    None
 *
 * RETURNVALUE:  tU16
 * HISTORY
 * Date      | Author                       | Modification
 *-------------------------------------------------------------------------------
 *******************************************************************************/
tU16 tunmstr_MsgFromHMI::u16GetCmdCntr()const
{
	return  m_16CmdCntr;
}
/*************************************************************************
 *  FUNCTION:    tVoid vSetCmdCntr()
 *
 *  DESCRIPTION:
 *
 *  PARAMETER:   amt_tclServiceData* poMessage
 *
 *
 *  RETURNVALUE: None
 *
 *************************************************************************/
tVoid tunmstr_MsgFromHMI::vSetAppID_ActiveTuner(tU16 u16AppID)
{
	m_u16ActiveTuner_AppID = u16AppID;
}
/*******************************************************************************
 * FUNCTION:     tunmstr_MsgFromHMI::u16GetCmdCntr( )
 *
 * DESCRIPTION:
 *
 * PARAMETER:    None
 *
 * RETURNVALUE:  tU16
 * HISTORY
 * Date      | Author                       | Modification
 *-------------------------------------------------------------------------------
 *******************************************************************************/
tU16 tunmstr_MsgFromHMI::u16GetActiveTuner_APPID()const
{
	return  m_u16ActiveTuner_AppID;
}
/*******************************************************************************
 *FUNCTION:    tunmstr_MsgFromHMI::vGetDatafromAMT
 *
 *DESCRIPTION: This function converts Amt message to visitor class and
 *             get the data from visitor to the Fi class. Refer FI Manual.
 *             Doc.
 *
 *PARAMETER:
 *           poFiMsg   - Amt Message
 *           oFIData   - Base class of Fi class
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_MsgFromHMI::vGetDatafromAMT( amt_tclServiceData* poFIMsg,
		fi_tclTypeBase&     oFIData )const
{
	// Create Visitor message object for incoming message
	fi_tclVisitorMessage oInVisitorMsg(poFIMsg);

	/* Get the data in FI class from Vistor class*/
	if(OSAL_ERROR == oInVisitorMsg.s32GetData(oFIData,1))
	{
		// assert here
		NORMAL_M_ASSERT_ALWAYS ();
	}

}

/*******************************************************************************
 *FUNCTION:    tunmstr_MsgFromHMI::vHandle_s_Rf_Antenna_Test
 *
 *DESCRIPTION: This function will extarct CCA messeage for Test mode sent by HMI
 *
 *
 *
 *PARAMETER:    poMessage
 *
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_MsgFromHMI::vHandle_s_Rf_Antenna_Test(amt_tclServiceData* poMessage)
{
	// Check message pointer.
	if(( poMessage == NULL )||(NULL==m_potunmstr_antdiag_Manager))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		return;
	}
	else
	{
	   switch (poMessage->u8GetOpCode())
		{
		case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
			{
			   midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart  oMessageStart;
				vGetDatafromAMT(poMessage,oMessageStart );
				tU8 u8WhichClient=(tU8)( midw_fi_tcl_e8_AntennaTest::tenType)oMessageStart.Antenna_Test.enType;
				ETG_TRACE_USR4(("vHandle_s_Rf_Antenna_Test u8WhichClient=%d",u8WhichClient));
				m_u16RfAntennaTest_AppID= poMessage->u16GetSourceAppID();
				m_u16RfAntennaTest_Cmdcntr=poMessage->u16GetCmdCounter();
				m_u16RfAntennaTest_RegID=poMessage->u16GetRegisterID();
				m_potunmstr_antdiag_Manager->vSetPendingAntennaStateReqClient(u8WhichClient);
				m_potunmstr_antdiag_Manager->vPostEvent(TUNMSTR_ANTDIAG_U32_EVENT_MASK_READ_ANT_STATUS_REQ);
				break;
			}
		default:
			{
				break;
			}
		}
	}
}
/*************************************************************************
 * FUNCTION:    tunmstr_MsgFromHMI::   vHandle_g_Rf_Antenna_Test()
 *
 * DESCRIPTION: This function will extract CCA message for RF_ANTENNA_TEST
 *
 * PARAMETER:   amt_tclServiceData* poMessage
 *
 * RETURNVALUE: NONE
 *************************************************************************/
tVoid tunmstr_MsgFromHMI :: vHandle_g_Rf_Antenna_Test( amt_tclServiceData* poMessage )const
{
	if((poMessage == NULL)||(NULL==m_potunmstr_MsgToHMI)||(NULL==m_potunmstr_antdiag_Manager))
	{
	   return;
	}	
	ETG_TRACE_USR4(("vHandle_g_Rf_Antenna_Test::enter into vHandle_g_Rf_Antenna_Test"));
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_UPREG:
	{

	   if( !( m_potunmstr_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
		{
			//add to notification table failed
			ETG_TRACE_USR4((" vHandle_g_Rf_Antenna_Test::add to notification table failed"));
		}
		else
		{
		   m_potunmstr_antdiag_Manager->vPostEvent(TUNMSTR_ANTDIAG_U32_EVENT_MASK_READ_ANT_UPREG_REQ);
		}
		break;
	}
	case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
	{
		if( !( m_potunmstr_MsgToHMI ->bRemoveNotification( poMessage ) ) )
		{
			//Remove from notification table failed
			ETG_TRACE_USR4((" vHandle_g_Rf_Antenna_Test::Remove from notification table failed"));
		}
		else
		{
			//Remove from notification table succ
			ETG_TRACE_USR4((" vHandle_g_Rf_Antenna_Test::Remove from notification table succ"));
		}
		break;
	}
	default:
	{
		ETG_TRACE_USR4((" vHandle_g_Rf_Antenna_Test::Wromg opcode"));
		break;
	}
	}
}
/****************************************************************************
 *FUNCTION:    tunmstr_MsgFromHMI::vSendMessage
 *
 *DESCRIPTION: This function converts Amt message to visitor class and
 *             get the data from visitor to the Fi class. Refer FI Manual.Doc.
 *
 *PARAMETER:
 *             u16DestAppID      - Destination ID of Out Msg
 *             oOutData          - Base class of out going Fi object
 *             u16Fid            - Funtion id of the out going message
 *             u8OpCode          - Opcode of the message
 *
 *RETURNVALUE: None
 ******************************************************************************/
tVoid tunmstr_MsgFromHMI::vSendMessage( stSendCCAMsg OstSendCCAMsg,const fi_tclTypeBase&  oOutData)
{
	if((poGWMain == NULL)||(OstSendCCAMsg.u16RegID==AMT_C_U16_REGID_INVALID))
	{
		NORMAL_M_ASSERT( poGWMain != NULL );
		return;
	}
	// Create the Visitor Message
	fi_tclVisitorMessage oOutVisitorMsg(oOutData,1);


	// Set the CCA message information
	oOutVisitorMsg.vInitServiceData(
			CCA_C_U16_APP_TUNERMASTER,                      /* Source app-ID    */
			OstSendCCAMsg.u16DestAppID,                             /* Dest. app-ID     */
			AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,        /* stream type      */
			0,                                        /* stream counter   */
			OstSendCCAMsg.u16RegID,                                 /* Registry ID      */
			OstSendCCAMsg.u16CmdCtr,                                /* Command counter  */
			CCA_C_U16_SRV_TUNERMASTERCONTROL,               /* Service-ID       */
			OstSendCCAMsg.u16Fid,                                   /* Function-ID      */
			OstSendCCAMsg.u8OpCode,                                 /* OpCode           */
			0,                                        /* ACT              */
			0,                                        /* Source sub-ID    */
			0 );                                      /* Dest. sub-ID     */

	/* ---
   send it to the client 
   --- */
	if(poGWMain->enPostMessage( &oOutVisitorMsg, TRUE ) != AIL_EN_N_NO_ERROR)
	{
		// Message sent successfully.
		ETG_TRACE_USR4(("vSendMessage()->Message not sent successfully."));
	}
	else
	{
		// Message not sent successfully.
		ETG_TRACE_USR4(("vSendMessage()->Message sent successfully."));
	}
}
/*************************************************************************
 *
 * FUNCTION:tVoid vOnUnknownMessage(amt_tclBaseMessage* poMessage)
 *
 * DESCRIPTION: handle unkown message
 *
 * PARAMETER:  unknown message
 *
 * RETURNVALUE: void
 *
 *************************************************************************/
tVoid tunmstr_MsgFromHMI::vOnUnknownMessage(amt_tclBaseMessage* poMessage)
{
	/* +++ the frame work calls this function when it receives a message with a unknown
   FID. You can use it for error handling. +++ */

	amt_tclServiceData oServiceData(poMessage);

	tU16 u16FuncID = oServiceData.u16GetFunctionID();


	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _\
			TUNMSTR_TRACE_MSG_FROM_HMI_UNKNOWN_MESS _ ET_EN_T16 _ \
			u16FuncID _ ET_EN_DONE );


}
/*************************************************************************
* FUNCTION:    vSendRfAntenna_TestMethodResult
*
* DESCRIPTION: fucntion to send the method result for FID
				MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RF_ANTENNA_TEST
*
* PARAMETER:   tU8 u8Client,tU8 u8AntennaState, tU8 u8Curr
*
* RETURNVALUE:  tVoid
*************************************************************************/
tVoid tunmstr_MsgFromHMI::vSendRfAntenna_TestMethodResult
(tU8 u8Client,tU8 u8AntennaState, tFloat fCurrent)
{
	midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodResult oResponce;
	oResponce.Tunmstr_RF_Antenna.AntennaTest.enType=(midw_fi_tcl_e8_AntennaTest::tenType)u8Client;
	#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
	if(u8AntennaState == enAntennState_ELMOSOpen_Noresult)
	{
		u8AntennaState = enAntennState_Unknown;
	}
	#endif
	oResponce.Tunmstr_RF_Antenna.RFAntennaStatus.enType=(midw_fi_tcl_e8_RFAntenna::tenType)u8AntennaState;
	if(fCurrent>255.0)
	{
		fCurrent=255.0;
	}
	oResponce.Tunmstr_RF_Antenna.ConnectionCurrent = (tU8)fCurrent;
	stSendCCAMsg ostSendCCAMsg; 
	ostSendCCAMsg.u16DestAppID=m_u16RfAntennaTest_AppID;
	ostSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RF_ANTENNA_TEST;
	ostSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
	ostSendCCAMsg.u16CmdCtr=m_u16RfAntennaTest_Cmdcntr;
	ostSendCCAMsg.u16RegID=m_u16RfAntennaTest_RegID;
	vSendMessage( ostSendCCAMsg,oResponce);
}
/*************************************************************************
 *
 * FUNCTION:     tunmstr_MsgFromHMI::vHandleTTFiS_CMD( )
 *
 * DESCRIPTION:  Handler to handle TTFIs Commands
 *
 * PARAMETER:    tU8DataLength, const tU8*u8DataSpecial
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_MsgFromHMI::vHandleTTFiS_CMD(const tU8* u8DataSpecial)
{
	tU8 u8FunctionID = u8DataSpecial[0];
	//CCA message Function ID
	if ( NULL == poGWMain || NULL == m_potunmstr_Utility)
	{
		NORMAL_M_ASSERT (NULL != poGWMain);
		NORMAL_M_ASSERT (NULL != m_potunmstr_Utility);
		return;
	}
	stSendCCAMsg ostSendCCAMsg;
	ostSendCCAMsg.u16DestAppID=CCA_C_U16_APP_TUNERMASTER;
	ostSendCCAMsg.u16CmdCtr=0;
	ostSendCCAMsg.u16RegID=poGWMain->u16GetRegID();
	ostSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODSTART;
	ETG_TRACE_USR4((" tunmstr_MsgFromHMI::vHandleTTFiS_CMD"
			"u8FunctionID=%d",
			u8FunctionID));
	switch(u8FunctionID)
	{
		#if 0
	case MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_MIXED_PRESET_RECALL:
	{
		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MIXED_PRESET_RECALLMethodStart oMessage;
		oMessage.u8Element_ID = u8DataSpecial[1];
		oMessage.List.enType = (midw_fi_tcl_e8_List::tenType)u8DataSpecial[2];
		ostSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_MIXED_PRESET_RECALL;
		vSendMessage( ostSendCCAMsg,oMessage);
	}break;
	#endif
	case MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_STOP_ANNOUNCEMENT:
	{
		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart oMessage;
		oMessage.StopAnnouncements.enType = (midw_fi_tcl_StopAnnouncements::tenType)u8DataSpecial[1];
		ostSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_STOP_ANNOUNCEMENT;
		vSendMessage( ostSendCCAMsg,oMessage);
	}break;
	case MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_BAND_CHANGE:
	{
		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodStart oMessage;
		oMessage.Band.enType = (midw_fi_tcl_e8_Band::tenType)u8DataSpecial[1];
		ostSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_BAND_CHANGE;
		vSendMessage( ostSendCCAMsg,oMessage);
	}break;
#if 0
	case MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_VISIBILITY:
	{
		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_VISIBILITYMethodStart oMessage;
		oMessage.Visible = (tBool)u8DataSpecial[1];
		oMessage.Source  = u8DataSpecial[2];
		ostSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_VISIBILITY;
		vSendMessage( ostSendCCAMsg,oMessage);
	}break;
#endif
	case MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_TEST_MODE:
	{
		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodStart oMessage;
		oMessage.TestModeActive =(tBool)u8DataSpecial[1];
		ostSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_TEST_MODE;
		vSendMessage( ostSendCCAMsg,oMessage);
	}break;
	case MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_SRCCHG_TESTMODE:
	{
		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodStart oMessage;
		oMessage.WhichTuner.enType = (midw_fi_tcl_e8_WhichTuner::tenType)u8DataSpecial[1];
		ostSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_SRCCHG_TESTMODE;
		vSendMessage( ostSendCCAMsg,oMessage);
	}break;
	case MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RF_ANTENNA_TEST:
	{
		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RF_ANTENNA_TESTMethodStart oMessage;
		oMessage.Antenna_Test.enType=( midw_fi_tcl_e8_AntennaTest::tenType)u8DataSpecial[1];
		ostSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RF_ANTENNA_TEST;
		vSendMessage( ostSendCCAMsg,oMessage);
		break;
	}
	case MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_PRESET_HANDLING:
		{
			midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_HANDLINGMethodStart oMsgData;
			oMsgData.Preset_Action.enType=(midw_fi_tcl_e8_Preset_Action::tenType)u8DataSpecial[1];
			oMsgData.u8Element_ID=u8DataSpecial[2];
			oMsgData.List.enType=(midw_fi_tcl_e8_List::tenType)u8DataSpecial[3];
			oMsgData.Band.enType=(midw_fi_tcl_e8_Band::tenType)u8DataSpecial[4];
			oMsgData.Frequency = m_potunmstr_Utility->u32Convert4SeparateBytesTo32Bit(&u8DataSpecial[5]);
			oMsgData.PI = m_potunmstr_Utility->u32Convert4SeparateBytesTo32Bit(&u8DataSpecial[9]);
			oMsgData.SecondaryPI = m_potunmstr_Utility->u16Convert2SeparateBytesTo16Bit(&u8DataSpecial[13]);
			ostSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_PRESET_HANDLING;
			vSendMessage( ostSendCCAMsg,oMsgData);
			break;
		}
	case MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_AUTOSTORE:
		{
			midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart oMsgData;
			oMsgData.AutoStore_Start=u8DataSpecial[1];
			oMsgData.List.enType=(midw_fi_tcl_e8_List::tenType)u8DataSpecial[2];
			oMsgData.AST_Type.enType=(midw_fi_tcl_e8_AST_Types::tenType)u8DataSpecial[3];
			ostSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_AUTOSTORE;
			vSendMessage( ostSendCCAMsg,oMsgData);
			break;
		}
	case MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENT:
		{
			midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart oMsgData;
			oMsgData.b32Anno_Types.u32Value  = m_potunmstr_Utility->u32Convert4SeparateBytesTo32Bit( &u8DataSpecial[1] );
			oMsgData.Source.u8Value=u8DataSpecial[5];
			ostSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENT;
			vSendMessage( ostSendCCAMsg,oMsgData);
			break;
		}
	case MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_MTC_SETMODE:
		{
			midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart oMsgData;
			oMsgData.Mode.u8Value  = u8DataSpecial[1];
			ostSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_MTC_SETMODE;
			vSendMessage( ostSendCCAMsg,oMsgData);
			break;
		}
	case MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_STATION_SELECTION:
	{
		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodStart oMsgData;
		oMsgData.Option.enType  = (midw_fi_tcl_e8_StationSelection_Option::tenType)u8DataSpecial[1];
		oMsgData.Band.enType = (midw_fi_tcl_e8_Band::tenType)u8DataSpecial[2];
		oMsgData.Frequency = m_potunmstr_Utility->u32Convert4SeparateBytesTo32Bit(&u8DataSpecial[3]);
		oMsgData.u8Element_ID = u8DataSpecial[7];
		oMsgData.List.enType = (midw_fi_tcl_e8_List::tenType)u8DataSpecial[8];
		oMsgData.PI = m_potunmstr_Utility->u32Convert4SeparateBytesTo32Bit(&u8DataSpecial[9]);
		oMsgData.SecondaryPI = m_potunmstr_Utility->u16Convert2SeparateBytesTo16Bit(&u8DataSpecial[13]);
		oMsgData.ModulationType.enType = (midw_fi_tcl_e8_ModulationType::tenType)u8DataSpecial[15];
		oMsgData.HDProgramNumber = u8DataSpecial[16];
		ostSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_STATION_SELECTION;
		vSendMessage( ostSendCCAMsg,oMsgData);
		break;
	}
	case FID_TUNMSTR_S_SOURCE_SETUP_OPTION:
		{
			midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart oMsgData;
			oMsgData.Enable= u8DataSpecial[1];
			oMsgData.Source.enType = (midw_fi_tcl_e8_Source::tenType)u8DataSpecial[2];
			ostSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_SOURCE_SETUP_OPTION;
			vSendMessage( ostSendCCAMsg,oMsgData);
			break;
		}
	case MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_SET_DTVANTENNAREGISTER:
	{
		midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterSet oMsgData;
		ostSendCCAMsg.u8OpCode = AMT_C_U8_CCAMSG_OPCODE_SET;
		ostSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_SET_DTVANTENNAREGISTER;
		vSendMessage( ostSendCCAMsg,oMsgData);
		break;
	}
#ifdef INCLUDE_PROFILE_MANAGER
		case MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RADIOPROFILE_SETTING:
		{
			midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart  oMsgMethodStart;

			ETG_TRACE_USR4(("vHandleTTFiS_CMD()  S_RADIOPROFILE_SETTING band = %d",u8DataSpecial[1]));

			   unsigned int u32Frequency;
			   u32Frequency  = ( unsigned int  ) ( ( u8DataSpecial[2]  ) << 24 ) ;
			   u32Frequency |= ( unsigned int  ) ( ( u8DataSpecial[3]  ) << 16 ) ;
			   u32Frequency |= ( unsigned int  ) ( ( u8DataSpecial[4]  ) << 8  ) ;
			   u32Frequency |= ( unsigned int  ) (   u8DataSpecial[5]  );

			ETG_TRACE_USR4(("vHandleTTFiS_CMD()  S_RADIOPROFILE_SETTING u32Frequency = %d",u32Frequency));
			ETG_TRACE_USR4(("vHandleTTFiS_CMD()  S_RADIOPROFILE_SETTING OtherPresetsOption = %d",u8DataSpecial[6]));

			if(u8DataSpecial[6])
				oMsgMethodStart.RadioProfile_Option.enType = midw_fi_tcl_e8_Preset_Option::FI_EN_TUN_MSTR_PRESET_OPTION_DELETE_OTHERS;
			else
				oMsgMethodStart.RadioProfile_Option.enType = midw_fi_tcl_e8_Preset_Option::FI_EN_TUN_MSTR_PRESET_OPTION_KEEP_OTHERS;

			ETG_TRACE_USR4(("vHandleTTFiS_CMD()  S_RADIOPROFILE_SETTING AMSwitch = %d",u8DataSpecial[7]));

			if(u8DataSpecial[7])
				oMsgMethodStart.RadioProfile_AMSwitch = true;

			ETG_TRACE_USR4(("vHandleTTFiS_CMD()  S_RADIOPROFILE_SETTING Elemend_ID = %d",u8DataSpecial[8]));
			/*
			ARRAY Band=0x00:FM
			ARRAY Band=0x01:DAB
			ARRAY Band=0x02:MW
			ARRAY Band=0x03:LW
			ARRAY Band=0x04:SXM
			ARRAY Band=0x05:ALL*/

			oMsgMethodStart.RadioProfileSettingAction.u8Value =  u8DataSpecial[9];
			ETG_TRACE_USR4(("vHandleTTFiS_CMD()  S_RADIOPROFILE_SETTING RadioProfileSettingAction = %d",u8DataSpecial[9]));

			switch(u8DataSpecial[1])
			{
			case 0:
			{
				TunerMasterPresetList oElement;
				oElement.u32Frequency = 0;
				oElement.u32SID = 0;
				oElement.e8RadioType.enType = midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_FM;
				oElement.u32Frequency = 87900;
				oElement.m_e8ListType.enType = midw_fi_tcl_e8_List::FI_EN_BANK_FM1;
				oElement.u8PresetNumber = u8DataSpecial[8];
				if (0 != u32Frequency)
					oElement.u32Frequency = u32Frequency;

				oMsgMethodStart.RadioProfile_PresetList.push_back(oElement);

				break;
			}
			case 1:
			{	/*DAB*/
				TunerMasterPresetList oElement;
				oElement.e8RadioType.enType = midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_DAB;
				oElement.u8PresetNumber = u8DataSpecial[8];
				oElement.u32SID = 0x1e0d210;
				oElement.u32EnsembleId = 0x00e010bc;
				oElement.u32Frequency = 178352;
				oElement.ComponentLabel.bSet("",midw_fi_tclString::FI_EN_UTF8);
				oElement.u32ComponentLabelEncoding = 0;
				oElement.sStationName.bSet("Dlf",midw_fi_tclString::FI_EN_UTF8);
				oElement.u32TextEncoding = 57344;

				oMsgMethodStart.RadioProfile_PresetList.push_back(oElement);

				break;
			}
			case 2:
			{
				/*AM*/

				TunerMasterPresetList oElement;
				oElement.u32Frequency = 0;
				oElement.u32SID = 0;
				oElement.e8RadioType.enType = midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_AM;
				oElement.u32Frequency = 531;
				oElement.m_e8ListType.enType = midw_fi_tcl_e8_List::FI_EN_BANK_AM_MW1;
				oElement.u8PresetNumber = u8DataSpecial[8];
				if (0 != u32Frequency)
					oElement.u32Frequency = u32Frequency;

				oMsgMethodStart.RadioProfile_PresetList.push_back(oElement);
				break;
			}
			case 4:
			{
				TunerMasterPresetList oElement;
				oElement.u32Frequency = 0;
				oElement.e8RadioType.enType = midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_SXM;
				oElement.u32SID = 9;
				oElement.u8PresetNumber = u8DataSpecial[8];
				if (0 != u32Frequency)
					oElement.u32Frequency = u32Frequency;

				oMsgMethodStart.RadioProfile_PresetList.push_back(oElement);
				break;
			}
			case 5:
			{

				tU8 u8TotalPresets= 3+3+3;
				tU8 u8AMStart= 12;
				tU8 u8FMStart= 0;
				tU8 u8SXMStart= 18;
				tU8 u8DABStart= 18;

				for(tU8 u8Itr= 0 ; u8Itr <u8TotalPresets ; u8Itr++)
					{

						TunerMasterPresetList oElement;

						if(u8Itr< 3)
						{
							oElement.e8RadioType.enType = midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_FM;
							oElement.u32Frequency = 87900;
							oElement.m_e8ListType.enType = midw_fi_tcl_e8_List::FI_EN_BANK_FM1;
							oElement.u8PresetNumber = u8FMStart + u8Itr +1;
							oElement.sStationName.bSet("HGTEST101",midw_fi_tclString::FI_EN_UTF8);
						}

						if((u8Itr >= 3) && (u8Itr< 6))
						{
							oElement.e8RadioType.enType = midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_AM;
							oElement.u32Frequency = 531;
							oElement.m_e8ListType.enType = midw_fi_tcl_e8_List::FI_EN_BANK_AM_MW1;
							oElement.u8PresetNumber = u8AMStart + u8Itr+1;

						}

						if (m_poclConfigInterface->u32GetConfigData("SXMSupported"))
						{
							if((u8Itr >= 6) && (u8Itr< 9))
							{
								oElement.e8RadioType.enType = midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_SXM;
								oElement.u32SID = 9;
								//oElement.u32Frequency = 100;
								oElement.u8PresetNumber = u8SXMStart + u8Itr +1;
							}
						}

						if (m_poclConfigInterface->u32GetConfigData("DABSupported"))
						{
							if((u8Itr >= 6) && (u8Itr< 9))
							{
									oElement.e8RadioType.enType = midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_DAB;
									oElement.u8PresetNumber = u8DABStart + u8Itr +1;
									oElement.u32SID = 0x1e0d210;
									oElement.u32EnsembleId = 0x00e010bc;
									oElement.u32Frequency = 178352;
									oElement.ComponentLabel.bSet("",midw_fi_tclString::FI_EN_UTF8);
									oElement.u32ComponentLabelEncoding = 0;
									oElement.sStationName.bSet("Dlf",midw_fi_tclString::FI_EN_UTF8);
									oElement.u32TextEncoding = 57344;
							}
						}
						oMsgMethodStart.RadioProfile_PresetList.push_back(oElement);

					}
				break;
			}
			default:
				break;
			}



			ostSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RADIOPROFILE_SETTING;
			vSendMessage( ostSendCCAMsg,oMsgMethodStart);
			break;
	}
#endif
	default:
		break;
	}// end of Switch

}//end of vHandleTTFiS_CMD

#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
/*******************************************************************************
 *FUNCTION:    tunmstr_MsgFromHMI::vHandle_s_BandChange_TM
 *
 *DESCRIPTION: This function will extarct CCA messeage for soutce change sent by fc_audio
 *
 *
 *
 *PARAMETER:
 *           poMessage
 *
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_MsgFromHMI::vHandle_s_BandChange_TM(amt_tclServiceData* poMessage)
{
	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _\
			TUNMSTR_TRACE_MSG_FROM_HMI_NEW_CCA_MSG _ ET_EN_T16 _\
			MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_BAND_CHANGE _ ET_EN_DONE );

	// Check message pointer.
	if(( poMessage == NULL )||(m_potunmstr_SrcChgManager == NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT(m_potunmstr_SrcChgManager != NULL);

		ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _\
				TUNMSTR_TRACE_MSG_FROM_NULL_POINTER _ ET_EN_DONE );
		return;
	}
	else
	{

		switch (poMessage->u8GetOpCode())
		{
		case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
		{
			// Get the contents of the switch.


			midw_tunermasterfi_tclMsgFID_TUNMSTR_S_BAND_CHANGEMethodResult oResponce;

			// Response -> SUCC / FAIL / BUSY
			oResponce.TunerMaster_StatusResponse.u8TunermasterStatus.enType = \
					midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED;
			stSendCCAMsg ostSendCCAMsg;
			ostSendCCAMsg.u16DestAppID=poMessage->u16GetSourceAppID();
			ostSendCCAMsg.u16Fid=poMessage->u16GetFunctionID();
			ostSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
			ostSendCCAMsg.u16CmdCtr=poMessage->u16GetCmdCounter();
			ostSendCCAMsg.u16RegID=poMessage->u16GetRegisterID();
			vSendMessage( ostSendCCAMsg,oResponce);
			m_potunmstr_SrcChgManager->vCheckForBandChange( poMessage );

			break;

		}/* end of AMT_C_U8_CCAMSG_OPCODE_METHODSTART  */

		case AMT_C_U8_CCAMSG_OPCODE_ERROR:
		{
			/* Call default Error handling function */

			break;
		}/* end of AMT_C_U8_CCAMSG_OPCODE_ERROR    */

		default:
		{
			// To do send back info with invalid opcode...

			break;
		}/* end of default */
		}/* end of switch (poInMsg->u8GetOpCode())*/

		// delete the CCA message.
		//Need not call Delete function here, as it is takenc are in tunmaster_tclApp::vOnNewMessage
	} /* else */

}
/*******************************************************************************
 *FUNCTION:    tunmstr_MsgFromHMI::vHandle_s_StopAnnouncement
 *
 *DESCRIPTION: This function will extarct CCA messeage for soutce change sent by fc_audio
 *
 *
 *
 *PARAMETER:
 *           poMessage
 *
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_MsgFromHMI::vHandle_s_StopAnnouncement(amt_tclServiceData* poMessage)
{
#ifndef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _\
			TUNMSTR_TRACE_MSG_FROM_HMI_NEW_CCA_MSG _ ET_EN_T16 _\
			MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_STOP_ANNOUNCEMENT _ ET_EN_DONE );
	// Check message pointer.
	if(( poMessage == NULL )||(m_potunmstr_SrcChg_AnnoHandler == NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT(m_potunmstr_SrcChg_AnnoHandler != NULL);

		ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _\
				TUNMSTR_TRACE_MSG_FROM_NULL_POINTER _ ET_EN_DONE );

		return;
	}
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
	{
		// Get the contents of the switch.

		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult oResponce;

		// Response -> SUCC / FAIL / BUSY
		oResponce.TunerMaster_StatusResponse.u8TunermasterStatus.enType = \
				midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED;

		stSendCCAMsg ostSendCCAMsg;
		ostSendCCAMsg.u16DestAppID=poMessage->u16GetSourceAppID();
		ostSendCCAMsg.u16Fid=poMessage->u16GetFunctionID();
		ostSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
		ostSendCCAMsg.u16CmdCtr=poMessage->u16GetCmdCounter();
		ostSendCCAMsg.u16RegID=poMessage->u16GetRegisterID();
		vSendMessage( ostSendCCAMsg,oResponce);

		m_potunmstr_SrcChg_AnnoHandler->vCheckForStop_Anno( poMessage );

		break;

	}/* end of AMT_C_U8_CCAMSG_OPCODE_METHODSTART  */

	case AMT_C_U8_CCAMSG_OPCODE_ERROR:
	{
		/* Call default Error handling function */

		break;
	}/* end of AMT_C_U8_CCAMSG_OPCODE_ERROR    */

	default:
	{
		// To do send back info with invalid opcode...

		break;
	}/* end of default */
	}/* end of switch (poInMsg->u8GetOpCode())*/

#else
	if( poMessage == NULL )
	{
		return;
	}
	if (poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODSTART)
	{
		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodResult oResponse;
		oResponse.TunerMaster_StatusResponse.u8TunermasterStatus.enType = midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED;

		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STOP_ANNOUNCEMENTMethodStart oMsg;
		vGetDatafromAMT(poMessage,oMsg );

		stSendCCAMsg ostSendCCAMsg;
		ostSendCCAMsg.u16DestAppID=poMessage->u16GetSourceAppID();
		ostSendCCAMsg.u16Fid=poMessage->u16GetFunctionID();
		ostSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
		ostSendCCAMsg.u16CmdCtr=poMessage->u16GetCmdCounter();
		ostSendCCAMsg.u16RegID=poMessage->u16GetRegisterID();
		vSendMessage( ostSendCCAMsg,oResponse);
		tuner::announcements::clAnnouncementControl oControl;
		oControl.vCancelAnnouncement(oMsg.StopAnnouncements.enType);
	}

#endif
	// delete the CCA message.
	//Need not call Delete function here, as it is takenc are in tunmaster_tclApp::vOnNewMessage
}
/*******************************************************************************
 *FUNCTION:    tunmstr_MsgFromHMI::vHandle_s_Visibility
 *
 *DESCRIPTION: This function will extarct CCA messeage for Visibility sent by HMI
 *
 *
 *
 *PARAMETER:
 *           poMessage
 *
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_MsgFromHMI::vHandle_s_Visibility(amt_tclServiceData* /*poMessage*/)
{
	#if 0
	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _\
			TUNMSTR_TRACE_MSG_FROM_HMI_NEW_CCA_MSG _ ET_EN_T16 _\
			MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_VISIBILITY _ ET_EN_DONE );

	// Check message pointer.
	if(( poMessage == NULL )||(m_potunmstr_SrcChgManager == NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT(m_potunmstr_SrcChgManager != NULL);

		ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _\
				TUNMSTR_TRACE_MSG_FROM_NULL_POINTER _ ET_EN_DONE );

		return;
	}
	else
	{


		switch (poMessage->u8GetOpCode())
		{
		case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
		{
			// Get the contents of the switch.

			m_potunmstr_SrcChgManager->vCheckForVisibility( poMessage );

			midw_tunermasterfi_tclMsgFID_TUNMSTR_S_VISIBILITYMethodResult oResponce;

			// Response -> SUCC / FAIL / BUSY
			oResponce.TunerMaster_StatusResponse.u8TunermasterStatus.enType = \
					midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED;
		stSendCCAMsg ostSendCCAMsg;
		ostSendCCAMsg.u16DestAppID=poMessage->u16GetSourceAppID();
		ostSendCCAMsg.u16Fid=poMessage->u16GetFunctionID();
		ostSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
		ostSendCCAMsg.u16CmdCtr=poMessage->u16GetCmdCounter();
		ostSendCCAMsg.u16RegID=poMessage->u16GetRegisterID();
		vSendMessage( ostSendCCAMsg,oResponce);


			break;

		}/* end of AMT_C_U8_CCAMSG_OPCODE_METHODSTART  */

		case AMT_C_U8_CCAMSG_OPCODE_ERROR:
		{
			/* Call default Error handling function */

			break;
		}/* end of AMT_C_U8_CCAMSG_OPCODE_ERROR    */

		default:
		{
			// To do send back info with invalid opcode...

			break;
		}/* end of default */
		}/* end of switch (poInMsg->u8GetOpCode())*/

		// delete the CCA message.
		//Need not call Delete function here, as it is takenc are in tunmaster_tclApp::vOnNewMessage

	} /* else */
#endif
}


/*************************************************************************
 * FUNCTION:    tunmstr_MsgFromHMI::   vHandle_g_TunSeekMode()
 *
 * DESCRIPTION: Command from CLUSTER for the seek mode of the Tuner.
 *
 *
 * PARAMETER:   amt_tclServiceData* poMessage
 *
 * RETURNVALUE: NONE
 *
 * History:
 * Date      | Author                       | Modification
 * 27.07.06  | RBIN pus1kor                 | Initial version.
 *
 *************************************************************************/
tVoid tunmstr_MsgFromHMI :: vHandle_g_SourceChange( amt_tclServiceData* poMessage )
{

	if(( poMessage == NULL )|| (m_potunmstr_MsgToHMI == NULL) || (m_potunmstr_SrcChg_AnnoHandler == NULL))
	{

		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChg_AnnoHandler != NULL );
		return;

	}

	switch (poMessage->u8GetOpCode())
	{


	case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
	{

		ET_TRACE_ERROR_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _ TUNMSTR_TRACE_MSGFROMHMI_WRONG_OPCODE _
				ET_EN_T16 _ MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_SOURCE_CHANGE _ ET_EN_DONE);

		break;

	}

	case AMT_C_U8_CCAMSG_OPCODE_UPREG:

	{
		ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _ TUNMSTR_TRACE_MSGFROMHMI_FID_HANDLER _
				ET_EN_T16 _ MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_SOURCE_CHANGE _ ET_EN_DONE);

		if( !( m_potunmstr_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
		{

			// vSendErrorToClientsInNotTable( poMessage , AMT_C_U16_ERROR_UPREG_FAILURE  );

			ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _ TUNMSTR_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _ ET_EN_DONE);

		}
		else
		{
			ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _ TUNMSTR_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_SUCC _ ET_EN_DONE);
			m_potunmstr_MsgToHMI -> vSend_g_SourceChange( m_potunmstr_SrcChg_AnnoHandler->m_AnnoSrcChgRequest.u8Source,
							m_potunmstr_SrcChg_AnnoHandler->m_AnnoSrcChgRequest.u8AnnoState );
		}


	}
	break;

	case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
	{
		if( !( m_potunmstr_MsgToHMI ->bRemoveNotification( poMessage ) ) )
		{
			/* --- relupreg failt: send an error message --- */
			/* +++ use you own error codes  +++ */

		}
		else
		{
			/* ---
            the reupreg was successful so you can't talk to this client anymore.
            therefore there are normally no actions to be done in this case
            --- */
		}

	}
	break;

	default:
	{
		/* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
		ET_TRACE_ERROR_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _ TUNMSTR_TRACE_MSGFROMHMI_WRONG_OPCODE _
				ET_EN_T16 _ MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_SOURCE_CHANGE _ ET_EN_DONE);
		break;
	}
	}

}
/*************************************************************************
 * FUNCTION:    tunmstr_MsgFromHMI::   vHandle_g_TA_Status()
 *
 * DESCRIPTION:
 *
 * PARAMETER:   amt_tclServiceData* poMessage
 *
 * RETURNVALUE: NONE
 *
 *
 *************************************************************************/
tVoid tunmstr_MsgFromHMI::vHandle_g_AnnoButton_Status( amt_tclServiceData* poMessage )const
{

	if(( poMessage == NULL )|| (m_potunmstr_MsgToHMI == NULL) || (m_potunmstr_SrcChg_AnnoHandler == NULL) || (m_poclConfigInterface == NULL))
	{

		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChg_AnnoHandler != NULL );
		NORMAL_M_ASSERT( m_poclConfigInterface != NULL );
		return;

	}

	switch (poMessage->u8GetOpCode())
	{


	case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
	{

		ETG_TRACE_USR4(("tunmstr_MsgFromHMI::vHandle_g_AnnoButton_Statu ---> Error Opcode"));
		break;

	}

	case AMT_C_U8_CCAMSG_OPCODE_UPREG:

	{
		ETG_TRACE_USR4(("tunmstr_MsgFromHMI::vHandle_g_AnnoButton_Statu ---> UPREG"));

		if( !( m_potunmstr_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
		{

			ETG_TRACE_USR4(("tunmstr_MsgFromHMI::vHandle_g_AnnoButton_Statu ---> UPREG - FAIL"));

		}
		else
		{
			m_potunmstr_MsgToHMI->vSend_g_AnnoButton_Status((tU8)TUNMSTR_SRCCHG_SOURCE_TUN1FM, m_potunmstr_SrcChg_AnnoHandler->u32GetAnnoButtonState_FM());
			if(m_poclConfigInterface->u32GetConfigData("DABSupported")) 
			{
				m_potunmstr_MsgToHMI->vSend_g_AnnoButton_Status((tU8)TUNMSTR_SRCCHG_SOURCE_DAB, m_potunmstr_SrcChg_AnnoHandler->u32GetAnnoButtonState_DAB());
			}

			// DAB TA button status sent
			//Send TA Button status Message after UP Reg.
			ETG_TRACE_USR4(("tunmstr_MsgFromHMI::vHandle_g_AnnoButton_Status---> Status on Upreg sent"));
		}

	}
	break;

	case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
	{
		if( !( m_potunmstr_MsgToHMI ->bRemoveNotification( poMessage ) ) )
		{
			/* --- relupreg failt: send an error message --- */
			/* +++ use you own error codes  +++ */

		}
		else
		{
			/* ---
            the reupreg was successful so you can't talk to this client anymore.
            therefore there are normally no actions to be done in this case
            --- */
		}

	}
	break;

	default:
	{
		/* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
		ETG_TRACE_USR4(("tunmstr_MsgFromHMI::vHandle_g_AnnoButton_Statu---> Wrong Opcode.... default case"));
		break;
	}
	}

}

/*************************************************************************
 * FUNCTION:    tunmstr_MsgFromHMI::   vHandle_g_TP_Status()
 *
 * DESCRIPTION:
 *
 * PARAMETER:   amt_tclServiceData* poMessage
 *
 * RETURNVALUE: NONE
 *
 *
 *************************************************************************/
tVoid tunmstr_MsgFromHMI :: vHandle_g_TP_Status( amt_tclServiceData* poMessage )
{

	if(( poMessage == NULL )|| (m_potunmstr_MsgToHMI == NULL) || (m_potunmstr_SrcChg_AnnoHandler == NULL))
	{

		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChg_AnnoHandler != NULL );
		return;

	}

	switch (poMessage->u8GetOpCode())
	{


	case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
	{

		ET_TRACE_ERROR_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _ TUNMSTR_TRACE_MSGFROMHMI_WRONG_OPCODE _
				ET_EN_T16 _ MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_TP_STATUS _ ET_EN_DONE);

		break;

	}

	case AMT_C_U8_CCAMSG_OPCODE_UPREG:

	{
		ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _ TUNMSTR_TRACE_MSGFROMHMI_FID_HANDLER _
				ET_EN_T16 _ MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_TP_STATUS _ ET_EN_DONE);

		if( !( m_potunmstr_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
		{

			ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _ TUNMSTR_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _ ET_EN_DONE);

		}
		else
		{


			ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _ TUNMSTR_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_SUCC _ ET_EN_DONE);
			/*tBool blTP_State = m_potunmstr_SrcChg_AnnoHandler->blGetTPState();
			tU8 u8Source = m_potunmstr_SrcChg_AnnoHandler->u8GetTPSource();
			//Get TP Status from Source Change Manager
			m_potunmstr_MsgToHMI->vSend_g_TP_Status(blTP_State, u8Source);*/
			// Send this info to HMI
			if(m_potunmstr_MsgToHMI->u8GetTunerTPStatus() != 0xFF)
				m_potunmstr_MsgToHMI->vSend_g_TP_Status((tBool)m_potunmstr_MsgToHMI->u8GetTunerTPStatus(), (tU8)midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_FM1);

			if(m_potunmstr_MsgToHMI->u8GetDABTPStatus() != 0xFF)
				m_potunmstr_MsgToHMI->vSend_g_TP_Status((tBool)m_potunmstr_MsgToHMI->u8GetDABTPStatus(), (tU8)midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_DAB);

		}
	}
	break;

	case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
	{
		if( !( m_potunmstr_MsgToHMI ->bRemoveNotification( poMessage ) ) )
		{
			/* --- relupreg failt: send an error message --- */
			/* +++ use you own error codes  +++ */

		}
		else
		{
			/* ---
            the reupreg was successful so you can't talk to this client anymore.
            therefore there are normally no actions to be done in this case
            --- */
		}

	}
	break;

	default:
	{
		/* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
		ET_TRACE_ERROR_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _ TUNMSTR_TRACE_MSGFROMHMI_WRONG_OPCODE _
				ET_EN_T16 _ MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_TP_STATUS _ ET_EN_DONE);
		break;
	}
	}

}


/*************************************************************************
 * FUNCTION:    tunmstr_MsgFromHMI::   vHandle_g_Band_Info()
 *
 * DESCRIPTION:
 *
 * PARAMETER:   amt_tclServiceData* poMessage
 *
 * RETURNVALUE: NONE
 *
 *
 *************************************************************************/
tVoid tunmstr_MsgFromHMI :: vHandle_g_Band_Info( amt_tclServiceData* poMessage )
{

	if(( poMessage == NULL )|| (m_potunmstr_MsgToHMI == NULL) || (m_potunmstr_SrcChgManager == NULL))
	{

		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );

		return;

	}

	switch (poMessage->u8GetOpCode())
	{


	case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
	{

		ET_TRACE_ERROR_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _ TUNMSTR_TRACE_MSGFROMHMI_WRONG_OPCODE _
				ET_EN_T16 _ MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_BAND_INFO _ ET_EN_DONE);

		break;

	}

	case AMT_C_U8_CCAMSG_OPCODE_UPREG:

	{
		ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _ TUNMSTR_TRACE_MSGFROMHMI_FID_HANDLER _
				ET_EN_T16 _ MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_BAND_INFO _ ET_EN_DONE);

		if( !( m_potunmstr_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
		{

			ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _ TUNMSTR_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _ ET_EN_DONE);

		}
		else
		{
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
            tuner::common::enSourceId activeSource = m_poArlImpl->getActiveSource();
            tuner::common::enSrcActivity activeSrcActivity = m_poArlImpl->getActiveSourceActivity();
            if(bIsTemporarySource(activeSource))
            {
            	tuner::common::enSourceId previousSource = m_poSessionControl->getStoredPreviousSessionStateBeforeAnnoucementSrc();
            	if((previousSource != tuner::common::SOURCEID_LIMIT)
            			&& (m_poSessionControl->getStoredPreviousSessionStateBeforeAnnoucementSrcActivity() == tuner::common::SRCPAUSE))
            	{
            		m_potunmstr_MsgToHMI->vSend_g_Band_Info(previousSource, false);
            	}
            }
            else
            {
            	if(activeSrcActivity == tuner::common::SRCOFF || activeSrcActivity == tuner::common::SRCACTIVITY_UNKNOWN)
            	{
            		m_potunmstr_MsgToHMI->vSend_g_Band_Info(activeSource, true);
            	}
            	else
            	{
            		m_potunmstr_MsgToHMI->vSend_g_Band_Info(activeSource, false);
            	}
            }
#else
            tU8 u8Temp = m_potunmstr_SrcChgManager->u8GetCurrentSource();
            m_potunmstr_MsgToHMI->vSend_g_Band_Info(u8Temp, false);
#endif
			//m_potunmstr_MsgToHMI->vSend_g_Band_Info(u8Temp, false);
			//Send Status Message after UP-REG
			ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _ TUNMSTR_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_SUCC _ ET_EN_DONE);

		}


	}
	break;

	case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
	{
		if( !( m_potunmstr_MsgToHMI ->bRemoveNotification( poMessage ) ) )
		{
			/* --- relupreg failt: send an error message --- */
			/* +++ use you own error codes  +++ */

		}
		else
		{
			/* ---
            the reupreg was successful so you can't talk to this client anymore.
            therefore there are normally no actions to be done in this case
            --- */
		}

	}
	break;

	default:
	{
		/* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
		ET_TRACE_ERROR_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _ TUNMSTR_TRACE_MSGFROMHMI_WRONG_OPCODE _
				ET_EN_T16 _ MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_BAND_INFO _ ET_EN_DONE);
		break;
	}
	}

}

/*************************************************************************
 * FUNCTION:    tunmstr_MsgFromHMI::   vHandle_g_Tuner_Source_Availability()
 *
 * DESCRIPTION:
 *
 * PARAMETER:   amt_tclServiceData* poMessage
 *
 * RETURNVALUE: NONE
 *
 *
 *************************************************************************/
tVoid tunmstr_MsgFromHMI :: vHandle_g_Tuner_Source_Availability( amt_tclServiceData* poMessage )
{

	if(( poMessage == NULL )|| (m_potunmstr_MsgToHMI == NULL))
	{

		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		return;

	}

	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_UPREG:

	{
		ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _ TUNMSTR_TRACE_MSGFROMHMI_FID_HANDLER _
				ET_EN_T16 _ MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITY _ ET_EN_DONE);

		if( !( m_potunmstr_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
		{

			ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _ TUNMSTR_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_FAIL _ ET_EN_DONE);

		}
		else
		{


			ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _ TUNMSTR_TRACE_MSGFROMHMI_ADDTO_NOT_TABLE_SUCC _ ET_EN_DONE);
			m_potunmstr_MsgToHMI->vSend_g_Tuner_Source_Availability_status(true);
			// Send this info to HMI


		}


	}
	break;

	case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
	{
		if( !( m_potunmstr_MsgToHMI ->bRemoveNotification( poMessage ) ) )
		{
			/* --- relupreg failt: send an error message --- */
			/* +++ use you own error codes  +++ */

		}
		else
		{
			/* ---
            the reupreg was successful so you can't talk to this client anymore.
            therefore there are normally no actions to be done in this case
            --- */
		}

	}
	break;

	default:
	{
		/* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
		ET_TRACE_ERROR_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _ TUNMSTR_TRACE_MSGFROMHMI_WRONG_OPCODE _
				ET_EN_T16 _ MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_TUNER_SOURCE_AVAILABILITY _ ET_EN_DONE);
		break;
	}
	}

}


/*******************************************************************************
 *FUNCTION:    tunmstr_MsgFromHMI::vHandle_s_TestMode
 *
 *DESCRIPTION: This function will extarct CCA messeage for Test mode sent by HMI
 *
 *
 *
 *PARAMETER:    poMessage
 *
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_MsgFromHMI::vHandle_s_TestMode(amt_tclServiceData* poMessage)
{
	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _\
			TUNMSTR_TRACE_MSG_FROM_HMI_NEW_CCA_MSG _ ET_EN_T16 _\
			MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_TEST_MODE _ ET_EN_DONE );

	// Check message pointer.
	if(( poMessage == NULL )||(m_potunmstr_SrcChgManager == NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT(m_potunmstr_SrcChgManager != NULL);

		ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _\
				TUNMSTR_TRACE_MSG_FROM_NULL_POINTER _ ET_EN_DONE );

		return;
	}
	else
	{


		switch (poMessage->u8GetOpCode())
		{
		case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
		{
			// Get the contents of the switch.

			m_potunmstr_SrcChgManager->vTestMode( poMessage );


			midw_tunermasterfi_tclMsgFID_TUNMSTR_S_TEST_MODEMethodResult oResponce;

			// Response -> SUCC / FAIL / BUSY
			oResponce.TunerMaster_StatusResponse.u8TunermasterStatus.enType = \
					midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED;

		stSendCCAMsg ostSendCCAMsg;
		ostSendCCAMsg.u16DestAppID=poMessage->u16GetSourceAppID();
		ostSendCCAMsg.u16Fid=poMessage->u16GetFunctionID();
		ostSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
		ostSendCCAMsg.u16CmdCtr=poMessage->u16GetCmdCounter();
		ostSendCCAMsg.u16RegID=poMessage->u16GetRegisterID();
		vSendMessage( ostSendCCAMsg,oResponce);
			break;

		}/* end of AMT_C_U8_CCAMSG_OPCODE_METHODSTART  */

		case AMT_C_U8_CCAMSG_OPCODE_ERROR:
		{
			/* Call default Error handling function */

			break;
		}/* end of AMT_C_U8_CCAMSG_OPCODE_ERROR    */

		default:
		{
			// To do send back info with invalid opcode...

			break;
		}/* end of default */
		}/* end of switch (poInMsg->u8GetOpCode())*/

		// delete the CCA message.
		//Need not call Delete function here, as it is takenc are in tunmaster_tclApp::vOnNewMessage

	} /* else */

}
/*******************************************************************************
 *FUNCTION:    tunmstr_MsgFromHMI::vHandle_s_SrcChg_testmode
 *
 *DESCRIPTION: This function will extract CCA message for Tuner switching in test mode
 *
 *
 *
 *PARAMETER:    poMessage
 *
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_MsgFromHMI::vHandle_s_SrcChg_testmode(amt_tclServiceData* poMessage)
{
	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _\
			TUNMSTR_TRACE_MSG_FROM_HMI_NEW_CCA_MSG _ ET_EN_T16 _\
			MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_TEST_MODE _ ET_EN_DONE );

	// Check message pointer.
	if(( poMessage == NULL )||(m_potunmstr_SrcChgManager == NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT(m_potunmstr_SrcChgManager != NULL);

		ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_T16 _\
				TUNMSTR_TRACE_MSG_FROM_NULL_POINTER _ ET_EN_DONE );

		return;
	}
	else
	{


		switch (poMessage->u8GetOpCode())
		{
		case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
		{
			// Get the contents of the switch.

			m_potunmstr_SrcChgManager->vTestMode_SrcChg( poMessage );


			midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SRCCHG_TESTMODEMethodResult oResponce;

			// Response -> SUCC / FAIL / BUSY
			oResponce.TunerMaster_StatusResponse.u8TunermasterStatus.enType = \
					midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED;

		stSendCCAMsg ostSendCCAMsg;
		ostSendCCAMsg.u16DestAppID=poMessage->u16GetSourceAppID();
		ostSendCCAMsg.u16Fid=poMessage->u16GetFunctionID();
		ostSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
		ostSendCCAMsg.u16CmdCtr=poMessage->u16GetCmdCounter();
		ostSendCCAMsg.u16RegID=poMessage->u16GetRegisterID();
		vSendMessage( ostSendCCAMsg,oResponce);
			break;

		}/* end of AMT_C_U8_CCAMSG_OPCODE_METHODSTART  */

		case AMT_C_U8_CCAMSG_OPCODE_ERROR:
		{
			/* Call default Error handling function */

			break;
		}/* end of AMT_C_U8_CCAMSG_OPCODE_ERROR    */

		default:
		{
			// To do send back info with invalid opcode...

			break;
		}/* end of default */
		}/* end of switch (poInMsg->u8GetOpCode())*/

		// delete the CCA message.
		//Need not call Delete function here, as it is takenc are in tunmaster_tclApp::vOnNewMessage

	} /* else */

}

/*******************************************************************************
 *FUNCTION:    tunmstr_MsgFromHMI::vHandle_s_GetActiveTuner_Info
 *
 *DESCRIPTION: This function will extarct CCA messeage for CCA method "TUNMSTR_S_GET_ACTIVETUNER_INFO"
 *
 *PARAMETER:    poMessage
 *
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_MsgFromHMI::vHandle_s_GetActiveTuner_Info(amt_tclServiceData* poMessage)
{

	// Check message pointer.
	if(( poMessage == NULL )||(m_potunmstr_TunerClientHandler == NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT(m_potunmstr_TunerClientHandler != NULL);

		ETG_TRACE_USR4((" tunmstr_MsgFromHMI::vHandle_s_GetActiveTuner_Info, Null pointer"));
		return;
	}

	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
	{
		// Get the contents of the switch.
		m_potunmstr_TunerClientHandler->vSend_s_ActiveTuner();
		vSetRegID(poMessage->u16GetRegisterID());
		vSetCmdCntr(poMessage->u16GetCmdCounter());
		vSetAppID_ActiveTuner(poMessage->u16GetSourceAppID());
		break;

	}/* end of AMT_C_U8_CCAMSG_OPCODE_METHODSTART  */

	case AMT_C_U8_CCAMSG_OPCODE_ERROR:
	{
		/* Call default Error handling function */
		break;
	}/* end of AMT_C_U8_CCAMSG_OPCODE_ERROR    */

	default:
	{
		// To do send back info with invalid opcode...

		break;
	}/* end of default */
	}/* end of switch (poInMsg->u8GetOpCode())*/

	// delete the CCA message.
	//Need not call Delete function here, as it is takenc are in tunmaster_tclApp::vOnNewMessage
}
/*******************************************************************************
 *FUNCTION:    tunmstr_MsgFromHMI::vHandle_s_DirectFrequency_Input
 *
 *DESCRIPTION: This function will extarct CCA messeage for CCA method "FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUT"
 *
 *PARAMETER:    poMessage
 *
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_MsgFromHMI::vHandle_s_DirectFrequency_Input(amt_tclServiceData* poMessage)
{

	// Check message pointer.
	if(( poMessage == NULL )||(m_potunmstr_SrcChgManager == NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT(m_potunmstr_SrcChgManager != NULL);

		ETG_TRACE_USR4((" tunmstr_MsgFromHMI::vHandle_s_DirectFrequency_Input, Null pointer"));
		return;
	}

	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
	{
		// Get the contents of the switch.
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodStart oMsgData;
			//create an object of  FID_TUNMSTR_S_DIRECT_FREQUENCY_INPUT
			vGetDatafromAMT(poMessage,oMsgData);
		bool bIsRequestValid = m_poSessionControl->bOnDirectFrequency(oMsgData.Band.enType, oMsgData.Frequency);
#else
		m_potunmstr_SrcChgManager->vCheckforFrequencyChange(poMessage);
#endif
		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_DIRECT_FREQUENCY_INPUTMethodResult oResponce;

		// Response -> SUCC / FAIL / BUSY
		oResponce.TunerMaster_StatusResponse.u8TunermasterStatus.enType = \
				midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED;

		//------------------------------
		// Send the response to client.
		//------------------------------
		stSendCCAMsg ostSendCCAMsg;
		ostSendCCAMsg.u16DestAppID=poMessage->u16GetSourceAppID();
		ostSendCCAMsg.u16Fid=poMessage->u16GetFunctionID();
		ostSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT; 
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		oResponce.TunerMaster_StatusResponse.u8TunermasterStatus.enType= bIsRequestValid ? midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED : midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_FAIL;
#endif
		ostSendCCAMsg.u16CmdCtr=poMessage->u16GetCmdCounter();
		ostSendCCAMsg.u16RegID=poMessage->u16GetRegisterID();
		vSendMessage( ostSendCCAMsg,oResponce);
		ETG_TRACE_USR4((" tunmstr_MsgFromHMI::vHandle_s_DirectFrequency_Input, Result Sent to HMI"));
		break;

	}/* end of AMT_C_U8_CCAMSG_OPCODE_METHODSTART  */

	case AMT_C_U8_CCAMSG_OPCODE_ERROR:
	{
		/* Call default Error handling function */
		break;
	}/* end of AMT_C_U8_CCAMSG_OPCODE_ERROR    */

	default:
	{
		// To do send back info with invalid opcode...

		break;
	}/* end of default */
	}/* end of switch (poInMsg->u8GetOpCode())*/

	// delete the CCA message.
	//Need not call Delete function here, as it is takenc are in tunmaster_tclApp::vOnNewMessage
}// end of function


/*************************************************************************
 * FUNCTION:    tunmstr_MsgFromHMI::   vHandle_s_PresetHandling()
 *
 * DESCRIPTION: Fuction to handle FID_TUNMSTR_S_PRESET_HANDLING Method start
 *
 * PARAMETER:   amt_tclServiceData* poMessage
 *
 * RETURNVALUE: NONE
 *************************************************************************/
tVoid tunmstr_MsgFromHMI ::vHandle_s_PresetHandling(amt_tclServiceData* poMessage)
{
	if(m_potunmstr_Preset_Handler==NULL)
	{
      ETG_TRACE_USR4(("m_potunmstr_Preset_Handler is NULL"));
		return;
	}
	ETG_TRACE_USR4(("vHandle_s_PresetHandling()"));
	switch(poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
		{
			m_potunmstr_Preset_Handler->vHandlePreset(poMessage);
			break;
		}
	default:
		{
			break;
		}
	}
}
/*************************************************************************
 * FUNCTION:    tunmstr_MsgFromHMI::   vHandle_s_AutoStore()
 *
 * DESCRIPTION: Handle for FID_TUNMSTR_S_AUTOSTORE
 *
 * PARAMETER:   amt_tclServiceData* poMessage
 *
 * RETURNVALUE: NONE
 *************************************************************************/
tVoid tunmstr_MsgFromHMI ::vHandle_s_AutoStore(amt_tclServiceData* poMessage)
{
	if((m_ptunmstr_AutoStoreHandler==NULL) || (poMessage == NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_ptunmstr_AutoStoreHandler != NULL );
		return;
	}

	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
	{
		// Get the contents of the switch.
		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodStart oMsg;
		vGetDatafromAMT(poMessage,oMsg );

		// Response -> SUCC / FAIL / BUSY
		tBool blAST_Status = oMsg.AutoStore_Start;
		tU8 u8ListID = (tU8)oMsg.List.enType;
		tU8 u8AST_Type = (tU8)oMsg.AST_Type.enType;
		m_ptunmstr_AutoStoreHandler->vSetCmd_Cntr(poMessage->u16GetCmdCounter());
		m_ptunmstr_AutoStoreHandler->vSetAstRegID(poMessage->u16GetRegisterID());
		m_AST_APPID = poMessage->u16GetSourceAppID();
		m_ptunmstr_AutoStoreHandler->vHandle_ASTRequest(blAST_Status,u8ListID,u8AST_Type);
		ETG_TRACE_USR4((" tunmstr_MsgFromHMI::vHandle_s_AutoStore-> ListID = %d, Type = %d, ListM = %d, TypeM = %d , AppID =%d",u8ListID, u8AST_Type, oMsg.List.enType, oMsg.AST_Type.enType, m_AST_APPID));

	}break;

	case AMT_C_U8_CCAMSG_OPCODE_ERROR:
	{
		/* Call default Error handling function */
		break;
	}/* end of AMT_C_U8_CCAMSG_OPCODE_ERROR    */

	default:
	break;
	}/* end of switch (poInMsg->u8GetOpCode())*/

}// end of function

/*************************************************************************
 * FUNCTION:    tunmstr_MsgFromHMI::   vSendAST_MethodResult()
 *
 * DESCRIPTION: This function will extract CCA message for RF_ANTENNA_TEST
 *
 * PARAMETER:   amt_tclServiceData* poMessage
 *
 * RETURNVALUE: NONE
 *************************************************************************/

tVoid tunmstr_MsgFromHMI::vSendAST_MethodResult(tU8 u8Source, tU8 u8Action, tU8 u8Opcode)
{
    if((m_ptunmstr_AutoStoreHandler==NULL) || (m_potunmstr_MsgToHMI==NULL))
	{
		ETG_TRACE_USR4(("vSendAST_MethodResult, Assert"));
        NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
        NORMAL_M_ASSERT( m_ptunmstr_AutoStoreHandler != NULL );
		return;
	}
	midw_tunermasterfi_tclMsgFID_TUNMSTR_S_AUTOSTOREMethodResult oResponce;
	stSendCCAMsg ostSendCCAMsg;
	ostSendCCAMsg.u16DestAppID=m_AST_APPID;
	ostSendCCAMsg.u16Fid=MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_AUTOSTORE;
	ostSendCCAMsg.u16CmdCtr=m_ptunmstr_AutoStoreHandler->u16GetCMd_Cntr();
	ostSendCCAMsg.u16RegID=m_ptunmstr_AutoStoreHandler->u16GetASTRegId();
	if(u8Opcode ==AMT_C_U8_CCAMSG_OPCODE_ERROR)
	{
		oResponce.TunerMaster_StatusResponse.u8TunermasterStatus.enType = \
		midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_FAIL;
	}
	else
	{
		oResponce.TunerMaster_StatusResponse.u8TunermasterStatus.enType = \
		midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED;
	}
	// Response -> SUCC / FAIL / BUSY
	oResponce.Action.enType = (midw_fi_tcl_e8_Action::tenType)u8Action;
	oResponce.Source.enType = (midw_fi_tcl_e8_Source::tenType)u8Source;
	ostSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
	vSendMessage( ostSendCCAMsg,oResponce);
	ETG_TRACE_USR4(("tunmstr_MsgFromHMI::vSendAST_MethodResult()"));
    /**autostore is complete deactivate the state*/
    ETG_TRACE_USR4(("tunmstr_MsgFromHMI::vSendAST_MethodResult() post autostore property status"));

    m_ptunmstr_AutoStoreHandler->vSetAST_Status(FALSE);
    m_ptunmstr_AutoStoreHandler-> vSetNormalAST_Status(FALSE);
    m_potunmstr_MsgToHMI->vSend_g_GetAutostoreStatus\
    (m_ptunmstr_AutoStoreHandler->blGetAST_Status(), m_ptunmstr_AutoStoreHandler->u8GetAST_Type());
}//end of function


/*************************************************************************
 * FUNCTION:    tunmstr_MsgFromHMI::   vHandle_g_Get_Autostore_Status()
 *
 * DESCRIPTION: This function will extract CCA message for Autostore Status
 *
 * PARAMETER:   amt_tclServiceData* poMessage
 *
 * RETURNVALUE: NONE
 *************************************************************************/
tVoid tunmstr_MsgFromHMI::vHandle_g_Get_Autostore_Status(amt_tclServiceData *poMessage)
{
    if(( poMessage == NULL )|| (m_potunmstr_MsgToHMI == NULL) || (m_ptunmstr_AutoStoreHandler == NULL))
    {
        NORMAL_M_ASSERT( poMessage != NULL );
        NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
        NORMAL_M_ASSERT( m_ptunmstr_AutoStoreHandler != NULL );
        return;
    }

    switch (poMessage->u8GetOpCode())
    {
    case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
    {
        ETG_TRACE_USR4(("tunmstr_MsgFromHMI::vHandle_g_Get_Autostore_Status ---> Wrong Opcode"));
        break;
    }

    case AMT_C_U8_CCAMSG_OPCODE_UPREG:
    {
        ETG_TRACE_USR4(("tunmstr_MsgFromHMI::vHandle_g_Get_Autostore_Status ---> UPREG"));

        if( !( m_potunmstr_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
        {
            ETG_TRACE_USR4(("tunmstr_MsgFromHMI::vHandle_g_Get_Autostore_Status ---> UPREG - FAIL"));
        }
        else
        {
            m_potunmstr_MsgToHMI->vSend_g_GetAutostoreStatus\
                    ( m_ptunmstr_AutoStoreHandler->blGetAST_Status(), m_ptunmstr_AutoStoreHandler->u8GetAST_Type() );
            ETG_TRACE_USR4(("tunmstr_MsgFromHMI::vHandle_g_Get_Autostore_Status---> Status on Upreg sent"));
        }
    }
    break;

    case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
    {
        if( !( m_potunmstr_MsgToHMI ->bRemoveNotification( poMessage ) ) )
        {
            /* --- relupreg fail: send an error message --- */
            /* +++ use you own error codes  +++ */
        }
        else
        {
            /* ---
            the reupreg was successful so you can't talk to this client anymore.
            therefore there are normally no actions to be done in this case
            --- */
        }
    }
    break;

    default:
    {
        /* +++
         unkown opcode:
         enter error handling here ( trace or assert )
         +++ */
        ETG_TRACE_USR4(("tunmstr_MsgFromHMI::vHandle_g_Get_Autostore_Status---> Wrong Opcode.... default case"));
        break;
    }
    }
}//end of function


/*************************************************************************
 * FUNCTION:    tunmstr_MsgFromHMI::   vHandle_g_PresetList()
 *
 * DESCRIPTION: This function will extract CCA message for PresetList
 *
 * PARAMETER:   amt_tclServiceData* poMessage
 *
 * RETURNVALUE: NONE
 *************************************************************************/
tVoid tunmstr_MsgFromHMI :: vHandle_g_PresetList( amt_tclServiceData* poMessage )
{
	ETG_TRACE_USR4(("vHandle_g_PresetList()"));
	if(( poMessage == NULL )||(m_potunmstr_MsgToHMI==NULL)\
		||(m_potunmstr_DABClient_Handler==NULL)||(m_potunmstr_TunerClientHandler==NULL)||(m_poclConfigInterface==NULL) || (m_potunmstr_Preset_Handler == NULL)
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
		|| (m_potunermaster_SXMClient == NULL)
#endif
		)
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		NORMAL_M_ASSERT( m_potunmstr_DABClient_Handler != NULL );
		NORMAL_M_ASSERT( m_poclConfigInterface != NULL );
		NORMAL_M_ASSERT( m_potunmstr_TunerClientHandler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_Preset_Handler != NULL );
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
		NORMAL_M_ASSERT( m_potunermaster_SXMClient != NULL );
#endif
		return;
	}
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
	{
		//wrong opcode
		break;
	}
	case AMT_C_U8_CCAMSG_OPCODE_UPREG:
	{
		if( !( m_potunmstr_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
		{
			//add to notification table failed
			ETG_TRACE_USR4((" vHandle_g_PresetList::add to notification table failed"));
		}
		else
		{
			if((m_poclConfigInterface->u32GetConfigData("PresetListType")) && (m_poclConfigInterface->u32GetConfigData("SXMSupported")))
			{
				ETG_TRACE_USR4((" vHandle_g_PresetList::start up flag updated on service state available of both tuner and SXM"));
			}
			else
			{
				m_potunmstr_Preset_Handler->Update_tunmstr_bStartUpFlag(TRUE);
			}

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_SUZUKI
			m_potunmstr_TunerClientHandler->vRequestPresetList_Suzuki();
#else
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
			m_potunmstr_TunerClientHandler->vRequestMixedPresetList();
#else
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_CAF
			m_potunmstr_TunerClientHandler->vRequestPresetList_Suzuki();
#else
			if(m_poclConfigInterface->u32GetConfigData("PresetListType"))
			{
				if(m_poclConfigInterface->u32GetConfigData("SXMSupported"))
				{
					if((m_potunmstr_Preset_Handler->u8GetTunerStartUp_HMI_Update() == 0x00) && (m_potunmstr_Preset_Handler->u8GetSXMStartUp_HMI_Update() == 0x00))
					{
						m_potunmstr_Preset_Handler->vSendMixedPresetList();
					}
					else
					{
						ETG_TRACE_USR4((" vHandle_g_PresetList::preset lists requested on service availability"));
					}
				}
				else
				{
					m_potunmstr_TunerClientHandler->vRequestMixedPresetList();
				}
			}
			else
			{
				m_potunmstr_TunerClientHandler->vRequestPresetList();
			}
#endif/** END CAF*/
#endif/** END PSA */
#endif /** END SUZUKI*/
		
			if(m_poclConfigInterface->u32GetConfigData("DABSupported"))
			{
				m_potunmstr_DABClient_Handler->vSendPresetListReq();
			}
		}
		break;
	}
	case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
	{
		if( !( m_potunmstr_MsgToHMI ->bRemoveNotification( poMessage ) ) )
		{
			//Remove from notification table failed
			ETG_TRACE_USR4((" vHandle_g_PresetList()->Remove from notification table failed"));
		}
		else
		{
			//Remove from notification table succ
			ETG_TRACE_USR4((" vHandle_g_PresetList()->Remove from notification table succ"));
		}
		break;
	}
	default:
	{
		ETG_TRACE_USR4((" vHandle_g_PresetList()->Wrong opcode"));
		break;
	}
	}
}

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
/*************************************************************************
 * FUNCTION:    tunmstr_MsgFromHMI::   vHandle_g_Preset_ChannelUpdate()
 *
 * DESCRIPTION: This function will extract CCA message for PresetChannelUpdate
 *
 * PARAMETER:   amt_tclServiceData* poMessage
 *
 * RETURNVALUE: NONE
 *************************************************************************/
tVoid tunmstr_MsgFromHMI :: vHandle_g_Preset_ChannelUpdate( amt_tclServiceData* poMessage )
{
	ETG_TRACE_USR4(("vHandle_g_Preset_ChannelUpdate()"));

	if(( poMessage == NULL ) || (m_potunmstr_MsgToHMI == NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		return;
	}

	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
		{
			//wrong opcode
			break;
		}
		case AMT_C_U8_CCAMSG_OPCODE_UPREG:
		{
			if( !( m_potunmstr_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
			{
				//add to notification table failed
				ETG_TRACE_USR4((" vHandle_g_Preset_ChannelUpdate::add to notification table failed"));
			}
			else
			{
				ETG_TRACE_USR4((" vHandle_g_Preset_ChannelUpdate::add to notification table success"));
			}

			break;
		}
		case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
		{
			if( !( m_potunmstr_MsgToHMI ->bRemoveNotification( poMessage ) ) )
			{
				//Remove from notification table failed
				ETG_TRACE_USR4((" vHandle_g_Preset_ChannelUpdate()->Remove from notification table failed"));
			}
			else
			{
				//Remove from notification table succ
				ETG_TRACE_USR4((" vHandle_g_Preset_ChannelUpdate()->Remove from notification table succ"));
			}
			break;
		}
		default:
		{
			ETG_TRACE_USR4((" vHandle_g_Preset_ChannelUpdate()->Wrong opcode"));
			break;
		}
	}
}

/*************************************************************************
 * FUNCTION:    tunmstr_MsgFromHMI::   vHandle_g_System_Message()
 *
 * DESCRIPTION: This function will extract CCA message for SXM System Message
 *
 * PARAMETER:   amt_tclServiceData* poMessage
 *
 * RETURNVALUE: NONE
 *************************************************************************/
tVoid tunmstr_MsgFromHMI :: vHandle_g_System_Message( amt_tclServiceData* poMessage )
{
	ETG_TRACE_USR4(("vHandle_g_System_Message()"));

	if(( poMessage == NULL ) || (m_potunmstr_MsgToHMI == NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		return;
	}

	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_UPREG:
		{
			if( !( m_potunmstr_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
			{
				//add to notification table failed
				ETG_TRACE_USR4((" vHandle_g_System_Message::add to notification table failed"));
			}
			else
			{
				ETG_TRACE_USR4((" vHandle_g_System_Message::add to notification table success"));
			}

			break;
		}
		case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
		{
			if( !( m_potunmstr_MsgToHMI ->bRemoveNotification( poMessage ) ) )
			{
				//Remove from notification table failed
				ETG_TRACE_USR4((" vHandle_g_System_Message()->Remove from notification table failed"));
			}
			else
			{
				//Remove from notification table succ
				ETG_TRACE_USR4((" vHandle_g_System_Message()->Remove from notification table succ"));
			}
			break;
		}
		default:
		{
			ETG_TRACE_USR4((" vHandle_g_System_Message()->Wrong opcode"));
			break;
		}
	}
}


/*************************************************************************
 * FUNCTION:    tunmstr_MsgFromHMI::   vHandle_s_get_ChannelArtList()
 *
 * DESCRIPTION: This function will extract CCA message for MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_GET_CHANNELART_LIST
 *
 * PARAMETER:   amt_tclServiceData* poMessage
 *
 * RETURNVALUE: NONE
 *************************************************************************/
tVoid tunmstr_MsgFromHMI :: vHandle_s_get_ChannelArtList( amt_tclServiceData* poMessage )
{
	ETG_TRACE_USR4(("vHandle_s_get_ChannelArtList()"));

	if(( poMessage == NULL ) || (m_potunmstr_MsgToHMI == NULL) || (m_potunermaster_SXMchannelartClient == NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		NORMAL_M_ASSERT( m_potunermaster_SXMchannelartClient != NULL );
		return;
	}

	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
		{
			if(m_potunermaster_SXMchannelartClient->bGetServiceStatus())
			{
				m_potunmstr_Preset_Handler->vRequestChannelArtList(poMessage);
			}
			else
			{
				midw_tunermasterfi_tclMsgFID_TUNMSTR_S_GET_SXMCHANNELART_LISTMethodResult oMethodResult;
				oMethodResult.TunerMaster_StatusResponse.u8TunermasterStatus.enType = \
						midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_FAIL;
				stSendCCAMsg ostSendCCAMsg;
				ostSendCCAMsg.u16DestAppID=poMessage->u16GetSourceAppID();
				ostSendCCAMsg.u16Fid=poMessage->u16GetFunctionID();
				ostSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
				ostSendCCAMsg.u16CmdCtr=poMessage->u16GetCmdCounter();
				ostSendCCAMsg.u16RegID=poMessage->u16GetRegisterID();
				vSendMessage( ostSendCCAMsg,oMethodResult);
			}
			break;
		}
		default:
		{
			ETG_TRACE_USR4((" vHandle_s_get_ChannelArtList()->Wrong opcode"));
			break;
		}
	}
}


#endif

#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
/*************************************************************************
 * FUNCTION:    tunmstr_MsgFromHMI::   vHandle_g_SXM_PresetHandling()
 *
 * DESCRIPTION: This function will extract CCA message for SXM preset operations
 *
 * PARAMETER:   amt_tclServiceData* poMessage
 *
 * RETURNVALUE: NONE
 *************************************************************************/
tVoid tunmstr_MsgFromHMI :: vHandle_g_SXM_PresetHandling( amt_tclServiceData* poMessage )
{
	ETG_TRACE_USR4(("vHandle_g_SXM_PresetHandling()"));

	if(( poMessage == NULL ) || (m_potunmstr_MsgToHMI == NULL) || (m_potunmstr_Preset_Handler == NULL) || (m_potunmstr_TunerClientHandler == NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		NORMAL_M_ASSERT( m_potunmstr_Preset_Handler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_TunerClientHandler != NULL );
		return;
	}

	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_UPREG:
		{
			if( !( m_potunmstr_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
			{
				//add to notification table failed
				ETG_TRACE_USR4((" vHandle_g_SXM_PresetHandling::add to notification table failed"));
			}
			else
			{
				if(poMessage->u16GetSourceAppID() == CCA_C_U16_APP_FC_SXM_360L)
				{
					ETG_TRACE_USR4((" vHandle_g_SXM_PresetHandling::add to notification table success"));

					m_bSXM360LClientAvail = TRUE;
					
					if(m_potunmstr_TunerClientHandler->u8GetTunerService())
					{
						m_potunmstr_Preset_Handler->Update_tunmstr_bStartUpFlag(TRUE);
						m_potunmstr_TunerClientHandler->vRequestMixedPresetList();
						m_potunmstr_Preset_Handler->Inc_m_u8SXMStartUp_HMI_Update();
						midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_PRESET_HANDLINGStatus oStatus;
						oStatus.Preset_Action.enType = midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_GETPRESETLIST;
						oStatus.PresetIndex = 0x00;
						m_potunmstr_MsgToHMI->vHandleSXM360LPresetRequest(oStatus);
					}

				}
			}

			break;
		}
		case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
		{
			if( !( m_potunmstr_MsgToHMI ->bRemoveNotification( poMessage ) ) )
			{
				//Remove from notification table failed
				ETG_TRACE_USR4((" vHandle_g_SXM_PresetHandling()->Remove from notification table failed"));
			}
			else
			{
				//Remove from notification table succ
				if(poMessage->u16GetSourceAppID() == CCA_C_U16_APP_FC_SXM_360L)
				{
					m_bSXM360LClientAvail = FALSE;
					m_potunmstr_Preset_Handler->Dec_m_u8SXMStartUp_HMI_Update(true);
					ETG_TRACE_USR4((" vHandle_g_SXM_PresetHandling()->Remove from notification table succ"));
				}
			}
			break;
		}
		default:
		{
			ETG_TRACE_USR4((" vHandle_g_SXM_PresetHandling()->Wrong opcode"));
			break;
		}
	}
}


/*************************************************************************
 * FUNCTION:    tunmstr_MsgFromHMI::   vHandle_s_HandleSXMPreset()
 *
 * DESCRIPTION: This function will extract CCA message for SXM preset list
 *
 * PARAMETER:   amt_tclServiceData* poMessage
 *
 * RETURNVALUE: NONE
 *************************************************************************/
tVoid tunmstr_MsgFromHMI :: vHandle_s_HandleSXMPreset(amt_tclServiceData* poMessage)
{

	if(( poMessage == NULL ) || (m_potunmstr_Preset_Handler == NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_Preset_Handler != NULL );
		return;
	}

	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
		{
			ETG_TRACE_USR4(("vHandle_s_HandleSXMPreset()"));
			m_potunmstr_Preset_Handler->vUpdateSXM360LPresetList(poMessage);
			break;
		}
		default:
		{
			ETG_TRACE_USR4((" vHandle_s_HandleSXMPreset()->Wrong opcode"));
			break;
		}
	}

}


/*************************************************************************
 * FUNCTION:    tunmstr_MsgFromHMI::   vHandle_s_SXM_PresetAutoCompare()
 *
 * DESCRIPTION: Fuction to handle FID_TUNMSTR_S_SXM_PRESETAUTOCOMPARE Method start
 *
 * PARAMETER:   amt_tclServiceData* poMessage
 *
 * RETURNVALUE: NONE
 *************************************************************************/
tVoid tunmstr_MsgFromHMI::vHandle_s_SXM_PresetAutoCompare(amt_tclServiceData* poMessage)
{
	if( (poMessage == NULL ) || (m_potunmstr_MsgToHMI == NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		return;
	}

	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
	{
		// Get the contents of the switch.
		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodStart oMsg;
		vGetDatafromAMT(poMessage,oMsg );

		ETG_TRACE_USR4(("vHandle_s_SXM_PresetAutoCompare() preset autocompare : %d, userpresetaction : %d", oMsg.u8PresetAutoCompare, oMsg.bUserPresetAction));
					
		m_u8SXMPresetAutocompare = oMsg.u8PresetAutoCompare;
		m_bSXMUserPresetAction = oMsg.bUserPresetAction;

		if(bGetSXMSrcState() == TRUE)
		{
			m_potunmstr_MsgToHMI->vSend_g_PresetAutoCompare(m_u8SXMPresetAutocompare, m_bSXMUserPresetAction);
		}

		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_PRESETAUTOCOMPAREMethodResult oResponce;
		// Response -> SUCC / FAIL / BUSY
		oResponce.TunerMaster_StatusResponse.u8TunermasterStatus.enType = \
				midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED;
		stSendCCAMsg ostSendCCAMsg;
		ostSendCCAMsg.u16DestAppID=poMessage->u16GetSourceAppID();
		ostSendCCAMsg.u16Fid=poMessage->u16GetFunctionID();
		ostSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
		ostSendCCAMsg.u16CmdCtr=poMessage->u16GetCmdCounter();
		ostSendCCAMsg.u16RegID=poMessage->u16GetRegisterID();
		vSendMessage( ostSendCCAMsg,oResponce);

		break;
	}

	default:
		break;
	}/* end of switch (poInMsg->u8GetOpCode())*/
}


tBool tunmstr_MsgFromHMI::bGetSXM360LServiceStatus()
{
	ETG_TRACE_USR4(("bGetSXM360LServiceStatus(), status : %d", m_bSXM360LClientAvail));
	return m_bSXM360LClientAvail;
}

#endif

#if defined(VARIANT_S_FTR_ENABLE_SXMCLIENT) || defined(VARIANT_S_FTR_ENABLE_SXM360LCLIENT)
/*************************************************************************
 * FUNCTION:    tunmstr_MsgFromHMI::   vHandle_s_SXM_SrcState()
 *
 * DESCRIPTION: Fuction to handle FID_TUNMSTR_S_SXM_SRCSTATE Method start
 *
 * PARAMETER:   amt_tclServiceData* poMessage
 *
 * RETURNVALUE: NONE
 *************************************************************************/
tVoid tunmstr_MsgFromHMI::vHandle_s_SXM_SrcState(amt_tclServiceData* poMessage)
{
	if( (poMessage == NULL ) || (m_potunmstr_TunerClientHandler == NULL) || (m_potunmstr_MsgToHMI == NULL) || (m_poArlImpl == NULL)
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	|| (m_potunermaster_SXMClient == NULL)
#endif
	)
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_TunerClientHandler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		NORMAL_M_ASSERT( m_poArlImpl != NULL );
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
		NORMAL_M_ASSERT( m_potunermaster_SXMClient != NULL );
#endif
		return;
	}

	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
	{
		// Get the contents of the switch.
		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodStart oMsg;
		vGetDatafromAMT(poMessage,oMsg );

		m_bSXMSrcState = oMsg.bSrcState;
		ETG_TRACE_USR4(("vHandle_s_SXM_SrcState() bSXMSrcState : %d", m_bSXMSrcState));

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB

		tU8 u8SrcActivity  = (tU8)m_poArlImpl->getActiveSourceActivity();

		ETG_TRACE_USR4((" vHandle_g_Preset_AutoCompare, src activity : %d", u8SrcActivity));

		if((u8SrcActivity == (tU8)tuner::common::SRCON) || (u8SrcActivity == (tU8)tuner::common::SRCPAUSE))
		{
			if(m_potunmstr_TunerClientHandler->u8GetPresetAutoCompare() != 0xFF)
				m_potunmstr_MsgToHMI->vSend_g_PresetAutoCompare(m_potunmstr_TunerClientHandler->u8GetPresetAutoCompare(), m_potunmstr_TunerClientHandler->bGetUserPresetAction());
		}
		else
		{
			if(m_bSXMSrcState)
			{
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
				if(m_potunermaster_SXMClient->u8GetPresetAutoCompare() != 0xFF)
					m_potunmstr_MsgToHMI->vSend_g_PresetAutoCompare(m_potunermaster_SXMClient->u8GetPresetAutoCompare(), FALSE);
#else
				if(m_u8SXMPresetAutocompare != 0xFF)
					m_potunmstr_MsgToHMI->vSend_g_PresetAutoCompare(m_u8SXMPresetAutocompare, m_bSXMUserPresetAction);
#endif
			}
		}
#endif

		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_SRCSTATEMethodResult oResponce;
		// Response -> SUCC / FAIL / BUSY
		oResponce.TunerMaster_StatusResponse.u8TunermasterStatus.enType = \
				midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED;
		stSendCCAMsg ostSendCCAMsg;
		ostSendCCAMsg.u16DestAppID=poMessage->u16GetSourceAppID();
		ostSendCCAMsg.u16Fid=poMessage->u16GetFunctionID();
		ostSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
		ostSendCCAMsg.u16CmdCtr=poMessage->u16GetCmdCounter();
		ostSendCCAMsg.u16RegID=poMessage->u16GetRegisterID();
		vSendMessage( ostSendCCAMsg,oResponce);

		break;
	}

	default:
		break;
	}/* end of switch (poInMsg->u8GetOpCode())*/
}


/*************************************************************************
 * FUNCTION:    tunmstr_MsgFromHMI::   bGetSXMSrcState()
 *
 * DESCRIPTION: Function to get SXM source state state
 *
 * PARAMETER:
 *
 * RETURNVALUE: tBool
 *************************************************************************/
tBool tunmstr_MsgFromHMI::bGetSXMSrcState()
{
	ETG_TRACE_USR4(("bGetSXMSrcState() SXMSrcState : %d", m_bSXMSrcState));
	return m_bSXMSrcState;
}

#endif


/*************************************************************************
 * FUNCTION:    tunmstr_MsgFromHMI::   vHandle_g_Preset_AutoCompare()
 *
 * DESCRIPTION: This function will register clients for preset auto compare
 *
 * PARAMETER:   amt_tclServiceData* poMessage
 *
 * RETURNVALUE: NONE
 *************************************************************************/
tVoid tunmstr_MsgFromHMI :: vHandle_g_Preset_AutoCompare( amt_tclServiceData* poMessage )
{
	ETG_TRACE_USR4(("vHandle_g_Preset_AutoCompare()"));

	if(( poMessage == NULL ) || (m_potunmstr_MsgToHMI == NULL) || (m_potunmstr_DABClient_Handler == NULL) || (m_potunmstr_TunerClientHandler == NULL)
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	|| (m_poArlImpl == NULL) || (m_poSessionControl == NULL)
#endif
	   )
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		NORMAL_M_ASSERT( m_potunmstr_DABClient_Handler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_TunerClientHandler != NULL );
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT( m_poArlImpl != NULL );
		NORMAL_M_ASSERT( m_poSessionControl != NULL );
#endif
		return;
	}

	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_UPREG:
		{
			if( !( m_potunmstr_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
			{
				//add to notification table failed
				ETG_TRACE_USR4((" vHandle_g_Preset_AutoCompare::add to notification table failed"));
			}
			else
			{
				ETG_TRACE_USR4((" vHandle_g_Preset_AutoCompare::add to notification table success"));
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
				tU8 u8ActiveTunerBand = (tU8)m_poSessionControl->getActiveTunerBand();
				tU8 u8SrcActivity  = (tU8)m_poArlImpl->getActiveSourceActivity();

				ETG_TRACE_USR4((" vHandle_g_Preset_AutoCompare, source : %d , srcactivity : %d", u8ActiveTunerBand, u8SrcActivity));

				if((u8ActiveTunerBand == (tU8)tuner::common::BANDDAB) && ((u8SrcActivity == (tU8)tuner::common::SRCON) || (u8SrcActivity == (tU8)tuner::common::SRCPAUSE)))
				{
					if(m_potunmstr_DABClient_Handler->u8GetPresetAutoCompare() != 0xFF)
						m_potunmstr_MsgToHMI->vSend_g_PresetAutoCompare(m_potunmstr_DABClient_Handler->u8GetPresetAutoCompare(), FALSE);
				}
				else if(((u8ActiveTunerBand == (tU8)tuner::common::BANDFM) || (u8ActiveTunerBand == (tU8)tuner::common::BANDLW) || (u8ActiveTunerBand == (tU8)tuner::common::BANDMW) || (u8ActiveTunerBand == (tU8)tuner::common::BANDCB1))
						&& ((u8SrcActivity == (tU8)tuner::common::SRCON) || (u8SrcActivity == (tU8)tuner::common::SRCPAUSE)))
				{
					if(m_potunmstr_TunerClientHandler->u8GetPresetAutoCompare() != 0xFF)
						m_potunmstr_MsgToHMI->vSend_g_PresetAutoCompare(m_potunmstr_TunerClientHandler->u8GetPresetAutoCompare() , m_potunmstr_TunerClientHandler->bGetUserPresetAction());
				}
				else
				{
#if defined(VARIANT_S_FTR_ENABLE_SXMCLIENT) || defined(VARIANT_S_FTR_ENABLE_SXM360LCLIENT)
					if(m_bSXMSrcState)
					{
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
						if(m_potunermaster_SXMClient->u8GetPresetAutoCompare() != 0xFF)
							m_potunmstr_MsgToHMI->vSend_g_PresetAutoCompare(m_potunermaster_SXMClient->u8GetPresetAutoCompare(), FALSE);
#else
						if(m_u8SXMPresetAutocompare != 0xFF)
							m_potunmstr_MsgToHMI->vSend_g_PresetAutoCompare(m_u8SXMPresetAutocompare, m_bSXMUserPresetAction);
#endif
					}
#endif
				}
#endif
			}

			break;
		}
		case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
		{
			if( !( m_potunmstr_MsgToHMI ->bRemoveNotification( poMessage ) ) )
			{
				//Remove from notification table failed
				ETG_TRACE_USR4((" vHandle_g_Preset_AutoCompare()->Remove from notification table failed"));
			}
			else
			{
				//Remove from notification table succ
				ETG_TRACE_USR4((" vHandle_g_Preset_AutoCompare()->Remove from notification table succ"));
			}
			break;
		}
		default:
		{
			ETG_TRACE_USR4((" vHandle_g_Preset_AutoCompare()->Wrong opcode"));
			break;
		}
	}
}


/*************************************************************************
 * FUNCTION:    tunmstr_MsgFromHMI::   vHandle_s_Set_PSFreeze()
 *
 * DESCRIPTION: Fuction to handle FID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZE Method start
 *
 * PARAMETER:   amt_tclServiceData* poMessage
 *
 * RETURNVALUE: NONE
 *************************************************************************/
tVoid tunmstr_MsgFromHMI::vHandle_s_Set_PSFreeze(amt_tclServiceData* poMessage)
{
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
	{
		if(m_potunmstr_TunerClientHandler != NULL)
		{
			// Get the contents of the switch.
			midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodStart oMsg;
			vGetDatafromAMT(poMessage,oMsg );

			m_potunmstr_TunerClientHandler->vSendPSFreezeReq((tU8)oMsg.e8Mode.enType);

			midw_tunermasterfi_tclMsgFID_TUNMSTR_S_PRESET_STORAGE_PS_FREEZEMethodResult oResponce;
			// Response -> SUCC / FAIL / BUSY
			oResponce.TunerMaster_StatusResponse.u8TunermasterStatus.enType = \
					midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED;
			stSendCCAMsg ostSendCCAMsg;
			ostSendCCAMsg.u16DestAppID=poMessage->u16GetSourceAppID();
			ostSendCCAMsg.u16Fid=poMessage->u16GetFunctionID();
			ostSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
			ostSendCCAMsg.u16CmdCtr=poMessage->u16GetCmdCounter();
			ostSendCCAMsg.u16RegID=poMessage->u16GetRegisterID();
			vSendMessage( ostSendCCAMsg,oResponce);
		}

		break;
	}

	default:
		break;
	}/* end of switch (poInMsg->u8GetOpCode())*/
}



/*************************************************************************
 * FUNCTION:    tunmstr_MsgFromHMI::   vHandle_s_ActivateAnno()
 *
 * DESCRIPTION: Fuction to handle FID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENT Method start
 *
 * PARAMETER:   amt_tclServiceData* poMessage
 *
 * RETURNVALUE: NONE
 *************************************************************************/
tVoid tunmstr_MsgFromHMI ::vHandle_s_ActivateAnno(amt_tclServiceData* poMessage)
{
	if(m_potunmstr_SrcChg_AnnoHandler==NULL)
	{
		ETG_TRACE_USR4(("m_potunmstr_SrcChg_AnnoHandler is NULL"));
		return;
	}
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
	{
		// Get the contents of the switch.
		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodStart oMsg;
		vGetDatafromAMT(poMessage,oMsg );

		// Response -> SUCC / FAIL / BUSY
		tU32 u32AnnoType = (tU32)oMsg.b32Anno_Types.u32Value;
		tU8 u8Source = (tU8)oMsg.Source.u8Value;

		m_potunmstr_SrcChg_AnnoHandler->vHandleAnnoStatusInfo(u32AnnoType,u8Source);
		ETG_TRACE_USR4((" tunmstr_MsgFromHMI::vHandle_s_ActivateAnno-> Type = %d, Source = %d" ,u32AnnoType, u8Source));

		//------------------------------
		// Send the response to client.
		//------------------------------
		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_ACTIVATE_ANNOUNCEMENTMethodResult oResponce;
		// Response -> SUCC / FAIL / BUSY
		oResponce.TunerMaster_StatusResponse.u8TunermasterStatus.enType = \
				midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED;
			stSendCCAMsg ostSendCCAMsg;
			ostSendCCAMsg.u16DestAppID=poMessage->u16GetSourceAppID();
			ostSendCCAMsg.u16Fid=poMessage->u16GetFunctionID();
			ostSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
			ostSendCCAMsg.u16CmdCtr=poMessage->u16GetCmdCounter();
			ostSendCCAMsg.u16RegID=poMessage->u16GetRegisterID();
			vSendMessage( ostSendCCAMsg,oResponce);
	}break;

	case AMT_C_U8_CCAMSG_OPCODE_ERROR:
	{
		/* Call default Error handling function */
		break;
	}/* end of AMT_C_U8_CCAMSG_OPCODE_ERROR    */

	default:
		break;
	}/* end of switch (poInMsg->u8GetOpCode())*/


}
/*******************************************************************************
 *FUNCTION:    tunmstr_MsgFromHMI::vHandle_g_Anno_Status
 *
 *DESCRIPTION: This function will is used to update anno status to HMI
 *
 *
 *
 *PARAMETER:
 *           poMessage
 *
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_MsgFromHMI::vHandle_g_Anno_Status(amt_tclServiceData* poMessage)
{
	ETG_TRACE_USR4(("vHandle_g_Anno_Status()"));
	if( (poMessage == NULL )||(m_potunmstr_MsgToHMI==NULL)||(m_potunmstr_SrcChgManager==NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
		ETG_TRACE_USR4(("vHandle_g_Anno_Status()->Null pointer"));
		return;
	}
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
	{
		ETG_TRACE_USR4((" vHandle_g_Anno_Status::Worng Opcode"));
		//wrong opcode
		break;
	}
	case AMT_C_U8_CCAMSG_OPCODE_UPREG:
	{
		if( !( m_potunmstr_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
		{
			//add to notification table failed
			ETG_TRACE_USR4((" vHandle_g_Anno_Status::add to notification table failed"));
		}
		else
		{
			ETG_TRACE_USR4((" vHandle_g_Anno_Status::add to notification table Success"));
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			m_potunmstr_MsgToHMI->vSend_g_Announcement_Status(m_potunmstr_SrcChgManager->m_AnnoHandlingRequest.u8AnnoState,
							m_potunmstr_SrcChgManager->m_AnnoHandlingRequest.u8Source, m_potunmstr_SrcChgManager->m_AnnoHandlingRequest.u8AnnoType);
#else
			m_potunmstr_MsgToHMI->vSend_g_Announcement_Status();
#endif
		}
		break;
	}
	case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
	{
		if( !( m_potunmstr_MsgToHMI ->bRemoveNotification( poMessage ) ) )
		{
			//Remove from notification table failed
			ETG_TRACE_USR4((" vHandle_g_Anno_Status()->Remove from notification table failed"));
		}
		else
		{
			//Remove from notification table succ
			ETG_TRACE_USR4((" vHandle_g_Anno_Status()->Remove from notification table succ"));
		}
		break;
	}
	default:
	{
		ETG_TRACE_USR4((" vHandle_g_Anno_Status()->Wrong opcode"));
		break;
	}
	}
}


/*******************************************************************************
 *FUNCTION:    tunmstr_MsgFromHMI::vHandle_g_Tuner_Domain_Availability_Status
 *
 *DESCRIPTION: This function will is used to update Tuner Domain Availability
 *status to HMI
 *
 *
 *PARAMETER: poMessage
 *
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_MsgFromHMI::vHandle_g_Tuner_Domain_Availability(amt_tclServiceData* poMessage)
{
	ETG_TRACE_USR4(("vHandle_g_Tuner_Domain_Availability()"));
	if( (poMessage == NULL )||(m_potunmstr_MsgToHMI==NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		ETG_TRACE_USR4(("vHandle_g_Tuner_Domain_Availability()->Null pointer"));
		return;
	}
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_UPREG:
	{
		if( !( m_potunmstr_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
		{
			//add to notification table failed
			ETG_TRACE_USR4((" vHandle_g_Tuner_Domain_Availability::add to notification table failed"));
		}
		else
		{
			ETG_TRACE_USR4((" vHandle_g_Tuner_Domain_Availability::add to notification table Success"));
			vSendTunerDomainAvailability(poMessage);

		}
		break;
	}
	case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
	{
		if( !( m_potunmstr_MsgToHMI ->bRemoveNotification( poMessage ) ) )
		{
			//Remove from notification table failed
			ETG_TRACE_USR4((" vHandle_g_Tuner_Domain_Availability()->Remove from notification table failed"));
		}
		else
		{
			//Remove from notification table succ
			ETG_TRACE_USR4((" vHandle_g_Tuner_Domain_Availability()->Remove from notification table succ"));
		}
		break;
	}
	default:
	{
		ETG_TRACE_USR4((" vHandle_g_Tuner_Domain_Availability()->Wrong opcode"));
		break;
	}
	}
}


/*******************************************************************************
 *FUNCTION:    tunmstr_MsgFromHMI::vHandle_s_Set_MTC_SetMode
 *
 *DESCRIPTION: This function will extarct CCA messeage for MTC Set Mode and forwards it to DAB 
 *
 *PARAMETER:    poMessage
 *
 *AUTHOR: Vinay Nadagoud ECV2 17.12.2014
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_MsgFromHMI::vHandle_s_Set_MTC_SetMode(amt_tclServiceData* poMessage)
{
	// Check message pointer.
	if(( poMessage == NULL )||(NULL==m_potunmstr_DABClient_Handler)||(NULL==m_potunmstr_MsgToHMI) || (NULL == m_poclConfigInterface))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_DABClient_Handler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		NORMAL_M_ASSERT( m_poclConfigInterface != NULL );
		return;
	}
	else
	{
		switch (poMessage->u8GetOpCode())
		{
			case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
			{
				midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodResult oResponce;
				if(m_poclConfigInterface->u32GetConfigData("DABSupported"))
				{
					midw_tunermasterfi_tclMsgFID_TUNMSTR_S_MTC_SETMODEMethodStart  oMessageStart;
					vGetDatafromAMT(poMessage,oMessageStart );
					tU8 u8Mode = (tU8) oMessageStart.Mode.u8Value;
					ETG_TRACE_USR4(("vHandle_s_Set_MTC_SetMode u8Mode=%d",u8Mode));
					m_potunmstr_DABClient_Handler->vSet_MTC_Mode(u8Mode);
					oResponce.TunerMaster_StatusResponse.u8TunermasterStatus.enType = \
					midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED;
				}
				else
				{
					oResponce.TunerMaster_StatusResponse.u8TunermasterStatus.enType = \
					midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_FAIL;
				}
				stSendCCAMsg ostSendCCAMsg;
				ostSendCCAMsg.u16DestAppID=poMessage->u16GetSourceAppID();
				ostSendCCAMsg.u16Fid=poMessage->u16GetFunctionID();
				ostSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
				ostSendCCAMsg.u16CmdCtr=poMessage->u16GetCmdCounter();
				ostSendCCAMsg.u16RegID=poMessage->u16GetRegisterID();
				vSendMessage( ostSendCCAMsg,oResponce);

				break;
			}
			case AMT_C_U8_CCAMSG_OPCODE_GET:
			{
				//Send Get MTCMode Switch Status to DAB
				ETG_TRACE_USR4((" vHandle_s_Set_MTC_SetMode::GET Opcode Received"));
				//fix for mempool issue
				if (m_poclConfigInterface->u32GetConfigData("DABSupported"))
				{
					m_potunmstr_DABClient_Handler->vGet_MTC_Mode();
				}
				else
				{
					midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSGet oResponce;
					stSendCCAMsg ostSendCCAMsg;
					ostSendCCAMsg.u16DestAppID=poMessage->u16GetSourceAppID();
					ostSendCCAMsg.u16Fid=poMessage->u16GetFunctionID();
					ostSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_ERROR;
					ostSendCCAMsg.u16CmdCtr=poMessage->u16GetCmdCounter();
					ostSendCCAMsg.u16RegID=poMessage->u16GetRegisterID();
					vSendMessage( ostSendCCAMsg,oResponce);
				}
				break;
			}
			case AMT_C_U8_CCAMSG_OPCODE_UPREG:
			{
				//fix for mempool issue
				if (!m_poclConfigInterface->u32GetConfigData("DABSupported"))
				{
					midw_tunermasterfi_tclMsgFID_TUNMSTR_G_MTC_SETMODE_STATUSUpReg oResponce;
					stSendCCAMsg ostSendCCAMsg;
					ostSendCCAMsg.u16DestAppID=poMessage->u16GetSourceAppID();
					ostSendCCAMsg.u16Fid=poMessage->u16GetFunctionID();
					ostSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_ERROR;
					ostSendCCAMsg.u16CmdCtr=poMessage->u16GetCmdCounter();
					ostSendCCAMsg.u16RegID=poMessage->u16GetRegisterID();
					vSendMessage( ostSendCCAMsg,oResponce);
				}
				else if( !( m_potunmstr_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
				{
					//add to notification table failed
					ETG_TRACE_USR4((" vHandle_s_Set_MTC_SetMode::add to notification table failed"));
				}
				else
				{
					ETG_TRACE_USR4((" vHandle_s_Set_MTC_SetMode::add to notification table Success"));
					
					m_potunmstr_DABClient_Handler->vGet_MTC_Mode();

				}
				break;
			}
			case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
			{
				if( !( m_potunmstr_MsgToHMI ->bRemoveNotification( poMessage ) ) )
				{
					//Remove from notification table failed
					ETG_TRACE_USR4((" vHandle_s_Set_MTC_SetMode()->Remove from notification table failed"));
				}
				else
				{
					//Remove from notification table succ
					ETG_TRACE_USR4((" vHandle_s_Set_MTC_SetMode()->Remove from notification table succ"));
				}
				break;		
			}
			default:
			{
				break;
			}
		}
	}
}


/*******************************************************************************
 *FUNCTION:    tunmstr_MsgFromHMI::vHandle_s_StationSelection
 *
 *DESCRIPTION: This function will extarct CCA messeage for station selection requests from SDS
 *
 *PARAMETER:    poMessage
 *
 *AUTHOR:
 *RETURNVALUE: None
 ********************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
tVoid tunmstr_MsgFromHMI::vHandle_s_StationSelection(amt_tclServiceData* poMessage)
{
	// Check message pointer.
	if((poMessage == NULL ) || (m_potunmstr_SDSHandler == NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SDSHandler != NULL );
		return;
	}
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
		{

			m_potunmstr_SDSHandler->vHandleStationSelection(poMessage);

			/*midw_tunermasterfi_tclMsgFID_TUNMSTR_S_STATION_SELECTIONMethodResult oResponce;

			// Response -> SUCC / FAIL / BUSY
			oResponce.TunerMaster_StatusResponse.u8TunermasterStatus.enType = \
				midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED;
			stSendCCAMsg ostSendCCAMsg;
			ostSendCCAMsg.u16DestAppID=poMessage->u16GetSourceAppID();
			ostSendCCAMsg.u16Fid=poMessage->u16GetFunctionID();
			ostSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
			ostSendCCAMsg.u16CmdCtr=poMessage->u16GetCmdCounter();
			ostSendCCAMsg.u16RegID=poMessage->u16GetRegisterID();
			vSendMessage( ostSendCCAMsg,oResponce);*/

			break;
		}
	default:
		{
			break;
		}

	}

}
#endif

/*******************************************************************************
 *FUNCTION:    tunmstr_MsgFromHMI::vHandle_g_MTC_SurveilanceStationStatus
 *
 *DESCRIPTION: This function will handle Upreg and Relupreg for CCA messeage FID_TUNMSTR_G_MTC_SURVEILLANCE_MONITOR_STATUS
 *
 *PARAMETER:    poMessage
 *
 *AUTHOR: Vinay Nadagoud ECV2 17.12.2014
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_MsgFromHMI::vHandle_g_MTC_SurveilanceStationStatus(amt_tclServiceData* poMessage)
{
	// Check message pointer.
	if(( poMessage == NULL )||(NULL==m_potunmstr_DABClient_Handler)||(NULL==m_potunmstr_MsgToHMI))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		return;
	}
	else
	{
		switch (poMessage->u8GetOpCode())
		{
		  case AMT_C_U8_CCAMSG_OPCODE_UPREG:
			{
				if( !( m_potunmstr_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
				{
					//add to notification table failed
					ETG_TRACE_USR4((" vHandle_g_MTC_SurveilanceStationStatus::add to notification table failed"));
				}
				else
				{
					ETG_TRACE_USR4((" vHandle_g_MTC_SurveilanceStationStatus::add to notification table Success"));
					m_potunmstr_DABClient_Handler->vGet_Surveillance_Mode_Status();
				}
				break;
			}
		case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
			{
				if( !( m_potunmstr_MsgToHMI ->bRemoveNotification( poMessage ) ) )
				{
					//Remove from notification table failed
					ETG_TRACE_USR4((" vHandle_g_MTC_SurveilanceStationStatus()->Remove from notification table failed"));
				}
				else
				{
					//Remove from notification table succ
					ETG_TRACE_USR4((" vHandle_g_MTC_SurveilanceStationStatus()->Remove from notification table succ"));
				}
				break;		
		default:
			{
				break;
			}
			}
		} 
	}
}
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
tVoid tunmstr_MsgFromHMI::vHandle_s_Source_Setup_Option(amt_tclServiceData* poMessage)
{
	if((poMessage == NULL ) || (m_poArlImpl== NULL) || (NULL==m_potunmstr_TunerClientHandler))
	{
		return ;
	}
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
	{
		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodStart oMessageStart;
		vGetDatafromAMT(poMessage,oMessageStart );
		arl_tenSource enSource = ARL_SRC_NONE;
		arl_tenSrcAvailability enSrcAvail=ARL_EN_SRC_NOT_AVAILABLE;
		arl_tenAvailabilityReason enAvailabilityReason=ARL_EN_REASON_NOMEDIA;	
		if(oMessageStart.Source.enType ==midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_AM)
		{
			m_stSendCCAMsgSourceSetupOpt.u16DestAppID=poMessage->u16GetSourceAppID();
			m_stSendCCAMsgSourceSetupOpt.u16Fid=poMessage->u16GetFunctionID();
			m_stSendCCAMsgSourceSetupOpt.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
			m_stSendCCAMsgSourceSetupOpt.u16CmdCtr=poMessage->u16GetCmdCounter();
			m_stSendCCAMsgSourceSetupOpt.u16RegID=poMessage->u16GetRegisterID();
			if(oMessageStart.Enable)
			{
				enSrcAvail = ARL_EN_SRC_PLAYABLE;
				enAvailabilityReason= ARL_EN_REASON_NEWMEDIA;
				vUpdateAMSourceDp();
				vSend_s_Source_Setup_Option_MethodResult(midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED);

			}
			else
			{
				m_potunmstr_TunerClientHandler->vDisableTunerSource(oMessageStart.Source.enType ,false);
			}
			enSource = ARL_SRC_AM;
			m_poArlImpl->vUpdateAudioSourceAvailabelStatus(enSource,enSrcAvail,enAvailabilityReason);
		}
		else
		{
			midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult oResult;
			oResult.TunerMaster_StatusResponse.u8TunermasterStatus.enType = \
			midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_FAIL;
			stSendCCAMsg ostSendCCAMsg;
			ostSendCCAMsg.u16DestAppID=poMessage->u16GetSourceAppID();
			ostSendCCAMsg.u16Fid=poMessage->u16GetFunctionID();
			ostSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
			ostSendCCAMsg.u16CmdCtr=poMessage->u16GetCmdCounter();
			ostSendCCAMsg.u16RegID=poMessage->u16GetRegisterID();
			vSendMessage( ostSendCCAMsg,oResult);
		}
		break;
	}
	default:
	break;
	}
}
#endif
tVoid tunmstr_MsgFromHMI::vSend_s_Source_Setup_Option_MethodResult( midw_fi_tcl_e8_TunMstr_ResponseStatus::tenType oStatus)
{		
	if( (m_potunmstr_MsgToHMI == NULL ) || ( NULL == m_poclConfigInterface))
	{
		return;
	}	
	midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SOURCE_SETUP_OPTIONMethodResult oResult;
	oResult.TunerMaster_StatusResponse.u8TunermasterStatus.enType = oStatus;
	vSendMessage( m_stSendCCAMsgSourceSetupOpt,oResult);
	m_stSendCCAMsgSourceSetupOpt.u16Fid=0XFF;
	m_stSendCCAMsgSourceSetupOpt.u8OpCode=CCA_C_U8_OPCODE_ERROR;
	m_stSendCCAMsgSourceSetupOpt.u16CmdCtr=0;
	m_stSendCCAMsgSourceSetupOpt.u16RegID=AMT_C_U16_REGID_INVALID;
	//m_poclConfigInterface
	if((m_poclConfigInterface->u32GetConfigData("AvailableBands") & 0x06) && (m_poclConfigInterface->u32GetConfigData("CFGAM")))
		m_potunmstr_MsgToHMI->vSend_g_Tuner_Source_Availability_status();
}


tVoid tunmstr_MsgFromHMI::vUpdateAMSourceDp()
{
	#ifndef VARIANT_S_FTR_ENABLE_TUNERMASTER_MOCK


	dp_tclTmcTunerUsrDPAMAvailability oTmcTunerDPAMAvailability ;
    oTmcTunerDPAMAvailability.s32SetData(true);
	tBool bTmcTunerDPAMAvailStatus = true;
	oTmcTunerDPAMAvailability.s32GetData(bTmcTunerDPAMAvailStatus);

	ETG_TRACE_USR4(("vUpdateAMSourceDp After updatating AMAvailability =%d ",bTmcTunerDPAMAvailStatus));

	#endif
}

#ifdef INCLUDE_PROFILE_MANAGER
/*************************************************************************
 *
 * FUNCTION:     tunmstr_MsgFromHMI::vSet_tunmstr_PMClient_Handler_Ptr( )
 *
 * DESCRIPTION:  Set pointer to pointer PM client
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 ************************************************************************/
tVoid tunmstr_MsgFromHMI::vSet_tunmstr_PMClient_Handler_Ptr( tunermaster_PMClient* potunmstr_PMClient_Handler )
{
	if( potunmstr_PMClient_Handler != NULL )
	{
		m_potunmstr_PMClient_Handler = ( tunermaster_PMClient* )potunmstr_PMClient_Handler;
	}
	else
	{
		NORMAL_M_ASSERT ( m_potunmstr_PMClient_Handler != NULL );
	}
}
#endif

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
/*************************************************************************
 *
 * FUNCTION:     tunmstr_MsgFromHMI::vSet_tunmstr_SXMClient_Handler_Ptr( )
 *
 * DESCRIPTION:  Set pointer to pointer SXM client
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 ************************************************************************/
tVoid tunmstr_MsgFromHMI::vSet_tunmstr_SXMClient_Handler_Ptr(tunermaster_SXMClient* potunermaster_SXMClient)
{
	if( potunermaster_SXMClient != NULL )
	{
		m_potunermaster_SXMClient = potunermaster_SXMClient;
	}
	else
	{
		NORMAL_M_ASSERT ( m_potunermaster_SXMClient != NULL );
	}
}


/*************************************************************************
 *
 * FUNCTION:     tunmstr_MsgFromHMI::vSet_tunmstr_SXMClient_Handler_Ptr( )
 *
 * DESCRIPTION:  Set pointer to pointer SXM client
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 ************************************************************************/
tVoid tunmstr_MsgFromHMI::vSet_tunmstr_SXMChannelArtClient_Handler_Ptr(tunermaster_SXMchannelartClient* potunermaster_SXMchannelartClient)
{
	if( potunermaster_SXMchannelartClient != NULL )
	{
		m_potunermaster_SXMchannelartClient = potunermaster_SXMchannelartClient;
	}
	else
	{
		NORMAL_M_ASSERT ( m_potunermaster_SXMchannelartClient != NULL );
	}
}

#endif

#ifdef INCLUDE_PROFILE_MANAGER
/*************************************************************************
 *
 * FUNCTION:     tunmstr_MsgFromHMI::vHandle_Tunmstr_s_RadioProfile_Setting( )
 *
 * DESCRIPTION:  Method Start MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RADIOPROFILE_SETTING
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 ************************************************************************/

tVoid tunmstr_MsgFromHMI::vHandle_Tunmstr_s_RadioProfile_Setting(amt_tclServiceData* poMessage)
{

	if((poMessage == NULL ) || (m_potunmstr_PMClient_Handler == NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_PMClient_Handler != NULL );
		return;
	}
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
		{

			m_potunmstr_PMClient_Handler->vHandle_s_Radio_Profile_Setting(poMessage);
			break;
		}
	default:
		{
			break;
		}
	}

}


/*************************************************************************
 *
 * FUNCTION:     tunmstr_MsgFromHMI::vHandle_Tunmstr_s_RadioProfile_Setting( )
 *
 * DESCRIPTION:  Method Start MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUEST
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 ************************************************************************/

tVoid tunmstr_MsgFromHMI::vHandle_s_Radio_Profile_Setting_Request(amt_tclServiceData* poMessage)
{

	if((poMessage == NULL ) || (m_potunmstr_PMClient_Handler == NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_PMClient_Handler != NULL );
		return;
	}
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
		{

			m_potunmstr_PMClient_Handler->vHandle_s_RadioProfileSettings_Request(poMessage);
			break;
		}
	default:
		{
			break;
		}
	}

}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_MsgFromHMI::vHandle_g_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATION_Status( )
 *
 * DESCRIPTION:  StatusMsg MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATION
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 ************************************************************************/

tVoid tunmstr_MsgFromHMI::vHandle_g_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATION_Status(amt_tclServiceData* poMessage)
{

	if((poMessage == NULL ) || (m_potunmstr_PMClient_Handler == NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_PMClient_Handler != NULL );
		return;
	}
	switch (poMessage->u8GetOpCode())
			{
			  case AMT_C_U8_CCAMSG_OPCODE_UPREG:
				{
					if( !( m_potunmstr_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
					{
						//add to notification table failed
						ETG_TRACE_USR4((" vHandle_g_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATION_Status::add to notification table failed"));
					}
					else
					{
						ETG_TRACE_USR4((" vHandle_g_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATION_Status::add to notification table Success"));
					}
					break;
				}
			case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
				{
					if( !( m_potunmstr_MsgToHMI ->bRemoveNotification( poMessage ) ) )
					{
						//Remove from notification table failed
						ETG_TRACE_USR4((" vHandle_g_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATION_Status()->Remove from notification table failed"));
					}
					else
					{
						//Remove from notification table succ
						ETG_TRACE_USR4((" vHandle_g_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATION_Status()->Remove from notification table succ"));
					}
					break;
			default:
				{
					break;
				}
				}
			}

}


/*************************************************************************
 * FUNCTION:    tunmstr_MsgFromHMI::   vHandle_g_SXM_UserProfile()
 *
 * DESCRIPTION: This function will register clients for SXM user profile
 *
 * PARAMETER:   amt_tclServiceData* poMessage
 *
 * RETURNVALUE: NONE
 *************************************************************************/
tVoid tunmstr_MsgFromHMI :: vHandle_g_SXM_UserProfile( amt_tclServiceData* poMessage )
{
	ETG_TRACE_USR4(("vHandle_g_SXM_UserProfile()"));

	if(( poMessage == NULL ) || (m_potunmstr_MsgToHMI == NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		return;
	}

	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_UPREG:
		{
			if( !( m_potunmstr_MsgToHMI ->bAddNotificationTable ( poMessage ) ) )
			{
				//add to notification table failed
				ETG_TRACE_USR4((" vHandle_g_SXM_UserProfile::add to notification table failed"));
			}
			else
			{
				ETG_TRACE_USR4((" vHandle_g_SXM_UserProfile::add to notification table success"));
			}

			break;
		}
		case AMT_C_U8_CCAMSG_OPCODE_RELUPREG:
		{
			if( !( m_potunmstr_MsgToHMI ->bRemoveNotification( poMessage ) ) )
			{
				//Remove from notification table failed
				ETG_TRACE_USR4((" vHandle_g_SXM_UserProfile()->Remove from notification table failed"));
			}
			else
			{
				//Remove from notification table succ
				ETG_TRACE_USR4((" vHandle_g_SXM_UserProfile()->Remove from notification table succ"));
			}
			break;
		}
		default:
		{
			ETG_TRACE_USR4((" vHandle_g_SXM_UserProfile()->Wrong opcode"));
			break;
		}
	}
}


/*******************************************************************************
 *FUNCTION:    vHandleUserProfileResponse
 *
 *DESCRIPTION: Handler for message start FID_TUNMSTR_S_SXM_USERPROFILE_RESPONSE
 *
 *PARAMETER:
 *           amt_tclServiceData
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_MsgFromHMI::vHandleUserProfileResponse(amt_tclServiceData* poMessage)
{

	if((NULL==poMessage) || (NULL == m_potunmstr_PMClient_Handler ))
	{
		ETG_TRACE_USR4(("vHandleUserProfileResponse, NULL Message"));
		return;
	}
	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_METHODSTART:
		{
			midw_tunermasterfi_tclMsgFID_TUNMSTR_S_SXM_USERPROFILE_RESPONSEMethodStart oMsg;
			vGetDatafromAMT(poMessage,oMsg );

			tU8 u8Status = TUNMSTR_PROFILE_USER_ACTION_FAIL;
			if (midw_fi_tcl_ProfileActionStatus::FI_EN_SUCCESS == oMsg.ProfileResponse.Status.enType)
				u8Status = TUNMSTR_PROFILE_USER_ACTION_SUCESS;

			switch(oMsg.ProfileResponse.ProfileAction.enType)
			{

				case  midw_fi_tcl_ProfileAction::FI_EN_ACTIVEPROFILE:
				{
					m_potunmstr_PMClient_Handler->vHandleOnDataChanged((tU8)u8Status);
					break;
					ETG_TRACE_USR4(("vHandleUserProfileResponse activate u8Status =%d   ",u8Status));

				}
				case  midw_fi_tcl_ProfileAction::FI_EN_COPYPROFILE:
				{
					m_potunmstr_PMClient_Handler->vHandleOnProfileCopied((tU8)u8Status);
					ETG_TRACE_USR4(("vHandleUserProfileResponse Copy u8Status =  %d   ",u8Status));
					break;
				}
				case  midw_fi_tcl_ProfileAction::FI_EN_DELETEPROFILE:
				{
					m_potunmstr_PMClient_Handler->vHandleOnProfileDeleted((tU8)u8Status);
					ETG_TRACE_USR4(("vHandleUserProfileResponse Delete u8Status =%d   ",u8Status));
					break;
				}
				case  midw_fi_tcl_ProfileAction::FI_EN_DATACHANGE:
				{
					switch(oMsg.ProfileResponse.ProfileStatus.enType)
					{
						case midw_fi_tcl_ProfileStatus::FI_EN_PREPARE:
							m_potunmstr_PMClient_Handler->vHandleOnDataChanged_Prepare((tU8)oMsg.ProfileResponse.Status.enType);
							ETG_TRACE_USR4(("vHandleUserProfileResult Datachange Prepare u8Status =%d   ",u8Status));
							break;
						case midw_fi_tcl_ProfileStatus::FI_EN_CHANGED:
							m_potunmstr_PMClient_Handler->vHandleOnDataChanged((tU8)u8Status);
							ETG_TRACE_USR4(("vHandleUserProfileResult Datachange Changed u8Status =%d   ",u8Status));
							break;
						case midw_fi_tcl_ProfileStatus::FI_EN_RESET:
							//Do nothing
							break;
						default:
							break;
					}

					break;
				}
				default:
				{
					break;
				}

			}
			break;
		}
		default:
			break;
	}


}

#endif
/*This property will set the DTV Antenna Power supply(example ELMOS IC)
 *  current register(Open/Over Current register) based on the KDS configuration
 *   in "CM_VariantCoding" and AntennaParameterSet"*/
tVoid tunmstr_MsgFromHMI::vHandle_g_Set_DTVAntennaTRegister(amt_tclServiceData* poMessage)
{
	if(( poMessage == NULL )||(NULL==m_potunmstr_antdiag_Manager))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_antdiag_Manager != NULL );
		return;
	}
	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_SET:
			{
			   midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SET_DTVAntennaRegisterStatus oStatus;
            m_potunmstr_antdiag_Manager->vPostEvent(TUNMSTR_ANTDIAG_U32_EVENT_MASK_SET_DTV_ANT_REG_REQ);
#ifndef GTEST_x86LINUX_BUILD
				stSendCCAMsg ostSendCCAMsg;
				ostSendCCAMsg.u16DestAppID=poMessage->u16GetSourceAppID();
				ostSendCCAMsg.u16Fid=poMessage->u16GetFunctionID();
				ostSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_STATUS;
				ostSendCCAMsg.u16CmdCtr=poMessage->u16GetCmdCounter();
				ostSendCCAMsg.u16RegID=poMessage->u16GetRegisterID();
				vSendMessage( ostSendCCAMsg,oStatus);
#endif
				break;
			}
		default:
			{
				break;
			}
	}

}
tVoid tunmstr_MsgFromHMI::vSendTunerDomainAvailability(amt_tclServiceData* poMessage)
{
	if(( NULL != m_potunmstr_DABClient_Handler) && ( NULL != m_potunmstr_TunerClientHandler ))
	{
		midw_tunermasterfi_tclMsgFID_TUNMSTR_G_TUNER_DOMAIN_AVAILABILITYStatus oStatus;
		if((!m_potunmstr_DABClient_Handler->u8GetDABServiceState()) && (!m_potunmstr_TunerClientHandler->u8GetTunerService()))
		{
			oStatus.TunerAvailability.enType = midw_fi_tcl_e8_TunerAvailability::FI_EN_TUNMSTR_BOTH_TUNER_NOT_AVAILABLE;
		}
		else if((!m_potunmstr_DABClient_Handler->u8GetDABServiceState()) && (m_potunmstr_TunerClientHandler->u8GetTunerService()))
		{
			oStatus.TunerAvailability.enType = midw_fi_tcl_e8_TunerAvailability::FI_EN_TUNMSTR_FM_TUNER_NOW_AVAILABLE;
		}
		else if((m_potunmstr_DABClient_Handler->u8GetDABServiceState()) && (!m_potunmstr_TunerClientHandler->u8GetTunerService()))
		{
			oStatus.TunerAvailability.enType = midw_fi_tcl_e8_TunerAvailability::FI_EN_TUNMSTR_DAB_TUNER_NOW_AVAILABLE;
		}
		else
		{
			oStatus.TunerAvailability.enType = midw_fi_tcl_e8_TunerAvailability::FI_EN_TUNMSTR_BOTH_TUNER_NOW_AVAILABLE;
		}
		stSendCCAMsg ostSendCCAMsg;
		ostSendCCAMsg.u16DestAppID=poMessage->u16GetSourceAppID();
		ostSendCCAMsg.u16Fid=poMessage->u16GetFunctionID();
		ostSendCCAMsg.u8OpCode=AMT_C_U8_CCAMSG_OPCODE_STATUS;
		ostSendCCAMsg.u16CmdCtr=poMessage->u16GetCmdCounter();
		ostSendCCAMsg.u16RegID=poMessage->u16GetRegisterID();
		vSendMessage( ostSendCCAMsg,oStatus);
	}
}
#endif
