/************************************************************************
 * FILE:           tunmstr_DABClient_Handler.cpp
 * PROJECT:        G3g
 * SW-COMPONENT:   fc_tunermaster.
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:    To Handle CCA Messages  from fc_DAB
 *
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY: 
 * Date        | Author                            | Modification
 * 20/04/2011  | CM-AI/PJ-VW36 Pallavi Hn          | initial version
 *
 *************************************************************************/

//-----------------
// System includes
//-----------------
#ifdef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#include "ahl_mock/ahl_if.h"
#include "amt_mock/amt_if.h"
#else
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"


#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_ext_fi_if.h"

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h"

#include "fc_tunermaster_featureControl.h"

#include "tunermaster_utility.h"
#include "tunermaster_main.h"
#include "tunermaster_Config.h"

#include "tunmstr_SrcChg_Defines.h"
#include "tunmstr_SrcChg_Trace.h"
#include "tunmstr_SrcChgManager.h"
#include "tunmstr_DABClient_Handler.h"
#include "tunmstr_AudioClientHandler.h"
#include "tunmstr_TunerClientHandler.h"
#include "tunermaster_defines.h"
#ifdef INCLUDE_PROFILE_MANAGER
#include "tunermaster_PMClient.h"
#endif
#include "kdsconfig/clConfigInterface.h"

#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_DABTUNERFI_SERVICEINFO
#include "midw_ext_fi_if.h"

#include "tunmstr_AutoStorehandler.h"
#include "tunmstr_SrcChg_AnnoHandler.h"
#include "tunmstr_MuteHandler.h"
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNMSTR_TRACE_CLASS_SRCCHG
#include "trcGenProj/Header/tunmstr_DABClient_Handler.cpp.trc.h"
#endif

/* +++
MESSAGE MAP:
enter the function IDs (FID) and the corresponding functions here.
the function will be called when a message with the corresponding FID arrives
+++ */
BEGIN_MSG_MAP(tunmstr_DABClient_Handler, ahl_tclBaseWork)
//Method
ON_MESSAGE( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SOURCE_STATE,    vHandle_s_MethodResult_SrcChg)
ON_MESSAGE( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SELECT_ANNO,    vHandle_s_MethodResult_SrcChg)
ON_MESSAGE( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SET_MUTE_STATUS,    vHandle_s_Set_Mute_Status)
ON_MESSAGE( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_ACTIVATE_PRESET_LIST_ELEM,    vHandleDABPresetHandlingMethodResult)
ON_MESSAGE( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_GET_PRESET_LIST,    vHandleDABPresetListMethodResult)
ON_MESSAGE( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_AUTOSTORE,    vHandle_s_AutoStore)
ON_MESSAGE( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_MTC_SETMODE , vHandleDAB_MTCSetModeMethodResult)
//Property
ON_MESSAGE( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_CHANNEL_INFO,    vHandle_g_Channel_Info)
ON_MESSAGE( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_ANNO_STATUS,     vHandle_g_Anno_Status)
ON_MESSAGE( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_MUTE_REQUEST , vHandle_g_Mute_Request)
ON_MESSAGE( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_PRESET_LIST , vHandleDABPresetListStatus)
ON_MESSAGE( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_MTC_SETMODE_STATUS , vHandleDAB_MTCSetModeStatus)
ON_MESSAGE( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_MTC_SURVEILLANCE_MONITOR , vHandleDAB_MTC_Surveillance_Monitor)
#ifdef INCLUDE_PROFILE_MANAGER
ON_MESSAGE( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SAVE_PRESET_LIST , vHandle_S_FID_DAB_S_SAVE_PRESET_LIST_MethodeResult)
ON_MESSAGE( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_USER_PROFILE_UPDATE, vHandle_s_UserProfileUpdateResult)
#endif
/*Added to resolve double deletion */
ON_MESSAGE( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_ANNO_CONFIG , vHandle_s_UnUsedMessages)
ON_MESSAGE( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SAVE_PRESET_LIST_ELEM , vHandle_s_UnUsedMessages)
ON_MESSAGE( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_DELETE_PRESET_LIST_ELEM , vHandle_s_UnUsedMessages)
ON_MESSAGE( MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_STOP_ANNO , vHandle_s_UnUsedMessages)
END_MSG_MAP()
/*************************************************************************
 * FUNCTION:     tunmstr_DABClient_Handler::tunmstr_DABClient_Handler( )
 *
 * DESCRIPTION:  Constructor
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
tunmstr_DABClient_Handler::tunmstr_DABClient_Handler( tunmaster_tclApp* poMainApp, tuner::sessionManagement::audio::clArlSourceImpl* poArlImpl)
#else
tunmstr_DABClient_Handler::tunmstr_DABClient_Handler( tunmaster_tclApp* poMainApp)
#endif
{
	poGWMain = poMainApp;
	m_potunmstr_SrcChgManager = NULL;
	m_potunmaster_Config = NULL;
	m_potunmstr_TunerClientHandler = NULL;
	m_potunmstr_Preset_Handler = NULL;
	m_potunmstr_AudioClientHandler = NULL;
	m_ptunmstr_AutoStoreHandler = NULL;
	m_potunmstr_SrcChg_AnnoHandler = NULL;
	m_potunmstr_MuteHandler = NULL;
	m_potunmstr_MsgToHMI = NULL;
	m_potunmstr_MsgFromHMI = NULL;
	m_poclConfigInterface = NULL;
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
	m_ptunmaster_PMClient = NULL;
#endif
	m_u16RegID = AMT_C_U16_REGID_INVALID;
	m_u8ServiceAvailable_DAB = TUNMASTER_INVALID;
	m_bFmServiceFollowActive = FALSE;
	for(tU8 i=0; i< 10; i++)
{

		midw_ext_fi_tcl_DAB_AnnoElement oAnnoElem;
		m_eAnnoElement.AnnoStatus.AnnouncementList.push_back(oAnnoElem);
	}

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	m_poSessionControl = clSessionControl::getInstance();
	m_poArlImpl = poArlImpl;
#endif
//	m_eAnnoElement.m_eAnnoElement.AnnoStatus.AnnouncementList[i].AnnoState.enType;
	oMTCSurveilanceStatus.StationType.enType = midw_fi_tcl_e8_StationType::FI_EN_TUNMSTR_STATIONTYPE_DAB;
    oMTCSurveilanceStatus.Frequency = 0;
    oMTCSurveilanceStatus.Station_ID = 0;
    //oMTCSurveilanceStatus.StationNameFM.bSet( '\0', midw_fi_tclString::FI_EN_UTF8);
	m_u8PresetAutocompare = 0xFF;

}
/*************************************************************************
 * FUNCTION:     tunmstr_DABClient_Handler::~tunmstr_DABClient_Handler( )
 *
 * DESCRIPTION:  Destructor.
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *************************************************************************/
tunmstr_DABClient_Handler::~tunmstr_DABClient_Handler( )
{
	poGWMain = NULL;
	m_potunmstr_SrcChgManager= NULL;
	m_potunmaster_Config = NULL;
	m_potunmstr_TunerClientHandler = NULL;
	m_potunmstr_Preset_Handler =NULL;
	m_potunmstr_AudioClientHandler = NULL;
	m_ptunmstr_AutoStoreHandler = NULL;
	m_potunmstr_SrcChg_AnnoHandler = NULL;
	m_potunmstr_MuteHandler = NULL;
	m_potunmstr_MsgToHMI = NULL;
	m_potunmstr_MsgFromHMI = NULL;
	m_u16RegID = AMT_C_U16_REGID_INVALID;
	m_u8ServiceAvailable_DAB = TUNMASTER_INVALID;
	m_poclConfigInterface = NULL;
	m_eAnnoElement.AnnoStatus.AnnouncementList.clear();
	m_bFmServiceFollowActive = FALSE;
	oMTCSurveilanceStatus.StationType.enType = midw_fi_tcl_e8_StationType::FI_EN_TUNMSTR_STATIONTYPE_DAB;
   oMTCSurveilanceStatus.Frequency = 0;
   oMTCSurveilanceStatus.Station_ID = 0;
   //oMTCSurveilanceStatus.StationNameFM.bSet( '\0', midw_fi_tclString::FI_EN_UTF8);

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	m_poSessionControl = NULL;
	m_poArlImpl = 0;
#endif
//	m_eAnnoElement.AnnoType = 0x00;
//m_eAnnoElement.AnnoState = 0xff;
#ifdef INCLUDE_PROFILE_MANAGER
	m_ptunmaster_PMClient = NULL;
#endif

	m_u8PresetAutocompare = 0xFF;

}


/*************************************************************************
 * FUNCTION:     vSet_tunmstr_SrcChgManager_Ptr
 *
 * DESCRIPTION:   Update member variable m_potunmstr_SrcChgManager
 *
 * PARAMETER:    tunmstr_SrcChgManager*
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_DABClient_Handler::vSet_tunmstr_SrcChgManager_Ptr( tunmstr_SrcChgManager* potunmstr_SrcChgManager )
{
	if( potunmstr_SrcChgManager != NULL )
	{
		m_potunmstr_SrcChgManager = ( tunmstr_SrcChgManager* )potunmstr_SrcChgManager;
	}
}
/*************************************************************************
 * FUNCTION:    vSet_tunmstr_AutoStoreHandler_Ptr
 *
 * DESCRIPTION: Set pointer to pointer tunmstr_Presethandler
 *
 * PARAMETER:   tunmstr_Presethandler* potunmstr_Presethandler
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_DABClient_Handler::vSet_tunmstr_AutoStoreHandler_Ptr(tunmstr_AutoStoreHandler* potunmstr_AutoStoreHandler)
{
	if( potunmstr_AutoStoreHandler != NULL )
	{
		m_ptunmstr_AutoStoreHandler = ( tunmstr_AutoStoreHandler* )potunmstr_AutoStoreHandler;
	}
}
/*************************************************************************
 * FUNCTION:     tunmstr_DABClient_Handler::vSet_tunmaster_Config_Ptr( )
 *
 * DESCRIPTION:   With this config data can be accessed
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_DABClient_Handler::vSet_tunmaster_Config_Ptr( tunmaster_Config* potunmaster_Config )
{
	if( potunmaster_Config != NULL )
	{
		m_potunmaster_Config = ( tunmaster_Config* )potunmaster_Config;
	}
}
/*************************************************************************
 * FUNCTION:     tunmstr_DABClient_Handler::vSet_tunmstr_Preset_Handler_Ptr( )
 *
 * DESCRIPTION:  tunmstr_Preset_Handler* potunmstr_Preset_Handler
 *
 * PARAMETER:    tunmstr_Preset_Handler* potunmstr_Preset_Handler
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_DABClient_Handler::vSet_tunmstr_Preset_Handler_Ptr( tunmstr_Preset_Handler* potunmstr_Preset_Handler)
{
	if( potunmstr_Preset_Handler != NULL )
	{
		m_potunmstr_Preset_Handler = ( tunmstr_Preset_Handler* )potunmstr_Preset_Handler;
	}
	else
	{
		NORMAL_M_ASSERT ( m_potunmstr_Preset_Handler != NULL );
	}
}
/*************************************************************************
 * FUNCTION:    vSet_tunmstr_TunerClientHandler_Ptr( tunmstr_TunerClientHandler* potunmstr_TunerClientHandler )
 *
 * DESCRIPTION:  Set pointer to pointer tunmstr_TunerClientHandler
 *
 * PARAMETER:    tunmstr_TunerClientHandler* potunmstr_TunerClientHandler
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_DABClient_Handler::vSet_tunmstr_TunerClientHandler_Ptr(tunmstr_TunerClientHandler* potunmstr_TunerClientHandler )
{
	if( potunmstr_TunerClientHandler != NULL )
	{
		m_potunmstr_TunerClientHandler = ( tunmstr_TunerClientHandler* )potunmstr_TunerClientHandler;
	}
}
/*************************************************************************
 * FUNCTION:     tunmstr_DABClient_Handler::vSet_tunmstr_SrcChg_AnnoHandler_Ptr( )
 *
 * DESCRIPTION:  Set pointer to pointer tunmstr_SrcChg_AnnoHandler*
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_DABClient_Handler::vSet_tunmstr_SrcChg_AnnoHandler_Ptr(tunmstr_SrcChg_AnnoHandler* potunmstr_SrcChg_AnnoHandler)

{
	if( potunmstr_SrcChg_AnnoHandler != NULL )
	{
		m_potunmstr_SrcChg_AnnoHandler = ( tunmstr_SrcChg_AnnoHandler* )potunmstr_SrcChg_AnnoHandler;
	}
	else
	{
		NORMAL_M_ASSERT ( m_potunmstr_SrcChg_AnnoHandler != NULL );
	}
}
/*************************************************************************
 *
 * FUNCTION:    vSet_tunmstr_MuteHandler_Ptr
 *
 * DESCRIPTION: Set pointer to pointer tunmstr_Presethandler
 *
 * PARAMETER:   tunmstr_Presethandler* potunmstr_Presethandler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_DABClient_Handler::vSet_tunmstr_MuteHandler_Ptr(tunmstr_MuteHandler* potunmstr_MuteHandler)
{
	if( potunmstr_MuteHandler != NULL )
	{
		m_potunmstr_MuteHandler = ( tunmstr_MuteHandler* )potunmstr_MuteHandler;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_MuteHandler != NULL );
	}
}
/*************************************************************************
 * FUNCTION:    vSet_tunmstr_AudioClientHandler_Ptr(tunmstr_AudioClientHandler* potunmstr_AudioClientHandler)
 *
 * DESCRIPTION: Set pointer to pointer tunmstr_AudioClientHandler
 *
 * PARAMETER:   tunmstr_AudioClientHandler* potunmstr_AudioClientHandler
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmstr_DABClient_Handler::vSet_tunmstr_AudioClientHandler_Ptr(tunmstr_AudioClientHandler* potunmstr_AudioClientHandler)
{
	if( potunmstr_AudioClientHandler != NULL )
	{
		m_potunmstr_AudioClientHandler = ( tunmstr_AudioClientHandler* )potunmstr_AudioClientHandler;
	}
}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_DABClient_Handler::vSet_tunmstr_MsgToHMI_Ptr( )
 *
 * DESCRIPTION:
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunmstr_DABClient_Handler::vSet_tunmstr_MsgToHMI_Ptr( tunmstr_MsgToHMI* potunmstr_MsgToHMI )
{
	if( potunmstr_MsgToHMI != NULL )
	{
		m_potunmstr_MsgToHMI = potunmstr_MsgToHMI;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_MsgToHMI != NULL );
	}
}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_DABClient_Handler::vSet_tunmstr_SrcChg_AnnoHandler_Ptr( )
 *
 * DESCRIPTION:  Set pointer to pointer m_potunmstr_SrcChg_AnnoHandler*
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_DABClient_Handler::vSet_tunmstr_MsgFromHMI_Ptr( tunmstr_MsgFromHMI* potunmstr_MsgFromHMI )
{
	if( potunmstr_MsgFromHMI != NULL )
	{
		m_potunmstr_MsgFromHMI= ( tunmstr_MsgFromHMI* )potunmstr_MsgFromHMI;
	}
	else
	{
		NORMAL_M_ASSERT ( m_potunmstr_MsgFromHMI != NULL );
	}
}

/*************************************************************************
 * FUNCTION:     u8GetDABServiceState
 *
 * DESCRIPTION:	Returns DAB service availabel status
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  tU8
 *************************************************************************/
tU8 tunmstr_DABClient_Handler::u8GetDABServiceState()const
{
	return m_u8ServiceAvailable_DAB;
}
/*************************************************************************************
 *FUNCTION:     tunmstr_DABClient_Handler::vOnServiceState
 *
 *DESCRIPTION:  Handles DAB service state
 *
 *PARAMETER:    tU16,tU16,tU16,tU8,tU16,
 *
 *RETURNVALUE: None
 ************************************************************************************/
tVoid tunmstr_DABClient_Handler :: vOnServiceState(   tU16  u16ServiceId ,
		tU16  u16ServerId ,
		tU16  u16RegisterId,
		tU8   u8ServiceState,
		tU16  u16SubId      )
{
	if(( u16ServiceId  !=  CCA_C_U16_SRV_DAB_TUNER) || (m_potunmstr_TunerClientHandler == NULL)||
			(m_potunmstr_SrcChgManager==NULL)|| (m_poclConfigInterface == NULL) ||
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		(NULL==m_potunmstr_AudioClientHandler) ||
#else
		(NULL == m_poSessionControl) ||
#endif
      (m_potunmstr_Preset_Handler == NULL))
	{
		NORMAL_M_ASSERT (NULL != m_potunmstr_TunerClientHandler);
		NORMAL_M_ASSERT (NULL != m_potunmstr_SrcChgManager);
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT (NULL != m_potunmstr_AudioClientHandler);
#endif
		NORMAL_M_ASSERT (NULL != m_potunmstr_Preset_Handler);
		return;
	}

	ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vOnServiceState Service States"
			"u16ServiceId=%d u8ServiceState=%d u16RegisterId=%d c=%d u16SubId=%d u16ServerId=%d",
			u16ServiceId,
			u8ServiceState,
			u16RegisterId,
			u16RegisterId,
			u16SubId,
			u16ServerId));
	// Analyze the state of the server
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		m_poSessionControl->vOnServiceState(tuner::common::DABTUNER, static_cast<tuner::common::enTunerClientAvailability>(u8ServiceState));
#endif
	switch(u8ServiceState)
	{
	case AMT_C_U8_SVCSTATE_AVAILABLE:
	{
		m_u8ServiceAvailable_DAB = TRUE;
		tU16 u16FID;
		m_u16RegID=u16RegisterId;
		//Trace the status Accepted or rejected
		ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vOnServiceState, Service Available"
				"DABTUN -> Reg ID : =%d",
				m_u16RegID));

		u16FID = MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_CHANNEL_INFO;
		fregisterForFID(u16FID); // register for MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_CHANNEL_INFO
		u16FID = MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_ANNO_STATUS;
		fregisterForFID(u16FID); // register for MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_ANNO_STATUS
		/* commented to avoid double deletion.
		u16FID = MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_EXT_SERVICE_FOLLOWING_STATUS;
		fregisterForFID(u16FID); // register for MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_EXT_SERVICE_FOLLOWING_STATUS*/
		u16FID = MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_MUTE_REQUEST;
		fregisterForFID(u16FID);
		u16FID = MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_PRESET_LIST;
		fregisterForFID(u16FID); // register for MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_PRESET_LIST
		u16FID = MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_MTC_SETMODE_STATUS;
		fregisterForFID(u16FID); // register for MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_MTC_SETMODE_STATUS
		u16FID = MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_MTC_SURVEILLANCE_MONITOR;
		fregisterForFID(u16FID); // register for MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_MTC_SURVEILLANCE_MONITOR

		u16FID = MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_MTC_SURVEILLANCE_MONITOR;
		fregisterForFID(u16FID); // register for MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_MTC_SURVEILLANCE_MONITOR
  		if( ! poGWMain->blGetStratUpTriggerSent_Info())
		{
			poGWMain->vTunerMasterStartUpProcess();
		}

		// even if DAB is available via SRV, but the Source should be avail based on PD And CD
		if(m_poclConfigInterface->u32GetConfigData("DABSupported"))
		{
			for(tU8 u8Source=(tU8)ARL_SRC_DAB;u8Source<=(tU8)ARL_SRC_DABTA;u8Source++)
			{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
				m_potunmstr_AudioClientHandler->vSendSourceavailability((arl_tenSource)u8Source,ARL_EN_SRC_PLAYABLE,ARL_EN_REASON_NEWMEDIA);
#else
				if(m_poclConfigInterface->u32GetConfigData("SBR"))
				{
					if(m_potunmstr_TunerClientHandler->u8GetTunerService())
					{
						m_poArlImpl->vUpdateAudioSourceAvailabelStatus((arl_tenSource)u8Source,ARL_EN_SRC_PLAYABLE,ARL_EN_REASON_NEWMEDIA);
						m_poArlImpl->vRequestMute(tuner::common::DAB,tuner::common::DEMUTE); /*Added to send demute when tuner comes up*/
					}
				}
				else
				{
					m_poArlImpl->vUpdateAudioSourceAvailabelStatus((arl_tenSource)u8Source,ARL_EN_SRC_PLAYABLE,ARL_EN_REASON_NEWMEDIA);
					m_poArlImpl->vRequestMute(tuner::common::DAB,tuner::common::DEMUTE); /*Added to send demute when tuner comes up*/
				}
#endif
			}
		}
  		m_potunmstr_Preset_Handler->Update_tunmstr_bStartUpFlag(TRUE);

		vSendPresetListReq();
		//On DAB service avail info,send Preset list update request to DAB tuenr
  		vHandlePendingSrcChgReq_DAB();
		break;
	}
	case AMT_C_U8_SVCSTATE_NOT_AVAILABLE:
	{
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		tuner::common::enSourceId currentSourceId = m_poArlImpl->getActiveSource();
		if(bIsTemporarySource(currentSourceId) && oGetTunerClient(currentSourceId) == tuner::common::DABTUNER)
		{
			ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vOnServiceState currentSourceId = %d", currentSourceId));
			// Get the active type of DAB announcement and request for switching off
			midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus oAnnoStatus;
			midw_ext_fi_tcl_DAB_AnnoElement oAnnoElement;
			oAnnoElement.u16AnnoType = oAnnouncementControl.oGetActiveMidwAnnouncementId();
			oAnnoElement.AnnoState.enType = midw_ext_fi_tcl_e8_DAB_AnnouncementStatus::FI_EN_END;
			oAnnoStatus.AnnoStatus.AnnouncementList.push_back(oAnnoElement);				
			oAnnouncementControl.vOnNewAnnouncementList(oAnnoStatus.AnnoStatus.AnnouncementList,m_poSessionControl->getStoredPreviousSessionStateBeforeAnnoucementSrc(),m_poSessionControl->getStoredPreviousSessionStateBeforeAnnoucementSrcActivity());
		}
#endif
		// Service is not available anymore
		// Don't do anything..wait for availability
		tU8 u8TunerService_State = m_potunmstr_TunerClientHandler->u8GetTunerService();
		m_potunmstr_SrcChgManager->vClearDABStates();
		m_u8ServiceAvailable_DAB = FALSE;
		for(tU8 u8Source=(tU8)ARL_SRC_DAB;u8Source<=(tU8)ARL_SRC_DABTA;u8Source++)
		{
           #ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			m_potunmstr_AudioClientHandler->vSendSourceavailability((arl_tenSource)u8Source,ARL_EN_SRC_PLAYABLE_UNKNOWN,ARL_EN_REASON_SAMEMEDIA);
#else
			/*Source availability will be sent only when the amfm/dab service becomes available*/
			//m_poArlImpl->vUpdateAudioSourceAvailabelStatus((arl_tenSource)u8Source,ARL_EN_SRC_PLAYABLE_UNKNOWN,ARL_EN_REASON_SAMEMEDIA);
         #endif
		}
		if (u8TunerService_State ==FALSE)
		{
			ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vOnServiceState Service States, Both FM and DAB unavail, call sthutdown process"));
			poGWMain->vTunerMasterShutDownProcess();
		}
		else
		{
			//Do nothing
		}
		//Don't clear the preset list static member, it will cause the system restart during startup.
if(m_poclConfigInterface->u32GetConfigData("PresetListType"))
{	
	m_potunmstr_Preset_Handler->vUpdateMixedPresetListBandAsNone();
}

	break;
	}
	case AMT_C_U8_SVCSTATE_REG_INVALID:
	{
		// Server has lost our registration.
		m_u16RegID=AMT_C_U16_REGID_INVALID;
		// Try to register again
		vRegisterForService();
		m_u8ServiceAvailable_DAB = FALSE;
	break;
	}
	default:
	{
		m_u16RegID=AMT_C_U16_REGID_INVALID;
		vRegisterForService();
	break;
	}
	} // switch(u8ServiceState)
	//Trace the status Accepted or rejected
	ET_TRACE_INFO_BIN( TUNMSTR_TRACE_CLASS_SRCCHG, ET_EN_STRING _ "DABTUN -> Reg ID :" _
			ET_EN_T16 _ m_u16RegID _ ET_EN_DONE );
}
/*************************************************************************************
 *FUNCTION:     tunmstr_DABClient_Handler::vNewAppState
 *
 *DESCRIPTION:  Function to hanlde the Tunermaster Application state
 *
 *PARAMETER:    tU16,tU16,tU16,tU8,tU16,
 *
 *RETURNVALUE: None
 ************************************************************************************/
tVoid tunmstr_DABClient_Handler :: vOnNewAppState(  tU32 u32OldAppState,  tU32 u32NewAppState  )
{
	ETG_TRACE_USR1(( "vOnNewAppState()->u32OldAppState=%d u32NewAppState=%d",u32OldAppState,u32NewAppState));
	switch(u32NewAppState)
	{
		case AMT_C_U32_STATE_DIAGNOSIS:
		case AMT_C_U32_STATE_NORMAL:
		case AMT_C_U32_STATE_PAUSE:
		{
			vRegisterForService();
			break;
		}
		case AMT_C_U32_STATE_OFF:
		{
			//fUnregisterForService();
			break;
		}
		default:
		{
			ETG_TRACE_USR4(("vOnNewAppState, Application state is not handled here"));
		}
	} // end of Switch
}// end of NewAppState
/*************************************************************************************
 *FUNCTION:     tunmstr_DABClient_Handler::fUnregisterForService
 *
 *DESCRIPTION:  Sends a unregister message to Diaglog
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  tBool
 ************************************************************************************/
tBool tunmstr_DABClient_Handler::fUnregisterForService()
{
	// Return value
	tBool fIsServiceUnregistered = TRUE;
	// Unregister if registration is valid?
	if ( AMT_C_U16_REGID_INVALID != m_u16RegID )
	{
		// Send an unregister for service message
		if ( NULL == poGWMain )
		{
			NORMAL_M_ASSERT (NULL != poGWMain);
			return FALSE;
		}
		else
		{
			poGWMain->vUnregisterService( (tU16) CCA_C_U16_SRV_DAB_TUNER );
			ETG_TRACE_USR1(("fUnregisterForService, UNREG Success"));
		}
		// Make register-ID invalid:
		m_u16RegID = AMT_C_U16_REGID_INVALID;
		m_u8ServiceAvailable_DAB = FALSE;
	}
	// return whether the service is unregistered
	return fIsServiceUnregistered;
}
/*************************************************************************************
 *FUNCTION:     tunmstr_DABClient_Handler::fregisterForFID
 *
 *DESCRIPTION:  Handles the state changes of the service we use
 *
 *PARAMETER:    u16FID
 *
 *RETURNVALUE: tBool
 ************************************************************************************/
tBool tunmstr_DABClient_Handler :: fregisterForFID(tU16 u16FID)
{
	tBool bRetVal = FALSE;
	if ( NULL == poGWMain )
	{
		NORMAL_M_ASSERT (NULL != poGWMain);
		return FALSE;
	}
	if(m_u16RegID!=AMT_C_U16_REGID_INVALID)
	{
		gm_tclEmptyMessage oUpRegMessage( CCA_C_U16_APP_TUNERMASTER,  // AppID of this application
			CCA_C_U16_APP_FC_DABTUNER,      // AppID of the Server
			m_u16RegID,                // RegId for the service (see bRegisterForService )
			0,                        // always 0
			CCA_C_U16_SRV_DAB_TUNER,  // SID of the service
			u16FID,                   // FID to register for
			AMT_C_U8_CCAMSG_OPCODE_UPREG);
	if (poGWMain->enPostMessage(&oUpRegMessage, TRUE) == AIL_EN_N_NO_ERROR)
	{
		// message send success - set the return value to TRUE
		bRetVal = TRUE;
			ETG_TRACE_USR4(("tunmstr_DABClient_Handler::fregisterForFID, REG Success"));
	}
	else
	{
			ETG_TRACE_USR4(("tunmstr_DABClient_Handler::fregisterForFID, REG NOK"));
	}
	}
	return bRetVal;
}
/*************************************************************************************
 *FUNCTION:     tunmstr_DABClient_Handler::vRegisterForService
 *
 *DESCRIPTION:  Function to register for DAB tuner service

 *PARAMETER:    tVoid
 *
 *RETURNVALUE:  tVoid
 ************************************************************************************/
tVoid tunmstr_DABClient_Handler::vRegisterForService()
{
	// Return value
	tBool fIsServiceRegistered = FALSE;
	if ( NULL == poGWMain )
	{
		NORMAL_M_ASSERT (NULL != poGWMain);
		return;
	}
	// Is registration invalid ?
	if ( AMT_C_U16_REGID_INVALID == m_u16RegID )
	{
		// Try to register
		// Try to register
#ifndef VARIANT_S_FTR_ENABLE_FEAT_VDFMAM_AUD_CCACOMM
		fIsServiceRegistered = poGWMain->bRegisterAsync (CCA_C_U16_SRV_DAB_TUNER,
				MIDW_EXT_DABTUNERFI_C_U16_SERVICE_MAJORVERSION /* Major version */,
				MIDW_EXT_DABTUNERFI_C_U16_SERVICE_MINORVERSION /* Minor version */,
				0x0,
				CCA_C_U16_APP_FC_DABTUNER
		);
		ETG_TRACE_USR1(( " vRegisterForService()"));
#else
		m_u16SrvRegID = poGWMain->u16RegisterService(CCA_C_U16_SRV_DAB_TUNER,
				2                      /* Major version */,
				0                      /* Minor version */,
				0x0,
				CCA_C_U16_APP_FC_DABTUNER);
		fIsServiceRegistered = ( m_u16SrvRegID != AMT_C_U16_REGID_INVALID );

#endif
	}
	if(fIsServiceRegistered == TRUE)
	{
		ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vRegisterForService, REG for Service OK"));
	}
	else
	{
		ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vRegisterForService, REG for Service NOK"));
	}
}
/*************************************************************************************
 *FUNCTION:    tunmstr_DABClient_Handler::vSendMessage
 *
 *DESCRIPTION: This function converts Amt message to visitor class and
 *             get the data from visitor to the FI class. Refer FI Manual.Doc.
 *
 *PARAMETER:    tU16,fi_tclTypeBase& ,tU16,tU8,tU16,tU16
 *
 *RETURNVALUE: None
 ************************************************************************************/
tVoid tunmstr_DABClient_Handler :: vSendMessage( tU16             u16DestAppID,
		const fi_tclTypeBase&  oOutData,
		tU16             u16Fid,
		tU8              u8OpCode,
		tU16             u16CmdCtr,
		tU16             u16RegId)
{
	if( ( NULL == poGWMain )||(u16RegId==AMT_C_U16_REGID_INVALID))
	{

		NORMAL_M_ASSERT (NULL != poGWMain);
		//NORMAL_M_ASSERT (AMT_C_U16_REGID_INVALID != u16RegId);
		return;
	}
	// Create the Visitor Message
	fi_tclVisitorMessage oOutVisitorMsg(oOutData,1);

	// Set the CCA message information
	oOutVisitorMsg.vInitServiceData(  CCA_C_U16_APP_TUNERMASTER,                  /* Source app-ID    */
			u16DestAppID,                         /* Dest. app-ID     */
			AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,    /* stream type      */
			0,                                    /* stream counter   */
			u16RegId,                             /* Registry ID      */
			u16CmdCtr,                            /* Command counter  */
			CCA_C_U16_SRV_DAB_TUNER,                /* Service-ID       */
			u16Fid,                               /* Function-ID      */
			u8OpCode,                             /* OpCode           */
			0,                                    /* ACT              */
			0,                                    /* Source sub-ID    */
			0 );                                  /* Dest. sub-ID     */


	// Send it to the client
	if(poGWMain->enPostMessage(&oOutVisitorMsg, TRUE) != AIL_EN_N_NO_ERROR)
	{
		ETG_TRACE_USR4(("vSendMessage()->Message sent successfully."));
	}
	else
	{
		ETG_TRACE_USR4(("vSendMessage()->Message not sent successfully."));
	}
}
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
/*************************************************************************************/
tBool tunmstr_DABClient_Handler::bIsRequestedSourceDAB()
{
	if(((m_poSessionControl->oGetRequestedSource() == tuner::common::DAB || m_poSessionControl->oGetRequestedSource() == tuner::common::DABANNOUNCEMENTS))
		&& (m_poSessionControl->oGetRequestedSourceState() ==tuner::common::SRC_CHANGE_REQUESTED))
	{
		return true;
	}
	return false;
}
#endif
/*************************************************************************************
 *FUNCTION:    vHandle_s_Source_State
 *
 *DESCRIPTION: Function to handle FID_DAB_S_SOURCE_STATE method result
 *
 *PARAMETER:   amt_tclServiceData* poMessage
 *
 *RETURNVALUE: tVoid
 ************************************************************************************/
tVoid tunmstr_DABClient_Handler::vHandle_s_MethodResult_SrcChg(amt_tclServiceData* poMessage)
{
	if((poMessage == NULL )||(m_potunmstr_SrcChgManager == NULL) ||(m_potunmstr_TunerClientHandler==NULL)
			 || (m_poclConfigInterface == NULL))
	{
		ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vHandle_s_Source_State, Null Pointer"));

		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
		NORMAL_M_ASSERT( m_potunmstr_TunerClientHandler != NULL );
		NORMAL_M_ASSERT (m_poclConfigInterface !=NULL);
		return;
	}// if....
	switch (poMessage->u16GetFunctionID())
	{
	case MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SOURCE_STATE:
	{
		if(poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
		{
			midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodResult oResult;
			//create an object of  FID_TUNMSTR_S_MIXED_PRESET_RECALL
			vGetDataFromAmt(poMessage,oResult);
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			if( midw_ext_fi_tcl_e8_DAB_SourceState::FI_EN_DAB_LEARN_FOREVER == oResult.e8SourceState.enType  ||  midw_ext_fi_tcl_e8_DAB_SourceState::FI_EN_DAB_BG_LEARN_FOREVER == oResult.e8SourceState.enType)
			{
				/*No operation in case of FG and BG learn forever*/
				return;
			}
			m_poSessionControl->vOnNewDabTunerState((tuner::common::enTunerState)oResult.e8SourceState.enType);
			ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vHandle_s_MethodResult_SrcChg = %d ", (tU8)oResult.e8SourceState.enType));
			if(bIsRequestedSourceDAB())
			{
				if(!(m_poclConfigInterface->u32GetConfigData("SBR")))
				{
					m_poSessionControl->vOnNewTunerBand(midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_INVALID);
					m_poSessionControl->vOnNewTunerState(oResult.e8SourceState.enType);
				}
				m_potunmstr_TunerClientHandler->vHandleDABSurvivellenceState();
			}
#else
		    tU8 u8Result = (tU8)oResult.e8MethodResult.enType;
			m_potunmstr_SrcChgManager->vHandleSrcChg_MethodResult_DAB (u8Result);
					ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vHandle_s_Source_State, Sent to handler"));
#endif
		}

		break;
	}
	case MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SELECT_ANNO:
	{
		if(poMessage->u8GetOpCode() == AMT_C_U8_CCAMSG_OPCODE_METHODRESULT)
		{
			midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodResult oResult;
			//create an object of  FID_TUNMSTR_S_MIXED_PRESET_RECALL
			vGetDataFromAmt(poMessage,oResult);
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		if(bIsTemporarySource(m_poSessionControl->oGetRequestedSource()))
		{
			if( (m_poSessionControl->oGetRequestedSourceActivity() == tuner::common::SRCON) ||
					(m_poSessionControl->oGetRequestedSourceActivity() == tuner::common::SRCPAUSE) )
			{
				oAnnouncementControl.vOnNewTunerState(tuner::common::TAFG);
			}
			else
			{
				oAnnouncementControl.vOnNewTunerState(tuner::common::TUNERSTATE_UNKNOWN);
			}
		}
		m_poSessionControl->vOnNewTunerBand(midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_INVALID);
		if(!(m_poclConfigInterface->u32GetConfigData("SBR")))
		{
			m_poSessionControl->vOnNewTunerState(midw_ext_fi_tcl_e8_DAB_SourceState::FI_EN_DAB_FOREGROUND);
		}
#else
		    tU8 u8Result = (tU8)oResult.e8MethodResult.enType;
			m_potunmstr_SrcChgManager->vHandleSrcChg_MethodResult_DAB (u8Result);
#endif
					ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vHandle_s_Select ANNO, Sent to handler"));
		}

		break;
	}
	default:
	{
		break;
	}
	};// switch
}// endof Function
/*************************************************************************************
 *FUNCTION:    vHandle_s_Set_Mute_Status
 *
 *DESCRIPTION: Function to handle FID_DAB_S_SET_MUTE_STATUS method result
 *
 *PARAMETER:    amt_tclServiceData* poMessage
 *
 *RETURNVALUE: tVoid
 ************************************************************************************/
tVoid tunmstr_DABClient_Handler::vHandle_s_Set_Mute_Status(amt_tclServiceData* poMessage)const
{
	if(poMessage == NULL )
	{
		ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vHandle_s_Source_State, Null Pointer"));
		NORMAL_M_ASSERT( poMessage != NULL );
		return;
	}// if....
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
	{
		midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodResult oResult;
		//create an object of  FID_TUNMSTR_S_MIXED_PRESET_RECALL
		vGetDataFromAmt(poMessage,oResult);
		tU8 u8Temp = (tU8)oResult.e8MethodResult.enType;
		if((tU8)TUNMSTR_SRCCHG_DAB_RES_OK == u8Temp)
		{
			ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vHandle_s_Set_Mute_Status, MethodResult success"));
		}
		else
		{
			ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vHandle_s_Set_Mute_Status, MethodResult FAIL!!!"));
		}
	}
	break;
	default:
	{
		break;
	}
	};// switch
}// endof Function
/*************************************************************************************
 *FUNCTION:    tunmstr_DABClient_Handler::vSend_s_Source_State(tU8 u8DAB_State)
 *
 *DESCRIPTION: Fucntion to send FGBG request to DAB tuner
 *
 *PARAMETER:    tU8 u8DAB_State
 *
 *RETURNVALUE: tVoid
 ************************************************************************************/
tVoid tunmstr_DABClient_Handler::vSend_s_Source_State(tU8 u8DAB_State)
{
/*#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
#ifdef VARIANT_S_FTR_ENABLE_DAB_SURVEILLANCE
	if(u8DAB_State != (tU8)midw_ext_fi_tcl_e8_DAB_SourceState::FI_EN_DAB_FOREGROUND)
	{
		u8DAB_State = (tU8)((oAnnouncementControl.oGetPICode() != 0)?
				(midw_ext_fi_tcl_e8_DAB_SourceState::FI_EN_DAB_BACKGROUND):
				(midw_ext_fi_tcl_e8_DAB_SourceState::FI_EN_DAB_FOREGROUND_ANNO_SURVEILLANCE));
		if((tU8)m_poSessionControl->getActiveTunerState(tuner::common::DABTUNER) != u8DAB_State)
		{
			m_poSessionControl->vOnNewDabTunerState(static_cast<tuner::common::enTunerState>(u8DAB_State));
		}
	}
#endif
#endif*/
	

	if((m_potunmstr_Preset_Handler==NULL)
	#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	||(m_potunmstr_AudioClientHandler==NULL)
	#endif
	)
	{
		return;
	}
	stPresetHandlingReguest oPresetHandleReq=m_potunmstr_Preset_Handler->stGetPresetHandleRequest();
	if(oPresetHandleReq.eBand.enType == midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_DAB)
	{
		//Check will be removed once the amfm mute interface defined
		if(oPresetHandleReq.ePresetAction.enType==midw_fi_tcl_e8_Tun_PresetAction::FI_EN_RECALL_ELEMENT)
		{
			/*m_potunmstr_Preset_Handler->vUpdatePresetRequestVar(NormalPresetRecall);
			m_potunmstr_AudioClientHandler->vStoreMuteParameter(m_potunmstr_AudioClientHandler->enConvertFiSourcetoArlSrc((tU8)oPresetHandleReq.eBand.enType),\
					ARL_EN_MUTEACTION_MUTE,ARL_EN_MUTE_REASON_OTHER);
			m_potunmstr_AudioClientHandler->vSendMuteState(m_potunmstr_AudioClientHandler->enConvertFiSourcetoArlSrc((tU8)oPresetHandleReq.eBand.enType),\
					ARL_EN_MUTEACTION_MUTE,ARL_EN_MUTE_REASON_OTHER);*/
			//Send preset recall method start to DAB
			midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart oMethodStart;
			oMethodStart.u8ActPresetElemID=oPresetHandleReq.u8Element_ID;
			vSendMessage( CCA_C_U16_APP_FC_DABTUNER,// Destination APP ID
				oMethodStart,           // parameter&
				MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_ACTIVATE_PRESET_LIST_ELEM, //FID
				AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
				0,
				m_u16RegID );

			/**Clear the request so that we will not call the same preset again after putting the source to FG*/
			m_potunmstr_Preset_Handler->vClearPreserHandleRequest();
		}
	}
	vSendSourceState(u8DAB_State);
	ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vSend_s_Source_State, Message Sent"
					"u8DAB_State -> %d",
					u8DAB_State));
}//end of Function

tVoid tunmstr_DABClient_Handler::vSendSourceState(tU8 u8DAB_State)
{
	//ETG_TRACE_USR4((" tunmstr_SrcChgManager::vSend_s_Source_State"));

	midw_ext_dabtunerfi_tclMsgFID_DAB_S_SOURCE_STATEMethodStart oMsgData;
	oMsgData.e8SourceState.enType = (midw_ext_fi_tcl_e8_DAB_SourceState::tenType)u8DAB_State;
	vSendMessage( CCA_C_U16_APP_FC_DABTUNER,// Destination APP ID
			oMsgData,           // parameter&
			MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SOURCE_STATE, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0,
			m_u16RegID //Registration ID
	);
	ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vSend_s_Source_State, Message Sent"
				"u8DAB_State -> %d",
				u8DAB_State));

}

/*************************************************************************************
 *FUNCTION:    tunmstr_DABClient_Handler::vSend_s_Activate_Preset_List_Elem(tU8 u8Elem_ID)
 *
 *DESCRIPTION: This function will call CCA Message FID_DAB_S_ACTIVATE_PRESET_LIST_ELEM
 *
 *PARAMETER:    tU8
 *
 *RETURNVALUE: None
 ************************************************************************************/
tVoid tunmstr_DABClient_Handler::vSend_s_Activate_Preset_List_Elem(tU8 u8Elem_ID)
{
	midw_ext_dabtunerfi_tclMsgFID_DAB_S_ACTIVATE_PRESET_LIST_ELEMMethodStart oMsgData;
	oMsgData.u8ActPresetElemID = u8Elem_ID;

	vSendMessage( CCA_C_U16_APP_FC_DABTUNER,// Destination APP ID
			oMsgData,           // parameter&
			MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_ACTIVATE_PRESET_LIST_ELEM, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0,
			m_u16RegID //Registration ID
	);
	ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vSend_s_Activate_Preset_List_Elem, Message Sent"
			"u8Elem_ID -> %d ",
			u8Elem_ID));
}//end of Function
/*************************************************************************************
 *FUNCTION:    vHandle_g_Channel_Info
 *
 *DESCRIPTION: This function handel CCA Message FID_DAB_G_CHANNEL_INFO
 *
 *PARAMETER:    amt_tclServiceData *poMessage
 *
 *RETURNVALUE: None
 ************************************************************************************/
tVoid tunmstr_DABClient_Handler::vHandle_g_Channel_Info(amt_tclServiceData *poMessage)
{
	if( (poMessage == NULL )||(m_potunmstr_SrcChg_AnnoHandler == NULL) || (m_potunmstr_SrcChgManager == NULL)
#ifdef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
		|| (m_potunmstr_MsgToHMI == NULL)
#endif
		)
	{
		ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vHandle_g_Channel_Info, Null Pointer"));

		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChg_AnnoHandler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
#ifdef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
#endif
		return;
	}// if....
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_STATUS:
	{
		midw_ext_dabtunerfi_tclMsgFID_DAB_G_CHANNEL_INFOStatus oStatus;

		vGetDataFromAmt(poMessage,oStatus);
		// Convert into AMT format
		m_bFmServiceFollowActive = oStatus.ChannelInfo.bFmServiceFollowActive;
#ifndef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB

		/**If the DAMFM linking is received and the DABTA is active then cancel the DABTA / Alarm / Other Announcements immediately*/
		if(m_bFmServiceFollowActive && \
			(\
				TUNMSTR_SRCCHG_SOURCE_DAB_TA == m_potunmstr_SrcChgManager->u8GetCurrentTA_Source()\
				||
				TUNMSTR_SRCCHG_SOURCE_DABPTY31 == m_potunmstr_SrcChgManager->u8GetCurrentTA_Source()\
				||
				TUNMSTR_SRCCHG_SOURCE_DABOTHER == m_potunmstr_SrcChgManager->u8GetCurrentTA_Source()\
			)\
		)
		{
			vSend_s_StopAnno();
		}

		tU8  u8Anno;
		tU16 u16Anno = (tU16)oStatus.ChannelInfo.b16AvailableAnnoTypesMask.u16Value;
		u8Anno = (tU8)u16Anno;
		m_potunmstr_SrcChg_AnnoHandler->vCheckForTPStatus(u8Anno, (tU8)TUNMSTR_SRCCHG_SOURCE_DAB);
		ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vHandle_g_Channel_Info, Message Recived"
				"u8Anno -> %d ",
				u8Anno));
#else
		tuner::common::enTpState tpState = tuner::common::TP_NOTAVAILABLE;
		ETG_TRACE_USR4(("TPStatus: ChannelInfo::b16AvailableAnnoTypesMask=%d  ", oStatus.ChannelInfo.b16AvailableAnnoTypesMask.u16Value));
		bool tpStatus = oStatus.ChannelInfo.b16AvailableAnnoTypesMask.bDAB_ANNOTYPE_TA();
		if (tpStatus)
		{
			tpState = tuner::common::TP_AVAILABLE;
		}
		ETG_TRACE_USR4(("TPStatus: ChannelInfo::tpStatus=%d bFmServiceFollowActive=%d  ", tpStatus, oStatus.ChannelInfo.bFmServiceFollowActive));
		oAnnouncementControl.vOnNewTpState(tuner::common::BANDDAB, tpState);
		oAnnouncementControl.vOnSourceFollowingState(tuner::common::BANDDAB, oStatus.ChannelInfo.bFmServiceFollowActive);
		m_potunmstr_MsgToHMI->vSend_g_TP_Status(tpStatus, (tU8)midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_DAB);


		tU8 u8ActiveTunerBand = (tU8)(clSessionControl::getInstance()->getActiveTunerBand());
		tU8 u8SrcActivity  = (tU8)m_poArlImpl->getActiveSourceActivity();

		if((u8ActiveTunerBand == (tU8)tuner::common::BANDDAB) && ((u8SrcActivity == (tU8)tuner::common::SRCON) || (u8SrcActivity == (tU8)tuner::common::SRCPAUSE)))
		{
			if(m_u8PresetAutocompare != oStatus.ChannelInfo.u8PresetListElementID)
			{
				m_potunmstr_MsgToHMI->vSend_g_PresetAutoCompare(oStatus.ChannelInfo.u8PresetListElementID, FALSE);
				m_u8PresetAutocompare = oStatus.ChannelInfo.u8PresetListElementID;
			}
		}

#endif

	}
	break;
	default:
	{
		break;
	}
	};// switch
}//end of Function
/*************************************************************************************
 *FUNCTION:    vHandle_g_Anno_Status
 *
 *DESCRIPTION: This function handel CCA Message FID_DAB_G_ANNO_STATUS
 *
 *PARAMETER:    amt_tclServiceData *poMessage
 *
 *RETURNVALUE: None
 ************************************************************************************/
tVoid tunmstr_DABClient_Handler::vHandle_g_Anno_Status(amt_tclServiceData *poMessage)
{
	if((poMessage == NULL )||(m_potunmstr_SrcChg_AnnoHandler == NULL))
	{
		ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vHandle_g_Anno_Status, Null Pointer"));

		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChg_AnnoHandler != NULL );
		return;
	}// if....
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_STATUS:
	{
		midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus oStatus;
		vGetDataFromAmt(poMessage,oStatus);
#ifndef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
		// Convert into AMT format
		tU32 u32AnnoConfig = (tU32)oStatus.AnnoStatus.AnnoConfigTypes.u16Value;
		m_potunmstr_SrcChg_AnnoHandler->vHandleAnnoConfig(u32AnnoConfig);
		tU16 u16Anno_Sel_Type = oStatus.AnnoStatus.AnnoSelectedTypes.u16Value;
		tU8 u8AnnoSelectState = (tU8)oStatus.AnnoStatus.AnnoSelectState.enType;
		tU8 u8Length = oStatus.AnnoStatus.AnnouncementList.size();
		ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vHandle_g_Anno_Status, Message Recived"
				"AnnoSel_Type -> %d  State ->%d Length ->%d",
				u16Anno_Sel_Type,u8AnnoSelectState ,u8Length));
			ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vHandle_g_Anno_Status, Message Recived"
				"AnnoSel_Type -> %d  State ->%d Length ->%d",
				u16Anno_Sel_Type,u8AnnoSelectState ,u8Length));
			if(u8Length >0)
			{ 

			midw_ext_fi_tcl_DAB_AnnoElement oAnnoElem;
				// Create object of Anno element type
			for(tU8 i = 0;i<u8Length;i++)
			 {
				oAnnoElem.u16AnnoType=oStatus.AnnoStatus.AnnouncementList[i].u16AnnoType;
				oAnnoElem.AnnoState.enType=oStatus.AnnoStatus.AnnouncementList[i].AnnoState.enType;
				//extarct Announcment details from Fc_DAB
				//m_eAnnoElement.AnnoStatus.AnnouncementList.push_back(oAnnoElem);
				m_eAnnoElement.AnnoStatus.AnnouncementList.at (i) = oAnnoElem;
				ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vHandle_g_Anno_Status, Message Reu16Anno_Sel_Typecived"
					"AnnoType -> %d  State =%d",
					oAnnoElem.u16AnnoType,oAnnoElem.AnnoState.enType ));
			 }
				vHandleAnnoInfo(u8Length);

			}
			else
			{
				ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vHandle_g_Anno_Status, list length zero"));
			}
#else
			tU32 u32AnnoConfig = (tU32)oStatus.AnnoStatus.AnnoConfigTypes.u16Value;
	        m_potunmstr_SrcChg_AnnoHandler->vHandleAnnoConfig(u32AnnoConfig);
			oAnnouncementControl.vOnNewAnnouncementList(oStatus.AnnoStatus.AnnouncementList,m_poSessionControl->getStoredPreviousSessionStateBeforeAnnoucementSrc(),m_poSessionControl->getStoredPreviousSessionStateBeforeAnnoucementSrcActivity());
#endif
	}
	break;
	default:
	{
		break;
	}
	};// switch
}//end of Function
/*******************************************************************************
 *FUNCTION:    tunmstr_DABClient_Handler::vGetDataFromAmt
 *
 *DESCRIPTION: This function converts Amt message to visitor class and
 *             get the data from visitor to the Fi class. Refer FI Manual.
 *             Doc.
 *
 *PARAMETER:
 *           poFiMsg   - Amt Message
 *           oFIData   - Base class of Fi class
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_DABClient_Handler::vGetDataFromAmt(amt_tclServiceData* poFIMsg,
		fi_tclTypeBase&     oFIData )const
{
	// Create Visitor message object for incoming message
	fi_tclVisitorMessage oInVisitorMsg(poFIMsg);

	/* Get the data in FI class from Vistor class*/
	if(OSAL_ERROR == oInVisitorMsg.s32GetData(oFIData,1))
	{
		// assert here
		NORMAL_M_ASSERT_ALWAYS ();
	}
}
/*************************************************************************************
 *FUNCTION:    vSend_s_Set_Mute_State
 *
 *DESCRIPTION: This function handel CCA Message FID_DAB_S_SET_MUTE_STATUS
 *
 *PARAMETER:    amt_tclServiceData *poMessage
 *
 *RETURNVALUE: None
 ************************************************************************************/
tVoid tunmstr_DABClient_Handler::vSend_s_Set_Mute_State(tBool blSource , tBool blState)
{
	midw_ext_dabtunerfi_tclMsgFID_DAB_S_SET_MUTE_STATUSMethodStart oMsgData;
	oMsgData.e8DabSource.enType =(midw_ext_fi_tcl_e8_DAB_Source::tenType) blSource;
	oMsgData.e8MuteStatus.enType =(midw_ext_fi_tcl_e8_DAB_MuteStatus::tenType) blState;
	vSendMessage( CCA_C_U16_APP_FC_DABTUNER,// Destination APP ID
			oMsgData,           // parameter&
			MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SET_MUTE_STATUS, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0,
			m_u16RegID //Registration ID
	);

	ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vSend_s_Set_Mute_State, Message Sent"
			"blSource -> %d  blState -> %d",
			blSource , blState));

}//end of Function
/*************************************************************************************
 *FUNCTION:    vSend_s_AutoStore
 *
 *DESCRIPTION: This function handel CCA Message FID_DAB_S_AUTOSTORE
 *
 *PARAMETER:    amt_tclServiceData *poMessage
 *
 *RETURNVALUE: None
 ************************************************************************************/
tVoid tunmstr_DABClient_Handler::vSend_s_AutoStore( tBool blStatus)
{
	midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodStart oMsgData;
	oMsgData.StartAutostore = blStatus;
	vSendMessage( CCA_C_U16_APP_FC_DABTUNER,// Destination APP ID
			oMsgData,           // parameter&
			MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_AUTOSTORE, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0,
			m_u16RegID //Registration ID
	);
	ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vSend_s_AutoStore, Message Sent"
			"  blState -> %d", blStatus));
}//end of Function
/*************************************************************************************
 *FUNCTION:    vHandle_g_Mute_Request
 *
 *DESCRIPTION: This function handel CCA Message FID_DAB_G_MUTE_REQUEST
 *
 *PARAMETER:    amt_tclServiceData *poMessage
 *
 *RETURNVALUE: None
 ************************************************************************************/
tVoid tunmstr_DABClient_Handler::vHandle_g_Mute_Request(amt_tclServiceData* poMessage)const
{
	if((poMessage == NULL )||(m_potunmstr_MuteHandler == NULL)
			|| (m_potunmstr_SrcChgManager == NULL)
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			|| (m_potunmstr_MsgFromHMI == NULL)
#endif
			)
	{
		ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vHandle_g_Mute_Request, Null Pointer"));
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MuteHandler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		NORMAL_M_ASSERT( m_potunmstr_MsgFromHMI != NULL );
#endif
		return;
	}// if....
	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_STATUS:
	{
		if(m_potunmstr_SrcChgManager->u8GetDABState() != (tU8)TUNMSTR_SRCCHG_BACKGROUND)
		{
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		   midw_ext_dabtunerfi_tclMsgFID_DAB_G_MUTE_REQUESTStatus oStatusMsg;
		   m_potunmstr_MsgFromHMI->vGetDatafromAMT(poMessage,oStatusMsg);

		   clSessionControl::getInstance()->vRequestMute(oStatusMsg.bRequestMute, oStatusMsg.bMute_Interrupt);
#else
			m_potunmstr_MuteHandler->vHandle_DABMuteRequest(poMessage);
#endif
		}
	}
	break;
	default:
	{
		break;
	}
	}//switch
}
/*************************************************************************************
 *FUNCTION:    vHandlePendingSrcChgReq_DAB
 *
 *DESCRIPTION: This function handel CCA Message FID_DAB_G_MUTE_REQUEST
 *
 *PARAMETER:    amt_tclServiceData *poMessage
 *
 *RETURNVALUE: None
 ************************************************************************************/
tVoid tunmstr_DABClient_Handler::vHandlePendingSrcChgReq_DAB()
{
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	if ( (m_potunmstr_AudioClientHandler == NULL) || (m_potunmstr_SrcChgManager == NULL))
	{
		ETG_TRACE_USR4((" tunmstr_DABClient_Handler::vHandleTunerSrcChgReq_OnSrvUnavil, Null pointer"));
		NORMAL_M_ASSERT (NULL != m_potunmstr_AudioClientHandler);
		NORMAL_M_ASSERT (NULL != m_potunmstr_SrcChgManager);
		return;
	}
	tU8 u8Source = m_potunmstr_AudioClientHandler->u8GetSrcReq_ServiceUnavail();
	tU8 u8Action = m_potunmstr_AudioClientHandler->u8GetSrcActivity_ServiceUnavail();
	switch(u8Source)
	{
		case TUNMSTR_SRCCHG_SOURCE_DAB_TA:
		{
			vHandlePendingDABTAReqFromARL(u8Action);
			break;
		}
		case TUNMSTR_SRCCHG_SOURCE_DAB:
		{
			if((tU8)TUNMSTR_SRCCHG_ACTION_ON==u8Action)
			{
				m_potunmstr_SrcChgManager->vHandleDABSrcChg_ON(u8Source);
			}
			else if((tU8)TUNMSTR_SRCCHG_ACTION_PAUSE==u8Action)
			{
				m_potunmstr_SrcChgManager->vHandleDABSrcChg_PAUSE(u8Source);
			}
			else if((tU8)TUNMSTR_SRCCHG_ACTION_OFF==u8Action)
			{
				m_potunmstr_SrcChgManager->vHandleDABSrcChg_OFF(u8Source);
			}
			else
			{
				//Nothing
			}
			m_potunmstr_AudioClientHandler->vSetSrcReq_ServiceUnavail(TUNMSTR_SRCCHG_INVALID);
			m_potunmstr_AudioClientHandler->vSetSrcActivity_ServiceUnavail(TUNMSTR_SRCCHG_INVALID);
			break;
		}
		default:
		{
			if(TUNMSTR_TUNER_SOURCE_2)
			{
				ETG_TRACE_USR4(("vHandlePendingSrcChgReq, Tuner source; would be handelled in Tuner clinet handler"));
				break;
			}
			else
			{
				ETG_TRACE_USR4(("vHandlePendingSrcChgReq, Default case"));
				m_potunmstr_AudioClientHandler->vSetSrcReq_ServiceUnavail(TUNMSTR_SRCCHG_INVALID);
			 m_potunmstr_AudioClientHandler->vSetSrcActivity_ServiceUnavail(TUNMSTR_SRCCHG_INVALID);
			}
			break;
		}
	}
#endif
}// end of function
/*************************************************************************************
 *FUNCTION:    vHandleDABPresetHandlingMethodResult
 *
 *DESCRIPTION: This function handel CCA Message FID_DAB_S_ACTIVATE_PRESET_LIST_ELEM
 *
 *PARAMETER:    amt_tclServiceData *poMessage
 *
 *RETURNVALUE: tVoid
 ************************************************************************************/
tVoid tunmstr_DABClient_Handler::vHandleDABPresetHandlingMethodResult(amt_tclServiceData* poMessage)const
{
	if((poMessage == NULL )||(m_potunmstr_Preset_Handler ==NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_Preset_Handler != NULL );
		return;
	}
	
	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
		{
			m_potunmstr_Preset_Handler->vHandleDABpresetMethodResult(poMessage);
			break;
		}
		default:
		{
			break;
		}
	};// switch
}
/*************************************************************************************
 *FUNCTION:    vHandlePendingSrcChgReq_DAB
 *
 *DESCRIPTION: Returns DAB service Reg ID
 *
 *PARAMETER:    None
 *
 *RETURNVALUE: m_u16RegID
 ************************************************************************************/
tU16 tunmstr_DABClient_Handler::u16GetDABServiceRegID()const
{
	return m_u16RegID;
}
/*************************************************************************************
 *FUNCTION:    vHandle_s_AutoStore
 *
 *DESCRIPTION: This function handel CCA Message FID_DAB_S_GET_PRESET_LIST
 *
 *PARAMETER:    amt_tclServiceData *poMessage
 *
 *RETURNVALUE: None
 ************************************************************************************/
tVoid tunmstr_DABClient_Handler::vHandle_s_AutoStore(amt_tclServiceData* poMessage)const
{
    if((poMessage == NULL ) || (m_ptunmstr_AutoStoreHandler == NULL) || (m_potunmstr_MsgToHMI == NULL)
    		|| (m_potunmstr_MsgFromHMI == NULL))
	{
		ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vHandle_s_AutoStore, Null Pointer"));
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_ptunmstr_AutoStoreHandler != NULL );
        NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
        NORMAL_M_ASSERT( m_potunmstr_MsgFromHMI != NULL );
		return;
	}// if....
	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
		{
			midw_ext_dabtunerfi_tclMsgFID_DAB_S_AUTOSTOREMethodResult oResult;
			//create an object of  FID_DAB_S_AUTOSTORE
			vGetDataFromAmt(poMessage,oResult);
			tU8 u8Temp = (tU8)oResult.e8MethodResult.enType;
			if((tU8)TUNMSTR_SRCCHG_DAB_RES_OK == u8Temp)
			{
				ETG_TRACE_USR4(("vHandle_s_AutoStore, MethodResult success"));
				if(m_ptunmstr_AutoStoreHandler->m_blGetInitalAST_Request() == TRUE)
				{
					m_ptunmstr_AutoStoreHandler->vHandleResult_ForInitialAST();
					// If initail AST is active, cehck if furher AST request needs to be sent or not
				}
				else
				{
					m_ptunmstr_AutoStoreHandler->vHandleResult_ForNormalAST();
				}
			}
			else
			{
				ETG_TRACE_USR4(("vHandle_s_AutoStore, MethodResult FAIL!!!"));
				m_potunmstr_MsgFromHMI->vSendAST_MethodResult(TUNMSTR_SRCCHG_INVALID, TUNMSTR_SRCCHG_INVALID,AMT_C_U8_CCAMSG_OPCODE_ERROR);
			}
			break;
	}
	default:
	{
		break;
	}
	};// switch
}
/*************************************************************************************
 *FUNCTION:    vSendPresetListReq
 *
 *DESCRIPTION: This function handel CCA Message FID_DAB_S_GET_PRESET_LIST
 *
 *PARAMETER:    amt_tclServiceData *poMessage
 *
 *RETURNVALUE: None
 ************************************************************************************/
tVoid tunmstr_DABClient_Handler::vSendPresetListReq()
{
	if(m_u8ServiceAvailable_DAB == true)
	{

	midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart oMsgData;
	oMsgData.u8FirstElementID=0;
	oMsgData.u8NumberOfElements=0;
	if ( m_potunmstr_Preset_Handler == NULL)
	{
		return;
	}
	// As per discussion with DAB team, if we pack 1st element and no of elements as "0", entire Preset list will be sent
	m_potunmstr_Preset_Handler->Inc_m_u8StartUp_HMI_Update();
	vSendMessage( CCA_C_U16_APP_FC_DABTUNER,// Destination APP ID
			oMsgData,           // parameter&
			MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_PRESET_LIST, //FID
			AMT_C_U8_CCAMSG_OPCODE_GET,  // OpCode                           /* amt_tclServiceData* */
			0,
			m_u16RegID //Registration ID
	);
	/*m_potunmstr_Preset_Handler->Send_HMIUpdate_Flag();*/
	ETG_TRACE_USR4(("vSendPresetListReq-> request sent"));
	}
	else
	{
		ETG_TRACE_USR4(("vSendPresetListReq-> dAB service not available : request not sent"));
	}
}
/*************************************************************************************
 *FUNCTION:    vSend_s_Anno_Config
 *
 *DESCRIPTION: This function handel CCA Message MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_ANNO_CONFIG
 *
 *PARAMETER:    amt_tclServiceData *poMessage
 *
 *RETURNVALUE: None
 ************************************************************************************/
tVoid tunmstr_DABClient_Handler::vSend_s_Anno_Config(tU16 u16Type)
{
	midw_ext_dabtunerfi_tclMsgFID_DAB_S_ANNO_CONFIGMethodStart oMsgData;

	oMsgData.AnnoConfig.AnnoConfigTypes.u16Value = u16Type;
#ifdef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
	/*Bug 247574, If active announcement Id disabled (disabling anno button from HMI) then ask DAB tuner to cancel on-going announcement else do not cancel*/
	if(oAnnouncementControl.oGetActiveMidwAnnouncementId() & u16Type)
	{
		oMsgData.AnnoConfig.bEnable = true;
	}
	else
	{
		oMsgData.AnnoConfig.bEnable = false;
	}
#endif
	oMsgData.AnnoConfig.AnnoConfigSource.enType =(midw_ext_fi_tcl_e8_DAB_AnnouncementSource::tenType) TUNMSTR_DAB_ANNOSOURCE_CURRENT_SERVICE;

	vSendMessage( CCA_C_U16_APP_FC_DABTUNER,// Destination APP ID
			oMsgData,           // parameter&
			MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_ANNO_CONFIG, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0,
			m_u16RegID //Registration ID
	);
	ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vSend_s_Anno_Config,Type -> %d",u16Type));

}//end of Function

/*************************************************************************************
 *FUNCTION:    vHandleDABPresetListMethodResult
 *
 *DESCRIPTION: This function handel CCA Message FID_DAB_S_GET_PRESET_LIST
 *
 *PARAMETER:    amt_tclServiceData *poMessage
 *
 *RETURNVALUE: None
 ************************************************************************************/
tVoid tunmstr_DABClient_Handler::vHandleDABPresetListMethodResult(amt_tclServiceData* poMessage)const
{
	if((poMessage == NULL )||(m_potunmstr_Preset_Handler ==NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_Preset_Handler != NULL );
		return;
	}
	/*Don't handle the Method result, always method result is sending the frequency as 0*/
	//m_potunmstr_Preset_Handler->vHandleDABPresetListMethodResult(poMessage);
}
/*************************************************************************************
 *FUNCTION:    vHandleDABPresetListStatus
 *
 *DESCRIPTION: This function handel CCA Message FID_DAB_G_PRESET_LIST
 *
 *PARAMETER:    amt_tclServiceData *poMessage
 *
 *RETURNVALUE: None
 ************************************************************************************/
tVoid tunmstr_DABClient_Handler::vHandleDABPresetListStatus(amt_tclServiceData* poMessage)const
{
	if((poMessage == NULL )||(m_potunmstr_Preset_Handler ==NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_Preset_Handler != NULL );
		return;
	}
	
	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_STATUS:
		{
			m_potunmstr_Preset_Handler->vHandleDABPresetListStatus(poMessage);
			break;
		}
		default:
		{
			break;
		}
	};// switch
}
/*************************************************************************
 * FUNCTION:     vSetDABRegID()
 *
 * DESCRIPTION: Update the member variable m_u16RegID with regID on successful registration DAB service
 *
 * PARAMETER:    tU16 u16RegId
 *
 * RETURNVALUE:  void
 **************************************************************************/
tVoid tunmstr_DABClient_Handler::vSetDABRegID(tU16 u16RegID)
{
	ETG_TRACE_USR4(("vSetDABRegID()->m_u16RegID=%d",m_u16RegID));
	m_u16RegID=u16RegID;
}
/*************************************************************************
 * FUNCTION:     vHandlePendingDABTAReqFromARL()
 *
 * DESCRIPTION: Fucntion to handle DAB TA request from ARL when DAB service is not yet availabel
 *
 * PARAMETER:    u8Action
 *
 * RETURNVALUE:  void
 **************************************************************************/
tVoid tunmstr_DABClient_Handler::vHandlePendingDABTAReqFromARL(tU8 u8Action)
{
	if((NULL==m_potunmstr_SrcChgManager)
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
		||(NULL==m_potunmstr_AudioClientHandler)
#endif
		)
	{
		return;
	}
	ETG_TRACE_USR4(("vHandlePendingDABTAReqFromARL()->Action=%02x",
	ETG_CENUM(enSourcendAction,u8Action)));
	switch(u8Action)
	{
		case TUNMSTR_SRCCHG_ACTION_ON:
		{
			m_potunmstr_SrcChgManager->vHandleAnnoSrc_ON((tU8)TUNMSTR_SRCCHG_SOURCE_DAB_TA);
			break;
		}
		case TUNMSTR_SRCCHG_ACTION_PAUSE:
		{
			m_potunmstr_SrcChgManager->vHandleAnnoSrc_PAUSE((tU8)TUNMSTR_SRCCHG_SOURCE_DAB_TA);
			break;
		}
		case TUNMSTR_SRCCHG_ACTION_OFF:
		{
			m_potunmstr_SrcChgManager->vHandleAnnoSrc_OFF((tU8)TUNMSTR_SRCCHG_SOURCE_DAB_TA);
			break;
		}
		default:
		{
			ETG_TRACE_USR4(("vHandlePendingDABTAReqFromARL, Entered into Default case"));
			break;
		}// end of Switch
	}
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	m_potunmstr_AudioClientHandler->vSetSrcReq_ServiceUnavail(TUNMSTR_SRCCHG_INVALID);
	m_potunmstr_AudioClientHandler->vSetSrcActivity_ServiceUnavail(TUNMSTR_SRCCHG_INVALID);
#endif

}
/*************************************************************************
 * FUNCTION:     vHandleAnnoInfo()
 *
 * DESCRIPTION: This function will check active Anno types based on priority and forward this infomation to Announcement handler class.
 *
 * PARAMETER:    tU8 u8Length
 *
 * RETURNVALUE:  void
 **************************************************************************/
tVoid tunmstr_DABClient_Handler::vHandleAnnoInfo(tU8 u8Length)
{
	if((m_potunmstr_SrcChg_AnnoHandler == NULL) ||(NULL==m_potunmaster_Config))
	{
		NORMAL_M_ASSERT( m_potunmstr_SrcChg_AnnoHandler != NULL );
		NORMAL_M_ASSERT(m_potunmaster_Config!= NULL );
		ETG_TRACE_USR4((" tunmstr_DABClient_Handler::vHandleAnnoInfo ---> NULL Pointer"));
		return;
	}

	tU16  u16CurrentAnnoPrio = m_potunmaster_Config->u16GetAnnoPrio(m_potunmstr_SrcChg_AnnoHandler->m_ActiveAnnoSrc);
	tU16  u16AnnoTypeFinalPrio = 0xFFFF;
	tU8   u8TempState = 0xFF;
	tU16  u16AnnoTypeFinal = 0xFFFF;
	tBool blAnno_State = FALSE;

	for (tU8 u8Index = 0; u8Index<u8Length; u8Index++)
	{
		tU16 u16TempAnnoType = m_eAnnoElement.AnnoStatus.AnnouncementList[u8Index].u16AnnoType;
		tU16 u16TempAnnoType_prio = m_potunmaster_Config->u16GetAnnoPrio(u16TempAnnoType);

		if(u16TempAnnoType_prio < u16AnnoTypeFinalPrio)
		{
			u16AnnoTypeFinalPrio = u16TempAnnoType_prio;
			u16AnnoTypeFinal = u16TempAnnoType;
			u8TempState = (tU8)m_eAnnoElement.AnnoStatus.AnnouncementList[u8Index].AnnoState.enType;
		}
	}
	ETG_TRACE_USR4((" tunmstr_DABClient_Handler::vHandleAnnoInfo(), Active announcement : %d ",(tU16)m_potunmstr_SrcChg_AnnoHandler->m_ActiveAnnoSrc));
	ETG_TRACE_USR4((" tunmstr_DABClient_Handler::vHandleAnnoInfo(), Anno State : %d, Anno Type : %d ",u8TempState ,u16AnnoTypeFinal));

	if(u8TempState == TUNMSTR_ANNOELEM_STATE_START)
	{
		if((m_potunmstr_SrcChg_AnnoHandler->m_ActiveAnnoSrc == TunMstr_AnnoActive_None) || (u16AnnoTypeFinalPrio < u16CurrentAnnoPrio))
		{
			blAnno_State = TRUE;
			m_potunmstr_SrcChg_AnnoHandler->vHandle_AnnoMSG(u16AnnoTypeFinal,TUNMSTR_SRCCHG_SOURCE_DAB,blAnno_State);
		}
		else
		{
			ETG_TRACE_USR4((" tunmstr_DABClient_Handler::vHandleAnnoInfo(), ignore request"));
		}
	}// if Anno state is Anno start, send request to start announcment
	else if(((u8TempState == TUNMSTR_ANNOELEM_STATE_END) || (u8TempState == TUNMSTR_ANNOELEM_STATE_ESCAPED))
				&& (m_potunmstr_SrcChg_AnnoHandler->m_ActiveAnnoSrc == u16AnnoTypeFinal))
	{
		m_potunmstr_SrcChg_AnnoHandler->vHandle_AnnoMSG(u16AnnoTypeFinal,TUNMSTR_SRCCHG_SOURCE_DAB,blAnno_State);
		ETG_TRACE_USR4((" tunmstr_DABClient_Handler::vHandleAnnoInfo() --->End Anno"));
	}// if Anno state is Anno End, send request to END announcment
	else
	{
		ETG_TRACE_USR4((" tunmstr_DABClient_Handler::vHandleAnnoInfo_MultipleElem() ---> ignore the anno request"));
	}
}


/*************************************************************************
 * FUNCTION:     u8ConvertDABAnnoTyp_TunMstrAnnoTyp()
 *
 * DESCRIPTION: This function will check active Anno types based on priority and forward this infomation to Announcement handler class.
 *
 * PARAMETER:    tU8 u8Anno_Sel_Type,tU8 u8AnnoSelectState,tU8 u8Length
 *
 * RETURNVALUE:  void
 **************************************************************************/
tU8 tunmstr_DABClient_Handler:: u8ConvertDABAnnoTyp_TunMstrAnnoTyp(tU16 u16Type)const
{
	tU8 u8AnnoType =0;
	switch (u16Type)
	{
	case TUNMSTR_ANNO_DAB_ANNOTYPE_ALARM:
	{
		u8AnnoType = (tU8)TUNMSTR_SRCCHG_ANNOTYPES_PTY31;
	}break;
	case TUNMSTR_ANNO_DAB_ANNOTYPE_TA:
	{
		u8AnnoType = (tU8)TUNMSTR_SRCCHG_ANNOTYPE_TA;
	}break;
	default:
	{
		u8AnnoType = (tU8)TUNMSTR_SRCCHG_ANNOTYPE_OTHER;
	}break;
	};//end of switch

	return u8AnnoType;
}// end of function
/*************************************************************************
 * FUNCTION:     u8ConvertTunMstrAnnoTyp_DABAnnoTyp()
 *
 * DESCRIPTION: This function will check active Anno types based on priority and forward this infomation to Announcement handler class.
 *
 * PARAMETER:    tU8 u8Anno_Sel_Type,tU8 u8AnnoSelectState,tU8 u8Length
 *
 * RETURNVALUE:  void
 **************************************************************************/
tU16 tunmstr_DABClient_Handler:: u8ConvertTunMstrAnnoTyp_DABAnnoTyp(tU8 u8Type)const
{
	tU16 u16AnnoType =0;
	switch (u8Type)
	{
	case TUNMSTR_SRCCHG_ANNOTYPES_PTY31:
	{
		u16AnnoType = TUNMSTR_ANNO_DAB_ANNOTYPE_ALARM;
	}break;
	case TUNMSTR_SRCCHG_ANNOTYPE_TA:
	{
		u16AnnoType = TUNMSTR_ANNO_DAB_ANNOTYPE_TA ;
	}break;
	case TUNMSTR_SRCCHG_ANNOTYPE_OTHER:
	{
		u16AnnoType =  TUNMSTR_ANNO_DAB_ANNOTYPE_OTHER ;
	}break;
	default:
		break;
	};//end of switch

	return u16AnnoType;
}// end of function

/*************************************************************************
 * FUNCTION:     vSend_s_SlectAnno()
 *
 * DESCRIPTION: This function will check active Anno types based on priority and forward this infomation to Announcement handler class.
 *
 * PARAMETER:    tU8 u8Anno_Sel_Type,tU8 u8AnnoSelectState,tU8 u8Length
 *
 * RETURNVALUE:  void
 **************************************************************************/
tVoid tunmstr_DABClient_Handler::vSend_s_SlectAnno(tU16 u16Type, tBool blStatus)
{
	if(m_poclConfigInterface == NULL) {
		return;
	}
	midw_ext_dabtunerfi_tclMsgFID_DAB_S_SELECT_ANNOMethodStart oMsgData;

	oMsgData.bSelect = blStatus;
	oMsgData.u16AnnoNumber = u16Type;
	
	/*For DAB, only for selection of TA, select_s_anno method has to be sent
	* For cancellation of DAB-TA, it is not required. Hence, simulate cancellation message */
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	if(blStatus == false)
	{
		if(!(m_poclConfigInterface->u32GetConfigData("SBR")))
		{
			oAnnouncementControl.vOnNewTunerState(tuner::common::TUNERSTATE_UNKNOWN);
			m_poSessionControl->vOnNewTunerBand(midw_fi_tcl_e8_Tun_TunerBand::FI_EN_TUN_BAND_INVALID);
			m_poSessionControl->vOnNewTunerState(midw_ext_fi_tcl_e8_DAB_SourceState::FI_EN_DAB_FOREGROUND);
			return;
		}
	}
#endif
	vSendMessage( CCA_C_U16_APP_FC_DABTUNER,// Destination APP ID
			oMsgData,           // parameter&
			MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SELECT_ANNO, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0,
			m_u16RegID //Registration ID
	);

	ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vSend_s_Anno_Config, Message Sent"
			"Status -> %d  Type -> %d",
			blStatus , u16Type));


}


/*************************************************************************
 * FUNCTION:     vSend_s_StopAnno()
 *
 * DESCRIPTION: This function will send stop announcement methd start to Dab tuner.
 *
 * PARAMETER:    tVoid
 *
 * RETURNVALUE:  void
 **************************************************************************/
tVoid tunmstr_DABClient_Handler::vSend_s_StopAnno()
{
	midw_ext_dabtunerfi_tclMsgFID_DAB_S_STOP_ANNOMethodStart oMsgData;

	vSendMessage( CCA_C_U16_APP_FC_DABTUNER,// Destination APP ID
			oMsgData,           // parameter&
			MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_STOP_ANNO, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0,
			m_u16RegID //Registration ID
	);

	ETG_TRACE_USR4(("tunmstr_DABClient_Handler::FID_DAB_S_STOP_ANNO, Message Sent"));


}
/*************************************************************************
 * FUNCTION:     blGetFmServiceFollowActive()
 *
 * DESCRIPTION: Returns FmServiceFollow Active/Inactive
 *
 * PARAMETER:    None
 *
 * RETURNVALUE:  tBool
 **************************************************************************/
tBool tunmstr_DABClient_Handler::blGetFmServiceFollowActive()
{
	ETG_TRACE_USR4(("tunmstr_DABClient_Handler::blGetFmServiceFollowActive, m_bFmServiceFollowActive : %d",
			m_bFmServiceFollowActive));

	return m_bFmServiceFollowActive;
}



/*************************************************************************
 *
 * FUNCTION:     tunmstr_DABClient_Handler::vHandleTTFiS_CMD( )
 *
 * DESCRIPTION:  Handler to handle TTFIs Commands
 *
 * PARAMETER:    tU8DataLength, const tU8*u8DataSpecial
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_DABClient_Handler::vHandleTTFiS_CMD(const tU8* u8DataSpecial)
{
	if(NULL==m_potunmstr_TunerClientHandler)
	{
		return;
	}
	tU8 u8FunctionID = u8DataSpecial[0];
	//CCA message Function ID
	tU8 u8length = 0;
	switch(u8FunctionID)
	{
	case 1:
	{
		midw_ext_dabtunerfi_tclMsgFID_DAB_G_ANNO_STATUSStatus oStatusMsg;
		u8length = u8DataSpecial[1];
		for(tU8 i=0 ; i<u8length ; i++)
		{
			oStatusMsg.AnnoStatus.AnnouncementList[i].u16AnnoType = u8DataSpecial[2];
			/*tU8 u8check = u8DataSpecial[1];
			oStatusMsg.e8AnnoMessage.enType = (midw_fi_tcl_e8_Anno_Message::tenType)u8check;*/
			tU8 u8check = u8DataSpecial[3];
			oStatusMsg.AnnoStatus.AnnouncementList[i].AnnoState.enType = (midw_ext_fi_tcl_e8_DAB_AnnouncementStatus::tenType)u8check;
		}
		m_potunmstr_TunerClientHandler->vSendMessage( CCA_C_U16_APP_TUNERMASTER,// Destination APP ID
				oStatusMsg,           // parameter&
				MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_ANNO_STATUS, //FID
				AMT_C_U8_CCAMSG_OPCODE_STATUS,  // OpCode                           /* amt_tclServiceData* */
				0);
		ETG_TRACE_USR4((" tunmstr_TunerClientHandler::vHandleTTFiS_CMD, MIDW_TUNERFI_C_U16_FID_TUN_G_SET_FEATURE sent"));


	}break;
	default:
	{
		break;
	}
	}
}

/*************************************************************************
 * FUNCTION:     vSet_MTC_Mode()
 *
 * DESCRIPTION: This function will send MTCSetMode command to DAB tuner.
 *
 * PARAMETER:    tU8 u8Mode
 *
 * RETURNVALUE:  void
 * AUTHOR: Vinay Nadagoud ECV2 17.12.2014
 **************************************************************************/
tVoid tunmstr_DABClient_Handler::vSet_MTC_Mode(tU8 u8Mode)
{
	midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodStart oMsgData;

	oMsgData.b8Mode.u8Value = u8Mode;

	vSendMessage( CCA_C_U16_APP_FC_DABTUNER,// Destination APP ID
			oMsgData,           // parameter&
			MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_MTC_SETMODE, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0,
			m_u16RegID //Registration ID
	);
	
	ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vSet_MTC_Mode, Message Sent "));


}


/*************************************************************************
 * FUNCTION:     vGet_MTC_Mode()
 *
 * DESCRIPTION: This function will send Get MTCMode switch status command to DAB tuner.
 *
 * PARAMETER:    tU8 u8Mode
 *
 * RETURNVALUE:  void
 * AUTHOR: Vinay Nadagoud ECV2 17.12.2014
 **************************************************************************/
tVoid tunmstr_DABClient_Handler::vGet_MTC_Mode()
{
	midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSGet oMsgData;

	
	vSendMessage( CCA_C_U16_APP_FC_DABTUNER,// Destination APP ID
			oMsgData,           // parameter&
			MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_MTC_SETMODE_STATUS, //FID
			AMT_C_U8_CCAMSG_OPCODE_GET,  // OpCode                           /* amt_tclServiceData* */
			0,
			m_u16RegID //Registration ID
	);

	ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vGet_MTC_Mode, Message Sent"));


}

/*************************************************************************************
 *FUNCTION:    vHandleDAB_MTCSetModeMethodResult
 *
 *DESCRIPTION: This function handel CCA Message FID_DAB_S_MTC_SETMODE
 *
 *PARAMETER:    amt_tclServiceData *poMessage
 *
 *RETURNVALUE: tVoid
 *AUTHOR: Vinay Nadagoud ECV2 17.12.2014
 ************************************************************************************/
tVoid tunmstr_DABClient_Handler::vHandleDAB_MTCSetModeMethodResult(amt_tclServiceData* poMessage)const
{
    if(poMessage == NULL)
	{
		ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vHandleDAB_MTCSetModeMethodResult, Null Pointer"));
		NORMAL_M_ASSERT( poMessage != NULL );
		return;
	}// if....
	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
		{
			midw_ext_dabtunerfi_tclMsgFID_DAB_S_MTC_SETMODEMethodResult oResult;
			//create an object of  FID_DAB_S_AUTOSTORE
			vGetDataFromAmt(poMessage,oResult);
			
			if(TUNMSTR_SRCCHG_DAB_RES_OK == (enTunmstrDAB_Methodresult)oResult.e8MethodResult.enType)
			{
				ETG_TRACE_USR4(("vHandleDAB_MTCSetModeMethodResult, MethodResult success"));
			}
			else
			{
				ETG_TRACE_USR4(("vHandleDAB_MTCSetModeMethodResult, MethodResult FAIL!!!"));
			}
			break;
		}
		default:
		{
		break;
		}
	};// switch
}


 /*************************************************************************************
 *FUNCTION:    vHandleDABMTCSetModeStatus
 *
 *DESCRIPTION: This function handel CCA Message FID_DAB_G_MTC_SETMODE_STATUS
 *
 *PARAMETER:    amt_tclServiceData *poMessage
 *
 *RETURNVALUE: None
 *AUTHOR: Vinay Nadagoud ECV2 17.12.2014
 ************************************************************************************/
tVoid tunmstr_DABClient_Handler::vHandleDAB_MTCSetModeStatus(amt_tclServiceData* poMessage) const
{
	if((poMessage == NULL )||(m_potunmstr_MsgToHMI ==NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		return;
	}

	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_STATUS:
		{

			midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SETMODE_STATUSStatus oStatusMsg;
			vGetDataFromAmt(poMessage,oStatusMsg);
			
			ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vHandleDABMTCSetModeStatus , Mode : %d",oStatusMsg.Mode.u8Value ));

			m_potunmstr_MsgToHMI->vSendMTC_SetMode_status(oStatusMsg.Mode.u8Value);
		}
		break;
	default:
		{
			ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vHandleDABMTCSetModeStatus , WRONG OPCODE"));
			break;
		}
	}//switch

}

 /*************************************************************************************
 *FUNCTION:    vHandleDAB_MTC_Surveillance_Monitor
 *
 *DESCRIPTION: This function handel CCA Message FID_DAB_G_MTC_SURVEILLANCE_MONITOR
 *
 *PARAMETER:    amt_tclServiceData *poMessage
 *
 *RETURNVALUE: None
 *AUTHOR: Vinay Nadagoud ECV2 17.12.2014
 ************************************************************************************/
tVoid tunmstr_DABClient_Handler::vHandleDAB_MTC_Surveillance_Monitor(amt_tclServiceData* poMessage)
{
	if((poMessage == NULL )||(m_potunmstr_MsgToHMI ==NULL))
	{
		NORMAL_M_ASSERT( poMessage != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		return;
	}

	switch (poMessage->u8GetOpCode())
	{
	case AMT_C_U8_CCAMSG_OPCODE_STATUS:
		{

			midw_ext_dabtunerfi_tclMsgFID_DAB_G_MTC_SURVEILLANCE_MONITORStatus oStatusMsg;
			vGetDataFromAmt(poMessage,oStatusMsg);
			
			oMTCSurveilanceStatus.StationType.enType = (midw_fi_tcl_e8_StationType::tenType)oStatusMsg.StationType.enType;
			oMTCSurveilanceStatus.Frequency = oStatusMsg.StationFrequency;
			oMTCSurveilanceStatus.Station_ID = oStatusMsg.StationId;

			if(oMTCSurveilanceStatus.StationType.enType == (midw_fi_tcl_e8_StationType::tenType)TUNMSTR_MTC_SURVEIL_STATIONTYPE_FM)
			{
				oMTCSurveilanceStatus.StationNameFM = oStatusMsg.StationNameFM.szGet(midw_ext_fi_tclString::FI_EN_UTF8);
			}
			else
			{

			}

			ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vHandleDAB_MTC_Surveillance_Monitor , \n\
							StationType : %d\n\
							Frequency	: %d\n\
							Station_ID  : %8x\n\
							StationName : %s\n"\
							,oMTCSurveilanceStatus.StationType.enType
							,oMTCSurveilanceStatus.Frequency
							,oMTCSurveilanceStatus.Station_ID
							,oMTCSurveilanceStatus.StationNameFM.szGet(midw_fi_tclString::FI_EN_UTF8)
							));

			m_potunmstr_MsgToHMI->vSendMTC_Surveilance_StationStatus(oMTCSurveilanceStatus);
		}
		break;
	default:
		{
			ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vHandleDAB_MTC_Surveillance_Monitor , WRONG OPCODE"));
			break;
		}
	}//switch

}
/****************************************************

****************************************************/
tVoid tunmstr_DABClient_Handler::vHandle_s_UnUsedMessages()
{
	// Do Nothing
}




/*************************************************************************
 * FUNCTION:     vGet_Surveillance_Mode_Status()
 *
 * DESCRIPTION: This function will send Get MTCMode switch status command to DAB tuner.
 *
 * PARAMETER:
 *
 * RETURNVALUE:  void
 **************************************************************************/
tVoid tunmstr_DABClient_Handler::vGet_Surveillance_Mode_Status()
{
	if(m_potunmstr_MsgToHMI ==NULL)
	{
		NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
		return;
	}
   m_potunmstr_MsgToHMI->vSendMTC_Surveilance_StationStatus(oMTCSurveilanceStatus);
}

/*************************************************************************
* FUNCTION:    vSet_tunmstr_ConfigInterface_Ptr
*
* DESCRIPTION: 
*
* PARAMETER:   clConfigInterface* poclConfigInterface
*
* RETURNVALUE:  void
*************************************************************************/
tVoid tunmstr_DABClient_Handler::vSet_tunmstr_ConfigInterface_Ptr
(clConfigInterface* poclConfigInterface)
{
	if( poclConfigInterface != NULL )
	{
		m_poclConfigInterface = poclConfigInterface;
	}

}

/*************************************************************************
 *
 * FUNCTION:     tunmstr_DABClient_Handler::u8GetPresetAutoCompare()
 *
 * DESCRIPTION:  Return preset autocompare
 * PARAMETER:
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tBool tunmstr_DABClient_Handler::u8GetPresetAutoCompare()
{

	ETG_TRACE_USR4(("u8GetPresetAutoCompare : %d",m_u8PresetAutocompare));

	return m_u8PresetAutocompare;

}


/*************************************************************************
 * FUNCTION:     vHandleProfileUpdate()
 *
 * DESCRIPTION:	 Returns band
 *
 * PARAMETER:
 * Param 1 UserID that need to be sent to ADR
 * Param 2 Action (Load profile, copy  and delete)
 * Param 3 for destination needs to be added
 *
 * RETURNVALUE:  Void
 **************************************************************************/

#ifdef INCLUDE_PROFILE_MANAGER
	tVoid tunmstr_DABClient_Handler::vHandleProfileUpdate(tU8 u8UserID ,tU8 u8UserIDDest , tU8 u8Action ){
#else
tVoid tunmstr_DABClient_Handler::vHandleProfileUpdate(tU8 u8UserID ,tU8 /*u8UserIDDest*/ , tU8 u8Action ){
#endif
		//midw_tunerfi_tclMsgFID_TUN_S_USER_PROFILE_UPDATEMethodStart oMsgData;
		midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodStart oMsgData;
		oMsgData.UserID = u8UserID;
		switch(u8Action)
		{
#ifdef INCLUDE_PROFILE_MANAGER
			case (tU8)en_ActionChangeProfile:
			{
		oMsgData.Action.enType = midw_ext_fi_tcl_e8_DAB_UserProfileAction::FI_EN_DAB_PROFILE_CHANGE;
				ETG_TRACE_USR4((" tunmstr_DABClient_Handler::vHandleProfileUpdate, CHANGE Message"));
				break;
			}
			case (tU8)en_ActionCopy:
			{
				oMsgData.Action.enType = midw_ext_fi_tcl_e8_DAB_UserProfileAction::FI_EN_DAB_PROFILE_COPY;
				oMsgData.DestinationUserID =u8UserIDDest;
				ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vHandleProfileUpdate, COPY  Message"));
				break;
			}
			case (tU8)en_ActionDelete:
			{
				oMsgData.Action.enType = midw_ext_fi_tcl_e8_DAB_UserProfileAction::FI_EN_DAB_PROFILE_DELETE;
				ETG_TRACE_USR4(("tunmstr_DABClient_Handler::vHandleProfileUpdate, DELETE Message"));
				break;
			}
#endif
			default:
			{
				break;
			}
      }
		vSendMessage( CCA_C_U16_APP_FC_DABTUNER,// Destination APP ID
			oMsgData,           // parameter&
			MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_USER_PROFILE_UPDATE, //FID
			AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
			0,
			m_u16RegID );

}

#ifdef INCLUDE_PROFILE_MANAGER

/*************************************************************************
 * FUNCTION:     vSendDABListonlinePersonalization()
 *
 * DESCRIPTION:	 Message to send MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SAVE_PRESET_LIST to configure presets sent by profile Manager
 *
 * PARAMETER: 	midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart
 *
 * RETURNVALUE:  Void
 **************************************************************************/

tVoid tunmstr_DABClient_Handler::vSendDABListonlinePersonalization(midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart& DABList)
{

	ETG_TRACE_USR4((" vSendDABListonlinePersonalization,Request "));

	for (std::vector<midw_ext_fi_tcl_DAB_PresetListElement>::iterator it = DABList.PresetList.begin(); it != DABList.PresetList.end() ; it++ )
	{
		ETG_TRACE_USR4(( "vSendDABListonlinePersonalization u8PresetElementID  =%d ",it->u8PresetElementID));
		ETG_TRACE_USR4(( "vSendDABListonlinePersonalization ServiceLabel  =%s ",it->ServiceLabel.sLabel.szValue));
		ETG_TRACE_USR4(( "vSendDABListonlinePersonalization Sid  =%d ",it->u32Frequency));
	}


	vSendMessage( CCA_C_U16_APP_FC_DABTUNER,// Destination APP ID
		DABList,           // parameter&
		MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SAVE_PRESET_LIST, //FID
		AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
		0,
		m_u16RegID );


}

tVoid tunmstr_DABClient_Handler::vHandle_s_UserProfileUpdateResult(amt_tclServiceData* poMessage)
{
	if(NULL==poMessage)
	{
		return;
	}
	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
		{
			midw_ext_dabtunerfi_tclMsgFID_DAB_S_USER_PROFILE_UPDATEMethodResult oMsg;
			vGetDataFromAmt(poMessage,oMsg);

			tU8 u8Status = (tU8)oMsg.e8MethodResult.enType;
				if(0 == (tU8)oMsg.e8MethodResult.enType)
					u8Status = TUNMSTR_PROFILE_USER_ACTION_SUCESS;
				else
					u8Status = TUNMSTR_PROFILE_USER_ACTION_FAIL;
				switch(oMsg.Action.enType)
			{
					case midw_ext_fi_tcl_e8_DAB_UserProfileAction::FI_EN_DAB_PROFILE_CHANGE:
					{
						m_ptunmaster_PMClient->vHandleOnDataChanged((tU8)u8Status );
						ETG_TRACE_USR4((" tunmstr_DABClient_Handler::vHandleProfileUpdate, CHANGE Response"));
						break;
			}
					case midw_ext_fi_tcl_e8_DAB_UserProfileAction::FI_EN_DAB_PROFILE_COPY:
					{
						m_ptunmaster_PMClient->vHandleOnProfileCopied((tU8)u8Status );
						ETG_TRACE_USR4((" tunmstr_DABClient_Handler::vHandleProfileUpdate, COPY Response"));
						break;
					}

					case  midw_ext_fi_tcl_e8_DAB_UserProfileAction::FI_EN_DAB_PROFILE_DELETE:
			{
						m_ptunmaster_PMClient->vHandleOnProfileDeleted((tU8)u8Status );
						ETG_TRACE_USR4((" tunmstr_DABClient_Handler::vHandleProfileUpdate, DELETE Response"));
						break;
			}
					default:
					{
			break;
					}
				}
				break;
		}
		default:
		{
			break;
		}
	}
}

/*************************************************************************
 * FUNCTION:     vHandle_S_FID_DAB_S_SAVE_PRESET_LIST_MethodeResult()
 *
 * DESCRIPTION:	 vHandle for Result MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_S_SAVE_PRESET_LIST
 *
 * PARAMETER: amt_tclServiceData data
 *
 * RETURNVALUE:  Void
 **************************************************************************/
tVoid tunmstr_DABClient_Handler::vHandle_S_FID_DAB_S_SAVE_PRESET_LIST_MethodeResult(amt_tclServiceData* poMessage)
{

	if((NULL==poMessage) ||  (NULL== m_ptunmaster_PMClient))
	{
		ETG_TRACE_USR4((" tunmstr_DABClient_Handler::vHandle_S_FID_DAB_S_SAVE_PRESET_LIST_MethodeResult, Error"));
		return;
	}
	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
		{
			midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodResult oMsg;
			fi_tclVisitorMessage oInVisitorMsg(poMessage);
			if(OSAL_ERROR == oInVisitorMsg.s32GetData(oMsg,1))
			{
				NORMAL_M_ASSERT_ALWAYS ();
			}
			midw_fi_tcl_TunMstr_RadioSetting_StatusResponse TunerMasterResponse;
			TunerMasterResponse.RadioProfileSetting_Response.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_SUCCEED;
			TunerMasterResponse.RadioProfileSetting_ErrorCode.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_NONE;

			if(0 != (tU8)oMsg.e8MethodResult.enType)
			{
				TunerMasterResponse.RadioProfileSetting_Response.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_FAILED_FOR_DAB;
				TunerMasterResponse.RadioProfileSetting_ErrorCode.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_UNKNOWN;
				// only required to call the below fuction if we dont get presetlist incase of failure.
				if(m_ptunmaster_PMClient->bGetKeepOtherPreset())
				{
					midw_ext_dabtunerfi_tclMsgFID_DAB_S_GET_PRESET_LISTMethodStart oMsgData;
					oMsgData.u8FirstElementID=0;
					oMsgData.u8NumberOfElements=0;
					// As per discussion with DAB team, if we pack 1st element and no of elements as "0", entire Preset list will be sent
					vSendMessage( CCA_C_U16_APP_FC_DABTUNER,// Destination APP ID
							oMsgData,           // parameter&
							MIDW_EXT_DABTUNERFI_C_U16_FID_DAB_G_PRESET_LIST, //FID
							AMT_C_U8_CCAMSG_OPCODE_GET,  // OpCode                           /* amt_tclServiceData* */
							0,
							m_u16RegID //Registration ID
					);
				}
			}

			m_ptunmaster_PMClient->vSendResponseToRadioSetting(TunerMasterResponse);

			break;
		}
		default:
		{
			break;
		}
	}

}

/*************************************************************************
 *
 * FUNCTION:    vSet_PMClient_Handler_Ptr(tunermaster_PMClient* po_PMClient_Handler)
 *
 * DESCRIPTION: Set pointer to pointer tunermaster_PMClient
 *
 * PARAMETER:   tunermaster_PMClient* po_PMClient_Handler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunmstr_DABClient_Handler::vSet_PMClient_Handler_Ptr(tunermaster_PMClient* po_PMClient_Handler)
{
	if( NULL != po_PMClient_Handler  )
	{
		 m_ptunmaster_PMClient = ( tunermaster_PMClient* )po_PMClient_Handler;
	}
}
#endif
