/************************************************************************
 * FILE:           tunmstr_AudioClientHandler.cpp
 * PROJECT:        G3g
 * SW-COMPONENT:   fc_tunermaster.
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:    To send CCA messages to fc_audio
 *
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      		| Author                        | Modification
 * 8/04/2011		| Pallavi HN (CM-AI/PJ-VW36)    | initial version
* 25.04.13  		| NGP1KOR    					| First version of the G3g after porting from NISSAN LCN2Kai 
				
 *************************************************************************/
//-----------------
// System includes
//-----------------


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#include "ahl_mock/ahl_if.h"
#include "amt_mock/amt_if.h"
#else
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif


#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" 


//Added by Karsten Geier

#include "fc_tunermaster_featureControl.h"

/*----------------------------------------------------------------------*/

#include "tunmstr_TunerClientHandler.h"
#include "tunermaster_main.h"

#include "tunmstr_AudioClientHandler.h"
#include "tunmstr_SrcChgManager.h"
#include "tunmstr_SrcChg_Trace.h"
#include "tunmstr_SrcChg_Defines.h"
#include "tunmstr_DABClient_Handler.h"
#include "tunmstr_SrcChg_AnnoHandler.h"
#include "tunmstr_MuteHandler.h"
#include "tunermaster_Config.h"
#include "tunermaster_PrjConfig.h"
#include "tunermaster_defines.h"
#include "kdsconfig/clConfigInterface.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNMSTR_TRACE_CLASS_SRCCHG
#include "trcGenProj/Header/tunmstr_AudioClientHandler.cpp.trc.h"
#endif

#define TUNER_SOURCE (ARL_SRC_FM==enSrcNum || \
        ARL_SRC_AM == enSrcNum || ARL_SRC_DRM == enSrcNum)
#define DAB_MUTE_SOURCE (ARL_SRC_DAB == enSrcNum || \
		ARL_SRC_DABTA == enSrcNum)


/*************************************************************************
 *
 * FUNCTION:     tunmstr_AudioClientHandler::tunmstr_AudioClientHandler( )
 *
 * DESCRIPTION:  Constructor
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tunmstr_AudioClientHandler::tunmstr_AudioClientHandler( tunmaster_tclApp* potunerMainApp  ):
arl_tclISource_AIL((ail_tclAppInterface*) potunerMainApp),
poGWMain( NULL ),\
m_potunmstr_SrcChgManager(NULL),\
m_potunmstr_DABClient_Handler(NULL),\
m_potunmstr_TunerClient_Handler(NULL),\
m_potunmstr_tunmaster_tclApp(NULL),\
m_potunmstr_Preset_Handler(NULL),\
m_potunmaster_Config(NULL),\
m_poclConfigInterface(NULL),\
m_u8SrcReq_ServiceUnavail (TUNMSTR_SRCCHG_INVALID),\
m_u8SrcActivity_ServiceUnavail (TUNMSTR_SRCCHG_INVALID)
{
	m_ostMuteRequest.enMuteState=ARL_EN_MUTEACTION_MUTE;
	m_ostMuteRequest.enSrcNum=ARL_SRC_NONE;
	m_ostMuteRequest.enmuteReason=ARL_EN_MUTE_REASON_OTHER;
	m_potunmstr_SrcChg_AnnoHandler=NULL;
	m_potunmstr_MuteHandler = NULL;
	m_blEnableDRMSource=FALSE;
	poGWMain = potunerMainApp;
}//End of constructor


/*************************************************************************
 *
 * FUNCTION:     tunmstr_AudioClientHandler::~tunmstr_AudioClientHandler( )
 *
 * DESCRIPTION:  Destructor
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tunmstr_AudioClientHandler::~tunmstr_AudioClientHandler( )
{

	m_potunmstr_SrcChgManager = NULL;
	m_potunmstr_DABClient_Handler = NULL;
	m_potunmstr_TunerClient_Handler = NULL;
	m_potunmstr_tunmaster_tclApp=NULL;
	m_potunmstr_Preset_Handler=NULL;
	m_potunmaster_Config=NULL;
	m_u8SrcReq_ServiceUnavail  = TUNMSTR_SRCCHG_INVALID;
	m_u8SrcActivity_ServiceUnavail = TUNMSTR_SRCCHG_INVALID;
	m_ostMuteRequest.enMuteState=ARL_EN_MUTEACTION_MUTE;
	m_ostMuteRequest.enSrcNum=ARL_SRC_NONE;
	m_ostMuteRequest.enmuteReason=ARL_EN_MUTE_REASON_OTHER;
	m_potunmstr_SrcChg_AnnoHandler=NULL;
	m_potunmstr_MuteHandler = NULL;
	m_poclConfigInterface = NULL;
	poGWMain = NULL;
	m_blEnableDRMSource=FALSE;
}//End of Destructor
/*************************************************************************
 *
 * FUNCTION:     tunmstr_AudioClientHandler::vSet_tunmstr_SrcChgManager_Ptr( )
 *
 * DESCRIPTION:  Set pointer to pointer tunmstr_SrcChgManager*
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_AudioClientHandler::vSet_tunmstr_SrcChgManager_Ptr(tunmstr_SrcChgManager* potunmstr_SrcChgManager)

{
	if( potunmstr_SrcChgManager != NULL )
	{
		m_potunmstr_SrcChgManager = ( tunmstr_SrcChgManager* )potunmstr_SrcChgManager;
	}
}

/*************************************************************************
 *
 * FUNCTION:    vSet_tunmstr_AudioClientHandler_Ptr(tunmstr_AudioClientHandler* potunmstr_AudioClientHandler)
 *
 * DESCRIPTION: Set pointer to pointer tunmstr_AudioClientHandler
 *
 * PARAMETER:   tunmstr_AudioClientHandler* potunmstr_AudioClientHandler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunmstr_AudioClientHandler::vSet_tunmstr_DABClient_Handler_Ptr(tunmstr_DABClient_Handler* potunmstr_DABClient_Handler)
{
	if( potunmstr_DABClient_Handler != NULL )
	{
		m_potunmstr_DABClient_Handler = ( tunmstr_DABClient_Handler* )potunmstr_DABClient_Handler;
	}

}
/*************************************************************************
 *
 * FUNCTION:    vSet_tunmstr_AudioClientHandler_Ptr(tunmstr_AudioClientHandler* potunmstr_AudioClientHandler)
 *
 * DESCRIPTION: Set pointer to pointer tunmstr_AudioClientHandler
 *
 * PARAMETER:   tunmstr_AudioClientHandler* potunmstr_AudioClientHandler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunmstr_AudioClientHandler::vSet_tunmstr_TunerClient_Handler_Ptr(tunmstr_TunerClientHandler* potunmstr_TunerClient_Handler)
{
	if( potunmstr_TunerClient_Handler != NULL )
	{
		m_potunmstr_TunerClient_Handler = ( tunmstr_TunerClientHandler* )potunmstr_TunerClient_Handler;
	}

}
/*************************************************************************
 *
 * FUNCTION:    vSet_tunmaster_tclApp_Handler_Ptr(tunmaster_tclApp* potunmaster_tclApp)
 *
 * DESCRIPTION: Set pointer to pointer tunmaster_tclApp
 *
 * PARAMETER:   tunmaster_tclApp* potunmaster_tclApp
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_AudioClientHandler::vSet_tunmaster_tclApp_Handler_Ptr(tunmaster_tclApp* potunmaster_tclApp)
{
	if( potunmaster_tclApp != NULL )
	{
		m_potunmstr_tunmaster_tclApp = ( tunmaster_tclApp* )potunmaster_tclApp;
	}

}
/*************************************************************************
 * FUNCTION:     tunmstr_AudioClientHandler::vSet_tunmstr_tunmstr_Preset_Handler_Ptr( )
 *
 * DESCRIPTION:  tunmstr_Preset_Handler* potunmstr_Preset_Handler
 *
 * PARAMETER:    tunmstr_Preset_Handler* potunmstr_Preset_Handler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_AudioClientHandler::vSet_tunmstr_tunmstr_Preset_Handler_Ptr( tunmstr_Preset_Handler* potunmstr_Preset_Handler)
{
	if( potunmstr_Preset_Handler != NULL )
	{
		m_potunmstr_Preset_Handler = ( tunmstr_Preset_Handler* )potunmstr_Preset_Handler;
	}
	else
	{
		NORMAL_M_ASSERT ( m_potunmstr_Preset_Handler != NULL );
	}
}
/*************************************************************************
 *
 * FUNCTION: vSet_tunmaster_Config_Ptr( tunmaster_Config* potunmaster_Config )
 *
 * DESCRIPTION:  Set pointer to pointer tunmaster_Config
 *
 * PARAMETER:    tunmaster_Config* potunmaster_Config
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_AudioClientHandler::vSet_tunmaster_Config_Ptr(tunmaster_Config* potunmaster_Config)
{
	if( potunmaster_Config != NULL )
	{
		m_potunmaster_Config = ( tunmaster_Config* )potunmaster_Config;
	}
}


/*************************************************************************
* FUNCTION:    vSet_tunmstr_ConfigInterface_Ptr
*
* DESCRIPTION:
*
* PARAMETER:   clConfigInterface* poclConfigInterface
*
* RETURNVALUE:  void
*************************************************************************/
tVoid tunmstr_AudioClientHandler::vSet_tunmstr_ConfigInterface_Ptr
(clConfigInterface* poclConfigInterface)
{
	if( poclConfigInterface != NULL )
	{
		m_poclConfigInterface = poclConfigInterface;
	}

}


/*************************************************************************
 *
 * FUNCTION: bOnAllocate( arl_tenSource enSrcNum, const arl_tAllocRouteResult& rfcoAllocRoute )
 *
 * DESCRIPTION:  Allocate the DRM resource 
 *
 * PARAMETER:    arl_tenSource enSrcNum
 *               arl_tAllocRouteResult& rfcoAllocRoute
 *
 * RETURNVALUE:  tBool
 *
 *************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_DRM
tBool tunmstr_AudioClientHandler::bOnAllocate(arl_tenSource enSrcNum, const arl_tAllocRouteResult& rfcoAllocRoute)
#else
tBool tunmstr_AudioClientHandler::bOnAllocate(arl_tenSource enSrcNum, const arl_tAllocRouteResult& /*rfcoAllocRoute*/)
#endif
//this change in function is done only to solve prio2 warning
{
   ETG_TRACE_USR4(("tunmstr_AudioClientHandler::bOnAllocate enSrcNum-%d", enSrcNum));

#ifdef VARIANT_S_FTR_ENABLE_DRM
   if (enSrcNum == ARL_SRC_DRM)
   {
      if(m_blEnableDRMSource)
		{
			return true;
		}
		else
		{
			m_potunmstr_TunerClient_Handler->vSend_s_AudioDevice(rfcoAllocRoute.listOutputDev.strALSADev.back().szValue);
		}			
   }
   else
   {
        //can be handled later
   }
#endif
   return true;
}
/*************************************************************************
 *
 * FUNCTION:     bOnDeAllocate( arl_tenSource enSrcNum )
 *
 * DESCRIPTION:  Deallocate the DRM resource 
 *
 * PARAMETER:    arl_tenSource enSrcNum
 *
 * RETURNVALUE:  tBool
 *
 *************************************************************************/
tBool tunmstr_AudioClientHandler:: bOnDeAllocate(arl_tenSource enSrcNum)
{
    ETG_TRACE_USR4(("tunmstr_AudioClientHandler::bOnDeAllocate enSrcNum-%d", enSrcNum));
	return true;
}

/*******************************************************************************
 *FUNCTION:    tunmstr_AudioClientHandler::bOnSrcActivity
 *
 *DESCRIPTION:
 *
 *PARAMETER:
 *
 *
 *RETURNVALUE: None
 ********************************************************************************/
tBool tunmstr_AudioClientHandler::bOnSrcActivity( arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity )
{
	if(( m_potunmstr_DABClient_Handler == NULL ) || (m_potunmstr_TunerClient_Handler == NULL)||(m_potunmstr_tunmaster_tclApp==NULL))
	{
		ETG_TRACE_USR4(("tunmstr_AudioClientHandler::bOnSrcActivity, NULL Pointer"));
		return false;
	}
	ETG_TRACE_USR4(("tunmstr_AudioClientHandler::bOnSrcActivity,Source=%d Activity=%d ", enSrcNum, rfcoSrcActivity.enType));

	if(m_potunmstr_tunmaster_tclApp->u8GetStreamRoutreServiceState()==AMT_C_U8_SVCSTATE_NOT_AVAILABLE)
	{
		ETG_TRACE_USR4(("tunmstr_AudioClientHandler::bOnSrcActivity->Handle Stream rounter service Unavail"));
		vHandleSrcReq_ServiceUnavail(enSrcNum,rfcoSrcActivity);
	}
	tBool blIsSrvAva=blCheckForSrvAva(enSrcNum);
	if(!blIsSrvAva)
	{
		vHandleSrcReq_ServiceUnavail(enSrcNum,rfcoSrcActivity);
	}
	else
	{
		switch(enSrcNum)
		{
		case ARL_SRC_DAB:
		{
			vSrcActivity_DABSource(enSrcNum, rfcoSrcActivity );
			break;
		}
		case ARL_SRC_DABTA:
		case ARL_SRC_FMTA:
		{
			vSrcActivity_TASource(enSrcNum, rfcoSrcActivity );
			break;
		}
		case ARL_SRC_AM:
		case ARL_SRC_FM:
		{
			vSrcActivity_TunerSource(enSrcNum,rfcoSrcActivity);
			break;
		}
#ifdef VARIANT_S_FTR_ENABLE_DRM
		case ARL_SRC_DRM:
		{
			if(m_blEnableDRMSource)
			{
				vSourceActivityResult(enSrcNum, rfcoSrcActivity);
			}
			else
			{
				vSrcActivity_TunerSource(enSrcNum,rfcoSrcActivity);
			}			
			break;
		}
#endif
		default:
		{
			break;
		}
		}

		if((u8GetSrcReq_ServiceUnavail() != TUNMSTR_SRCCHG_INVALID) || (u8GetSrcActivity_ServiceUnavail() != TUNMSTR_SRCCHG_INVALID))
		{
			ETG_TRACE_USR4(("tunmstr_AudioClientHandler::bOnSrcActivity->clear stored source activity request"));
			vSetSrcReq_ServiceUnavail(TUNMSTR_SRCCHG_INVALID);
			vSetSrcActivity_ServiceUnavail(TUNMSTR_SRCCHG_INVALID);
		}
	}
	return TRUE;
}//end of function bOnSrcActivity(....)

/*******************************************************************************
 *FUNCTION:    tunmstr_AudioClientHandler::vSendResult_ToLib
 *
 *DESCRIPTION:
 *
 *PARAMETER:
 *
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunmstr_AudioClientHandler::vSendResult_ToLib(arl_tenSource enSrcNum , tU8 u8Action)
{
	if(NULL==m_potunmstr_MuteHandler)
	{
		return;
	}
	switch (u8Action)
	{
	case AUDIO_PLAY:
	{
		vSourceActivityResult(enSrcNum,ARL_EN_ISRC_ACT_ON );
		ETG_TRACE_USR4(("tunmstr_AudioClientHandler::vSendResult_ToLib,  ON sent"
				"Source =%d",
				enSrcNum));
		break;
	}
	case AUDIO_PAUSE:
	{
		vSourceActivityResult(enSrcNum,ARL_EN_ISRC_ACT_PAUSE );
		ETG_TRACE_USR4(("tunmstr_AudioClientHandler::vSendResult_ToLib,  PAUSE sent"
				"Source =%d",
				enSrcNum));
		break;
	}
	case AUDIO_STOP:
	{
		vSourceActivityResult(enSrcNum,ARL_EN_ISRC_ACT_OFF );
		ETG_TRACE_USR4(("tunmstr_AudioClientHandler::vSendResult_ToLib,  OFF sent"
				"Source =%d",
				enSrcNum));
		break;
	}
	default:
		ETG_TRACE_USR4(("tunmstr_AudioClientHandler::vSendResult_ToLib, Default case"));
		break;
	}; //end of switch

}// end of vSendResultOFF_toLIB
/*******************************************************************************
 *FUNCTION:    vSendSourceavailability
 *
 *DESCRIPTION: Interface can be used to set the Source availability
 *
 *PARAMETER:	srcAvailability,availabilityReason,enSource
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_AudioClientHandler::vSendSourceavailability
#ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
(arl_tenSource enSrcNum,arl_tenSrcAvailability enSrcAvail,arl_tenAvailabilityReason enAvailabilityReason)
#else
(arl_tenSource ,arl_tenSrcAvailability ,arl_tenAvailabilityReason )
#endif
{
  #ifndef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	tBool blRes=bSetSourceAvailability(enSrcAvail,enAvailabilityReason,enSrcNum);
	ETG_TRACE_USR1(("vSendSourceavailability()->Source =%d enSrcAvail =%d blRes=%d enAvailabilityReason=%d",
		enSrcNum,enSrcAvail,enAvailabilityReason,blRes));
#endif
}
/*******************************************************************************
 *FUNCTION:    tunmstr_AudioClientHandler::bOnSrcActivity
 *
 *DESCRIPTION: This function will map audio source defines to tunermaster source defines
 *
 *PARAMETER:arl_tenSource enSrcNum
 *
 *
 *RETURNVALUE: u8
 ********************************************************************************/
tU8 tunmstr_AudioClientHandler::u8MapAuidoSources(const arl_tenSource enSrcNum)const
{
	tU8 u8Source = 0xff;
	if(m_potunmstr_SrcChg_AnnoHandler == NULL)
	{
		ETG_TRACE_USR4(("tunmstr_SrcChgManager::u8MapAuidoSources, NULL Pointer"));
		return u8Source;
	}

	switch(enSrcNum)
	{
	case ARL_SRC_FM:
	{
		u8Source = (tU8)TUNMSTR_SRCCHG_SOURCE_TUN1FM;
	}break;
	case ARL_SRC_AM:
	{
		u8Source = (tU8)TUNMSTR_SRCCHG_SOURCE_TUN1AM;
	}break;
	case ARL_SRC_DRM:
	{
		u8Source = (tU8)TUNMSTR_SRCCHG_SOURCE_DRM;
    }break;
	case ARL_SRC_FMTA:
	{
		if(m_potunmstr_SrcChg_AnnoHandler->m_ActiveAnnoSrc == TunMstr_AnnoActive_FMTA)
		{
			u8Source = (tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA;
		}
		else if(m_potunmstr_SrcChg_AnnoHandler->m_ActiveAnnoSrc == TunMstr_AnnoActive_FMPTY)
		{
			u8Source = (tU8)TUNMSTR_SRCCHG_SOURCE_FMPTY31;
		}
		else
		{
			u8Source = (tU8)TUNMSTR_SRCCHG_SOURCE_FMTA_INVALID;
		}
	}break;
	case ARL_SRC_DAB:
	{
		u8Source = (tU8)TUNMSTR_SRCCHG_SOURCE_DAB;
	}break;
	case ARL_SRC_DABTA:
	{
		if(m_potunmstr_SrcChg_AnnoHandler->m_ActiveAnnoSrc == TunMstr_AnnoActive_DABTA)
		{
			u8Source = (tU8)TUNMSTR_SRCCHG_SOURCE_DAB_TA;
		}
		else if(m_potunmstr_SrcChg_AnnoHandler->m_ActiveAnnoSrc == TunMstr_AnnoActive_DABPTY)
		{
			u8Source = (tU8)TUNMSTR_SRCCHG_SOURCE_DABPTY31;
		}
		else if(m_potunmstr_SrcChg_AnnoHandler->m_ActiveAnnoSrc == TunMstr_AnnoActive_None)
		{
			u8Source = (tU8)TUNMSTR_SRCCHG_SOURCE_DABTA_INVALID;
		}
		else
		{
			u8Source = (tU8)TUNMSTR_SRCCHG_SOURCE_DABOTHER;
		}
	}break;
	default:
	{
		u8Source = (tU8)TUNMSTR_SRCCHG_SOURCE_NON_RADIO;
	}break;
	}//end of switch
	ETG_TRACE_USR4(("tunmstr_AudioClientHandler::u8MapAuidoSources"
			"AudioSource=%d TunermasterSoucre=%d",
			enSrcNum,u8Source ));
	return u8Source;
}// end of function

/*******************************************************************************
 *FUNCTION:    tunmstr_AudioClientHandler::u8MapTunmstrSources
 *
 *DESCRIPTION: This function will map audio source defines to tunermaster source defines
 *
 *PARAMETER:arl_tenSource enSrcNum
 *
 *
 *RETURNVALUE: u8
 ********************************************************************************/
arl_tenSource tunmstr_AudioClientHandler::u8MapTunmstrSources(const tU8 u8Source)const
{
	arl_tenSource enSrcNum = ARL_SRC_NONE;
	switch(u8Source)
	{
	case TUNMSTR_SRCCHG_SOURCE_TUN1FM:
	{
		enSrcNum = ARL_SRC_FM;
	}break;
	case TUNMSTR_SRCCHG_SOURCE_TUN1AM:
	{
		enSrcNum = ARL_SRC_AM;
	}break;
    case TUNMSTR_SRCCHG_SOURCE_DRM:
    {
        enSrcNum = ARL_SRC_DRM;
	}break;
	case TUNMSTR_SRCCHG_SOURCE_FM_TA:
	case TUNMSTR_SRCCHG_SOURCE_FMPTY31:
	{
		enSrcNum = ARL_SRC_FMTA;
	}break;
	case TUNMSTR_SRCCHG_SOURCE_DAB:
	{
		enSrcNum = ARL_SRC_DAB;
	}break;
	case TUNMSTR_SRCCHG_SOURCE_DAB_TA:
	case TUNMSTR_SRCCHG_SOURCE_DABPTY31:
	case TUNMSTR_SRCCHG_SOURCE_DABOTHER:
	{
		enSrcNum = ARL_SRC_DABTA;
	}break;
	default:
		break;
	}//end of switch
	ETG_TRACE_USR4(("tunmstr_SrcChgManager::u8MapTunmstrSources"
			"AudioSource=%d TunermasterSoucre=%d",
			enSrcNum,u8Source ));
	return enSrcNum;
}// end of function
/*******************************************************************************
 *FUNCTION:    tunmstr_AudioClientHandler::vHandleDABMuteState
 *
 *DESCRIPTION: This function will send a request for mute state to ARL
 *
 *PARAMETER:tBool blSource, tBool blState
 *
 *
 *RETURNVALUE: Void
 ********************************************************************************/
tVoid tunmstr_AudioClientHandler::vHandleDABMuteState(tBool blSource, tBool blState)
{

	ETG_TRACE_USR4(("tunmstr_SrcChgManager::vHandleDABMuteState, source : %d, State :%d",blSource,blState));
#ifdef MUTE_ACTIVE
	arl_tenSource enSrcNum = ARL_SRC_NONE;
	arl_tenMuteAction enMuteAction = ARL_EN_MUTEACTION_MUTE;
	arl_enMuteReason  enmuteReason = ARL_EN_MUTE_REASON_OTHER;

	// Initilaise the Variables
	if(blSource == TRUE)
	{
		enSrcNum = ARL_SRC_DABTA;
	}
	else
	{
		enSrcNum = ARL_SRC_DAB;
	}
	// Convert Source value
	if(blState == TRUE)
	{
		enMuteAction = ARL_EN_MUTEACTION_MUTE;
	}
	else
	{
		enMuteAction = ARL_EN_MUTEACTION_DEMUTE;
	}// Convert Mute State Value
	bSetMuteState(enSrcNum, enMuteAction, enmuteReason);
	// Send Mute request to ARL
	ETG_TRACE_USR4(("tunmstr_SrcChgManager::vHandleDABMuteState, Mute Request sent to ARL"
			"Source=%d MuteState=%d enSrcNum =%d enMuteState=%d",
			blSource,blState,enSrcNum,enMuteAction ));
#endif
}//end of function
/*******************************************************************************
 *FUNCTION:    tunmstr_AudioClientHandler::bOnMuteState
 *
 *DESCRIPTION: This is an overloaded function from ARL, if mute update is for DAB or DAB_TA source,
 *DESCRIPTION: this info is forwared to fc_dabtuner
 *
 *PARAMETER:arl_tenSource enSrcNum ,arl_tenMuteState enMuteState
 *
 *
 *RETURNVALUE: tBool
 ********************************************************************************/
tBool tunmstr_AudioClientHandler::bOnMuteState(arl_tenSource enSrcNum, arl_tenMuteState enMuteState)
{
	if(m_potunmstr_MuteHandler == NULL)
	{
		ETG_TRACE_USR4(("tunmstr_SrcChgManager::bOnMuteState, NULL Pointer"));
		return FALSE;
	}
	if (DAB_MUTE_SOURCE)
	{
		tBool blMuteState = blConvertMuteStates(enMuteState);
		tBool blSource = blConvertMuteSource(enSrcNum);
		m_potunmstr_MuteHandler->vSend_DABMuteState(blSource,blMuteState);
		return TRUE;
	}// check for DAB source
	else if(TUNER_SOURCE)
	{
		ETG_TRACE_USR4(("tunmstr_SrcChgManager::bOnMuteState, Tuner Source"));
		tBool blMuteState = blConvertMuteStates(enMuteState);
        m_potunmstr_MuteHandler->vSend_TunerMuteState(blMuteState);
		return TRUE;
	}// check for Tuner source
	else
	{
		ETG_TRACE_USR4(("tunmstr_SrcChgManager::bOnMuteState, invalid source"));
		return TRUE;
	}
}// end of function
/*******************************************************************************
 *FUNCTION:    tunmstr_AudioClientHandler::blConvertMuteStates
 *
 *DESCRIPTION: Convert Function
 *PARAMETER:arl_tenMuteState enMuteState
 *
 *
 *RETURNVALUE: tBool
 ********************************************************************************/
tBool tunmstr_AudioClientHandler::blConvertMuteStates(arl_tenMuteState enMuteState)const
{
	tBool blMuteState = FALSE;
	switch (enMuteState)
	{
    case ARL_EN_MUTESTATE_MUTE:
	{
		blMuteState = TUNMSTR_SRCCHG_MUTESTATUS_MUTE;
	}break;
    case ARL_EN_MUTESTATE_DEMUTE:
    case ARL_EN_MUTESTATE_DEMUTE_RUNNING:
	{
		blMuteState = TUNMSTR_SRCCHG_MUTESTATUS_DEMUTE;
	}break;
	default:
		blMuteState = FALSE;
		break;
	}//end of Switch
	return blMuteState;
}
/*******************************************************************************
 *FUNCTION:    tunmstr_AudioClientHandler::blConvertMuteSource
 *
 *DESCRIPTION: Convert Functionr
 *
 *PARAMETER:arl_tenSource enSrcNum
 *
 *
 *RETURNVALUE: tBool
 ********************************************************************************/
tBool tunmstr_AudioClientHandler::blConvertMuteSource(arl_tenSource enSrcNum)const
{
	tBool blMuteSource = FALSE;
	switch (enSrcNum)
	{
	case ARL_SRC_DABTA:
	{
		blMuteSource = TUNMSTR_SRCCHG_MUTESRC_DABTA;
	}break;
	case ARL_SRC_DAB:
	{
		blMuteSource = TUNMSTR_SRCCHG_MUTESRC_DAB;
	}break;
	default:
		blMuteSource = FALSE;
		break;
	}//end of Switch
	return blMuteSource;
}
/*******************************************************************************
 *FUNCTION:    tunmstr_AudioClientHandler::vSrcActivity_TunerSource
 *
 *DESCRIPTION: Convert Functionr
 *
 *PARAMETER:arl_tenSource enSrcNum
 *
 *
 *RETURNVALUE: tBool
 ********************************************************************************/
tVoid tunmstr_AudioClientHandler::vSrcActivity_TunerSource(arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity)
{
	if((m_potunmstr_SrcChgManager == NULL)||(m_potunmstr_TunerClient_Handler==NULL)
			|| (m_potunmstr_MuteHandler == NULL))
	{
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
		NORMAL_M_ASSERT( m_potunmstr_TunerClient_Handler != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MuteHandler != NULL );
		ETG_TRACE_USR4(("tunmstr_AudioClientHandler::vSrcActivity_TunerSource, m_potunmstr_SrcChgManager pointer is NULL"));
		return;
	}
	tU8 u8Source = TUNMSTR_SRCCHG_INVALID;
	switch(rfcoSrcActivity.enType)
	{
	case midw_fi_tcl_e8_SrcActivity::FI_EN_ON:
	{
		u8Source = u8MapAuidoSources(enSrcNum);
		if(m_potunmstr_SrcChgManager->blGetDirectFrqRequest_Status() == TRUE)
		{
			m_potunmstr_SrcChgManager->vSetBandChgSDS_status(TRUE);
			m_potunmstr_SrcChgManager->vSetSDSBand(u8Source);
			m_potunmstr_SrcChgManager->vSetTunAudibleStatus((tU8)TUNMSTR_SRCCHG_ACTION_ON);
			ETG_TRACE_USR4(("tunmstr_AudioClientHandler::vSrcActivity_TunerSource, ON request for SDS case"));
		}
		else
		{
			m_potunmstr_SrcChgManager->vHandleTunerSrcChg_ON(u8Source);
			ETG_TRACE_USR4(("tunmstr_AudioClientHandler::vSrcActivity_TunerSource, Tuner Play"));
		}
	}//case
	break;
	case midw_fi_tcl_e8_SrcActivity::FI_EN_PAUSE:
	{
		u8Source = u8MapAuidoSources(enSrcNum);
		if(m_potunmstr_SrcChgManager->blGetDirectFrqRequest_Status() == TRUE)
		{
			m_potunmstr_SrcChgManager->vSetBandChgSDS_status(TRUE);
			m_potunmstr_SrcChgManager->vSetSDSBand(u8Source);
			m_potunmstr_SrcChgManager->vSetTunAudibleStatus((tU8)TUNMSTR_SRCCHG_ACTION_PAUSE);
			ETG_TRACE_USR4(("tunmstr_AudioClientHandler::vSrcActivity_TunerSource, PAUSE request for SDS case"));
		}
		else
		{
			m_potunmstr_SrcChgManager->vHandleTunerSrcChg_PAUSE(u8Source);
			ETG_TRACE_USR4(("tunmstr_AudioClientHandler::vSrcActivity_TunerSource, Tuner Pause"));

		}

	}
	break;
	case midw_fi_tcl_e8_SrcActivity::FI_EN_OFF:
	{
			u8Source = u8MapAuidoSources(enSrcNum);
			m_potunmstr_SrcChgManager->vHandleTunerSrcChg_OFF(u8Source);
			//m_potunmstr_MuteHandler->vSendTunerDeMute_srcChange();
			ETG_TRACE_USR4(("tunmstr_AudioClientHandler::vSrcActivity_TunerSource, Tuner Stop"));
	}
	break;
	default:
	{
		ETG_TRACE_USR4(("tunmstr_AudioClientHandler::vSrcActivity_TunerSource, Inside default Tuner case"));
	}
	break;
	};// end of Switch
}
/*******************************************************************************
 *FUNCTION:    tunmstr_AudioClientHandler::vSrcActivity_DABSource
 *
 *DESCRIPTION: Convert Functionr
 *
 *PARAMETER:arl_tenSource enSrcNum
 *
 *
 *RETURNVALUE: tBool
 ********************************************************************************/
tVoid tunmstr_AudioClientHandler::vSrcActivity_DABSource(arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity)
{
	if((m_potunmstr_SrcChgManager == NULL) || (m_potunmstr_MuteHandler == NULL))
	{
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
		NORMAL_M_ASSERT( m_potunmstr_MuteHandler != NULL );
		ETG_TRACE_USR4(("tunmstr_AudioClientHandler::vSrcActivity_DABSource, m_potunmstr_SrcChgManager pointer is NULL"));
		return ;
	}
	tU8 u8Source = TUNMSTR_SRCCHG_INVALID;
	switch(rfcoSrcActivity.enType)
	{
	case midw_fi_tcl_e8_SrcActivity::FI_EN_ON:
	{
		u8Source = u8MapAuidoSources(enSrcNum);
		m_potunmstr_SrcChgManager->vHandleDABSrcChg_ON(u8Source);
		ETG_TRACE_USR4(("tunmstr_AudioClientHandler::bOnSrcActivity, DAB Play"));
	}
	break;
	case midw_fi_tcl_e8_SrcActivity::FI_EN_PAUSE:
	{
		u8Source = u8MapAuidoSources(enSrcNum);
		m_potunmstr_SrcChgManager->vHandleDABSrcChg_PAUSE(u8Source);
		ETG_TRACE_USR4(("tunmstr_AudioClientHandler::bOnSrcActivity, DAB Pause"));
	}
	break;
	case midw_fi_tcl_e8_SrcActivity::FI_EN_OFF:
	{
			u8Source = u8MapAuidoSources(enSrcNum);
			m_potunmstr_SrcChgManager->vHandleDABSrcChg_OFF(u8Source);
			//m_potunmstr_MuteHandler->vSendDABDeMute_srcChange();
			ETG_TRACE_USR4(("tunmstr_AudioClientHandler::bOnSrcActivity, DAB Stop"));
	}
	break;
	default:
	{
		ETG_TRACE_USR4(("tunmstr_AudioClientHandler::bOnSrcActivity, Inside default DAB case"));
	}
	break;


	};//end of Switch

}

/*******************************************************************************
 *FUNCTION:    tunmstr_AudioClientHandler::vSrcActivity_TASource
 *
 *DESCRIPTION: Convert Functionr
 *
 *PARAMETER:arl_tenSource enSrcNum
 *
 *
 *RETURNVALUE: tBool
 ********************************************************************************/
tVoid tunmstr_AudioClientHandler::vSrcActivity_TASource(arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity)
{
	if(m_potunmstr_SrcChgManager == NULL)
	{
		NORMAL_M_ASSERT( m_potunmstr_SrcChgManager != NULL );
		ETG_TRACE_USR4(("tunmstr_AudioClientHandler::vSrcActivity_TASource, m_potunmstr_SrcChgManager pointer is NULL"));
		return ;
	}
	tU8 u8Source = TUNMSTR_SRCCHG_INVALID;
	switch(rfcoSrcActivity.enType)
	{
	case midw_fi_tcl_e8_SrcActivity::FI_EN_ON:
	{
		u8Source = u8MapAuidoSources(enSrcNum);
		m_potunmstr_SrcChgManager->vHandleAnnoSrc_ON(u8Source);
		ETG_TRACE_USR4(("tunmstr_AudioClientHandler::bOnSrcActivity, TA Play"));
	}
	break;
	case midw_fi_tcl_e8_SrcActivity::FI_EN_PAUSE:
	{
		u8Source = u8MapAuidoSources(enSrcNum);
		m_potunmstr_SrcChgManager->vHandleAnnoSrc_PAUSE(u8Source);
		ETG_TRACE_USR4(("tunmstr_AudioClientHandler::bOnSrcActivity, TA Pause"));
	}
	break;
	case midw_fi_tcl_e8_SrcActivity::FI_EN_OFF:
	{
		u8Source = u8MapAuidoSources(enSrcNum);
		m_potunmstr_SrcChgManager->vHandleAnnoSrc_OFF(u8Source);
		ETG_TRACE_USR4(("tunmstr_AudioClientHandler::bOnSrcActivity, TA Stop"));
	}
	break;
	default:
	{
		ETG_TRACE_USR4(("tunmstr_AudioClientHandler::bOnSrcActivity, Inside default TA case"));
	}
	break;
	};//end of switch

}

/*******************************************************************************
 *FUNCTION:    tunmstr_AudioClientHandler::vHandleSrcReq_ServiceUnavail
 *
 *DESCRIPTION: If we get Source change request when Tuner /DAB Service of  is unavail,
 *	then source and activity values are stored and later passed once there service is Avail
 *
 *PARAMETER:arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity
 *
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_AudioClientHandler::vHandleSrcReq_ServiceUnavail( arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity)
{

	
	// update soucre value

	switch(rfcoSrcActivity.enType)
	{
	case midw_fi_tcl_e8_SrcActivity::FI_EN_ON:
	{
		vSetSrcReq_ServiceUnavail(enSrcNum);
		vSetSrcActivity_ServiceUnavail((tU8)TUNMSTR_SRCCHG_ACTION_ON );
		ETG_TRACE_USR4(("tunmstr_AudioClientHandler::vSetSrcReq_ServiceUnavailTuner, On Request stored"));
	}//case
	break;
	case midw_fi_tcl_e8_SrcActivity::FI_EN_PAUSE:
	{
		vSetSrcReq_ServiceUnavail(enSrcNum);
		vSetSrcActivity_ServiceUnavail((tU8)TUNMSTR_SRCCHG_ACTION_PAUSE );
		vSendResult_ToLib(enSrcNum,(tU8)TUNMSTR_SRCCHG_ACTION_PAUSE);
		// Pal1kor: in case of Pasue and OFF, result needs to be sent to ARL immidetely. Solution for JIRA issue NIKAI-6907
		ETG_TRACE_USR4(("tunmstr_AudioClientHandler::vSetSrcReq_ServiceUnavailTuner, PAUSE Request stored"));
	}
	break;
	case midw_fi_tcl_e8_SrcActivity::FI_EN_OFF:
	{
		vSendResult_ToLib(enSrcNum,(tU8)TUNMSTR_SRCCHG_ACTION_OFF);
		// Pal1kor: in case of Pasue and OFF, result needs to be sent to ARL immidetely. Solution for JIRA issue NIKAI-6907
		ETG_TRACE_USR4(("tunmstr_AudioClientHandler::vSetSrcReq_ServiceUnavailTuner, OFF Request stored"));

	}
	break;
	default:
	{
		vSetSrcActivity_ServiceUnavail(TUNMSTR_SRCCHG_INVALID );
		ETG_TRACE_USR4(("tunmstr_AudioClientHandler::vSetSrcReq_ServiceUnavailTuner, Default case"));
	}
	break;
	};// end of Switch
}// end of function

/*******************************************************************************
 *FUNCTION:    tunmstr_AudioClientHandler::vSetSrcReq_ServiceUnavail
 *
 *DESCRIPTION: Set Source variable and update respective flag
 *
 *PARAMETER:arl_tenSource enSrcNum
 *
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_AudioClientHandler::vSetSrcReq_ServiceUnavail(arl_tenSource enSrcNum)
{
	tU8 u8Source = u8MapAuidoSources(enSrcNum);
	m_u8SrcReq_ServiceUnavail = u8Source;

	ETG_TRACE_USR4(("tunmstr_AudioClientHandler::vSetSrcReq_ServiceUnavail -> "
			"Source = %d "
			,m_u8SrcReq_ServiceUnavail));

}// end of Function
/*******************************************************************************
 *FUNCTION:    tunmstr_AudioClientHandler::vSetSrcReq_ServiceUnavail
 *
 *DESCRIPTION: Set Source variable and update respective flag
 *
 *PARAMETER:arl_tenSource enSrcNum
 *
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_AudioClientHandler::vSetSrcReq_ServiceUnavail(tU8 u8Source)
{

	m_u8SrcReq_ServiceUnavail = u8Source;

	ETG_TRACE_USR4(("tunmstr_AudioClientHandler::vSetSrcReq_ServiceUnavail -> "
			"Source = %d "
			,m_u8SrcReq_ServiceUnavail	));

}// end of Function
/*******************************************************************************
 *FUNCTION:    tunmstr_AudioClientHandler::vSetSrcActivity_ServiceUnavail
 *
 *DESCRIPTION: Set Activity variable
 *
 *PARAMETER:arl_tenSource enSrcNum
 *
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_AudioClientHandler::vSetSrcActivity_ServiceUnavail(tU8 u8Activity)
{
	m_u8SrcActivity_ServiceUnavail = u8Activity;
	ETG_TRACE_USR4(("tunmstr_AudioClientHandler::vSetSrcActivity_ServiceUnavail -> "
			"Activity = %d",
			m_u8SrcActivity_ServiceUnavail	));
}
/*******************************************************************************
 *FUNCTION:    tunmstr_AudioClientHandler::vSetSrcActivity_ServiceUnavail
 *
 *DESCRIPTION: Return Activity variable
 *
 *PARAMETER:
 *
 *
 *RETURNVALUE: tU8
 ********************************************************************************/

tU8 tunmstr_AudioClientHandler::u8GetSrcActivity_ServiceUnavail()
{
	ETG_TRACE_USR4(("tunmstr_AudioClientHandler::u8GetSrcActivity_ServiceUnavail -> "
			"Action = %d",
			m_u8SrcActivity_ServiceUnavail	));
	return m_u8SrcActivity_ServiceUnavail;
}
/*******************************************************************************
 *FUNCTION:    tunmstr_AudioClientHandler::u8GetSrcReq_ServiceUnavail
 *
 *DESCRIPTION: Return Source variable
 *
 *PARAMETER:
 *
 *
 *RETURNVALUE: tU8
 ********************************************************************************/
tU8 tunmstr_AudioClientHandler::u8GetSrcReq_ServiceUnavail()
{
	ETG_TRACE_USR4(("tunmstr_AudioClientHandler::u8GetSrcActivity_ServiceUnavail -> "
			"Source = %d",
			m_u8SrcReq_ServiceUnavail	));
	return m_u8SrcReq_ServiceUnavail;
}
/*******************************************************************************
 *FUNCTION:    tunmstr_AudioClientHandler::enConvertFiSourcetoArlSrc
 *
 *DESCRIPTION: Rconverts midw_fi_tcl_e8_Band to arl_tenSource
 *
 *PARAMETER:  midw_fi_tcl_e8_BandeBand
 *
 *RETURNVALUE: arl_tenSource enRetSrc
 ********************************************************************************/
arl_tenSource tunmstr_AudioClientHandler::enConvertFiSourcetoArlSrc(tU8 u8Band) const
{
	arl_tenSource enRetSrc;
	switch(u8Band)
	{
	case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_FM:
	{
		enRetSrc=ARL_SRC_FM;
		break;
	}
	case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_MW:
	case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_LW:
	{
		enRetSrc=ARL_SRC_AM;
		break;
	}
	case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_CB1:
   {
      enRetSrc=ARL_SRC_DRM;
      break;
   }
	case (tU8)midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_DAB:
	{
		enRetSrc=ARL_SRC_DAB;
		break;
	}
	default:
	{
		enRetSrc=ARL_SRC_NONE;
		break;
	}
	}
	return enRetSrc;
}
/*******************************************************************************
 *FUNCTION:    tunmstr_AudioClientHandler::vSendMuteState
 *
 *DESCRIPTION: Function to request mute/demute from other tunermaster classes
 *
 *PARAMETER:  arl_tenSource enSrc, arl_tenMuteAction enMuteAction,arl_enMuteReason enMuteReason
 *
 *RETURNVALUE: tVoid 
 ********************************************************************************/
tVoid tunmstr_AudioClientHandler::vSendMuteState(
		arl_tenSource enSrc, arl_tenMuteAction enMuteAction,arl_enMuteReason enMuteReason)
{
	ETG_TRACE_USR4(("vSendMuteState()->enSrc=%d enMuteAction=%d enMuteReason=%d",enSrc,enMuteAction,enMuteReason));
#ifdef MUTE_ACTIVE
	bSetMuteState(enSrc, enMuteAction, enMuteReason);
#endif
}
/*******************************************************************************
 *FUNCTION:    tunmstr_AudioClientHandler::vStoreMuteParameter
 *
 *DESCRIPTION: Function to store mute request parameter sent to ARLs
 *
 *PARAMETER:  arl_tenSource enSrc, arl_tenMuteAction enMuteAction,arl_enMuteReason enMuteReason
 *
 *RETURNVALUE: tVoid 
 ********************************************************************************/
tVoid tunmstr_AudioClientHandler::vStoreMuteParameter(arl_tenSource enSrc, arl_tenMuteAction enMuteAction,arl_enMuteReason enMuteReason)
{
	ETG_TRACE_USR4(("vStoreMuteParameter()->enSrc=%d enMuteAction=%d enMuteReason=%d",enSrc,enMuteAction,enMuteReason));
#ifdef MUTE_ACTIVE
	m_ostMuteRequest.enMuteState=enMuteAction;
	m_ostMuteRequest.enSrcNum=enSrc;
	m_ostMuteRequest.enmuteReason=enMuteReason;
#endif
}
/*******************************************************************************
 *FUNCTION:    tunmstr_AudioClientHandler::vSendDemuteRequest
 *
 *DESCRIPTION: Function to send demute request to ARL in case of Preset Recall
 *
 *PARAMETER:  tVoid
 *
 *RETURNVALUE: tVoid 
 ********************************************************************************/
tVoid tunmstr_AudioClientHandler::vSendDemuteRequest()
{
	if(m_potunmstr_Preset_Handler==NULL)
	{
		return;
	}
	enPresetReguest oenPresetReguest;
	oenPresetReguest=m_potunmstr_Preset_Handler->enGetPreserRequest();
	ETG_TRACE_USR4(("vSendDemuteRequest()->oenPresetReguest=%d",oenPresetReguest));
	if(oenPresetReguest==NormalPresetRecall)
	{
		vSendMuteState(m_ostMuteRequest.enSrcNum,m_ostMuteRequest.enMuteState,m_ostMuteRequest.enmuteReason);
		m_potunmstr_Preset_Handler->vUpdatePresetRequestVar(None);
	}
}
/*******************************************************************************
 *FUNCTION:    tunmstr_AudioClientHandler::vHandleANNOSrcChg_Request
 *
 *DESCRIPTION: Function is used to send Source hcange request directly to ARL
 *
 *PARAMETER:  tU8 u8Anno_Source, tU8 u8Action
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_AudioClientHandler::vHandleANNOSrcChg_Request(tU8 u8Anno_Source, tU8 u8Action)
{
	if(m_potunmstr_SrcChg_AnnoHandler==NULL)
	{
		ETG_TRACE_USR4(("vHandleANNOSrcChg_Request()->Null Pointer"));
		return;
	}
	switch (u8Action)
		{
		case AUDIO_PLAY:
		{
			ETG_TRACE_USR4(("vHandleANNOSrcChg_Request()->ON sent"));
			m_potunmstr_SrcChg_AnnoHandler->vSetTA_Anno_State(TRUE);
			bSetAudioRouteRequest(u8MapTunmstrSources(u8Anno_Source),ARL_EN_ISRC_ACT_ON );
			break;
		}
		case AUDIO_PAUSE:
		{
			ETG_TRACE_USR4(("vHandleANNOSrcChg_Request()->Pause sent"));
			bSetAudioRouteRequest(u8MapTunmstrSources(u8Anno_Source),ARL_EN_ISRC_ACT_PAUSE );
			break;
		}
		case AUDIO_STOP:
		{
			ETG_TRACE_USR4(("vHandleANNOSrcChg_Request()->Off sent"));
			m_potunmstr_SrcChg_AnnoHandler->vSetTA_Anno_State(FALSE);
			bSetAudioRouteRequest(u8MapTunmstrSources(u8Anno_Source),ARL_EN_ISRC_ACT_OFF );
			break;
		}
		default:
			ETG_TRACE_USR4(("tunmstr_AudioClientHandler::vHandleANNOSrcChg_Request, Default case"));
			break;
		}; //end of switch

}
/*******************************************************************************
 *FUNCTION:		vSet_tunmstr_SrcChg_AnnoHandler_Ptr
 *
 *DESCRIPTION:	Function is update the pointer varaible m_potunmstr_SrcChg_AnnoHandler
 *
 *PARAMETER:	tunmstr_SrcChg_AnnoHandler* potunmstr_SrcChg_AnnoHandler
 *
 *RETURNVALUE:	tVoid
 ********************************************************************************/
tVoid tunmstr_AudioClientHandler::vSet_tunmstr_SrcChg_AnnoHandler_Ptr(tunmstr_SrcChg_AnnoHandler* potunmstr_SrcChg_AnnoHandler)

{
	if( potunmstr_SrcChg_AnnoHandler != NULL )
	{
		m_potunmstr_SrcChg_AnnoHandler = ( tunmstr_SrcChg_AnnoHandler* )potunmstr_SrcChg_AnnoHandler;
	}
	else
	{
		NORMAL_M_ASSERT ( m_potunmstr_SrcChg_AnnoHandler != NULL );
	}
}
/*************************************************************************
 *
 * FUNCTION:    vSet_tunmstr_MuteHandler_Ptr
 *
 * DESCRIPTION: Set pointer to pointer tunmstr_Presethandler
 *
 * PARAMETER:   tunmstr_Presethandler* potunmstr_Presethandler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_AudioClientHandler::vSet_tunmstr_MuteHandler_Ptr(tunmstr_MuteHandler* potunmstr_MuteHandler)

{
	if( potunmstr_MuteHandler != NULL )
	{
		m_potunmstr_MuteHandler = ( tunmstr_MuteHandler* )potunmstr_MuteHandler;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_MuteHandler != NULL );
	}
}
/*******************************************************************************
 *FUNCTION:    blCheckForSrvAvat
 *
 *DESCRIPTION: Function to check the service availibilty of request ARL Source
 *
 *PARAMETER:  arl_tenSource enSrcNum
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tBool tunmstr_AudioClientHandler::blCheckForSrvAva(arl_tenSource enSrcNum)const
{
	if((NULL==m_potunmstr_TunerClient_Handler)||(NULL==m_potunmstr_DABClient_Handler))
	{
		return FALSE;
	}
	tBool blRet=FALSE;
	tU8 u8TunerService  = m_potunmstr_TunerClient_Handler->u8GetTunerService();
	tU8 u8DABService = m_potunmstr_DABClient_Handler->u8GetDABServiceState() ;
	switch(enSrcNum)
	{
	case ARL_SRC_FMTA :
	case ARL_SRC_FM:
	case ARL_SRC_AM:
    case ARL_SRC_DRM:
	{
		if(u8TunerService==TRUE)
		{
			blRet=TRUE;
		}
		break;
	}
	case ARL_SRC_DAB:
	case ARL_SRC_DABTA:
	{
		if(u8DABService==TRUE)
		{
			blRet=TRUE;
		}
		break;
	}
	default:
	{
		break;
	}
	}
	return blRet;
}
/*******************************************************************************
 *FUNCTION:    vCheckDRMSourceAvailability
 *
 *DESCRIPTION:  Function to Check the DRM source availability based by reading KDS
 *
 *PARAMETER:	tVoid
 *
 *RETURNVALUE:  tVoid
 ********************************************************************************/
tVoid tunmstr_AudioClientHandler::vCheckDRMSourceAvailability()
{

    if(NULL==m_poclConfigInterface)
    {
        return;
    }
    arl_tenSrcAvailability enSrcAvail=ARL_EN_SRC_NOT_AVAILABLE;
    arl_tenAvailabilityReason enAvailabilityReason=ARL_EN_REASON_NOMEDIA;
    tU32 u32Available_band =m_poclConfigInterface->u32GetConfigData("AvailableBands");

    if((u32Available_band & TUNMSTR_CONFIG_DEFAULT_AVAILABLEBAND_DRM_MASKVAL))
    {
        ETG_TRACE_USR4(("tunmstr_AudioClientHandler::vCheckDRMSourceAvailability \
                        DRM is avaialble"));
        enSrcAvail=ARL_EN_SRC_PLAYABLE_UNKNOWN;
        enAvailabilityReason=ARL_EN_REASON_NEWMEDIA;
    }
    vSendSourceavailability( ARL_SRC_DRM, enSrcAvail, enAvailabilityReason);
}

/*******************************************************************************
 *FUNCTION:    vCheckTunerSourceavailability
 *
 *DESCRIPTION: Function to Check the Avaliable Tunersource based by reading KDS 
 *
 *PARAMETER:	tVoid
 *
 *RETURNVALUE: tVoid
 ********************************************************************************/
tVoid tunmstr_AudioClientHandler::vCheckTunerSourceavailability()
{
	#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
	if(NULL==m_poclConfigInterface)
	{
		return;
	}
	arl_tenSrcAvailability enSrcAvail=ARL_EN_SRC_NOT_AVAILABLE;
	arl_tenAvailabilityReason enAvailabilityReason=ARL_EN_REASON_NOMEDIA;
	tU32 u32Available_band =m_poclConfigInterface->u32GetConfigData("AvailableBands");
	tBool blDABAvail=(tBool)m_poclConfigInterface->u32GetConfigData("DABSupported");
    for(tU8 u8Source=(tU8)ARL_SRC_FM;u8Source<=(tU8)ARL_SRC_DABTA;u8Source++)
	{
		switch(u8Source)
		{
			case ARL_SRC_FM:
			case ARL_SRC_FMTA:
			{
				if((u32Available_band & TUNMSTR_CONFIG_DEFAULT_AVAILABLEBAND_FM_MASKVAL))
				{
					enSrcAvail=ARL_EN_SRC_PLAYABLE_UNKNOWN;
					enAvailabilityReason=ARL_EN_REASON_NEWMEDIA;
				}
				break;
			}
			case ARL_SRC_AM:
			{
				if((u32Available_band & TUNMSTR_CONFIG_DEFAULT_AVAILABLEBAND_AM_MASKVAL))
				{
					enSrcAvail=ARL_EN_SRC_PLAYABLE_UNKNOWN;
					enAvailabilityReason=ARL_EN_REASON_NEWMEDIA;
				}
				break;
			}
			case ARL_SRC_DAB:
			case ARL_SRC_DABTA:
			{
				if(blDABAvail)
				{
					enSrcAvail=ARL_EN_SRC_PLAYABLE_UNKNOWN;
					enAvailabilityReason=ARL_EN_REASON_NEWMEDIA;
				}
				break;
			}
			default:
			{
				break;
			}
		}
		vSendSourceavailability((arl_tenSource)u8Source,enSrcAvail,enAvailabilityReason);
	}
    vCheckDRMSourceAvailability();
	#endif
}

/*************************************************************************
 *
 * FUNCTION:     vHandleTTFiS_CMD( )
 *
 * DESCRIPTION:  Handler to handle TTFIs Commands
 *
 * PARAMETER:    tU8DataLength, const tU8*u8DataSpecial
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmstr_AudioClientHandler::vHandleTTFiS_CMD(const tU8* u8DataSpecial)
{
	switch(u8DataSpecial[0])
	{
		case DRMDUMMYSOURCE_ENABLE:
		{
			m_blEnableDRMSource=TRUE;
			break;
		}
		case DRMDUMMYSOURCE_DISABLE:
		{
			m_blEnableDRMSource=FALSE;
			break;
		}

	default:
		{
			break;
		}
	}
	
}
