/************************************************************************
 * FILE:           tunmstr_TunerClientHandler.h
 * PROJECT:        G3g
 * SW-COMPONENT:   fc_tunermaster.
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:    To Handle CCA Messages sent from fc_amfmtuner
 *
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      			| Author                       | Modification
 * 29/11/2010			| (RBEI\ECV4) Pallavi          | initial version
* 25.04.13  			| NGP1KOR   				   | First version of the G3g after porting from NISSAN LCN2Kai
				
 *************************************************************************/


#ifndef TUNMSTR_TUNERCLIENTHANDLER_H
#define TUNMSTR_TUNERCLIENTHANDLER_H

/**vnd4kor : to solve prio 2 lint warning*/
//lint -"esym(793,external identifiers)"


//-------------------------- FI includes
#ifdef VARIANT_S_FTR_ENABLE_AIL_MOCK
#include "amt_mock/amt_if.h"
#else
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifdef VARIANT_S_FTR_ENABLE_AHL_MOCK
#include "ahl_mock/ahl_if.h"
#else
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#endif

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERFI_ERRORCODES

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h"

#include "datatypes/tString.h"

#ifdef VARIANT_S_FTR_ENABLE_TUNERMASTER_MOCK
//#include "../../utest/Mocks/tunmstr_AudioClientHandler.h"
#else
//#include "tunmstr_Tmc_Trace.h"
#include "tunmstr_AudioClientHandler.h"
#ifndef TUNMASTER_CLASS_FORWARD_DECL_H
#include "tunermaster_Class_ForwardDecl.h"
#endif
#endif


#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
#include "sessionManagement/clSessionControl.h"
#include "sessionManagement/clArlSourceImpl.h"
#include "sessionManagement/audio/clAudioSession.h"
using namespace tuner::sessionManagement::audio;
#endif

#ifdef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
#include "announcements/clAnnouncementControl.h"
#include "announcements/clAnnouncements.h"
#endif


class clConfigInterface;

/*----------------------------------*/
/* class tunmstr_TunerClientHandler definition  */
/*----------------------------------*/

class tunmstr_TunerClientHandler : public ahl_tclBaseWork
{
private:  

	//Pointer to class tunmaster_tclApp;
	tunmaster_tclApp* poGWMain;

	tunmaster_Config*       m_potunmaster_Config;

	clConfigInterface* m_poclConfigInterface;

	// Pointer to class tunmaster_Utility
	tunmaster_Utility* m_potunmstr_Utility;

	#ifdef AUDIO_ACTIVE
	tunmstr_AudioClientHandler* m_potunmstr_AudioClientHandler;
#endif


	//pointer to class tunmstr_SrcChgManager
	tunmstr_SrcChgManager* m_potunmstr_SrcChgManager;

	//pointer to class tunmstr_MsgToHMI
	tunmstr_MsgToHMI* m_potunmstr_MsgToHMI;

	//Pointer to class tunmstr_DABClientHandler
	tunmstr_DABClient_Handler* m_potunmstr_DABClient_Handler;
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
	tunermaster_PMClient* m_ptunmaster_PMClient;
#endif
	tunmstr_Preset_Handler* m_ptunmstr_Preset_Handler;
	tunmstr_AutoStoreHandler* m_ptunmstr_AutoStoreHandler;
	  tunmstr_SrcChg_AnnoHandler* m_potunmstr_SrcChg_AnnoHandler;
	     //Pointer to classtunmstr_MsgFromHMI
   	tunmstr_MsgFromHMI* m_potunmstr_MsgFromHMI;
   	tunmstr_MuteHandler* m_potunmstr_MuteHandler;

   	tunmstr_SDSHandler* m_potunmstr_SDSHandler;
	
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	tunermaster_SXMClient* m_potunermaster_SXMClient;
#endif

	tBool m_u8ServiceAvailable_Tuner;
	//tuner Header

	tU16 m_u16TunerRegID;
	tBool m_blSendGetStaticListReq;
	tU8 m_u8AnnoType;
	tBool m_bPTYState;
	tU8 m_u8StationinfoBand;
	tU32 m_u8StationinfoFreq;
	tBool m_bFromPMClient;

	tU8 m_u8PresetAutocompare;
	tBool m_bUserPresetAction;

	//Keeps the Registration ID

	/**vnd4kor: solved prio2 lint warning*/
	tVoid vHandlePendingSrcChgReq_Tuner();
	tVoid vHandle_TunPresetList(amt_tclServiceData* poMessage )const;
	tVoid vHandle_s_UnUsedMessages();
	midw_fi_tcl_e8_Tun_TunerBand enGetTunerDisableBand(tU8 u8Source);

public:
	/* Constructor */
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	tunmstr_TunerClientHandler(tunmaster_tclApp* poMain, tuner::sessionManagement::audio::clArlSourceImpl* poArlImpl);
	tBool bIsDabStateUpdateRequired(tuner::common::enTunerState &dabTunerState, tU16 u16PICode);
	tVoid vHandleDABSurvivellenceState();
	tBool bIsRequestedSourceFM();
#else
	tunmstr_TunerClientHandler(tunmaster_tclApp* poMain);
	tunmstr_TunerClientHandler();
#endif

	/* Destructor  */
	virtual ~tunmstr_TunerClientHandler( );

	tVoid vSet_tunmaster_Config_Ptr( tunmaster_Config* potunmaster_Config );

	tVoid vSet_tunmstr_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface);

	   // Set pointer tunmstr_MsgFromHMI
   	tVoid vSet_tunmstr_MsgFromHMI_Ptr(
   			tunmstr_MsgFromHMI* potunmstr_MsgFromHMI
   	);
	tVoid vSetTunerRegID(tU16 u16RegID);
#ifdef AUDIO_ACTIVE
	tVoid vSet_tunmstr_AudioClientHandler_Ptr( tunmstr_AudioClientHandler* potunmstr_AudioClientHandler);
#endif

#ifdef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
   tuner::announcements::clAnnouncementControl oAnnouncementControl;
#endif

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
   tuner::sessionManagement::audio::clSessionControl* m_poSessionControl;
   tuner::sessionManagement::audio::clArlSourceImpl* m_poArlImpl;
   tU8 m_u8TunerHeader;
   tU8 m_u8AudioSink;
#endif

	// Get pointer to class tunmaster_Utility
	tVoid vSet_tunmstr_Utility_Ptr( tunmaster_Utility* potunmstr_Utility );


	// Set pointer to class tunmstr_SrcChgManager
	tVoid vSet_tunmstr_SrcChgManager_Ptr( tunmstr_SrcChgManager* potunmstr_SrcChgManager );

	tVoid vSet_tunmstr_MsgToHMI_Ptr( tunmstr_MsgToHMI* potunmstr_MsgToHMI );

	tVoid vSet_tunmstr_DABClient_Handler_Ptr(tunmstr_DABClient_Handler* potunmstr_DABClient_Handler);
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
	tVoid vSet_PMClient_Handler_Ptr(tunermaster_PMClient* po_PMClient_Handler);
#endif

	tVoid vSet_tunmstr_Preset_Handler_Ptr(tunmstr_Preset_Handler* potunmstr_Preset_Handler);
	tVoid vSet_tunmstr_AutoStoreHandler_Ptr(tunmstr_AutoStoreHandler* potunmstr_AutoStoreHandler);

	tVoid vSet_tunmstr_SrcChg_AnnoHandler_Ptr( tunmstr_SrcChg_AnnoHandler* potunmstr_SrcChg_AnnoHandler );
	tVoid vSet_tunmstr_MuteHandler_Ptr( tunmstr_MuteHandler* potunmstr_MuteHandler );

	tVoid vSet_tunmstr_SDSHandler_Ptr( tunmstr_SDSHandler* potunmstr_SDSHandler  );
	
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	tVoid vSet_tunmstr_SXMClient_Handler_Ptr(tunermaster_SXMClient* potunermaster_SXMClient);
#endif

	//Handles the state changes of the service we use
	tVoid vOnServiceState(   tU16  u16ServiceId ,
			tU16  u16ServerId ,
			tU16  u16RegisterId,
			tU8   u8ServiceState,
			tU16  u16SubId      );

	//Function to handle change in power state
	tVoid vOnNewAppState(   tU32 u32OldAppState,  tU32 u32AppState  );
	tBool fUnregisterForService();

	// Register for FI ID's

	tBool fregisterForFID(tU16 u16FID);
	//Register for fc_amfmtuner service
	tVoid vRegisterForService(void);

	//Sned Messages to CCA component
	virtual tVoid vSendMessage( tU16             u16DestAppID,
			const fi_tclTypeBase&  oOutData,
			tU16             u16Fid,
			tU8              u8OpCode,
			tU16             u16CmdCtr);


	/*
   This function converts Amt message to visitor class and 
   get the data from visitor to the Fi class. Refer FI Manual Doc
	 */


	tU8 u8GetTunerService()const;

	//Method Start for MIDW_TUNERFI_C_U16_FID_TUN_S_AUDIO_FG_BG_NEW
	tVoid vSend_MTCAudiosource(midw_fi_tcl_e8_Tun_TunerHeader::tenType e8TunerState, midw_fi_tcl_e8_Tun_MTCAudioSource::tenType e8MTCAudioSource, midw_fi_tcl_e8_Tun_TunerBand::tenType e8Band, bool bIsAnnoSrcOffRequest = false);
	tVoid vSend_s_Audio_FG_BG_New(tU8 u8TunHeader, tU8 u8SubCommand, tU8 u8AUdioSink,tBool blTunerState,tU8 u8_PhysicalTuner, tU8 u8TunBand = 0xff);

	//Method Start for MIDW_TUNERFI_C_U16_FID_TUN_CHANGE_BAND
	tVoid vSend_s_ChangeBand(tU8 u8TunBand);

	//Method Start for MIDW_TUNERFI_C_U16_FID_TUN_S_STOP_ANNOUNCEMENT
	tVoid vSend_s_Stop_Anno(tU8 u8Anno);

	//Method Start for MIDW_TUNERFI_C_U16_FID_TUN_S_ACTIVE_TUNER
	tVoid vSend_s_ActiveTuner();

	//Method Start for FID_TUN_S_DIRECT_FREQUENCY
	tVoid vSend_s_DirectFrq_input(tU32 u32Frequency , tU8 u8Band);

	tVoid vSend_s_SetPIFreq_Input(tU32 u32Frequency , tU16 u16PI);

	/* Handle message of FID_TUN_G_STATION_DATA_VAG */
	tVoid vSend_s_AutoStore(tU8 u8ListID, tBool blStatus);

	tVoid vHandle_g_AtStation_Info( amt_tclServiceData* poMessage );

	//Handle message of FID_TUN_G_ANNOUNCEMENT_MESSAGE
	tVoid vHandle_g_Announcement_Message(amt_tclServiceData* poMessage );

	tVoid vHandle_AnnouncementMessage(tU8 u8Anno_State , tU8 u8FMAnnoType);

	//Handle message of FID_TUN_G_ANNOUNCEMENT_SWITCH
	tVoid vHandle_g_Announcement_Switch(amt_tclServiceData* poMessage);

	//Handle message of FID_TUN_G_COMPONENT_STATUS_TUNER
	tVoid vHandle_g_Component_Status(amt_tclServiceData* poMessage);

	//DRM related functions
    tVoid vSend_s_DemodulationSwitch(tU8 u8ModSwitch, tBool bDRMValue);
    tVoid vSend_s_AudioDevice(tunerString sSinkName);
    tVoid vSend_s_DRMSourceActivity(enTunmstr_DRMSourceActivity   e8SrcAct);

	//Method Result for MIDW_TUNERFI_C_U16_FID_TUN_S_FG_BG_NEW
	tVoid vHandle_s_AudioFgBg(amt_tclServiceData* poMessage );
	tVoid vHandle_s_HandlePresetMethodResult(amt_tclServiceData* poMessage );
	tVoid vHandle_s_DisableBand(amt_tclServiceData* poMessage);

	tVoid vHandle_s_PSFreezeResult(amt_tclServiceData* poMessage);

	//Method Result for MIDW_TUNERFI_C_U16_FID_TUN_S_BAND_CHANGE
	tVoid vHandle_s_BandChange(amt_tclServiceData* poMessage );

	//Method Result for MIDW_TUNERFI_C_U16_FID_TUN_S_DIRECT_FREQUENCY
	tVoid vHandle_s_DirectFrequency(amt_tclServiceData* poMessage );
	tVoid vSend_s_SetAnnouncementSwitch(tU8 u8AnnoSwitch);
	tVoid vHandle_s_ChangeLsm(amt_tclServiceData* poMessage);
	tVoid vHandle_s_SetPI(amt_tclServiceData* poMessage);

	//Method Result for MIDW_TUNERFI_C_U16_FID_TUN_S_ACTIVE_TUNER
	tVoid vHandle_s_ActiveTuner(amt_tclServiceData* poMessage);

	tVoid vHandle_g_Remote_Control(amt_tclServiceData* poMessage);

	tVoid vHandle_g_AnnouncementInfo(amt_tclServiceData* poMessage);

	tVoid vHandle_MonitorFMTA(tU16 u16PICode);

    //Method result for MIDW_TUNERFI_C_U16_FID_TUN_S_AUDIO_DEVICE
    tVoid vHandle_s_AudioDevice(amt_tclServiceData* poMessage )const;
    //method result for MIDW_TUNERFI_C_U16_FID_TUN_S_SET_DRM_SRCACTIVITY
    tVoid vHandle_s_DRMSrcAct(amt_tclServiceData* poMessage )const;
    //method result for MIDW_TUNERFI_C_U16_FID_TUN_S_SET_DEMODULATION_SWITCH
    tVoid vHandle_s_DemodSwitch(amt_tclServiceData* poMessage )const;

	tVoid vHandle_S_Autostore(amt_tclServiceData* poMessage )const;

	tVoid vSend_s_ChangeLSM();

	tVoid vHandleTTFiS_CMD(const tU8* u8DataSpecial);
	tVoid vRequestPresetList();
	tVoid vRequestPresetList_Suzuki();
	tVoid vRequestMixedPresetList();
	tVoid vHandleSDSDirectFreqReq();
	tVoid vHandlePendingTunTAPendingReq();
	tVoid vHandle_MuteRequest(amt_tclServiceData* poMessage );
	tVoid vSend_s_MuteState();
	tVoid vSetAnnoType(tU8 AnnoType);
	tU8 blConvertTUNAnnoType_TunMstrAnnoType(tU8 u8Anno_Type , tU8 &u8FMAnnoType);
	tBool bGetPTYState()const;
	tU8 u8GetActiveStationinfoBand()const;
	tVoid vHandleProfileUpdate(tU8 u8UserID , tU8 u8Action );
#ifdef INCLUDE_PROFILE_MANAGER
	tVoid vHandle_s_UserProfileUpdateResult(amt_tclServiceData* poMessage);
	tVoid vSendAMFMListonlinePersonalization(midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart& AMFMList );
	tVoid vHandle_S_ProfilePresetListContentUpdateResult(amt_tclServiceData* poMessage);
#endif
	tU32 u32GetCurrentAtStationFreq();
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
	tU8 u8GetBandFromFrequency(unsigned int u32Frequency);
#endif
	tVoid vDisableTunerSource(tU8 Source, tBool bFromPMClient);
	/*TUNMSTR_R_COMPONENT_STATUS, TUNMSTR_R_SET_FRQ,TUNMSTR_R_SEL_LIST_ELEM,TUNMSTR_R_SET_RDBID.... Need to Implimented as CCA Message. */
	virtual tVoid vGetDatafromAMT( amt_tclServiceData* poFIMsg,
			fi_tclTypeBase&     oFIData )const;

	tVoid vSendPSFreezeReq(tU8 u8Mode);

	tU8 u8GetPresetAutoCompare();
	tBool bGetUserPresetAction() { return m_bUserPresetAction; }

	DECLARE_MSG_MAP( tunmstr_TunerClientHandler )

};


#endif // TUNMSTR_TMC_MANAGER_H
