/************************************************************************
 * FILE:           tunmstr_SrcChg_Defines.h
 * PROJECT:        G3g
 * SW-COMPONENT:   FC_TunerMaster
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:    Source change  related defines
 *
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date           | Author                        | Modification
 * 12.04.2011     | CM-AI/PJ-VW36 Pallavi HN      | initial version
 * 25.04.13       | NGP1KOR   					  | First version of the G3g after porting from NISSAN LCN2Kai
				
 *************************************************************************/


#ifndef TUNMSTR_SRCCHG_SRCCHG_DEFINES_H
#define TUNMSTR_SRCCHG_SRCCHG_DEFINES_H


#define TUNERMASTER_AUDIO_FUNID_CARRAY_SIZE           40  // To be verified
#define UNERMASTER_AUDIO_FUNID_NOTARRAY_SIZE         60  // To be verified

#define TUNERMASTER_AUDIO_NOTTABLE_SEM_NAME           "TUNERMASTER_AUDIO_NOTTABLESEM"
#define TUNERMASTER_HMI_NOTTABLE_SEM_NAME           "TUNERMASTER_HMI_NOTTABLESEM"
#define TUNERMASTER_ERRHANDLR_TIMER           15000
#define TUNERMASTER_STOP_TIMER								0


/* Used in generated interface FI msg */
#define TUNERMASTER_FI_GEN_CODE_MAJOR_VERSION  1 


#define  TUNMSTR_SRCCHG_TUNER0             0x00
#define  TUNMSTR_SRCCHG_TUNER1             0x01
#define  TUNMSTR_SRCCHG_TUNER2			   0x02
#define  TUNMSTR_SRCCHG_TUNER3			   0x03
#define  TUNMSTR_SRCCHG_AUTO			      0x04


#define TUNMSTR_SRCCHG_MAX_NUM_TUNERS           0x02

#define TUNMSTR_SRCCHG_PS_NAME_MAX_VALUE           0x08

#define TUNMSTR_SRCCHG_SPACE_CHARACTER             0x20

#define TUNMSTR_SRCCHG_MUTESRC_DAB		0x00
#define TUNMSTR_SRCCHG_MUTESRC_DABTA	0x01


#define TUNMSTR_SRCCHG_MUTESTATUS_MUTE				0x00
#define TUNMSTR_SRCCHG_MUTESTATUS_DEMUTE			0x01
#define TUNMSTR_SRCCHG_MUTESTATUS_DEMUTE_RUNNING	0x02




/* Tuner TA Mode  */
#define TUNMSTR_SRCCHG_FEATURE_SET_TA_MODE                   0x00002000
#define TUNMSTR_SRCCHG_FEATURE_TA_MODE_MASK_ON               0x00002000
#define TUNMSTR_SRCCHG_FEATURE_TA_MODE_MASK_OFF              0x00000000

/* Tuner PTY Mode  */
#define TUNMSTR_SRCCHG_FEATURE_SET_PTY_MODE                       0x00000040
#define TUNMSTR_SRCCHG_FEATURE_PTY_MODE_MASK_ON             0x00000040
#define TUNMSTR_SRCCHG_FEATURE_PTY_MODE_MASK_OFF              0x00000000


#define TUNMSTR_SRCCHG_PSNAME_MAX_SIZE                     16



#define TUNMSTR_SRCCHG_INVALID_STATION_LIST_ELEM       0xff

/*----------------------------------------------*/
/* TP status indicated in u16PackedInfo (0x51) */
/* FID_TUN_G_STATION_DATA_VAG              */
/*----------------------------------------------*/

// valid TP-values
//TUNMSTR_TP_UNDECODED    ==> nothing TODO
//TUNMSTR_TP_OFF          ==> TUNMSTR_TP_OFF
//TUNMSTR_TP_ON           ==> TUNMSTR_TP_ON
//TUNMSTR_TP_LOST         ==> TUNMSTR_TP_OFF
//TUNMSTR_TP_OFF_TEMP     ==> TUNMSTR_TP_OFF

#define  TUNMSTR_TP_SHIFT_MASK        7
#define  TUNMSTR_TP_MASK              0x0380  //0b00000011 10000000

#define TUNMSTR_SRCCHG_STATUS_TUNMSTR_TP_UNDECODED		     0x00 // 0b000
#define TUNMSTR_SRCCHG_STATUS_TUNMSTR_TP_OFF			     0x01 // 0b001
#define TUNMSTR_SRCCHG_STATUS_TUNMSTR_TP_ON                 0x02 // 0b010
#define TUNMSTR_SRCCHG_STATUS_TUNMSTR_EON_TP			    0x03 // 0b011
#define TUNMSTR_SRCCHG_STATUS_TUNMSTR_TP_NO_SYNC  	        0x04 // 0b110


/*----------------------------------------------*/
/*Avail Flag Info from  */
/* FID_TUN_G_STATION_DATA_VAG              */
/*----------------------------------------------*/

#define TUNMSTR_SRCCHG_FRQ_AVAILABLE                  0x01
#define TUNMSTR_SRCCHG_PSNAME_AVAILABLE               0x02



/*--------------------------------------------------*/
/*  Defines commam to All messages                  */
/*                                                  */
/*--------------------------------------------------*/
enum enTunmstrTunerState
{
	TUNMSTR_SRCCHG_FOREGROUND,
	TUNMSTR_SRCCHG_BACKGROUND,
	TUNMSTR_SRCCHG_INPROGESS,
	TUNMSTR_SRCCHG_DAB_PAUSE_STATE,
	TUNMSTR_SRCCHG_DAB_SURVEILLANCE
};
#define TUNMSTR_SRCCHG_INVALID						   0xFF

/*--------------------------------------------------*/
/*  Band						                  */
/* These defines are based on FI Tunermaster                                                 */
/*--------------------------------------------------*/

#define TUNMSTR_SRCCHG_BAND_FM						0x00
#define TUNMSTR_SRCCHG_BAND_AM						0x02
#define TUNMSTR_SRCCHG_BAND_DAB						0x01
#define TUNMSTR_SRCCHG_BAND_LW						0x03
#define TUNMSTR_SRCCHG_BAND_CB1              0x14
#define TUNMSTR_SRCCHG_BAND_NONE					0xFF
#define TUNMSTR_SRCCHG_BAND_UPDATE_NOTREQ  0xFE
// This define is used to resolve Prio 1 lint issue. 

/*--------------------------------------------------*/
/*  Tuner Band						                  */
/* These defines are based on FI Tunermaster                                                 */
/*--------------------------------------------------*/

#define TUNMSTR_SRCCHG_TUNER_BAND_FM				0x00
#define TUNMSTR_SRCCHG_TUNER_BAND_AM				0x01

#define TUNMSTR_ANNOREQUEST_OFF   		0x00
#define TUNMSTR_ANNOREQUEST_ON    		0x01
#define TUNMSTR_ANNOREQUEST_IGNORE   	0x02

#define TUNMSTR_ANNOPRIORITY_IGNORE     0x001F

/*--------------------------------------------------*/
/*	     Source         			                  */
/*                                                  */
/*--------------------------------------------------*/
enum enTunmstrSource
{
	TUNMSTR_SRCCHG_SOURCE_TUN1FM,
	TUNMSTR_SRCCHG_SOURCE_TUN2,
	TUNMSTR_SRCCHG_SOURCE_TUN1AM,
	TUNMSTR_SRCCHG_SOURCE_DAB	,
	TUNMSTR_SRCCHG_SOURCE_FM_TA,
	TUNMSTR_SRCCHG_SOURCE_DAB_TA,
	TUNMSTR_SRCCHG_SOURCE_DAB_FM_SF,
	TUNMSTR_SRCCHG_SOURCE_NON_RADIO,
	TUNMSTR_SRCCHG_SOURCE_FMPTY31,
	TUNMSTR_SRCCHG_SOURCE_DABPTY31,
	TUNMSTR_SRCCHG_SOURCE_DABOTHER,
	TUNMSTR_SRCCHG_SOURCE_FMOTHER,
	TUNMSTR_SRCCHG_SOURCE_NO_TA,
	TUNMSTR_SRCCHG_SOURCE_FMTA_INVALID,
   TUNMSTR_SRCCHG_SOURCE_DABTA_INVALID,
   TUNMSTR_SRCCHG_SOURCE_DRM
};
/*--------------------------------------------------*/
/*	     Action        			                  */
/*                                                  */
/*--------------------------------------------------*/
enum enTunmstrAction
{
	TUNMSTR_SRCCHG_ACTION_ON,
	TUNMSTR_SRCCHG_ACTION_PAUSE,
	TUNMSTR_SRCCHG_ACTION_OFF
};

/*--------------------------------------------------*/
/*	     Visible & Audible 		                  */
/*                                                  */
/*--------------------------------------------------*/
enum enTunmstrVisibleInfo
{
	TUNMSTR_SRCCHG_INVISIBLE,
	TUNMSTR_SRCCHG_VISIBLE
};

enum enTunmstrAudiableInfo
{
	TUNMSTR_SRCCHG_NOTAUDIABLE,
	TUNMSTR_SRCCHG_AUDIABLE
};


/*************************************************/
/************TUNMSTR Anno_Types*******************/
/************************************************/
enum enTunmstrAnnoType
{
	TUNMSTR_SRCCHG_ANNOTYPES_PTY31,
	TUNMSTR_SRCCHG_ANNOTYPE_TA,
	TUNMSTR_SRCCHG_ANNOTYPE_OTHER,
	TUNMSTR_SRCCHG_ANNOTYPE_TRANSPORT,
	TUNMSTR_SRCCHG_ANNOTYPE_WARNING,
	TUNMSTR_SRCCHG_ANNOTYPE_NEWS,
	TUNMSTR_SRCCHG_ANNOTYPE_WEATHER,
	TUNMSTR_SRCCHG_ANNOTYPE_EVENT,
	TUNMSTR_SRCCHG_ANNOTYPE_SPECIALEVENT,
	TUNMSTR_SRCCHG_ANNOTYPE_PROGRAMME,
	TUNMSTR_SRCCHG_ANNOTYPE_SPORT,
	TUNMSTR_SRCCHG_ANNOTYPE_FINANCE,
	TUNMSTR_SRCCHG_ANNOTYPE_INVALID = 0xFF
};

/***************************************************/
/************SET Feature*******************/
/***************************************************/
enum enTunmstrFeatureInfo
{
	TUNMSTR_SRCCHG_SET_FEATURE_TA,
	TUNMSTR_SRCCHG_SET_FEATURE_PTY31,
	TUNMSTR_SRCCHG_SET_FEATURE_INVALID=0xFF
};
/*---------------------------------------------------*/
/*           Audio Sink                              */
/*---------------------------------------------------*/
enum enTunmstrFGBG_AudioSink
{
	TUNMSTR_SRCCHG_USR1_CHG_FGBG,
	TUNMSTR_SRCCHG_TA_CHG_FGBG,
	TUNMSTR_SRCCHG_TIM_CHG_FGBG ,
	TUNMSTR_SRCCHG_PTY_CHG_FGBG,
	TUNMSTR_SRCCHG_NEWS_CHG_FGBG,
	TUNMSTR_SRCCHG_DABSF_CHG_FGBG
};

/*---------------------------------------------------*/
/*            Sub Command                            */
/*----------------------------------------------------*/
enum enTunmstrFGBG_SubCmd
{
	TUNMSTR_SRCCHG_CHG_TO_FG ,
	TUNMSTR_SRCCHG_CHG_TO_BG
};


/*-----------------------------------------------------*/
/*           DAB Source State                          */
/*-----------------------------------------------------*/
enum enTunmstrDAB_SourceState
{
	TUNMSTR_SRCCHG_DAB_BACKGROUND ,
	TUNMSTR_SRCCHG_DAB_FOREGROUND,
	TUNMSTR_SRCCHG_DAB_SERVICE_FOLLOWING ,
	TUNMSTR_SRCCHG_DAB_FOREGROUND_TA,
	TUNMSTR_SRCCHG_DAB_FOREGROUND_SURVEILLANCE = 0x06
};

/*------------------------------------------------------*/
/*            DAB Method Result                         */
/*------------------------------------------------------*/
enum enTunmstrDAB_Methodresult
{
	TUNMSTR_SRCCHG_DAB_RES_OK,
	TUNMSTR_SRCCHG_DAB_RES_FAILED,
	TUNMSTR_SRCCHG_DAB_RES_NOT_AVAILABLE,
	TUNMSTR_SRCCHG_DAB_RES_INPROCESS
};

/*------------------------------------------------------*/
/*            Tuner Master Method Result                */
/*------------------------------------------------------*/
enum enTunmstr_Methodresult
{
	TUNMSTR_SRCCHG_RES_REQ_SUCCEED,
	TUNMSTR_SRCCHG_RES_REQ_FAIL,
	TUNMSTR_SRCCHG_RES_REQ_INPROCESS
};

/*------------------------------------------------------*/
/*          TA  Announcement states of Tuner                */
/*------------------------------------------------------*/
enum enTunmstr_TunerTAAnnoustate
{
	TUNMSTR_SRCCHG_TUN_NO_ANNO,
	TUNMSTR_SRCCHG_TUN_ANNO_TA,
	TUNMSTR_SRCCHG_TUN_ANNO_PTY,
	TUNMSTR_SRCCHG_TUN_ANNO_PTY_31,
	TUNMSTR_SRCCHG_TUN_ANNO_NEWS,
	TUNMSTR_SRCCHG_TUN_ANNO_TA_ACTIVE=0x0010,
	TUNMSTR_SRCCHG_TUN_ANNO_EON=0x0020
};

/*------------------------------------------------------*/
/*          TA  Announcement states of DAB            */
/*------------------------------------------------------*/
enum enTunmstr_DABTAAnnoustate
{
	TUNMSTR_SRCCHG_DAB_IDLE,
	TUNMSTR_SRCCHG_DAB_PENDING,
	TUNMSTR_SRCCHG_DAB_SELECTING,
	TUNMSTR_SRCCHG_DAB_SELECTED,
	TUNMSTR_SRCCHG_DAB_DESELECTING
};
enum enAutostoreBank
{
	AST_AM_MW1=0,
	AST_FM1,
	AST_DAB,
	AST_AM_MW1_DAB,
	AST_FM1_DAB,
	AST_NONE=255
};


//SET_FEATURE for TA
#define  TUNMSTR_FEATURE_TA                       0x00002000
#define  TUNMSTR_FEATURE_OFF_MASK                 0x00000000 
/*----------------------------------------------------------------------------*/
/*---------------------Anno Config states of DAB----------------------*/
/*----------------------------------------------------------------------------*/

#define TUNMSTR_ANNO_DAB_ANNOTYPE_ALARM 		0x001
#define TUNMSTR_ANNO_DAB_ANNOTYPE_TA				0x002
#define TUNMSTR_ANNO_DAB_ANNOTYPE_OTHER        0x7F8
#define TUNMSTR_ANNO_DAB_ANNOTYPE_INVALID        0xFFF
/* This value is obtained by ORing DAB_ANNOTYPE_WARNING, DAB_ANNOTYPE_NEWS, DAB_ANNOTYPE_WEATHER
 * DAB_ANNOTYPE_EVENT, DAB_ANNOTYPE_SPECIALEVENT, DAB_ANNOTYPE_PROGRAMME, DAB_ANNOTYPE_SPORTS, DAB_ANNOTYPE_FINANCE,  types from DAB FI*/
#define TUNMSTR_DAB_PRESETLIST_LENGTH				0x12
//SET_FEATURE for TA
#define  TUNMSTR_COMP_STATUS_BGMODE_TEMP_FM       0x01
#define  TUNMSTR_COMP_STATUS_BGMODE_USER_FM       0x00

#define  TUNMSTR_COMP_STATUS_AUDSINK_USR_FG       0x01
#define  TUNMSTR_COMP_STATUS_AUDSINK_USR_BG       0x00
#define  TUNMSTR_COMP_STATUS_AUDSINK_TA_FG        0x02
#define  TUNMSTR_COMP_STATUS_AUDSINK_TA_BG        0x00

/*-------------------------------------------------------*/
/*         T_b16_DAB_AnnouncementType                    */
/*-------------------------------------------------------*/
#define TUNMSTR_SRCCHG_DAB_ANNOTYPE_NOANNO	0x00
#define TUNMSTR_SRCCHG_DAB_ANNOTYPE_ALARM       0x01
#define TUNMSTR_SRCCHG_DAB_ANNOTYPE_TA          0x02


#define TUNMSTR_SRCCHG_TA_ANNO_DECODE_MASK      0x1F
#define TUNMSTR_CRITICAL_LOW_VOLTAGE_START		0x00

/*-------------------------------------------------------*/
/*         T_e8_DAB_SwitchTuner                   */
/*-------------------------------------------------------*/

#define TUNMSTR_SRCCHG_DAB_SWITCH_TO_DAB       0x00
#define TUNMSTR_SRCCHG_DAB_SWITCH_TO_FM        0x01

#define TUNMSTR_TUNER_SOURCE_1 ((tU8)TUNMSTR_SRCCHG_SOURCE_TUN1FM==u8Source || \
		(tU8)TUNMSTR_SRCCHG_SOURCE_TUN1AM == u8Source)

#define TUNMSTR_TUNER_SOURCE_2 ((tU8)TUNMSTR_SRCCHG_SOURCE_TUN1FM==u8Source || \
		(tU8)TUNMSTR_SRCCHG_SOURCE_TUN1AM == u8Source || (tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA == u8Source)

#define TUNMSTR_DAB_SOURCE ((tU8)TUNMSTR_SRCCHG_SOURCE_DAB==u8Source || \
		(tU8)TUNMSTR_SRCCHG_SOURCE_DAB_TA == u8Source)

#define TUNMSTR_FMTPSTATUS_ACTIVE       ((u8Status == (tU8)TUNMSTR_SRCCHG_STATUS_TUNMSTR_TP_ON || \
		u8Status == (tU8)TUNMSTR_SRCCHG_STATUS_TUNMSTR_EON_TP))

#define TUNMSTR_DABTPSTATUS_ACTIVE    ((tU8)TUNMSTR_SRCCHG_DAB_ANNOTYPE_TA & u8Status||\
		(tU8)TUNMSTR_SRCCHG_DAB_ANNOTYPE_ALARM & u8Status)
#define TUNMSTR_TUNER_FMANNO_SRC ((tU8)TUNMSTR_SRCCHG_SOURCE_FMPTY31==u8Source || \
		(tU8)TUNMSTR_SRCCHG_SOURCE_FM_TA == u8Source || (tU8)TUNMSTR_SRCCHG_SOURCE_FMOTHER == u8Source)

#define TUNMSTR_TUNER_DABANNO_SRC ((tU8)TUNMSTR_SRCCHG_SOURCE_DABPTY31==u8Source || \
		(tU8)TUNMSTR_SRCCHG_SOURCE_DAB_TA == u8Source || (tU8)TUNMSTR_SRCCHG_SOURCE_DABOTHER == u8Source)

#define TUNMSTR_TUNER_STATE_BG_INVALID   (((tU8)TUNMSTR_SRCCHG_INVALID == u8TunerState || TUNMSTR_SRCCHG_BACKGROUND == u8TunerState) \
		&& ((tU8)TUNMSTR_SRCCHG_INVALID == u8DABState || TUNMSTR_SRCCHG_BACKGROUND == u8DABState))

#define TUNMSTR_TUNER_STATE_BG_TEMPFG   (((tU8)TUNMSTR_SRCCHG_INVALID == u8TunerState || TUNMSTR_SRCCHG_BACKGROUND == u8TunerState) \
		&& ((tU8)TUNMSTR_SRCCHG_DAB_TEMP_FOREGROUND == u8DABState))


enum enSourcendAction
{
	FM_ON=1,
	FM_PAUSE,
	FM_OFF,
	AM_ON,
	AM_OFF,
	AM_PAUSE,
	DAB_ON,
	DAB_OFF,
	DAB_PAUSE,
	FMTA_ON,
	FMTA_OFF,
	FMTA_PAUSE,
	DABTA_ON,
	DABTA_OFF,
	DABTA_PAUSE,
	DRM_ON,
	DRM_OFF,
	DRM_PAUSE,
	NONE
};
enum enVolumeMutendDemueReq
{
	enMute=0,
	enDemute
};
#define TUNMSTR_AST_NORMAL 0x00
#define TUNMSTR_AST_INITAL 0x01


/*********************************************************************/
/*               FID_TUN_S_SURVEIL_TP	                                                         */
/********************************************************************/
#define TUNMSTR_SRCCHG_START_TPSURVEILLANCE    0x00
#define TUNMSTR_SRCCHG_STOP_TPSURVEILLANCE       0x01
/*********************************************************************/
/**************DAB ANNO Source values********************************/
/*********************************************************************/

#define TUNMSTR_DAB_ANNOSOURCE_NONE								 0x00
#define TUNMSTR_DAB_ANNOSOURCE_CURRENT_SUBCHANNE  0x01
#define TUNMSTR_DAB_ANNOSOURCE_CURRENT_SERVICE        0x02
#define TUNMSTR_DAB_ANNOSOURCE_CURRENT_ENSEMBLE     0x03

/*********************************************************************/
/**************T_b8_SourceAnno values********************************/
/*********************************************************************/

#define TUNMSTR_SOURCEANNO_FM											0x01
#define TUNMSTR_SOURCEANNO_DAB											0x02
#define TUNMSTR_SOURCEANNO_BOTH										0x03
#define TUNMSTR_SOURCEANNO_NONE										0x00
#define TUNMSTR_SOURCEANNO_ALL 										0xFF
#define TUNMSTR_SOURCEANNO_FM_WB                            0x05
#define TUNMSTR_SOURCEANNO_WB                               0x04


#define  TUNMSTR_ANNO_HANDLING_ARL   0x01

#define  TUNMSTR_MONITORFMTA_AM      0x01
#define  TUNMSTR_MONITORFMTA_FM      0x06

enum enTunmstr_AnnoSwitch
{
	TUNMSTR_ANNOSTATE_PTYOFF_TAOFF,
	TUNMSTR_ANNOSTATE_PTYON_TAOFF,
	TUNMSTR_ANNOSTATE_PTYOFF_TAON,
	TUNMSTR_ANNOSTATE_PTYON_TAON
};


/*--------------------------------------------------*/
/*	     Tun ANno_message        			                  */
/*                                                  */
/*--------------------------------------------------*/
enum enTunmstr_Annomsg
{
	TUNMSTR_ANNOMSG_TAPTY_OFF,
	TUNMSTR_ANNOMSG_TAON_PTYOFF,
	TUNMSTR_ANNOMSG_TAOFF_PTYON,
	TUNMSTR_ANNOMSG_TAON_PTYON,
	TUNMSTR_ANNOMSG_INVALID = 0xffff
};

enum enTunmstr_AnnoListLength
{
	TUNMSTR_ANNOLISTLENGTH_ZERO,
	TUNMSTR_ANNOLISTLENGTH_ONE,
	TUNMSTR_ANNOLISTLENGTH_TWO,
	TUNMSTR_ANNOLISTLENGTH_THREE,
	TUNMSTR_ANNOLISTLENGTH_INVALID= 0xff
};

enum enTunmstr_AnnoElem_State
{
	TUNMSTR_ANNOELEM_STATE_START =1,
	TUNMSTR_ANNOELEM_STATE_END,
	TUNMSTR_ANNOELEM_STATE_ESCAPED,
	TUNMSTR_ANNOELEM_STATE_SWITCHED,
};

enum enTunmstr_MTC_Surveil_StationType
{
	TUNMSTR_MTC_SURVEIL_STATIONTYPE_DAB =0,
	TUNMSTR_MTC_SURVEIL_STATIONTYPE_FM
};

/**DRM defines*/
enum enTunmstr_DRMSourceActivity
{
    TUNMSTR_DRM_OFF = 0,
    TUNMSTR_DRM_ON,
    TUNMSTR_DRM_PAUSE
};

#define DRMEnable true
#define DRMDisable false

#define TUNMSTR_PRESETID_INVALID 0xFFFFFFFF

#endif // TUNMSTR_SRCCHG_DEFINES_H


