/************************************************************************
 * FILE:           tunmstr_SrcChgManager.h
 * PROJECT:        G3g
 * SW-COMPONENT:   FC_TunerMaster.
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:    This class will handle source change logic functionalty.
 *
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      | Author                       | Modification
 * 11-04-11  | CM-AI/PJ-VW36 Pallavi HN   | initial version
 *
 *************************************************************************/

#ifndef tunmstr_SrcChgManager_H
#define tunmstr_SrcChgManager_H


//-------------------------- FI includes

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_STDVISITORS // not sure
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_SERVICEINFO


#include "midw_fi_if.h" // Include tmctuner_fi in VOB:di_fi using "fi_if_gen.h"


#ifndef TUNMASTER_CLASS_FORWARD_DECL_H
#include "tunermaster_Class_ForwardDecl.h"
#endif
#ifndef TUNERMASTER_SPM_CLIENT_H
#include "tunermaster_SPM_Client.h"
#endif
#include "tunmstr_SrcChg_Defines.h"
//---------------------------------


//using namespace std;

struct stAnnoHandlingRequest
{
	tU8 	u8AnnoState;
	tU8 	u8Source;
	tU16 	u8AnnoType;
};
/*--------------------------------*/
/* class tunmstr_SrcChgManager definition */
/*--------------------------------*/
class tunmstr_SrcChgManager 
{

	template< class T > void vDeleteNoThrow( T*& rfpArg ) throw();
	/* this function must not be used, therefore it is private */
	tunmstr_SrcChgManager& operator=(const tunmstr_SrcChgManager& c);

public:
	tU8 u8ConvertSrcToBand(tU8 u8Source);
	static OSAL_tTimerHandle    _hSysErrorHandelr_Timer;
	enSourcendAction enSrcActivty;

	/*-------------*/
	/* Constructor */
	/*-------------*/
	tunmstr_SrcChgManager( tunmaster_tclApp* poMain );
	tunmstr_SrcChgManager(); //default constructor added to remove lint warning
	/* This function is made public to avoid Prio3 lint warnings. This cannot be called by other functions */
	tunmstr_SrcChgManager(const tunmstr_SrcChgManager& c);


	/*-------------*/
	/* Destructors */
	/*-------------*/
	virtual ~tunmstr_SrcChgManager( );


	// Set pointer to Config.
	tVoid vSet_tunmaster_Config_Ptr( tunmaster_Config* potunmaster_Config );


	// Set pointer tunmstr_MsgFromHMI
	tVoid vSet_tunmstr_MsgFromHMI_Ptr(
			tunmstr_MsgFromHMI* potunmstr_MsgFromHMI
	);

	//Set Pointer to tunmstr_TunerClientHandler
	tVoid vSet_tunmstr_TunerClientHandler_Ptr(
			tunmstr_TunerClientHandler* potunmstr_TunerClientHandler
	);
	//Set Pointer to tunmstr_MsgToHMI
	tVoid vSet_tunmstr_MsgToHMI_Ptr(
			tunmstr_MsgToHMI* potunmstr_MsgToHMI
	);

	//Set Pointer to tunmstr_DABClient_Handler
	tVoid vSet_tunmstr_DABClient_Handler_Ptr(
			tunmstr_DABClient_Handler* potunmstr_DABClient_Handler
	);
	#ifdef AUDIO_ACTIVE

	//Set Pointer to tunmstr_AudioClientHandler
	tVoid vSet_tunmstr_AudioClientHandler_Ptr(
			tunmstr_AudioClientHandler* potunmstr_AudioClientHandler
	);
#endif
	tVoid vSet_tunmaster_tclSPMClient(tunmaster_tclSPMClient* potunmaster_tclSPMClient);

	tVoid vSet_tunmstr_SrcChg_AnnoHandler_Ptr( tunmstr_SrcChg_AnnoHandler* potunmstr_SrcChg_AnnoHandler );
	tVoid vSet_tunmstr_MuteHandler_Ptr(tunmstr_MuteHandler* potunmstr_MuteHandler);

	tVoid vSet_tunmstr_tunmstr_Preset_Handler_Ptr( tunmstr_Preset_Handler* potunmstr_Preset_Handler);

	tBool blCompareBand( const tU8 u8New_Band) const;
	tBool blGetBandFlagStatus()const;
	tBool blGetPresetRecallStatus()const;
	tVoid vSetPresetRecallStatus_DAB(const tBool blStatus);
	tVoid vSetPresetRecallStatus_Tuner(const tBool blStatus);
	tVoid vSetElement_ID(const tU8 u8Element_ID);
	tBool blGetBGTunerMode();
	tVoid vSetBGTunerMode(const tBool blStatus);
	tBool blExtractBandInfo()const;
	tU8   u8GetLastBand()const;
	tVoid vSetLastBand(const tU8 u8Band);
	tVoid vSetExtractBand_Status(const tBool blStatus);
	tU8 u8GetTPSource()const;

	tVoid vSetSourceInfo(const tU8 u8New_Band);	
	tVoid vSetTunerState(const tU8 u8TunerState);
	tVoid vSetDABState(const tU8 u8DABStatus);
	tVoid vSetRemoteControl_Status(const tBool blRemoteSession);
   virtual tU8   u8GetCurrentSource()const;
	tU8   u8CheckRadioSource();
	tVoid vSetBandChg_Flag(const tBool blStatus);

	tBool blGetDABVisibalityStatus()const;
	tU8   u8GetTunAudibleStatus()const;
	tU8   u8GetDABAudibleStatus()const;
	tU8   u8GetTunerState()const;
	tU8   u8GetDABState() const;
	tVoid vSetSDSBand(const tU8 u8Band);
	tU8   u8GetSDSBand()const;
	tVoid vSetDirectFrqRequest_Status(const tBool blStatus);
	tBool blGetDirectFrqRequest_Status()const;
	tVoid vSetBandChgSDS_status(const tBool blStatus);
	tBool blGetBandChgSDS_status() const;
	 tVoid vSetTunAudibleStatus(const tU8 u8Status);
	 tU8 u8GetCurrentTA_Source()const;
	 tBool blGetTestMode_Status()const;
			//Helper functions to Handle Method start sent from Audio and HMI

	tVoid vCheckForSourceChange(amt_tclServiceData* poMessage);
	tVoid vCheckForPreset_Recall( amt_tclServiceData* poMessage);
	tVoid vCheckForBandChange( amt_tclServiceData* poMessage);
	tVoid vCheckForVisibility(amt_tclServiceData* poMessage);
	tVoid vHandleSrcChg_MethodResult_DAB(tU8 u8Result);
	tVoid vCheckForStop_Anno(amt_tclServiceData* poMessage);
	tVoid vCheckForService_Following(tU8 u8SwitchTuner,tBool blSwitch_Recommended);
	tVoid vCheckforFrequencyChange (amt_tclServiceData* poMessage);

	//DRM related functions
	tVoid vSendTunerToFG(tU8 u8Source, enSourcendAction u8Action);
	tVoid vSendTunerToBG(tU8 u8Source, enSourcendAction u8Action);
	enTunmstr_DRMSourceActivity enConvertDRMSrcActValue(enSourcendAction u8Action);

    //From fc_amfmtuner
	tVoid vMethodResult_SrcChg_FrmTuner( tU8 u8Status);
	tVoid vMethodResult_BandChg_FrmTuner( tU8 u8Status);
	tVoid vMethodResult_PresetRecall_FrmTuner( tU8 u8Status ) const;
	tVoid vUpdateBand(tU8 u8Band);
	tVoid vTestMode(amt_tclServiceData* poMessage);
	tVoid vTestMode_SrcChg(amt_tclServiceData* poMessage);
	tVoid vSendCurrentSource_Info(tU8 u8Source);

	// Helper functions To Handle Soucre Change Logic
	tVoid vHandleTunerSrcChg_ON(tU8 u8Source);
	tVoid vHandleTunerSrcChg_PAUSE(tU8 u8Source);
	
	tVoid vHandleTunerSrcChg_OFF(tU8 u8Source);

	tVoid vHandleDABSrcChg_ON(tU8 u8Source);
	tVoid vHandleDABSrcChg_PAUSE(tU8 u8Source);
	tVoid vHandleDABSrcChg_OFF(tU8 u8Source);

	tVoid vHandleAnnoSrc_ON(tU8 u8Source);
	tVoid vHandleAnnoSrc_PAUSE(tU8 u8Source);
	tVoid vHandleAnnoSrc_OFF(tU8 u8Source);


	tVoid vHandleTunerSrcChg_ON_and_Visible(tU8 u8Source);
	tVoid vHandleTunerSrcChg_OFF_and_Visible(tU8 u8Source);
	tVoid vHandleDABSrcChg_OFF_and_Visible(tU8 u8Source);
	tVoid vSendDABToFG(tU8 u8Source);
	tVoid vSendDAB_SFToFG();

	// Timer related functions

	static OSAL_tpfCallback vTimeOut_Responce_TimerCallBack(tVoid*);
	tVoid vClearRadioStates();
	tVoid vClearDABStates();

	tVoid vHandleTunerServiceUnavil();
	tBool blGetVisibleInfo_ReceivedFlag();
	tVoid vSetVisibleInfo_ReceivedFlag(tBool blVisibleInfoFlag);
	tVoid vStoreSource_FMTAActive();
	tVoid vStoreSource_DABTAActive();
	tBool blIsFMTAActive()const;
	tVoid vUpdateAnnoHandlingRequest(tU8 u8AnnoState, tU8 u8Source , tU16 u16AnnoType);

	tVoid vHandleTunerStateInProgress(tU8 u8Source,tU8 u8SrcActivity);
	tVoid vHandleDABStateInProgress(tU8 u8Source,tU8 u8SrcActivity);

	tVoid vHandleDABTempAnnouncement();
	tVoid vUpdateDAB_SrcState();

	tU16  u16GetAnnoInfoPI()const;
	tVoid vSetAnnoInfoPI(tU16 u16PI);
	tU8 u8GetActionFromenSourcendAction()const;


	tU8    m_u8InProgSource;
	tU8    m_u8InProgSrcActivity;
	tU8    m_u8InProgDABSource;
	tU8    m_u8InProgDABSrcActivity;
	tU16   m_u16PI;


	stAnnoHandlingRequest m_AnnoHandlingRequest;

private:

	// Pointer to main fc_TunerMaster application class.
	tunmaster_tclApp*   poGWMain;

	// Pointer to class tunmaster_Config.
	tunmaster_Config*      m_potunmaster_Config;

	// Pointer to class tunmstr_TunerClientHandler.
	tunmstr_TunerClientHandler* m_potunmstr_TunerClientHandler;

	//Pointer to classtunmstr_MsgFromHMI
	tunmstr_MsgFromHMI* m_potunmstr_MsgFromHMI;

	//Pointer to class tunmstr_MsgToHMI
	tunmstr_MsgToHMI* m_potunmstr_MsgToHMI;

	//Pointer to class tunmstr_DABClientHandler
	tunmstr_DABClient_Handler* m_potunmstr_DABClient_Handler;

	// Pointer to class tunmstr_SrcChg_AnnoHandler
	 tunmstr_SrcChg_AnnoHandler* m_potunmstr_SrcChg_AnnoHandler;
#ifdef AUDIO_ACTIVE
	//Pointer to class tunmstr_DABClientHandler
	tunmstr_AudioClientHandler* m_potunmstr_AudioClientHandler;
#endif
	tunmaster_tclSPMClient*			m_ptunmaster_tclSPMClient;
	tunmstr_Preset_Handler* m_potunmstr_Preset_Handler;

	tunmstr_MuteHandler* m_potunmstr_MuteHandler;
	//Variables

	tBool m_blBandChangeFlag;
	tBool m_blPresetChangeFlag_Tuner;
	tBool m_blPresetChangeFlag_DAB;
	tBool m_blTun_Header;


	tU8   m_u8ActiveSource;
	tU8   m_u8Element_ID;
	tU8   m_u8CurrentTunerState;
	tU8   m_u8TunAudibaleStatus;
	tBool m_blDABVisibleStatus;
	tBool m_blDABAudibleStatus;
	tU8   m_u8DABState;
	tU8   m_u8DABAudibaleStatus;
	tU8  m_u8Current_TASource;
	tU8   m_u8Current_TAAction;

	tBool m_blTestMode;
	tBool m_blRemoteSession_Active;
	tBool m_blExtarctBandValue;
	tU8   m_u8PreviousBand;
	tU8   m_u8SDS_Band;
	tBool m_blFrq_Requested;
	tBool m_blBandChg_Requested;

	/*Flags to handle ADR3 reset timer */
	tBool m_blErrHandlr_TmrCreated;
	// this flag is added only to fix JIRA issue NIKAI 5689

	tVoid vGetDataFromAmt(amt_tclServiceData* poFIMsg,fi_tclTypeBase &oFIData)const;

	//Helper Functions to Handle SrcChg logic FM:
	tVoid vHandleTuner_ON_FG(tU8 u8RequestedSource);
	tVoid vHandleTuner_ON_BG(tU8 u8RequestedSource);
	tVoid vSetInprogmemberVariables(tU8 u8Source,tU8 u8SrcActivity);
	tVoid vSetInprogDABmemberVariables(tU8 u8Source,tU8 u8SrcActivity);

	//Helper Functions to Handle SrcChg logic DAB:
	tVoid vHandleDAB_ON_FG(tU8 u8Source);
	tVoid vHandleDAB_ON_BG(tU8 u8Source);

	//Helper Functions to Handle SrcChg logic DAB:
	tVoid vHandleOtherSrc_ON_FG(tU8 u8Source);
	tVoid vHandleOtherSrc_ON_BG(tU8 u8Source);
	tU8 u8GetSourceFromenSourcendAction()const;
	enSourcendAction enConvertSrcForPause(tU8 u8Source)const;
	enSourcendAction enConvertSrcForON(tU8 u8Source)const;
	enSourcendAction enConvertSrcForOFF(tU8 u8Source)const;
	tVoid vHandleCriticalVg(tU8 u8Source,tU8 u8Action);
	tVoid vhandleTunerpAUSE(tU8 u8Source);
	tVoid vHandleFMTAFGBGMethodResult();

	// functiosn to handle Timer
	tVoid vInitializeErrHandlr_Timer(tU32 u32TimerValue) const ;
	tVoid vCreateTimer();
	tVoid vDeleteTimer();

};

#endif // tunmstr_SrcChgManager_H
