/************************************************************************
 * FILE:           tunmstr_SDSHandler.h
 * PROJECT:        G3g
 * SW-COMPONENT:   FC_TunerMaster.
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:    header contents of tunmstr_SDSHandler
 *
 *----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY: 
 * Date			 | Author					| Modification
 * 		     	 | auj1kor					| initial version
 *************************************************************************/

#ifndef TUNMSTR_SDSHANDLER_H_
#define TUNMSTR_SDSHANDLER_H_

#ifdef VARIANT_S_FTR_ENABLE_AIL_MOCK
#include "amt_mock/amt_if.h"
#else
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifdef VARIANT_S_FTR_ENABLE_AHL_MOCK
#include "ahl_mock/ahl_if.h"
#else
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#endif

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
#include "sessionManagement/clSessionControl.h"
#include "sessionManagement/clArlSourceImpl.h"
#include "datatypes/tunerDatatypes.h"
using namespace tuner::sessionManagement::audio;
#endif

#ifndef TUNMASTER_CLASS_FORWARD_DECL_H
#include "tunermaster_Class_ForwardDecl.h"
#endif

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


struct stSDSTunerReguest
{
	tU8 	u8Option;
	tU8 	u8Band;
	tU32	u32Frequency;
	tU8 	u8ElemID;
	tU8 	u8ListID;
	tU32 	u32PI;
	tU16    u16SecondaryPI;
	tU8  	u8HDProgramNumber;
};

class clConfigInterface;

class tunmstr_SDSHandler
{
private:

	tunmstr_MsgFromHMI* m_potunmstr_MsgFromHMI;
	tunmstr_SrcChgManager* m_potunmstr_SrcChgManager;
	tunmstr_TunerClientHandler* m_potunmstr_TunerClientHandler;
	tunmstr_DABClient_Handler* m_potunmstr_DABClient_Handler;
	tunmstr_Preset_Handler* m_potunmstr_Preset_Handler;
	clConfigInterface* m_poclConfigInterface;
	tunmstr_MsgToHMI* m_potunmstr_MsgToHMI;
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	tunermaster_SXMClient* m_potunermaster_SXMClient;
#endif

	tU16 m_u16RegID;
	tU16 m_u16CmdCntr;
	tU16 m_u16SourceAppID;
	tU8 m_u8BandReqFromHMI;

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	tuner::sessionManagement::audio::clArlSourceImpl* m_poArlImpl;
	tU8	vConvertSessionBand(tU8 u8Band);
	tVoid vHandleStationSelctionByStationName(tU8 u8ModulationType);
	tVoid vHandleDirectFrequency();
	tVoid vHandleHDStationSelection();
	tVoid vHandleDRMStationSelection();
	tVoid vClearSDSRequestParams();
	tBool bCheckReqChangeLSM();
    tVoid vHandleStationSelctionByPresetNumber();
    tVoid vHandleDABPresetSelect();
    tVoid vHandleTunerPresetSelect();
    tVoid vHandleDABStationNameSelect();
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
    tVoid vHandleSXMPresetSelect();
    tVoid vHandleSXMStationNameSelect();
#endif
#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
    tVoid vHandleSXM360LPresetSelect();
#endif
    tVoid vSendMethodResult(tU8 u8Source , tU8 u8Action , tU8 u8ResultStatus = (tU8)midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED);
#endif

public:

	stSDSTunerReguest m_rSDSTunerRequest;
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	tunmstr_SDSHandler(tuner::sessionManagement::audio::clArlSourceImpl* poArlImpl);
	   	tVoid vHandleStationSelection(amt_tclServiceData* poMessage);
		tBool bIsFrequencyWithinTheRange(tU8 u8Band, tU32 u32Frequency)const;
#else
	tunmstr_SDSHandler();
#endif

	virtual ~tunmstr_SDSHandler();

	tVoid vSet_tunmstr_MsgFromHMI_Ptr( tunmstr_MsgFromHMI* potunmstr_MsgFromHMI );
	tVoid vSet_tunmstr_SrcChgManager_Ptr( tunmstr_SrcChgManager* potunmstr_SrcChgManager );
	tVoid vSet_tunmstr_TunerClientHandler_Ptr(tunmstr_TunerClientHandler* potunmstr_TunerClientHandler);
	tVoid vSet_tunmstr_DABClient_Handler_Ptr(tunmstr_DABClient_Handler* potunmstr_DABClient_Handler);
	tVoid vSet_tunmstr_Preset_Handler_Ptr(tunmstr_Preset_Handler* potunmstr_Preset_Handler);
	tVoid vSet_tunmstr_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface);
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	tVoid vSet_tunmstr_SXMClient_Handler_Ptr(tunermaster_SXMClient* potunermaster_SXMClient);
#endif
	tVoid vSet_tunmstr_MsgToHMI_Ptr( tunmstr_MsgToHMI* potunmstr_MsgToHMI );
};

#endif /* TUNMSTR_SPMHANDLER_H_ */
