/************************************************************************
* FILE:           tunmstr_MuteHandler.h
* PROJECT:        G3g
* SW-COMPONENT:   FC_TunerMaster.
*----------------------------------------------------------------------
*
* DESCRIPTION:    Header contents of tunmstr_MuteHandler.h
*              
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:      
* Date     			  | Author                         | Modification
* Jan 2, 2014 		  | auj1kor    					   | initial version
				
*************************************************************************/

#ifndef TUNMSTR_MUTEHANDLER_H_
#define TUNMSTR_MUTEHANDLER_H_


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#include "ahl_mock/ahl_if.h"
#include "amt_mock/amt_if.h"
#else
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif

#ifndef TUNMASTER_CLASS_FORWARD_DECL_H
#include "tunermaster_Class_ForwardDecl.h"
#endif

#define SRC_DABTA 0x01
#define SRC_DAB 0x00

class tunmstr_MuteHandler
{
	private:
	tunmstr_TunerClientHandler* m_potunmstr_TunerClientHandler;
	tunmstr_AudioClientHandler* m_potunmstr_AudioClientHandler;
	tunmstr_SrcChgManager* m_potunmstr_SrcChgManager;
	tunmstr_MsgFromHMI* m_potunmstr_MsgFromHMI;
	tunmstr_DABClient_Handler* m_potunmstr_DABClient_Handler;
	tunmstr_Preset_Handler* m_ptunmstr_Preset_Handler;
	
	// Mute or De-Mute request to Audio
	tU8 m_u8MuteStatus;
	tU8 m_u8DABMuteStatus;
	
	// Mute or De-Mute response from Audio
	tBool m_bMuteReq;
	tBool m_bDABMuteReq;

	public:
	tunmstr_MuteHandler();
	~tunmstr_MuteHandler();

	tVoid vSet_tunmstr_TunerClientHandler( tunmstr_TunerClientHandler* potunmstr_TunerClientHandler);
	tVoid vSet_tunmstr_AudioClientHandler_Ptr( tunmstr_AudioClientHandler* potunmstr_AudioClientHandler );
	tVoid vSet_tunmstr_SrcChgManager_Ptr( tunmstr_SrcChgManager* potunmstr_SrcChgManager );
	tVoid vSet_tunmstr_MsgFromHMI_Ptr( tunmstr_MsgFromHMI* potunmstr_MsgFromHMI );
	tVoid vSet_tunmstr_DABClient_Handler_Ptr( tunmstr_DABClient_Handler* potunmstr_DABClient_Handler );
	tVoid vSet_tunmstr_Preset_Handler_Ptr(tunmstr_Preset_Handler* potunmstr_Preset_Handler);
	tVoid vHandle_TunerMuteRequest(amt_tclServiceData* poMessage);
	tVoid vSend_TunerMuteRequest();
	tVoid vHandle_DABMuteRequest(amt_tclServiceData* poMessage);
	tVoid vSend_DABMuteRequest(tU8 u8Source);
    tVoid vSend_TunerMuteState(tBool blMuteState);
	tVoid vHandle_TunerStoredRequests();
	tVoid vSend_DABMuteState(tBool blSource,tBool blMuteState);
	tVoid vHandle_DABStoredRequests();
	tVoid vSendTunerDeMute_srcChange();
	tVoid vSendDABDeMute_srcChange();

	// Holds if the current mute/De-Mute request can be interrupted or not
	tBool bMute_Interrupt;
	tBool bDABMute_Interrupt;

};

#endif /* TUNMSTR_MUTEHANDLER_H_ */
