/************************************************************************
 * FILE:           tunmstr_AutoStorehandler.h
 * PROJECT:        g3g
 * SW-COMPONENT:   FC_TunerMaster.
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:   Header content of tunmstr_AutoStorehandler
 *
*              
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      | Author                       | Modification
 * 
 *************************************************************************/



#ifndef tunmstr_AutoStoreHandler_H
#define tunmstr_AutoStoreHandler_H
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#include "midw_fi_if.h"

#ifdef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#include "ahl_mock/ahl_if.h"
#include "amt_mock/amt_if.h"
#else
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_AIL_MOCK
//AMT already included
#else
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"  // use AIL template with MessageMaps
#endif

#include <vector>


#ifdef VARIANT_S_FTR_ENABLE_TUNERMASTER_MOCK
#include "../../utest/Mocks/tunmstr_MsgToHMI.h"
#include "../../utest/Mocks/tunmstr_MsgFromHMI.h"
#include "../../utest/Mocks/tunmstr_SrcChg_Defines.h"
#include "../../utest/Mocks/tunmstr_Preset_Handler.h"
#else
#include "tunmstr_MsgToHMI.h" 
#include "tunmstr_MsgFromHMI.h"
#include "tunmstr_SrcChg_Defines.h"
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
#ifndef tunmstr_Preset_Handler_H
#include "tunmstr_Preset_Handler.h"
#endif
#endif
#endif

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
#include "sessionManagement/clSessionControl.h"
#include "sessionManagement/clArlSourceImpl.h"
#include "datatypes/tunerDatatypes.h"
using namespace tuner::sessionManagement::audio;
#endif

class clConfigInterface;

enum enInitial_AutoStore_Status
{
	TunMstr_InitialAST_Start=0,
	TunMstr_InitialAST_InPrg,
	TunMstr_InitialAST_Complete,
	TunMstr_InitialAST_Invalid = 0xff,
};

class tunmstr_AutoStoreHandler
{
private:
	
	// Member variables
	tU16 m_u16Cmd_Cntr;
	tBool m_blNormalAST_Request ;
	tBool m_blInitialAST_Request;
	tU8 m_u8ASTReq_ListID;
	tBool m_blAst_Status;
	tU8 m_u8Band_BeforeAST;
	
	enInitial_AutoStore_Status m_enInitiaAST_ProgressStatus;
		
	tunmstr_SrcChgManager* m_potunmstr_SrcChgManager;
	tunmstr_MsgFromHMI* m_potunmstr_MsgFromHMI;
	tunmstr_DABClient_Handler *m_potunmstr_DABClient_Handler;
	tunmstr_TunerClientHandler* m_potunmstr_TunerClientHandler;
	tunmaster_Config*      m_potunmaster_Config;
	tunmstr_MsgToHMI* m_potunmstr_MsgToHMI;
	tunmstr_Preset_Handler* m_potunmstr_Preset_Handler;
	clConfigInterface* m_poclConfigInterface;

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	tuner::sessionManagement::audio::clArlSourceImpl* m_poArlImpl;
#endif
	
	tVoid vHandleNormal_AST(tBool blAst_Start , tU8 u8ListID);
    tVoid vHandleInitial_AST(tBool blAST_Start);
	tU16 m_u16ASTRegId;
	
public:
	/*-------------*/
	/* Constructor */
	/*-------------*/
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	tunmstr_AutoStoreHandler(tuner::sessionManagement::audio::clArlSourceImpl* poArlImpl);
#else
	tunmstr_AutoStoreHandler();
#endif
	
	//Distructor
	~tunmstr_AutoStoreHandler();
	
	// Helper Functions
	tVoid vHandle_ASTRequest(tBool blAST_Start, tU8 u8ListID, tU8 u8Type);
	tBool blGetNormalAST_Request()const;
	tBool m_blGetInitalAST_Request()const;
	tU8 u8ConvertList2Source(tU8 u8ListID)const;
	tBool blGetAST_Status()const;
    tU8 u8GetAST_Type() const;
	tU8 u8GetAST_ListID()const;
	
	tVoid vSetNormalAST_Status(tBool blStatue);
	tVoid vSetInitialAST_Status(tBool blStatus);
	tVoid vSetAST_ListID(tU8 u8ListID);
    tVoid vSetAST_Status(tBool blStatus);

	enInitial_AutoStore_Status enGetInitialAST_ProgressStatus()const;
	tVoid vSetInitialAST_ProgressStatus(enInitial_AutoStore_Status enStatus);
	tU8 u8GetInitialAST_Counter()const;

	tVoid vSetCmd_Cntr(tU16 u16Cmd_Cntr);
	tU16 u16GetCMd_Cntr()const;  

	// Pointer creation	
	tVoid vSet_tunmstr_SrcChgManager_Ptr(tunmstr_SrcChgManager* potunmstr_SrcChgManager);
	tVoid vSet_tunmstr_MsgFromHMI_Ptr( tunmstr_MsgFromHMI* potunmstr_MsgFromHMI );
	tVoid vSet_tunmstr_DABClient_Handler_Ptr( tunmstr_DABClient_Handler* potunmstr_DABClient_Handler );
	tVoid vSet_tunmstr_TunerClientHandler( tunmstr_TunerClientHandler* potunmstr_TunerClientHandler);
	tVoid vSet_tunmaster_Config_Ptr( tunmaster_Config* potunmaster_Config );
	tVoid vSet_tunmstr_MsgToHMI_Ptr( tunmstr_MsgToHMI* potunmstr_MsgToHMI );
	tVoid vSet_tunmstr_Preset_Handler_Ptr( tunmstr_Preset_Handler* potunmstr_Preset_Handler);
	tVoid vSet_tunmstr_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface);

    tVoid vHandleResult_ForInitialAST();
    tVoid vHandleResult_ForNormalAST();
	tU16 u16GetASTRegId()const;
	tVoid vSetAstRegID(tU16 u16RegId);
	tVoid vSendAutoStoreReq(enAutostoreBank oenAutostoreBank);
	


};
#endif
