/************************************************************************
 * FILE:           tunmstr_AudioClientHandler.h
 * PROJECT:        G3g
 * SW-COMPONENT:   FC_TunerMaster.
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:    CCA messages sent to FC_TIMA are implemented in this file.
 *
*              
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
 * HISTORY:
 * Date      | Author                       | Modification
 * 11-10-10  | CM-AI/PJ-VW36 Pallavi HN     | initial version
 *
 *************************************************************************/


#ifndef tunmstr_AudioClientHandler_H
#define tunmstr_AudioClientHandler_H

#ifdef VARIANT_S_FTR_ENABLE_AIL_MOCK
#include "amt_mock/amt_if.h"
#else
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif


#ifdef VARIANT_S_FTR_ENABLE_AHL_MOCK
#include "ahl_mock/ahl_if.h"
#else
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#endif

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
//Amt Ahl mocks already included
#else
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif

#ifdef AUDIO_ACTIVE
#ifdef VARIANT_S_FTR_ENABLE_ARL_MOCK
#include "arl_mock/arl_if.h"
#else
#define ARL_S_IMPORT_INTERFACE_GENERIC_AIL
#include "audio_routing_lib.h"
#endif
#endif

#ifdef VARIANT_S_FTR_ENABLE_TUNERMASTER_MOCK
#include "../../utest/Mocks/tunmstr_Preset_Handler.h"
#else
#ifndef tunmstr_Preset_Handler_H
#include "tunmstr_Preset_Handler.h"
#endif
#ifndef TUNMASTER_CLASS_FORWARD_DECL_H
#include "tunermaster_Class_ForwardDecl.h"
#endif
#endif
//---------------------------------


//using namespace std;


/*--------------------------------*/
/* class tunmstr_AudioClientHandler definition */
/*--------------------------------*/
struct stMuteRequest
{
	arl_tenSource enSrcNum;
	arl_tenMuteAction enMuteState;
	arl_enMuteReason  enmuteReason;
};
//class tunmstr_AudioClientHandler;
class clConfigInterface;

class tunmstr_AudioClientHandler:public arl_tclISource_AIL
{


public:
	typedef enum
	{
		AUDIO_PLAY = 0,
		AUDIO_PAUSE,
		AUDIO_STOP
	} TUNMSTR_Audio_Activity;
	/*-------------*/
	/* Constructor */
	/*-------------*/
	tunmstr_AudioClientHandler( tunmaster_tclApp* poMain );
	// tunmstr_AudioClientHandler( tunmstr_AudioClientHandler* poMain );

	tunmstr_AudioClientHandler(); //default constructor added to remove lint warning
	/* This function is made public to avoid Prio3 lint warnings. This cannot be called by other functions */
	tunmstr_AudioClientHandler(const ail_tclAppInterface& c);


	/*-------------*/
	/* Destructors */
	/*-------------*/
	virtual ~tunmstr_AudioClientHandler( );


	// Get pointer to class tunmstr_SrcChgManager
	tVoid vSet_tunmstr_SrcChgManager_Ptr(
			tunmstr_SrcChgManager* potunmstr_SrcChgManager
	);

	//Set Pointer to tunmstr_DABClient_Handler
	tVoid vSet_tunmstr_DABClient_Handler_Ptr(
			tunmstr_DABClient_Handler* potunmstr_DABClient_Handler
	);
	tVoid vSet_tunmaster_Config_Ptr(tunmaster_Config* potunmaster_Config);

	tVoid vSet_tunmstr_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface);

	//Set Pointer to tunmstr_DABClient_Handler
		tVoid vSet_tunmstr_TunerClient_Handler_Ptr(
				tunmstr_TunerClientHandler* potunmstr_TunerClient_Handler
		);
		tVoid vSet_tunmaster_tclApp_Handler_Ptr(
				tunmaster_tclApp* potunmaster_tclApp
		);
	tVoid vSet_tunmstr_tunmstr_Preset_Handler_Ptr(tunmstr_Preset_Handler* potunmstr_Preset_Handler);
	tVoid vSet_tunmstr_SrcChg_AnnoHandler_Ptr(tunmstr_SrcChg_AnnoHandler* potunmstr_SrcChg_AnnoHandler);
	tVoid vSet_tunmstr_MuteHandler_Ptr(tunmstr_MuteHandler* potunmstr_MuteHandler);
	/* Method Result FID_TUNMSTR_S_SOURCE_CHANGE */
	virtual tBool bOnSrcActivity(arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity);
	virtual tBool bOnMuteState(arl_tenSource enSrcNum, arl_tenMuteState enMuteState);
  
	//virtual tVoid vSetSrcAvailable(tBool bSrcAvail = TRUE);
	//virtual tBool bSetAudioRouteRequest(arl_tenSource enSource, arl_tenActivity enRequest, audioroutinglib::arl_tclBitmask<arl_enRouteReqReason> Reason = ARL_EN_ROUTEREQ_REASON_OTHER);
	// This function is used to send Source chnage request for TA use cases.

	/**allocate and deallocate functions are used for DRM player*/
	virtual tBool bOnDeAllocate(arl_tenSource enSrcNum);
	virtual tBool bOnAllocate(arl_tenSource enSrcNum, const arl_tAllocRouteResult& rfcoAllocRoute);
    tVoid vCheckDRMSourceAvailability();

	tVoid vSendResult_ToLib(arl_tenSource enSrcNum , tU8 u8Action);
	tVoid vSendSourceavailability(arl_tenSource enSrcNum,arl_tenSrcAvailability enSrcAvail,arl_tenAvailabilityReason enAvailabilityReason);
	tU8 u8MapAuidoSources(const arl_tenSource enSrcNum)const;
	arl_tenSource u8MapTunmstrSources(const tU8 u8Source)const;

	tVoid  vHandleDABMuteState(tBool blSource, tBool blState);

	tVoid vHandleSrcReq_ServiceUnavail(arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity);
	tVoid vSetSrcReq_ServiceUnavail(arl_tenSource enSrcNum) ;
	tVoid vSetSrcReq_ServiceUnavail(tU8 u8Source);
	tU8 u8GetSrcReq_ServiceUnavail();
	tVoid vSetSrcActivity_ServiceUnavail(tU8 u8SrcActivity) ;
	tU8 u8GetSrcActivity_ServiceUnavail();
	arl_tenSource enConvertFiSourcetoArlSrc(tU8 u8Band)const;
	tVoid vSendMuteState(arl_tenSource enSrc,arl_tenMuteAction enMuteAction,arl_enMuteReason enMuteReason);
	tVoid vStoreMuteParameter(arl_tenSource enSrc, arl_tenMuteAction enMuteAction,arl_enMuteReason enMuteReason);
	tVoid vSendDemuteRequest();
	tVoid vHandleANNOSrcChg_Request(tU8 u8Anno_Source, tU8 u8Action);
	tVoid vCheckTunerSourceavailability();
	tBool blCheckForSrvAva(arl_tenSource enSrcNum)const;
	tVoid vHandleTTFiS_CMD(const tU8* u8DataSpecial);

private:

	// Pointer to main fc_Tmctuner application class.
	tunmaster_tclApp*   poGWMain;


	// Pointer to class tunmstr_SrcChgManager.
	tunmstr_SrcChgManager*	  m_potunmstr_SrcChgManager;

	//Pointer to class tunmstr_DABClientHandler
	tunmstr_DABClient_Handler* m_potunmstr_DABClient_Handler;

	//Pointer to class tunmstr_DABClientHandler
	tunmstr_TunerClientHandler* m_potunmstr_TunerClient_Handler;
	tunmaster_tclApp* m_potunmstr_tunmaster_tclApp;

	tunmstr_Preset_Handler* m_potunmstr_Preset_Handler;
	tunmaster_Config*	m_potunmaster_Config;
	clConfigInterface* m_poclConfigInterface;
	tU8 m_u8SrcReq_ServiceUnavail;
	tU8 m_u8SrcActivity_ServiceUnavail;
	stMuteRequest m_ostMuteRequest;
	tunmstr_SrcChg_AnnoHandler* m_potunmstr_SrcChg_AnnoHandler;
	tunmstr_MuteHandler* m_potunmstr_MuteHandler;
	tBool m_blEnableDRMSource;

	tBool blConvertMuteSource(const arl_tenSource enSrcNum)const;
	tBool blConvertMuteStates(const arl_tenMuteState enMute)const;
	tVoid vSrcActivity_TunerSource(arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity);
	tVoid vSrcActivity_DABSource(arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity);
	tVoid vSrcActivity_TASource(arl_tenSource enSrcNum, const arl_tSrcActivity& rfcoSrcActivity);

};


#endif // tunmstr_AudioClientHandler_H
