/************************************************************************
* FILE:           tunmaster_Utility.cpp
* PROJECT:        G3g
* SW-COMPONENT: 
*----------------------------------------------------------------------
*
* DESCRIPTION:    Tuner Utility tasks are done .
*              
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------

* HISTORY:      
* Date      | Author                       | Modification
* 06/10/10  | CM-AI/PJ-VW36 ( RBEI ) Pallavi HN   | initial version
* 25.04.13  | NGP1KOR    | First version of the G3g after porting 
				from NISSAN LCN2Kai
*************************************************************************/


#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"




#include "tunermaster_utility.h"

/*------------------------------*/
/* Utility functions            */
/*------------------------------*/

/*************************************************************************
*
* FUNCTION:     tunmaster_Utility::vConvert16BitTo2SeparateBytes( )
* 
* DESCRIPTION:  
*
* PARAMETER:    
*
* RETURNVALUE:  
*
*************************************************************************/
tVoid tunmaster_Utility::vConvert16BitTo2SeparateBytes( tU8* pu8Message, tU16 u16Frequency )const
{
   pu8Message[0] = (tU8) (  u16Frequency & 0x00ff);
   pu8Message[1] = (tU8) (( u16Frequency & 0xff00) >> 8  );
 
}

/*************************************************************************
*
* FUNCTION:     tunmaster_Utility::u16Convert2SeparateBytesTo16Bit( )
* 
* DESCRIPTION:  
*
* PARAMETER:    
*
* RETURNVALUE:  
*
*************************************************************************/
tU16  tunmaster_Utility::u16Convert2SeparateBytesTo16Bit( const tU8* pu8NewData )const
{ 
    tU16 u16Frequency;

    u16Frequency =  ( tU16 ) (   (tU16)  pu8NewData[0]  );
    u16Frequency |= ( tU16 ) ( ( (tU16)  pu8NewData[1]  ) << 8  ) ;
    
    
    return u16Frequency;
}


/*************************************************************************
*
* FUNCTION:     tunmaster_Utility::vConvert32BitTo4SeparateBytes( )
* 
* DESCRIPTION:  
*
* PARAMETER:    
*
* RETURNVALUE:  
*
*************************************************************************/
tVoid tunmaster_Utility::vConvert32BitTo4SeparateBytes( tU8* pu8Message, tU32 u32Frequency )const
{ 
    
    pu8Message[0] = (tU8) (  u32Frequency & 0x000000ff);
    pu8Message[1] = (tU8) (( u32Frequency & 0x0000ff00) >> 8  );
    pu8Message[2] = (tU8) (( u32Frequency & 0x00ff0000) >> 16 );
    pu8Message[3] = (tU8) (( u32Frequency & 0xff000000) >> 24 );

}

/*************************************************************************
*
* FUNCTION:     tunmaster_Utility::u32Convert4SeparateBytesTo32Bit( )
* 
* DESCRIPTION:  
*
* PARAMETER:    
*
* RETURNVALUE:  
*
*************************************************************************/
tU32 tunmaster_Utility::u32Convert4SeparateBytesTo32Bit( const tU8* pu8NewData )const
{ 
    tU32 u32Frequency;

    u32Frequency =  ( tU32 ) (   (tU32)  pu8NewData[0]  );
    u32Frequency |= ( tU32 ) ( ( (tU32)  pu8NewData[1]  ) << 8  ) ;
    u32Frequency |= ( tU32 ) ( ( (tU32)  pu8NewData[2]  ) << 16 ) ;
    u32Frequency |= ( tU32 ) ( ( (tU32)  pu8NewData[3]  ) << 24 ) ;
    
    return u32Frequency;
}
/*************************************************************************
*
* FUNCTION:     tunmaster_Utility::u32ConvertFromUnicode2UTF8( )
* 
* DESCRIPTION:  Converts the Unicode character to UTF8 character
*
* PARAMETER:    tU16 - Unicode character
*
* RETURNVALUE:  tU32 - UTF8 character.
*
*************************************************************************/
tU32 tunmaster_Utility::u32ConvertFromUnicode2UTF8( tU16 u16UnicodeChar )const
{ 
    tU32 u32UTF8Char = (tU32) TUNERMASTER_INVALID_UTF8_CHAR;

    // If the Unicode character is less than 128(0x7f), equivalent UTF8 is one byte long
    // No conversion is required.
    if( u16UnicodeChar < (tU16) 128 )
    {
      u32UTF8Char = (tU32) u16UnicodeChar;

    }
    // If the Unicode data value is between 128( 0x7f) and 2047 (0x7ff), 
    // equivalent UTF8 is two byte long.
    else if( (u16UnicodeChar >= (tU16) 128) && (u16UnicodeChar <= (tU16) 2047) )
    {
      // Get the UTF8 MSB:
      u32UTF8Char = 192 + (u16UnicodeChar / 64 ); 

      u32UTF8Char = (tU32)(u32UTF8Char << 8);

      // OR with UTF8 LSB:
      u32UTF8Char |= ( 128 + (u16UnicodeChar % 64 ) );

    }
    /* 3 byte UTF 8 character.*/
	// u16UnicodeChar can have the value only from 2048 to 65535 since 2^16 = 65536-1 
    else
    {
      // Get the UTF8 MSB. Byte1 = 224 + (ud div 4096)
      u32UTF8Char = (tU32) 224 + (u16UnicodeChar / 4096 ); 

      u32UTF8Char = (u32UTF8Char << 16);

      // Get the 2nd UTF8 MSB. Byte2 = 128 + ((ud div 64) mod 64)
      tU16 u16TempUTF8Char = (tU16)( (tU16) 128 + ((u16UnicodeChar / 64 ) % 64));

      u16TempUTF8Char = ( tU16 )(u16TempUTF8Char << 8);

      u32UTF8Char |= (tU32) u16TempUTF8Char;

      // Get the LSB. Byte3 = 128 + (ud mod 64)
      u32UTF8Char |= ( 128 + (u16UnicodeChar % 64 ) );
    }
    
    return u32UTF8Char;
}

/*************************************************************************
*
* FUNCTION:     tunmaster_Utility::u16ConvertFromUTF82Unicode( )
* 
* DESCRIPTION:  Converts the UTF8 character to Unicode character
*
* PARAMETER:    tU16 - UTF8 character
*
* RETURNVALUE:  tU16 - Unicode character.
*
*************************************************************************/
tU16 tunmaster_Utility::u16ConvertFromUTF82Unicode( tU8 u8UTF8CharLSB, tU8 u8UTF8CharMSB )const
{ 
    tU16 u16UnicodeChar = TUNERMASTER_INVALID_UNICODE_CHARACTER;

    /* Formula used for converting 2 byte UTF8 character to
       unicode character*/

    u16UnicodeChar = (tU16) ((u8UTF8CharMSB - 192 ) * 64);
 
    u16UnicodeChar = (tU16)(u16UnicodeChar << 8);

    u16UnicodeChar = (tU16)(u16UnicodeChar |(u8UTF8CharLSB - 128));
      
    return u16UnicodeChar;
}

/*************************************************************************
*
* FUNCTION:     tunmaster_Utility::u16ConvertFromUTF82Unicode( )
* 
* DESCRIPTION:  Converts the UTF8 character to Unicode character
*
* PARAMETER:    3- byte of the UTF 8 character.
*
* RETURNVALUE:  tU16 - Unicode character.
*
*************************************************************************/
tU16 tunmaster_Utility::u16ConvertFromUTF82Unicode( tU8 u8UTF8Char1, tU8 u8UTF8Char2, tU8 u8UTF8Char3 )const
{ 
    tU16 u16UnicodeChar = TUNERMASTER_INVALID_UNICODE_CHARACTER;

    /* Formula used for converting 2 byte UTF8 character to
       unicode character*/

    u16UnicodeChar = (tU16) ((u8UTF8Char3 - 224 ) * (tU16) 4096 + (u8UTF8Char2 - 128) * 64 + (u8UTF8Char1 - 128));

    return u16UnicodeChar;
}
