/************************************************************************
* FILE:           tunermaster_Config.cpp
* PROJECT:        G3g
* SW-COMPONENT:
*----------------------------------------------------------------------
*
* DESCRIPTION:    Tuner component specific configuration.
*
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------

* HISTORY:
* Date      	| Author                       	| Modification
* 20.01.05  	| CM-DI/ESA2 ( RBIN ) Dinesh   	| Initial version.
* 25.04.13  	| NGP1KOR    					| First version of the G3g after porting from NISSAN LCN2Kai.
				
*************************************************************************/
 
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#include "announcements/clAudioControl.h"
#include "tunermaster_trace.h"

#include "tunermaster_PrjConfig.h"
#include "tunermaster_Config.h"
#include "tunermaster_defines.h"
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
#include "tunmstr_AudioClientHandler.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
#include "convTables/midwTunerMap.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNMSTR_TRACE_CLASS_TUNMASTERAPP
#include "trcGenProj/Header/tunermaster_config.cpp.trc.h"
#endif
#ifndef tunmstr_antdiag_Manager_H

#include "tunmstr_antdiag_Manager.h"
#endif

#include "kdsconfig/clConfigInterface.h"

#ifndef VARIANT_S_FTR_ENABLE_TUNERMASTER_MOCK
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#include "dp_tuner_if.h"
#endif

/*************************************************************************
 *
 * FUNCTION:     tunmaster_Config::tunmaster_Config( )
 *
 * DESCRIPTION:  Constructor
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tunmaster_Config::tunmaster_Config( )
{
	m_fLandscapeSeekNeeded =FALSE;
	m_fTMC_Server = DIA_KDS_TMC_FM;
    m_potunmstr_Preset_Handler=NULL;
	m_potunmstr_antdiag_Manager=NULL;
	m_potunmstr_AudioClientHandler=NULL;
	m_poclConfigInterface = NULL;
	m_potunmstr_DiaglibListner=NULL;
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	m_poArlSourceImpl=NULL;
#endif
#ifdef  VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
	m_poAnnouncementControl=NULL;
#endif
}
/*************************************************************************
 *
 * FUNCTION:     tunmaster_Config::~tunmaster_Config( )
 *
 * DESCRIPTION:  Destructor
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tunmaster_Config::~tunmaster_Config( )
{
    m_potunmstr_Preset_Handler=NULL;
	m_potunmstr_antdiag_Manager=NULL;
	m_potunmstr_AudioClientHandler=NULL;
	m_poclConfigInterface = NULL;
	m_potunmstr_DiaglibListner=NULL;
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	m_poArlSourceImpl=NULL;
#endif
#ifdef  VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
	m_poAnnouncementControl=NULL;
#endif
}
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
tVoid tunmaster_Config::vSet_tunmstr__ArlSourceImplPtr(tuner::sessionManagement::audio::clArlSourceImpl* poArlSourceImpl)
{
	m_poArlSourceImpl =poArlSourceImpl;
}
#endif
#ifdef  VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
tVoid tunmaster_Config::vSet_tunmstr__AnnouncementControlImplPtr( tuner::announcements::clAnnouncementControl* poAnnouncementControl)
{
	m_poAnnouncementControl=poAnnouncementControl;
}
#endif
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
tVoid tunmaster_Config::vSendSourceAvailabilityAfterConfigDone()
{
	if((NULL==m_poclConfigInterface)||(NULL==m_poArlSourceImpl))
	{
		return;
	}
	tU8 u8Source = ARL_SRC_NONE;
	arl_tenSrcAvailability enSrcAvail=ARL_EN_SRC_NOT_AVAILABLE;
	arl_tenAvailabilityReason enAvailabilityReason=ARL_EN_REASON_SAMEMEDIA;
	tU32 u32Available_band =m_poclConfigInterface->u32GetConfigData("AvailableBands");
	for(u8Source=(tU8)ARL_SRC_AM;u8Source<=(tU8)ARL_SRC_DABTA;u8Source++)
	{
		switch(u8Source)
		{
			case ARL_SRC_AM:
			{
			    #ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
				dp_tclTmcTunerUsrDPAMAvailability oTmcTunerDPAMAvailability ;

				tBool bTmcTunerDPAMAvailStatus = true;
				oTmcTunerDPAMAvailability.s32GetData(bTmcTunerDPAMAvailStatus);
				ETG_TRACE_USR4(( "AMAvailability=%d",bTmcTunerDPAMAvailStatus));
				if(  (m_poclConfigInterface->u32GetConfigData("AvailableBands") &  0x06) && (m_poclConfigInterface->u32GetConfigData("CFGAM")))
				{
					if(bTmcTunerDPAMAvailStatus)
					{
						enSrcAvail=ARL_EN_SRC_PLAYABLE;
					}
				}
				#else
				u32Available_band =m_poclConfigInterface->u32GetConfigData("AvailableBands");
				if((u32Available_band & TUNMSTR_CONFIG_DEFAULT_AVAILABLEBAND_AM_MASKVAL))
				{
					enSrcAvail=ARL_EN_SRC_PLAYABLE;
				}
				#endif
				break;
			}
			case ARL_SRC_DAB:
			case ARL_SRC_DABTA:
			{
				if(m_poclConfigInterface->u32GetConfigData("DABSupported"))
				{
					enSrcAvail=ARL_EN_SRC_PLAYABLE;
				}
				break;
			}
			default:
			{
				break;
			}
		}
		ETG_TRACE_USR4(( "vSendSourceAvailabilityAfterConfigDone() source =%d availability =%d reason=%d",u8Source,enSrcAvail,enAvailabilityReason));
		m_poArlSourceImpl->vUpdateAudioSourceAvailabelStatus((arl_tenSource)u8Source,enSrcAvail,enAvailabilityReason);
	}
	u8Source = ARL_SRC_DRM;
	enSrcAvail=ARL_EN_SRC_NOT_AVAILABLE;
	if(m_poclConfigInterface->u32GetConfigData("DRMSupported"))
	{
			enSrcAvail = ARL_EN_SRC_PLAYABLE;
	}
	m_poArlSourceImpl->vUpdateAudioSourceAvailabelStatus((arl_tenSource)u8Source,enSrcAvail,enAvailabilityReason);
	u8Source = ARL_SRC_AMTI;
	enSrcAvail=ARL_EN_SRC_NOT_AVAILABLE;
	if((u32Available_band & TUNMSTR_CONFIG_DEFAULT_AVAILABLEBAND_TRF_MASKVAL))
	{
			enSrcAvail = ARL_EN_SRC_PLAYABLE;
	}
	m_poArlSourceImpl->vUpdateAudioSourceAvailabelStatus((arl_tenSource)u8Source,enSrcAvail,enAvailabilityReason);
	u8Source = ARL_SRC_WX;
	enSrcAvail=ARL_EN_SRC_NOT_AVAILABLE;
	if((u32Available_band & TUNMSTR_CONFIG_DEFAULT_AVAILABLEBAND_WB_MASKVAL))
	{
			enSrcAvail = ARL_EN_SRC_PLAYABLE;
	}
	m_poArlSourceImpl->vUpdateAudioSourceAvailabelStatus((arl_tenSource)u8Source,enSrcAvail,enAvailabilityReason);
	m_poArlSourceImpl->vUpdateAudioSourceAvailabelStatus(arl_tenSource::ARL_SRC_WX_ALERT,enSrcAvail,enAvailabilityReason);
}
#endif
/*****************************************************************************
 * Constructor
 ****************************************************************************/
tunmstr_trKdsCMVariantCodingParameter::tunmstr_trKdsCMVariantCodingParameter( tVoid )
{
   ETG_TRACE_USR1((" tunmstr_trKdsCMVariantCodingParameter::tunmstr_trKdsCMVariantCodingParameter() -> Constructor "));
   tunmstr_trKdsCMVariantCodingParameter::vSetToDefaultValues();
}

/*****************************************************************************
 * Set all KDS values to default
 ****************************************************************************/
tVoid tunmstr_trKdsCMVariantCodingParameter::vSetToDefaultValues( tVoid)
{
   ETG_TRACE_USR1((" tunmstr_trKdsCMVariantCodingParameter::vSetToDefaultValues() -> u8HWAssemblyInfo3"));
   u8HWAssemblyInfo3 = TUNMSTR_CONFIG_DEFAULT_HWASSEMBLYINFO3;
   m_blDABAvail = TUNMSTR_CONFIG_DEFAULT_DABAVAIL;
   m_bIs3FrontEndTuner = false;
}
/*************************************************************************
 * FUNCTION:	vReadKDSCMVariantCoding()
 *
 * DESCRIPTION: Read CM_CONFIG_STRING parameters
 *
 * PARAMETER:	tVoid
 *
 * RETURNVALUE: tVoid
 *************************************************************************/
tVoid tunmaster_Config::vReadKDSCMVariantCoding()
{
/* mhv6kor commented as this is a unused code to solve coverity
	OSAL_tIODescriptor IOKdsHandle;
	IOKdsHandle    = OSAL_ERROR;
	//Open the KDS device before reading it
	IOKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
	if( OSAL_ERROR == IOKdsHandle )
	{
		ETG_TRACE_USR4(( " vReadKDSCMVariantCoding()->Error in Opening the KDS "));
		OSAL_s32IOClose(IOKdsHandle);
		return;
	}
	tsKDSEntry sKDSEntryData;
	sKDSEntryData.u16Entry       = DIA_C_U16_KDS_CM_CONFIG_STRING;
	sKDSEntryData.u16EntryLength = DIA_C_U16_KDS_CM_CONFIG_STRING_LEN;
	sKDSEntryData.u16EntryFlags  = M_KDS_ENTRY_FLAG_NONE;
	sKDSEntryData.au8EntryData[0]= 0;
	tS32 s32RetVal = OSAL_s32IORead(IOKdsHandle,(tPS8)&sKDSEntryData, sizeof(sKDSEntryData));
	if( OSAL_ERROR != s32RetVal )
	{
		m_rKdsCMVariantCodingParameter.vParse(sKDSEntryData.au8EntryData,TUNMSTR_CONFIG_NEW_KDS_CM_VARIANT_CODING_LENGTH);
      m_rKdsCMVariantCodingParameter.vTrace();

		OSAL_s32IOClose(IOKdsHandle);
		IOKdsHandle = OSAL_ERROR;
	}
	vReadKDSVariantCodingPSAParameters();
	vReadKDSSystemInfoCommonIVIParameters();
	if(OSAL_ERROR != IOKdsHandle)
	{
		OSAL_s32IOClose(IOKdsHandle);
	}
*/
}//end of the function

/*************
 *
 */
tVoid tunmaster_Config::vReadKDSSystemInfoCommonIVIParameters()
{
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
#ifdef	DP_U16_KDSADR_SYSTEMCONFIGURATION1
	if(m_rKdsCMVariantCodingParameter.m_blDABAvail)
	{
		dp_tclKdsSystemConfiguration1 oKdsSystemConfig;
		oKdsSystemConfig.u8GetDAB(m_rKdsCMVariantCodingParameter.m_blDABAvail);
		ETG_TRACE_USR1(( " vReadKDSSystemInfoCommonIVIParameters:: m_blDABAvail=%d",m_rKdsCMVariantCodingParameter.m_blDABAvail));
	}
#endif
#endif
}
tVoid tunmaster_Config::vReadKDSVariantCodingPSAParameters()
{
	ETG_TRACE_USR1(( " tunmaster_Config::vReadKDSVariantCodingPSAParameters()\n"));
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
#ifdef DP_U16_KDSADR_TEL_FCT_RADIONUM
	tU8 pu8Data[TUNMSTR_CONFIG_NEW_KDS_EOL_CONFIG_RADIONUM_PARAMETER_LENGTH];

	dp_tclKdsTEL_Fct_RADIONUM oDp_TEL_Fct_RADIONUM;

	/** Read from Data pool into local array */
	tU8 u8KdsReadReturnValue = oDp_TEL_Fct_RADIONUM.u8GetTEL_Fct_RADIONUM(pu8Data,DP_U8_KDSLEN_TEL_FCT_RADIONUM_COMPLETE);

	if(u8KdsReadReturnValue == DP_U8_ELEM_STATUS_VALID)
	{
		tU8 u8DpReadStatus = 0xFF;
		if(m_rKdsCMVariantCodingParameter.m_blDABAvail)
		{
		u8DpReadStatus = oDp_TEL_Fct_RADIONUM.u8GetRADIONUMBandActivation(m_rKdsCMVariantCodingParameter.m_blDABAvail);
			ETG_TRACE_USR1(( " vReadKDSVariantCodingPSAParameters:: m_blDABAvail=%d",m_rKdsCMVariantCodingParameter.m_blDABAvail));
		}
		ETG_TRACE_USR2(( " DAB avail read status : %d" , u8DpReadStatus));

	}
#endif
#endif
	return;
}
/*****************************************************************************
 *
 ****************************************************************************/
tVoid tunmstr_trKdsCMVariantCodingParameter::vParse( tPU8 pu8KdsBuffer, tU32 u32Length)
{


  ETG_TRACE_USR1(( " tunmstr_trKdsCMVariantCodingParameter::vParse() -> u32Length  : %d bytes\n",u32Length));

  if( u32Length < TUNMSTR_CONFIG_NEW_KDS_CM_VARIANT_CODING_LENGTH)
  {
    ETG_TRACE_ERR(( " tunmstr_trKdsFmAmTunerParameter::vParse() -> Error: wrong length of KDS entry, default values are used now!\n"
                     " u32Length                   : %d bytes\n"
                     " KDS config                  : %d bytes\n"
                     " expected                    : %d bytes\n"
                     ,u32Length
                     ,32
                     ,TUNMSTR_CONFIG_NEW_KDS_CM_VARIANT_CODING_LENGTH
                  ));
  }
  else
  {
     u8HWAssemblyInfo3                = pu8KdsBuffer[ enKdsCMVariantCoding_idx_HWAssemblyInfo3];
     m_blDABAvail                     = (tBool)((pu8KdsBuffer[4]& 0x20)>>5);
     m_bIs3FrontEndTuner              =((pu8KdsBuffer[5]& 0x14) || (pu8KdsBuffer[5]& 0x27));
     ETG_TRACE_USR2((" tunmstr_trKdsCMVariantCodingParameter::vParse() DABAvailable = %d", m_blDABAvail));
     ETG_TRACE_USR1(( " tunmstr_trKdsCMVariantCodingParameter::vParse() -> m_bIs3FrontEndTuner  : %d\n",m_bIs3FrontEndTuner));
#ifdef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
#ifdef VARIANT_S_FTR_ENABLE_DAB_SURVEILLANCE
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_SUZUKI
	 tuner::announcements::clAnnouncementSettings::instance()->vSetAnnouncementSurvivellenceModeSupport(tuner::common::FM1, m_bIs3FrontEndTuner);
	 tuner::announcements::clAnnouncementSettings::instance()->vSetAnnouncementSurvivellenceModeSupport(tuner::common::AM, m_bIs3FrontEndTuner);
	 tuner::announcements::clAnnouncementSettings::instance()->vSetAnnouncementSurvivellenceModeSupport(tuner::common::SOURCEID_LIMIT, m_bIs3FrontEndTuner);
#else
	 tuner::announcements::clAnnouncementSettings::instance()->vSetAnnouncementSurvivellenceModeSupport(tuner::common::FM1, bIsDABForeGroundAnnouncementSurvivellenceModeSupport(tuner::common::FM1));
	 tuner::announcements::clAnnouncementSettings::instance()->vSetAnnouncementSurvivellenceModeSupport(tuner::common::AM, bIsDABForeGroundAnnouncementSurvivellenceModeSupport(tuner::common::AM));
	 tuner::announcements::clAnnouncementSettings::instance()->vSetAnnouncementSurvivellenceModeSupport(tuner::common::SOURCEID_LIMIT, bIsDABForeGroundAnnouncementSurvivellenceModeSupport(tuner::common::SOURCEID_LIMIT));
#endif
#endif
#endif
  }
}

/*****************************************************************************
 *
 ****************************************************************************/
tVoid tunmstr_trKdsCMVariantCodingParameter::vTrace( tVoid)
{
  if( etg_bIsTraceActiveShort(((0xFFFFu & (tU16)TUNMSTR_TRACE_CLASS_TUNMASTERAPP) << 16) | (tU16)TR_LEVEL_USER_2) == TRUE)
  {

    ETG_TRACE_USR2(( " BEGIN ------------------------------------------------------------------------------------"             ));
    ETG_TRACE_USR2(( " u8HWAssemblyInfo3              : %d "    ,u8HWAssemblyInfo3                              ));
    ETG_TRACE_USR2(( " m_blDABAvail                          : %d "    ,m_blDABAvail                                           ));
    ETG_TRACE_USR2(( " END   --------------------------------------------------------------------------------------"            ));
  }
}
/*************************************************************************
 *
 * FUNCTION:		tunmaster_Config::fGetLandscapeFlag()
 *
 * DESCRIPTION: Read various KDS configuration parameters
 *
 * PARAMETER:	Enumeration type
 *
 *
 *
 * RETURNVALUE: tBool
 *
 *************************************************************************/
tBool tunmaster_Config::fGetLandscapeFlag() const
{
	return m_fLandscapeSeekNeeded;
}


/*************************************************************************
 *
 * FUNCTION:		tunmaster_Config::fGetTMC_Server()
 *
 * DESCRIPTION: Read various KDS configuration parameters
 *
 * PARAMETER:	Enumeration type
 *
 *
 *
 * RETURNVALUE: tBool
 *
 *************************************************************************/
tBool tunmaster_Config::fGetTMC_Server() const
{
	return m_fTMC_Server;
}
/*************************************************************************
 * FUNCTION:	tunmaster_Config::blGetDABAVail_Info()
 *
 * DESCRIPTION:	retruns DAB Avail info
 *
 * PARAMETER:
 *
 * RETURNVALUE: tBool
 *************************************************************************/
/* tBool tunmaster_Config::blGetDABAVail_Info()const
{
	ETG_TRACE_USR2(( " blGetDABAVail_Info              : %d "    ,m_rKdsCMVariantCodingParameter .m_blDABAvail));
	return m_rKdsCMVariantCodingParameter.m_blDABAvail;
}*/
#if 0
/*************************************************************************
 * * FUNCTION:	tunmaster_Config::u8ReadTMCServerFromKDS()

 * DESCRIPTION:	This function will read TMC server Type from KDS and 
 *				returns the same
 *
 * PARAMETER:	tVoid
 *
 * RETURNVALUE: tU8 
 *************************************************************************/
tU8 tunmaster_Config::u8ReadTMCServerFromKDS()const
{
	
	dp_tclKdsFMAMTunerParameterSet oFMAMParameterSet;
	tU8 u8KDSData;
	tU8 u8TMCServer=DIA_KDS_TMC_FM;
	//If the TMC server type is FM than the function u8GetFM return 0x01 else returns 0x00.Same for u8GetXM and u8GetDAB function
	//Since we are interest to read TMC server Type byte, the valuse are shifted nd ORed.
	//0th bit=FM, 1th bit is DAB and 2nd bit is XM
	if(!KDS_READ_ERROR(oFMAMParameterSet.u8GetFM(u8KDSData)))
	{
		ETG_TRACE_USR4(("u8ReadTMCServerFromKDS()FM->u8KDSData=%d",u8KDSData));
		u8TMCServer=u8KDSData;
		u8TMCServer=u8TMCServer&1;
		if(!KDS_READ_ERROR(oFMAMParameterSet.u8GetDAB(u8KDSData)))
		{
			ETG_TRACE_USR4(("u8ReadTMCServerFromKDS()DAB->u8KDSData=%d",u8KDSData));
			u8KDSData=u8KDSData&1;
			u8KDSData=u8KDSData<<1;
			u8TMCServer=u8TMCServer|u8KDSData;
			if(!KDS_READ_ERROR(oFMAMParameterSet.u8GetXM(u8KDSData)))
			{
				ETG_TRACE_USR4(("u8ReadTMCServerFromKDS()XM->u8KDSData=%d",u8KDSData));
				u8KDSData=u8KDSData&1;
				u8KDSData=u8KDSData<<2;
				u8TMCServer=u8TMCServer|u8KDSData;
				ETG_TRACE_USR4(("u8ReadTMCServerFromKDS()->u8TMCServer=%d",u8TMCServer));
			}
		}
	}
	ETG_TRACE_USR4(("u8ReadTMCServerFromKDS()->u8TMCServer=%d",u8TMCServer));
	return u8TMCServer;
}
/*************************************************************************
 * * FUNCTION:	tunmaster_Config::u8ReadLandScapeFlag()

 * DESCRIPTION:	This function will read LandScapeFlag from KDS
 *				returns the same
 *
 * PARAMETER:	tVoid
 *
 * RETURNVALUE: tU8 
 *************************************************************************/
tU8 tunmaster_Config::u8ReadLandScapeFlag()const
{
	dp_tclKdsFMAMTunerParameterSet oFMAMParameterSet;
	tU8 u8KDSData=FALSE;
	if(KDS_READ_ERROR(oFMAMParameterSet.u8GetLandscapeUpdateOnShutdown(u8KDSData)))
	{
		ETG_TRACE_USR4(("u8ReadLandScapeFlag()->error in reading KDS"));
	}
	else
	{
		ETG_TRACE_USR4(("u8ReadLandScapeFlag()->u8KDSData=%d",u8KDSData));
	}
	return u8KDSData;
}
#endif


/*************************************************************************
 *
 * FUNCTION:     tunmstr_MsgFromHMI::vSet_tunmstr_tunmstr_Preset_Handler_Ptr( )
 *
 * DESCRIPTION:  tunmstr_Preset_Handler* potunmstr_Preset_Handler
 *
 * PARAMETER:    tunmstr_Preset_Handler* potunmstr_Preset_Handler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunmaster_Config::vSet_tunmstr_tunmstr_Preset_Handler_Ptr( tunmstr_Preset_Handler* potunmstr_Preset_Handler)
{
	if( potunmstr_Preset_Handler != NULL )
	{
		m_potunmstr_Preset_Handler = ( tunmstr_Preset_Handler* )potunmstr_Preset_Handler;
	}
	else
	{
		NORMAL_M_ASSERT ( m_potunmstr_Preset_Handler != NULL );
	}
}
/*************************************************************************
* FUNCTION:    vSet_tunmstr_AudioClientHandler_Ptr
*
* DESCRIPTION: update tunmstr_AudioClientHandler pointer variable
*
* PARAMETER:   tunmstr_AudioClientHandler* potunmstr_AudioClientHandler
*
* RETURNVALUE:  void
*************************************************************************/
tVoid tunmaster_Config::vSet_tunmstr_AudioClientHandler_Ptr
(tunmstr_AudioClientHandler* potunmstr_AudioClientHandler)
{
	if( potunmstr_AudioClientHandler != NULL )
	{
		m_potunmstr_AudioClientHandler = (tunmstr_AudioClientHandler*)potunmstr_AudioClientHandler;
	}

}


/*************************************************************************
* FUNCTION:    vSet_tunmstr_ConfigInterface_Ptr
*
* DESCRIPTION: 
*
* PARAMETER:   clConfigInterface* poclConfigInterface
*
* RETURNVALUE:  void
*************************************************************************/
tVoid tunmaster_Config::vSet_tunmstr_ConfigInterface_Ptr
(clConfigInterface* poclConfigInterface)
{
	if( poclConfigInterface != NULL )
	{
		m_poclConfigInterface = poclConfigInterface;
	}
}
/*************************************************************************
 * FUNCTION:    vSettunmstr_antdiag_Manager()
 *
 * DESCRIPTION: function to update m_potunmstr_antdiag_Manager
 *
 * PARAMETER:   tunmstr_antdiag_Manager* potunmstr_antdiag_Manager
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunmaster_Config::vSettunmstr_antdiag_Manager( tunmstr_antdiag_Manager* potunmstr_antdiag_Manager)
{
	m_potunmstr_antdiag_Manager=potunmstr_antdiag_Manager;
}
tVoid tunmaster_Config::vSet_tunmstr_DiaglibListner_Ptr( tunmstr_DiaglibListner* potunmstr_DiaglibListner)
{
	m_potunmstr_DiaglibListner=potunmstr_DiaglibListner;
}
/*************************************************************************
 * FUNCTION:    vReadAntennaExtSupInfo()
 *
 * DESCRIPTION: function to read the Antenna External Supply info from System coding parameter
				of KDS
 *
 * PARAMETER:   tU8 u8Buffer[]
 *
 * RETURNVALUE:  tVoid
 *************************************************************************/
/*tVoid tunmaster_Config::vReadAntennaExtSupInfo(tU8 u8Buffer[])const
{
	OSAL_tIODescriptor IOKdsHandle;
	IOKdsHandle    = OSAL_ERROR;
	//Open the KDS device before reading it
	IOKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
	if( OSAL_ERROR == IOKdsHandle )
	{
		ETG_TRACE_USR4(( " vReadAntennaExtSupInfo()->Error in Opening the KDS "));
		#ifdef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
		u8Buffer[enKdsCMVariantCoding_idx_FM1_AntennaInfo]=enunknown;
		u8Buffer[enKdsCMVariantCoding_idx_DAB_AntennaInfo]=enunknown;
		u8Buffer[enKdsCMVariantCoding_idx_GPS_AntennaInfo]=enMAXIM_16946;
		ETG_TRACE_USR4(("vReadAntennaExtSupInfo()->FMAntenna1=%x DABAntenna1=%x GPSAntenna1=%x",
		u8Buffer[enKdsCMVariantCoding_idx_FM1_AntennaInfo],u8Buffer[enKdsCMVariantCoding_idx_DAB_AntennaInfo],u8Buffer[enKdsCMVariantCoding_idx_DAB_AntennaInfo]));
		#endif
		OSAL_s32IOClose(IOKdsHandle);
		return;
	}
	tsKDSEntry sKDSEntryData;
	sKDSEntryData.u16Entry       = DIA_C_U16_KDS_CM_CONFIG_STRING;
	sKDSEntryData.u16EntryLength = DIA_C_U16_KDS_CM_CONFIG_STRING_LEN;
	sKDSEntryData.u16EntryFlags  = M_KDS_ENTRY_FLAG_NONE;
	sKDSEntryData.au8EntryData[0]= 0;

	tS32 s32RetVal = OSAL_s32IORead(IOKdsHandle,(tPS8)&sKDSEntryData, sizeof(sKDSEntryData));
	if( OSAL_ERROR != s32RetVal )
	{
		ETG_TRACE_USR4(("vReadAntennaExtSupInfo()->FMAntenna1=%x DABAntenna1=%x GPSAntenna1=%x",
		sKDSEntryData.au8EntryData[10],sKDSEntryData.au8EntryData[11],sKDSEntryData.au8EntryData[12]));
		for(tU8 u8index=0;u8index<3;u8index++)
		{
			u8Buffer[u8index]=sKDSEntryData.au8EntryData[u8index+10];
		}
		ETG_TRACE_USR4(("vReadAntennaExtSupInfo()->FMAntenna1=%x DABAntenna1=%x GPSAntenna1=%x",
		u8Buffer[0],u8Buffer[1],u8Buffer[2]));
		OSAL_s32IOClose(IOKdsHandle);
	}
	else
	{
		ETG_TRACE_USR4(("vReadAntennaExtSupInfo()->error in reading KDS"));
		#ifdef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
		u8Buffer[enKdsCMVariantCoding_idx_FM1_AntennaInfo]=enunknown;
		u8Buffer[enKdsCMVariantCoding_idx_DAB_AntennaInfo]=enunknown;
		u8Buffer[enKdsCMVariantCoding_idx_GPS_AntennaInfo]=enMAXIM_16946;
		ETG_TRACE_USR4(("vReadAntennaExtSupInfo()->FMAntenna1=%x DABAntenna1=%x GPSAntenna1=%x",
		u8Buffer[enKdsCMVariantCoding_idx_FM1_AntennaInfo],u8Buffer[enKdsCMVariantCoding_idx_DAB_AntennaInfo],u8Buffer[enKdsCMVariantCoding_idx_GPS_AntennaInfo]));
		#endif
		OSAL_s32IOClose(IOKdsHandle);
	}

}*/
/*************************************************************************
 * FUNCTION:    vReadAntennaParameter()
 *
 * DESCRIPTION: function to read the AntennaParameter info from KDS
 *
 * PARAMETER:   tU8 u8Buffer[]
 *
 * RETURNVALUE:  tVoid
 *************************************************************************/
/*tVoid tunmaster_Config::vReadAntennaParameter(tU8 u8Buffer[])
{
	u8Buffer[TUNMSTR_ANTDIAG_ANTENNAPARAMETER_COMPLETE-1]=FALSE;
	//Open the KDS device before reading it
	ETG_TRACE_USR4(("vReadAntennaParameter()->Reading Antenna Parameter by OSAL_s32IORead"));
	OSAL_tIODescriptor IOKdsHandle;
	IOKdsHandle    = OSAL_ERROR;
	IOKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);
	if( OSAL_ERROR == IOKdsHandle )
	{
		ETG_TRACE_USR4(( "vReadAntennaParameter()->Error in Opening the KDS "));
		#ifdef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
		u8Buffer[TUNMSTR_ANTDIAG_ANTENNAPARAMETER_COMPLETE-1]=TRUE;
		u8Buffer[enAntennaParameter_idx_GPSAntennaType]=enPhantom;
		u8Buffer[enAntennaParameter_idx_GPSOpenCur]=5;
		u8Buffer[enAntennaParameter_idx_GPSOpenClearCur]=5;
		u8Buffer[enAntennaParameter_idx_GPSConsiderVg_Open]=255;
		u8Buffer[enAntennaParameter_idx_GPSConsiderIgn_Open]=255;
		u8Buffer[enAntennaParameter_idx_GPSOpen2Amp]=5;
		u8Buffer[enAntennaParameter_idx_GPSOpen2AmpClearCur_Lw]=5;
		u8Buffer[enAntennaParameter_idx_GPSOpen2AmpClearCur_Hg]=5;
		u8Buffer[enAntennaParameter_idx_GPSConsiderVg_Open2Amp]=255;
		u8Buffer[enAntennaParameter_idx_GPSConsiderIgn_Open2Amp]=255;
		u8Buffer[enAntennaParameter_idx_GPSShortCur]=40;
		u8Buffer[enAntennaParameter_idx_GPSShortClearCur]=40;
		u8Buffer[enAntennaParameter_idx_GPSConsiderVg_Short]=255;
		u8Buffer[enAntennaParameter_idx_GPSConsiderIgn_Short]=255;
		u8Buffer[enAntennaParameter_idx_GPSMonitorCycle]=10;
		u8Buffer[enAntennaParameter_idx_GPSNoOfMonitorCycle]=3;
		u8Buffer[enAntennaParameter_idx_GPSShortCircuitWait]=0;
		u8Buffer[enAntennaParameter_idx_GPSConsiderCriticalHg_Vg]=0;
		#endif
		OSAL_s32IOClose(IOKdsHandle);
		return;
	}
	tsKDSEntry sKDSEntryData;
	sKDSEntryData.u16Entry       = 0x0430;
	sKDSEntryData.u16EntryLength = 90;
	sKDSEntryData.u16EntryFlags  = M_KDS_ENTRY_FLAG_NONE;
	sKDSEntryData.au8EntryData[0]= 0;
	tS32 s32RetVal = OSAL_s32IORead(IOKdsHandle,(tPS8)&sKDSEntryData, sizeof(sKDSEntryData));
	if( OSAL_ERROR != s32RetVal )
	{
		for(tU8 u8index=0;u8index<=90;u8index++)
		{
			u8Buffer[u8index]=sKDSEntryData.au8EntryData[u8index];
		}
		u8Buffer[TUNMSTR_ANTDIAG_ANTENNAPARAMETER_COMPLETE-1]=TRUE;
		OSAL_s32IOClose(IOKdsHandle);
	}
	else
	{
		ETG_TRACE_USR4(("vReadAntennaParameter()->error in reading KDS"));
		#ifdef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
		u8Buffer[TUNMSTR_ANTDIAG_ANTENNAPARAMETER_COMPLETE-1]=TRUE;
		u8Buffer[enAntennaParameter_idx_GPSAntennaType]=enPhantom;
		u8Buffer[enAntennaParameter_idx_GPSOpenCur]=5;
		u8Buffer[enAntennaParameter_idx_GPSOpenClearCur]=5;
		u8Buffer[enAntennaParameter_idx_GPSConsiderVg_Open]=255;
		u8Buffer[enAntennaParameter_idx_GPSConsiderIgn_Open]=255;
		u8Buffer[enAntennaParameter_idx_GPSOpen2Amp]=5;
		u8Buffer[enAntennaParameter_idx_GPSOpen2AmpClearCur_Lw]=5;
		u8Buffer[enAntennaParameter_idx_GPSOpen2AmpClearCur_Hg]=5;
		u8Buffer[enAntennaParameter_idx_GPSConsiderVg_Open2Amp]=255;
		u8Buffer[enAntennaParameter_idx_GPSConsiderIgn_Open2Amp]=255;
		u8Buffer[enAntennaParameter_idx_GPSShortCur]=40;
		u8Buffer[enAntennaParameter_idx_GPSShortClearCur]=40;
		u8Buffer[enAntennaParameter_idx_GPSConsiderVg_Short]=255;
		u8Buffer[enAntennaParameter_idx_GPSConsiderIgn_Short]=255;
		u8Buffer[enAntennaParameter_idx_GPSMonitorCycle]=10;
		u8Buffer[enAntennaParameter_idx_GPSNoOfMonitorCycle]=3;
		u8Buffer[enAntennaParameter_idx_GPSShortCircuitWait]=0;
		u8Buffer[enAntennaParameter_idx_GPSConsiderCriticalHg_Vg]=0;
		#endif
		OSAL_s32IOClose(IOKdsHandle);
	}
}*/
/*****************************************************************************
 * Constructor
 ****************************************************************************/
tunmstr_trKdsFmAmTunerParameter::tunmstr_trKdsFmAmTunerParameter( tVoid )
{
	ETG_TRACE_USR1((" tunmstr_trKdsFmAmTunerParameter::tunmstr_trKdsFmAmTunerParameter() -> Constructor "));
	tunmstr_trKdsFmAmTunerParameter::vSetToDefaultValues();
}

/*****************************************************************************
 * Set all KDS values to default
 ****************************************************************************/
tVoid tunmstr_trKdsFmAmTunerParameter::vSetToDefaultValues( tVoid)
{
	ETG_TRACE_USR1((" tunmstr_trKdsFmAmTunerParameter::vSetToDefaultValues() -> "));

  /** FM  */
  u32LowFM                        = TUNMSTR_CONFIG_DEFAULT_LOW_FM;
  u32HighFM                       = TUNMSTR_CONFIG_DEFAULT_HIGH_FM;

  /** MW */
  u32LowMW                        = TUNMSTR_CONFIG_DEFAULT_LOW_MW;
  u32HighMW                       = TUNMSTR_CONFIG_DEFAULT_HIGH_MW;

  /** LW */
  u32LowLW                        = TUNMSTR_CONFIG_DEFAULT_LOW_LW;
  u32HighLW                       = TUNMSTR_CONFIG_DEFAULT_HIGH_LW;
  u32Available_band               =TUNMSTR_CONFIG_DEFAULT_AVAILABLEBAND;
}


/*************************************************************************
 *
 * FUNCTION:		tunmaster_Config::vReadKDSConfig_AMFMParamters()
 *
 * DESCRIPTION: Read various KDS configuration parameters
 *
 * PARAMETER:	Enumeration type
 *
 *
 *
 * RETURNVALUE: tBool
 *
 *************************************************************************/
tVoid tunmaster_Config::vReadKDSConfig_AMFMParamters()
{
	ETG_TRACE_USR4(("Entered into vReadKDSConfig()"));
	tS32 s32KdsReadReturnValue = OSAL_ERROR;

	tU8 pu8Data[TUNMSTR_CONFIG_NEW_KDS_FM_AM_TUNER_PARAMETER_LENGTH];

	//Open the KDS device before reading it
	OSAL_tIODescriptor IOKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);

	/** Check if IOOpen was successful */
	if( OSAL_ERROR == IOKdsHandle )
	{
		ETG_TRACE_ERR(( " tunmaster_Config::vReadKDSConfig() -> KDS open operation failed, OSAL_u32ErrorCode=0x%08X"
			,OSAL_u32ErrorCode()
			));
		return;
	}

	s32KdsReadReturnValue = s32ReadKDS(IOKdsHandle,pu8Data,TUNMSTR_CONFIG_NEW_KDS_FM_AM_TUNER_PARAMETER_START_POINT_1,\
			TUNMSTR_CONFIG_NEW_KDS_FM_AM_TUNER_PARAMETER_READ_LEN_1);

	/** If success read remaining bytes  */
	if(s32KdsReadReturnValue != OSAL_ERROR)
	{
		s32KdsReadReturnValue = s32ReadKDS(IOKdsHandle,pu8Data + TUNMSTR_CONFIG_NEW_KDS_FM_AM_TUNER_PARAMETER_READ_LEN_1,\
				TUNMSTR_CONFIG_NEW_KDS_FM_AM_TUNER_PARAMETER_START_POINT_2,\
				TUNMSTR_CONFIG_NEW_KDS_FM_AM_TUNER_PARAMETER_READ_LEN_2);
	}

	OSAL_s32IOClose(IOKdsHandle);

	if(s32KdsReadReturnValue != OSAL_ERROR)
	{
		/** Parse and Print  */
		m_rKdsFmAmTunerParameter.vParse(pu8Data,TUNMSTR_CONFIG_NEW_KDS_FM_AM_TUNER_PARAMETER_LENGTH);
		m_rKdsFmAmTunerParameter.vTrace();

	}
	else
	{
		ETG_TRACE_ERR(( " tunmaster_Config::vReadKDSConfig() -> Reading FMAM PARAMETERS ERROR"		));
	}
}
/*****************************************************************************
 * gds5kor: Return AMFMTunerParameter, read from KDS
 ****************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
tunmstr_trKdsFmAmTunerParameter tunmaster_Config::stGetAMFMParameter()const
{
	return m_rKdsFmAmTunerParameter;
}
#endif
/*****************************************************************************
 *
 ****************************************************************************/
tVoid tunmstr_trKdsFmAmTunerParameter::vParse( tPU8 pu8KdsBuffer, tU32 u32Length)
{


  ETG_TRACE_USR1(( " tunmstr_trKdsFmAmTunerParameter::vParse() ->\n"
                   " u32Length                   : %d bytes\n"
                   " KDS config                  : %d bytes\n"
                   " expected                    : %d bytes\n"
                   ,u32Length
                   ,288//DIA_C_U16_KDS_NISSAN_FMAMTUNER_PARAM_SET_LEN
                   ,TUNMSTR_CONFIG_NEW_KDS_FM_AM_TUNER_PARAMETER_LENGTH
                ));

  if( u32Length < TUNMSTR_CONFIG_NEW_KDS_FM_AM_TUNER_PARAMETER_LENGTH)
  {
    ETG_TRACE_ERR(( " tunmstr_trKdsFmAmTunerParameter::vParse() -> Error: wrong length of KDS entry, default values are used now!\n"
                     " u32Length                   : %d bytes\n"
                     " KDS config                  : %d bytes\n"
                     " expected                    : %d bytes\n"
                     ,u32Length
                     ,288//DIA_C_U16_KDS_NISSAN_FMAMTUNER_PARAM_SET_LEN
                     ,TUNMSTR_CONFIG_NEW_KDS_FM_AM_TUNER_PARAMETER_LENGTH
                  ));
  }
  else

  {
	u32LowFM						= TUNMSTR_CONFIG_GET_U32( &pu8KdsBuffer[ enKdsFmAmTunerParameter_idx_LowFM]);
    u32HighFM						= TUNMSTR_CONFIG_GET_U32( &pu8KdsBuffer[ enKdsFmAmTunerParameter_idx_HighFM]);
    u32LowMW						= TUNMSTR_CONFIG_GET_U32( &pu8KdsBuffer[ enKdsFmAmTunerParameter_idx_LowMW]);
    u32HighMW						= TUNMSTR_CONFIG_GET_U32( &pu8KdsBuffer[ enKdsFmAmTunerParameter_idx_HighMW]);
    u32LowLW						= TUNMSTR_CONFIG_GET_U32( &pu8KdsBuffer[ enKdsFmAmTunerParameter_idx_LowLW]);
    u32HighLW						= TUNMSTR_CONFIG_GET_U32( &pu8KdsBuffer[ enKdsFmAmTunerParameter_idx_HighLW]);
	u32Available_band               = TUNMSTR_CONFIG_GET_U32(&pu8KdsBuffer[enKdsFmAmTunerParameter_idx_Ava_Band ]);
  }
}


/*****************************************************************************
 *
 ****************************************************************************/
tVoid tunmstr_trKdsFmAmTunerParameter::vTrace( tVoid)
{
  if( etg_bIsTraceActiveShort(((0xFFFFu & (tU16)TUNMSTR_TRACE_CLASS_TUNMASTERAPP) << 16) | (tU16)TR_LEVEL_USER_2) == TRUE)
  {

    ETG_TRACE_USR2(( " BEGIN ------------------------------------------------------------------------------------"            ));
    ETG_TRACE_USR2(( " u32LowFM                    : %8d kHz"    ,u32LowFM                             ));
    ETG_TRACE_USR2(( " u32HighFM                   : %8d kHz"    ,u32HighFM                            ));
    ETG_TRACE_USR2(( " u32LowMW                    : %8d kHz"    ,u32LowMW                             ));
    ETG_TRACE_USR2(( " u32HighMW                   : %8d kHz"    ,u32HighMW                            ));
    ETG_TRACE_USR2(( " u32LowLW                    : %8d kHz"    ,u32LowLW                             ));
    ETG_TRACE_USR2(( " u32HighLW                   : %8d kHz"    ,u32HighLW                            ));
	ETG_TRACE_USR2(( " Available_band              : %x kHz"    ,u32Available_band                     ));
    ETG_TRACE_USR2(( " END   ------------------------------------------------------------"            ));
  }
}


/*****************************************************************************
 * Constructor
 ****************************************************************************/
tunmstr_trKdsGenericTunerParameter::tunmstr_trKdsGenericTunerParameter( tVoid)
{
	ETG_TRACE_USR1((" tunmstr_trKdsGenericTunerParameter::tunmstr_trKdsGenericTunerParameter() -> Constructor"));
	tunmstr_trKdsGenericTunerParameter::vSetToDefaultValues();
}

/*****************************************************************************
 * Set all KDS values to default
 ****************************************************************************/
tVoid tunmstr_trKdsGenericTunerParameter::vSetToDefaultValues( tVoid)
{
	ETG_TRACE_USR1((" tunmstr_trKdsGenericTunerParameter::vSetToDefaultValues() -> "));

  u32InitialAutoStoreListId				= TUNMSTR_CONFIG_DEFAULT_INITIAL_AUTOSTORE_LISTID;

  u8BandToTuneAfterInitialAutostore		= TUNMSTR_CONFIG_DEFAULT_BANDTOTUNE_AFTR_INITIAL_AUTOSTORE;
  u8StationToTuneAfterUserAutostore		= TUNMSTR_CONFIG_DEFAULT_STATIONTOTUNE_AFTR_USER_AUTOSTORE;

  u8MonitorFM_TA						= TUNMSTR_CONFIG_DEFAULT_MONITOR_FMTA;
  u8AudioTunerFM_TPSeek					= TUNMSTR_CONFIG_DEFAULT_AUDIOTUNER_FMTPSEEK;
  u8AnnouncementRequestHandling			= TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_REQHANDLING;

  u8BackgroundFM_TA						= TUNMSTR_CONFIG_DEFAULT_BACKGROUNDFM_TA;

  u8TraficAnnoInOtherSrc				= TUNMSTR_CONFIG_DEFAULT_TRAFFIC_ANNO_INOTHSRC;
  u8AnnouncementPrio_FM_TA				= TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_FM_TA;
  u8AnnouncementPrio_FM_PTY31			= TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_FM_PTY31;
  u8AnnouncementPrio_FM_NEWS			= TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_FM_NEWS;
  u8AnnouncementPrio_DAB_Alarm			= TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_ALARM;

  u8AnnouncementPrio_DAB_RoadTrafficFlash = TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_ROADTRAFFICFLASH;
  u8AnnouncementPrio_DAB_TransportFlash	= TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_TRANSPORTFLASH;
  u8AnnouncementPrio_DAB_WarningService = TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_WARNIINGSERVICE;

  u8AnnouncementPrio_DAB_NewsFlash			= TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_NEWSFLASH;
  u8AnnouncementPrio_DAB_AreaWeatherFlash	= TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_AREAWEATHERFLASH;
  u8AnnouncementPrio_DAB_EventAnnouncement	= TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_EVENTANNO;
  u8AnnouncementPrio_DAB_SpecialEvent		= TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_SPECIALEVENT;
  u8AnnouncementPrio_DAB_ProgramInfo		= TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_PROGRAMINFO;
  u8AnnouncementPrio_DAB_SportReport		= TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_SPORTREPORT;
  u8AnnouncementPrio_DAB_FinancialReport	= TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_FINANCIALREPORT;
  u8AnnouncementPrio_DAB_reserved1			= TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED1;
  u8AnnouncementPrio_DAB_reserved2			= TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED2;
  u8AnnouncementPrio_DAB_reserved3			= TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED3;
  u8AnnouncementPrio_DAB_reserved4			= TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED4;
  u8AnnouncementPrio_DAB_reserved5			= TUNMSTR_CONFIG_DEFAULT_ANNOUNCEMENT_PRIO_DAB_RESERVED5;

  u8PresetListType					= TUNMSTR_CONFIG_DEFAULT_PRESETLISTTYPE;

  u8NumberOfPresetsPerBankFM        = TUNMSTR_CONFIG_DEFAULT_NO_OF_FM_PRESET_PER_BANK;
  u8NumberOfPresetsPerBankMW        = TUNMSTR_CONFIG_DEFAULT_NO_OF_MW_PRESET_PER_BANK;
  u8NumberOfPresetsPerBankLW        = TUNMSTR_CONFIG_DEFAULT_NO_OF_LW_PRESET_PER_BANK;
  u8NumberOfPresetsPerBankDRM       = TUNMSTR_CONFIG_DEFAULT_NO_OF_DRM_PRESET_PER_BANK;
  u8NumberOfPresetsPerBankMixed1    = TUNMSTR_CONFIG_DEFAULT_NO_OF_MIXED1_PRESET_PER_BANK;
}


/*************************************************************************
 * FUNCTION:	vReadKDSGenericTunerParameterSet()
 *
 * DESCRIPTION:
 *
 * PARAMETER:	tVoid
 *
 * RETURNVALUE: tVoid
 *************************************************************************/
tVoid tunmaster_Config::vReadKDSGenericTunerParameterSet()
{
	ETG_TRACE_USR1(( " vReadKDSGenericTunerParameterSet "));

	tS32 s32KdsReadReturnValue = OSAL_ERROR;

	tU8 pu8Data[TUNMSTR_CONFIG_NEW_KDS_GENERIC_TUNER_PARAMETER_LENGTH];

	//Open the KDS device before reading it
	OSAL_tIODescriptor IOKdsHandle = OSAL_IOOpen(OSAL_C_STRING_DEVICE_KDS,OSAL_EN_READWRITE);

	/** Check if IOOpen was successful */
	if( OSAL_ERROR == IOKdsHandle )
	{
		ETG_TRACE_ERR(( " tunmaster_Config::vReadKDSConfig() -> KDS open operation failed, OSAL_u32ErrorCode=0x%08X"
			,OSAL_u32ErrorCode()
			));
		return;
	}

	s32KdsReadReturnValue = s32ReadKDS(IOKdsHandle,pu8Data,TUNMSTR_CONFIG_NEW_KDS_GENERIC_TUNER_PARAMETER_START_POINT_1,\
	TUNMSTR_CONFIG_NEW_KDS_GENERIC_TUNER_PARAMETER_READ_LEN_1);

	ETG_TRACE_USR1(( " TUNMSTR_NEW_KDS_GENERIC_Tuner_Parameter_Set***************  -> %d", 	s32KdsReadReturnValue	));

	/** If success read remaining bytes  */
	if(s32KdsReadReturnValue != OSAL_ERROR)
	{
		s32KdsReadReturnValue = s32ReadKDS(IOKdsHandle,pu8Data + TUNMSTR_CONFIG_NEW_KDS_GENERIC_TUNER_PARAMETER_READ_LEN_1,\
			TUNMSTR_CONFIG_NEW_KDS_GENERIC_TUNER_PARAMETER_START_POINT_2,\
			TUNMSTR_CONFIG_NEW_KDS_GENERIC_TUNER_PARAMETER_READ_LEN_2);
	}
	OSAL_s32IOClose(IOKdsHandle);

	if(s32KdsReadReturnValue != OSAL_ERROR)
	{
		/** Parse and Print  */
		m_rKdsGenericTunerParameter.vParse(pu8Data,TUNMSTR_CONFIG_NEW_KDS_GENERIC_TUNER_PARAMETER_LENGTH);
		m_rKdsGenericTunerParameter.vTrace();
	}
	else
	{
		ETG_TRACE_ERR(( " tunmaster_Config::vReadKDSConfig() -> Reading GENERIC PARAMETERS ERROR"		));
	}
	vUpdateAnnoPrio();
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
	if(m_potunmstr_Preset_Handler != NULL)
	{
		m_potunmstr_Preset_Handler->vUpdateMixedPresetListBandAsNone();
	}
#endif
}

/*************************************************************************
*
* FUNCTION:   tunmaster_Config::s32ReadKDS()
*
* DESCRIPTION: Reads one chunk (230 bytes )from KDS , If successful then
*
* PARAMETER:  OSAL_tIODescriptor IOKdsHandle, tU8* u8Buf, tU16 u16KdsKey, tU16 u16Len
*
* RETURNVALUE: tS32
*
*
*************************************************************************/
tS32 tunmaster_Config::s32ReadKDS(OSAL_tIODescriptor IOKdsHandle, tU8* u8Buf, tU16 u16KdsKey, tU16 u16Len) const
{
	/**Reading Production mode settings */
	tsKDSEntry sKDS_EntryData;

	sKDS_EntryData.u16Entry = u16KdsKey;
	sKDS_EntryData.u16EntryLength = u16Len;
	sKDS_EntryData.u16EntryFlags = M_KDS_ENTRY_FLAG_NONE;
	sKDS_EntryData.au8EntryData[0] = 0;

	tS32 s32RetVal = OSAL_s32IORead(IOKdsHandle,(tPS8)&sKDS_EntryData,\
				sizeof(sKDS_EntryData));

    if (OSAL_ERROR != s32RetVal) {
          (tVoid)memcpy((tVoid*)u8Buf, sKDS_EntryData.au8EntryData, u16Len);
       }

	return s32RetVal;
}


/*************************************************************************
*
* FUNCTION:   tunmaster_Config::vParse()
*
* DESCRIPTION:
*
* PARAMETER:
*
* RETURNVALUE:
*
*
*************************************************************************/
tVoid tunmstr_trKdsGenericTunerParameter::vParse( tPU8 pu8KdsBuffer, tU32 u32Length)
{
	  ETG_TRACE_USR1(( " TUNMSTR_trKdsGenericTunerParameter::vParse() ->\n"
	                   " u32Length                   : %d bytes\n"
	                   " KDS config                  : %d bytes\n"
	                   " expected                    : %d bytes\n"
	                   ,u32Length
	                   ,417//diagnosis define needed
	                   ,TUNMSTR_CONFIG_NEW_KDS_GENERIC_TUNER_PARAMETER_LENGTH
	                ));

	  if( u32Length < TUNMSTR_CONFIG_NEW_KDS_GENERIC_TUNER_PARAMETER_LENGTH)
	  {
	    ETG_TRACE_ERR(( " TUNMSTR_trKdsGenericTunerParameter::vParse() -> Error: wrong length of KDS entry, default values are used now!\n"
	                     " u32Length                   : %d bytes\n"
	                     " KDS config                  : %d bytes\n"
	                     " expected                    : %d bytes\n"
	                     ,u32Length
	                     ,417//DIA_C_U16_KDS_NISSAN_FMAMTUNER_PARAM_SET_LEN
	                     ,TUNMSTR_CONFIG_NEW_KDS_GENERIC_TUNER_PARAMETER_LENGTH
	                  ));
	  }
	  else
	  {
		  u32InitialAutoStoreListId				= TUNMSTR_CONFIG_GET_U32( &pu8KdsBuffer[ enKdsGenericTunerParameter_idx_InitialAutoStoreListId]);

		  u8BandToTuneAfterInitialAutostore		= pu8KdsBuffer[ enKdsGenericTunerParameter_idx_BandToTuneAfterInitialAutostore];
		  u8StationToTuneAfterUserAutostore		= pu8KdsBuffer[ enKdsGenericTunerParameter_idx_StationToTuneAfterUserAutostore];

		  u8MonitorFM_TA						= pu8KdsBuffer[ enKdsGenericTunerParameter_idx_MonitorFM_TA];
		  u8AudioTunerFM_TPSeek					= pu8KdsBuffer[ enKdsGenericTunerParameter_idx_AudioTunerFM_TPSeek];
		  u8AnnouncementRequestHandling			= pu8KdsBuffer[ enKdsGenericTunerParameter_idx_AnnouncementRequestHandling];

		  u8BackgroundFM_TA						= pu8KdsBuffer[ enKdsGenericTunerParameter_idx_BackgroundFM_TA];
		  u8TraficAnnoInOtherSrc				= pu8KdsBuffer[ enKdsGenericTunerParameter_idx_TraficAnnoInOtherSrc];

		  u8AnnouncementPrio_FM_TA				= pu8KdsBuffer[ enKdsGenericTunerParameter_idx_AnnouncementPrio_FM_TA] & TUNMSTR_ANNO_PRIORITY;
		  u8AnnouncementPrio_FM_PTY31			= pu8KdsBuffer[ enKdsGenericTunerParameter_idx_AnnouncementPrio_FM_PTY31] & TUNMSTR_ANNO_PRIORITY;
		  u8AnnouncementPrio_FM_NEWS			= pu8KdsBuffer[ enKdsGenericTunerParameter_idx_AnnouncementPrio_FM_NEWS] & TUNMSTR_ANNO_PRIORITY;
		  u8AnnouncementPrio_DAB_Alarm			= pu8KdsBuffer[ enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_Alarm] & TUNMSTR_ANNO_PRIORITY;
		  u8AnnouncementPrio_DAB_RoadTrafficFlash = pu8KdsBuffer[ enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_RoadTrafficFlash] & TUNMSTR_ANNO_PRIORITY;
		  u8AnnouncementPrio_DAB_TransportFlash = pu8KdsBuffer[ enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_TransportFlash] & TUNMSTR_ANNO_PRIORITY;
		  u8AnnouncementPrio_DAB_WarningService = pu8KdsBuffer[ enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_WarningService] & TUNMSTR_ANNO_PRIORITY;
		  u8AnnouncementPrio_DAB_NewsFlash		= pu8KdsBuffer[ enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_NewsFlash] & TUNMSTR_ANNO_PRIORITY;
		  u8AnnouncementPrio_DAB_AreaWeatherFlash = pu8KdsBuffer[ enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_AreaWeatherFlash] & TUNMSTR_ANNO_PRIORITY;
		  u8AnnouncementPrio_DAB_EventAnnouncement = pu8KdsBuffer[ enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_EventAnnouncement] & TUNMSTR_ANNO_PRIORITY;
		  u8AnnouncementPrio_DAB_SpecialEvent	= pu8KdsBuffer[ enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_SpecialEvent] & TUNMSTR_ANNO_PRIORITY;
		  u8AnnouncementPrio_DAB_ProgramInfo	= pu8KdsBuffer[ enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_ProgramInfo] & TUNMSTR_ANNO_PRIORITY;
		  u8AnnouncementPrio_DAB_SportReport	= pu8KdsBuffer[ enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_SportReport] & TUNMSTR_ANNO_PRIORITY;
		  u8AnnouncementPrio_DAB_FinancialReport = pu8KdsBuffer[ enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_FinancialReport] & TUNMSTR_ANNO_PRIORITY;
		  u8AnnouncementPrio_DAB_reserved1		= pu8KdsBuffer[ enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_reserved1] & TUNMSTR_ANNO_PRIORITY;
		  u8AnnouncementPrio_DAB_reserved2		= pu8KdsBuffer[ enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_reserved2] & TUNMSTR_ANNO_PRIORITY;
		  u8AnnouncementPrio_DAB_reserved3		= pu8KdsBuffer[ enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_reserved3] & TUNMSTR_ANNO_PRIORITY;
		  u8AnnouncementPrio_DAB_reserved4		= pu8KdsBuffer[ enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_reserved4] & TUNMSTR_ANNO_PRIORITY;
		  u8AnnouncementPrio_DAB_reserved5		= pu8KdsBuffer[ enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_reserved5] & TUNMSTR_ANNO_PRIORITY;

		  u8PresetListType						= pu8KdsBuffer[ enKdsGenericTunerParameter_idx_PresetListType];

		  u8NumberOfPresetsPerBankFM            = pu8KdsBuffer[ enKdsGenericTunerParameter_idx_NumberOfPresetsPerBankFM ];
		  u8NumberOfPresetsPerBankMW            = pu8KdsBuffer[ enKdsGenericTunerParameter_idx_NumberOfPresetsPerBankMW ];
		  u8NumberOfPresetsPerBankLW            = pu8KdsBuffer[ enKdsGenericTunerParameter_idx_NumberOfPresetsPerBankLW ];
		  /*KDS for DRM is not yet available*/
		  u8NumberOfPresetsPerBankDRM           = TUNMSTR_CONFIG_DEFAULT_NO_OF_DRM_PRESET_PER_BANK;
		  u8NumberOfPresetsPerBankMixed1        = pu8KdsBuffer[ enKdsGenericTunerParameter_idx_NumberOfPresetsPerBankMixed1 ];
	  }

}


/*****************************************************************************
 *
 ****************************************************************************/
tVoid tunmstr_trKdsGenericTunerParameter::vTrace( tVoid)
{
  if( etg_bIsTraceActiveShort(((0xFFFFu & (tU16)TUNMSTR_TRACE_CLASS_TUNMASTERAPP) << 16) | (tU16)TR_LEVEL_USER_2) == TRUE)
  {

    ETG_TRACE_USR2(( " BEGIN Genreic parameter read in tunermaster------------------------------------"));

	ETG_TRACE_USR2(( " u32InitialAutoStoreListId                    : 0x%08d  " ,u32InitialAutoStoreListId						));
    ETG_TRACE_USR2(( " u8BandToTuneAfterInitialAutostore            : %8d  "    ,u8BandToTuneAfterInitialAutostore				));
    ETG_TRACE_USR2(( " u8StationToTuneAfterUserAutostore               : %8d  " ,u8StationToTuneAfterUserAutostore              ));


    ETG_TRACE_USR2(( " u8MonitorFM_TA								: %8d  "    ,u8MonitorFM_TA									));
    ETG_TRACE_USR2(( " u8AnnouncementRequestHandling				: %8d  "    ,u8AnnouncementRequestHandling					));



    ETG_TRACE_USR2(( " u8BackgroundFM_TA							: %8d  "    ,u8BackgroundFM_TA								));
    ETG_TRACE_USR2(( " u8TraficAnnoInOtherSrc						: %8d  "    ,u8TraficAnnoInOtherSrc							));
    ETG_TRACE_USR2(( " u8AnnouncementPrio_FM_TA						: %8d  "    ,u8AnnouncementPrio_FM_TA						));

    ETG_TRACE_USR2(( " u8AnnouncementPrio_FM_PTY31					: %8d  "    ,u8AnnouncementPrio_FM_PTY31					));
    ETG_TRACE_USR2(( " u8AnnouncementPrio_FM_NEWS					: %8d  "    ,u8AnnouncementPrio_FM_NEWS                     ));
    ETG_TRACE_USR2(( " u8AnnouncementPrio_DAB_Alarm					: %8d  "    ,u8AnnouncementPrio_DAB_Alarm					));
    ETG_TRACE_USR2(( " u8AnnouncementPrio_DAB_RoadTrafficFlash		: %8d  "    ,u8AnnouncementPrio_DAB_RoadTrafficFlash		));
    ETG_TRACE_USR2(( " u8AnnouncementPrio_DAB_TransportFlash        : %8d  "    ,u8AnnouncementPrio_DAB_TransportFlash          ));

    ETG_TRACE_USR2(( " u8AnnouncementPrio_DAB_WarningService		: %8d  "    ,u8AnnouncementPrio_DAB_WarningService			));
    ETG_TRACE_USR2(( " u8AnnouncementPrio_DAB_NewsFlash				: %8d  "    ,u8AnnouncementPrio_DAB_NewsFlash				));

    ETG_TRACE_USR2(( " u8AnnouncementPrio_DAB_AreaWeatherFlash		: %8d  "	,u8AnnouncementPrio_DAB_AreaWeatherFlash		));
    ETG_TRACE_USR2(( " u8AnnouncementPrio_DAB_EventAnnouncement		: %8d  "	,u8AnnouncementPrio_DAB_EventAnnouncement		));
    ETG_TRACE_USR2(( " u8AnnouncementPrio_DAB_SpecialEvent			: %8d  "    ,u8AnnouncementPrio_DAB_SpecialEvent            ));
    ETG_TRACE_USR2(( " u8AnnouncementPrio_DAB_ProgramInfo			: %8d  "    ,u8AnnouncementPrio_DAB_ProgramInfo				));

    ETG_TRACE_USR2(( " u8AnnouncementPrio_DAB_SportReport		    : %8d  "    ,u8AnnouncementPrio_DAB_SportReport				));
    ETG_TRACE_USR2(( " u8AnnouncementPrio_DAB_FinancialReport		: %8d  "    ,u8AnnouncementPrio_DAB_FinancialReport         ));


    ETG_TRACE_USR2(( " u8AnnouncementPrio_DAB_reserved1				: %8d  "    ,u8AnnouncementPrio_DAB_reserved1				));
    ETG_TRACE_USR2(( " u8AnnouncementPrio_DAB_reserved2				: %8d  "    ,u8AnnouncementPrio_DAB_reserved2				));
    ETG_TRACE_USR2(( " u8AnnouncementPrio_DAB_reserved3				: %8d  "    ,u8AnnouncementPrio_DAB_reserved3				));
    ETG_TRACE_USR2(( " u8AnnouncementPrio_DAB_reserved4				: %8d  "    ,u8AnnouncementPrio_DAB_reserved4				));
    ETG_TRACE_USR2(( " u8AnnouncementPrio_DAB_reserved5				: %8d  "    ,u8AnnouncementPrio_DAB_reserved5				));

    ETG_TRACE_USR2(( " u8PresetListType								: %8d  "    ,u8PresetListType								));

    ETG_TRACE_USR2(( " u8NumberOfPresetsPerBankFM					: %8d  "    ,u8NumberOfPresetsPerBankFM						));
    ETG_TRACE_USR2(( " u8NumberOfPresetsPerBankMW					: %8d  "    ,u8NumberOfPresetsPerBankMW						));
    ETG_TRACE_USR2(( " u8NumberOfPresetsPerBankLW					: %8d  "    ,u8NumberOfPresetsPerBankLW						));
    ETG_TRACE_USR2(( " u8NumberOfPresetsPerBankDRM					: %8d  "    ,u8NumberOfPresetsPerBankDRM						));
    ETG_TRACE_USR2(( " u8NumberOfPresetsPerBankMixed1					: %8d  "    ,u8NumberOfPresetsPerBankMixed1						));


    ETG_TRACE_USR2(( " END   ------------------------------------------------------------"            ));
  }
}

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
/*****************************************************************************
 * Constructor
 ****************************************************************************/
tunmstr_trKdsEOLParameter::tunmstr_trKdsEOLParameter( tVoid )
{
	ETG_TRACE_USR1((" tunmstr_trKdsEOLParameter::tun_trKdsEOLParameter() -> Constructor "));
	tunmstr_trKdsEOLParameter::vSetToDefaultValues();
}

/*****************************************************************************
 * Set all KDS values to default
 ****************************************************************************/
tVoid tunmstr_trKdsEOLParameter::vSetToDefaultValues( tVoid)
{
	ETG_TRACE_USR1((" tun_trKdsEOLParameter::vSetToDefaultValues() -> "));

	u8AMAvailable = TUNMSTR_CONFIG_DEFAULT_AM_AVAILABLE;
	u8CountryCode = TUNMSTR_CONFIG_DEFAULT_COUNTRY_CODE;
	u8FM1AntennaType=TUNMSTR_CONFIG_DEFAULT_FMANTENNATYPE;
	u8FM2AntennaType =TUNMSTR_CONFIG_DEFAULT_FMANTENNATYPE;
}


/*************************************************************************
 *
 * FUNCTION:		tunmaster_Config::vReadKDSEOLParameters()
 *
 * DESCRIPTION: Read various KDS configuration parameters
 *
 * PARAMETER:	Enumeration type
 *
 *
 *
 * RETURNVALUE: tBool
 *
 *************************************************************************/
tVoid tunmaster_Config::vReadKDSEOLParameters()
{
	ETG_TRACE_USR4(("Entered into vReadKDSEOLParameters()"));
#ifdef DP_U16_KDSADR_TEL_FCT_RADIO

	tU8 pu8Data[TUNMSTR_CONFIG_NEW_KDS_EOL_PARAMETER_LENGTH];
	dp_tclKdsTEL_Fct_RADIO oDp_TEL_Fct_RADIO;

	/** Read from Data pool into local array */
	tU8 u8KdsReadReturnValue = oDp_TEL_Fct_RADIO.u8GetTEL_Fct_RADIO(pu8Data,DP_U8_KDSLEN_TEL_FCT_RADIO_COMPLETE);

	if(u8KdsReadReturnValue == DP_U8_ELEM_STATUS_VALID)
	{
		m_rKdsEOLParameter.vParse();
		m_rKdsEOLParameter.vTrace();

		vUpdateAvailableBandsAccording2EOL();
		vUpdateFrequencyFromEOL();
	}

#endif

}


/*****************************************************************************
 *
 ****************************************************************************/
tVoid tunmstr_trKdsEOLParameter::vParse( tVoid)
{

	ETG_TRACE_USR1(( " tunmstr_trKdsEOLParameter::vParse() ->\n"));
#ifdef DP_U16_KDSADR_TEL_FCT_RADIO
	tU8 u8DpReadStatus = 0xFF;
	dp_tclKdsTEL_Fct_RADIO oDp_TEL_Fct_RADIO;

	u8DpReadStatus = oDp_TEL_Fct_RADIO.u8GetRADIOAMBandFunction(u8AMAvailable);
	ETG_TRACE_USR2(( " AM avail read status : %d" , u8DpReadStatus));

	u8DpReadStatus = oDp_TEL_Fct_RADIO.u8GetRADIOCountryZone(u8CountryCode);
	ETG_TRACE_USR2(( " CountryCode read status : %d" , u8DpReadStatus));

	u8DpReadStatus = oDp_TEL_Fct_RADIO.u8GetRADIOAntennaAMFM1Type(u8FM1AntennaType);
	ETG_TRACE_USR2(( " FM1 AntennaType read status : %d" , u8DpReadStatus));

	u8DpReadStatus = oDp_TEL_Fct_RADIO.u8GetRADIOAntennaFM2Type(u8FM2AntennaType);
	ETG_TRACE_USR2(( " FM2 AntennaType read status : %d" , u8DpReadStatus));
#endif

}


/*****************************************************************************
 *
 ****************************************************************************/
tVoid tunmstr_trKdsEOLParameter::vTrace( tVoid)
{
  if( etg_bIsTraceActiveShort(((0xFFFFu & (tU16)TUNMSTR_TRACE_CLASS_TUNMASTERAPP) << 16) | (tU16)TR_LEVEL_USER_2) == TRUE)
  {

    ETG_TRACE_USR2(( " BEGIN ------------------------------------------------------------------------------------"            ));
    ETG_TRACE_USR2(( " u8AMAvailable                    : %8d"    ,u8AMAvailable                             ));
    ETG_TRACE_USR2(( " u8CountryCode                    : %8d"    ,u8CountryCode                             ));
	ETG_TRACE_USR2(( " u8FM1AntennaType                 : %8d"    ,u8FM1AntennaType                             ));
	ETG_TRACE_USR2(( " u8FM2AntennaType                 : %8d"    ,u8FM2AntennaType                             ));
    ETG_TRACE_USR2(( " END   ------------------------------------------------------------"            ));
  }
}

/*************************************************************************
*
* FUNCTION:   vUpdateAvailableBandsAccording2EOL()
*
* DESCRIPTION: update the Available bands from EOL
*
* PARAMETER:  tVoid
*
* RETURNVALUE: tVoid
*
*************************************************************************/
tVoid tunmaster_Config::vUpdateAvailableBandsAccording2EOL()
{
	tU32 u32Availablebands = u32GetAvailableBand();
	// value from KDS

	if(u8GetAMAvailable())
		// Value read from EOL
	{
		if(u8GetCountryCode() == enPSA_TunerArea_Europe)
		{
			u32Availablebands |= TUNMSTR_CONFIG_AM_AVAIL_EU; /* Enable both MW and LW */
		}
		else
		{
			// enables the MW bit.
			u32Availablebands &= TUNMSTR_CONFIG_LW_NOTAVAIL;
			u32Availablebands |= TUNMSTR_CONFIG_AM_AVAIL_RESTAREA;
		}
	}
	else
	{
		u32Availablebands &= TUNMSTR_CONFIG_AM_NOTAVAIL; /*Disable MW and LW */
	}

	m_rKdsFmAmTunerParameter.u32Available_band = u32Availablebands;
}

/*************************************************************************
*
* FUNCTION:   vUpdateFrequencyFromEOL()
*
* DESCRIPTION: update the Available Frequency from EOL
*
* PARAMETER:tU8 u8Band
*
* RETURNVALUE: tVoid
*
*************************************************************************/
tVoid tunmaster_Config::vUpdateFrequencyFromEOL()
{
	tU8 u8CountryCode = u8GetCountryCode();
	ETG_TRACE_USR2(( " vUpdateFrequency_StepSizeFromEOL, country code : %d ", u8CountryCode));
	switch((enTunerArea)u8CountryCode)
	{
	case enPSA_TunerArea_Europe:
		{
				m_rKdsFmAmTunerParameter.u32LowFM  			    = TUNMSTR_CONFIG_EU_LOW_FM;
				m_rKdsFmAmTunerParameter.u32HighFM 			    = TUNMSTR_CONFIG_EU_HIGH_FM;

				m_rKdsFmAmTunerParameter.u32LowMW  				= TUNMSTR_CONFIG_EU_LOW_MW;
				m_rKdsFmAmTunerParameter.u32HighMW 				= TUNMSTR_CONFIG_EU_HIGH_MW;

				m_rKdsFmAmTunerParameter.u32LowLW  				= TUNMSTR_CONFIG_EU_LOW_LW;
				m_rKdsFmAmTunerParameter.u32HighLW 				= TUNMSTR_CONFIG_EU_HIGH_LW;

			break;
		}
	case enPSA_TunerArea_Japan:
		{
				m_rKdsFmAmTunerParameter.u32LowFM  			    = TUNMSTR_CONFIG_JP_LOW_FM;
				m_rKdsFmAmTunerParameter.u32HighFM 			    = TUNMSTR_CONFIG_JP_HIGH_FM;

				m_rKdsFmAmTunerParameter.u32LowMW  				= TUNMSTR_CONFIG_JP_LOW_MW;
				m_rKdsFmAmTunerParameter.u32HighMW 				= TUNMSTR_CONFIG_JP_HIGH_MW;

			break;
		}
	case enPSA_TunerArea_South_America:
		{
				m_rKdsFmAmTunerParameter.u32LowFM  			    = TUNMSTR_CONFIG_SAR_LOW_FM;
				m_rKdsFmAmTunerParameter.u32HighFM 			    = TUNMSTR_CONFIG_SAR_HIGH_FM;

				m_rKdsFmAmTunerParameter.u32LowMW  				= TUNMSTR_CONFIG_SAR_LOW_MW;
				m_rKdsFmAmTunerParameter.u32HighMW 				= TUNMSTR_CONFIG_SAR_HIGH_MW;

			break;
		}
	case enPSA_TunerArea_Asia_China:
		{
				m_rKdsFmAmTunerParameter.u32LowFM  			    = TUNMSTR_CONFIG_ASIA_CN_LOW_FM;
				m_rKdsFmAmTunerParameter.u32HighFM 			    = TUNMSTR_CONFIG_ASIA_CN_HIGH_FM;

				m_rKdsFmAmTunerParameter.u32LowMW  				= TUNMSTR_CONFIG_ASIA_CN_LOW_MW;
				m_rKdsFmAmTunerParameter.u32HighMW 				= TUNMSTR_CONFIG_ASIA_CN_HIGH_MW;

			break;
		}
	case enPSA_TunerArea_Arabia:
		{
				m_rKdsFmAmTunerParameter.u32LowFM  			    = TUNMSTR_CONFIG_ARABIA_LOW_FM;
				m_rKdsFmAmTunerParameter.u32HighFM 			    = TUNMSTR_CONFIG_ARABIA_HIGH_FM;

				m_rKdsFmAmTunerParameter.u32LowMW  				= TUNMSTR_CONFIG_ARABIA_LOW_MW;
				m_rKdsFmAmTunerParameter.u32HighMW 				= TUNMSTR_CONFIG_ARABIA_HIGH_MW;

			break;
		}
	case enPSA_TunerArea_North_America:
		{
				m_rKdsFmAmTunerParameter.u32LowFM  			    = TUNMSTR_CONFIG_NAR_LOW_FM;
				m_rKdsFmAmTunerParameter.u32HighFM 			    = TUNMSTR_CONFIG_NAR_HIGH_FM;

				m_rKdsFmAmTunerParameter.u32LowMW  				= TUNMSTR_CONFIG_NAR_LOW_MW;
				m_rKdsFmAmTunerParameter.u32HighMW 				= TUNMSTR_CONFIG_NAR_HIGH_MW;

			break;
		}
	default :
		{
			ETG_TRACE_USR2(( " vUpdateFrequency_StepSizeFromEOL , invalid area "));
			break;
		}
	};
}
/*************************************************************************
*
* FUNCTION:   u8GetAntennaType()
*
* DESCRIPTION: retunr the antenna type of the requested client
*
* PARAMETER:Client
*
* RETURNVALUE: u8AntennaType
*
*************************************************************************/
tU8 tunmaster_Config::u8GetAntennaType(tU8 Client)
{
	tU8 u8AntennaType=TUNMSTR_CONFIG_DEFAULT_FMANTENNATYPE;

	if(m_poclConfigInterface == NULL)
	{
		NORMAL_M_ASSERT (NULL != m_poclConfigInterface);
		return u8AntennaType;
	}
	switch(Client)
	{
	case enFM1:
		{
			return (tU8)m_poclConfigInterface->u32GetConfigData("RADIOAntennaAMFM1Type");
			break;
		}
	case enFM2:
		{
			return (tU8)m_poclConfigInterface->u32GetConfigData("RADIOAntennaFM2Type");
			break;
		}
	default:
		{
			break;
		}
	}
	return u8AntennaType;
}
#endif
tVoid tunmaster_Config::vUpdateAnnoPrio()
{
	if(m_poclConfigInterface == NULL)
	{
		NORMAL_M_ASSERT (NULL != m_poclConfigInterface);
		return;
	}
#ifdef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_SUZUKI
{
	tBool blAnnouncementSurvivellenceModeSupport=((m_poclConfigInterface->u32GetConfigData("FmDabHdTunerMode")& 0x14) ||
			(m_poclConfigInterface->u32GetConfigData("FmDabHdTunerMode")& 0x27));
	 tuner::announcements::clAnnouncementSettings::instance()->vSetAnnouncementSurvivellenceModeSupport(tuner::common::FM1, blAnnouncementSurvivellenceModeSupport);
	 tuner::announcements::clAnnouncementSettings::instance()->vSetAnnouncementSurvivellenceModeSupport(tuner::common::AM, blAnnouncementSurvivellenceModeSupport);
	 tuner::announcements::clAnnouncementSettings::instance()->vSetAnnouncementSurvivellenceModeSupport(tuner::common::SOURCEID_LIMIT, blAnnouncementSurvivellenceModeSupport);
}
#else
{
	 tuner::announcements::clAnnouncementSettings::instance()->vSetAnnouncementSurvivellenceModeSupport(tuner::common::FM1, bIsDABForeGroundAnnouncementSurvivellenceModeSupport(tuner::common::FM1));
	 tuner::announcements::clAnnouncementSettings::instance()->vSetAnnouncementSurvivellenceModeSupport(tuner::common::AM, bIsDABForeGroundAnnouncementSurvivellenceModeSupport(tuner::common::AM));
	 tuner::announcements::clAnnouncementSettings::instance()->vSetAnnouncementSurvivellenceModeSupport(tuner::common::SOURCEID_LIMIT, bIsDABForeGroundAnnouncementSurvivellenceModeSupport(tuner::common::SOURCEID_LIMIT));
}
#endif
tU32 u32Available_band =m_poclConfigInterface->u32GetConfigData("AvailableBands");
if((u32Available_band & TUNMSTR_CONFIG_DEFAULT_AVAILABLEBAND_WB_MASKVAL))
{
   tuner::announcements::clAnnouncementSettings::instance()->vSetPlayOtherAnnouncements(tuner::common::AM, tuner::common::WEATHERANNOUNCEMENTS, true);
   tuner::announcements::clAnnouncementSettings::instance()->vSetPlayOtherAnnouncements(tuner::common::SOURCEID_LIMIT, tuner::common::WEATHERANNOUNCEMENTS, true);
   tuner::announcements::clAnnouncementSettings::instance()->vSetPlayOtherAnnouncements(tuner::common::FM1, tuner::common::WEATHERANNOUNCEMENTS, true);
   tuner::announcements::clAnnouncementSettings::instance()->vSetPlayOtherAnnouncements(tuner::common::WB, tuner::common::WEATHERANNOUNCEMENTS, true);
   tuner::announcements::clAnnouncementSettings::instance()->vSetAnnouncementPriority(tuner::common::WEATHERALERT, ALWAYS_ALLOW_ANNOUNCEMENTS);
}
if( ((tU8)m_poclConfigInterface->u32GetConfigData("TraficAnnoInOtherSrc")) & 0x01 )
 {
	 tuner::announcements::clAnnouncementSettings::instance()->vSetPlayOtherAnnouncements(tuner::common::DAB, tuner::common::FMANNOUNCEMENTS, true);
 }
 else
 {
	 tuner::announcements::clAnnouncementSettings::instance()->vSetPlayOtherAnnouncements(tuner::common::DAB, tuner::common::FMANNOUNCEMENTS, false);
 }
 if( ((tU8)m_poclConfigInterface->u32GetConfigData("TraficAnnoInOtherSrc")) & 0x02 )
 {
	 tuner::announcements::clAnnouncementSettings::instance()->vSetPlayOtherAnnouncements(tuner::common::FM1, tuner::common::DABANNOUNCEMENTS, true);
 }
 else
 {
	 tuner::announcements::clAnnouncementSettings::instance()->vSetPlayOtherAnnouncements(tuner::common::FM1, tuner::common::DABANNOUNCEMENTS, false);
 }
 if( ((tU8)m_poclConfigInterface->u32GetConfigData("TraficAnnoInOtherSrc")) & 0x04 )
  {
 	 tuner::announcements::clAnnouncementSettings::instance()->vSetPlayOtherAnnouncements(tuner::common::SOURCEID_LIMIT, tuner::common::DABANNOUNCEMENTS, true);
  }
  else
  {
 	 tuner::announcements::clAnnouncementSettings::instance()->vSetPlayOtherAnnouncements(tuner::common::SOURCEID_LIMIT, tuner::common::FMANNOUNCEMENTS, true);
  }
 if (((tU8)m_poclConfigInterface->u32GetConfigData("MonitorFMTA")) & 0x01)
 {
	 tuner::announcements::clAnnouncementSettings::instance()->vSetPlayOtherAnnouncements(tuner::common::AM, tuner::common::FMANNOUNCEMENTS, true);
 }
 else
 {
	 tuner::announcements::clAnnouncementSettings::instance()->vSetPlayOtherAnnouncements(tuner::common::AM, tuner::common::FMANNOUNCEMENTS, false);
 }
 
	 tuner::announcements::clAnnouncementSettings::instance()->vSetAnnouncementPriority(tuner::common::FMTA, m_poclConfigInterface->u32GetConfigData("AnnouncementPrioFMTA")& TUNMSTR_ANNO_PRIORITY);
	 tuner::announcements::clAnnouncementSettings::instance()->vSetAnnouncementPriority(tuner::common::PTY31FM, m_poclConfigInterface->u32GetConfigData("AnnouncementPrioFMPTY31")& TUNMSTR_ANNO_PRIORITY);
	 tuner::announcements::clAnnouncementSettings::instance()->vSetAnnouncementPriority(tuner::common::DABALARM, m_poclConfigInterface->u32GetConfigData("AnnouncementPrioDABAlarm")& TUNMSTR_ANNO_PRIORITY);
	 tuner::announcements::clAnnouncementSettings::instance()->vSetAnnouncementPriority(tuner::common::DABTA, m_poclConfigInterface->u32GetConfigData("AnnouncementPrioDABRoadTrafficFlash")& TUNMSTR_ANNO_PRIORITY);
	 tuner::announcements::clAnnouncementSettings::instance()->vSetAnnouncementPriority(tuner::common::DABTRANSPORT, m_poclConfigInterface->u32GetConfigData("AnnouncementPrioDABTransportFlash")& TUNMSTR_ANNO_PRIORITY);
	 tuner::announcements::clAnnouncementSettings::instance()->vSetAnnouncementPriority(tuner::common::DABWARNING, m_poclConfigInterface->u32GetConfigData("AnnouncementPrioDABWarningService")& TUNMSTR_ANNO_PRIORITY);
	 tuner::announcements::clAnnouncementSettings::instance()->vSetAnnouncementPriority(tuner::common::DABNEWS, m_poclConfigInterface->u32GetConfigData("AnnouncementPrioDABNewsFlash")& TUNMSTR_ANNO_PRIORITY);
	 tuner::announcements::clAnnouncementSettings::instance()->vSetAnnouncementPriority(tuner::common::DABWEATHER, m_poclConfigInterface->u32GetConfigData("AnnouncementPrioDABAreaWeatherFlash")& TUNMSTR_ANNO_PRIORITY);
	 tuner::announcements::clAnnouncementSettings::instance()->vSetAnnouncementPriority(tuner::common::DABEVENT, m_poclConfigInterface->u32GetConfigData("AnnouncementPrioDABEventAnnouncement")& TUNMSTR_ANNO_PRIORITY);
	 tuner::announcements::clAnnouncementSettings::instance()->vSetAnnouncementPriority(tuner::common::DABSPECIALEVENT, m_poclConfigInterface->u32GetConfigData("AnnouncementPrioDABSpecialEvent")& TUNMSTR_ANNO_PRIORITY);
	 tuner::announcements::clAnnouncementSettings::instance()->vSetAnnouncementPriority(tuner::common::DABPROGRAMME, m_poclConfigInterface->u32GetConfigData("AnnouncementPrioDABProgramInformation")& TUNMSTR_ANNO_PRIORITY);
	 tuner::announcements::clAnnouncementSettings::instance()->vSetAnnouncementPriority(tuner::common::DABSPORTS, m_poclConfigInterface->u32GetConfigData("AnnouncementPrioDABSportReport")& TUNMSTR_ANNO_PRIORITY);
	 tuner::announcements::clAnnouncementSettings::instance()->vSetAnnouncementPriority(tuner::common::DABFINANCE, m_poclConfigInterface->u32GetConfigData("AnnouncementPrioDABFinantialReport")& TUNMSTR_ANNO_PRIORITY);
#else
	m_mapAnnoPrioVal[0]    = m_poclConfigInterface->u32GetConfigData("AnnouncementPrioFMPTY31")& TUNMSTR_ANNO_PRIORITY;
	m_mapAnnoPrioVal[1]    = m_poclConfigInterface->u32GetConfigData("AnnouncementPrioDABAlarm")& TUNMSTR_ANNO_PRIORITY;
	m_mapAnnoPrioVal[2]    = m_poclConfigInterface->u32GetConfigData("AnnouncementPrioDABRoadTrafficFlash")& TUNMSTR_ANNO_PRIORITY;
	m_mapAnnoPrioVal[3]    = m_poclConfigInterface->u32GetConfigData("AnnouncementPrioFMTA")& TUNMSTR_ANNO_PRIORITY;
	m_mapAnnoPrioVal[4]    = m_poclConfigInterface->u32GetConfigData("AnnouncementPrioDABTransportFlash")& TUNMSTR_ANNO_PRIORITY;
	m_mapAnnoPrioVal[5]    = m_poclConfigInterface->u32GetConfigData("AnnouncementPrioFMNEWS")& TUNMSTR_ANNO_PRIORITY;
	m_mapAnnoPrioVal[8]    = m_poclConfigInterface->u32GetConfigData("AnnouncementPrioDABWarningService")& TUNMSTR_ANNO_PRIORITY;
	m_mapAnnoPrioVal[16]   = m_poclConfigInterface->u32GetConfigData("AnnouncementPrioDABNewsFlash")& TUNMSTR_ANNO_PRIORITY;
	m_mapAnnoPrioVal[32]   = m_poclConfigInterface->u32GetConfigData("AnnouncementPrioDABAreaWeatherFlash")& TUNMSTR_ANNO_PRIORITY;
	m_mapAnnoPrioVal[64]   = m_poclConfigInterface->u32GetConfigData("AnnouncementPrioDABEventAnnouncement")& TUNMSTR_ANNO_PRIORITY;
	m_mapAnnoPrioVal[128]  = m_poclConfigInterface->u32GetConfigData("AnnouncementPrioDABSpecialEvent")& TUNMSTR_ANNO_PRIORITY;
	m_mapAnnoPrioVal[256]  = m_poclConfigInterface->u32GetConfigData("AnnouncementPrioDABProgramInformation")& TUNMSTR_ANNO_PRIORITY;
	m_mapAnnoPrioVal[512]  = m_poclConfigInterface->u32GetConfigData("AnnouncementPrioDABSportReport")& TUNMSTR_ANNO_PRIORITY;
	m_mapAnnoPrioVal[1024] = m_poclConfigInterface->u32GetConfigData("AnnouncementPrioDABFinantialReport")& TUNMSTR_ANNO_PRIORITY;
#endif
}


/*************************************************************************
* FUNCTION:    tunmaster_Config::u16GetAnnoPrio
*
* DESCRIPTION: returns anno prio from map
*
* PARAMETER:   u16AnnoType
*
* RETURNVALUE: tU16
*
* History:
* InitialVersion
*
* Author
*************************************************************************/

tU16 tunmaster_Config::u16GetAnnoPrio(tU16 u16AnnoType)
{
	/** Check for map empty */
	if(!m_mapAnnoPrioVal.empty())
	{
		/** Iterate through the map */
		for(mapAnnoPrio::const_iterator pos = m_mapAnnoPrioVal.begin();
			pos != m_mapAnnoPrioVal.end();
			++pos)
		{
			if(u16AnnoType == pos->first)
			{
				ETG_TRACE_USR2((" tunmaster_Config::u8GetAnnoPrio , found value %d", pos->second));
				return pos->second;
			}
		}
	}
	ETG_TRACE_USR2((" tunmaster_Config::u8GetAnnoPrio , not found" ));
	return TUNMSTR_ANNO_INVALID;
}
/*************************************************************************
*
* FUNCTION:   bIsDRMSupported()
*
* DESCRIPTION: Says whether DRM is supported by the current configuration.
* Bit 2 and 3 are used for DRM info in CMVariantCoding 15th byte.
*
* PARAMETER:  tVoid
*
* RETURNVALUE: tU8 : 0-info not available (0x00)
*                                      1- mounted (0x04)
*                                      2-not mounted (0x08)
*
*************************************************************************/

tU8 tunmaster_Config::bIsDRMSupported() const
{
   ETG_TRACE_USR2((" tunmaster_Config::bIsDRMSupported-> 0x%02x (Bit values: 0 - info not available, 1- mounted, 2-not mounted )",
         m_rKdsCMVariantCodingParameter.u8HWAssemblyInfo3 & EXTRACT_DRM_BIT_HW_CONFIGURATION ));

   return (m_rKdsCMVariantCodingParameter.u8HWAssemblyInfo3 & EXTRACT_DRM_BIT_HW_CONFIGURATION) == EXTRACT_DRM_BIT_HW_CONFIGURATION ? true: false;
}

/*************************************************************************
*
**************************************************************************/
tBool tunmaster_Config::bIsDABSupported() const
{
   return m_rKdsCMVariantCodingParameter.m_blDABAvail;
}

tVoid tunmaster_Config::vConfigDone()
{
	//Below section will be uncommented once the system set coding is enabled for tunermaster
	/*#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
		if((NULL==m_potunmstr_Preset_Handler)
		#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			||(NULL==m_poArlSourceImpl)
		#endif
		#ifdef  VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
			||(NULL==m_poAnnouncementControl)
		#endif
			)
		{
			return;
		}
	#endif
	#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	m_poArlSourceImpl->vResetAudioSessionStates();
	vSendSourceAvailabilityAfterConfigDone();
	#endif
	#ifdef  VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
		m_poAnnouncementControl->vResetAnnouncementsStates();
		vUpdateAnnoPrio();
	#endif
	#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
		m_potunmstr_Preset_Handler->vUpdateMixedPresetListBandAsNone();
	#endif
	   if((m_potunmstr_antdiag_Manager != nullptr) && (m_potunmstr_DiaglibListner != nullptr))
	   {
		   m_potunmstr_antdiag_Manager->vPostEvent(TUNMSTR_ANTDIAG_U32_EVENT_MASK_START_ANTDIAG);
		   m_potunmstr_DiaglibListner->vSendSystemSetResult();
		}*/
}
/*** END OF FILE *************************************************************/
