/*
 * tunermaster_SXMchannelartClient.cpp
 *
 *  Created on: Dec 6, 2018
 *      Author: auj1kor
 */

#include "tunermaster_SXMchannelartClient.h"
#include "tunermaster_defines.h"
#include "tunmstr_Preset_Handler.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNMSTR_TRACE_CLASS_SXM_CLIENT
#include "trcGenProj/Header/tunermaster_SXMchannelartClient.cpp.trc.h"
#endif
// trace defines.
#include "tunermaster_trace.h"

#ifndef _TUNERMASTER_MAIN_H_
#include "tunermaster_main.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
BEGIN_MSG_MAP(tunermaster_SXMchannelartClient, ahl_tclBaseWork)

ON_MESSAGE( MIDW_EXT_SXM_CHANNELARTFI_C_U16_GETCHANNELARTLIST, vHandleChannelArtList)

END_MSG_MAP()


tunermaster_SXMchannelartClient::tunermaster_SXMchannelartClient(tunmaster_tclApp* poMainApp):poGWMain(poMainApp),m_u16SrvRegID(AMT_C_U16_REGID_INVALID)
			,m_potunmstr_Preset_Handler(NULL),m_bServiceState(FALSE)
{

}


tunermaster_SXMchannelartClient::~tunermaster_SXMchannelartClient(){
	poGWMain      = NULL;
	m_u16SrvRegID = AMT_C_U16_REGID_INVALID;
	m_potunmstr_Preset_Handler = NULL;
	m_bServiceState = FALSE;
}


/*************************************************************************
 *
 * FUNCTION:    vSet_Preset_Handler_Ptr(tunmstr_Preset_Handler* po_tunmstr_PresetHandler)
 *
 * DESCRIPTION: Update pointer m_potunmstr_Preset_Handler
 *
 * PARAMETER:   tunmstr_Preset_Handler* po_tunmstr_PresetHandler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunermaster_SXMchannelartClient::vSet_Preset_Handler_Ptr(tunmstr_Preset_Handler* po_tunmstr_PresetHandler)
{
	if( po_tunmstr_PresetHandler != NULL  )
	{
		m_potunmstr_Preset_Handler = po_tunmstr_PresetHandler;
	}
}


/*************************************************************************
 *
 * FUNCTION:     tunermaster_SXMchannelartClient::bRegisterForFID
 *
 * DESCRIPTION:  Function call t register FID
 *
 * PARAMETER:    amt_tclServiceData
 *
 * RETURNVALUE:  tBool
 *
 *************************************************************************/
tBool tunermaster_SXMchannelartClient::bRegisterForFID(tU16 u16FID){

	ETG_TRACE_USR1(( " bRegisterForFID  m_u16SrvRegID =%d u16FID=%d",m_u16SrvRegID,u16FID));

	if(( AMT_C_U16_REGID_INVALID == m_u16SrvRegID ) || (poGWMain == NULL))
	{

		ETG_TRACE_USR1(( "   bRegisterForFID INVALID m_u16SrvRegID =%d u16FID=%d",m_u16SrvRegID,u16FID));
		return false;
	}
	gm_tclEmptyMessage oUpRegMessage
	(
			CCA_C_U16_APP_TUNERMASTER,          // AppID of this application
			CCA_C_U16_APP_FC_SXM,            // AppID of the other Server
			m_u16SrvRegID,                    // RegId for the service
			0,                            // always 0
			CCA_C_U16_SRV_SXM_CHANNEL_ART,            // the SID of the service
			u16FID,                       // the FID to register for
			AMT_C_U8_CCAMSG_OPCODE_UPREG  // this is an Upreg-message!
	);

	if( AIL_EN_N_NO_ERROR != poGWMain->enPostMessage(&oUpRegMessage) )
	{
		ETG_TRACE_USR1(( "bRegisterForFID POST error  m_u16SrvRegID =%d u16FID=%d",m_u16SrvRegID,u16FID));
		// Error in sending the message
		if(!oUpRegMessage.bDelete())
		{
			ETG_TRACE_USR4(("bRegisterForFID, Delete Error"));
			return false;
		}
	}
	return true;
}


/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_SXMchannelartClient::vRegisterForService
 *
 *DESCRIPTION:  Sends a register message to SPM.
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  TRUE  : No Error in registeration
 *              FALSE : Error in registeration
 *
 *
 ******************************************************************-FUNCHEADER*/
tVoid tunermaster_SXMchannelartClient::vRegisterForService(){

	tBool bIsServiceRegistered = FALSE;

	if ( AMT_C_U16_REGID_INVALID == m_u16SrvRegID )
	{
		// Signal to register to service
		if (NULL != poGWMain)
		{
			bIsServiceRegistered = poGWMain->bRegisterAsync (CCA_C_U16_SRV_SXM_CHANNEL_ART,
					MIDW_EXT_SXM_CHANNELARTFI_C_U16_SERVICE_MAJORVERSION                      /* Major version */,
					MIDW_EXT_SXM_CHANNELARTFI_C_U16_SERVICE_MINORVERSION                      /* Minor version */,
					0x0,
					CCA_C_U16_APP_FC_SXM
			);
		}
	}
	if (FALSE == bIsServiceRegistered)
	{
		ETG_TRACE_USR4(("vRegisterForService, Service Registration Error"));

	}
	else
	{
		ETG_TRACE_USR4(("vRegisterForService, Service SUCCESS"));
	}
}


/*************************************************************************
 * FUNCTION:     vOnAsyncRegisterConf
 *
 * DESCRIPTION:  SXM service registration confirmation function
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunermaster_SXMchannelartClient::vOnAsyncRegisterConf(tU16 u16RegisterId,tU16 u16ServerAppId,
				tU16 u16ServiceId,
				tU16 u16SourceSubID)
{
	m_u16SrvRegID=u16RegisterId;
	ETG_TRACE_USR1(("vRegisterForSXMService() m_u16SrvRegID=%d u16ServiceId=%d,u16SourceSubID=%d u16ServerAppId=%d"\
		,m_u16SrvRegID,u16ServiceId,u16SourceSubID,u16ServerAppId));
}


/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_SXMchannelartClient::vUnregisterForService
 *
 *DESCRIPTION:  Sends a unregister message to SXM
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  TRUE  : No Error in unregisteration
 *              FALSE : Error in unregisteration
 *
 *
 ******************************************************************-FUNCHEADER*/
tVoid tunermaster_SXMchannelartClient::vUnregisterForService(){


	if ( AMT_C_U16_REGID_INVALID != m_u16SrvRegID )
	{

		// Send an unregister for service message
		if (NULL != poGWMain)
			poGWMain->vUnregisterService( (tU16) CCA_C_U16_SRV_SXM_CHANNEL_ART ); //Update to PM
		// Make register-ID invalid:
		m_u16SrvRegID = AMT_C_U16_REGID_INVALID;

		ETG_TRACE_USR4(( " vUnregisterForService  m_u16SrvRegID = %d",m_u16SrvRegID));
	}

}


/*************************************************************************
 *
 * FUNCTION:     tunermaster_SXMchannelartClient::vOnNewAppState
 *
 * DESCRIPTION:  Main calls this function whenever there is a change in
 *              power state to handle CCA service
 *
 * PARAMETER:    u32OldAppState : Last set application state
 *               u32AppState    : Current requested app state
 *
 * RETURNVALUE:  None
 *
 *
 *************************************************************************/
tVoid tunermaster_SXMchannelartClient::vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState)
{

		if(poGWMain == NULL)
		{
				NORMAL_M_ASSERT (NULL != poGWMain);
					return;
		}

		if( u32OldAppState == u32AppState)
			return;
		switch(u32AppState)
		{
			case AMT_C_U32_STATE_NORMAL:
			{
				// Register for service
				vRegisterForService();

			}
			break;

			case AMT_C_U32_STATE_OFF:
			{
				/*In case of APP state off*/
				vUnregisterForService();
			}
			break;

			default:
			{
				// Ideally should  not come here
				break;
			}
		} // switch(u32AppState)

}

/*************************************************************************
 *
 * FUNCTION:     tunermaster_SXMchannelartClient::vOnServiceState
 *
 * DESCRIPTION:  Main calls this function whenever there is a change in
 *              power state to handle CCA service
 *
 * PARAMETER:    u16ServiceId : Service ID
 *               u16RegisterId : Current requested app state *
 *               u8ServiceState
 *
 *
 * RETURNVALUE:  None
 *
 *
 *************************************************************************/
tVoid tunermaster_SXMchannelartClient::vOnServiceState(tU16 u16ServiceId,tU16 u16RegisterId, tU8 u8ServiceState, tU16 u16SubId)
{

		ETG_TRACE_USR1(( " vOnServiceState u16ServiceId=%d u8ServiceState=%d u16RegisterId=%d",u16ServiceId,u8ServiceState,u16RegisterId));

		if( CCA_C_U16_SRV_SXM_CHANNEL_ART != u16ServiceId )
		{

			return;
		}

		// Analyze the state of the server
		switch(u8ServiceState)
		{
		case AMT_C_U8_SVCSTATE_AVAILABLE:
			{
				// Get new service ID
				m_u16SrvRegID = u16RegisterId;
				m_bServiceState = TRUE;
				ETG_TRACE_USR4(( " Channel Art Service Available, u16ServiceId=%d u8ServiceState=%d u16RegisterId=%d",u16ServiceId,u8ServiceState,m_u16SrvRegID));
				break;
			}
		case AMT_C_U8_SVCSTATE_NOT_AVAILABLE:
			{
				ETG_TRACE_USR1(( " Channel Art Service  not avail "));
				m_bServiceState = FALSE;
				break;
			}
		default:
			{
				break;
			}
		} // switch(u8ServiceState)

}

/*******************************************************************************
 *FUNCTION:    tunermaster_SXMchannelartClient::vGetDataFromAmt
 *
 *DESCRIPTION: This function converts Amt message to visitor class and
 *             get the data from visitor to the Fi class. Refer FI Manual.
 *             Doc.
 *
 *PARAMETER:
 *           poFiMsg   - Amt Message
 *           oFIData   - Base class of Fi class
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunermaster_SXMchannelartClient::vGetDataFromAmt(amt_tclServiceData* poFIMsg,
		fi_tclTypeBase&     oFIData )const
{
	// Create Visitor message object for incoming message
	fi_tclVisitorMessage oInVisitorMsg(poFIMsg);

	/* Get the data in FI class from Vistor class*/
	if(OSAL_ERROR == oInVisitorMsg.s32GetData(oFIData,1))
	{
		// assert here
		NORMAL_M_ASSERT_ALWAYS ();
	}
}

tVoid tunermaster_SXMchannelartClient :: vSendMessage( tU16             u16DestAppID,
		const fi_tclTypeBase&  oOutData,
		tU16             u16Fid,
		tU8              u8OpCode,
		tU16             u16CmdCtr)
{

		fi_tclVisitorMessage oOutVisitorMsg(oOutData,1);


		// Set the CCA message information
		oOutVisitorMsg.vInitServiceData(  CCA_C_U16_APP_TUNERMASTER,                  /* Source app-ID    */
				u16DestAppID,                         /* Dest. app-ID     */
				AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,    /* stream type      */
				0,                                    /* stream counter   */
				m_u16SrvRegID,                        /* Registry ID      */
				u16CmdCtr,                            /* Command counter  */
				CCA_C_U16_SRV_SXM_CHANNEL_ART,           /* Service-ID       */
				u16Fid,                               /* Function-ID      */
				u8OpCode,                             /* OpCode           */
				0,                                    /* ACT              */
				0,                                    /* Source sub-ID    */
				0 );                                  /* Dest. sub-ID     */

		if ( NULL == poGWMain )
		{

			NORMAL_M_ASSERT (NULL != poGWMain);
			return;

		}

		// Send it to the client
		if(poGWMain->enPostMessage(&oOutVisitorMsg, TRUE) != AIL_EN_N_NO_ERROR)
		{
			//Trace for Error message if required.
		}

}


/*************************************************************************
 *
 * FUNCTION:     tunermaster_SXMchannelartClient::vHandleChannelArtList
 *
 * DESCRIPTION:  Handle channel art method result
 *
 * PARAMETER:    amt_tclServiceData* poMessage
 *
 *
 * RETURNVALUE:  None
 *
 *
 *************************************************************************/
tVoid tunermaster_SXMchannelartClient::vHandleChannelArtList(amt_tclServiceData* poMessage)
{
	if((nullptr == poMessage) || ( nullptr == m_potunmstr_Preset_Handler))
	{
		ETG_TRACE_USR4(("vHandlePresetListResult is NULL"));
		return;
	}
	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
		{
			ETG_TRACE_USR4(("vHandleChannelArtList()"));
			m_potunmstr_Preset_Handler->vHandleChannelArtListResult(poMessage);
			break;
		}

		default:
		{
			break;
		}
	}
}


/*************************************************************************
 *
 * FUNCTION:     tunermaster_SXMchannelartClient::bGetServiceStatus()
 *
 * DESCRIPTION:  Return service status
 * PARAMETER:
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tBool tunermaster_SXMchannelartClient::bGetServiceStatus()
{

	ETG_TRACE_USR4(("bGetServiceAvail : %d",m_bServiceState));
	return m_bServiceState;

}


#endif

