///////////////////////////////////////////////////////////
//  tunermaster_SXMClient.cpp
//  Implementation of the Class tunermaster_SXMClient
//  Created on:      18-Apr-2018 11:35:15 AM
//  Original author: MHV6KOR
///////////////////////////////////////////////////////////

#include "tunermaster_SXMClient.h"
#include "tunermaster_defines.h"
#include "tunmstr_Preset_Handler.h"
#include "kdsconfig/clConfigInterface.h"
#include "tunmstr_TunerClientHandler.h"

#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNMSTR_TRACE_CLASS_SXM_CLIENT
#include "trcGenProj/Header/tunermaster_SXMClient.cpp.trc.h"
#endif
// trace defines.
#include "tunermaster_trace.h"

#ifndef _TUNERMASTER_MAIN_H_
#include "tunermaster_main.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
BEGIN_MSG_MAP(tunermaster_SXMClient, ahl_tclBaseWork)
#ifdef INCLUDE_PROFILE_MANAGER
ON_MESSAGE( MIDW_EXT_SXM_AUDIOFI_C_U16_USERPROFILE, vHandleUserProfileResult)
#endif
ON_MESSAGE( MIDW_EXT_SXM_AUDIOFI_C_U16_SETPRESETLIST, vHandle_SetPresetListResult)
ON_MESSAGE( MIDW_EXT_SXM_AUDIOFI_C_U16_PRESETCHANNELUPDATE, vHandlePresetChannelUpdate)
ON_MESSAGE( MIDW_EXT_SXM_AUDIOFI_C_U16_SYSTEMMESSAGE, vHandleSystemMessageUpdate)
ON_MESSAGE( MIDW_EXT_SXM_AUDIOFI_C_U16_GETPRESETLIST, vHandlePresetListResult)
ON_MESSAGE( MIDW_EXT_SXM_AUDIOFI_C_U16_RECALLPRESET, vHandleRecallPresetResult)
ON_MESSAGE( MIDW_EXT_SXM_AUDIOFI_C_U16_STOREPRESET, vHandleStorePresetResult)
ON_MESSAGE( MIDW_EXT_SXM_AUDIOFI_C_U16_AUTOCOMPARE, vHandlePresetAutoCompare)

END_MSG_MAP()


tunermaster_SXMClient::tunermaster_SXMClient(tunmaster_tclApp* poMainApp):poGWMain(poMainApp),m_u16SrvRegID(AMT_C_U16_REGID_INVALID)
#ifdef INCLUDE_PROFILE_MANAGER
,m_ptunmaster_PMClient(NULL)
#endif
		,m_potunmstr_Preset_Handler(nullptr),m_poclConfigInterface(nullptr),m_potunmstr_MsgToHMI(nullptr),m_potunmstr_MsgFromHMI(nullptr),m_potunmstr_TunerClientHandler(nullptr),m_bServiceAvailable(FALSE),m_u8PresetAutocompare(0xFF)
{

}


tunermaster_SXMClient::~tunermaster_SXMClient(){
	poGWMain      = NULL;
	m_u16SrvRegID = AMT_C_U16_REGID_INVALID;
#ifdef INCLUDE_PROFILE_MANAGER
	m_ptunmaster_PMClient = NULL;
#endif
	m_potunmstr_Preset_Handler = nullptr;
	m_poclConfigInterface = nullptr;
	m_potunmstr_MsgToHMI = nullptr;
	m_potunmstr_MsgFromHMI = nullptr;
	m_potunmstr_TunerClientHandler = nullptr;
	m_bServiceAvailable = FALSE;
	m_u8PresetAutocompare = 0xFF;
}


/*************************************************************************
 *
 * FUNCTION:     tunermaster_SXMClient::bRegisterForFID
 *
 * DESCRIPTION:  Function call t register FID
 *
 * PARAMETER:    amt_tclServiceData
 *
 * RETURNVALUE:  tBool
 *
 *************************************************************************/
tBool tunermaster_SXMClient::bRegisterForFID(tU16 u16FID){

	ETG_TRACE_USR1(( " bRegisterForFID  m_u16SrvRegID =%d u16FID=%d",m_u16SrvRegID,u16FID));

	if( ( AMT_C_U16_REGID_INVALID == m_u16SrvRegID ) || (poGWMain == NULL))
	{

		ETG_TRACE_USR1(( "   bRegisterForFID INVALID m_u16SrvRegID =%d u16FID=%d",m_u16SrvRegID,u16FID));
		return false;
	}
	gm_tclEmptyMessage oUpRegMessage
	(
			CCA_C_U16_APP_TUNERMASTER,          // AppID of this application
			CCA_C_U16_APP_FC_SXM,            // AppID of the other Server
			m_u16SrvRegID,                    // RegId for the service
			0,                            // always 0
			CCA_C_U16_SRV_SXM_AUDIO,            // the SID of the service
			u16FID,                       // the FID to register for
			AMT_C_U8_CCAMSG_OPCODE_UPREG  // this is an Upreg-message!
	);

	if( AIL_EN_N_NO_ERROR != poGWMain->enPostMessage(&oUpRegMessage) )
	{
		ETG_TRACE_USR1(( "bRegisterForFID POST error  m_u16SrvRegID =%d u16FID=%d",m_u16SrvRegID,u16FID));
		// Error in sending the message
		if(!oUpRegMessage.bDelete())
		{
			ETG_TRACE_USR4(("bRegisterForFID, Delete Error"));
			return false;
		}
	}
	return true;
}


/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_SXMClient::vRegisterForService
 *
 *DESCRIPTION:  Sends a register message to SPM.
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  TRUE  : No Error in registeration
 *              FALSE : Error in registeration
 *
 *
 ******************************************************************-FUNCHEADER*/
tVoid tunermaster_SXMClient::vRegisterForService(){

	tBool bIsServiceRegistered = FALSE;

	if ( AMT_C_U16_REGID_INVALID == m_u16SrvRegID )
	{
		// Signal to register to service
		if (NULL != poGWMain)
		{
			bIsServiceRegistered = poGWMain->bRegisterAsync (CCA_C_U16_SRV_SXM_AUDIO,
					MIDW_EXT_SXM_AUDIOFI_C_U16_SERVICE_MAJORVERSION                      /* Major version */,
					MIDW_EXT_SXM_AUDIOFI_C_U16_SERVICE_MINORVERSION                      /* Minor version */,
					0x0,
					CCA_C_U16_APP_FC_SXM
			);
		}
	}
	if (FALSE == bIsServiceRegistered)
	{
		ETG_TRACE_USR4(("vRegisterForService, audio Service Registration Error"));

	}
	else
	{
		ETG_TRACE_USR4(("vRegisterForService, audio Service SUCCESS"));

	}
}

/*************************************************************************
 * FUNCTION:     vOnAsyncRegisterConf
 *
 * DESCRIPTION:  SXM service registration confirmation function
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunermaster_SXMClient::vOnAsyncRegisterConf(tU16 u16RegisterId,tU16 u16ServerAppId,
				tU16 u16ServiceId,
				tU16 u16SourceSubID)
{
	m_u16SrvRegID=u16RegisterId;
	ETG_TRACE_USR1(("vRegisterForSXMService() m_u16SrvRegID=%d u16ServiceId=%d,u16SourceSubID=%d u16ServerAppId=%d"\
		,m_u16SrvRegID,u16ServiceId,u16SourceSubID,u16ServerAppId));
}

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_SXMClient::vUnregisterForService
 *
 *DESCRIPTION:  Sends a unregister message to SXM
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  TRUE  : No Error in unregisteration
 *              FALSE : Error in unregisteration
 *
 *
 ******************************************************************-FUNCHEADER*/
tVoid tunermaster_SXMClient::vUnregisterForService(){


	if ( AMT_C_U16_REGID_INVALID != m_u16SrvRegID )
	{

		// Send an unregister for service message
		if (NULL != poGWMain)
			poGWMain->vUnregisterService( (tU16) CCA_C_U16_SRV_SXM_AUDIO ); //Update to PM
		// Make register-ID invalid:
		m_u16SrvRegID = AMT_C_U16_REGID_INVALID;

		ETG_TRACE_USR4(( " vUnregisterForService  m_u16SrvRegID = %d",m_u16SrvRegID));
	}

}


/*************************************************************************
 *
 * FUNCTION:     tunermaster_SXMClient::vOnNewAppState
 *
 * DESCRIPTION:  Main calls this function whenever there is a change in
 *              power state to handle CCA service
 *
 * PARAMETER:    u32OldAppState : Last set application state
 *               u32AppState    : Current requested app state
 *
 * RETURNVALUE:  None
 *
 *
 *************************************************************************/
tVoid tunermaster_SXMClient::vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState)
{

		if(poGWMain == NULL)
		{
				NORMAL_M_ASSERT (NULL != poGWMain);
					return;
		}

		if( u32OldAppState == u32AppState)
			return;
		switch(u32AppState)
		{
			case AMT_C_U32_STATE_NORMAL:
			{
				// Register for service
				vRegisterForService();

			}
			break;

			case AMT_C_U32_STATE_OFF:
			{
				/*In case of APP state off*/
				vUnregisterForService();
			}
			break;

			default:
			{
				// Ideally should  not come here
				break;
			}
		} // switch(u32AppState)

}

/*************************************************************************
 *
 * FUNCTION:     tunermaster_SXMClient::vOnServiceState
 *
 * DESCRIPTION:  Main calls this function whenever there is a change in
 *              power state to handle CCA service
 *
 * PARAMETER:    u16ServiceId : Service ID
 *               u16RegisterId : Current requested app state *
 *               u8ServiceState
 *
 *
 * RETURNVALUE:  None
 *
 *
 *************************************************************************/
tVoid tunermaster_SXMClient::vOnServiceState(tU16 u16ServiceId,tU16 u16RegisterId, tU8 u8ServiceState, tU16 u16SubId)
{
		if((m_potunmstr_TunerClientHandler == NULL) || (m_potunmstr_Preset_Handler == NULL))
		{
			NORMAL_M_ASSERT (NULL != m_potunmstr_TunerClientHandler);
			NORMAL_M_ASSERT (NULL != m_potunmstr_Preset_Handler);
			return;
		}
		ETG_TRACE_USR1(( " vOnServiceState u16ServiceId=%d u8ServiceState=%d u16RegisterId=%d",u16ServiceId,u8ServiceState,u16RegisterId));

		if( CCA_C_U16_SRV_SXM_AUDIO != u16ServiceId )
		{

			return;
		}

		// Analyze the state of the server
		switch(u8ServiceState)
		{
		case AMT_C_U8_SVCSTATE_AVAILABLE:
			{
				// Get new service ID
				m_u16SrvRegID = u16RegisterId;

				ETG_TRACE_USR4(( "AVAILABLE u16ServiceId=%d u8ServiceState=%d u16RegisterId=%d",u16ServiceId,u8ServiceState,m_u16SrvRegID));
				bool bRegisterState = false;
				bRegisterState = bRegisterForFID( MIDW_EXT_SXM_AUDIOFI_C_U16_PRESETCHANNELUPDATE);
				if(!bRegisterState)
					ETG_TRACE_USR4(("vOnServiceState Register error , FID : %d ", MIDW_EXT_SXM_AUDIOFI_C_U16_PRESETCHANNELUPDATE));

				bRegisterState = bRegisterForFID( MIDW_EXT_SXM_AUDIOFI_C_U16_SYSTEMMESSAGE);
				if(!bRegisterState)
					ETG_TRACE_USR4(("vOnServiceState Register error , FID : %d ", MIDW_EXT_SXM_AUDIOFI_C_U16_SYSTEMMESSAGE));

				bRegisterState = bRegisterForFID( MIDW_EXT_SXM_AUDIOFI_C_U16_AUTOCOMPARE);
				if(!bRegisterState)
					ETG_TRACE_USR4(("vOnServiceState Register error , FID : %d ", MIDW_EXT_SXM_AUDIOFI_C_U16_AUTOCOMPARE));

				if((m_poclConfigInterface != nullptr) && (m_poclConfigInterface->u32GetConfigData("PresetListType")))
				{
					m_bServiceAvailable = TRUE;
					if(m_potunmstr_TunerClientHandler->u8GetTunerService())
					{
						m_potunmstr_Preset_Handler->Update_tunmstr_bStartUpFlag(TRUE);
						m_potunmstr_TunerClientHandler->vRequestMixedPresetList();
						m_potunmstr_Preset_Handler->Inc_m_u8SXMStartUp_HMI_Update();
						vGetPresetList();
					}
				}

				break;
			}
		case AMT_C_U8_SVCSTATE_NOT_AVAILABLE:
			{
				ETG_TRACE_USR1(( " vOnServiceState, service not avaial "));
				m_bServiceAvailable = FALSE;
				break;
			}
		default:
			{
				break;
			}
		} // switch(u8ServiceState)

}

/*******************************************************************************
 *FUNCTION:    tunermaster_SXMClient::vGetDataFromAmt
 *
 *DESCRIPTION: This function converts Amt message to visitor class and
 *             get the data from visitor to the Fi class. Refer FI Manual.
 *             Doc.
 *
 *PARAMETER:
 *           poFiMsg   - Amt Message
 *           oFIData   - Base class of Fi class
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunermaster_SXMClient::vGetDataFromAmt(amt_tclServiceData* poFIMsg,
		fi_tclTypeBase&     oFIData )const
{
	// Create Visitor message object for incoming message
	fi_tclVisitorMessage oInVisitorMsg(poFIMsg);

	/* Get the data in FI class from Vistor class*/
	if(OSAL_ERROR == oInVisitorMsg.s32GetData(oFIData,1))
	{
		// assert here
		NORMAL_M_ASSERT_ALWAYS ();
	}
}

tVoid tunermaster_SXMClient :: vSendMessage( tU16             u16DestAppID,
		const fi_tclTypeBase&  oOutData,
		tU16             u16Fid,
		tU8              u8OpCode,
		tU16             u16CmdCtr)
{

		fi_tclVisitorMessage oOutVisitorMsg(oOutData,1);


		// Set the CCA message information
		oOutVisitorMsg.vInitServiceData(  CCA_C_U16_APP_TUNERMASTER,                  /* Source app-ID    */
				u16DestAppID,                         /* Dest. app-ID     */
				AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,    /* stream type      */
				0,                                    /* stream counter   */
				m_u16SrvRegID,                        /* Registry ID      */
				u16CmdCtr,                            /* Command counter  */
				CCA_C_U16_SRV_SXM_AUDIO,           /* Service-ID       */
				u16Fid,                               /* Function-ID      */
				u8OpCode,                             /* OpCode           */
				0,                                    /* ACT              */
				0,                                    /* Source sub-ID    */
				0 );                                  /* Dest. sub-ID     */

		if ( NULL == poGWMain )
		{

			NORMAL_M_ASSERT (NULL != poGWMain);
			return;

		}

		// Send it to the client
		if(poGWMain->enPostMessage(&oOutVisitorMsg, TRUE) != AIL_EN_N_NO_ERROR)
		{
			//Trace for Error message if required.
		}

}

/*******************************************************************************
 *FUNCTION:    tunermaster_SXMClient::vSendSXMListonlinePersonalization
 *
 *DESCRIPTION: Function to send request to configure new presets received from Profile manager.
 *
 *PARAMETER:
 *           midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunermaster_SXMClient::vSendSXMListonlinePersonalization(midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart& SXMList)
{

	ETG_TRACE_USR4(( "vSendSXMListonlinePersonalization SXMList lsize =%d ",SXMList.PresetEntry.size()));

	#if 0
	/*Keep only for quick debugging not release*/
		for (std::vector<midw_ext_fi_tcl_PresetEntry>::iterator it = SXMList.PresetEntry.begin() ; it != SXMList.PresetEntry.end() ; it++ )
		{
			ETG_TRACE_USR4(( "vSendSXMListonlinePersonalization Sid  =%d ",it->SID));
		}
	#endif
	vSendMessage( CCA_C_U16_APP_FC_SXM,// Destination APP ID
		SXMList,           // parameter&
		MIDW_EXT_SXM_AUDIOFI_C_U16_SETPRESETLIST, //FID
		AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
		0
		);
}
#ifdef INCLUDE_PROFILE_MANAGER
/*************************************************************************
 *
 * FUNCTION:    vSet_PMClient_Handler_Ptr(tunermaster_PMClient* po_PMClient_Handler)
 *
 * DESCRIPTION: Set pointer to pointer tunermaster_PMClient
 *
 * PARAMETER:   tunermaster_PMClient* po_PMClient_Handler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunermaster_SXMClient::vSet_PMClient_Handler_Ptr(tunermaster_PMClient* po_PMClient_Handler)
{
	if( NULL != po_PMClient_Handler  )
	{
		 m_ptunmaster_PMClient = ( tunermaster_PMClient* )po_PMClient_Handler;
	}
}
#endif

/*************************************************************************
 *
 * FUNCTION:    vSet_Preset_Handler_Ptr(tunmstr_Preset_Handler* po_tunmstr_PresetHandler)
 *
 * DESCRIPTION: Update pointer m_potunmstr_Preset_Handler
 *
 * PARAMETER:   tunmstr_Preset_Handler* po_tunmstr_PresetHandler
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunermaster_SXMClient::vSet_Preset_Handler_Ptr(tunmstr_Preset_Handler* po_tunmstr_PresetHandler)
{
	if( po_tunmstr_PresetHandler != nullptr  )
	{
		m_potunmstr_Preset_Handler = po_tunmstr_PresetHandler;
	}
}


/*************************************************************************
 *
 * FUNCTION:    vSet_tunmstrMsgToHMI_Ptr(tunmstr_MsgToHMI* po_tunmstr_MsgToHMI)
 *
 * DESCRIPTION: Update pointer m_potunmstr_MsgToHMI
 *
 * PARAMETER:   tunmstr_MsgToHMI* po_tunmstr_MsgToHMI
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunermaster_SXMClient::vSet_tunmstrMsgToHMI_Ptr(tunmstr_MsgToHMI* po_tunmstr_MsgToHMI)
{
	if( po_tunmstr_MsgToHMI != NULL  )
	{
		m_potunmstr_MsgToHMI = po_tunmstr_MsgToHMI;
	}
}


/*************************************************************************
* FUNCTION:    vSet_tunmstr_ConfigInterface_Ptr
*
* DESCRIPTION:
*
* PARAMETER:   clConfigInterface* poclConfigInterface
*
* RETURNVALUE:  void
*************************************************************************/

tVoid tunermaster_SXMClient::vSet_tunmstr_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface)
{
	if( poclConfigInterface != nullptr )
	{
		m_poclConfigInterface = poclConfigInterface;
	}

}


/*************************************************************************
 *
 * FUNCTION:    vSet_tunmstrMsgFromHMI_Ptr(tunmstr_MsgFromHMI* po_tunmstr_MsgFromHMI)
 *
 * DESCRIPTION: Update pointer m_potunmstr_MsgFromHMI
 *
 * PARAMETER:   tunmstr_MsgToHMI* po_tunmstr_MsgFromHMI
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunermaster_SXMClient::vSet_tunmstrMsgFromHMI_Ptr(tunmstr_MsgFromHMI* po_tunmstr_MsgFromHMI)
{
	if( po_tunmstr_MsgFromHMI != NULL  )
	{
		m_potunmstr_MsgFromHMI = po_tunmstr_MsgFromHMI;
	}
}


/*************************************************************************
 *
 * FUNCTION:     tunmstr_MsgFromHMI::vSet_tunmaster_Config_Ptr( )
 *
 * DESCRIPTION:  Set pointer to pointer m_potunmstr_TunerClientHandler*
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunermaster_SXMClient::vSet_tunmstr_TunerClientHandler_Ptr( tunmstr_TunerClientHandler* potunmstr_TunerClientHandler )
{
	if( potunmstr_TunerClientHandler != NULL )
	{
		m_potunmstr_TunerClientHandler = ( tunmstr_TunerClientHandler* )potunmstr_TunerClientHandler;
	}
	else
	{
		NORMAL_M_ASSERT ( m_potunmstr_TunerClientHandler != NULL );
	}
}


/*******************************************************************************
 *FUNCTION:    tunermaster_SXMClient::vSendUserProfileAction
 *
 *DESCRIPTION: Function to send request user action received from profile manager
 *
 *PARAMETER:
 *           midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunermaster_SXMClient::vSendUserProfileAction(midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart& UserProfileAction)
{

	vSendMessage( CCA_C_U16_APP_FC_SXM,// Destination APP ID
		UserProfileAction,           // parameter&
		MIDW_EXT_SXM_AUDIOFI_C_U16_USERPROFILE, //FID
		AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
		0
		);
}

/*******************************************************************************
 *FUNCTION:    tunermaster_SXMClient::vHandle_SetPresetListResult
 *
 *DESCRIPTION: Handler for message result MIDW_EXT_SXM_AUDIOFI_C_U16_SETPRESETLIST
 *
 *PARAMETER:
 *           amt_tclServiceData
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunermaster_SXMClient::vHandle_SetPresetListResult(amt_tclServiceData* poMessage)
{
	if((NULL==poMessage)
#ifdef INCLUDE_PROFILE_MANAGER
			|| (NULL == m_ptunmaster_PMClient )
#endif
			)
		{
			ETG_TRACE_USR4(("vHandleUserProfileResult, NULL Message"));
			return;
		}
		switch (poMessage->u8GetOpCode())
		{
			case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
			{
				ETG_TRACE_USR4(("vHandleDeletePresetResult() result"));

				if(m_potunmstr_Preset_Handler->enGetPreserRequest() == NormalPresetDelete)
				{
					m_potunmstr_Preset_Handler->vUpdateSXMPresetActionMethodResult(poMessage , (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETDELETE_ONE);
				}
				else if(m_potunmstr_Preset_Handler->enGetPreserRequest() == NormalPresetDeleteAll)
				{
					m_potunmstr_Preset_Handler->vUpdateSXMPresetActionMethodResult(poMessage , (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETDELETE_ALL);
				}
				else
				{
#ifdef INCLUDE_PROFILE_MANAGER
					midw_ext_sxm_audiofi_tclMsgSetPresetListMethodResult oMsg;
					vGetDataFromAmt(poMessage,oMsg);

					midw_fi_tcl_TunMstr_RadioSetting_StatusResponse TunerMasterResponse;
					TunerMasterResponse.RadioProfileSetting_Response.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_SUCCEED;
					TunerMasterResponse.RadioProfileSetting_ErrorCode.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_NONE;

					if(false ==oMsg.Status)
					{
						TunerMasterResponse.RadioProfileSetting_Response.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_FAILED_FOR_SXM;
						TunerMasterResponse.RadioProfileSetting_ErrorCode.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_UNKNOWN;
						m_ptunmaster_PMClient->vSendResponseToRadioSetting(TunerMasterResponse);
					}
#endif
				}
				break;
			}
			case AMT_C_U8_CCAMSG_OPCODE_ERROR:
			{
				ETG_TRACE_USR4(("vHandleDeletePresetResult() error"));

				if(m_potunmstr_Preset_Handler->enGetPreserRequest() == NormalPresetDelete)
				{
					m_potunmstr_Preset_Handler->vSendSXMPresetActionMethodResult((tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETDELETE_ONE , FALSE);
				}
				else if(m_potunmstr_Preset_Handler->enGetPreserRequest() == NormalPresetDeleteAll)
				{
					m_potunmstr_Preset_Handler->vSendSXMPresetActionMethodResult((tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETDELETE_ALL , FALSE);
				}
				else
				{
					// no operation
				}
				break;
			}

			default:
				break;
		}
}

#ifdef INCLUDE_PROFILE_MANAGER
/*******************************************************************************
 *FUNCTION:    tunermaster_SXMClient::vHandleUserProfileResult
 *
 *DESCRIPTION: Handler for message result MIDW_EXT_SXM_AUDIOFI_C_U16_USERPROFILE
 *
 *PARAMETER:
 *           amt_tclServiceData
 *
 *RETURNVALUE: None
 ********************************************************************************/
tVoid tunermaster_SXMClient::vHandleUserProfileResult(amt_tclServiceData* poMessage)
{

	if((NULL==poMessage) || (NULL == m_ptunmaster_PMClient ))
	{
		return;
		ETG_TRACE_USR4(("vHandleUserProfileResult, NULL Message"));
	}
	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
		{
			midw_ext_sxm_audiofi_tclMsgUserProfileMethodResult oMsg;
			vGetDataFromAmt(poMessage,oMsg);

			tU8 u8Status = TUNMSTR_PROFILE_USER_ACTION_FAIL;
			if (midw_ext_fi_tcl_Status::FI_EN_SUCCESS == oMsg.ProfileResponse.Status.enType)
				u8Status = TUNMSTR_PROFILE_USER_ACTION_SUCESS;

			switch(oMsg.ProfileResponse.ProfileAction.enType)
			{

				case  midw_ext_fi_tcl_ProfileAction::FI_EN_ACTIVEPROFILE:
				{
					m_ptunmaster_PMClient->vHandleOnDataChanged((tU8)u8Status);
					break;
					ETG_TRACE_USR4(("vHandleUserProfileResult activate u8Status =%d   ",u8Status));

				}
				case  midw_ext_fi_tcl_ProfileAction::FI_EN_COPYPROFILE:
				{
					m_ptunmaster_PMClient->vHandleOnProfileCopied((tU8)u8Status);
					ETG_TRACE_USR4(("vHandleUserProfileResult Copy u8Status =  %d   ",u8Status));
					break;
				}
				case  midw_ext_fi_tcl_ProfileAction::FI_EN_DELETEPROFILE:
				{
					m_ptunmaster_PMClient->vHandleOnProfileDeleted((tU8)u8Status);
					ETG_TRACE_USR4(("vHandleUserProfileResult Delete u8Status =%d   ",u8Status));
					break;
				}
				case  midw_ext_fi_tcl_ProfileAction::FI_EN_DATACHANGE:
				{
					switch(oMsg.ProfileResponse.ProfileStatus.enType)
					{
						case midw_ext_fi_tcl_ProfileStatus::FI_EN_PREPARE:
								m_ptunmaster_PMClient->vHandleOnDataChanged_Prepare((tU8)oMsg.ProfileResponse.Status.enType);
							ETG_TRACE_USR4(("vHandleUserProfileResult Datachange Prepare u8Status =%d   ",u8Status));
							break;
						case midw_ext_fi_tcl_ProfileStatus::FI_EN_CHANGED:
							m_ptunmaster_PMClient->vHandleOnDataChanged((tU8)u8Status);
							ETG_TRACE_USR4(("vHandleUserProfileResult Datachange Changed u8Status =%d   ",u8Status));
							break;
						case midw_ext_fi_tcl_ProfileStatus::FI_EN_RESET:
							//Do nothing
							break;
						default:
							break;
					}

					break;
				}
				default:
				{
					break;
				}

			}
			break;
		}
		default:
			break;
	}


}
#endif
/*************************************************************************
 *
 * FUNCTION:     tunermaster_SXMClient::vHandlePresetChannelUpdate(amt_tclServiceData* poMessage)
 *
 * DESCRIPTION:  Handle for PresetChannelUpdate property
 *
 * PARAMETER:    amt_tclServiceData
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunermaster_SXMClient::vHandlePresetChannelUpdate(amt_tclServiceData* poMessage)
{
	if((nullptr == poMessage) || ( nullptr == m_potunmstr_Preset_Handler)
#ifdef 	INCLUDE_PROFILE_MANAGER
			|| ( nullptr == m_ptunmaster_PMClient)
#endif
	)
	{
		ETG_TRACE_USR4(("vHandlePresetChannelUpdate is NULL"));
			return;

	}
	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_STATUS:
		{
			midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus oMsgStatus;
			vGetDataFromAmt(poMessage,oMsgStatus);
			/*mhv6kor below debug statement is required for debug, better to keep in production code also */
			ETG_TRACE_USR4(( " vHandlePresetChannelUpdate  PresetIndex =%d ",oMsgStatus.PresetIndex));
			ETG_TRACE_USR4(( " vHandlePresetChannelUpdate  LinearPresetIndex =%d ",oMsgStatus.LinearPresetIndex));
			ETG_TRACE_USR4(( " vHandlePresetChannelUpdate  PresetBand =%d ",oMsgStatus.PresetBand));
			ETG_TRACE_USR4(( " vHandlePresetChannelUpdate  ServiceID =%d ",oMsgStatus.ChannelInfo.ServiceID));
#ifdef INCLUDE_PROFILE_MANAGER
			m_ptunmaster_PMClient->vIndividualTunerPresetListUpdate(oMsgStatus);
#endif
			m_potunmstr_Preset_Handler->vUpdateSXMPresetChannel(poMessage);
			break;
		}

		default:
		{
				break;
		}
	}

}


/*************************************************************************
 *
 * FUNCTION:     tunermaster_SXMClient::vHandleSystemMessageUpdate(amt_tclServiceData* poMessage)
 *
 * DESCRIPTION:  Handle for SystemMessage property
 *
 * PARAMETER:    amt_tclServiceData
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunermaster_SXMClient::vHandleSystemMessageUpdate(amt_tclServiceData* poMessage)
{
	if((nullptr == poMessage) || (nullptr == m_potunmstr_MsgToHMI) || (nullptr == m_poclConfigInterface))
	{
		ETG_TRACE_USR4(("vHandleSystemMessageUpdate is NULL"));
			return;

	}
	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_STATUS:
		{
			tBool blIsmixedPreset= (tBool)m_poclConfigInterface->u32GetConfigData("PresetListType");
			if(blIsmixedPreset==TRUE)
			{
				midw_ext_sxm_audiofi_tclMsgSystemMessageStatus oMsgStatus;
				vGetDataFromAmt(poMessage,oMsgStatus);

				ETG_TRACE_USR4(( " vHandleSystemMessageUpdate  SystemErrorType =%d ",(tU8)oMsgStatus.SystemErrorType.enType));
				ETG_TRACE_USR4(( " vHandleSystemMessageUpdate  ChannelNumber =%d ",oMsgStatus.CID));
				m_potunmstr_MsgToHMI->vSend_g_SystemMessage((tU8)oMsgStatus.SystemErrorType.enType , oMsgStatus.CID);
			}

			break;
		}

		default:
		{
				break;
		}
	}

}


/*************************************************************************
 *
 * FUNCTION:     tunermaster_SXMClient::vHandlePresetListResult(amt_tclServiceData* poMessage)
 *
 * DESCRIPTION:  Handle for GetPresetList result
 *
 * PARAMETER:    amt_tclServiceData
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunermaster_SXMClient::vHandlePresetListResult(amt_tclServiceData* poMessage)
{
	if((nullptr == poMessage) || ( nullptr == m_potunmstr_Preset_Handler))
	{
		ETG_TRACE_USR4(("vHandlePresetListResult is NULL"));
		return;
	}
	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
		{
			ETG_TRACE_USR4(("vHandlePresetListResult()"));
			m_potunmstr_Preset_Handler->vUpdateSXMPresetList(poMessage);
			break;
		}

		default:
		{
			break;
		}
	}
}


/*************************************************************************
 *
 * FUNCTION:     tunermaster_SXMClient::vHandleRecallPresetResult(amt_tclServiceData* poMessage)
 *
 * DESCRIPTION:  Handle for RecallPresetList result
 *
 * PARAMETER:    amt_tclServiceData
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunermaster_SXMClient::vHandleRecallPresetResult(amt_tclServiceData* poMessage)
{
	if((nullptr == poMessage) || ( nullptr == m_potunmstr_Preset_Handler))
	{
		ETG_TRACE_USR4(("vHandlePresetListResult is NULL"));
		return;
	}
	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
		{
			ETG_TRACE_USR4(("vHandleRecallPresetResult() result"));
			tU8 u8PresetAction = (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETRECALL;
			m_potunmstr_Preset_Handler->vUpdateSXMPresetChannel(poMessage , u8PresetAction);
			m_potunmstr_Preset_Handler->vUpdateSXMPresetActionMethodResult(poMessage , u8PresetAction);
			break;
		}
		case AMT_C_U8_CCAMSG_OPCODE_ERROR:
		{
			ETG_TRACE_USR4(("vHandleRecallPresetResult() error"));
			m_potunmstr_Preset_Handler->vSendSXMPresetActionMethodResult((tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETRECALL , FALSE);
			break;
		}
		default:
		{
			break;
		}
	}
}


/*************************************************************************
 *
 * FUNCTION:     tunermaster_SXMClient::vHandleStorePresetResult(amt_tclServiceData* poMessage)
 *
 * DESCRIPTION:  Handle for StorePreset result
 *
 * PARAMETER:    amt_tclServiceData
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunermaster_SXMClient::vHandleStorePresetResult(amt_tclServiceData* poMessage)
{
	if((nullptr == poMessage) || ( nullptr == m_potunmstr_Preset_Handler))
	{
		ETG_TRACE_USR4(("vHandleStorePresetResult is NULL"));
		return;
	}
	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
		{
			ETG_TRACE_USR4(("vHandleStorePresetResult() method result"));
			tU8 u8PresetAction = (tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETSAVE;
			m_potunmstr_Preset_Handler->vUpdateSXMPresetChannel(poMessage , u8PresetAction);
			m_potunmstr_Preset_Handler->vUpdateSXMPresetActionMethodResult(poMessage , u8PresetAction);
			break;
		}
		case AMT_C_U8_CCAMSG_OPCODE_ERROR:
		{
			ETG_TRACE_USR4(("vHandleStorePresetResult() error"));
			m_potunmstr_Preset_Handler->vSendSXMPresetActionMethodResult((tU8)midw_fi_tcl_e8_Preset_Action::FI_EN_TUNMSTR_PRESETSAVE , FALSE);
			break;
		}
		default:
		{
			break;
		}
	}
}


/*************************************************************************
 *
 * FUNCTION:     tunermaster_SXMClient::vHandlePresetAutoCompare(amt_tclServiceData* poMessage)
 *
 * DESCRIPTION:  Handle for Preset AutoCompare property
 *
 * PARAMETER:    amt_tclServiceData
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunermaster_SXMClient::vHandlePresetAutoCompare(amt_tclServiceData* poMessage)
{
	if((NULL == poMessage) || ( NULL == m_potunmstr_MsgFromHMI) || (NULL == m_potunmstr_MsgToHMI))
	{
		ETG_TRACE_USR4(("vHandlePresetAutoCompare, NULL pointer return"));
		return;

	}
	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_STATUS:
		{
			midw_ext_sxm_audiofi_tclMsgAutoCompareStatus oMsgStatus;
			vGetDataFromAmt(poMessage,oMsgStatus);

			if(m_potunmstr_MsgFromHMI->bGetSXMSrcState())
			{
				ETG_TRACE_USR4(("vHandlePresetAutoCompare, preset autocompare : %d", oMsgStatus.TunerElemNr));
				m_potunmstr_MsgToHMI->vSend_g_PresetAutoCompare(oMsgStatus.TunerElemNr, FALSE);
			}
			m_u8PresetAutocompare = oMsgStatus.TunerElemNr;
			break;
		}

		default:
		{
				break;
		}
	}

}


/*************************************************************************
 *
 * FUNCTION:     tunermaster_SXMClient::vGetPresetList()
 *
 * DESCRIPTION:  Request for GetPresetList
 *
 * PARAMETER:
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunermaster_SXMClient::vGetPresetList()
{

	ETG_TRACE_USR4(("vGetPresetList()"));

	midw_ext_sxm_audiofi_tclMsgGetPresetListMethodStart oMethodStart;
	oMethodStart.PresetBand = 0xFF;

	vSendMessage( CCA_C_U16_APP_FC_SXM,// Destination APP ID
		oMethodStart,           // parameter&
		MIDW_EXT_SXM_AUDIOFI_C_U16_GETPRESETLIST, //FID
		AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode
		0
		);

}

/*************************************************************************
 *
 * FUNCTION:     tunermaster_SXMClient::bGetServiceStatus()
 *
 * DESCRIPTION:  Return service status
 * PARAMETER:
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tBool tunermaster_SXMClient::bGetServiceStatus()
{

	ETG_TRACE_USR4(("bGetServiceAvail : %d",m_bServiceAvailable));

	return m_bServiceAvailable;

}


/*************************************************************************
 *
 * FUNCTION:     tunermaster_SXMClient::u8GetPresetAutoCompare()
 *
 * DESCRIPTION:  Return preset autocompare
 * PARAMETER:
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tBool tunermaster_SXMClient::u8GetPresetAutoCompare()
{

	ETG_TRACE_USR4(("u8GetPresetAutoCompare : %d",m_u8PresetAutocompare));

	return m_u8PresetAutocompare;

}


#endif


