///////////////////////////////////////////////////////////
//  tunermaster_PMClient.cpp
//  Implementation of the Class tunermaster_PMClient
//  Created on:      26-Jun-2017 11:42:28 AM
//  Original author: MHV6KOR
///////////////////////////////////////////////////////////

#include "../Header/tunermaster_PMClient.h"
/************************************************************************
* FILE:           tunermaster_PMClient
* PROJECT:        G3g
* SW-COMPONENT:   Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION:    FC_Tunermaster registers as client to Profile Manager 
*
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2017 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:

* Date           | Author                       		| Modification
 | initial version
* 26.06.17  	 | MHV6KOR  						    | First version of the for Personalization feature.
				
												
*************************************************************************/

//-----------------------------------------------------------------------------
// includes
//-----------------------------------------------------------------------------

#ifdef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#include "ahl_mock/ahl_if.h"
#include "amt_mock/amt_if.h"
#else
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif

// Include common fi interface
#define FI_S_IMPORT_INTERFACE_BASE_TYPES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "common_fi_if.h"
#ifdef INCLUDE_PROFILE_MANAGER
#define PROFILE_FI_S_IMPORT_INTERFACE_PROFILE_MAINFI_STDVISITORS
#define PROFILE_FI_S_IMPORT_INTERFACE_PROFILE_MAINFI_FUNCTIONIDS
#define PROFILE_FI_S_IMPORT_INTERFACE_PROFILE_MAINFI_SERVICEINFO
#include "profile_fi_if.h"
#endif

#ifndef VARIANT_S_FTR_ENABLE_TUNERMASTER_MOCK
#define DP_S_IMPORT_INTERFACE_FI
#include "dp_generic_if.h"
#include "dp_tuner_if.h"
#endif
#define ETRACE_S_IMPORT_INTERFACE_GENERIC
#include "etrace_if.h"
#ifndef TUNERMASTER_DEFINES_H
#include "tunermaster_defines.h"
#endif
#ifndef TUNMSTR_SRCCHG_SRCCHG_DEFINES_H
#include "tunmstr_SrcChg_Defines.h"
#endif

//------------------------
// Local headers
//------------------------
#include "fc_tunermaster_featureControl.h"
// Self header

#include "tunermaster_main.h"

// trace defines.
#include "tunermaster_trace.h"

#include "tunermaster_defines.h"
#include "tunermaster_PrjConfig.h"
#include "tunermaster_Config.h"
#ifndef VARIANT_S_FTR_ENABLE_FEATURE_GMMY16
#include "tunmstr_TunerClientHandler.h"
#endif
#include "tunmstr_DiagLogClientHandler.h"
#include "datatypes/tunerDatatypes.h"

#ifdef VARIANT_S_FTR_ENABLE_TRC_GEN
#define ETG_DEFAULT_TRACE_CLASS TUNMSTR_TRACE_CLASS_PM_CLIENT
#include "trcGenProj/Header/tunermaster_PMClient.cpp.trc.h"
#endif

#include "tunmstr_MsgToHMI.h"
#include "tunmstr_DABClient_Handler.h"
#include "tunermaster_Config.h"
#include "kdsconfig/clConfigInterface.h"


/* ---
MESSAGE MAP:
enter the function IDs (FID) and the corresponding functions here.
the function will be called when a message with the corresponding FID arrives
--- */
/* need to update after fi check.*/
#ifdef INCLUDE_PROFILE_MANAGER
BEGIN_MSG_MAP(tunermaster_PMClient, ahl_tclBaseWork)
ON_MESSAGE( PROFILE_MAINFI_C_U16_ACTIVEPROFILE, vHandleActiveProfile)
ON_MESSAGE( PROFILE_MAINFI_C_U16_STATUS, vHandleStatus)
ON_MESSAGE( PROFILE_MAINFI_C_U16_DATACHANGED, vHandleDataChanged)
ON_MESSAGE( PROFILE_MAINFI_C_U16_COPYPROFILE, vHandleCopyProfile)
ON_MESSAGE( PROFILE_MAINFI_C_U16_DELETEPROFILE, vHandleDeleteProfile)
ON_MESSAGE( PROFILE_MAINFI_C_U16_REGISTERCLIENT, vHandleDoRegisterClient)
END_MSG_MAP()
/**/



static stTunermasterPresetListMap astTunermasterPresetListMap[] =
{
	#define TUNERMASTER_LIST_PRESET_MAPPING(KDSdata, midwPresetListID, LastPresetNumber )                  { KDSdata, midwPresetListID,LastPresetNumber},
	#include "midwTunerMasterListPresetMapping.dat"
	#undef TUNERMASTER_LIST_PRESET_MAPPING
};
#endif


#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
tunermaster_PMClient::tunermaster_PMClient(tunmaster_tclApp* poMainApp):
poGWMain(poMainApp),m_u16SrvRegID(AMT_C_U16_REGID_INVALID)
#ifdef INCLUDE_PROFILE_MANAGER
, m_u16DestAppID(AMT_C_U16_APPID_INVALID)
, m_u16CmdCtr(0)
, m_u16GetFunctionID(0)
, m_u16GetRegisterID(0)
#endif
,m_u8UserID(0xFF),m_u8Action(en_actionNone),m_bResponseSentToPM(false)\
,m_u8MasterListLastPresetID(0)\
,m_u8RadioProfileSettingRequestCount(0)\
,m_u8NoOfPresetListUpdateRequest(0)\
,m_bRadioSettingResponseSent(false)\
,m_potunmstr_MsgToHMI(NULL)\
,m_potunmstr_TunClnt_Handlr(NULL),m_potunmstr_DABClient_Handler(NULL)\
,m_potunmstr_Preset_Handler(NULL)\
,m_poclConfigInterface(NULL)\
,m_poArlSourceImpl(NULL)\
,m_potunmstr_MsgFromHMI(NULL)
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
,m_potunmstr_SXMClient_Handler(NULL)
#endif
,m_bDeleteOthersOption(false)
{

}
#else
tunermaster_PMClient::tunermaster_PMClient(tunmaster_tclApp* poMainApp):
poGWMain(poMainApp),m_u16SrvRegID(AMT_C_U16_REGID_INVALID)
#ifdef INCLUDE_PROFILE_MANAGER
, m_u16DestAppID(AMT_C_U16_APPID_INVALID)
, m_u16CmdCtr(0)
, m_u16GetFunctionID(0)
, m_u16GetRegisterID(0)
#endif
,m_u8UserID(0xFF),m_u8Action(en_actionNone),m_bResponseSentToPM(false)\
,m_u8MasterListLastPresetID(0)\
,m_u8RadioProfileSettingRequestCount(0)\
,m_u8NoOfPresetListUpdateRequest(0)\
,m_bRadioSettingResponseSent(false)\
,m_potunmstr_MsgToHMI(NULL)\
,m_potunmstr_TunClnt_Handlr(NULL),m_potunmstr_DABClient_Handler(NULL)\
,m_potunmstr_Preset_Handler(NULL)\
,m_poclConfigInterface(NULL)\
,m_potunmstr_MsgFromHMI(NULL)
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
,m_potunmstr_SXMClient_Handler(NULL)
#endif
,m_bDeleteOthersOption(false)
{
	//m_u8UserID = 0xFF; //FF is used 0 is Guest user
}

#endif

tunermaster_PMClient::~tunermaster_PMClient(){
	poGWMain     = NULL;
	m_u8UserID = 0xFF; //FF is used 0 is Guest user
	m_potunmstr_TunClnt_Handlr =NULL;
	m_potunmstr_DABClient_Handler =NULL;
	m_potunmstr_MsgToHMI = NULL;
	m_poclConfigInterface = NULL ;
	m_potunmstr_Preset_Handler = NULL;
	m_bRadioSettingResponseSent = false;
}


tVoid tunermaster_PMClient::vOnUnknownMessage(amt_tclBaseMessage* /*poMessage*/)
{
	// do NOTHING


}

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_PMClient::vOnServiceState
 *
 *DESCRIPTION:  Handles the state changes of the service we use
 *
 *PARAMETER:    u16ServiceId  : Service id whose service state is sent
 *              u16ServerId   : Server id who sends this service state
 *              u16RegisterId : Register id for service whose service state
 *                              is sent
 *              u8ServiceState: Service state of the registered service
 *              u16SubId      : SubId whose service state is sent
 *
 *RETURNVALUE: None
 *
 ******************************************************************-FUNCHEADER*/
tVoid tunermaster_PMClient::vOnServiceState( tU16 u16ServiceId,tU16 u16ServerId,
											  tU16 u16RegisterId,tU8  u8ServiceState,tU16 u16SubId)
{
	ETG_TRACE_USR1(( " vOnServiceState u16ServiceId=%d u8ServiceState=%d u16RegisterId=%d u16ServerId=%d u16SubId=%d",u16ServiceId,u8ServiceState,u16RegisterId,u16ServerId,u16SubId));
#ifdef INCLUDE_PROFILE_MANAGER
	// We are interested only in SPM service
	if( CCA_C_U16_SRV_USERMANAGER != u16ServiceId )
	{

		return;
	}
	// Get new service ID
	m_u16SrvRegID = u16RegisterId;

	// Analyze the state of the server
	switch(u8ServiceState)
	{
	case AMT_C_U8_SVCSTATE_AVAILABLE:
		{
			
			ETG_TRACE_USR4(( "AVAILABLE u16ServiceId=%d u8ServiceState=%d u16RegisterId=%d",u16ServiceId,u8ServiceState,u16RegisterId));
			fRegisterForFID( PROFILE_MAINFI_C_U16_ACTIVEPROFILE);
			fRegisterForFID( PROFILE_MAINFI_C_U16_STATUS );
			fRegisterForFID( PROFILE_MAINFI_C_U16_DATACHANGED );
			fRegisterForFID( PROFILE_MAINFI_C_U16_COPYPROFILE);
			fRegisterForFID( PROFILE_MAINFI_C_U16_DELETEPROFILE);
			vRegisterClient();
			break;
		}
	default:
		{
			break;
		}
	} // switch(u8ServiceState)
	#endif
}

tVoid tunermaster_PMClient::vRegisterClient()
{
#ifdef INCLUDE_PROFILE_MANAGER
	profile_mainfi_tclMsgRegisterClientMethodStart oRegisterClientMethodStart;
				vSendMessage( CCA_C_U16_APP_FC_USERMANAGER,// Destination APP ID
													oRegisterClientMethodStart,           // parameter&
													PROFILE_MAINFI_C_U16_REGISTERCLIENT, //FID
													AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode
													0 //CmdCntr
				);
#endif
}

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_PMClient::fRegisterForService
 *
 *DESCRIPTION:  Sends a register message to SPM.
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  TRUE  : No Error in registration
 *              FALSE : Error in registration
 *
 *
 ******************************************************************-FUNCHEADER*/
tVoid tunermaster_PMClient::fRegisterForService()
{

	// Return value
#ifdef INCLUDE_PROFILE_MANAGER
	tBool bIsServiceRegistered = FALSE;

	// Is registration invalid ?
	if ( AMT_C_U16_REGID_INVALID == m_u16SrvRegID )
	{
		// Signal that service is registered


		// Try to register
		// Try to register
		if (NULL != poGWMain)
		{
			bIsServiceRegistered = poGWMain->bRegisterAsync (CCA_C_U16_SRV_USERMANAGER,
					PROFILE_MAINFI_C_U16_SERVICE_MAJORVERSION                      /* Major version */,
					PROFILE_MAINFI_C_U16_SERVICE_MINORVERSION                      /* Minor version */,
					0x0,
					CCA_C_U16_APP_FC_USERMANAGER
			);
		}





	}


	// Determine whether the service is registered / registeration was successful
	// fIsServiceRegistered = ( AMT_C_U16_REGID_INVALID != m_u16SrvRegID);

	if (FALSE == bIsServiceRegistered)
	{
		ETG_TRACE_USR4(("fRegisterForService, Service Registration Error"));

	}
	else
	{
		ETG_TRACE_USR4(("fRegisterForService, Service SUCCESS"));
		//vPersonalizationMasterListCreation();

	}
	#endif
	// return whether the service is registered


}

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_PMClient::fUnregisterForService
 *
 *DESCRIPTION:  Sends a unregister message to SPM
 *
 *PARAMETER:    None
 *
 *RETURNVALUE:  TRUE  : No Error in unregisteration
 *              FALSE : Error in unregisteration
 *
 *
 ******************************************************************-FUNCHEADER*/
tVoid tunermaster_PMClient::fUnregisterForService()
{
		
	// Return value
#ifdef INCLUDE_PROFILE_MANAGER
	// Unregister if registration is valid?
	if ( AMT_C_U16_REGID_INVALID != m_u16SrvRegID )
	{

		// Send an unregister for service message
		if (NULL != poGWMain)
			poGWMain->vUnregisterService( (tU16) CCA_C_U16_SRV_USERMANAGER ); //Update to PM

		// Make register-ID invalid:
		m_u16SrvRegID = AMT_C_U16_REGID_INVALID;

		ETG_TRACE_USR4(( " fUnregisterForService  m_u16SrvRegID = %d",m_u16SrvRegID));
	}

#endif
	// return whether the service is unregistered

}


/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_PMClient::fRegisterForFID
 *
 *DESCRIPTION:  Registers for a function of a service
 *              !!! before this, you must register for the service !!!
 *
 *PARAMETER:    u16FID : FID of the function to be registered (upreg)
 *
 *RETURNVALUE:  TRUE  : No Error in FID registeration
 *              FALSE : Error in FID registeration
 *
 *
 ******************************************************************-FUNCHEADER*/
tBool tunermaster_PMClient::fRegisterForFID(tU16 u16FID)
{
	// Return value
	tBool bIsServiceRegistered = FALSE;
	ETG_TRACE_USR1(( " fRegisterForFID  m_u16SrvRegID =%d u16FID=%d",m_u16SrvRegID,u16FID));
#ifdef INCLUDE_PROFILE_MANAGER


	// Is registration invalid?
	if ( AMT_C_U16_REGID_INVALID == m_u16SrvRegID )
	{
		// Ideally should  not come here
		ETG_TRACE_USR1(( "   fRegisterForFID INVALID m_u16SrvRegID =%d u16FID=%d",m_u16SrvRegID,u16FID));
	}

	gm_tclEmptyMessage oUpRegMessage
	(
			CCA_C_U16_APP_TUNERMASTER,          // AppID of this application
			CCA_C_U16_APP_FC_USERMANAGER,            // AppID of the other Server
			m_u16SrvRegID,                    // RegId for the service
			0,                            // always 0
			CCA_C_U16_SRV_USERMANAGER,            // the SID of the service
			u16FID,                       // the FID to register for
			AMT_C_U8_CCAMSG_OPCODE_UPREG  // this is an Upreg-message!
	);
	if(AIL_EN_N_NO_ERROR != poGWMain->enPostMessage(&oUpRegMessage,FALSE) )
	{

		// Error in sending the message
		if(!oUpRegMessage.bDelete())
		{
			ETG_TRACE_USR1(( "fRegisterForFID POST error  m_u16SrvRegID =%d u16FID=%d",m_u16SrvRegID,u16FID));
		}
	}
	else
	{
		bIsServiceRegistered = TRUE;

		/*
		if(NULL != m_poclConfigInterface)
		{
			vCreateMasterList();
		}
		*/
	}
#endif
	// return whether the service is registered
	return bIsServiceRegistered;
}

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_PMClient::fUnregisterForFID
 *
 *DESCRIPTION:  Unregisters for a function of a service
 *
 *PARAMETER:    u16FID : FID of the function to be registered (upreg)
 *
 *RETURNVALUE:  TRUE  : No Error in FID unregisteration
 *              FALSE : Error in FID unregisteration
 *
 *
 ******************************************************************-FUNCHEADER*/
tBool tunermaster_PMClient::fUnregisterForFID(tU16 u16FID)
{

	// Return value
	tBool fIsServiceUnregistered = FALSE;
	ETG_TRACE_USR1(( " fUnregisterForFID u16FID=%d",u16FID));
#ifdef INCLUDE_PROFILE_MANAGER

	// Is register id valid?
	if ( AMT_C_U16_REGID_INVALID != m_u16SrvRegID )
	{
		// Create message with relupreg - request:

		gm_tclEmptyMessage oRelupRegMessage
		(
				CCA_C_U16_APP_TUNERMASTER,             // AppID of this application
				CCA_C_U16_APP_FC_USERMANAGER,               // AppID of the other Server
				m_u16SrvRegID,                       // RegId for the service
				0,                               // always 0
				CCA_C_U16_SRV_USERMANAGER,               // the SID of the service
				u16FID,                          // the FID to register for
				AMT_C_U8_CCAMSG_OPCODE_RELUPREG  // this is an Upreg-message!
		);


		if(AIL_EN_N_NO_ERROR != poGWMain->enPostMessage(&oRelupRegMessage,FALSE))
		{
			// Error in sending the message
			if(!oRelupRegMessage.bDelete())
			{
				ETG_TRACE_USR4(("fUnregisterForFID, Error "));
			}
		}
		else
		{
			fIsServiceUnregistered = TRUE;
		}

	} // if ( AMT_C_U16_REGID_INVALID != m_u16SrvRegID )
#endif
	// return whether the service is unregistered
	return fIsServiceUnregistered;
}


/*************************************************************************
 *
 * FUNCTION:     tunermaster_PMClient::vOnNewAppState
 *
 * DESCRIPTION:  Main calls this function whenever there is a change in
 *              power state to handle CCA service
 *
 * PARAMETER:    u32OldAppState : Last set application state
 *               u32AppState    : Current requested app state
 *
 * RETURNVALUE:  None
 *
 *
 *************************************************************************/
tVoid tunermaster_PMClient::vOnNewAppState ( tU32 u32OldAppState,
		tU32 u32AppState )
{
	if(poGWMain == NULL)
	{
		//ETG_TRACE_USR4((" tunermaster_PMClient::vOnNewAppState, Null pointer"));
				NORMAL_M_ASSERT (NULL != poGWMain);
				return;
	}
	// Decide to register/unregister based on the app state
	if( u32OldAppState == u32AppState)
		return;
#ifdef INCLUDE_PROFILE_MANAGER
	switch(u32AppState)
	{
	case AMT_C_U32_STATE_NORMAL:
	{
		// Server has already entered this state, hence ignore

		// Register for service
		//vPersonalizationMasterListCreation();
		fRegisterForService();
		//mhv6kor moved to main.cpp to be in sync

		// Server has already entered this state, hence ignore

		// The application can enter this state from every other state
		// (e.g. NORMAL or OFF) so register for service should have the same
		// behavior everytime

		// Don't do anything in this state, audio don't do anything in this
		// state

		// Indicate the component has not reached stability
	}
	break;

	case AMT_C_U32_STATE_OFF:
	{
		// Server has already entered this state, hence ignore

		// Indicate the component has not reached stability

		// Unregister for service
		fUnregisterForService();
	}
	break;

	default:
	{
		// Ideally should  not come here
		break;
	}
	} // switch(u32AppState)


			#endif

}




/*****************************************MSGFROMPM***********************************************************/

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_PMClient::vHandleStatus
 *
 *DESCRIPTION: To handle property Active profile React on messages with FID = PROFILE_MAINFI_C_U16_STATUS
 *
 *PARAMETER:  poMessage : Pointer to CCA data
 *
 *
 *HISTORY: 07.2017 mhv6kor
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/
tVoid tunermaster_PMClient::vHandleStatus
(
		amt_tclServiceData* poMessage
)
{
	if(NULL==poMessage)
	{
			NORMAL_M_ASSERT (NULL != poMessage);
			return;

	}
#ifdef INCLUDE_PROFILE_MANAGER
	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_STATUS:
		{
			profile_mainfi_tclMsgstatusStatus oMsgStatus;
			vGetDataFromAmt(poMessage,oMsgStatus);
			m_u8PMState.enType = oMsgStatus.status.enType;
			ETG_TRACE_USR4(("vHandleStatus()m_u8PMState=%d",oMsgStatus.status.enType));
			break;
		}
		default:
		{
				break;
		}
	}
	#endif

}

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_PMClient::vHandleDataChanged
 *
 *DESCRIPTION: To handle property Active profile React on messages with FID = PROFILE_MAINFI_C_U16_DATACHANGED
 *
 *PARAMETER:  poMessage : Pointer to CCA data
 *
 *
 *HISTORY: 07.2017 mhv6kor
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/
tVoid tunermaster_PMClient::vHandleDataChanged
(
		amt_tclServiceData* poMessage
)
{
	ETG_TRACE_USR4(("vHandleDataChanged, Message Received"));

		if(NULL==poMessage)
		{
				ETG_TRACE_USR4(("vHandleDataChanged, handle message received is NULL  "));
				NORMAL_M_ASSERT (NULL != poMessage);
				return;

		}
#ifdef INCLUDE_PROFILE_MANAGER
		switch (poMessage->u8GetOpCode())
		{
			case AMT_C_U8_CCAMSG_OPCODE_STATUS:
			{
				
				profile_mainfi_tclMsgdataChangedStatus oMsgStatus;
				vGetDataFromAmt(poMessage,oMsgStatus);

				if((profile_fi_tcl_e8_changeProfile::FI_EN_PREPARE == oMsgStatus.reason.enType)  &&  (profile_fi_tcl_e8_profileStatus::FI_EN_LOADING == m_u8PMState.enType))
				{
					ETG_TRACE_USR4(("vHandleDataChanged() Data state  =%d  PMState =%d ",(tU8)oMsgStatus.reason.enType,m_u8PMState.enType));
					profile_mainfi_tclMsgonDataChangedMethodStart oOnDataChangedMethodStart;
					oOnDataChangedMethodStart.result.enType = profile_fi_tcl_e8_DataChangedResponse::FI_EN_PREPARED;
					vSendMessage( CCA_C_U16_APP_FC_USERMANAGER,// Destination APP ID
							oOnDataChangedMethodStart,           // parameter&
							PROFILE_MAINFI_C_U16_ONDATACHANGED, //FID
							AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode
							0 //CmdCntr
						    );
				}

				if((0xFF != m_u8UserID) && (profile_fi_tcl_e8_changeProfile::FI_EN_PROFILECHANGED == oMsgStatus.reason.enType ))
				{
					if(en_ActionChangeProfile == m_u8Action)
					{
						vSendProfileOperationToClients(m_u8UserID,m_u8UserID,en_ActionChangeProfile);
					}
					else if(en_actionNone == m_u8Action)
					{
						profile_mainfi_tclMsgonDataChangedMethodStart oOnDataChangedMethodStart;
						oOnDataChangedMethodStart.result.enType = profile_fi_tcl_e8_DataChangedResponse::FI_EN_PROFILE_CHANGED;
						vSendMessage( CCA_C_U16_APP_FC_USERMANAGER,// Destination APP ID
						oOnDataChangedMethodStart,           // parameter&
						PROFILE_MAINFI_C_U16_ONDATACHANGED, //FID
						AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode
						0 //CmdCntr
						);
					}
					else
					{
						//no action
					}
				}
			    break;

			}
			default:
			{
					break;
			}
		}
#endif
}


/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_PMClient::vHandleActiveProfile
 *
 *DESCRIPTION: To handle property Active profile React on messages with FID = PROFILE_MAINFI_C_U16_STATUS
 *
 *PARAMETER:  poMessage : Pointer to CCA data
 *
 *
 *HISTORY: 07.2017 mhv6kor
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/
tVoid tunermaster_PMClient::vHandleActiveProfile
(
		amt_tclServiceData* poMessage
)
{
	if(NULL== poMessage)
	{
			ETG_TRACE_USR4(("vHandleActiveProfile, Message NULL"));
			NORMAL_M_ASSERT (NULL != poMessage);
			return;

	}
#ifdef INCLUDE_PROFILE_MANAGER
	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_STATUS:
		{
			
			profile_mainfi_tclMsgactiveProfileStatus oMsgStatus;
			vGetDataFromAmt(poMessage,oMsgStatus);

			//Need to extract the user ID
			m_u8UserID = oMsgStatus.ID;
			m_u8Action = en_ActionChangeProfile;
			ETG_TRACE_USR4(("vHandleActiveProfile()m_u8UserID = %d",m_u8UserID));
			break;
		}
		default:
		{
				break;
		}
	}
	#endif

}

/*************************************************************************
 * FUNCTION:     vGetDataFromAmt
 *
 * DESCRIPTION:  Function to convert poMessage to AMT message
 *
 * PARAMETER:   amt_tclServiceData* poFIMsg,fi_tclTypeBase&     oFIData
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunermaster_PMClient::vGetDataFromAmt(amt_tclServiceData* poFIMsg,
		fi_tclTypeBase&     oFIData )const
{

	// Create Visitor message object for incoming message
	fi_tclVisitorMessage oInVisitorMsg(poFIMsg);

	/* Get the data in FI class from Vistor class*/
	if(OSAL_ERROR == oInVisitorMsg.s32GetData(oFIData,1))
	{
		ETG_TRACE_USR4(("vGetDataFromAmt, Error"));
		NORMAL_M_ASSERT_ALWAYS ();
	}
	ETG_TRACE_USR4(("vGetDataFromAmt()"));

}

/*************************************************************************************
 *FUNCTION:    tunermaster_PMClient::vSendMessage
 *
 *DESCRIPTION: This function converts Amt message to visitor class and
 *             get the data from visitor to the FI class. Refer FI Manual.Doc.
 *
 *PARAMETER:    tU16,fi_tclTypeBase& ,tU16,tU8,tU16,tU16
 *
 *RETURNVALUE: None
 *RETURNVALUE:
 ************************************************************************************/
#ifdef INCLUDE_PROFILE_MANAGER
tVoid tunermaster_PMClient :: vSendMessage( tU16             u16DestAppID,
		const fi_tclTypeBase&  oOutData,
		tU16             u16Fid,
		tU8              u8OpCode,
		tU16             u16CmdCtr)
{
	if (( NULL == poGWMain ) || (m_u16SrvRegID == AMT_C_U16_REGID_INVALID))
	{

		NORMAL_M_ASSERT (NULL != poGWMain);
		return;

	}

	fi_tclVisitorMessage oOutVisitorMsg(oOutData,1);


	// Set the CCA message information
	oOutVisitorMsg.vInitServiceData(  CCA_C_U16_APP_TUNERMASTER,                  /* Source app-ID    */
			u16DestAppID,                         /* Dest. app-ID     */
			AMT_C_U8_CCAMSG_STREAMTYPE_NODATA,    /* stream type      */
			0,                                    /* stream counter   */
			m_u16SrvRegID,                        /* Registry ID      */
			u16CmdCtr,                            /* Command counter  */
         CCA_C_U16_SRV_USERMANAGER,           /* Service-ID       */
			u16Fid,                               /* Function-ID      */
			u8OpCode,                             /* OpCode           */
			0,                                    /* ACT              */
			0,                                    /* Source sub-ID    */
			0 );                                  /* Dest. sub-ID     */
	// Send it to the client
	if(poGWMain->enPostMessage(&oOutVisitorMsg, TRUE) != AIL_EN_N_NO_ERROR)
	{
		//Trace for Error message if required.
	}


}
#endif
/*************************************************************************
 *
 * FUNCTION:     tunermaster_PMClient::vSet_tunmaster_ClientHandler_Ptr
 *
 * DESCRIPTION:  Set pointer to pointer tunmstr_TunerClientHandler
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunermaster_PMClient::vSet_tunmaster_ClientHandler_Ptr( tunmstr_TunerClientHandler* ptunmaster_ClientHandler )
{
	if( ptunmaster_ClientHandler != NULL )
	{
		m_potunmstr_TunClnt_Handlr = ptunmaster_ClientHandler;
	}
	else
	{
		NORMAL_M_ASSERT ( ptunmaster_ClientHandler != NULL );
	}
}


/*************************************************************************
 *
 * FUNCTION:     tunermaster_PMClient::vSet_tunmaster_DABHandler_Ptr
 *
 * DESCRIPTION:  Set pointer to pointer tunmstr_DABClientHandler
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunermaster_PMClient::vSet_tunmstr_DABClient_Handler_Ptr( tunmstr_DABClient_Handler* potunmstr_DABClient_Handler)
{
	if( potunmstr_DABClient_Handler != NULL )
	{
		m_potunmstr_DABClient_Handler = potunmstr_DABClient_Handler;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_DABClient_Handler != NULL );
	}
}

#ifdef INCLUDE_PROFILE_MANAGER

/*************************************************************************
 *
 * FUNCTION:     tunermaster_PMClient::vHandleOnDataChanged
 *
 * DESCRIPTION:  Handle the response of DAB and AMFM clients for the requested operation and send the response to PM
 *
 * PARAMETER:    u8Result Response from the client (SUCcESS or FAIL )
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunermaster_PMClient::vHandleOnDataChanged(tU8 u8Result )
{

	ETG_TRACE_USR4(("vHandleOnDataChanged, Message Received"));
	if(m_u8NoOfPresetListUpdateRequest)
		m_u8NoOfPresetListUpdateRequest--;
	if(0 != m_u8NoOfPresetListUpdateRequest)
	{
		ETG_TRACE_USR4(("vHandleOnDataChanged m_u8NoOfPresetListUpdateRequest = %d",m_u8NoOfPresetListUpdateRequest));
		if(u8Result == TUNMSTR_PROFILE_USER_ACTION_FAIL)
		{
			profile_mainfi_tclMsgonDataChangedMethodStart oOnDataChangedMethodStart;
			oOnDataChangedMethodStart.result.enType = profile_fi_tcl_e8_DataChangedResponse::FI_EN_FAILED;
			vSendMessage( CCA_C_U16_APP_FC_USERMANAGER,// Destination APP ID
														oOnDataChangedMethodStart,           // parameter&
														PROFILE_MAINFI_C_U16_ONDATACHANGED, //FID
														AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode
														0 //CmdCntr
					);
			ETG_TRACE_USR4(("vHandleOnDataChanged, PM Operation FAILED"));
			m_u8NoOfPresetListUpdateRequest = 0;
			m_bResponseSentToPM = true;

		}
		return;

	}
	else
	{
		if(!m_bResponseSentToPM)
		{
			profile_mainfi_tclMsgonDataChangedMethodStart oOnDataChangedMethodStart;
			oOnDataChangedMethodStart.result.enType = profile_fi_tcl_e8_DataChangedResponse::FI_EN_PROFILE_CHANGED;

			if(u8Result == TUNMSTR_PROFILE_USER_ACTION_FAIL)
				oOnDataChangedMethodStart.result.enType = profile_fi_tcl_e8_DataChangedResponse::FI_EN_FAILED;

			if( 0 == m_u8UserID )
			{
				/*In case of Guest user we need to reset the AM Switch to True */
#ifndef GTEST_x86LINUX_BUILD
				dp_tclTmcTunerUsrDPAMAvailability oTmcTunerDPAMAvailability ;
			    oTmcTunerDPAMAvailability.s32SetData(true);
#endif
			}

			if(NULL != m_potunmstr_MsgToHMI)
			{
				ETG_TRACE_USR4(("vHandleOnDataChanged AM Switch Requested"));
				vUpdateStatusTo_ARLandHMI();

			}
			else
			{
				ETG_TRACE_USR4(("vHandleOnDataChanged AM Switch status not updated"));
			}


			vSendMessage( CCA_C_U16_APP_FC_USERMANAGER,// Destination APP ID
												oOnDataChangedMethodStart,           // parameter&
												PROFILE_MAINFI_C_U16_ONDATACHANGED, //FID
												AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode
												0 //CmdCntr
			);

			ETG_TRACE_USR4(("vHandleOnDataChanged, PM Operation SUCESS"));

			m_u8NoOfPresetListUpdateRequest = 0;
			m_bResponseSentToPM = true;
		}
	}
}

tVoid tunermaster_PMClient::vHandleOnDataChanged_Prepare(tU8 Result )
{
	profile_mainfi_tclMsgonDataChangedMethodStart oOnDataChangedMethodStart;
	 /*Commented to solve coverity issue 2721597 */
	//oOnDataChangedMethodStart.result.enType = profile_fi_tcl_e8_DataChangedResponse::FI_EN_FAILED;

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
	if ((tU8)midw_ext_fi_tcl_Status::FI_EN_FAILED != Result)
#endif
#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
	if ((tU8)midw_fi_tcl_ProfileActionStatus::FI_EN_FAILED != Result)
#endif
		oOnDataChangedMethodStart.result.enType = profile_fi_tcl_e8_DataChangedResponse::FI_EN_PREPARED;

		vSendMessage( CCA_C_U16_APP_FC_USERMANAGER,// Destination APP ID
						oOnDataChangedMethodStart,           // parameter&
						PROFILE_MAINFI_C_U16_ONDATACHANGED, //FID
						AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode                           /* amt_tclServiceData* */
						0 //CmdCntr
					);

}
//adding copy and delete here

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_PMClient::vHandleCopyProfile
 *
 *DESCRIPTION: To handle property Active profile React on messages with FID = PROFILE_MAINFI_C_U16_COPYPROFILE
 *
 *PARAMETER:  poMessage : Pointer to CCA data
 *
 *
 *HISTORY: 07.2017 mhv6kor
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/
tVoid tunermaster_PMClient::vHandleCopyProfile
(
		amt_tclServiceData* poMessage
)
{

	if(NULL== poMessage)
	{
			ETG_TRACE_USR4(("vHandleCopyProfile, Message NULL"));
			NORMAL_M_ASSERT (NULL != poMessage);
			return;

	}
	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_STATUS:
		{

			profile_mainfi_tclMsgcopyProfileStatus  oMsgStatus;
			vGetDataFromAmt(poMessage,oMsgStatus);

			if(0xFF == oMsgStatus.destinationID)
			{
				 /*This is added to prevent tuner from performing any action when there is a UPReg for Copy FI (0xFF is received)*/
				ETG_TRACE_USR4(("vHandleCopyProfile Profile ID is Zero Copy Profile Ignored"));
				return;
			}

			ETG_TRACE_USR4(("vHandleCopyProfile()oMsgStatus.sourceID = %d oMsgStatus.destinationID = %d",oMsgStatus.sourceID ,oMsgStatus.destinationID));
			m_u8Action = en_ActionCopy;
			vSendProfileOperationToClients(oMsgStatus.sourceID,oMsgStatus.destinationID,en_ActionCopy );
			break;
		}
		default:
		{
				break;
		}
	}


}


/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_PMClient::vHandleDeleteProfile
 *
 *DESCRIPTION: To handle property Active profile React on messages with FID = PROFILE_MAINFI_C_U16_DELETEPROFILE
 *
 *PARAMETER:  poMessage : Pointer to CCA data
 *
 *
 *HISTORY: 07.2017 mhv6kor
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/

tVoid tunermaster_PMClient::vHandleDeleteProfile
(
		amt_tclServiceData* poMessage
)
{

	if(NULL== poMessage)
	{
			ETG_TRACE_USR4(("tunermaster_PMClient::vHandleDeleteProfile, Message NULL"));
			NORMAL_M_ASSERT (NULL != poMessage);
			return;

	}
	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_STATUS:
		{

			profile_mainfi_tclMsgdeleteProfileStatus  oMsgStatus;
			vGetDataFromAmt(poMessage,oMsgStatus);

			if(0xFF == oMsgStatus.ProfileID)
			{	
				 /*This is added to prevent tuner from performing any action when there is a UPReg for Delete FI (0xFF is recieved)*/
				ETG_TRACE_USR4((" vHandleDeleteProfile Profile ID is Zero Delete Profile Ignored"));
				return;
			}

			ETG_TRACE_USR4(("vHandleDeleteProfile()oMsgStatus.ProfileID = %d",oMsgStatus.ProfileID));
			m_u8Action = en_ActionDelete;
			vSendProfileOperationToClients(oMsgStatus.ProfileID,oMsgStatus.ProfileID,en_ActionDelete );

			break;
		}
		default:
		{
				break;
		}
	}


}

/*************************************************************************
 *
 * FUNCTION:     tunermaster_PMClient::vHandleOnProfileCopied
 *
 * DESCRIPTION:  Handle the response of DAB and AMFM clients for the requested copy operation and send the response to PM
 *
 * PARAMETER:    u8Result Response from the client (SUCcESS or FAIL )
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunermaster_PMClient::vHandleOnProfileCopied(tU8 u8Result )
{

	ETG_TRACE_USR4(("vHandleOnProfileCopied, Message Received"));
	if(m_u8NoOfPresetListUpdateRequest)
		m_u8NoOfPresetListUpdateRequest--;
	if(0 != m_u8NoOfPresetListUpdateRequest)
	{
		ETG_TRACE_USR4(("vHandleOnProfileCopied m_u8NoOfPresetListUpdateRequest = %d",m_u8NoOfPresetListUpdateRequest));
		if(u8Result == TUNMSTR_PROFILE_USER_ACTION_FAIL)
		{

			profile_mainfi_tclMsgonProfileCopiedMethodStart oOnProfileCopiedMethodStart;
			oOnProfileCopiedMethodStart.result.enType = profile_fi_tcl_e8_ClientResponse::FI_EN_FAILED;
			vSendMessage( CCA_C_U16_APP_FC_USERMANAGER,// Destination APP ID
														oOnProfileCopiedMethodStart,           // parameter&
														PROFILE_MAINFI_C_U16_ONPROFILECOPIED, //FID
														AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode
														0 //CmdCntr
					);
			ETG_TRACE_USR4(("vHandleOnProfileCopied, PM Operation FAILED"));

			m_u8NoOfPresetListUpdateRequest = 0;
			m_bResponseSentToPM = true;

		}
		return;

	}
	else
	{
		if(!m_bResponseSentToPM)
		{
			profile_mainfi_tclMsgonProfileCopiedMethodStart oOnProfileCopiedMethodStart;
			oOnProfileCopiedMethodStart.result.enType = profile_fi_tcl_e8_ClientResponse::FI_EN_SUCCESS;

			if(u8Result == TUNMSTR_PROFILE_USER_ACTION_FAIL)
				oOnProfileCopiedMethodStart.result.enType = profile_fi_tcl_e8_ClientResponse::FI_EN_FAILED;

		       vSendMessage( CCA_C_U16_APP_FC_USERMANAGER,// Destination APP ID
		    		                                oOnProfileCopiedMethodStart,           // parameter&
		    		                                PROFILE_MAINFI_C_U16_ONPROFILECOPIED, //FID
													AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode
													0 //CmdCntr
				);
				if(NULL != m_potunmstr_MsgToHMI)
				{
					vUpdateStatusTo_ARLandHMI();
					ETG_TRACE_USR4(("vHandleOnProfileCopied AM Switch Requested"));
				}
				else
				{
					ETG_TRACE_USR4(("vHandleOnProfileCopied AM Switch status not updated"));
				}
				m_u8NoOfPresetListUpdateRequest = 0;
				m_bResponseSentToPM = true;
		}
	}


}

/*************************************************************************
 *
 * FUNCTION:     tunermaster_PMClient::vHandleOnProfileDeleted
 *
 * DESCRIPTION:  Handle the response of DAB and AMFM clients for the requested delete operation and send the response to PM
 *
 * PARAMETER:    u8Result Response from the client (SUCCESS or FAIL )
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunermaster_PMClient::vHandleOnProfileDeleted(tU8 u8Result  )
{

	if(m_u8NoOfPresetListUpdateRequest)
		m_u8NoOfPresetListUpdateRequest--;
	if(0 != m_u8NoOfPresetListUpdateRequest)
	{
		ETG_TRACE_USR4(("vHandleOnProfileDeleted m_u8NoOfPresetListUpdateRequest = %d",m_u8NoOfPresetListUpdateRequest));
		if(u8Result == TUNMSTR_PROFILE_USER_ACTION_FAIL)
		{

			profile_mainfi_tclMsgonProfileDeletedMethodStart oOnProfileDeletedMethodStart;
					oOnProfileDeletedMethodStart.result.enType = profile_fi_tcl_e8_ClientResponse::FI_EN_FAILED;
												vSendMessage( CCA_C_U16_APP_FC_USERMANAGER,// Destination APP ID
																oOnProfileDeletedMethodStart,           // parameter&
																PROFILE_MAINFI_C_U16_ONPROFILEDELETED, //FID
																AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode
																0 //CmdCntr
															);
			ETG_TRACE_USR4(("vHandleOnProfileDeleted, PM Operation FAILED"));
			m_u8NoOfPresetListUpdateRequest = 0;
			m_bResponseSentToPM = true;

		}
		return;

	}
	else
	{

		if(!m_bResponseSentToPM)
		{
			profile_mainfi_tclMsgonProfileDeletedMethodStart oOnProfileDeletedMethodStart;
			oOnProfileDeletedMethodStart.result.enType = profile_fi_tcl_e8_ClientResponse::FI_EN_SUCCESS;

			if(u8Result == TUNMSTR_PROFILE_USER_ACTION_FAIL)
				oOnProfileDeletedMethodStart.result.enType = profile_fi_tcl_e8_ClientResponse::FI_EN_FAILED;

			vSendMessage( CCA_C_U16_APP_FC_USERMANAGER,// Destination APP ID
						oOnProfileDeletedMethodStart,           // parameter&
			    		PROFILE_MAINFI_C_U16_ONPROFILEDELETED, //FID
						AMT_C_U8_CCAMSG_OPCODE_METHODSTART,  // OpCode
						0 //CmdCntr
					);

			if(NULL != m_potunmstr_MsgToHMI)
			{
				ETG_TRACE_USR4(("vHandleOnProfileDeleted AM Switch Requested"));
				vUpdateStatusTo_ARLandHMI();
			}
			else
			{
				ETG_TRACE_USR4(("vHandleOnProfileDeleted AM Switch Update failed"));
			}
			m_u8NoOfPresetListUpdateRequest = 0;
			m_bResponseSentToPM = true;
		}
	}

}

tVoid  tunermaster_PMClient::vHandleDoRegisterClient (amt_tclServiceData* poMessage)
{
	if(NULL== poMessage)
	{
			ETG_TRACE_USR4(("vHandleDoRegisterClient, Message NULL"));
			NORMAL_M_ASSERT (NULL != poMessage);
			return;

	}
	switch (poMessage->u8GetOpCode())
	{
		case AMT_C_U8_CCAMSG_OPCODE_METHODRESULT:
		{

			profile_mainfi_tclMsgRegisterClientMethodResult  oMsgResult;
			vGetDataFromAmt(poMessage,oMsgResult);

			if(oMsgResult.bReloadData)
			{
				vUpdateStatusTo_ARLandHMI();

#if defined(VARIANT_S_FTR_ENABLE_SXMCLIENT) || defined(VARIANT_S_FTR_ENABLE_SXM360LCLIENT)
				 if (m_poclConfigInterface->u32GetConfigData("SXMSupported"))
				 {
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT

					 midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart oMsgStart;
					 oMsgStart.ProfileAction.enType = midw_ext_fi_tcl_ProfileAction::FI_EN_DATACHANGE;
					 oMsgStart.SourceID = m_u8UserID;
					 oMsgStart.ProfileStatus.enType = midw_ext_fi_tcl_ProfileStatus::FI_EN_RESET;
					 if(m_potunmstr_SXMClient_Handler != NULL)
					 {
						 m_potunmstr_SXMClient_Handler->vSendUserProfileAction(oMsgStart);
					 }
#else
					 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus oStatus;
					 oStatus.ProfileAction.enType = midw_fi_tcl_ProfileAction::FI_EN_DATACHANGE;
					 oStatus.SourceID = m_u8UserID;
					 oStatus.ProfileStatus.enType = midw_fi_tcl_ProfileStatus::FI_EN_RESET;
					 if(m_potunmstr_MsgToHMI != NULL)
					 {
						 m_potunmstr_MsgToHMI->vSend_SXM360LUserProfileActions(oStatus);
					 }
#endif
				 }
#endif
			}

			break;
		}
		default:
		{
				break;
		}
	}
}

/*************************************************************************
 *
 * FUNCTION:     tunermaster_PMClient::vSet_tunmstr_MsgToHMI_Ptr( )
 *
 * DESCRIPTION:
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/

tVoid tunermaster_PMClient::vSet_tunmstr_MsgToHMI_Ptr( tunmstr_MsgToHMI* potunmstr_MsgToHMI )
{
	if( potunmstr_MsgToHMI != NULL )
	{
		m_potunmstr_MsgToHMI = potunmstr_MsgToHMI;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_MsgToHMI != NULL );
	}
}
#endif
/*************************************************************************
 *
 * FUNCTION:     tunermaster_PMClient::vSet_tunmstr_ConfigInterface_Ptr( )
 *
 * DESCRIPTION: Added only to get If DAB is supported or not.
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunermaster_PMClient::vSet_tunmstr_ConfigInterface_Ptr (clConfigInterface* poclConfigInterface)
{
		if( poclConfigInterface != NULL )
		{
			m_poclConfigInterface = poclConfigInterface;
		}
		else
		{
			NORMAL_M_ASSERT ( poclConfigInterface != NULL );
		}
}


#ifdef INCLUDE_PROFILE_MANAGER
/*************************************************************************
 *
 * FUNCTION:     tunermaster_PMClient::vSet_tunmstr_Preset_Handler_Ptr( )
 *
 * DESCRIPTION:  Added to SetPreset action before requesting presetlist on reponse
 *
 * PARAMETER:    void
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
tVoid tunermaster_PMClient::vSet_tunmstr_Preset_Handler_Ptr( tunmstr_Preset_Handler* potunmstr_Preset_Handler)
{
	if( potunmstr_Preset_Handler != NULL )
	{
		m_potunmstr_Preset_Handler = ( tunmstr_Preset_Handler* )potunmstr_Preset_Handler;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_Preset_Handler != NULL );
	}
}


/*************************************************************************
 *
 * FUNCTION:     tunermaster_PMClient::vSet_tunmstr_ArlSourceImplPtr( )
 *
 * DESCRIPTION:  Added to update ARL when source availability status during profile change
 *
 * PARAMETER:    clArlSourceImpl*
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
tVoid tunermaster_PMClient::vSet_tunmstr_ArlSourceImplPtr(tuner::sessionManagement::audio::clArlSourceImpl* poArlSourceImpl)
{
	if( poArlSourceImpl != NULL )
	{
		m_poArlSourceImpl = poArlSourceImpl;
	}
	else
	{
		NORMAL_M_ASSERT ( poArlSourceImpl != NULL );
	}
}
#endif

/*************************************************************************
 * FUNCTION:    vSet_tunmstr_MsgFromHMI_Ptr
 *
 * DESCRIPTION:  Update the tunmstr_MsgFromHMI pointer member variable m_potunmstr_MsgFromHMI
 *
 * PARAMETER:    tunmstr_MsgFromHMI* potunmstr_MsgFromHMI
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunermaster_PMClient::vSet_tunmstr_MsgFromHMI_Ptr( tunmstr_MsgFromHMI* potunmstr_MsgFromHMI )
{
	if( potunmstr_MsgFromHMI != NULL )
	{
		m_potunmstr_MsgFromHMI = ( tunmstr_MsgFromHMI* )potunmstr_MsgFromHMI;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_MsgFromHMI != NULL );
	}
}

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
/*************************************************************************
 * FUNCTION:    vSet_tunmstr_SXMClient_Ptr
 *
 * DESCRIPTION:  Update the tunmstr_MsgFromHMI pointer member variable m_potunmstr_MsgFromHMI
 *
 * PARAMETER:    tunermaster_PMClient* potunmstr_SXMClient_Handler
 *
 * RETURNVALUE:  void
 *************************************************************************/
tVoid tunermaster_PMClient::vSet_tunmstr_SXMClient_Ptr( tunermaster_SXMClient* potunmstr_SXMClient_Handler )
{
	if( potunmstr_SXMClient_Handler != NULL )
	{
		m_potunmstr_SXMClient_Handler = ( tunermaster_SXMClient* )potunmstr_SXMClient_Handler;
	}
	else
	{
		NORMAL_M_ASSERT ( potunmstr_SXMClient_Handler != NULL );
	}
}
#endif
#endif
/*************************************************************************
 *
 * FUNCTION:     tunermaster_PMClient::vSet_tunmstr_ArlSourceImplPtr( )
 *
 * DESCRIPTION:  Added to update ARL when source availability status during profile change
 * 				 Added as fix for NCG3D-65991
 *
 * PARAMETER:    none
 *
 * RETURNVALUE:  void
 *
 *************************************************************************/
#ifdef INCLUDE_PROFILE_MANAGER
tVoid tunermaster_PMClient::vUpdateStatusTo_ARLandHMI()
{

	if( (NULL == m_poclConfigInterface) || (NULL == m_potunmstr_MsgToHMI ))
		{
			ETG_TRACE_USR4(("vUpdateAMSwitchSettings Null  "));
			NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
			NORMAL_M_ASSERT( m_poclConfigInterface != NULL );
			return;
		}
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	if((NULL == m_poArlSourceImpl))
	{
		ETG_TRACE_USR4(("vUpdateStatusTo_ARLandHMI Null  "));
		return;
	}
#endif

	tBool bTmcTunerDPAMAvailStatus = true;
#ifndef GTEST_x86LINUX_BUILD
	dp_tclTmcTunerUsrDPAMAvailability oTmcTunerDPAMAvailability ;
	oTmcTunerDPAMAvailability.s32GetData(bTmcTunerDPAMAvailStatus);
#endif


	arl_tenSource enSource = ARL_SRC_AM;
	arl_tenAvailabilityReason enAvailabilityReason=ARL_EN_REASON_SAMEMEDIA;
	arl_tenSrcAvailability enSrcAvail=ARL_EN_SRC_NOT_AVAILABLE ;

	/*Update of source AM availability needs to be sent to both HMI and ARL */
	/*INFO vSend_g_Tuner_Source_Availability_status reflects in HMI as ON and OFF in Radio Settings
	       vUpdateAudioSourceAvailabelStatus will enable ARL to put AM Source status in Radio Screen (Status to ARL added as fix for NCG3D-65991)
	*/

	if((m_poclConfigInterface->u32GetConfigData("AvailableBands") & 0x06) && (m_poclConfigInterface->u32GetConfigData("CFGAM")))
	{
		if(bTmcTunerDPAMAvailStatus)
		{
			/* mhv6kor When AM source is enabled we need to make the reason as new media*/
			enAvailabilityReason= ARL_EN_REASON_NEWMEDIA;
			enSrcAvail = ARL_EN_SRC_PLAYABLE;
			ETG_TRACE_USR4(("vUpdateStatusTo_ARLandHMI() ARL_EN_SRC_PLAYABLE  "));
		}
		else
		{
			ETG_TRACE_USR4(("vUpdateStatusTo_ARLandHMI() ARL_EN_SRC_NOT_AVAILABLE "));
		}
		m_potunmstr_MsgToHMI->vSend_g_Tuner_Source_Availability_status();
	}
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	m_poArlSourceImpl->vUpdateAudioSourceAvailabelStatus(enSource,enSrcAvail,enAvailabilityReason);
#endif

}

tVoid tunermaster_PMClient::vUpdateAMSwitchSettings(tBool bAMSwitchStatus)
{

	if( (NULL == m_poclConfigInterface) || (NULL == m_potunmstr_MsgToHMI ))
		{
			ETG_TRACE_USR4(("vUpdateAMSwitchSettings Null  "));
			NORMAL_M_ASSERT( m_potunmstr_MsgToHMI != NULL );
			NORMAL_M_ASSERT( m_poclConfigInterface != NULL );
			return;
		}

#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
	if(NULL == m_poArlSourceImpl)
	{
		ETG_TRACE_USR4(("vUpdateAMSwitchSettings Null  "));
		return;
	}
#endif

	tBool bTmcTunerDPAMAvailStatus = true;
#ifndef GTEST_x86LINUX_BUILD
		dp_tclTmcTunerUsrDPAMAvailability oTmcTunerDPAMAvailability ;
		oTmcTunerDPAMAvailability.s32GetData(bTmcTunerDPAMAvailStatus);
#endif

		if( bTmcTunerDPAMAvailStatus != bAMSwitchStatus)
		{
			arl_tenSource enSource = ARL_SRC_NONE;
			arl_tenSrcAvailability enSrcAvail=ARL_EN_SRC_NOT_AVAILABLE;
			arl_tenAvailabilityReason enAvailabilityReason=ARL_EN_REASON_NOMEDIA;

			if(bAMSwitchStatus)
			{

				enSrcAvail = ARL_EN_SRC_PLAYABLE;
				enAvailabilityReason= ARL_EN_REASON_NEWMEDIA;
#ifndef GTEST_x86LINUX_BUILD
				oTmcTunerDPAMAvailability.s32SetData(true);
#endif

			 }
			else
			{
				m_potunmstr_TunClnt_Handlr->vDisableTunerSource(midw_fi_tcl_e8_Source::FI_EN_TUN_MSTR_SOURCE_AM ,true);
				m_u8RadioProfileSettingRequestCount ++;
			}
			enSource = ARL_SRC_AM;
			m_potunmstr_MsgToHMI->vSend_g_Tuner_Source_Availability_status();
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
			m_poArlSourceImpl->vUpdateAudioSourceAvailabelStatus(enSource,enSrcAvail,enAvailabilityReason);
#endif
		}

}
#endif


/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_PMClient::vSendProfileOperationToClients
 *
 *DESCRIPTION: Fucntion to send clients the action to perform the user actions
 *
 *
 *HISTORY: 04:2018 mhv6kor
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/
/*mhv6kor: Function is mainly added to add unit test cases as profile Manager is not present in CMD*/
tVoid   tunermaster_PMClient::vSendProfileOperationToClients(tU8 u8SrcID_DeleteID, tU8 u8DstID , ten_ProfileManagerAction enUserAction)
{

	if(NULL == m_poclConfigInterface)
	{
		NORMAL_M_ASSERT( m_poclConfigInterface != NULL );
		return;
	}
	switch(enUserAction)
	{
		case en_ActionChangeProfile:
		{
			m_bResponseSentToPM = false;
			m_u8NoOfPresetListUpdateRequest = 0;

			ETG_TRACE_USR4(("vSendProfileOperationToClients() PresetListMapping = %d",m_poclConfigInterface->u32GetConfigData("PresetListType")));
			 if( (NULL != m_potunmstr_Preset_Handler ) && (m_poclConfigInterface->u32GetConfigData("PresetListType")))
			 {
				 m_potunmstr_Preset_Handler->vHandleSystemSetForPresetList();
				 m_potunmstr_Preset_Handler->vHandleSystemSetFinishForPresetList();
			 }
			 ETG_TRACE_USR4(("vSendProfileOperationToClients()m_u8UserID =%d  m_u8Action =%d ",m_u8UserID,en_ActionChangeProfile));
			 if (NULL != m_potunmstr_TunClnt_Handlr)
			 {
				 m_u8NoOfPresetListUpdateRequest++;
				 m_potunmstr_TunClnt_Handlr->vHandleProfileUpdate(m_u8UserID,en_ActionChangeProfile);
				 ETG_TRACE_USR4(("vSendProfileOperationToClients, Request TOAM Sent "));
			 }

			 if ((NULL != m_potunmstr_DABClient_Handler )&& (m_poclConfigInterface->u32GetConfigData("DABSupported")))
			 {
				 m_u8NoOfPresetListUpdateRequest++;
				 m_potunmstr_DABClient_Handler->vHandleProfileUpdate(m_u8UserID,m_u8UserID,en_ActionChangeProfile);
				 ETG_TRACE_USR4(("vSendProfileOperationToClients, Request TODAB  Sent "));
			 }

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
			 vHandleSXMProfileOperations((tU8)midw_ext_fi_tcl_ProfileAction::FI_EN_ACTIVEPROFILE, u8SrcID_DeleteID, u8DstID);
#endif
#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
			 vHandleSXM360LProfileOperations((tU8)midw_fi_tcl_ProfileAction::FI_EN_ACTIVEPROFILE, u8SrcID_DeleteID, u8DstID);
#endif

			 m_u8Action = en_actionNone;
			break;
		}
		case en_ActionCopy:
		{
			m_bResponseSentToPM = false;
			m_u8NoOfPresetListUpdateRequest = 0;

			ETG_TRACE_USR4(("vSendProfileOperationToClients()oMsgStatus.destinationID = %d",u8DstID));

			 if (NULL != m_potunmstr_TunClnt_Handlr)
			 {
				 m_potunmstr_TunClnt_Handlr->vHandleProfileUpdate(u8DstID ,en_ActionCopy);
				 ETG_TRACE_USR4(("vSendProfileOperationToClients, Request TOAM Sent "));
				 m_u8NoOfPresetListUpdateRequest ++;
			 }

			 if ((NULL != m_potunmstr_DABClient_Handler) && (m_poclConfigInterface->u32GetConfigData("DABSupported")))
			 {
				 m_potunmstr_DABClient_Handler->vHandleProfileUpdate(u8SrcID_DeleteID,u8DstID,en_ActionCopy);
				 ETG_TRACE_USR4(("vSendProfileOperationToClients, Request TODAB  Sent "));
				 m_u8NoOfPresetListUpdateRequest ++;
			 }

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
			 vHandleSXMProfileOperations((tU8)midw_ext_fi_tcl_ProfileAction::FI_EN_COPYPROFILE, u8SrcID_DeleteID, u8DstID);
#endif
#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
			 vHandleSXM360LProfileOperations((tU8)midw_fi_tcl_ProfileAction::FI_EN_COPYPROFILE, u8SrcID_DeleteID, u8DstID);
#endif

			m_u8Action = en_actionNone;
			break;
		}
		case en_ActionDelete:
		{
			m_bResponseSentToPM = false;
			m_u8NoOfPresetListUpdateRequest = 0;

			/*Update action as Delete and send the request to Tuners with profile ID */
			 if ( (NULL != m_potunmstr_Preset_Handler ) && (m_poclConfigInterface->u32GetConfigData("PresetListType")))
			 {
				 m_potunmstr_Preset_Handler->vHandleSystemSetForPresetList();
				 m_potunmstr_Preset_Handler->vHandleSystemSetFinishForPresetList();
			 }
			if (NULL != m_potunmstr_TunClnt_Handlr)
			{
				 m_potunmstr_TunClnt_Handlr->vHandleProfileUpdate(u8SrcID_DeleteID,en_ActionDelete);
				 ETG_TRACE_USR4(("vHandleDeleteProfile, Request TOAM Sent "));
				 m_u8NoOfPresetListUpdateRequest ++;
			}

			if ((NULL != m_potunmstr_DABClient_Handler) && (m_poclConfigInterface->u32GetConfigData("DABSupported")))
			{	/*For DAB we need to send source and destination as the same is forwarded to ADR*/
				 m_potunmstr_DABClient_Handler->vHandleProfileUpdate(u8SrcID_DeleteID,u8SrcID_DeleteID,en_ActionDelete);
				 ETG_TRACE_USR4(("vHandleDeleteProfile, Request TODAB  Sent "));
				 m_u8NoOfPresetListUpdateRequest ++;
			}

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
			 vHandleSXMProfileOperations((tU8)midw_ext_fi_tcl_ProfileAction::FI_EN_DELETEPROFILE, u8SrcID_DeleteID, u8DstID);
#endif
#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
			 vHandleSXM360LProfileOperations((tU8)midw_fi_tcl_ProfileAction::FI_EN_DELETEPROFILE, u8SrcID_DeleteID, u8DstID);
#endif

			m_u8Action = en_actionNone;
			break;
		}
		default:
			break;
	}
}


#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_PMClient::vPrepareDataChanged
 *
 *DESCRIPTION: 	Function to perform profile actions of SXM
 *
 *
 *HISTORY:
 *
 ******************************************************************-FUNCHEADER*/
tVoid tunermaster_PMClient::vHandleSXMProfileOperations(tU8 u8ProfileAction , tU8 u8SrcID_DeleteID, tU8 u8DstID)
{
	 if (m_poclConfigInterface->u32GetConfigData("SXMSupported"))
	 {
		 midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart oMsgStart;
		 oMsgStart.ProfileAction.enType = (midw_ext_fi_tcl_ProfileAction::tenType)u8ProfileAction;
		 oMsgStart.SourceID = m_u8UserID;

		 if(u8ProfileAction == (tU8)midw_ext_fi_tcl_ProfileAction::FI_EN_DELETEPROFILE)
			 oMsgStart.SourceID = u8SrcID_DeleteID;

		 if(u8ProfileAction == (tU8)midw_ext_fi_tcl_ProfileAction::FI_EN_COPYPROFILE)
			 oMsgStart.DestinationID = u8DstID;

		 oMsgStart.ProfileStatus.enType = midw_ext_fi_tcl_ProfileStatus::FI_EN_CHANGED;

		 if(m_potunmstr_SXMClient_Handler != NULL)
		 {
			 m_u8NoOfPresetListUpdateRequest++;
			 m_potunmstr_SXMClient_Handler->vSendUserProfileAction(oMsgStart);
			 ETG_TRACE_USR4(("vHandleSXMProfileOperations, Request TO SXM Sent"));
		 }

	}
}
#endif


#ifdef VARIANT_S_FTR_ENABLE_SXM360LCLIENT
/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_PMClient::vHandleSXM360LProfileOperations
 *
 *DESCRIPTION: 	Function to perform profile actions of SXM 360L
 *
 *
 *HISTORY:
 *
 ******************************************************************-FUNCHEADER*/
tVoid tunermaster_PMClient::vHandleSXM360LProfileOperations(tU8 u8ProfileAction, tU8 u8SrcID_DeleteID, tU8 u8DstID)
{
	 if (m_poclConfigInterface->u32GetConfigData("SXMSupported"))
	 {
		 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus oStatus;
		 oStatus.ProfileAction.enType = (midw_fi_tcl_ProfileAction::tenType)u8ProfileAction;
		 oStatus.SourceID = m_u8UserID;

		 if(u8ProfileAction == (tU8)midw_fi_tcl_ProfileAction::FI_EN_DELETEPROFILE)
			 oStatus.SourceID = u8SrcID_DeleteID;

		 if(u8ProfileAction == (tU8)midw_fi_tcl_ProfileAction::FI_EN_COPYPROFILE)
			 oStatus.DestinationID = u8DstID;

		 oStatus.ProfileStatus.enType = midw_fi_tcl_ProfileStatus::FI_EN_CHANGED;
		 if(m_potunmstr_MsgToHMI != NULL)
		 {
			 m_u8NoOfPresetListUpdateRequest++;
			 m_potunmstr_MsgToHMI->vSend_SXM360LUserProfileActions(oStatus);
			 ETG_TRACE_USR4(("vHandleSXM360LProfileOperations, Request TO SXM 360L  Sent "));
		 }
	}
}
#endif


/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_PMClient::vPrepareDataChanged
 *
 *DESCRIPTION: Fucntion perform action in case of Datachanged Prepare.
 *
 *
 *HISTORY: 04:2018 mhv6kor
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/
/*mhv6kor: Function is mainly added to add unit test cases as profile Manager is not present in CMD*/

tVoid tunermaster_PMClient::vPrepareDataChanged()
{
#ifdef INCLUDE_PROFILE_MANAGER
	if( NULL == m_poclConfigInterface )
	{
		ETG_TRACE_USR4(("vPrepareDataChanged config NULL"));
		return;
	}
#if defined(VARIANT_S_FTR_ENABLE_SXMCLIENT) || defined(VARIANT_S_FTR_ENABLE_SXM360LCLIENT)
	 if (m_poclConfigInterface->u32GetConfigData("SXMSupported"))
	 {
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT

		 midw_ext_sxm_audiofi_tclMsgUserProfileMethodStart oMsgStart;
		 oMsgStart.ProfileAction.enType = midw_ext_fi_tcl_ProfileAction::FI_EN_DATACHANGE;
		 oMsgStart.SourceID = m_u8UserID;
		 oMsgStart.ProfileStatus.enType = midw_ext_fi_tcl_ProfileStatus::FI_EN_PREPARE;
		 if(m_potunmstr_SXMClient_Handler != NULL)
		 {
			 m_potunmstr_SXMClient_Handler->vSendUserProfileAction(oMsgStart);
			 ETG_TRACE_USR4(("vPrepareDataChanged, PrepareRequestSent"));
		 }
#else
		 midw_tunermasterfi_tclMsgFID_TUNMSTR_G_SXM_USERPROFILEStatus oStatus;
		 oStatus.ProfileAction.enType = midw_fi_tcl_ProfileAction::FI_EN_DATACHANGE;
		 oStatus.SourceID = m_u8UserID;
		 oStatus.ProfileStatus.enType = midw_fi_tcl_ProfileStatus::FI_EN_PREPARE;
		 if(m_potunmstr_MsgToHMI != NULL)
		 {
			 m_potunmstr_MsgToHMI->vSend_SXM360LUserProfileActions(oStatus);
			 ETG_TRACE_USR4(("vPrepareDataChanged, PrepareRequestSent"));
		 }
#endif
	 }
	 else
#endif
	 {
		 midw_ext_fi_tcl_Status oStatus;
		 oStatus.enType = midw_ext_fi_tcl_Status::FI_EN_SUCCESS;
		 vHandleOnDataChanged_Prepare((tU8)oStatus.enType);
		 ETG_TRACE_USR4(("vPrepareDataChanged Success"));
	 }
#endif

}

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_PMClient::vHandle_s_Radio_Profile_Setting
 *
 *DESCRIPTION: To handle FID = FID_TUNMSTR_S_RADIOPROFILE_SETTING
 *
 *PARAMETER:  poMessage : Pointer to CCA data
 *
 *
 *HISTORY: 04:2018 mhv6kor
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/
#ifdef INCLUDE_PROFILE_MANAGER
tVoid tunermaster_PMClient::vHandle_s_Radio_Profile_Setting(amt_tclServiceData* poMessage)
{

	ETG_TRACE_USR4(("vHandle_s_Radio_Profile_Setting()"));

	midw_fi_tcl_TunMstr_RadioSetting_StatusResponse TunerMasterResponse;
	TunerMasterResponse.RadioProfileSetting_Response.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_SUCCEED;
	TunerMasterResponse.RadioProfileSetting_ErrorCode.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_NONE;

	if (NULL == poMessage)
	{
      NORMAL_M_ASSERT(poMessage != NULL);
      return;
	}

   m_u16DestAppID = poMessage->u16GetSourceAppID();
   m_u16CmdCtr = poMessage->u16GetCmdCounter();
   m_u16GetFunctionID = poMessage->u16GetFunctionID();
   m_u16GetRegisterID = poMessage->u16GetRegisterID();

	midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart  oMsgMethodStart;
	vGetDataFromAmt(poMessage,oMsgMethodStart);

	if(oMsgMethodStart.RadioProfileSettingAction.bTUNMSTR_PROFILE_ACTION_AMSWITCH())
	{
		if((m_poclConfigInterface->u32GetConfigData("AvailableBands") &  0x06) && (m_poclConfigInterface->u32GetConfigData("CFGAM")))
		{
			ETG_TRACE_USR4(("vHandle_s_Radio_Profile_Setting()- AMSwitch "));
			vUpdateAMSwitchSettings(oMsgMethodStart.RadioProfile_AMSwitch);
		}
	}
	if(oMsgMethodStart.RadioProfileSettingAction.bTUNMSTR_PROFILE_ACTION_PRESETS())
	{
		ETG_TRACE_USR4(("vHandle_s_Radio_Profile_Setting()- Preset "));
		if(oMsgMethodStart.RadioProfile_Option.enType ==  midw_fi_tcl_e8_Preset_Option::FI_EN_TUN_MSTR_PRESET_OPTION_KEEP_OTHERS)
			vCreateIndividualTunerListKeepOthers(oMsgMethodStart);
		if(oMsgMethodStart.RadioProfile_Option.enType ==  midw_fi_tcl_e8_Preset_Option::FI_EN_TUN_MSTR_PRESET_OPTION_DELETE_OTHERS)
			vCreateIndividualTunerListDeleteOthers(oMsgMethodStart);
	}
	if((!oMsgMethodStart.RadioProfileSettingAction.bTUNMSTR_PROFILE_ACTION_AMSWITCH())&&(!oMsgMethodStart.RadioProfileSettingAction.bTUNMSTR_PROFILE_ACTION_PRESETS()))
	{
		vSendResponseToRadioSetting(TunerMasterResponse);
	}

}
#endif

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_PMClient::vCreateTunerElement
 *
 *DESCRIPTION: To Create elements for AMFMList
 *
 *PARAMETER:  midw_fi_tcl_TunMst_PresetListElement &  midw_fi_tcl_TunerListElement
 *
 *
 *HISTORY: 04:2018 mhv6kor
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/
#ifdef INCLUDE_PROFILE_MANAGER
tVoid  tunermaster_PMClient::vCreateTunerElement(midw_fi_tcl_TunMst_PresetListElement& Element, midw_fi_tcl_TunerListElement& AMFMList )
{
	AMFMList.u32Frequency = Element.u32Frequency;
	AMFMList.sStationName.bSet(Element.sStationName.szValue, midw_fi_tclString::FI_EN_UTF8);
	if (m_poclConfigInterface->u32GetConfigData("PresetListType"))
		AMFMList.e8ListID.enType = midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_MIX1;

	if((Element.u8PresetNumber > 0 ) && (Element.u8PresetNumber <= oPresetMasterList.size()))
	{
		AMFMList.u8ElementID = oPresetMasterList.at(Element.u8PresetNumber -1).m_u8IndividualTunerPresetID;
		ETG_TRACE_USR4(("vCreateTunerElement AMFMList Element.u8PresetNumber = %d",Element.u8PresetNumber));

		switch(Element.e8RadioType.enType)
		{
			case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_AMHD:
			case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_FMHD:
			{
				AMFMList.e8Modulation.enType = midw_fi_tcl_e8_Tun_ModulationType::FI_EN_TUN_MODULATION_HD;
				AMFMList.u32SID = oPresetMasterList.at(Element.u8PresetNumber -1).u32SID;
				AMFMList.u8StationNameEncoding = oPresetMasterList.at(Element.u8PresetNumber -1).u32TextEncoding;
				AMFMList.u8ProgramService = oPresetMasterList.at(Element.u8PresetNumber -1).u32EnsembleId;
				break;
			}
			case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_AM:
			case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_FM:
				AMFMList.e8Modulation.enType = midw_fi_tcl_e8_Tun_ModulationType::FI_EN_TUN_MODULATION_ANALOG;
				break;
			case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_DRM:
				AMFMList.e8Modulation.enType = midw_fi_tcl_e8_Tun_ModulationType::FI_EN_TUN_MODULATION_DRM;
				AMFMList.u32SID = oPresetMasterList.at(Element.u8PresetNumber -1).u32SID;
				AMFMList.u8StationNameEncoding = oPresetMasterList.at(Element.u8PresetNumber -1).u32TextEncoding;
				AMFMList.u8ProgramService = oPresetMasterList.at(Element.u8PresetNumber -1).u32EnsembleId;
				break;
			default:
				break;

		}
		tU8 u8ListID = (tU8)oPresetMasterList.at(Element.u8PresetNumber -1).m_e8ListType.enType;
		AMFMList.e8ListID.enType = (midw_fi_tcl_e8_Tun_ListID::tenType)u8ListID;
	}

	ETG_TRACE_USR4(("vCreateTunerElement AMFMList PresetID = %d",AMFMList.u8ElementID));

}

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_PMClient::vCreateTunerElement
 *
 *DESCRIPTION: To Create elements for DABList
 *
 *PARAMETER:  midw_fi_tcl_TunMst_PresetListElement &  midw_ext_fi_tcl_DAB_PresetListElement
 *
 *
 *HISTORY: 04:2018 mhv6kor
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/

tVoid tunermaster_PMClient::vCreateTunerElement(midw_fi_tcl_TunMst_PresetListElement& Element, midw_ext_fi_tcl_DAB_PresetListElement& DABList )
{
	DABList.u32EnsembleId = Element.u32EnsembleId;
	DABList.u32ServiceID = Element.u32SID;

	DABList.ServiceLabel.sLabel.bSet(Element.sStationName.szValue ,midw_ext_fi_tclString::FI_EN_UTF8 );
	DABList.ServiceLabel.u16LabelMask = Element.u32TextEncoding;

	DABList.ComponentLabel.sLabel.bSet(Element.ComponentLabel.szValue,midw_ext_fi_tclString::FI_EN_UTF8);
	DABList.ComponentLabel.u16LabelMask = Element.u32ComponentLabelEncoding;

	DABList.EnsembleLabel.sLabel.bSet("" ,midw_ext_fi_tclString::FI_EN_UTF8 );
	DABList.EnsembleLabel.u16LabelMask = 0;

	DABList.u32Frequency = Element.u32Frequency;

	if((Element.u8PresetNumber > 0 ) && (Element.u8PresetNumber <=  oPresetMasterList.size()))
	{
		DABList.u8PresetElementID = oPresetMasterList.at(Element.u8PresetNumber -1).m_u8IndividualTunerPresetID;
		ETG_TRACE_USR4(("vCreateTunerElement DABList Element.u8PresetNumber = %d",Element.u8PresetNumber));
	}


	ETG_TRACE_USR4(("vCreateTunerElement DABList PresetID = %d",DABList.u8PresetElementID));
}

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_PMClient::vCreateTunerElement
 *
 *DESCRIPTION: To Create elements for SXMList
 *
 *PARAMETER:  midw_fi_tcl_TunMst_PresetListElement &  midw_ext_fi_tcl_PresetEntry
 *
 *
 *HISTORY: 04:2018 mhv6kor
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/

tVoid tunermaster_PMClient::vCreateTunerElement(midw_fi_tcl_TunMst_PresetListElement& Element, midw_ext_fi_tcl_PresetEntry& SXMList )
{
	SXMList.SID = Element.u32SID;
	if((Element.u8PresetNumber > 0 ) && (Element.u8PresetNumber <= oPresetMasterList.size()))
	{
		SXMList.Index = oPresetMasterList.at(Element.u8PresetNumber -1).m_u8IndividualTunerPresetID;
	}

	ETG_TRACE_USR4(("vCreateTunerElement SXMList PresetID = %d",SXMList.Index));
}


/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_PMClient::vHandle_s_RadioProfileSettings_Request
 *
 *DESCRIPTION: React on messages with FID = MIDW_TUNERMASTERFI_C_U16_FID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUEST
 *
 *PARAMETER:  poMessage : Pointer to CCA data
 *
 *
 *HISTORY: 04:2018 mhv6kor
 *         Initial version
 *
 ******************************************************************-FUNCHEADER*/

tVoid tunermaster_PMClient::vHandle_s_RadioProfileSettings_Request(amt_tclServiceData* poMessage)
{

	midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodResult oMsgMethodResult;
	oMsgMethodResult.TunerMaster_StatusResponse.u8TunermasterStatus.enType = midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_SUCCEED;
	if(NULL == poMessage || NULL == m_potunmstr_MsgFromHMI)
	{
      NORMAL_M_ASSERT(poMessage != NULL);
	  NORMAL_M_ASSERT(m_potunmstr_MsgFromHMI != NULL);
		return;
	}

	midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTING_REQUESTMethodStart oMsgMethodStart;
	vGetDataFromAmt(poMessage,oMsgMethodStart);

	if(oMsgMethodStart.RadioProfileSettingAction.bTUNMSTR_PROFILE_ACTION_AMSWITCH())
	{
		tBool bTmcTunerDPAMAvailStatus = true;
#ifndef GTEST_x86LINUX_BUILD
		dp_tclTmcTunerUsrDPAMAvailability oTmcTunerDPAMAvailability ;
		oTmcTunerDPAMAvailability.s32GetData(bTmcTunerDPAMAvailStatus);
#endif
		oMsgMethodResult.AMSwitch = bTmcTunerDPAMAvailStatus;
	}

	if(oMsgMethodStart.RadioProfileSettingAction.bTUNMSTR_PROFILE_ACTION_PRESETS())
	{
		for(vector<tU8>::iterator u8itr = oMsgMethodStart.PresetID.begin() ; u8itr != oMsgMethodStart.PresetID.end() ; u8itr++)
		{
			if(*u8itr > m_u8MasterListLastPresetID)
			{
				oMsgMethodResult.TunerMaster_StatusResponse.u8TunermasterStatus.enType = midw_fi_tcl_e8_TunMstr_ResponseStatus::FI_EN_TUN_MSTR_RES_REQ_FAIL;
				break;
			}

			if(*u8itr > 0)
			{
				switch(oPresetMasterList.at(*u8itr -1).e8RadioType.enType)
				{
					case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_AM:
					case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_AMHD:
					case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_FM:
					case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_FMHD:
					{
						midw_fi_tcl_TunMst_PresetListElement oElement;
						oElement.u32Frequency = oPresetMasterList.at(*u8itr - 1).u32Frequency;
						oElement.e8RadioType = oPresetMasterList.at(*u8itr - 1).e8RadioType;
						oElement.sStationName = oPresetMasterList.at(*u8itr - 1).sStationName;
						oElement.u8PresetNumber = *u8itr;
						oElement.u32TextEncoding = oPresetMasterList.at(*u8itr - 1).u32TextEncoding;
						oElement.u32SID = oPresetMasterList.at(*u8itr - 1).u32SID;
						oElement.u32TextEncoding = oPresetMasterList.at(*u8itr - 1).u32TextEncoding ;
						oElement.u32EnsembleId =  oPresetMasterList.at(*u8itr - 1).u32EnsembleId ;

						oMsgMethodResult.PresetList.push_back(oElement);
					}
					break;

					case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_DAB:
					{
						midw_fi_tcl_TunMst_PresetListElement oElement;
						oElement.u32Frequency = oPresetMasterList.at(*u8itr - 1).u32Frequency;
						oElement.e8RadioType = oPresetMasterList.at(*u8itr - 1).e8RadioType;
						oElement.u32SID = oPresetMasterList.at(*u8itr - 1).u32SID;
						oElement.u32EnsembleId = oPresetMasterList.at(*u8itr - 1).u32EnsembleId;
						oElement.ComponentLabel = oPresetMasterList.at(*u8itr - 1).ComponentLabel;
						oElement.u32TextEncoding = oPresetMasterList.at(*u8itr - 1).u32TextEncoding;
						oElement.sStationName = oPresetMasterList.at(*u8itr - 1).sStationName;
						oElement.u32ComponentLabelEncoding = oPresetMasterList.at(*u8itr - 1).u32ComponentLabelEncoding;
						oMsgMethodResult.PresetList.push_back(oElement);
						break;
					}
					case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_SXM:
					{
						midw_fi_tcl_TunMst_PresetListElement oElement;
						oElement.u32Frequency = oPresetMasterList.at(*u8itr - 1).u32Frequency;
						oElement.e8RadioType = oPresetMasterList.at(*u8itr - 1).e8RadioType;
						oElement.u32SID = oPresetMasterList.at(*u8itr - 1).u32SID;
						oMsgMethodResult.PresetList.push_back(oElement);
					}
					break;
					default:
						break;

				}
			}
		}
	}

   stSendCCAMsg ostSendCCAMsg;
   ostSendCCAMsg.u16DestAppID = poMessage->u16GetSourceAppID();
   ostSendCCAMsg.u16Fid = poMessage->u16GetFunctionID();
   ostSendCCAMsg.u8OpCode = AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
   ostSendCCAMsg.u16CmdCtr = poMessage->u16GetCmdCounter();
   ostSendCCAMsg.u16RegID = poMessage->u16GetRegisterID();

   m_potunmstr_MsgFromHMI->vSendMessage(ostSendCCAMsg, oMsgMethodResult);

}


/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_PMClient::vHandleRadioProfileSettings_ValidateAMFMParams
 *
 *DESCRIPTION: Internal Function to validate the AMFM parameters received from profile manager.
 *
 ******************************************************************-FUNCHEADER*/
tU8 tunermaster_PMClient::vHandleRadioProfileSettings_ValidateAMFMParams(midw_fi_tcl_TunMst_PresetListElement& Element , midw_fi_tcl_TunMstr_RadioSetting_StatusResponse& Response )
{

	switch(Element.e8RadioType.enType)
		{
			case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_AM:
			case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_AMHD:
			case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_DRM:
			{
				if((Element.u32Frequency >= m_poclConfigInterface->u32GetConfigData("LowLW") ) && (Element.u32Frequency <= m_poclConfigInterface->u32GetConfigData("HighLW") ) \
					&& ((unsigned int)m_poclConfigInterface->u32GetConfigData("ManualStepSizeLW") > 0 ))
				{
					if(((Element.u32Frequency - (unsigned int)m_poclConfigInterface->u32GetConfigData("LowLW")) % (unsigned int)m_poclConfigInterface->u32GetConfigData("ManualStepSizeLW")) != 0)
					{
						Response.RadioProfileSetting_Response.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_FAILED_FOR_AMFM;
						Response.RadioProfileSetting_ErrorCode.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_INVALIDFREQUENCY;
						return Element.u8PresetNumber;
					}
				}
				else if ( (Element.u32Frequency >= m_poclConfigInterface->u32GetConfigData("LowMW") ) && (Element.u32Frequency <= m_poclConfigInterface->u32GetConfigData("HighMW") ) \
					&& ((unsigned int)m_poclConfigInterface->u32GetConfigData("ManualStepSizeMW") > 0) )
				{
					if(((Element.u32Frequency - (unsigned int)m_poclConfigInterface->u32GetConfigData("LowMW")) % (unsigned int)m_poclConfigInterface->u32GetConfigData("ManualStepSizeMW")) != 0)
					{
						Response.RadioProfileSetting_Response.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_FAILED_FOR_AMFM;
						Response.RadioProfileSetting_ErrorCode.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_INVALIDFREQUENCY;
						return Element.u8PresetNumber;
					}
				}
				else
				{
					Response.RadioProfileSetting_Response.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_FAILED_FOR_AMFM;
					Response.RadioProfileSetting_ErrorCode.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_INVALIDFREQUENCY;
					return Element.u8PresetNumber;
				}
				break;
			}
			case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_FM:
			case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_FMHD:
			{
				tBool bValidFrequency= false;
				if((unsigned int)m_poclConfigInterface->u32GetConfigData("ManualStepSizeFM"))
				{
					if(((Element.u32Frequency - (unsigned int)m_poclConfigInterface->u32GetConfigData("LowFM")) % (unsigned int)m_poclConfigInterface->u32GetConfigData("ManualStepSizeFM")) == 0)
					{
						bValidFrequency =true;
					}
				}

				if ( (Element.u32Frequency < m_poclConfigInterface->u32GetConfigData("LowFM") ) || (Element.u32Frequency > m_poclConfigInterface->u32GetConfigData("HighFM") ) || (!bValidFrequency))
				{
					Response.RadioProfileSetting_Response.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_FAILED_FOR_AMFM;
					Response.RadioProfileSetting_ErrorCode.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_INVALIDFREQUENCY;
					return Element.u8PresetNumber;
				}
				break;
			}
			default:
				break;
		}

	if((Element.u8PresetNumber > m_u8MasterListLastPresetID))
	{
		Response.RadioProfileSetting_Response.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_FAILED_FOR_AMFM;
		Response.RadioProfileSetting_ErrorCode.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_PRESETNOTCONFIGURED;
			return Element.u8PresetNumber;
	}
	return 0;
}

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_PMClient::vHandleRadioProfileSettings_ValidateDABParams
 *
 *DESCRIPTION: Internal Function to validate the DAB parameters received from profile manager.
 *
 ******************************************************************-FUNCHEADER*/
tU8 tunermaster_PMClient::vHandleRadioProfileSettings_ValidateDABParams(midw_fi_tcl_TunMst_PresetListElement& Element , midw_fi_tcl_TunMstr_RadioSetting_StatusResponse& Response )
{


	if( !m_poclConfigInterface->u32GetConfigData("DABSupported"))
	{
		Response.RadioProfileSetting_Response.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_FAILED_FOR_DAB;
		Response.RadioProfileSetting_ErrorCode.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_BANDNOTSUPPORTED;
		return Element.u8PresetNumber;
	}

	if((Element.u8PresetNumber > m_u8MasterListLastPresetID))
	{
		Response.RadioProfileSetting_Response.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_FAILED_FOR_DAB;
		Response.RadioProfileSetting_ErrorCode.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_PRESETNOTCONFIGURED;
			return Element.u8PresetNumber;
	}
	tU8 u8ECC_UpperNibble = (Element.u32SID & TUN_ECC_UPPERNIBBLE_MASK) >> TUN_ECC_UPPERNIBBLE_RSHIFT;
	tU8 u8ECC_LowerNibble = (Element.u32SID & TUN_ECC_LOWERNIBBLE_MASK) >> TUN_ECC_LOWERNIBBLE_RSHIFT;
	if(!DAB_ECC_VALIDATION)
	{
		ETG_TRACE_USR4(("vHandleRadioProfileSettings_ValidateDABParams(), validation failed for SID : %d ",Element.u32SID));
		Response.RadioProfileSetting_Response.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_FAILED_FOR_DAB;
		Response.RadioProfileSetting_ErrorCode.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_INVALIDSID_ENSEMBLEID;
			return Element.u8PresetNumber;
	}

	return 0;
}

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_PMClient::vHandleRadioProfileSettings_ValidateSXMParams
 *
 *DESCRIPTION: Internal Function to validate the SXM parameters received from profile manager.
 *
 ******************************************************************-FUNCHEADER*/
tU8 tunermaster_PMClient::vHandleRadioProfileSettings_ValidateSXMParams(midw_fi_tcl_TunMst_PresetListElement& Element , midw_fi_tcl_TunMstr_RadioSetting_StatusResponse& Response )
{
	if(!m_poclConfigInterface->u32GetConfigData("SXMSupported"))
	{
		Response.RadioProfileSetting_Response.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_FAILED_FOR_SXM;
		Response.RadioProfileSetting_ErrorCode.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_BANDNOTSUPPORTED;
		return Element.u8PresetNumber;
	}

	if((Element.u8PresetNumber > m_u8MasterListLastPresetID))
	{
		Response.RadioProfileSetting_Response.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_FAILED_FOR_SXM;
		Response.RadioProfileSetting_ErrorCode.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_PRESETNOTCONFIGURED;
			return Element.u8PresetNumber;
	}

	return 0;
}

tVoid tunermaster_PMClient::vCreateIndividualTunerListDeleteOthers (midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart& oMsgMethodStart )
{
	midw_fi_tcl_TunMstr_RadioSetting_StatusResponse TunerMasterResponse;
	TunerMasterResponse.RadioProfileSetting_Response.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_SUCCEED;
	TunerMasterResponse.RadioProfileSetting_ErrorCode.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_NONE;

	m_u8RadioProfileSettingRequestCount = 0;
	m_bRadioSettingResponseSent = false;
	tU8 RadioSettingPresets = 0;

	tU8 u8FailedPresetID = 0;

	midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart AMFMList;
	midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart DABList;
	midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart SXMList;


	vInitializeAMFMListDeleteOthers(AMFMList);
	vInitializeDABListDeleteOthers(DABList);


	RadioSettingPresets = oMsgMethodStart.RadioProfile_PresetList.size();
	ETG_TRACE_USR4(("vCreateIndividualTunerListDeleteOthers RadioProfile_PresetList size = %d",oMsgMethodStart.RadioProfile_PresetList.size()));
	ETG_TRACE_USR4(("vCreateIndividualTunerListDeleteOthers AMFMList size = %d",AMFMList.Tun_ListElements.TunerListElement.size()));
	ETG_TRACE_USR4(("vCreateIndividualTunerListDeleteOthers DABList size = %d",DABList.PresetList.size()));

	for( vector<midw_fi_tcl_TunMst_PresetListElement>::iterator itr = oMsgMethodStart.RadioProfile_PresetList.begin() ; \
	TunerMasterResponse.RadioProfileSetting_Response.enType == midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_SUCCEED && \
	itr != oMsgMethodStart.RadioProfile_PresetList.end() ; itr++)
	{
		switch (itr->e8RadioType.enType)
		{
			case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_AM:
			case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_AMHD:
			case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_FM:
			case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_FMHD:
			case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_DRM:
				{
					u8FailedPresetID = vHandleRadioProfileSettings_ValidateAMFMParams(*itr,  TunerMasterResponse );
					if(TunerMasterResponse.RadioProfileSetting_Response.enType == midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_SUCCEED)
					{
						midw_fi_tcl_TunerListElement AMFMListElement;
						vCreateTunerElement(*itr,AMFMListElement);

						tBool bNewElement = true;
						for( vector<midw_fi_tcl_TunerListElement>::iterator itrFind = AMFMList.Tun_ListElements.TunerListElement.begin() ; itrFind != AMFMList.Tun_ListElements.TunerListElement.end() ; itrFind++)
						{
							 if(m_poclConfigInterface->u32GetConfigData("PresetListType"))
							 {
								if( AMFMListElement.u8ElementID == itrFind->u8ElementID  )
								{
									(*itrFind) = AMFMListElement;
									AMFMListElement.e8ListID.enType = itrFind->e8ListID.enType;
									bNewElement = false;
								}
							 }
							 else
							 {
									if(( AMFMListElement.u8ElementID == itrFind->u8ElementID  ) && ( AMFMListElement.e8ListID.enType == itrFind->e8ListID.enType  ))
									{
										(*itrFind) = AMFMListElement;
										bNewElement = false;
									}
							 }
						}
						if(bNewElement)
							AMFMList.Tun_ListElements.TunerListElement.push_back(AMFMListElement);
					}
					break;
				}
			case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_DAB:
				{
					u8FailedPresetID = vHandleRadioProfileSettings_ValidateDABParams(*itr,  TunerMasterResponse );
					if(TunerMasterResponse.RadioProfileSetting_Response.enType == midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_SUCCEED)
					{
						if(m_poclConfigInterface->u32GetConfigData("DABSupported"))
						{
							midw_ext_fi_tcl_DAB_PresetListElement DABListElement;
							vCreateTunerElement(*itr,DABListElement);

							tBool bIsNewElement= true;

							for( vector<midw_ext_fi_tcl_DAB_PresetListElement>::iterator itrFind = DABList.PresetList.begin() ; itrFind != DABList.PresetList.end() ; itrFind++)
							{
								if( DABListElement.u8PresetElementID == itrFind->u8PresetElementID)
								{
										(*itrFind) = DABListElement;
										bIsNewElement= false;
								}
							}
							if(bIsNewElement)
								DABList.PresetList.push_back(DABListElement);
						}
					}
					break;
				}
			case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_SXM:
				{
					u8FailedPresetID = vHandleRadioProfileSettings_ValidateSXMParams(*itr,  TunerMasterResponse );
					if(TunerMasterResponse.RadioProfileSetting_Response.enType == midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_SUCCEED)
					{
						midw_ext_fi_tcl_PresetEntry SXMListElement;
						vCreateTunerElement(*itr,SXMListElement);
						SXMList.PresetEntry.push_back(SXMListElement);
					}
					break;
				}
			default:
				break;

		}

	}

	if(TunerMasterResponse.RadioProfileSetting_Response.enType != midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_SUCCEED)
	{
		vSendResponseToRadioSetting(TunerMasterResponse , u8FailedPresetID);
	}
	else
	{

		if( (NULL != m_potunmstr_Preset_Handler ) && (m_poclConfigInterface->u32GetConfigData("PresetListType")))
		{
			 m_potunmstr_Preset_Handler->vHandleSystemSetForPresetList(false);
			 m_potunmstr_Preset_Handler->vHandleSystemSetFinishForPresetList();
			 m_bDeleteOthersOption = true;
		}

		ETG_TRACE_USR4(("vCreateIndividualTunerListDeleteOthers AMFMList size = %d",AMFMList.Tun_ListElements.TunerListElement.size()));
		if((NULL != m_potunmstr_TunClnt_Handlr) && ( !AMFMList.Tun_ListElements.TunerListElement.empty() && (NULL != m_potunmstr_Preset_Handler )))
		{
			ETG_TRACE_USR4(("vCreateIndividualTunerListDeleteOthers m_u8UserID = %d",m_u8UserID));
			AMFMList.UserID = m_u8UserID; /*mhv6kor as per discussion only current user can be synced , parameter kept for further extension if required*/
			m_potunmstr_TunClnt_Handlr->vSendAMFMListonlinePersonalization(AMFMList);
			m_potunmstr_Preset_Handler->vSetProfile_PresetOperation();
			m_u8RadioProfileSettingRequestCount++;
		}


		if(m_poclConfigInterface->u32GetConfigData("DABSupported"))
		{
			ETG_TRACE_USR4(("vCreateIndividualTunerListDeleteOthers DABList size = %d",DABList.PresetList.size()));
			if((NULL != m_potunmstr_DABClient_Handler) && ( !DABList.PresetList.empty()))
			{
				m_potunmstr_DABClient_Handler->vSendDABListonlinePersonalization(DABList);
				m_u8RadioProfileSettingRequestCount++;
			}
		}
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
		if(m_poclConfigInterface->u32GetConfigData("SXMSupported"))
		{
			ETG_TRACE_USR4(("vCreateIndividualTunerListDeleteOthers SXMList size = %d",SXMList.PresetEntry.size()));
			if( (NULL != m_potunmstr_SXMClient_Handler) && (!SXMList.PresetEntry.empty()))
			{
				m_potunmstr_SXMClient_Handler->vSendSXMListonlinePersonalization(SXMList);
				m_u8RadioProfileSettingRequestCount++;
			}
		}
#endif
	}
}

tVoid tunermaster_PMClient::vCreateIndividualTunerListKeepOthers(midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodStart& oMsgMethodStart )
{
	midw_fi_tcl_TunMstr_RadioSetting_StatusResponse TunerMasterResponse;
	TunerMasterResponse.RadioProfileSetting_Response.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_SUCCEED;
	TunerMasterResponse.RadioProfileSetting_ErrorCode.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_NONE;

	m_u8RadioProfileSettingRequestCount = 0;
	m_bRadioSettingResponseSent = false;
	tU8 u8FailedPresetID = 0;

	midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart AMFMList;
	midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart DABList;
	midw_ext_sxm_audiofi_tclMsgSetPresetListMethodStart SXMList;

	ETG_TRACE_USR4(("vCreateIndividualTunerListKeepOthers RadioProfile_PresetList size = %d",oMsgMethodStart.RadioProfile_PresetList.size()));

	for( vector<midw_fi_tcl_TunMst_PresetListElement>::iterator itr = oMsgMethodStart.RadioProfile_PresetList.begin() ;\
	(TunerMasterResponse.RadioProfileSetting_Response.enType == midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_SUCCEED )&&\
	(itr != oMsgMethodStart.RadioProfile_PresetList.end()) ; itr++)
	{
		ETG_TRACE_USR4(("vCreateIndividualTunerListKeepOthers RadioProfile_PresetList u8PresetNumber = %d",itr->u8PresetNumber));
		ETG_TRACE_USR4(("vCreateIndividualTunerListKeepOthers RadioProfile_PresetList u32Frequency = %d",itr->u32Frequency));
		switch (itr->e8RadioType.enType)
		{
			case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_AM:
			case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_AMHD:
			case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_FM:
			case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_FMHD:
			case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_DRM:
				{
					u8FailedPresetID = vHandleRadioProfileSettings_ValidateAMFMParams(*itr,  TunerMasterResponse );


					//TODO delete below prints not required
					ETG_TRACE_USR4(("vCreateIndividualTunerListKeepOthers RadioProfile_PresetList oMsgMethodStart.RadioProfile_AMSwitch = %d",oMsgMethodStart.RadioProfile_AMSwitch));

					if((oMsgMethodStart.RadioProfile_AMSwitch == false) && ((midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_AM == itr->e8RadioType.enType)|| (midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_AMHD == itr->e8RadioType.enType)) )
					{
						TunerMasterResponse.RadioProfileSetting_Response.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_FAILED_FOR_AMFM;
						TunerMasterResponse.RadioProfileSetting_ErrorCode.enType = midw_fi_tcl_e8_TunMstr_RadioProfileSetting_ErrorCode::FI_EN_TUN_MSTR_RADIOPROFILESETTING_ERRORCODE_BANDNOTSUPPORTED;
						u8FailedPresetID =0;
						break;
					}

					if(TunerMasterResponse.RadioProfileSetting_Response.enType == midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_SUCCEED)
					{
						if(m_poclConfigInterface->u32GetConfigData("DABSupported"))
						{
							midw_ext_fi_tcl_DAB_PresetListElement DABListElement;
							DABListElement.u8PresetElementID = itr->u8PresetNumber;
							DABListElement.u32Frequency = 0;
							DABListElement.u32ServiceID = 0;
							DABList.PresetList.push_back(DABListElement);
						}
#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
						if(m_poclConfigInterface->u32GetConfigData("SXMSupported"))
						{
							midw_ext_fi_tcl_PresetEntry SXMListElement;
							SXMListElement.SID = 0;
							SXMList.PresetEntry.push_back(SXMListElement);
						}
#endif
						midw_fi_tcl_TunerListElement AMFMListElement;
						vCreateTunerElement(*itr,AMFMListElement);
						AMFMList.Tun_ListElements.TunerListElement.push_back(AMFMListElement);
					}
					break;
				}
			case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_DAB:
				{
					u8FailedPresetID = vHandleRadioProfileSettings_ValidateDABParams(*itr,  TunerMasterResponse );
					if(TunerMasterResponse.RadioProfileSetting_Response.enType == midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_SUCCEED)
					{
						if(m_poclConfigInterface->u32GetConfigData("DABSupported"))
						{
							midw_fi_tcl_TunerListElement AMFMListElement;
							AMFMListElement.u8ElementID = itr->u8PresetNumber;
							AMFMListElement.u32Frequency = 0;
							if (m_poclConfigInterface->u32GetConfigData("PresetListType"))
							{
								AMFMListElement.e8ListID.enType = midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_MIX1;
							}
							else
							{
								tU8 u8ListID = (tU8)oPresetMasterList.at(itr->u8PresetNumber-1).m_e8ListType.enType;
								AMFMListElement.e8ListID.enType = (midw_fi_tcl_e8_Tun_ListID::tenType)u8ListID;
							}
							AMFMList.Tun_ListElements.TunerListElement.push_back(AMFMListElement);
							midw_ext_fi_tcl_DAB_PresetListElement DABListElement;
							vCreateTunerElement(*itr,DABListElement);
							DABList.PresetList.push_back(DABListElement);
						}
					}
					break;
				}
			case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_SXM:
				{
					u8FailedPresetID = vHandleRadioProfileSettings_ValidateSXMParams(*itr,  TunerMasterResponse );
					if(TunerMasterResponse.RadioProfileSetting_Response.enType == midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_SUCCEED)
					{
						midw_fi_tcl_TunerListElement AMFMListElement;
						AMFMListElement.u8ElementID = itr->u8PresetNumber;
						AMFMListElement.u32Frequency = 0;
						if (m_poclConfigInterface->u32GetConfigData("PresetListType"))
						{
							AMFMListElement.e8ListID.enType = midw_fi_tcl_e8_Tun_ListID::FI_EN_TUN_BANK_MIX1;
						}
						else
						{
							tU8 u8ListID = (tU8)oPresetMasterList.at(itr->u8PresetNumber-1).m_e8ListType.enType;
							AMFMListElement.e8ListID.enType = (midw_fi_tcl_e8_Tun_ListID::tenType)u8ListID;
						}
						AMFMList.Tun_ListElements.TunerListElement.push_back(AMFMListElement);
						midw_ext_fi_tcl_PresetEntry SXMListElement;
						vCreateTunerElement(*itr,SXMListElement);
						SXMList.PresetEntry.push_back(SXMListElement);
					}
					break;
				}

			default:
				break;
		}


	}

	if(TunerMasterResponse.RadioProfileSetting_Response.enType != midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_SUCCEED)
	{
		vSendResponseToRadioSetting(TunerMasterResponse , u8FailedPresetID);
	}
	else
	{
		ETG_TRACE_USR4(("vCreateIndividualTunerListKeepOthers AMFMList size = %d",AMFMList.Tun_ListElements.TunerListElement.size()));
		if((NULL != m_potunmstr_TunClnt_Handlr) && ( !AMFMList.Tun_ListElements.TunerListElement.empty()) && (NULL != m_potunmstr_Preset_Handler))
		{
			m_u8RadioProfileSettingRequestCount++;
			AMFMList.UserID = m_u8UserID; /*mhv6kor as per discussion only current user can be synced , parameter kept for further extension if required*/
			m_potunmstr_TunClnt_Handlr->vSendAMFMListonlinePersonalization(AMFMList);
			m_potunmstr_Preset_Handler->vSetProfile_PresetOperation();
		}

		if(m_poclConfigInterface->u32GetConfigData("DABSupported"))
		{
			ETG_TRACE_USR4(("vCreateIndividualTunerListKeepOthers DABList size = %d",DABList.PresetList.size()));
			if((NULL != m_potunmstr_DABClient_Handler) && ( !DABList.PresetList.empty()))
			{
				ETG_TRACE_USR4(("vCreateIndividualTunerListKeepOthers DABList "));
				m_potunmstr_DABClient_Handler->vSendDABListonlinePersonalization(DABList);
				m_u8RadioProfileSettingRequestCount++;
			}
		}

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
		if(m_poclConfigInterface->u32GetConfigData("SXMSupported"))
		{
			ETG_TRACE_USR4(("vCreateIndividualTunerListKeepOthers SXMList size = %d",SXMList.PresetEntry.size()));
			if( (NULL != m_potunmstr_SXMClient_Handler) && (!SXMList.PresetEntry.empty()))
			{
				m_potunmstr_SXMClient_Handler->vSendSXMListonlinePersonalization(SXMList);
				m_u8RadioProfileSettingRequestCount++;
			}
		}
#endif
	}
}

tVoid  tunermaster_PMClient::vInitializeAMFMListDeleteOthers(midw_tunerfi_tclMsgFID_TUN_S_PRESETLIST_CONTENT_UPDATEMethodStart& AMFMList)
{
	bool bIsAMFMRadioType = false;
	for ( vector<TunerMasterPresetList>::iterator it=oPresetMasterList.begin() ; it != oPresetMasterList.end() ; it++ )
	{
		bIsAMFMRadioType = false;
		switch(it->e8RadioType.enType)
		{
		case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_AM:
		case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_AMHD:
		case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_FM:
		case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_FMHD:
		case midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_DRM:
			bIsAMFMRadioType = true;
			break;
		default:
			break;
		}

		if( bIsAMFMRadioType)
		{
			midw_fi_tcl_TunerListElement AMFMListElement;
			AMFMListElement.u8ElementID = it->m_u8IndividualTunerPresetID;
			tU8 u8ListID = (tU8)it->m_e8ListType.enType;
			AMFMListElement.e8ListID.enType = (midw_fi_tcl_e8_Tun_ListID::tenType)u8ListID;
			AMFMList.Tun_ListElements.TunerListElement.push_back(AMFMListElement);
			ETG_TRACE_USR4(("vInitializeAMFMListDeleteOthers() AMFM Element %d ",it->m_u8IndividualTunerPresetID ));
		}
	}

	vPrintMasterList();
}

tVoid  tunermaster_PMClient::vInitializeDABListDeleteOthers(midw_ext_dabtunerfi_tclMsgFID_DAB_S_SAVE_PRESET_LISTMethodStart& DABList)
{
	for ( vector<TunerMasterPresetList>::iterator it=oPresetMasterList.begin() ; it != oPresetMasterList.end() ; it++ )
	{

		if (midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_DAB == it->e8RadioType.enType)
		{
			midw_ext_fi_tcl_DAB_PresetListElement DABListElement;
			DABListElement.u8PresetElementID = it->m_u8IndividualTunerPresetID;
			DABList.PresetList.push_back(DABListElement);
			ETG_TRACE_USR4(("vInitializeDABListDeleteOthers() DAB Element  %d ",it->m_u8IndividualTunerPresetID ));
		}
	}
}
/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_PMClient::vSendRadioSettingNotification
 *
 *DESCRIPTION:  Notify Preset that has been modified .
 *
 *PARAMETER:  vector of PresetID
 *
 *
 *
 ******************************************************************-FUNCHEADER*/
tVoid tunermaster_PMClient::vSendRadioSettingNotification(std::vector<tU8> u8PresetID )
{
	midw_tunermasterfi_tclMsgFID_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATIONStatus oStatusMessage;
	oStatusMessage.RadioProfileSettingAction.u8Value = 01;
	oStatusMessage.PresetIndexList = u8PresetID;

#if 1
	for ( vector<tU8>::iterator it=u8PresetID.begin() ; it != u8PresetID.end() ; it++ )
	{
		ETG_TRACE_USR4(("vSendRadioSettingNotification() PresetID =  %d ",*it ));
	}
#endif

	m_potunmstr_MsgToHMI->vSend_g_TUNMSTR_G_RADIOPROFILE_SETTING_NOTIFICATION_Status(oStatusMessage);
}


/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_PMClient::vClearAMPresetsWhenDisableAM
 *
 *DESCRIPTION:  When AM switch  is disabled we need to clear all the presets in master list and send notification to profile manager component.
 *
 *
 ******************************************************************-FUNCHEADER*/
tVoid tunermaster_PMClient::vClearAMPresetsWhenDisableAM()
{
	std::vector<tU8> u8PresetID;

	for ( vector<TunerMasterPresetList>::iterator it=oPresetMasterList.begin() ; it != oPresetMasterList.end() ; it++ )
	{
		if (midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_AM == it->e8RadioType.enType || midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_AMHD == it->e8RadioType.enType)
		{
			TunerMasterPresetList oElement;
			oElement.u8PresetNumber = it->u8PresetNumber;
			oElement.m_e8ListType.enType = it->m_e8ListType.enType;
			oElement.m_u8IndividualTunerPresetID = it->m_u8IndividualTunerPresetID;
			*it = oElement;
			u8PresetID.push_back(oElement.u8PresetNumber);
			ETG_TRACE_USR4(("vClearAMPresetsWhenDisableAM() Element  %d ",oElement.u8PresetNumber ));
		}
	}

	if(!u8PresetID.empty())
		vSendRadioSettingNotification(u8PresetID);
}


/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:     tunermaster_PMClient::vIndividualTunerPresetListUpdate
 *
 *DESCRIPTION:  Update Master List in case of Change in Presets
 *
 *PARAMETER:  midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus  list reference
 *
 *
 *
 ******************************************************************-FUNCHEADER*/
tVoid tunermaster_PMClient::vIndividualTunerPresetListUpdate(midw_tunermasterfi_tclMsgFID_TUNMSTR_G_PRESET_LISTStatus oStatus)
{
	if((NULL == m_poclConfigInterface) || ( true == oStatus.ListOfStations.empty()))
	{
		ETG_TRACE_USR4(("vIndividualTunerPresetListUpdate() Config or NULL error"));
		return;
	}

	tU8 u8Itr=0 ,u8LastPresetElementNumberOfPresetList=0 ,u8TunerID = 1;
	midw_fi_tcl_e8_List List;
	List.enType = oStatus.List.enType;
	u8LastPresetElementNumberOfPresetList  = vGetEndPresetIDForListID(List);

	if(0 == u8LastPresetElementNumberOfPresetList)
	{
		ETG_TRACE_USR4(("vIndividualTunerPresetListUpdate() AMFM u8LastPresetElementNumberOfPresetList Error " ));
		return;
	}

	ETG_TRACE_USR4(("vIndividualTunerPresetListUpdate() AMFM u8LastPresetElementNumberOfPresetList %d ",u8LastPresetElementNumberOfPresetList ));

	switch(oStatus.List.enType)
	{
		case midw_fi_tcl_e8_List::FI_EN_BANK_AM_MW1:
		case midw_fi_tcl_e8_List::FI_EN_BANK_AM_MW2:
		case midw_fi_tcl_e8_List::FI_EN_BANK_AM_MW3:
		case midw_fi_tcl_e8_List::FI_EN_BANK_AM_MWAST:
		case midw_fi_tcl_e8_List::FI_EN_BANK_AM_LW1:
		case midw_fi_tcl_e8_List::FI_EN_BANK_AM_LW2:
		case midw_fi_tcl_e8_List::FI_EN_BANK_AM_LW3:
		case midw_fi_tcl_e8_List::FI_EN_BANK_AM_LWAST:
		case midw_fi_tcl_e8_List::FI_EN_BANK_AM_AST:
			ETG_TRACE_USR4(("vIndividualTunerPresetListUpdate() AMList"));
			u8Itr = u8LastPresetElementNumberOfPresetList - m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankMW");
		break;

		case midw_fi_tcl_e8_List::FI_EN_BANK_FM1:
		case midw_fi_tcl_e8_List::FI_EN_BANK_FM2:
		case midw_fi_tcl_e8_List::FI_EN_BANK_FM3:
			ETG_TRACE_USR4(("vIndividualTunerPresetListUpdate() FMList"));
			u8Itr = u8LastPresetElementNumberOfPresetList - m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankFM");
			break;

		case midw_fi_tcl_e8_List::FI_EN_BANK_MIX1:
		case midw_fi_tcl_e8_List::FI_EN_BANK_MIX2:
		case midw_fi_tcl_e8_List::FI_EN_BANK_MIX3:
		case midw_fi_tcl_e8_List::FI_EN_BANK_MIX_AST:
			ETG_TRACE_USR4(("vIndividualTunerPresetListUpdate() FI_EN_BANK_MIX"));
			u8Itr = u8LastPresetElementNumberOfPresetList - m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankForMixedAllBands");
			break;

		case midw_fi_tcl_e8_List::FI_EN_BANK_DRM1:
		case midw_fi_tcl_e8_List::FI_EN_BANK_DRM_AST:
		{
			ETG_TRACE_USR4(("vIndividualTunerPresetListUpdate() DRM"));
			u8Itr = u8LastPresetElementNumberOfPresetList - m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankDRM");
			break;
		}
		default:
			ETG_TRACE_USR4(("vIndividualTunerPresetListUpdate() OtherList"));
			break;

	}

	if(u8LastPresetElementNumberOfPresetList)
	{
			vector<midw_fi_tcl_PresetList>::iterator it=oStatus.ListOfStations.begin();
			while( u8Itr <u8LastPresetElementNumberOfPresetList && it != oStatus.ListOfStations.end())
			{
				if(u8Itr < oPresetMasterList.size())
				{
					oPresetMasterList.at(u8Itr).u32Frequency = it->Frequency;
					oPresetMasterList.at(u8Itr).sStationName = it->PSName;
					oPresetMasterList.at(u8Itr).m_u8IndividualTunerPresetID = u8TunerID ;

					switch(it->Band.enType)
					{
						case midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_FM:
							{


								oPresetMasterList.at(u8Itr).u32SID = it->u32HDStationId_DRMServiceId;
								oPresetMasterList.at(u8Itr).u32TextEncoding = (tU8)it->e8HDTextEncoding.enType;
								oPresetMasterList.at(u8Itr).u32EnsembleId = it->u8HDAudioProgram_DRMShortID;

								if(it->e8Modulation.enType == midw_fi_tcl_e8_ModulationType::FI_EN_TUN_MSTR_MODULATION_HD)
									oPresetMasterList.at(u8Itr).e8RadioType.enType = midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_FMHD;

								if(it->e8Modulation.enType == midw_fi_tcl_e8_ModulationType::FI_EN_TUN_MSTR_MODULATION_ANALOG)
									oPresetMasterList.at(u8Itr).e8RadioType.enType = midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_FM;
							}
							break;
						case midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_MW:
						case midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_LW:
						case midw_fi_tcl_e8_Band::FI_EN_TUN_MSTR_BAND_CB1:
							{
								oPresetMasterList.at(u8Itr).u32SID = it->u32HDStationId_DRMServiceId;
								oPresetMasterList.at(u8Itr).u32TextEncoding = (tU8)it->e8HDTextEncoding.enType;
								oPresetMasterList.at(u8Itr).u32EnsembleId = it->u8HDAudioProgram_DRMShortID;

								if(it->e8Modulation.enType == midw_fi_tcl_e8_ModulationType::FI_EN_TUN_MSTR_MODULATION_HD)
									oPresetMasterList.at(u8Itr).e8RadioType.enType = midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_AMHD;

								if(it->e8Modulation.enType == midw_fi_tcl_e8_ModulationType::FI_EN_TUN_MSTR_MODULATION_ANALOG)
									oPresetMasterList.at(u8Itr).e8RadioType.enType = midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_AM;

								if(it->e8Modulation.enType == midw_fi_tcl_e8_ModulationType::FI_EN_TUN_MSTR_MODULATION_DRM)
									oPresetMasterList.at(u8Itr).e8RadioType.enType = midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_DRM;
							}
							break;
						default:
							break;
					}
				}
				u8TunerID++;
				u8Itr++ ;
				it++;
			}
	}
	else
	{
			ETG_TRACE_USR4(("vIndividualTunerPresetListUpdate() ERROR"));
	}

	vPrintMasterList();

}

tVoid tunermaster_PMClient::vIndividualTunerPresetListUpdate(midw_ext_dabtunerfi_tclMsgFID_DAB_G_PRESET_LISTStatus oStatus)
{
	if((NULL == m_poclConfigInterface) || ( true == oStatus.PresetList.empty()))
	{
		ETG_TRACE_USR4(("vIndividualTunerPresetListUpdate() Config or NULL error"));
		return;
	}

	tU8 u8Itr=0 ,u8LastPresetElementNumberOfPresetList=0 ,u8TunerID = 1;
	midw_fi_tcl_e8_List List;
	if(m_poclConfigInterface->u32GetConfigData("PresetListType"))
		List.enType = midw_fi_tcl_e8_List::FI_EN_BANK_MIX1;
	else
		List.enType = midw_fi_tcl_e8_List::FI_EN_BANK_DAB1;
	u8LastPresetElementNumberOfPresetList  = vGetEndPresetIDForListID(List);

	if(0 == u8LastPresetElementNumberOfPresetList)
	{
		ETG_TRACE_USR4(("vIndividualTunerPresetListUpdate() DAB u8LastPresetElementNumberOfPresetList Error " ));
		return;
	}

	ETG_TRACE_USR4(("vIndividualTunerPresetListUpdate() DAB u8LastPresetElementNumberOfPresetList %d ",u8LastPresetElementNumberOfPresetList ));

	if(u8LastPresetElementNumberOfPresetList)
	{

		if(m_poclConfigInterface->u32GetConfigData("PresetListType"))
			u8Itr = u8LastPresetElementNumberOfPresetList - m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankForMixedAllBands");
		else
			u8Itr = u8LastPresetElementNumberOfPresetList - m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankDAB");

		vector<midw_ext_fi_tcl_DAB_PresetListElement>::iterator it=oStatus.PresetList.begin();
		while( u8Itr <u8LastPresetElementNumberOfPresetList && it != oStatus.PresetList.end())
		{
			if((u8Itr < oPresetMasterList.size())  &&  (it->u32Frequency > 0))
			{
				oPresetMasterList.at(u8Itr).u32Frequency = it->u32Frequency;
				oPresetMasterList.at(u8Itr).m_u8IndividualTunerPresetID = u8TunerID;
				oPresetMasterList.at(u8Itr).u32SID = it->u32ServiceID;
				oPresetMasterList.at(u8Itr).u32EnsembleId = it->u32EnsembleId;
				oPresetMasterList.at(u8Itr).sStationName.bSet(it->ServiceLabel.sLabel,midw_fi_tclString::FI_EN_UTF8);
				oPresetMasterList.at(u8Itr).u32TextEncoding = it->ServiceLabel.u16LabelMask;
				oPresetMasterList.at(u8Itr).ComponentLabel.bSet(it->ComponentLabel.sLabel,midw_fi_tclString::FI_EN_UTF8);
				oPresetMasterList.at(u8Itr).u32ComponentLabelEncoding = it->ComponentLabel.u16LabelMask;
				oPresetMasterList.at(u8Itr).e8RadioType.enType =  midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_DAB;
			}
			u8TunerID++;
			u8Itr++ ;
			it++;
		}
	}
	else
	{
		ETG_TRACE_USR4(("vIndividualTunerPresetListUpdate() DABList Update ERROR"));
	}
}



/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:      tunermaster_PMClient::vIndividualTunerPresetListUpdate
 *
 *DESCRIPTION:	 Update Master List with SXM Data during 1)Startup 2)During Preset Change
 *
 *
 ******************************************************************-FUNCHEADER*/

tVoid tunermaster_PMClient::vIndividualTunerPresetListUpdate(midw_ext_sxm_audiofi_tclMsgPresetChannelUpdateStatus oStatus)
{
	tU8 u8PresetList = ((m_u8MasterListLastPresetID - (m_poclConfigInterface->u32GetConfigData("NumberOfPresetListSXM")*m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankSXM")))\
			+ ((oStatus.PresetBand-1)* (m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankSXM")) ) + oStatus.PresetIndex -1) ;
	if( (u8PresetList > 0) && (u8PresetList  < oPresetMasterList.size()))
	{
		if(oPresetMasterList.at(u8PresetList).u32SID != oStatus.ChannelInfo.ServiceID)
		{
			ETG_TRACE_USR4(("vHandleRadioProfileSettings m_u8IndividualTunerPresetID = %d",oPresetMasterList.at(u8PresetList).m_u8IndividualTunerPresetID));

			if( 0 == oPresetMasterList.at(u8PresetList).u32SID)
			{
				oPresetMasterList.at(u8PresetList).u32SID = oStatus.ChannelInfo.ServiceID;
			}
			else
			{
				oPresetMasterList.at(u8PresetList).u32SID = oStatus.ChannelInfo.ServiceID;
				std::vector<tU8> u8PresetID;
				u8PresetID.push_back(u8PresetList +1);
				vSendRadioSettingNotification(u8PresetID);
				ETG_TRACE_USR4(("vIndividualTunerPresetListUpdate() u8PresetID  = %d ", u8PresetList));
			}
		}

	}
}

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:      tunermaster_PMClient::vSendResponseToRadioSetting
 *
 *DESCRIPTION:	 Send Response to Methode Start RadioProfileSetting
 *				 Also takes care of syncorinization between SXM DAB and TMC tuner when OnlinePersonalization data is recived.
 *
 ******************************************************************-FUNCHEADER*/

tVoid  tunermaster_PMClient:: vSendResponseToRadioSetting(midw_fi_tcl_TunMstr_RadioSetting_StatusResponse& Response ,tU8 u8FailedPresetID)
{
   if (m_potunmstr_MsgFromHMI == NULL)
   {
      NORMAL_M_ASSERT(m_potunmstr_MsgFromHMI != NULL);
      return;
   }

	if(m_u8RadioProfileSettingRequestCount)
		m_u8RadioProfileSettingRequestCount--;

   stSendCCAMsg ostSendCCAMsg;
   ostSendCCAMsg.u16DestAppID = m_u16DestAppID;
   ostSendCCAMsg.u16Fid = m_u16GetFunctionID;
   ostSendCCAMsg.u8OpCode = AMT_C_U8_CCAMSG_OPCODE_METHODRESULT;
   ostSendCCAMsg.u16CmdCtr = m_u16CmdCtr;
   ostSendCCAMsg.u16RegID = m_u16GetRegisterID;

	if(0 != m_u8RadioProfileSettingRequestCount)
	{
		ETG_TRACE_USR4(("vSendResponseToRadioSetting m_u8RadioProfileSettingRequestCount = %d",m_u8RadioProfileSettingRequestCount));

		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult oRadioSettingMethodResult;
		oRadioSettingMethodResult.u8FailedPresetID = u8FailedPresetID;
		oRadioSettingMethodResult.RadioProfileSetting_Response = Response;

		ETG_TRACE_USR4(("vSendResponseToRadioSetting Response.RadioProfileSetting_Response = %d",Response.RadioProfileSetting_Response.enType));

		if( (Response.RadioProfileSetting_Response.enType != midw_fi_tcl_e8_TunMstr_RadioProfileSetting_Response::FI_EN_TUN_MSTR_RADIOPROFILESETTING_RES_SUCCEED ) && (!m_bRadioSettingResponseSent))
		{
			ETG_TRACE_USR4(("vSendResponseToRadioSetting Response.RadioProfileSetting_ErrorCode = %d",Response.RadioProfileSetting_ErrorCode.enType));
			ETG_TRACE_USR4(("vSendResponseToRadioSetting u8FailedPresetID = %d",oRadioSettingMethodResult.u8FailedPresetID));

         m_potunmstr_MsgFromHMI->vSendMessage(ostSendCCAMsg, oRadioSettingMethodResult);

         m_u8RadioProfileSettingRequestCount = 0;
         m_bRadioSettingResponseSent = true;
		}
		return;

	}
	else
	{
		midw_tunermasterfi_tclMsgFID_TUNMSTR_S_RADIOPROFILE_SETTINGMethodResult oRadioSettingMethodResult;
		oRadioSettingMethodResult.u8FailedPresetID = u8FailedPresetID;
		oRadioSettingMethodResult.RadioProfileSetting_Response = Response;

		if(!m_bRadioSettingResponseSent)
		{
			ETG_TRACE_USR4(("vSendResponseToRadioSetting Response.RadioProfileSetting_Response = %d",Response.RadioProfileSetting_Response.enType));
			ETG_TRACE_USR4(("vSendResponseToRadioSetting Response.RadioProfileSetting_ErrorCode = %d",Response.RadioProfileSetting_ErrorCode.enType));
			ETG_TRACE_USR4(("vSendResponseToRadioSetting u8FailedPresetID = %d",oRadioSettingMethodResult.u8FailedPresetID));
			m_potunmstr_MsgFromHMI->vSendMessage(ostSendCCAMsg, oRadioSettingMethodResult);
         m_u8RadioProfileSettingRequestCount = 0;
         m_bRadioSettingResponseSent = true;
		}
	}

}


/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:      tunermaster_PMClient::vPrintMasterList
 *
 *DESCRIPTION:	 To Print information related to MasterList Creation
 *
 ******************************************************************-FUNCHEADER*/

tVoid tunermaster_PMClient::vPrintMasterList()
{
	for ( vector<TunerMasterPresetList>::iterator it=oPresetMasterList.begin() ; it != oPresetMasterList.end() ; it++ )
	{
		ETG_TRACE_USR4(("vPrintMasterList() u8PresetNumber = %d",it->u8PresetNumber));
		ETG_TRACE_USR4(("vPrintMasterList() Band = %d",ETG_ENUM(midw_fi_tcl_e8_TunMst_RadioType, (tU8)it->e8RadioType.enType)));
		ETG_TRACE_USR4(("vPrintMasterList() m_u8IndividualTunerPresetID = %d",it->m_u8IndividualTunerPresetID));
		ETG_TRACE_USR4(("vPrintMasterList() u32Frequency = %d",it->u32Frequency));
		ETG_TRACE_USR4(("vPrintMasterList() u32SID = %d",it->u32SID));
		ETG_TRACE_USR4(("vPrintMasterList() sStationName = %s", it->sStationName.szGet(midw_fi_tclString::FI_EN_UTF8)));


	}
}


/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:      tunermaster_PMClient::vPersonalizationMasterListCreation
 *
 *DESCRIPTION:	 Function to create Initial Master list during startup , which will updated with preset information
 *
 *PARAMETER: 	 midw_fi_tcl_e8_List list Type
 *
 * The function is currently called during startup
 * A vector based on the lists that are currently configured during startup is created.
 * Number of elements are taken from KDS
 * Currently SXM is appended in the end available
 ******************************************************************-FUNCHEADER*/

tVoid tunermaster_PMClient::vPersonalizationMasterListCreation()
{
	if(NULL == m_poclConfigInterface)
	{
		ETG_TRACE_USR4(("vPersonalizationMasterListCreation() Configuration Of Master List Error"));
		return;
	}

	const tU8 numberofPresetListID =  sizeof(astTunermasterPresetListMap)/sizeof(stTunermasterPresetListMap) ;
	tU8 u8PresetNumberLast = 0;

	for (tU8 u8presetlistidIndex = 0; u8presetlistidIndex < numberofPresetListID; u8presetlistidIndex++)
	{
		if( (astTunermasterPresetListMap[u8presetlistidIndex].u32KDSPresetListMapping) & (m_poclConfigInterface->u32GetConfigData("PresetListMapping")))
		{
			ETG_TRACE_USR4(("vPersonalizationMasterListCreation() u32KDSPresetListMapping = %x",astTunermasterPresetListMap[u8presetlistidIndex].u32KDSPresetListMapping));

			TunerMasterPresetList oElement;

			switch (astTunermasterPresetListMap[u8presetlistidIndex].midw_fi_TunerMasterPresetListId)
			{
				case midw_fi_tcl_e8_List::FI_EN_BANK_AM_MW1:
				case midw_fi_tcl_e8_List::FI_EN_BANK_AM_MW2:
				case midw_fi_tcl_e8_List::FI_EN_BANK_AM_MW3:
					if(  (m_poclConfigInterface->u32GetConfigData("AvailableBands") &  0x06) && (m_poclConfigInterface->u32GetConfigData("CFGAM")))
					{
						u8PresetNumberLast = u8PresetNumberLast + m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankMW");
						for(tU8 u8Itr= (u8PresetNumberLast - m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankMW") ) ; u8Itr <u8PresetNumberLast ; u8Itr++)
						{
							oElement.e8RadioType.enType = midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_AM;
							oElement.m_e8ListType.enType = astTunermasterPresetListMap[u8presetlistidIndex].midw_fi_TunerMasterPresetListId;
							oElement.u8PresetNumber = u8Itr +1;
							oPresetMasterList.push_back(oElement);
						}
						astTunermasterPresetListMap[u8presetlistidIndex].u8LastPresetelementNoOfPresetList = u8PresetNumberLast;
					}
					break;
				case midw_fi_tcl_e8_List::FI_EN_BANK_AM_MWAST:
				case midw_fi_tcl_e8_List::FI_EN_BANK_AM_AST:
				{
					if(  (m_poclConfigInterface->u32GetConfigData("AvailableBands") &  0x06) && (m_poclConfigInterface->u32GetConfigData("CFGAM")))
					{
						tU8 u8Itr =0;
						if(m_poclConfigInterface->u32GetConfigData("UserAutostoreNoOfStations") == 0 )
						{
						    u8PresetNumberLast = u8PresetNumberLast + m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankMW");
						    u8Itr= u8PresetNumberLast - m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankMW") ;
						}
						else
						{
							u8PresetNumberLast = u8PresetNumberLast + m_poclConfigInterface->u32GetConfigData("UserAutostoreNoOfStations");
							u8Itr= u8PresetNumberLast - m_poclConfigInterface->u32GetConfigData("UserAutostoreNoOfStations ") ;
						}

						for( ; u8Itr <u8PresetNumberLast ; u8Itr++)
						{
							oElement.e8RadioType.enType = midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_AM;
							oElement.m_e8ListType.enType = astTunermasterPresetListMap[u8presetlistidIndex].midw_fi_TunerMasterPresetListId;
							oElement.u8PresetNumber = u8Itr +1;
							oPresetMasterList.push_back(oElement);
						}
						astTunermasterPresetListMap[u8presetlistidIndex].u8LastPresetelementNoOfPresetList = u8PresetNumberLast;
					}
					break;
				}
				case midw_fi_tcl_e8_List::FI_EN_BANK_AM_LW1:
				case midw_fi_tcl_e8_List::FI_EN_BANK_AM_LW2:
				case midw_fi_tcl_e8_List::FI_EN_BANK_AM_LW3:
					if(  (m_poclConfigInterface->u32GetConfigData("AvailableBands") &  0x06) && (m_poclConfigInterface->u32GetConfigData("CFGAM")))
					{
						u8PresetNumberLast = u8PresetNumberLast + m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankLW");
						for(tU8 u8Itr= (u8PresetNumberLast - m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankLW") ) ; u8Itr <u8PresetNumberLast ; u8Itr++)
						{
							oElement.e8RadioType.enType = midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_AM;
							oElement.m_e8ListType.enType = astTunermasterPresetListMap[u8presetlistidIndex].midw_fi_TunerMasterPresetListId;
							oElement.u8PresetNumber = u8Itr +1;
							oPresetMasterList.push_back(oElement);
						}
						astTunermasterPresetListMap[u8presetlistidIndex].u8LastPresetelementNoOfPresetList = u8PresetNumberLast;
					}
					break;
				case midw_fi_tcl_e8_List::FI_EN_BANK_AM_LWAST:
					if(  (m_poclConfigInterface->u32GetConfigData("AvailableBands") &  0x06) && (m_poclConfigInterface->u32GetConfigData("CFGAM")))
					{
						tU8 u8Itr =0;
						if(m_poclConfigInterface->u32GetConfigData("UserAutostoreNoOfStations") == 0 )
						{
						    u8PresetNumberLast = u8PresetNumberLast + m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankLW");
						    u8Itr= u8PresetNumberLast - m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankLW") ;
						}
						else
						{
							u8PresetNumberLast = u8PresetNumberLast + m_poclConfigInterface->u32GetConfigData("UserAutostoreNoOfStations");
							u8Itr= u8PresetNumberLast - m_poclConfigInterface->u32GetConfigData("UserAutostoreNoOfStations ") ;
						}

						for( ; u8Itr <u8PresetNumberLast ; u8Itr++)
						{
							oElement.e8RadioType.enType = midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_AM;
							oElement.m_e8ListType.enType = astTunermasterPresetListMap[u8presetlistidIndex].midw_fi_TunerMasterPresetListId;
							oElement.u8PresetNumber = u8Itr +1;
							oPresetMasterList.push_back(oElement);
						}
						astTunermasterPresetListMap[u8presetlistidIndex].u8LastPresetelementNoOfPresetList = u8PresetNumberLast;
					}
					break;
				case midw_fi_tcl_e8_List::FI_EN_BANK_FM1:
				case midw_fi_tcl_e8_List::FI_EN_BANK_FM2:
				case midw_fi_tcl_e8_List::FI_EN_BANK_FM3:
					u8PresetNumberLast = u8PresetNumberLast + m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankFM");
					for(tU8 u8Itr= (u8PresetNumberLast - m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankFM") ) ; u8Itr <u8PresetNumberLast ; u8Itr++)
					{
						oElement.e8RadioType.enType = midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_FM;
						oElement.m_e8ListType.enType = astTunermasterPresetListMap[u8presetlistidIndex].midw_fi_TunerMasterPresetListId;
						oElement.u8PresetNumber = u8Itr +1;
						oPresetMasterList.push_back(oElement);
					}
					astTunermasterPresetListMap[u8presetlistidIndex].u8LastPresetelementNoOfPresetList = u8PresetNumberLast;
					break;
				case midw_fi_tcl_e8_List::FI_EN_BANK_FMAST:
				{
					tU8 u8Itr1 =0;
					if(m_poclConfigInterface->u32GetConfigData("UserAutostoreNoOfStations") == 0 )
					{
					    u8PresetNumberLast = u8PresetNumberLast + m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankFM");
					    u8Itr1= u8PresetNumberLast - m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankFM") ;
					}
					else
					{
						u8PresetNumberLast = u8PresetNumberLast + m_poclConfigInterface->u32GetConfigData("UserAutostoreNoOfStations");
						u8Itr1= u8PresetNumberLast - m_poclConfigInterface->u32GetConfigData("UserAutostoreNoOfStations ") ;
					}

					for( ; u8Itr1 <u8PresetNumberLast ; u8Itr1++)
					{
						oElement.e8RadioType.enType = midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_FM;
						oElement.m_e8ListType.enType = astTunermasterPresetListMap[u8presetlistidIndex].midw_fi_TunerMasterPresetListId;
						oElement.u8PresetNumber = u8Itr1 +1;
						oPresetMasterList.push_back(oElement);
					}
					astTunermasterPresetListMap[u8presetlistidIndex].u8LastPresetelementNoOfPresetList = u8PresetNumberLast;
					break;
				}
				case midw_fi_tcl_e8_List::FI_EN_BANK_DAB1:
				case midw_fi_tcl_e8_List::FI_EN_BANK_DAB2:
				case midw_fi_tcl_e8_List::FI_EN_BANK_DAB3:
				case midw_fi_tcl_e8_List::FI_EN_BANK_DABAST:
					if(m_poclConfigInterface->u32GetConfigData("DABSupported"))
					{
						u8PresetNumberLast = u8PresetNumberLast + m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankDAB");
						for(tU8 u8Itr= (u8PresetNumberLast - m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankDAB")  ) ; u8Itr <u8PresetNumberLast ; u8Itr++)
						{
							oElement.e8RadioType.enType = midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_DAB;
							oElement.m_e8ListType.enType = astTunermasterPresetListMap[u8presetlistidIndex].midw_fi_TunerMasterPresetListId;
							oElement.u8PresetNumber = u8Itr +1;
							oPresetMasterList.push_back(oElement);
						}
						astTunermasterPresetListMap[u8presetlistidIndex].u8LastPresetelementNoOfPresetList = u8PresetNumberLast;
					}
					break;

				case midw_fi_tcl_e8_List::FI_EN_BANK_MIX1:
				case midw_fi_tcl_e8_List::FI_EN_BANK_MIX2:
				case midw_fi_tcl_e8_List::FI_EN_BANK_MIX3:
				case midw_fi_tcl_e8_List::FI_EN_BANK_MIX_AST:
					u8PresetNumberLast = u8PresetNumberLast + m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankForMixedAllBands");
					for(tU8 u8Itr= (u8PresetNumberLast - m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankForMixedAllBands")  ) ; u8Itr <u8PresetNumberLast ; u8Itr++)
					{
						oElement.e8RadioType.enType = midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_NONE;
						oElement.m_e8ListType.enType = astTunermasterPresetListMap[u8presetlistidIndex].midw_fi_TunerMasterPresetListId;
						oElement.u8PresetNumber = u8Itr +1;
						oPresetMasterList.push_back(oElement);
					}
					astTunermasterPresetListMap[u8presetlistidIndex].u8LastPresetelementNoOfPresetList = u8PresetNumberLast;
					break;
				case midw_fi_tcl_e8_List::FI_EN_BANK_DRM1:
				case midw_fi_tcl_e8_List::FI_EN_BANK_DRM_AST:
					u8PresetNumberLast = u8PresetNumberLast + m_poclConfigInterface->u32GetConfigData("NoOfPresetsPerBankDRM");
					for(tU8 u8Itr= (u8PresetNumberLast - m_poclConfigInterface->u32GetConfigData("NoOfPresetsPerBankDRM")  ) ; u8Itr <u8PresetNumberLast ; u8Itr++)
					{
							oElement.m_e8ListType.enType = astTunermasterPresetListMap[u8presetlistidIndex].midw_fi_TunerMasterPresetListId;
							oElement.u8PresetNumber = u8Itr +1;
							oElement.e8RadioType.enType = midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_DRM;
							oPresetMasterList.push_back(oElement);
					}
					astTunermasterPresetListMap[u8presetlistidIndex].u8LastPresetelementNoOfPresetList = u8PresetNumberLast;
					break;
				default:
					break;
			}
			ETG_TRACE_USR4(("vPersonalizationMasterListCreation() u8PresetNumberFirst = %d",u8PresetNumberLast));
		}
	}

	m_u8MasterListLastPresetID = u8PresetNumberLast;
	if(m_poclConfigInterface->u32GetConfigData("SXMSupported"))
	{
		for(tU8 u8Itr= u8PresetNumberLast ; u8Itr < (u8PresetNumberLast + (m_poclConfigInterface->u32GetConfigData("NumberOfPresetListSXM")*m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankSXM"))) ; u8Itr++)
		{
			TunerMasterPresetList oElement;
			oElement.e8RadioType.enType = midw_fi_tcl_e8_TunMst_RadioType::FI_EN_RADIOTYPE_SXM;
			oElement.u8PresetNumber= u8Itr+1;
			oElement.m_u8IndividualTunerPresetID = u8Itr+1- (m_poclConfigInterface->u32GetConfigData("NumberOfPresetListSXM")*m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankSXM"));
			oElement.u32SID = 0;
			oPresetMasterList.push_back(oElement);
		}
		m_u8MasterListLastPresetID = u8PresetNumberLast + (m_poclConfigInterface->u32GetConfigData("NumberOfPresetListSXM")*m_poclConfigInterface->u32GetConfigData("NumberOfPresetsPerBankSXM")) ;
	}
	vPrintMasterList();
}

/******************************************************************+FUNCHEADER**
 *
 *FUNCTION:      tunermaster_PMClient::vGetEndPresetIDForListID
 *
 *DESCRIPTION:	 Internal Function to get Preset Range for a Band
 *
 *PARAMETER: 	 midw_fi_tcl_e8_List list Type
 *
 *
 *
 ******************************************************************-FUNCHEADER*/
tU8 tunermaster_PMClient::vGetEndPresetIDForListID(midw_fi_tcl_e8_List ListID)
{
	const tU8 numberofPresetListID = sizeof(astTunermasterPresetListMap) / sizeof(stTunermasterPresetListMap);

	for (tU8 u8presetlistidIndex = 0; u8presetlistidIndex < numberofPresetListID; u8presetlistidIndex++)
	{
		if (( astTunermasterPresetListMap[u8presetlistidIndex].midw_fi_TunerMasterPresetListId == ListID.enType ) && ( 0 != astTunermasterPresetListMap[u8presetlistidIndex].u8LastPresetelementNoOfPresetList ))
		{
			return( astTunermasterPresetListMap[u8presetlistidIndex].u8LastPresetelementNoOfPresetList);

		}
	}
	return 0;

}
#endif

tBool tunermaster_PMClient::bGetKeepOtherPreset()
{
	ETG_TRACE_USR4(("vPersonalizationMasterListCreation() m_bDeleteOthersOption = %d",m_bDeleteOthersOption));
	return m_bDeleteOthersOption;
}
