 /************************************************************************
* FILE:           tunermaster_defines.h
* PROJECT:        G3g
* SW-COMPONENT:   fc_tunermaster.
*----------------------------------------------------------------------
*
* DESCRIPTION:    Decisions, algorithim to select Background tuner are implemented here.
*
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:

* Date           | Author                       		| Modification
* 04/10/2010	 | CM-AI/PJ-VW36 ( RBEI )Pallavi    	| initial version
* 25.04.13  	 | NGP1KOR   						    | First version of the G3g after porting from NISSAN LCN2Kai
				
				
			
*************************************************************************/


#ifndef TUNERMASTER_DEFINES_H
#define TUNERMASTER_DEFINES_H



/*--------------------------------------------------------------------------*/
/* The below defines are only for the test purposes, they must be commented */
/*--------------------------------------------------------------------------*/

//#define TU_TEST_AUDIO_COMPONENT
//#define FORD_TPEX_ENVIRONMENT

/*MH no need for this interface here 
#define NUCLEUS_DRIVER_S_IMPORT_INTERFACE_IPN_DRV
#include "nucleus_driver_pif.h"
 */
/*-----------------------------------*/
/* posible events for waiting thread */
/*-----------------------------------*/
#define EVENT_SPI_RX_READY    0x0001
#define EVENT_TERMINATE       0x0002
#define EVENT_FROM_MAINTHREAD_UPDATE_MANTUN   0x0004

/*------------------------------------*/
/* tuner waiting thread configuration */
/*------------------------------------*/
#define TUNMASTER_WAITINGTHREAD_DEFAULT_PRIO                133
#define TUNMASTER_WAITINGTHREAD_DEFAULT_STACKSIZE           4096
#define EVENT_TUNERMASTER_SYSTEM_EVENT_HANDLE               "TunerMasterSrv"



/*--------------------------------------------------*/
/*    Info About Tuner Master component status      */ 
/****************************************************/ 
#define TUNMASTER_COMPONENT_STATUS_ACTIVE         0x01
#define TUNMASTER_COMPONENT_STATUS_INACTIVE       0x02

/*----------------------------------------*/
/* Tuner thread configuration in registry */
/*----------------------------------------*/

#define TUNMASTER_REGPATH_THREAD                "APP_THREAD"
#define TUNMASTER_REGVALUE_THREAD_PRIO_NAME     "TUNMSTR_TMC_TREAD_PRIO"
#define TUNMASTER_REGVALUE_STACK_SIZE_NAME      "TUNMSTR_TMC_STACK"

#define TUNMASTER_FEATURE_AF_MODE_MAN                    0x00000001
#define TUNMASTER_FEATURE_AF_MODE_MASK_ON               0x00000001

#define TUNMASTER_FEATURE_AF_MODE_MASK_OFF           0x00000000

/*------------------------------------*/
/* Fc_TunerMaster data stored in flash   */
/*------------------------------------*/
// File to be created in FFS
#define TUNMASTER_TMC_FFS_FILE_NAME   "/dev/ffs/FC_TunerMaster_LMM.DAT" 
#define TUNMASTER_TMC_LEARN_MEM_FFS_FILE_NAME   "/dev/ffs/FC_TunerMaster_Learn_Mem.DAT" 




#define FC_TUNERMASTER_SW_VERSION     1 


/*-----------------------------------------------------*/



/*------------------------------------*/
/* defines used in class tunmstr_MsgToHMI */
/*------------------------------------*/
#define TUNMASTER_HMI_FUNID_CARRAY_SIZE           40  // To be verified
#define TUNMASTER_HMI_FUNID_NOTARRAY_SIZE         60  // To be verified

#define TUNMASTER_HMI_NOTTABLE_SEM_NAME           "TUNER_HMI_NOTTABLESEM"


/*-----------------------------*/
/* Different tuner states      */
/*-----------------------------*/
#define TUNMASTER_STATE_NOT_READY                 0x01  /* Tuner Component not ready to take any request */
#define TUNMASTER_STATE_READY                     0x02  /* Tuner Component ready to take any request     */
#define TUNMASTER_STATE_BLOCKED                   0x03  /* Tuner Component current busy, cannot take new request */

/*--------------*/
/* Tuner trace  */
/*--------------*/

#define TUNMASTER_TRACE_NEW_RDBID_DATA             0x02
#define TUNMASTER_TRACE_WRITE_TO_FLASH             0x03
#define TUNMASTER_TRACE_READ_FROM_FLASH            0x04
#define TUNMASTER_TRACE_GET_CURRENT_RDBID_DATA     0x05
#define TUNMASTER_TRACE_SET_TIME_GRP_8A_MSG_SEND   0x06
#define TUNMASTER_TRACE_SET_TIME_SEL_BG_TUN        0x07

/*-----------------------------------*/
/* PS Name maximum size of the array */
/*-----------------------------------*/

#define TUNMASTER_PS_NAME_MAX_SIZE       8

/*-----------------------------------*/
/* This is added for the Packed info */
/* for Config list element           */
/*-----------------------------------*/
#define TUNMASTER_CONFIG_PACKINFO_TP                  0x01
#define TUNMASTER_CONFIG_PACKINFO_TP_SELF             0x02
#define TUNMASTER_CONFIG_PACKINFO_PTY_DYNAMIC         0x04
#define TUNMASTER_CONFIG_PACKINFO_PS_DYNAMIC          0x08
#define TUNMASTER_CONFIG_PACKINFO_TMC_RESERVED        0x10
#define TUNMASTER_CONFIG_PACKINFO_TMC_YES             0x20
#define TUNMASTER_CONFIG_PACKINFO_TMC_NO              0x00

/* This is added to check for the bits 4 & 5 for TMC_NO */

#define TUNMASTER_CONFIG_MASK_FOR_TMC_NO              0x30

// Defines needed for tunmstr_MsgFromHMI - Manual ticks.

#define TUNMASTER_MSGFROMHMI_NOOF_TICKS_1             0x01

/*----------------------*/
/* Static list ID.  */
/*----------------------*/
#define TUNMASTER_INVALID                      0xff
#define TUNMASTER_LIST_TYPE_CONFIG               0x01
/*-----------------------*/
/* Operation             */
/*-----------------------*/
#define OPERATION_DISABLE                        0
#define TUNMASTER_OPERATION_TP                         16
#define TUNMASTER_OPERATION_BG                         32


//SPM System States defines
#ifdef VARIANT_S_FTR_ENABLE_NEW_SPM_CORE_FI
	
	#define SPM_SYSTEM_STATE_STANDBY                    spm_fi_tcl_SPM_e32_TUNER_STATE::FI_EN_SPM_U32_TUNER_LANDSCAPE_SCAN
	#define SPM_SYSTEM_STATE_OFF                        spm_fi_tcl_SPM_e32_TUNER_STATE::FI_EN_SPM_U32_TUNER_OFF
	#define SPM_SYSTEM_STATE_ON                         spm_fi_tcl_SPM_e32_TUNER_STATE::FI_EN_SPM_U32_TUNER_ON
	
	#define CVM_CRITICAL_LOW_VOLTAGE_START				spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_START
	#define CVM_CRITICAL_LOW_VOLTAGE_END				spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_END
	#define CVM_LOW_VOLTAGE_START						spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_LOW_VOLTAGE_START
	#define CVM_LOW_VOLTAGE_END							spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_LOW_VOLTAGE_END
	#define CVM_HIGH_VOLTAGE_START						spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_START
	#define CVM_HIGH_VOLTAGE_END						spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_END
	#define CVM_CRITICAL_HIGH_VOLTAGE_START				spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_START
	#define CVM_CRITICAL_HIGH_VOLTAGE_END				spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_END
	#define CVM_NO_EVENT								spm_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_NO_EVENT
#else

	#define SPM_SYSTEM_STATE_STANDBY                    cfc_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_STANDBY
	#define SPM_SYSTEM_STATE_OFF                        cfc_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_OFF
	#define SPM_SYSTEM_STATE_ON                         cfc_fi_tcl_SPM_e32_SYSTEM_STATES::FI_EN_SPM_SYSTEM_ON
	
	#define CVM_CRITICAL_LOW_VOLTAGE_START				cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_START
	#define CVM_CRITICAL_LOW_VOLTAGE_END				cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_LOW_VOLTAGE_END
	#define CVM_LOW_VOLTAGE_START						cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_LOW_VOLTAGE_START
	#define CVM_LOW_VOLTAGE_END							cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_LOW_VOLTAGE_END
	#define CVM_HIGH_VOLTAGE_START						cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_START
	#define CVM_HIGH_VOLTAGE_END						cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_HIGH_VOLTAGE_END
	#define CVM_CRITICAL_HIGH_VOLTAGE_START				cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_START
	#define CVM_CRITICAL_HIGH_VOLTAGE_END				cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_CRITICAL_HIGH_VOLTAGE_END
	#define CVM_NO_EVENT								cfc_fi_tcl_SPM_e32_CVM_EVENT::FI_EN_SPM_U32_CVM_NO_EVENT
#endif



#define TUNMSTR_FOREGROUND                      00
#define TUNMSTR_BACKGROUND                      01

typedef enum
{
	TUNMSTR_ANTDIAG_ANTENNA_LEVEL_OPEN_0,
	TUNMSTR_ANTDIAG_ANTENNA_LEVEL_OPEN_1,
	TUNMSTR_ANTDIAG_ANTENNA_LEVEL_SHORT_0,
	TUNMSTR_ANTDIAG_ANTENNA_LEVEL_SHORT_1,
	TUNMSTR_ANTDIAG_ANTENNA_LEVEL_CLOSE_0,
	TUNMSTR_ANTDIAG_ANTENNA_LEVEL_CLOSE_1
}TUNMSTR_ANTDIAG_ANTENNA_LEVEL;
// Trace commands
#define TUNMSTR_MSG_TO_HMI			0x00
#define TUNMSTR_MSG_FROM_TUNER  	0x01
#define TUNMSTR_MSG_FROM_DAB		0x02
#define TUNMSTR_MSG_FROM_DIAGLOG 	0x03
#define TUNMSTR_MSG_FROM_SPM     	0x04
#define TUNMSTR_MSG_FROM_DIAGLIB	0x05
#define TUNMSTR_S_PRESET_HANDLING	0x06
#define TUNMSTR_S_AUTOSTORE			0x07
#define TUNMSTR_S_ACTIVATEANNO			0x08
#define	TUNMSTR_I2C						0x09
#define	TUNMSTR_vStartAntennaDiag		0x0a
#define	TUNMSTR_vStopAntennaDiag		0x0b
#define TUNMSTR_ReadAntennaStatus		0x0c
#define TUNMSTR_IgnitionState			   0x12
#define TUNMSTR_BatteryVg				   0x13
#define TUNMSTR_FM1ConsiderBatVg		   0x14
#define TUNMSTR_FM2ConsiderBatVg		   0x15
#define TUNMSTR_DAB1ConsiderBatVg		   0x16
#define TUNMSTR_FM1ConsiderIgn			   0x17
#define TUNMSTR_FM2ConsiderIgn			   0x18
#define TUNMSTR_DAB1ConsiderIgn            0x19
#define TUNMSTR_SystemSetTypeCoding	   0x1a
#define TUNMSTR_S_MTC_SETMODE			   0x1b
#define DRMDUMMYSOURCE_ENABLE			   0x1c
#define DRMDUMMYSOURCE_DISABLE			   0x1d
#define TUNMSTR_S_STATION_SELECTION			0x1e
#define TUNMSTR_SERVICE_STATUS				0x1f
#define FID_TUNMSTR_S_SOURCE_SETUP_OPTION   0x20
#define TUNMSTR_SetDTVAntennaRegister   	0x22
#define TUNMSTR_CCA_TMC_SERVICE_ID 0x2E
#define TUNMSTR_S_RADIOPROFILE_SETTING 0x31

#define TUNMSTR_INITIAL_AST_LISTID			0x0011
#define TUNMSTR_INITIAL_AST_MIB_FMAM        0x00000011
#define TUNMSTR_INITIAL_AST_MIB_FMAMDAB  0x00008011
#define TUNMSTR_INITIAL_AST_MIB_FM 				0x00000001

#define TUNMSTR_DEFINE_ONE   0x01
#define TUNMSTR_DEFINE_TWO  0x02
#define TUNMSTR_DEFINE_THREE   0x03

#define TUNMSTR_ANNO_INVALID    0xFFFF

#define TUNMSTR_ANNO_PRIORITY   0x1F

#define TUNMSTR_DABAST_PRESET1  0x07;

#define TUNMSTR_PROFILE_USER_ACTION_SUCESS 1
#define TUNMSTR_PROFILE_USER_ACTION_FAIL 4
#endif /* TUNER_DEFINES_H */


