/************************************************************************
* FILE:           tunermaster_cfcVehicleClientHandler.h
* PROJECT:        G3g
* SW-COMPONENT:   FC_TunerMaster.
*----------------------------------------------------------------------
*
* DESCRIPTION:    Cleint Header file for Vehicle Data Service 
*
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date			 | Author										| Modification
 * 13-12-2013	 | RBEI/ECV3 Priya Prabhuswamy(rrb1kor)			| initial version

*************************************************************************/

#ifndef tunermaster_cfcVehicleClientHandler_H
#define tunermaster_cfcVehicleClientHandler_H

#ifdef VARIANT_S_FTR_ENABLE_AMT_MOCK
#include "amt_mock/amt_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_AHL_MOCK
#include "ahl_mock/ahl_if.h"
#else
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#endif

#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_STDVISITORS // not sure
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_ERRORCODES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_TYPES
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_FUNCTIONIDS
#define MIDW_FI_S_IMPORT_INTERFACE_MIDW_TUNERMASTERFI_SERVICEINFO

#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_fi_if.h" 


#define VEHICLE_CSM_C_SIGNALSTATE_VALID				0x01
#define VEHICLE_CSM_C_VIEWOPTION_STATE_NORMAL		0x00
#define VEHICLE_CSM_C_VIEWOPTION_REASON_NORMAL		0x00

#ifdef VARIANT_S_FTR_ENABLE_TUNERMASTER_MOCK
#include "../utest/Mocks/tunermaster_main.h"
#else
#include "tunermaster_main.h"
#endif

class tunmaster_tclApp;
class tunermaster_cfcVehicleClientHandler : public ahl_tclBaseWork
{
private:	
		tunmaster_tclApp* poMain;
		tU16 m_u16RegisterId;
		tBool m_blIgnitionStatus;
		tF32 m_f32BatteryVg;
public:
		tVoid vRegisterForVehicleDataService();
		tVoid vOnAsyncRegisterConf(tU16 u16RegisterId,tU16 u16ServerAppId,\
		tU16 u16ServiceId,tU16 u16SourceSubID);
		static OSAL_tSemHandle			m_hNotTable_SemHandle;
		tunermaster_cfcVehicleClientHandler( tunmaster_tclApp* poMain );
		tunermaster_cfcVehicleClientHandler();
		//tunermaster_cfcVehicleClientHandler(const tunermaster_cfcVehicleClientHandler& c);
		virtual ~tunermaster_cfcVehicleClientHandler( );
		tVoid vHandleIgnitionStatus(amt_tclServiceData* poMessage);
		virtual tVoid vHandleBatteryVgStatus(amt_tclServiceData* poMessage);
		tVoid vOnServiceState (stOnServiceStateParm OnServiceStateParm);
		tVoid vRegisterForProperty(tU16 u16FID);
		virtual tVoid vGetDataFromAmt(amt_tclServiceData* poFIMsg, fi_tclTypeBase& oFIData )const;
		tVoid vOnNewAppState(tU32 u32OldAppState,tU32 u32NewAppState);
		tVoid vHandleTTFiS_CMD(const tU8* u8DataSpecial);
		tBool blGetIgnitionstate()const;
		tF32 f32GetBatteryVg()const;
		DECLARE_MSG_MAP( tunermaster_cfcVehicleClientHandler );
};
#endif