/*
 * tunermaster_SXMchannelartClient.h
 *
 *  Created on: Dec 6, 2018
 *      Author: auj1kor
 */

#ifndef FC_TUNERMASTER_HEADER_TUNERMASTER_SXMCHANNELARTCLIENT_H_
#define FC_TUNERMASTER_HEADER_TUNERMASTER_SXMCHANNELARTCLIENT_H_

#ifdef VARIANT_S_FTR_ENABLE_AIL_MOCK
#include "amt_mock/amt_if.h"
#else
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"         // use AIL template with MessageMaps
#endif

#ifdef VARIANT_S_FTR_ENABLE_AHL_MOCK
#include "ahl_mock/ahl_if.h"
#else
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"         // use Application Help Library
#endif

#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"


#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_CHANNELARTFI_TYPES
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_CHANNELARTFI_FUNCTIONIDS
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_CHANNELARTFI_SERVICEINFO
#define MIDW_EXT_FI_S_IMPORT_INTERFACE_MIDW_EXT_SXM_CHANNELARTFI_ERRORCODES
#define FI_S_IMPORT_INTERFACE_FI_MESSAGE
#include "midw_ext_fi_if.h"

#include "datatypes/tVector.h"

#ifdef VARIANT_S_FTR_ENABLE_SXMCLIENT
class tunmaster_tclApp;
class tunmstr_Preset_Handler;

class tunermaster_SXMchannelartClient : public ahl_tclBaseWork
{

private:
	tunmaster_tclApp* poGWMain;
	tunmstr_Preset_Handler* m_potunmstr_Preset_Handler;
	tU16 m_u16SrvRegID;
	tBool m_bServiceState;

public:
	tunermaster_SXMchannelartClient(tunmaster_tclApp* poMain);
	virtual ~tunermaster_SXMchannelartClient();

	tVoid vSet_Preset_Handler_Ptr(tunmstr_Preset_Handler* po_tunmstr_PresetHandler);

	tBool bRegisterForFID(tU16 u16FID);
	tVoid vOnAsyncRegisterConf(tU16 u16RegisterId,tU16 u16ServerAppId, tU16 u16ServiceId, tU16 u16SourceSubID);
	tVoid vUnregisterForService();
	tVoid vOnServiceState(tU16 u16ServiceId, tU16 u16RegisterId, tU8 u8ServiceState, tU16 u16SubId);
	tVoid vOnNewAppState(tU32 u32OldAppState, tU32 u32AppState);
	virtual tVoid vRegisterForService();
	virtual tVoid vSendMessage(tU16 u16DestAppID, const fi_tclTypeBase& oOutData, tU16 u16Fid, tU8 u8OpCode, tU16 u16CmdCtr);
	virtual tVoid vGetDataFromAmt(amt_tclServiceData* poFIMsg, fi_tclTypeBase& oFIData )const;

	tVoid vHandleChannelArtList(amt_tclServiceData* poMessage);
	tBool bGetServiceStatus();

	DECLARE_MSG_MAP( tunermaster_SXMchannelartClient )

};
#endif


#endif /* FC_TUNERMASTER_HEADER_TUNERMASTER_SXMCHANNELARTCLIENT_H_ */
