/************************************************************************
* FILE:           tunermaster_SPMClient.h
* PROJECT:        G3g
* SW-COMPONENT:   TunerMaster
*----------------------------------------------------------------------
*
* DESCRIPTION:    FC_TunerMaster registers as client to SPM 
*
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:

* Date           | Author                       		| Modification
* 13.09.10  	 | RBEI/Pallavi HN    				    | initial version
* 25.04.13  	 | NGP1KOR  						    | First version of the G3g after porting from NISSAN LCN2Kai
				
												
*************************************************************************/

#ifndef TUNERMASTER_SPM_CLIENT_H
#define TUNERMASTER_SPM_CLIENT_H

#ifdef VARIANT_S_FTR_ENABLE_AMT_MOCK
#include "amt_mock/amt_if.h"
#else
// use AIL template with MessageMaps
#define AIL_S_IMPORT_INTERFACE_GENERIC
#include "ail_if.h"
#endif

#ifdef VARIANT_S_FTR_ENABLE_AHL_MOCK
#include "ahl_mock/ahl_if.h"
#else
// use Application Help Library
#define AHL_S_IMPORT_INTERFACE_GENERIC
#include "ahl_if.h"
#endif

// Use OSAL defines
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
#ifndef TUNMASTER_CLASS_FORWARD_DECL_H
#include "tunermaster_Class_ForwardDecl.h"
#endif


// Copro reset/ normal indication
#define TUNMSTR_CRITICAL_STATUS_COPRO_BIT               0x01

// Component stable/unstable indication
#define TUNMSTR_CRITICAL_STATUS_COMP_STABLE_BIT         0x02

// Copro reset happened during undervoltage
#define TUNMSTR_CRITICAL_STATUS_COPRO_RESET_LOWVOLT_BIT 0x04


// Copro has gone to standby mode
#define TUNMSTR_CRITICAL_STATUS_COPRO_STANDBY_BIT       0x08


// Undervoltage indication
#define TUNMSTR_CRITICAL_STATUS_LOWVOLTAGE_BIT          0x10



// forward declarations


/*------------------------------------*/
/* class tunmaster_tclSPMClient definition  */
/*------------------------------------*/
class tunmaster_tclSPMClient : public ahl_tclBaseWork
{
private:

	// Pointer to class tunmaster_tclApp.
	tunmaster_tclApp*   poGWMain;
    tunmaster_Config*       m_ptunmaster_Config;
	tunmstr_SrcChgManager* m_potunmstr_SrcChgManager;
	tunmstr_TunerClientHandler* m_potunmstr_TunClnt_Handlr;
	tunmstr_antdiag_Manager*    m_potunmstr_antdiag_Manager;
	tunmstr_MsgToHMI*				m_potunmstr_MsgToHMI;
	tunmstr_DiagLogClientHandler* m_potunmstr__DiagLog;
  
   // Store the RegID of the registered service   
   tU16  m_u16SrvRegID; 

   // To know whether the registeration was done
   tBool m_fFidReg; 

   tBool m_fFidSysStateReg;

   tBool m_fFidCVMReg;
   
   tU32 m_u32CVMEvent;


   // Store the voltage state
   tU32 m_u32VoltageEvent;

   // Critical status bits
   tU8 m_u8CriticalStatus;

   // High Voltage on startup?
   tBool m_fIsHighVoltageOnStartup;
   tU32 m_u32SPMAppstate;

 
   /*---------------------------------------------------------------------*/
   
   // Function to register for required service
   virtual tBool fRegisterForService();
   
   /*---------------------------------------------------------------------*/
   
   // Function to unregister for required service
   tBool fUnregisterForService();
   
   /*---------------------------------------------------------------------*/
   
   // Function to register for FID (upreg)
   tBool fRegisterForFID(tU16 u16FID);
   
   /*---------------------------------------------------------------------*/

   // Function to unregister for FID (relupreg)
   tBool fUnregisterForFID(tU16 u16FID);

   /*---------------------------------------------------------------------*/   


protected:
  /*---------------------------------------------------------------------*/
     // Function to handle unknown messages
   virtual tVoid vOnUnknownMessage
                  (
                  amt_tclBaseMessage* poMessage
                  );

  /*---------------------------------------------------------------------*/
      
public:

//Functions to set the pointers to other classes

  tVoid vSet_tunmaster_Config_Ptr( tunmaster_Config* ptunmaster_Config );
  tVoid vSet_tunmaster_SrcChgManager_Ptr( tunmstr_SrcChgManager* ptunmaster_SrcChgMan );
  tVoid vSet_tunmaster_ClientHandler_Ptr( tunmstr_TunerClientHandler* ptunmaster_ClientHandler );
  tVoid vSet_tunmstr_DiagLogClientHandler_Ptr(tunmstr_DiagLogClientHandler* potunmstr_DiagLogClientHandler);
  //Set Pointer to tunmstr_antdiag_Manager
  tVoid vSet_tunmstr_antdiag_Manager( tunmstr_antdiag_Manager* potunmstr_antdiag_Manager );
  //Update Pointer to tunmstr_MsgToHMI
  tVoid vSet_tunmstr_MsgToHMI_Ptr(tunmstr_MsgToHMI* potunmstr_MsgToHMI);
  tVoid vHandleTTFiS_CMD(const tU8* u8DataSpecial);
  tVoid vSendMessage( tU16             u16DestAppID,
			const fi_tclTypeBase&  oOutData,
			tU16             u16Fid,
			tU8              u8OpCode,
			tU16             u16CmdCtr,
			tU16             u16RegId);


    // constructor
    tunmaster_tclSPMClient (tunmaster_tclApp* poMain);
	tunmaster_tclSPMClient();//default constructor is added to remove lint warning

   /*---------------------------------------------------------------------*/

   // destructor
   virtual ~tunmaster_tclSPMClient();
      
   /*---------------------------------------------------------------------*/

   // Function to handle new app state
   tVoid vOnNewAppState
      (
      tU32 u32OldAppState, 
      tU32 u32AppState
      );
   
   /*---------------------------------------------------------------------*/
   
   /*---------------------------------------------------------------------*/
      
   // Function to handle CVM status
   tVoid  vHandleCVM
      (
       amt_tclServiceData* poMessage
      );

   //Function to handle the System state property from SPM
   tVoid vHandleSysState( amt_tclServiceData* poMessage )const;
   /*---------------------------------------------------------------------*/
   
   // Function to handle the service state changes
   tVoid vOnServiceState
      ( 
      tU16 u16ServiceId,
      tU16 u16ServerId,
      tU16 u16RegisterId, 
      tU8  u8ServiceState,
      tU16 u16SubId
      );

   /*---------------------------------------------------------------------*/      

   // Set the voltage after getting the voltage state from main application
   tVoid vSetVoltageState (tU32 u32Event);

   /*---------------------------------------------------------------------*/   

   // Set the comp stability after comp becomes stable
   tVoid vSetCompStabilityState (tBool fStatus)const;

   /*---------------------------------------------------------------------*/   

   /*---------------------------------------------------------------------*/
   
   // Get the current copro state
   tU32 u32GetActualCoproState ()const;

   /*---------------------------------------------------------------------*/

   // Get the current voltage state
   tU32 u32GetVoltageState ()const;
   tU32 u32GetCVMEvent()const ;
   /**Vnd4kor: Solving prio2 lint warning*/
   tU32 u32GetSPMAppstate()const;

   /*---------------------------------------------------------------------*/
  

   DECLARE_MSG_MAP(tunmaster_tclSPMClient)
};

#endif //TUNERMASTER_SPM_CLIENT_H
