/************************************************************************
* FILE:           tunmaster_Config.h
* PROJECT:        G3g
* SW-COMPONENT:   Tuner
*----------------------------------------------------------------------
*
* DESCRIPTION:    Tuner component, configuration.
*
*----------------------------------------------------------------------
* COPYRIGHT:   (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:

* Date           | Author                       | Modification
* 20.01.05 		 | CM-DI/ESA2 ( RBIN ) Dinesh   | Initial version.
* 25.04.13 		 | NGP1KOR    					| First version of the G3g after porting from NISSAN LCN2Kai 
				
			
*************************************************************************/

#ifndef tunmaster_Config_H
#define tunmaster_Config_H

/*--------------------------------*/
/* class tunmaster_Config definition  */
/*--------------------------------*/

#define DIAGNOSTICS_KDS_ENTRY_IMPORT_INTERFACE
#include "fc_diagnosis_if.h"
#ifndef TUNMASTER_CLASS_FORWARD_DECL_H
#include "tunermaster_Class_ForwardDecl.h"
#endif
#include "fc_tunermaster_featureControl.h"
#include <vector>
#include <map>
#include <list>

using namespace std;

#ifdef VARIANT_S_FTR_ENABLE_ADR_API_3_20
#define VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
#include "announcements/clAnnouncementSettings.h"
#include "announcements/clAnnouncementControl.h"
#endif
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
#include "sessionManagement/clArlSourceImpl.h"
using namespace tuner::sessionManagement::audio;
#endif

#include "kdsconfig/clTunerConfigInterface.h"

#define TUNMSTR_CONFIG_NEW_KDS_FM_AM_TUNER_PARAMETER_LENGTH                                                                      288
#define TUNMSTR_CONFIG_NEW_KDS_FM_AM_TUNER_PARAMETER_START_POINT_1																0x0410
#define TUNMSTR_CONFIG_NEW_KDS_FM_AM_TUNER_PARAMETER_READ_LEN_1																     230
#define TUNMSTR_CONFIG_NEW_KDS_FM_AM_TUNER_PARAMETER_START_POINT_2																0x0411
#define TUNMSTR_CONFIG_NEW_KDS_FM_AM_TUNER_PARAMETER_READ_LEN_2																      57


#define TUNMSTR_CONFIG_NEW_KDS_GENERIC_TUNER_PARAMETER_LENGTH                                                                      417
#define TUNMSTR_CONFIG_NEW_KDS_GENERIC_NO_OF_PRESETS																				61
#define TUNMSTR_CONFIG_NEW_KDS_GENERIC_TUNER_PARAMETER_START_POINT_1																0x0420
#define TUNMSTR_CONFIG_NEW_KDS_GENERIC_TUNER_PARAMETER_READ_LEN_1																	230
#define TUNMSTR_CONFIG_NEW_KDS_GENERIC_TUNER_PARAMETER_START_POINT_2																0x0421
#define TUNMSTR_CONFIG_NEW_KDS_GENERIC_TUNER_PARAMETER_READ_LEN_2																	186

#define TUNMSTR_CONFIG_NEW_KDS_CM_VARIANT_CODING_LENGTH                                                     32
#define TUNMSTR_CONFIG_NEW_KDS_CM_VARIANT_CODING                                                                     0x0dF4
#define EXTRACT_DRM_BIT_HW_CONFIGURATION                                                                                        0x04

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
#define TUNMSTR_CONFIG_NEW_KDS_EOL_PARAMETER_LENGTH					 4
#define TUNMSTR_CONFIG_NEW_KDS_EOL_CONFIG_RADIONUM_PARAMETER_LENGTH  2
#define TUNMSTR_CONFIG_NEW_KDS_EOL_PARAMETER_START_POINT			0xA127
#endif

#define TUNMSTR_CONFIG_GET_U32(pu8) ((tU32)(((tU32)((pu8)[0])<<24) + ((tU32)((pu8)[1])<<16) + ((tU32)((pu8)[2])<<8) + (pu8)[3]))

#define PM_USERS 6 /*Guest + 5 users*/
struct tunmstr_trKds
{
	virtual tVoid vSetToDefaultValues( tVoid) = 0;
	virtual tVoid vParse( tPU8 pu8KdsBuffer, tU32 u32Length) = 0;
	virtual tVoid vTrace( tVoid) = 0;
};


/*============================================================================
 * Indices for  KDS byte stream 'FM/AM Tuner Parameter Set'
 *--------------------------------------------------------------------------*/
typedef enum
{
  enKdsFmAmTunerParameter_idx_LowFM                      =  12, enKdsFmAmTunerParameter_len_LowFM                      =   4,
  enKdsFmAmTunerParameter_idx_HighFM                     =  16, enKdsFmAmTunerParameter_len_HighFM                     =   4,
  enKdsFmAmTunerParameter_idx_LowMW                      =  22, enKdsFmAmTunerParameter_len_LowMW                      =   4,
  enKdsFmAmTunerParameter_idx_HighMW                     =  26, enKdsFmAmTunerParameter_len_HighMW                     =   4,
  enKdsFmAmTunerParameter_idx_LowLW                      =  32, enKdsFmAmTunerParameter_len_LowLW                      =   4,
  enKdsFmAmTunerParameter_idx_HighLW                     =  36, enKdsFmAmTunerParameter_len_HighLW                     =   4,
  enKdsFmAmTunerParameter_idx_Ava_Band                   = 153, enKdsFmAmTunerParameter_len_Ava_Band                   =   4

} tenKdsFmAmTunerParameter;                                                                                         /* ------- */

struct tunmstr_trKdsFmAmTunerParameter : public tunmstr_trKds
{
  /** FM */
  tU32  u32LowFM; /**--------------------------------------  12 - 15 byte */
  tU32  u32HighFM;/**--------------------------------------  16 - 19 byte */
  /** LW */
  tU32  u32LowLW;/**---------------------------------------  32 - 35 byte */
  tU32  u32HighLW;/**--------------------------------------  36 - 39 byte */
  /** MW */
  tU32  u32LowMW;/**---------------------------------------  22 - 25 byte */
  tU32  u32HighMW;/**--------------------------------------  26 - 29 byte */
  /** Available Band **/
  tU32  u32Available_band;/**--------------------------------------153 - 156 byte */

  tunmstr_trKdsFmAmTunerParameter( tVoid );

  virtual tVoid vSetToDefaultValues( tVoid);
  virtual tVoid vParse( tPU8 pu8KdsBuffer, tU32 u32Length);
  virtual tVoid vTrace( tVoid);
};

typedef enum
{
   enKdsCMVariantCoding_idx_HWAssemblyInfo3          =   15, enKdsCMVariantCoding_len_HWAssemblyInfo3          =   1,
}tenKdsCMVariantCodingParameters;

struct tunmstr_trKdsCMVariantCodingParameter:public tunmstr_trKds
{
   tU8 u8HWAssemblyInfo3;
   tBool m_blDABAvail;
   tBool m_bIs3FrontEndTuner;

   tunmstr_trKdsCMVariantCodingParameter( tVoid );

   virtual tVoid vSetToDefaultValues( tVoid);
   virtual tVoid vParse( tPU8 pu8KdsBuffer, tU32 u32Length);
   virtual tVoid vTrace( tVoid);
};

typedef enum
{

  enKdsGenericTunerParameter_idx_InitialAutoStoreListId				=  11, enKdsGenericTunerParameter_len_InitialAutoStoreListId				=   4,
  enKdsGenericTunerParameter_idx_BandToTuneAfterInitialAutostore		=  22, enKdsGenericTunerParameter_len_BandToTuneAfterInitialAutostore    =   1,
  enKdsGenericTunerParameter_idx_StationToTuneAfterUserAutostore		=  23, enKdsGenericTunerParameter_len_StationToTuneAfterUserAutostore       =   1,

  enKdsGenericTunerParameter_idx_MonitorFM_TA						=  54, enKdsGenericTunerParameter_len_MonitorFM_TA						=   1,
  enKdsGenericTunerParameter_idx_AudioTunerFM_TPSeek					=  55, enKdsGenericTunerParameter_len_AudioTunerFM_TPSeek				=   1,
  enKdsGenericTunerParameter_idx_AnnouncementRequestHandling			=  56, enKdsGenericTunerParameter_len_AnnouncementRequestHandling		=   1,
  enKdsGenericTunerParameter_idx_BackgroundFM_TA						=  62, enKdsGenericTunerParameter_len_BackgroundFM_TA					=   1,
  enKdsGenericTunerParameter_idx_TraficAnnoInOtherSrc                =  63, enKdsGenericTunerParameter_len_TraficAnnoInOtherSrc               =   1,
  enKdsGenericTunerParameter_idx_AnnouncementPrio_FM_TA				=  64, enKdsGenericTunerParameter_len_AnnouncementPrio_FM_TA				=   1,
  enKdsGenericTunerParameter_idx_AnnouncementPrio_FM_PTY31           =  65, enKdsGenericTunerParameter_len_AnnouncementPrio_FM_PTY31          =   1,
  enKdsGenericTunerParameter_idx_AnnouncementPrio_FM_NEWS			=  66, enKdsGenericTunerParameter_len_AnnouncementPrio_FM_NEWS			=   1,
  enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_Alarm			=  67, enKdsGenericTunerParameter_len_AnnouncementPrio_DAB_Alarm			=   1,
  enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_RoadTrafficFlash  =  68, enKdsGenericTunerParameter_len_AnnouncementPrio_DAB_RoadTrafficFlash =   1,
  enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_TransportFlash =  69, enKdsGenericTunerParameter_len_AnnouncementPrio_DAB_TransportFlash =   1,
  enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_WarningService =  70, enKdsGenericTunerParameter_len_AnnouncementPrio_DAB_WarningService =   1,


  enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_NewsFlash		=  71, enKdsGenericTunerParameter_len_AnnouncementPrio_DAB_NewsFlash		=   1,
  enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_AreaWeatherFlash  =  72, enKdsGenericTunerParameter_len_AnnouncementPrio_DAB_AreaWeatherFlash  =   1,
  enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_EventAnnouncement =  73, enKdsGenericTunerParameter_len_AnnouncementPrio_DAB_EventAnnouncement =   1,
  enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_SpecialEvent	=  74, enKdsGenericTunerParameter_len_AnnouncementPrio_DAB_SpecialEvent	=   1,
  enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_ProgramInfo	=  75, enKdsGenericTunerParameter_len_AnnouncementPrio_DAB_ProgramInfo	=   1,

  enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_SportReport	=  76, enKdsGenericTunerParameter_len_AnnouncementPrio_DAB_SportReport	=   1,
  enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_FinancialReport  =  77, enKdsGenericTunerParameter_len_AnnouncementPrio_DAB_FinancialReport  =   1,
  enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_reserved1		=  78, enKdsGenericTunerParameter_len_AnnouncementPrio_DAB_reserved1		=   1,
  enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_reserved2		=  79, enKdsGenericTunerParameter_len_AnnouncementPrio_DAB_reserved2		=   1,
  enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_reserved3		=  80, enKdsGenericTunerParameter_len_AnnouncementPrio_DAB_reserved3		=   1,
  enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_reserved4		=  81, enKdsGenericTunerParameter_len_AnnouncementPrio_DAB_reserved4		=   1,
  enKdsGenericTunerParameter_idx_AnnouncementPrio_DAB_reserved5		=  82, enKdsGenericTunerParameter_len_AnnouncementPrio_DAB_reserved5		=   1,

  enKdsGenericTunerParameter_idx_PresetListType						=  134, enKdsGenericTunerParameter_len_PresetListType					=   1,
  enKdsGenericTunerParameter_idx_NumberOfPresetsPerBankFM           =  137, enKdsGenericTunerParameter_len_NumberOfPresetsPerBankFM			=   1,
  enKdsGenericTunerParameter_idx_NumberOfPresetsPerBankMW			=  141, enKdsGenericTunerParameter_len_NumberOfPresetsPerBankMW			=   1,
  enKdsGenericTunerParameter_idx_NumberOfPresetsPerBankLW			=  145, enKdsGenericTunerParameter_len_NumberOfPresetsPerBankLW		=   1,
  enKdsGenericTunerParameter_idx_NumberOfPresetsPerBankMixed1			=  153, enKdsGenericTunerParameter_len_NumberOfPresetsPerBankMixed1		=   1
} tenKdsGenericTunerParameter;

struct tunmstr_trKdsGenericTunerParameter: public tunmstr_trKds
{

  tU32  u32InitialAutoStoreListId;/**----------------------  11 - 14 byte */

  tU8   u8BandToTuneAfterInitialAutostore;/**--------------  22nd byte */
  tU8   u8StationToTuneAfterUserAutostore;/**-----------------  23rd byte */

  tU8   u8MonitorFM_TA;/**---------------------------------  54th byte */
  tU8   u8AudioTunerFM_TPSeek;/**--------------------------  55th byte */
  tU8   u8AnnouncementRequestHandling;/**------------------  56th byte */
  tU8   u8BackgroundFM_TA;/**------------------------------  62nd byte */
  tU8   u8TraficAnnoInOtherSrc;/**-------------------------  63rd byte */

  tU8   u8AnnouncementPrio_FM_TA;/**-----------------------  64th byte */
  tU8   u8AnnouncementPrio_FM_PTY31;/**--------------------  65th byte */
  tU8   u8AnnouncementPrio_FM_NEWS;/**---------------------  66th byte */
  tU8   u8AnnouncementPrio_DAB_Alarm;/**-------------------  67th byte */
  tU8   u8AnnouncementPrio_DAB_RoadTrafficFlash;/**--------  68th byte */
  tU8   u8AnnouncementPrio_DAB_TransportFlash;/**----------  69th byte */
  tU8   u8AnnouncementPrio_DAB_WarningService;/**----------  70th byte */
  tU8   u8AnnouncementPrio_DAB_NewsFlash;/**---------------  71st byte */
  tU8   u8AnnouncementPrio_DAB_AreaWeatherFlash;/**--------  72nd byte */
  tU8   u8AnnouncementPrio_DAB_EventAnnouncement;/**-------  73rd byte */
  tU8   u8AnnouncementPrio_DAB_SpecialEvent;/**------------  74th byte */
  tU8   u8AnnouncementPrio_DAB_ProgramInfo;/**-------------  75th byte */
  tU8   u8AnnouncementPrio_DAB_SportReport;/**-------------  76th byte */
  tU8   u8AnnouncementPrio_DAB_FinancialReport;/**---------  77th byte */
  tU8   u8AnnouncementPrio_DAB_reserved1;/**---------------  78th byte */
  tU8   u8AnnouncementPrio_DAB_reserved2;/**---------------  79th byte */
  tU8   u8AnnouncementPrio_DAB_reserved3;/**---------------  80th byte */
  tU8   u8AnnouncementPrio_DAB_reserved4;/**---------------  81st byte */
  tU8   u8AnnouncementPrio_DAB_reserved5;/**---------------  82nd byte */

  tU8   u8PresetListType;/**-------------------------------  134th byte */

  tU8 	u8NumberOfPresetsPerBankFM;/**-------------------------------  137th byte */
  tU8 	u8NumberOfPresetsPerBankMW;/**-------------------------------  141th byte */
  tU8 	u8NumberOfPresetsPerBankLW;/**-------------------------------  145th byte */
  /*KDS for DRM is not yet available*/
  tU8 	u8NumberOfPresetsPerBankDRM;
  tU8 	u8NumberOfPresetsPerBankMixed1;

  tunmstr_trKdsGenericTunerParameter( tVoid);
  virtual tVoid vSetToDefaultValues( tVoid);
  virtual tVoid vParse( tPU8 pu8KdsBuffer, tU32 u32Length);
  virtual tVoid vTrace( tVoid);
};

#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
typedef enum
{
	enKdsEOLParameter_idx_EOL_Config_Radio		=   3, enKdsEOLParameter_len_EOL_Config_Radio						=   1
}tenKdsEOLParameter;

struct tunmstr_trKdsEOLParameter
{

	tU8  u8AMAvailable;     		/*Byte 3 and bit 4*/
	tU8  u8CountryCode;				/*BYTE3 and  BIT 5-7*/
	tU8 u8FM1AntennaType,u8FM2AntennaType;

	tunmstr_trKdsEOLParameter( tVoid);

	tVoid vSetToDefaultValues( tVoid);
	tVoid vParse( tVoid );
	tVoid vTrace( tVoid);

	tU8  u8GetAMAvail() const;
};
#endif

class clConfigInterface;
class tunmaster_Config : public clTunerConfigInterface
{
public:
  /* Constructor */
  tunmaster_Config( );

  /* Destructors */
  ~tunmaster_Config( );

	typedef std::map<tU16, tU8> mapAnnoPrio;
	mapAnnoPrio m_mapAnnoPrioVal;

	virtual void vConfigDone();
	  tVoid vUpdateAnnoPrio();

   //Configuration function for various KDS parameters
  tVoid vReadKDSCMVariantCoding();
	tVoid vReadKDSConfig_DABConfig(tU8 u8KDSParameter);
  tBool fGetTunerMasterAvailability() const;
  tU8 fGetTMC_Server() const;
  tBool fGetLandscapeFlag() const;
  tVoid vUpDateMemeberVar(tU8 i,tU16 u16ReadKDSData);

  tU8 u8ReadTMCServerFromKDS()const;
  tU8 u8ReadLandScapeFlag()const;
  tU8 u8ReadDABAvail()const;
  //tU16 u16GetAntennaCurrentLevel(tPU8 pu8AntennaCurrentLevel)const;
  tVoid vSet_tunmstr_tunmstr_Preset_Handler_Ptr(tunmstr_Preset_Handler* potunmstr_Preset_Handler);
  tVoid vSet_tunmstr_AudioClientHandler_Ptr(
			tunmstr_AudioClientHandler* potunmstr_AudioClientHandler);
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
  tVoid vSet_tunmstr__ArlSourceImplPtr(tuner::sessionManagement::audio::clArlSourceImpl* poArlSourceImpl);
  tVoid vSendSourceAvailabilityAfterConfigDone();
#endif
#ifdef  VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
tVoid vSet_tunmstr__AnnouncementControlImplPtr( tuner::announcements::clAnnouncementControl* poAnnouncementControl);
#endif
  tVoid vSet_tunmstr_ConfigInterface_Ptr(clConfigInterface* poclConfigInterface);
  tBool blGetTempDABAVail_Info() const;
  tVoid vSettunmstr_antdiag_Manager( tunmstr_antdiag_Manager* potunmstr_antdiag_Manager);
  tVoid vSet_tunmstr_DiaglibListner_Ptr( tunmstr_DiaglibListner* potunmstr_DiaglibListner);
  //tVoid vReadAntennaExtSupInfo(tU8 u8Buffer[])const;
  //tVoid vReadAntennaParameter(tU8 u8Buffer[]);
  tVoid vReadKDSConfig_AMFMParamters();
  tVoid vReadKDSGenericTunerParameterSet();
  tVoid vReadKDSCMVariantCodingParameter();
  tVoid vReadKDSVariantCodingPSAParameters();
  tVoid vReadKDSSystemInfoCommonIVIParameters();
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
  tVoid vReadKDSEOLParameters();
#endif

  tU32 u32GetMinFrqFM( tVoid) const                 { return m_rKdsFmAmTunerParameter.u32LowFM; }
  tU32 u32GetMaxFrqFM( tVoid) const                 { return m_rKdsFmAmTunerParameter.u32HighFM; }
  tU32 u32GetMinFrqLW( tVoid) const                 { return m_rKdsFmAmTunerParameter.u32LowLW; }
  tU32 u32GetMaxFrqLW( tVoid) const                 { return m_rKdsFmAmTunerParameter.u32HighLW; }
  tU32 u32GetMinFrqMW( tVoid) const                 { return m_rKdsFmAmTunerParameter.u32LowMW; }
  tU32 u32GetMaxFrqMW( tVoid) const                 { return m_rKdsFmAmTunerParameter.u32HighMW; }
  tU32 u32GetAvailableBand( tVoid) const                 { return m_rKdsFmAmTunerParameter.u32Available_band; }




  tU32  u32GetInitialAutoStoreListID( tVoid) const                  			{ return m_rKdsGenericTunerParameter.u32InitialAutoStoreListId; }
  tU8   u8GetBandToTuneAfterInitialAutostore( tVoid) const       				{ return m_rKdsGenericTunerParameter.u8BandToTuneAfterInitialAutostore; }
  tU8   u8GetStationToTuneAfterUserAutostore( tVoid) const          			{ return m_rKdsGenericTunerParameter.u8StationToTuneAfterUserAutostore; }
  tU8   u8GetMonitorFM_TA( tVoid) const                          				{ return m_rKdsGenericTunerParameter.u8MonitorFM_TA; }
  tU8   u8GetAudioTunerFM_TPSeek( tVoid) const                   				{ return m_rKdsGenericTunerParameter.u8AudioTunerFM_TPSeek; }
  tU8   u8GetAnnouncementRequestHandling( tVoid) const           				{ return m_rKdsGenericTunerParameter.u8AnnouncementRequestHandling; }
  tU8   u8GetBackgroundFM_TA( tVoid) const                       				{ return m_rKdsGenericTunerParameter.u8BackgroundFM_TA; }
  tU8   u8GetTraficAnnoInOtherSrc( tVoid) const                  				{ return m_rKdsGenericTunerParameter.u8TraficAnnoInOtherSrc; }
  tU8   u8GetAnnouncementPrio_FM_TA( tVoid) const 			 				    { return m_rKdsGenericTunerParameter.u8AnnouncementPrio_FM_TA; }
  tU8   u8GetAnnouncementPrio_FM_PTY31( tVoid) const 			 				{ return m_rKdsGenericTunerParameter.u8AnnouncementPrio_FM_PTY31; }
  tU8   u8GetAnnouncementPrio_FM_NEWS( tVoid) const 			 				{ return m_rKdsGenericTunerParameter.u8AnnouncementPrio_FM_NEWS; }
  tU8   u8GetAnnouncementPrio_DAB_Alarm( tVoid) const 		 					{ return m_rKdsGenericTunerParameter.u8AnnouncementPrio_DAB_Alarm; }
  tU8   u8GetAnnouncementPrio_DAB_RoadTrafficFlash( tVoid) const 		 		{ return m_rKdsGenericTunerParameter.u8AnnouncementPrio_DAB_RoadTrafficFlash; }
  tU8   u8GetAnnouncementPrio_DAB_TransportFlash( tVoid) const 		 			{ return m_rKdsGenericTunerParameter.u8AnnouncementPrio_DAB_TransportFlash; }
  tU8   u8GetAnnouncementPrio_DAB_WarningService( tVoid) const 		 		    { return m_rKdsGenericTunerParameter.u8AnnouncementPrio_DAB_WarningService; }
  tU8   u8GetAnnouncementPrio_DAB_NewsFlash( tVoid) const 		 		    	{ return m_rKdsGenericTunerParameter.u8AnnouncementPrio_DAB_NewsFlash; }
  tU8   u8GetAnnouncementPrio_DAB_AreaWeatherFlash( tVoid) const 		 		{ return m_rKdsGenericTunerParameter.u8AnnouncementPrio_DAB_AreaWeatherFlash; }
  tU8   u8GetAnnouncementPrio_DAB_EventAnnouncement( tVoid) const 		 		{ return m_rKdsGenericTunerParameter.u8AnnouncementPrio_DAB_EventAnnouncement; }
  tU8   u8GetAnnouncementPrio_DAB_SpecialEvent( tVoid) const 		 		    { return m_rKdsGenericTunerParameter.u8AnnouncementPrio_DAB_SpecialEvent; }
  tU8   u8GetAnnouncementPrio_DAB_ProgramInfo( tVoid) const 		 		    { return m_rKdsGenericTunerParameter.u8AnnouncementPrio_DAB_ProgramInfo; }
  tU8   u8GetAnnouncementPrio_DAB_SportReport( tVoid) const 		 		    { return m_rKdsGenericTunerParameter.u8AnnouncementPrio_DAB_SportReport; }
  tU8   u8GetAnnouncementPrio_DAB_FinancialReport( tVoid) const 		 		{ return m_rKdsGenericTunerParameter.u8AnnouncementPrio_DAB_FinancialReport; }
  tU8   u8GetPresetListType( tVoid) const 		 								{ return m_rKdsGenericTunerParameter.u8PresetListType; }
  tU8   u8GetNumberOfPresetsPerBankFM( tVoid) const                             { return m_rKdsGenericTunerParameter.u8NumberOfPresetsPerBankFM; }
  tU8   u8GetNumberOfPresetsPerBankMW( tVoid) const                             { return m_rKdsGenericTunerParameter.u8NumberOfPresetsPerBankMW; }
  tU8   u8GetNumberOfPresetsPerBankLW( tVoid) const                             { return m_rKdsGenericTunerParameter.u8NumberOfPresetsPerBankLW; }
  tU8   u8GetNumberOfPresetsPerBankDRM( tVoid) const                             { return m_rKdsGenericTunerParameter.u8NumberOfPresetsPerBankDRM; }
  tU8   u8GetNumberOfPresetsPerBankMixed1( tVoid) const                             { return m_rKdsGenericTunerParameter.u8NumberOfPresetsPerBankMixed1; }
  tU16 u16GetAnnoPrio(tU16 u16AnnoType);
  tU8 bIsDRMSupported() const;
  tBool bIsDABSupported() const;
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
  tunmstr_trKdsFmAmTunerParameter stGetAMFMParameter()const;
  tU8  	u8GetAMAvailable(tVoid) const											{ return m_rKdsEOLParameter.u8AMAvailable; }
  tU8   u8GetCountryCode(tVoid) const											{ return m_rKdsEOLParameter.u8CountryCode; }
  tVoid vUpdateAvailableBandsAccording2EOL();
  tVoid vUpdateFrequencyFromEOL();
	tU8 u8GetAntennaType(tU8 Client);
#endif

private:
  
  tBool    m_fLandscapeSeekNeeded;
  tU8 m_fTMC_Server;
  tunmstr_Preset_Handler* m_potunmstr_Preset_Handler;
  tunmstr_antdiag_Manager* m_potunmstr_antdiag_Manager;
  tunmstr_DiaglibListner* m_potunmstr_DiaglibListner;
  tunmstr_AudioClientHandler* m_potunmstr_AudioClientHandler;
  clConfigInterface* m_poclConfigInterface;
#ifdef VARIANT_S_FTR_ENABLE_SRCCHANGE_LIB
  tuner::sessionManagement::audio::clArlSourceImpl*	m_poArlSourceImpl;
#endif
#ifdef VARIANT_S_FTR_ENABLE_ANNOUNCEMENT_LIB
  tuner::announcements::clAnnouncementControl* m_poAnnouncementControl;
#endif

  tunmstr_trKdsFmAmTunerParameter      m_rKdsFmAmTunerParameter;
  tunmstr_trKdsGenericTunerParameter   m_rKdsGenericTunerParameter;
  tunmstr_trKdsCMVariantCodingParameter m_rKdsCMVariantCodingParameter;
#ifdef VARIANT_S_FTR_ENABLE_FEATURE_PSA_RCC
  tunmstr_trKdsEOLParameter m_rKdsEOLParameter;
#endif

  tS32 s32ReadKDS(OSAL_tIODescriptor IOKdsHandle, tU8* u8Buf, tU16 u16KdsKey, tU16 u16Len) const;

};

#endif /* tunmaster_Config_H */
