
 /************************************************************************
* FILE:           tunmstr_antdiag_i2cHandler.h
* PROJECT:        G3g
* SW-COMPONENT:   fc_tunermaster
*----------------------------------------------------------------------
*
* DESCRIPTION:    Handler Class for I2C communication 
*
*----------------------------------------------------------------------
* COPYRIGHT: (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date        | Author							         | Modification
* 13-12-2013  | RBEI/ECV3 Priya Prabhuswamy(rrb1kor)     | Initial version.

*************************************************************************/

#ifndef tunmstr_antdiag_i2cHandler_H
#define tunmstr_antdiag_i2cHandler_H
#include <stdio.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/ioctl.h>
#include <linux/i2c-dev.h>
#include <linux/i2c.h>

#ifdef VARIANT_S_FTR_ENABLE_GENERICMSGS_MOCK
#include "amt_mock/amt_if.h"
#include "ahl_mock/ahl_if.h"
#else
#define GENERICMSGS_S_IMPORT_INTERFACE_GENERIC
#include "generic_msgs_if.h"
#endif

#ifndef _TUNMSTR_ANTDIAG_DEFINES_H
#include  "tunmstr_antdiag_Defines.h"
#endif

//Timer
#define OSAL_S_IMPORT_INTERFACE_GENERIC
#include "osal_if.h"
class tunmstr_DiagLogClientHandler;
class tunmstr_antdiag_Measure;
class tunmstr_antdiag_Manager;
class tunmstr_antdiag_Debounce;
class tunmstr_MsgFromHMI;
class tunmstr_antdiag_i2cHandler
{
private:
		tunmstr_antdiag_Measure *m_potunmstr_antdiag_Measure;
		tunmstr_antdiag_Manager *m_potunmstr_antdiag_Manager;
		tunmstr_antdiag_Debounce* m_potunmstr_antdiag_Debounce;
		tunmstr_DiagLogClientHandler* m_potunmstr_DiagLogClientHandler;
		tunmstr_MsgFromHMI* m_potunmstr_MsgFromHMI;
		
		tBool m_blOutputA1Enabled[enELMOSIcIndex];
		tBool m_blOutputA2Enabled[enELMOSIcIndex];

		tBool m_blMax20084OutputA1En[enMAX20084IcIndex];
		tBool m_blMax20084OutputA2En[enMAX20084IcIndex];
		tBool m_blDummyI2CHalfReadCompleted;

public:
		tunmstr_antdiag_i2cHandler();
		virtual ~tunmstr_antdiag_i2cHandler( );
		tVoid vHandleTTFiS_CMD(const tU8* u8DataSpecial);
		
		tVoid vSet_tunmstr_antdiag_Measure_Ptr(tunmstr_antdiag_Measure* potunmstr_antdiag_Measure);
		tVoid vSet_tunmstr_antdiag_Manager_Ptr(tunmstr_antdiag_Manager* potunmstr_antdiag_Manager);
		tVoid vSet_tunmstr_antdiag_Debounce_Ptr( tunmstr_antdiag_Debounce* potunmstr_antdiag_Debounce );
		tVoid vSet_tunmstr_DiagLogClientHandler_Ptr(tunmstr_DiagLogClientHandler* potunmstr_DiagLogClientHandler);
		tVoid vSet_tunmstr_MsgFromHMI_Ptr(tunmstr_MsgFromHMI* potunmstr_MsgFromHMI );
		
		/*functions related to ELMOS*/
		tBool blWriteELMOSStatusReg(tenCMExtPowerSupplyType enCMExtPowerSupplyType);//utest
		tVoid vWriteOverCurrentReg(tenCMExtPowerSupplyType enCMExtPowerSupplyType,tU16 u16data);//utest
		#ifdef VARIANT_S_FTR_ENABLE_FEATURE_RNAIVI
		tVoid vWriteSupplyOverVoltageReg(tenCMExtPowerSupplyType enCMExtPowerSupplyType);
		#endif
		trI2CReadCurrent trReadELMOSCurrent(tenCMExtPowerSupplyType enCMExtPowerSupplyType);//utest
		tVoid vReadELMOSCurrent(tenCMExtPowerSupplyType enCMExtPowerSupplyType,tenAntDiagClients enAntDiagClients); //utest
		tenELMOSPowerICIndex enGetELMOSIC_Index(tenCMExtPowerSupplyType enCMExtPowerSupplyType);//utest
		tVoid vReadELMOSCurrentReg( tenCMExtPowerSupplyType enCMExtPowerSupplyType);//utest
		tVoid vReadELMOSA2CurrentReg(tenCMExtPowerSupplyType enCMExtPowerSupplyType);//utest
		tVoid vReadELMOSA1CurrentReg(tenCMExtPowerSupplyType enCMExtPowerSupplyType);//utest
		tVoid vInitialiseElmosRegisters(tenCMExtPowerSupplyType enCMExtPowerSupplyType);// no utest 
		//function is involking the same class function invloked function always return false as I2C write fails

		/*Function related to Max20084 */
		tenMAX20084IcIndex enGetMax20084IC_Index(tenCMExtPowerSupplyType enCMExtPowerSupplyType);//utest
		tenMax20084ICReg enGetMax20084IC_OutVgRegAddr(tenCMExtPowerSupplyType enCMExtPowerSupplyType);//utest
		tU8 u8GetMax20084OutVgValue(tenCMExtPowerSupplyType enCMExtPowerSupplyType, tBool blTurnOn= true)const;// no utest 
		tVoid vInitialiseMax20084Rg(tenCMExtPowerSupplyType enCMExtPowerSupplyType);// no utest 
		//function is involking the same class function invloked function 
		tVoid vReadMax20084Current(tenCMExtPowerSupplyType enCMExtPowerSupplyType,tenAntDiagClients enAntDiagClients);//utest
		tVoid vReadMax20084OutPutIReg(tenCMExtPowerSupplyType enCMExtPowerSupplyType);//utest
		tU8 u8GetMax20084WarCur(tenCMExtPowerSupplyType enCMExtPowerSupplyType);//utest
		tU8 u8GetMax20084OverCurNdOpenLoadCur(tenCMExtPowerSupplyType enCMExtPowerSupplyType);//utest
		tU8 u8GetMax20084OutVg(tenCMExtPowerSupplyType enCMExtPowerSupplyType);//utest
		tU8 u8GetMax20084LimCur(tenCMExtPowerSupplyType enCMExtPowerSupplyType,tU16 u16Val = TUNMSTR_ANTDIAG_MAX20084_LIMI_DEFAULT);//utest
		tBool blEnableMAX20084Output(tenCMExtPowerSupplyType enCMExtPowerSupplyType);//utest
		tBool blMAX20084ClearErrorLatch(tenCMExtPowerSupplyType enCMExtPowerSupplyType);
		tU8 u8GetMAX20084ErrorLatchMaskVal(tenCMExtPowerSupplyType enCMExtPowerSupplyType);
		/*common functions*/
		tVoid vSetOutputEnabled(tenCMExtPowerSupplyType enCMExtPowerSupplyType,tBool blValue);//utest
		tBool blWriteReg(tU8 u8RegAdd,tU16 u16data,tenCMExtPowerSupplyType enCMExtPowerSupplyType);//no utest, function includes i2c write
		tBool IsOutputPinIsEnabled(tenCMExtPowerSupplyType enCMExtPowerSupplyType);//utest
		trI2CRead trReadI2CReg(tU8 u8Register,tenCMExtPowerSupplyType enCMExtPowerSupplyType);//no utest, function includes i2c read

		tBool IsShortCktError(tenCMExtPowerSupplyType enCMExtPowerSupplyType);//no utest, i2c read always fails, hence only test case can be written for false case always
		tVoid vClearAllInternalState();//no utest, no logic
		tU8 u8GetICAddress(tenCMExtPowerSupplyType enCMExtPowerSupplyType);//utest

		tBool blTurnOnUsingGPIORegister(tU8 u8RegisterAddress,tU8 u8SlaveAddress, tU8 u8MaskVal);//no utest, function includes i2c write
		tBool blTurnOffUsingGPIORegister(tU8 u8RegisterAddress,tU8 u8SlaveAddress, tU8 u8MaskVal);//no utest, function includes i2c write
		tBool blEnableOutput(tenCMExtPowerSupplyType enCMExtPowerSupplyType); //function is involking the same class function, test cases can be written only for false case
		tVoid vDummyI2CHalfRead();
};
#endif
