
/************************************************************************
 * FILE:           tunmstr_antdiag_Measure.h
 * PROJECT:        G3g
 * SW-COMPONENT:   FC_TunerMaster.
 *----------------------------------------------------------------------
 *
 * DESCRIPTION:    This class will handle source change logic functionalty.
 * 
 *----------------------------------------------------------------------
* COPYRIGHT: (C) 2016 Robert Bosch Engineering and Business Solutions Private Limited.
*              The reproduction, distribution and utilization of this file as
*              well as the communication of its contents to others without express
*              authorization is prohibited. Offenders will be held liable for the
*              payment of damages. All rights reserved in the event of the grant
*              of a patent, utility model or design.
*----------------------------------------------------------------------
* HISTORY:
* Date        | Author							   | Modification
* 25/05/2012  | ECV4 ( RBEI ) Priya Prabhuswamy    | Initial version.
* 25.04.13    | NGP1KOR                            | First version of the G3g after porting from NISSAN LCN2Kai.
				
 *************************************************************************/

#ifndef tunmstr_antdiag_Measure_H
#define tunmstr_antdiag_Measure_H

#ifndef _TUNMSTR_ANTDIAG_DEFINES_H
#include "tunmstr_antdiag_Defines.h"
#endif
const tFloat TUNMSTR_ANTDIAG_DAB_ADC_SAMPLE_MINUS_VAL					= (tFloat)0.4;
const tFloat TUNMSTR_ANTDIAG_DAB_CURRENT_CAL_REDUCTION_FACT			    = (tFloat)1023;
const tFloat TUNMSTR_ANTDIAG_VADC_MUL_FACTOR							= (tFloat)0.00080586;
const tFloat TUNMSTR_ANTDIAG_INFINEON_SUZ_VREF							= (tFloat)44.5;
const tFloat TUNMSTR_ANTDIAG_INFINEON_OTHER_VREF						= (tFloat)58.1;
const tFloat TUNMSTR_ANTDIAG_MAX_MY16_RSENSE							= (tFloat)0.91;
#define TUNMSTR_ANTDIAG_MAX_MY16_AOUT_GAIN								26
#define TUNMSTR_ANTDIAG_TENBIT_VALUE									1023 //2^10-1
const tFloat TUNMSTR_ANTDIAG_MAX_MY16_VREF								=3300.0;
#define TUNMSTR_ANTDIAG_MAX_MY16_SUB_FACTOR								400
const tFloat TUNMSTR_ANTDIAG_INFINEON1_DAB_VREF							= (tFloat)46.95;
const tFloat TUNMSTR_ANTDIAG_INFINEON_PSA_VREF							=44.5;
const tFloat TUNMSTR_ANTDIAG_INFINEON2_GPS_VREF							=25.0;
const tU16 TUNMSTR_ANTDIAG_12BIT_VALUE									=4095;////2^12-1
const tFloat TUNMSTR_ANTDIAG_TPS7B7702_VREF					            = (tFloat)1.233;
const tU8 TUNMSTR_ANTDIAG_TPS7B7702_OUTI_TO_ISENSE_RATIO				=198;
const tFloat TUNMSTR_ANTDIAG_TPS7B7702_FM1_RLIM							=(tFloat)0.27;
const tFloat TUNMSTR_ANTDIAG_TPS7B7702_GPS_RLIM							=(tFloat)0.82;
/*--------------------------------*/
/* class tunmstr_antdiag_Debounce definition */ 
/*--------------------------------*/
class tunmstr_antdiag_Debounce;
class tunmstr_antdiag_Manager;
class tunmstr_DiagLogClientHandler;
class tunmstr_antdiag_Measure
{
private:
	// add private memeber variables
	tunmstr_antdiag_Debounce*		m_potunmstr_antdiag_Debounce;
	tunmstr_antdiag_Manager*        m_potunmstr_antdiag_Manager;
	tunmstr_DiagLogClientHandler* m_potunmstr_DiagLogClientHandler;
	
	OSAL_tIODescriptor m_hInfineonIOHandler;
	OSAL_tIODescriptor m_hInfineon2IOHandler;
	OSAL_tIODescriptor m_hMAXIOHandler;
	OSAL_tIODescriptor m_hTPS7B7701_IOHandler;
	OSAL_tIODescriptor m_hTPS7B7702_1_1IOHandler;
	OSAL_tIODescriptor m_hTPS7B7702_1_2IOHandler;
	
	tBool m_blnfineonADCChannel;
	tBool m_blnfineon2ADCChannel;
	tBool m_bMAXADCChannel;
	tBool m_blTPS7B7701ADCChannelOPen;
	tBool m_blTPS7B7702_1_1ADCChannelOpen;
	tBool m_blTPS7B7702_1_2ADCChannelOpen;
	
	tFloat m_flnfineon_Cur;
	tFloat m_flnfineon2_Cur;
	tFloat m_fMax_Cur;
	tFloat m_fELMOS1_1Cur;
	tFloat m_fELMOS1_2Cur;
	tFloat m_fELMOS2_1Cur;
	tFloat m_fELMOS2_2Cur;
	tFloat m_fMaxIC_CalculatedCur;
	tFloat m_fELMOS3_1Cur;
	tFloat m_fELMOS3_2Cur;
	tFloat m_fELMOS4_1Cur;
	tFloat m_fELMOS4_2Cur;
	tFloat m_fTPS7B7701_Cur;
	tFloat m_fTPS7B7702_1_1Cur;
	tFloat m_fTPS7B7702_1_2Cur;
	tFloat m_fMAX20084_1_1_Cur;
	tFloat m_fMAX20084_1_2_Cur;
	tFloat m_fMAX20084_2_1_Cur;
	tFloat m_fMAX20084_2_2_Cur;
	tFloat m_fMAX20084_3_1_Cur;
	tFloat m_fMAX20084_3_2_Cur;
public:
	tunmstr_antdiag_Measure(); 
	tVoid vSet_tunmstr_antdiag_Debounce_Ptr( tunmstr_antdiag_Debounce* potunmstr_antdiag_Debounce );
	tVoid vSet_tunmstr_antdiag_Manager( tunmstr_antdiag_Manager* potunmstr_antdiag_Manager );
	tVoid vSet_tunmstr_DiagLogClientHandler_Ptr(tunmstr_DiagLogClientHandler* potunmstr_DiagLogClientHandler);


	tVoid vCloseMAXADCChannel();//utest
	tVoid vCloselnfineonADCChannel();//utest
	tVoid vCloselnfineon2ADCChannel();//utest
	tVoid vCloseTPS7B7701ADCChannel();//utest
	tVoid vCloseTPS7B7702_1_1ADCChannel();//utest
	tVoid vCloseTPS7B7702_1_2ADCChannel();//utest
	
	tVoid vOpenlnfineonADCChannel();//utest
	tVoid vOpenlnfineon2ADCChannel();//utest
	tVoid vOpenMAXADCChannel();//utest
	tVoid vOpenTPS7B7701ADCChannel();//utest
	tVoid vOpenTPS7B7702_1_1ADCChannel();//utest
	tVoid vOpenTPS7B7702_1_2ADCChannel();//utest

	//Function to cal to current
	tFloat fCalculateInfineonCurrent(tU16 u16adcSample)const;//utest
	tFloat fCalculateInfineon2Current(tU16 u16adcSample)const;//utest
	tFloat fCalculateTPS7B7701Current(tU16 u16adcSample)const;
	tFloat fCalculateTPS7B7702_1_1Current(tU16 u16adcSample,tenAntDiagClients enAntDiagClients);//utest
	tFloat fCalculateTPS7B7702_1_2Current(tU16 u16adcSample,tenAntDiagClients enAntDiagClients);//utest
	//Function to read adc sample
	tVoid vReadInfineonIC_ADCVal();//utest
	tVoid vReadInfineon2IC_ADCVal();//utest
	tVoid vReadMAXIC_ADCVal();//utest
	tVoid vReadTPS7B7701_ADCVal();
	tVoid vReadTPS7B7702_1_1ADCVal(tenAntDiagClients enAntDiagClients);
	tVoid vReadTPS7B7702_1_2ADCVal(tenAntDiagClients enAntDiagClients);
	/*NFLT pin state is not required to identify the antenna status,
	may be during issue debug, it might be required*/
	//tBool blReadTPS7B7702_1_1_NFLTPinState(); 
	
	tFloat fCalculateMaxICCurrent(tU16 u16adcSample);//no utest, used in GM project filter
	tenMaxICGPIOPinState enReadMaxICShortGPIOPinState()const;//utest
	tenMaxICGPIOPinState enReadMaxICOpenGPIOPinState()const;//utest
	tenMaxICGPIOPinState enFindMaxICGPIOPinState(tFloat fCurrent);//no utest, function invoke the same class function
	tFloat fGetMaxIC_CalculatedCur();//no utest, getter funtion 
	tFloat fGetTPS7B7702RLIM(tenAntDiagClients enAntDiagClients);//utest
	
	tVoid vUpdateAntennaStatus(tenCMExtPowerSupplyType enCMExtPowerSupplyType, tU8 u8RegAddr);
	tBool IsShortCkt_TimeOver(tenCMExtPowerSupplyType enCMExtPowerSupplyType)const;
	tVoid vUpdateAntennaCur(tenCMExtPowerSupplyType enCMExtPowerSupplyType,tFloat fCurrent);
	tVoid vClearAllInternalState();//no utest
	virtual	~tunmstr_antdiag_Measure( );

};
#endif 
